#!/usr/bin/perl

use strict;
use warnings;
no  warnings 'syntax';

use lib ".";

use Regexp::Common;
use Test::More;
use t::zip::Zip;

my $r = eval "require Test::Regexp; 1";

unless ($r) {
    print "1..0 # SKIP Test::Regexp not found\n";
    exit;
}


test_zips country         =>  "Denmark",
          name            =>  "Danish zip codes",
          prefix          => {
              iso         =>  "DK",
              cept        =>  "DK",
              invalid     =>  "DE",
          },
          prefix_test_set => [5550, 7100],
;


done_testing;


sub valid_zip_codes {
    map {sprintf "%04d" => $_}

     800,    900,    917,    960,    999 .. 1000,

    1050 .. 1074,   1092 .. 1093,   1095,   1098,   1100 .. 1107,
    1110 .. 1131,   1140,           1147 .. 1148,   1150 .. 1162,
    1164 .. 1175,   1200 .. 1211,   1213 .. 1221,   1240,
    1250 .. 1251,   1253 .. 1257,   1259 .. 1261,   1263 .. 1268,
    1270 .. 1271,   1291,           1300 .. 1304,   1306 .. 1329,
    1350,           1352 .. 1371,   1400 .. 1403,   1406 .. 1441,
    1448,           1450 .. 1460,   1462 .. 1464,   1466 .. 1468,
    1470 .. 1472,   1500,   1513,   1532 .. 1533,   1550 .. 1564,
    1566 .. 1577,   1592,           1599 .. 1604,   1606 .. 1624,
    1630 .. 1635,   1650 .. 1677,   1699 .. 1712,   1714 .. 1739,
    1749 .. 1766,   1770 .. 1775,   1777,   1780,   1785 .. 1787,
    1790,           1799 .. 1820,   1822 .. 1829,   1850 .. 1857,
    1860 .. 1868,   1870 .. 1879,   1900 .. 1906,   1908 .. 1917,
    1920 .. 1928,   1950 .. 1967,   1970 .. 1974,

    2000,   2100,   2150,   2200,   2300,   2400,   2450,   2500,
    2600,   2605,   2610,   2620,   2625,   2630,   2635,   2640,
    2650,   2660,   2665,   2670,   2680,   2690,   2700,   2720,
    2730,   2740,   2750,   2760,   2765,   2770,   2791,   2800,
    2820,   2830,   2840,   2850,   2860,   2870,   2880,   2900,
    2920,   2930,   2942,   2950,   2960,   2970,   2980,   2990,

    3000,   3050,   3060,   3070,   3080,   3100,   3120,   3140,
    3150,   3200,   3210,   3220,   3230,   3250,   3300,   3310,
    3320,   3330,   3360,   3370,   3390,   3400,   3450,   3460,
    3480,   3490,   3500,   3520,   3540,   3550,   3600,   3630,
    3650,   3660,   3670,   3700,   3720,   3730,   3740,   3751,
    3760,   3770,   3782,   3790,

    4000,   4030,   4040,   4050,   4060,   4070,   4100,   4130,
    4140,   4160,   4171,           4173 .. 4174,   4180,   4190,
    4200,   4220,   4230,           4241 .. 4243,   4250,
    4261 .. 4262,   4270,   4281,   4291,   4293,   4295 .. 4296,
    4300,   4320,   4330,   4340,   4350,   4360,   4370,   4390,
    4400,   4420,   4440,   4450,   4460,   4470,   4480,   4490,
    4500,   4520,   4532,   4534,   4540,   4550,   4560,
    4571 .. 4573,   4581,   4583,   4591 .. 4593,   4600,
    4621 .. 4623,   4632,   4640,   4652 .. 4654,   4660,
    4671 .. 4673,   4681 .. 4684,   4690,   4700,   4720,   4733,
    4735 .. 4736,   4750,   4760,   4771 .. 4773,   4780,
    4791 .. 4793,   4800,   4840,   4850,           4862 .. 4863,
    4871 .. 4874,   4880,           4891 .. 4892,   4894 .. 4895,
    4900,           4912 .. 4913,   4920,   4930,   4941,
    4943 .. 4944,   4951 .. 4953,   4960,   4970,   4983,   4990,

    5000,   5200,   5210,   5220,   5230,   5240,   5250,   5260,
    5270,   5290,   5300,   5320,   5330,   5350,   5370,   5380,
    5390,   5400,   5450,           5462 .. 5464,   5466,   5471,
    5474,   5485,   5491 .. 5492,   5500,   5540,   5550,   5560,
    5580,           5591 .. 5592,   5600,   5610,   5620,   5631,
    5642,   5672,   5683,   5690,   5700,   5750,   5762,
    5771 .. 5772,   5792,   5800,   5853 .. 5854,   5856,   5863,
    5871,   5874,   5881 .. 5884,   5892,   5900,   5932,   5935,
    5953,   5960,   5970,   5985,

    6000,   6040,   6051 .. 6052,   6064,   6070,   6091 .. 6094,
    6100,   6200,   6230,   6240,   6261,   6270,   6280,   6300,
    6310,   6320,   6330,   6340,   6360,   6372,   6392,   6400,
    6430,   6440,   6470,   6500,   6510,   6520,   6534 .. 6535,
    6541,   6560,   6580,   6600,   6621 .. 6623,   6630,   6640,
    6650,   6660,   6670,           6682 .. 6683,   6690,   6700,
    6705,   6710,   6715,   6720,   6731,   6740,   6752 .. 6753,
    6760,   6771,   6780,   6792,   6800,   6818,   6823,   6830,
    6840,           6851 .. 6855,   6857,   6862,   6870,   6880,
    6893,   6900,   6920,   6933,   6940,   6950,   6960,   6971,
    6973,   6980,   6990,

    7000,   7007,   7080,   7100,   7120,   7130,   7140,   7150,
    7160,   7171,   7173,           7182 .. 7184,   7190,   7200,
    7250,   7260,   7270,   7280,   7300,   7321,   7323,   7330,
    7361 .. 7362,   7400,   7430,   7441 .. 7442,   7451,   7470,
    7480,   7490,   7500,   7540,   7550,   7560,   7570,   7600,
    7620,   7650,   7660,   7673,   7680,   7700,   7730,
    7741 .. 7742,   7752,   7755,   7760,   7770,   7790,   7800,
    7830,   7840,   7850,   7860,   7870,   7884,   7900,   7950,
    7960,   7970,   7980,   7990,

    8000,   8200,   8210,   8220,   8230,   8240,   8245,   8250,
    8260,   8270,   8300,   8305,   8310,   8320,   8330,   8340,
    8350,   8355,   8361 .. 8362,   8370,           8380 .. 8382,
    8400,   8410,   8420,   8444,   8450,   8462,   8464,
    8471 .. 8472,   8500,   8520,   8530,   8541,   8543 .. 8544,
    8550,   8560,   8570,   8581,   8585 .. 8586,   8592,   8600,
    8620,   8632,   8641,   8643,   8653 .. 8654,   8660,   8670,
    8680,   8700,   8721 .. 8723,   8732,   8740,   8751 .. 8752,
    8762 .. 8763,   8765 .. 8766,   8781,   8783,   8800,
    8830 .. 8832,   8840,   8850,   8860,   8870,   8881 .. 8883,
    8900,   8920,   8930,   8940,   8950,           8960 .. 8961,
    8963,   8970,   8981,   8983,   8990,

    9000,   9200,   9210,   9220,   9230,   9240,   9260,   9270,
    9280,   9293,   9300,   9310,   9320,   9330,   9340,   9352,
    9362,   9370,   9380 .. 9382,   9400,   9430,   9440,   9460,
    9480,   9490,   9492 .. 9493,   9500,   9510,   9520,   9530,
    9541,   9550,   9560,           9574 .. 9575,   9600,   9610,
    9620,           9631 .. 9632,   9640,   9670,   9681,   9690,
    9700,   9740,   9750,   9760,   9800,   9830,   9850,   9870,
    9881,   9900,   9940,   9970,   9981 .. 9982,   9990,
}


__END__
