# ! [ allow ( clippy :: too_many_arguments , clippy :: cognitive_complexity , clippy :: wrong_self_convention ) ]use std::fmt;
use std::os::raw::*;
#[doc = r" Iterates through the pointer chain. Includes the item that is passed into the function."]
#[doc = r" Stops at the last `BaseOutStructure` that has a null `p_next` field."]
pub(crate) unsafe fn ptr_chain_iter<T>(ptr: &mut T) -> impl Iterator<Item = *mut BaseOutStructure> {
    let ptr: *mut BaseOutStructure = ptr as *mut T as _;
    (0..).scan(ptr, |p_ptr, _| {
        if p_ptr.is_null() {
            return None;
        }
        let n_ptr = (**p_ptr).p_next as *mut BaseOutStructure;
        let old = *p_ptr;
        *p_ptr = n_ptr;
        Some(old)
    })
}
pub trait Handle {
    const TYPE: ObjectType;
    fn as_raw(self) -> u64;
    fn from_raw(_: u64) -> Self;
}
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_MAKE_VERSION.html>"]
pub const fn make_version(major: u32, minor: u32, patch: u32) -> u32 {
    (major << 22) | (minor << 12) | patch
}
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_VERSION_MAJOR.html>"]
pub const fn version_major(version: u32) -> u32 {
    version >> 22
}
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_VERSION_MINOR.html>"]
pub const fn version_minor(version: u32) -> u32 {
    (version >> 12) & 0x3ff
}
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VK_VERSION_PATCH.html>"]
pub const fn version_patch(version: u32) -> u32 {
    version & 0xfff
}
pub type RROutput = c_ulong;
pub type VisualID = c_uint;
pub type Display = *const c_void;
pub type Window = c_ulong;
#[allow(non_camel_case_types)]
pub type xcb_connection_t = c_void;
#[allow(non_camel_case_types)]
pub type xcb_window_t = u32;
#[allow(non_camel_case_types)]
pub type xcb_visualid_t = u32;
pub type MirConnection = *const c_void;
pub type MirSurface = *const c_void;
pub type HINSTANCE = *const c_void;
pub type HWND = *const c_void;
#[allow(non_camel_case_types)]
pub type wl_display = c_void;
#[allow(non_camel_case_types)]
pub type wl_surface = c_void;
pub type HANDLE = *mut c_void;
pub type HMONITOR = HANDLE;
pub type DWORD = c_ulong;
pub type LPCWSTR = *const u16;
#[allow(non_camel_case_types)]
pub type zx_handle_t = u32;
#[allow(non_camel_case_types)]
pub type SECURITY_ATTRIBUTES = ();
pub type ANativeWindow = c_void;
pub type AHardwareBuffer = c_void;
#[doc = r" This definition is experimental and won't adhere to semver rules."]
pub type GgpStreamDescriptor = u32;
#[doc = r" This definition is experimental and won't adhere to semver rules."]
pub type GgpFrameToken = u32;
pub type CAMetalLayer = c_void;
#[macro_export]
macro_rules! vk_bitflags_wrapped {
    ( $ name : ident , $ all : expr , $ flag_type : ty ) => {
        impl Default for $name {
            fn default() -> $name {
                $name(0)
            }
        }
        impl $name {
            #[inline]
            pub const fn empty() -> $name {
                $name(0)
            }
            #[inline]
            pub const fn all() -> $name {
                $name($all)
            }
            #[inline]
            pub const fn from_raw(x: $flag_type) -> Self {
                $name(x)
            }
            #[inline]
            pub const fn as_raw(self) -> $flag_type {
                self.0
            }
            #[inline]
            pub fn is_empty(self) -> bool {
                self == $name::empty()
            }
            #[inline]
            pub fn is_all(self) -> bool {
                self & $name::all() == $name::all()
            }
            #[inline]
            pub fn intersects(self, other: $name) -> bool {
                self & other != $name::empty()
            }
            #[doc = r" Returns whether `other` is a subset of `self`"]
            #[inline]
            pub fn contains(self, other: $name) -> bool {
                self & other == other
            }
        }
        impl ::std::ops::BitOr for $name {
            type Output = $name;
            #[inline]
            fn bitor(self, rhs: $name) -> $name {
                $name(self.0 | rhs.0)
            }
        }
        impl ::std::ops::BitOrAssign for $name {
            #[inline]
            fn bitor_assign(&mut self, rhs: $name) {
                *self = *self | rhs
            }
        }
        impl ::std::ops::BitAnd for $name {
            type Output = $name;
            #[inline]
            fn bitand(self, rhs: $name) -> $name {
                $name(self.0 & rhs.0)
            }
        }
        impl ::std::ops::BitAndAssign for $name {
            #[inline]
            fn bitand_assign(&mut self, rhs: $name) {
                *self = *self & rhs
            }
        }
        impl ::std::ops::BitXor for $name {
            type Output = $name;
            #[inline]
            fn bitxor(self, rhs: $name) -> $name {
                $name(self.0 ^ rhs.0)
            }
        }
        impl ::std::ops::BitXorAssign for $name {
            #[inline]
            fn bitxor_assign(&mut self, rhs: $name) {
                *self = *self ^ rhs
            }
        }
        impl ::std::ops::Sub for $name {
            type Output = $name;
            #[inline]
            fn sub(self, rhs: $name) -> $name {
                self & !rhs
            }
        }
        impl ::std::ops::SubAssign for $name {
            #[inline]
            fn sub_assign(&mut self, rhs: $name) {
                *self = *self - rhs
            }
        }
        impl ::std::ops::Not for $name {
            type Output = $name;
            #[inline]
            fn not(self) -> $name {
                self ^ $name::all()
            }
        }
    };
}
#[macro_export]
macro_rules! handle_nondispatchable {
    ( $ name : ident , $ ty : ident ) => {
        handle_nondispatchable!($name, $ty, doc = "");
    };
    ( $ name : ident , $ ty : ident , $ doc_link : meta ) => {
        #[repr(transparent)]
        #[derive(Eq, PartialEq, Ord, PartialOrd, Clone, Copy, Hash, Default)]
        #[$doc_link]
        pub struct $name(u64);
        impl Handle for $name {
            const TYPE: ObjectType = ObjectType::$ty;
            fn as_raw(self) -> u64 {
                self.0 as u64
            }
            fn from_raw(x: u64) -> Self {
                $name(x as _)
            }
        }
        impl $name {
            pub const fn null() -> $name {
                $name(0)
            }
        }
        impl fmt::Pointer for $name {
            fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
                write!(f, "0x{:x}", self.0)
            }
        }
        impl fmt::Debug for $name {
            fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
                write!(f, "0x{:x}", self.0)
            }
        }
    };
}
#[macro_export]
macro_rules! define_handle {
    ( $ name : ident , $ ty : ident ) => {
        define_handle!($name, $ty, doc = "");
    };
    ( $ name : ident , $ ty : ident , $ doc_link : meta ) => {
        #[repr(transparent)]
        #[derive(Eq, PartialEq, Ord, PartialOrd, Clone, Copy, Hash)]
        #[$doc_link]
        pub struct $name(*mut u8);
        impl Default for $name {
            fn default() -> $name {
                $name::null()
            }
        }
        impl Handle for $name {
            const TYPE: ObjectType = ObjectType::$ty;
            fn as_raw(self) -> u64 {
                self.0 as u64
            }
            fn from_raw(x: u64) -> Self {
                $name(x as _)
            }
        }
        unsafe impl Send for $name {}
        unsafe impl Sync for $name {}
        impl $name {
            pub const fn null() -> Self {
                $name(::std::ptr::null_mut())
            }
        }
        impl fmt::Pointer for $name {
            fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
                fmt::Pointer::fmt(&self.0, f)
            }
        }
        impl fmt::Debug for $name {
            fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
                fmt::Debug::fmt(&self.0, f)
            }
        }
    };
}
#[allow(non_camel_case_types)]
pub type PFN_vkGetInstanceProcAddr =
    extern "system" fn(instance: Instance, p_name: *const c_char) -> PFN_vkVoidFunction;
pub struct StaticFn {
    pub get_instance_proc_addr:
        extern "system" fn(instance: Instance, p_name: *const c_char) -> PFN_vkVoidFunction,
}
unsafe impl Send for StaticFn {}
unsafe impl Sync for StaticFn {}
impl ::std::clone::Clone for StaticFn {
    fn clone(&self) -> Self {
        StaticFn {
            get_instance_proc_addr: self.get_instance_proc_addr,
        }
    }
}
impl StaticFn {
    pub fn load<F>(mut _f: F) -> Self
    where
        F: FnMut(&::std::ffi::CStr) -> *const c_void,
    {
        StaticFn {
            get_instance_proc_addr: unsafe {
                extern "system" fn get_instance_proc_addr(
                    _instance: Instance,
                    _p_name: *const c_char,
                ) -> PFN_vkVoidFunction {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_instance_proc_addr)
                    ))
                }
                let raw_name = stringify!(vkGetInstanceProcAddr);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_instance_proc_addr
                } else {
                    ::std::mem::transmute(val)
                }
            },
        }
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetInstanceProcAddr.html>"]
    pub unsafe fn get_instance_proc_addr(
        &self,
        instance: Instance,
        p_name: *const c_char,
    ) -> PFN_vkVoidFunction {
        (self.get_instance_proc_addr)(instance, p_name)
    }
}
#[allow(non_camel_case_types)]
pub type PFN_vkCreateInstance = extern "system" fn(
    p_create_info: *const InstanceCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_instance: *mut Instance,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkEnumerateInstanceExtensionProperties = extern "system" fn(
    p_layer_name: *const c_char,
    p_property_count: *mut u32,
    p_properties: *mut ExtensionProperties,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkEnumerateInstanceLayerProperties =
    extern "system" fn(p_property_count: *mut u32, p_properties: *mut LayerProperties) -> Result;
pub struct EntryFnV1_0 {
    pub create_instance: extern "system" fn(
        p_create_info: *const InstanceCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_instance: *mut Instance,
    ) -> Result,
    pub enumerate_instance_extension_properties: extern "system" fn(
        p_layer_name: *const c_char,
        p_property_count: *mut u32,
        p_properties: *mut ExtensionProperties,
    ) -> Result,
    pub enumerate_instance_layer_properties: extern "system" fn(
        p_property_count: *mut u32,
        p_properties: *mut LayerProperties,
    ) -> Result,
}
unsafe impl Send for EntryFnV1_0 {}
unsafe impl Sync for EntryFnV1_0 {}
impl ::std::clone::Clone for EntryFnV1_0 {
    fn clone(&self) -> Self {
        EntryFnV1_0 {
            create_instance: self.create_instance,
            enumerate_instance_extension_properties: self.enumerate_instance_extension_properties,
            enumerate_instance_layer_properties: self.enumerate_instance_layer_properties,
        }
    }
}
impl EntryFnV1_0 {
    pub fn load<F>(mut _f: F) -> Self
    where
        F: FnMut(&::std::ffi::CStr) -> *const c_void,
    {
        EntryFnV1_0 {
            create_instance: unsafe {
                extern "system" fn create_instance(
                    _p_create_info: *const InstanceCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_instance: *mut Instance,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(create_instance)))
                }
                let raw_name = stringify!(vkCreateInstance);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_instance
                } else {
                    ::std::mem::transmute(val)
                }
            },
            enumerate_instance_extension_properties: unsafe {
                extern "system" fn enumerate_instance_extension_properties(
                    _p_layer_name: *const c_char,
                    _p_property_count: *mut u32,
                    _p_properties: *mut ExtensionProperties,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(enumerate_instance_extension_properties)
                    ))
                }
                let raw_name = stringify!(vkEnumerateInstanceExtensionProperties);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    enumerate_instance_extension_properties
                } else {
                    ::std::mem::transmute(val)
                }
            },
            enumerate_instance_layer_properties: unsafe {
                extern "system" fn enumerate_instance_layer_properties(
                    _p_property_count: *mut u32,
                    _p_properties: *mut LayerProperties,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(enumerate_instance_layer_properties)
                    ))
                }
                let raw_name = stringify!(vkEnumerateInstanceLayerProperties);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    enumerate_instance_layer_properties
                } else {
                    ::std::mem::transmute(val)
                }
            },
        }
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateInstance.html>"]
    pub unsafe fn create_instance(
        &self,
        p_create_info: *const InstanceCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_instance: *mut Instance,
    ) -> Result {
        (self.create_instance)(p_create_info, p_allocator, p_instance)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkEnumerateInstanceExtensionProperties.html>"]
    pub unsafe fn enumerate_instance_extension_properties(
        &self,
        p_layer_name: *const c_char,
        p_property_count: *mut u32,
        p_properties: *mut ExtensionProperties,
    ) -> Result {
        (self.enumerate_instance_extension_properties)(p_layer_name, p_property_count, p_properties)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkEnumerateInstanceLayerProperties.html>"]
    pub unsafe fn enumerate_instance_layer_properties(
        &self,
        p_property_count: *mut u32,
        p_properties: *mut LayerProperties,
    ) -> Result {
        (self.enumerate_instance_layer_properties)(p_property_count, p_properties)
    }
}
#[allow(non_camel_case_types)]
pub type PFN_vkDestroyInstance =
    extern "system" fn(instance: Instance, p_allocator: *const AllocationCallbacks) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkEnumeratePhysicalDevices = extern "system" fn(
    instance: Instance,
    p_physical_device_count: *mut u32,
    p_physical_devices: *mut PhysicalDevice,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkGetPhysicalDeviceFeatures = extern "system" fn(
    physical_device: PhysicalDevice,
    p_features: *mut PhysicalDeviceFeatures,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkGetPhysicalDeviceFormatProperties = extern "system" fn(
    physical_device: PhysicalDevice,
    format: Format,
    p_format_properties: *mut FormatProperties,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkGetPhysicalDeviceImageFormatProperties = extern "system" fn(
    physical_device: PhysicalDevice,
    format: Format,
    ty: ImageType,
    tiling: ImageTiling,
    usage: ImageUsageFlags,
    flags: ImageCreateFlags,
    p_image_format_properties: *mut ImageFormatProperties,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkGetPhysicalDeviceProperties = extern "system" fn(
    physical_device: PhysicalDevice,
    p_properties: *mut PhysicalDeviceProperties,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkGetPhysicalDeviceQueueFamilyProperties = extern "system" fn(
    physical_device: PhysicalDevice,
    p_queue_family_property_count: *mut u32,
    p_queue_family_properties: *mut QueueFamilyProperties,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkGetPhysicalDeviceMemoryProperties = extern "system" fn(
    physical_device: PhysicalDevice,
    p_memory_properties: *mut PhysicalDeviceMemoryProperties,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkGetDeviceProcAddr =
    extern "system" fn(device: Device, p_name: *const c_char) -> PFN_vkVoidFunction;
#[allow(non_camel_case_types)]
pub type PFN_vkCreateDevice = extern "system" fn(
    physical_device: PhysicalDevice,
    p_create_info: *const DeviceCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_device: *mut Device,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkEnumerateDeviceExtensionProperties = extern "system" fn(
    physical_device: PhysicalDevice,
    p_layer_name: *const c_char,
    p_property_count: *mut u32,
    p_properties: *mut ExtensionProperties,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkEnumerateDeviceLayerProperties = extern "system" fn(
    physical_device: PhysicalDevice,
    p_property_count: *mut u32,
    p_properties: *mut LayerProperties,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkGetPhysicalDeviceSparseImageFormatProperties = extern "system" fn(
    physical_device: PhysicalDevice,
    format: Format,
    ty: ImageType,
    samples: SampleCountFlags,
    usage: ImageUsageFlags,
    tiling: ImageTiling,
    p_property_count: *mut u32,
    p_properties: *mut SparseImageFormatProperties,
) -> c_void;
pub struct InstanceFnV1_0 {
    pub destroy_instance:
        extern "system" fn(instance: Instance, p_allocator: *const AllocationCallbacks) -> c_void,
    pub enumerate_physical_devices: extern "system" fn(
        instance: Instance,
        p_physical_device_count: *mut u32,
        p_physical_devices: *mut PhysicalDevice,
    ) -> Result,
    pub get_physical_device_features: extern "system" fn(
        physical_device: PhysicalDevice,
        p_features: *mut PhysicalDeviceFeatures,
    ) -> c_void,
    pub get_physical_device_format_properties: extern "system" fn(
        physical_device: PhysicalDevice,
        format: Format,
        p_format_properties: *mut FormatProperties,
    ) -> c_void,
    pub get_physical_device_image_format_properties: extern "system" fn(
        physical_device: PhysicalDevice,
        format: Format,
        ty: ImageType,
        tiling: ImageTiling,
        usage: ImageUsageFlags,
        flags: ImageCreateFlags,
        p_image_format_properties: *mut ImageFormatProperties,
    ) -> Result,
    pub get_physical_device_properties: extern "system" fn(
        physical_device: PhysicalDevice,
        p_properties: *mut PhysicalDeviceProperties,
    ) -> c_void,
    pub get_physical_device_queue_family_properties: extern "system" fn(
        physical_device: PhysicalDevice,
        p_queue_family_property_count: *mut u32,
        p_queue_family_properties: *mut QueueFamilyProperties,
    ) -> c_void,
    pub get_physical_device_memory_properties: extern "system" fn(
        physical_device: PhysicalDevice,
        p_memory_properties: *mut PhysicalDeviceMemoryProperties,
    ) -> c_void,
    pub get_device_proc_addr:
        extern "system" fn(device: Device, p_name: *const c_char) -> PFN_vkVoidFunction,
    pub create_device: extern "system" fn(
        physical_device: PhysicalDevice,
        p_create_info: *const DeviceCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_device: *mut Device,
    ) -> Result,
    pub enumerate_device_extension_properties: extern "system" fn(
        physical_device: PhysicalDevice,
        p_layer_name: *const c_char,
        p_property_count: *mut u32,
        p_properties: *mut ExtensionProperties,
    ) -> Result,
    pub enumerate_device_layer_properties: extern "system" fn(
        physical_device: PhysicalDevice,
        p_property_count: *mut u32,
        p_properties: *mut LayerProperties,
    ) -> Result,
    pub get_physical_device_sparse_image_format_properties: extern "system" fn(
        physical_device: PhysicalDevice,
        format: Format,
        ty: ImageType,
        samples: SampleCountFlags,
        usage: ImageUsageFlags,
        tiling: ImageTiling,
        p_property_count: *mut u32,
        p_properties: *mut SparseImageFormatProperties,
    ) -> c_void,
}
unsafe impl Send for InstanceFnV1_0 {}
unsafe impl Sync for InstanceFnV1_0 {}
impl ::std::clone::Clone for InstanceFnV1_0 {
    fn clone(&self) -> Self {
        InstanceFnV1_0 {
            destroy_instance: self.destroy_instance,
            enumerate_physical_devices: self.enumerate_physical_devices,
            get_physical_device_features: self.get_physical_device_features,
            get_physical_device_format_properties: self.get_physical_device_format_properties,
            get_physical_device_image_format_properties: self
                .get_physical_device_image_format_properties,
            get_physical_device_properties: self.get_physical_device_properties,
            get_physical_device_queue_family_properties: self
                .get_physical_device_queue_family_properties,
            get_physical_device_memory_properties: self.get_physical_device_memory_properties,
            get_device_proc_addr: self.get_device_proc_addr,
            create_device: self.create_device,
            enumerate_device_extension_properties: self.enumerate_device_extension_properties,
            enumerate_device_layer_properties: self.enumerate_device_layer_properties,
            get_physical_device_sparse_image_format_properties: self
                .get_physical_device_sparse_image_format_properties,
        }
    }
}
impl InstanceFnV1_0 {
    pub fn load<F>(mut _f: F) -> Self
    where
        F: FnMut(&::std::ffi::CStr) -> *const c_void,
    {
        InstanceFnV1_0 {
            destroy_instance: unsafe {
                extern "system" fn destroy_instance(
                    _instance: Instance,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(destroy_instance)))
                }
                let raw_name = stringify!(vkDestroyInstance);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_instance
                } else {
                    ::std::mem::transmute(val)
                }
            },
            enumerate_physical_devices: unsafe {
                extern "system" fn enumerate_physical_devices(
                    _instance: Instance,
                    _p_physical_device_count: *mut u32,
                    _p_physical_devices: *mut PhysicalDevice,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(enumerate_physical_devices)
                    ))
                }
                let raw_name = stringify!(vkEnumeratePhysicalDevices);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    enumerate_physical_devices
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_physical_device_features: unsafe {
                extern "system" fn get_physical_device_features(
                    _physical_device: PhysicalDevice,
                    _p_features: *mut PhysicalDeviceFeatures,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_physical_device_features)
                    ))
                }
                let raw_name = stringify!(vkGetPhysicalDeviceFeatures);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_physical_device_features
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_physical_device_format_properties: unsafe {
                extern "system" fn get_physical_device_format_properties(
                    _physical_device: PhysicalDevice,
                    _format: Format,
                    _p_format_properties: *mut FormatProperties,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_physical_device_format_properties)
                    ))
                }
                let raw_name = stringify!(vkGetPhysicalDeviceFormatProperties);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_physical_device_format_properties
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_physical_device_image_format_properties: unsafe {
                extern "system" fn get_physical_device_image_format_properties(
                    _physical_device: PhysicalDevice,
                    _format: Format,
                    _ty: ImageType,
                    _tiling: ImageTiling,
                    _usage: ImageUsageFlags,
                    _flags: ImageCreateFlags,
                    _p_image_format_properties: *mut ImageFormatProperties,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_physical_device_image_format_properties)
                    ))
                }
                let raw_name = stringify!(vkGetPhysicalDeviceImageFormatProperties);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_physical_device_image_format_properties
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_physical_device_properties: unsafe {
                extern "system" fn get_physical_device_properties(
                    _physical_device: PhysicalDevice,
                    _p_properties: *mut PhysicalDeviceProperties,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_physical_device_properties)
                    ))
                }
                let raw_name = stringify!(vkGetPhysicalDeviceProperties);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_physical_device_properties
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_physical_device_queue_family_properties: unsafe {
                extern "system" fn get_physical_device_queue_family_properties(
                    _physical_device: PhysicalDevice,
                    _p_queue_family_property_count: *mut u32,
                    _p_queue_family_properties: *mut QueueFamilyProperties,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_physical_device_queue_family_properties)
                    ))
                }
                let raw_name = stringify!(vkGetPhysicalDeviceQueueFamilyProperties);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_physical_device_queue_family_properties
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_physical_device_memory_properties: unsafe {
                extern "system" fn get_physical_device_memory_properties(
                    _physical_device: PhysicalDevice,
                    _p_memory_properties: *mut PhysicalDeviceMemoryProperties,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_physical_device_memory_properties)
                    ))
                }
                let raw_name = stringify!(vkGetPhysicalDeviceMemoryProperties);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_physical_device_memory_properties
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_device_proc_addr: unsafe {
                extern "system" fn get_device_proc_addr(
                    _device: Device,
                    _p_name: *const c_char,
                ) -> PFN_vkVoidFunction {
                    panic!(concat!("Unable to load ", stringify!(get_device_proc_addr)))
                }
                let raw_name = stringify!(vkGetDeviceProcAddr);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_device_proc_addr
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_device: unsafe {
                extern "system" fn create_device(
                    _physical_device: PhysicalDevice,
                    _p_create_info: *const DeviceCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_device: *mut Device,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(create_device)))
                }
                let raw_name = stringify!(vkCreateDevice);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_device
                } else {
                    ::std::mem::transmute(val)
                }
            },
            enumerate_device_extension_properties: unsafe {
                extern "system" fn enumerate_device_extension_properties(
                    _physical_device: PhysicalDevice,
                    _p_layer_name: *const c_char,
                    _p_property_count: *mut u32,
                    _p_properties: *mut ExtensionProperties,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(enumerate_device_extension_properties)
                    ))
                }
                let raw_name = stringify!(vkEnumerateDeviceExtensionProperties);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    enumerate_device_extension_properties
                } else {
                    ::std::mem::transmute(val)
                }
            },
            enumerate_device_layer_properties: unsafe {
                extern "system" fn enumerate_device_layer_properties(
                    _physical_device: PhysicalDevice,
                    _p_property_count: *mut u32,
                    _p_properties: *mut LayerProperties,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(enumerate_device_layer_properties)
                    ))
                }
                let raw_name = stringify!(vkEnumerateDeviceLayerProperties);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    enumerate_device_layer_properties
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_physical_device_sparse_image_format_properties: unsafe {
                extern "system" fn get_physical_device_sparse_image_format_properties(
                    _physical_device: PhysicalDevice,
                    _format: Format,
                    _ty: ImageType,
                    _samples: SampleCountFlags,
                    _usage: ImageUsageFlags,
                    _tiling: ImageTiling,
                    _p_property_count: *mut u32,
                    _p_properties: *mut SparseImageFormatProperties,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_physical_device_sparse_image_format_properties)
                    ))
                }
                let raw_name = stringify!(vkGetPhysicalDeviceSparseImageFormatProperties);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_physical_device_sparse_image_format_properties
                } else {
                    ::std::mem::transmute(val)
                }
            },
        }
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyInstance.html>"]
    pub unsafe fn destroy_instance(
        &self,
        instance: Instance,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_instance)(instance, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkEnumeratePhysicalDevices.html>"]
    pub unsafe fn enumerate_physical_devices(
        &self,
        instance: Instance,
        p_physical_device_count: *mut u32,
        p_physical_devices: *mut PhysicalDevice,
    ) -> Result {
        (self.enumerate_physical_devices)(instance, p_physical_device_count, p_physical_devices)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceFeatures.html>"]
    pub unsafe fn get_physical_device_features(
        &self,
        physical_device: PhysicalDevice,
        p_features: *mut PhysicalDeviceFeatures,
    ) -> c_void {
        (self.get_physical_device_features)(physical_device, p_features)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceFormatProperties.html>"]
    pub unsafe fn get_physical_device_format_properties(
        &self,
        physical_device: PhysicalDevice,
        format: Format,
        p_format_properties: *mut FormatProperties,
    ) -> c_void {
        (self.get_physical_device_format_properties)(physical_device, format, p_format_properties)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceImageFormatProperties.html>"]
    pub unsafe fn get_physical_device_image_format_properties(
        &self,
        physical_device: PhysicalDevice,
        format: Format,
        ty: ImageType,
        tiling: ImageTiling,
        usage: ImageUsageFlags,
        flags: ImageCreateFlags,
        p_image_format_properties: *mut ImageFormatProperties,
    ) -> Result {
        (self.get_physical_device_image_format_properties)(
            physical_device,
            format,
            ty,
            tiling,
            usage,
            flags,
            p_image_format_properties,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceProperties.html>"]
    pub unsafe fn get_physical_device_properties(
        &self,
        physical_device: PhysicalDevice,
        p_properties: *mut PhysicalDeviceProperties,
    ) -> c_void {
        (self.get_physical_device_properties)(physical_device, p_properties)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceQueueFamilyProperties.html>"]
    pub unsafe fn get_physical_device_queue_family_properties(
        &self,
        physical_device: PhysicalDevice,
        p_queue_family_property_count: *mut u32,
        p_queue_family_properties: *mut QueueFamilyProperties,
    ) -> c_void {
        (self.get_physical_device_queue_family_properties)(
            physical_device,
            p_queue_family_property_count,
            p_queue_family_properties,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceMemoryProperties.html>"]
    pub unsafe fn get_physical_device_memory_properties(
        &self,
        physical_device: PhysicalDevice,
        p_memory_properties: *mut PhysicalDeviceMemoryProperties,
    ) -> c_void {
        (self.get_physical_device_memory_properties)(physical_device, p_memory_properties)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeviceProcAddr.html>"]
    pub unsafe fn get_device_proc_addr(
        &self,
        device: Device,
        p_name: *const c_char,
    ) -> PFN_vkVoidFunction {
        (self.get_device_proc_addr)(device, p_name)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateDevice.html>"]
    pub unsafe fn create_device(
        &self,
        physical_device: PhysicalDevice,
        p_create_info: *const DeviceCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_device: *mut Device,
    ) -> Result {
        (self.create_device)(physical_device, p_create_info, p_allocator, p_device)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkEnumerateDeviceExtensionProperties.html>"]
    pub unsafe fn enumerate_device_extension_properties(
        &self,
        physical_device: PhysicalDevice,
        p_layer_name: *const c_char,
        p_property_count: *mut u32,
        p_properties: *mut ExtensionProperties,
    ) -> Result {
        (self.enumerate_device_extension_properties)(
            physical_device,
            p_layer_name,
            p_property_count,
            p_properties,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkEnumerateDeviceLayerProperties.html>"]
    pub unsafe fn enumerate_device_layer_properties(
        &self,
        physical_device: PhysicalDevice,
        p_property_count: *mut u32,
        p_properties: *mut LayerProperties,
    ) -> Result {
        (self.enumerate_device_layer_properties)(physical_device, p_property_count, p_properties)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceSparseImageFormatProperties.html>"]
    pub unsafe fn get_physical_device_sparse_image_format_properties(
        &self,
        physical_device: PhysicalDevice,
        format: Format,
        ty: ImageType,
        samples: SampleCountFlags,
        usage: ImageUsageFlags,
        tiling: ImageTiling,
        p_property_count: *mut u32,
        p_properties: *mut SparseImageFormatProperties,
    ) -> c_void {
        (self.get_physical_device_sparse_image_format_properties)(
            physical_device,
            format,
            ty,
            samples,
            usage,
            tiling,
            p_property_count,
            p_properties,
        )
    }
}
#[allow(non_camel_case_types)]
pub type PFN_vkDestroyDevice =
    extern "system" fn(device: Device, p_allocator: *const AllocationCallbacks) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkGetDeviceQueue = extern "system" fn(
    device: Device,
    queue_family_index: u32,
    queue_index: u32,
    p_queue: *mut Queue,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkQueueSubmit = extern "system" fn(
    queue: Queue,
    submit_count: u32,
    p_submits: *const SubmitInfo,
    fence: Fence,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkQueueWaitIdle = extern "system" fn(queue: Queue) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDeviceWaitIdle = extern "system" fn(device: Device) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkAllocateMemory = extern "system" fn(
    device: Device,
    p_allocate_info: *const MemoryAllocateInfo,
    p_allocator: *const AllocationCallbacks,
    p_memory: *mut DeviceMemory,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkFreeMemory = extern "system" fn(
    device: Device,
    memory: DeviceMemory,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkMapMemory = extern "system" fn(
    device: Device,
    memory: DeviceMemory,
    offset: DeviceSize,
    size: DeviceSize,
    flags: MemoryMapFlags,
    pp_data: *mut *mut c_void,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkUnmapMemory = extern "system" fn(device: Device, memory: DeviceMemory) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkFlushMappedMemoryRanges = extern "system" fn(
    device: Device,
    memory_range_count: u32,
    p_memory_ranges: *const MappedMemoryRange,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkInvalidateMappedMemoryRanges = extern "system" fn(
    device: Device,
    memory_range_count: u32,
    p_memory_ranges: *const MappedMemoryRange,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkGetDeviceMemoryCommitment = extern "system" fn(
    device: Device,
    memory: DeviceMemory,
    p_committed_memory_in_bytes: *mut DeviceSize,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkBindBufferMemory = extern "system" fn(
    device: Device,
    buffer: Buffer,
    memory: DeviceMemory,
    memory_offset: DeviceSize,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkBindImageMemory = extern "system" fn(
    device: Device,
    image: Image,
    memory: DeviceMemory,
    memory_offset: DeviceSize,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkGetBufferMemoryRequirements = extern "system" fn(
    device: Device,
    buffer: Buffer,
    p_memory_requirements: *mut MemoryRequirements,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkGetImageMemoryRequirements = extern "system" fn(
    device: Device,
    image: Image,
    p_memory_requirements: *mut MemoryRequirements,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkGetImageSparseMemoryRequirements = extern "system" fn(
    device: Device,
    image: Image,
    p_sparse_memory_requirement_count: *mut u32,
    p_sparse_memory_requirements: *mut SparseImageMemoryRequirements,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkQueueBindSparse = extern "system" fn(
    queue: Queue,
    bind_info_count: u32,
    p_bind_info: *const BindSparseInfo,
    fence: Fence,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkCreateFence = extern "system" fn(
    device: Device,
    p_create_info: *const FenceCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_fence: *mut Fence,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDestroyFence = extern "system" fn(
    device: Device,
    fence: Fence,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkResetFences =
    extern "system" fn(device: Device, fence_count: u32, p_fences: *const Fence) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkGetFenceStatus = extern "system" fn(device: Device, fence: Fence) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkWaitForFences = extern "system" fn(
    device: Device,
    fence_count: u32,
    p_fences: *const Fence,
    wait_all: Bool32,
    timeout: u64,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkCreateSemaphore = extern "system" fn(
    device: Device,
    p_create_info: *const SemaphoreCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_semaphore: *mut Semaphore,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDestroySemaphore = extern "system" fn(
    device: Device,
    semaphore: Semaphore,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCreateEvent = extern "system" fn(
    device: Device,
    p_create_info: *const EventCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_event: *mut Event,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDestroyEvent = extern "system" fn(
    device: Device,
    event: Event,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkGetEventStatus = extern "system" fn(device: Device, event: Event) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkSetEvent = extern "system" fn(device: Device, event: Event) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkResetEvent = extern "system" fn(device: Device, event: Event) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkCreateQueryPool = extern "system" fn(
    device: Device,
    p_create_info: *const QueryPoolCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_query_pool: *mut QueryPool,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDestroyQueryPool = extern "system" fn(
    device: Device,
    query_pool: QueryPool,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkGetQueryPoolResults = extern "system" fn(
    device: Device,
    query_pool: QueryPool,
    first_query: u32,
    query_count: u32,
    data_size: usize,
    p_data: *mut c_void,
    stride: DeviceSize,
    flags: QueryResultFlags,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkCreateBuffer = extern "system" fn(
    device: Device,
    p_create_info: *const BufferCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_buffer: *mut Buffer,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDestroyBuffer = extern "system" fn(
    device: Device,
    buffer: Buffer,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCreateBufferView = extern "system" fn(
    device: Device,
    p_create_info: *const BufferViewCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_view: *mut BufferView,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDestroyBufferView = extern "system" fn(
    device: Device,
    buffer_view: BufferView,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCreateImage = extern "system" fn(
    device: Device,
    p_create_info: *const ImageCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_image: *mut Image,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDestroyImage = extern "system" fn(
    device: Device,
    image: Image,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkGetImageSubresourceLayout = extern "system" fn(
    device: Device,
    image: Image,
    p_subresource: *const ImageSubresource,
    p_layout: *mut SubresourceLayout,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCreateImageView = extern "system" fn(
    device: Device,
    p_create_info: *const ImageViewCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_view: *mut ImageView,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDestroyImageView = extern "system" fn(
    device: Device,
    image_view: ImageView,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCreateShaderModule = extern "system" fn(
    device: Device,
    p_create_info: *const ShaderModuleCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_shader_module: *mut ShaderModule,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDestroyShaderModule = extern "system" fn(
    device: Device,
    shader_module: ShaderModule,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCreatePipelineCache = extern "system" fn(
    device: Device,
    p_create_info: *const PipelineCacheCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_pipeline_cache: *mut PipelineCache,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDestroyPipelineCache = extern "system" fn(
    device: Device,
    pipeline_cache: PipelineCache,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkGetPipelineCacheData = extern "system" fn(
    device: Device,
    pipeline_cache: PipelineCache,
    p_data_size: *mut usize,
    p_data: *mut c_void,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkMergePipelineCaches = extern "system" fn(
    device: Device,
    dst_cache: PipelineCache,
    src_cache_count: u32,
    p_src_caches: *const PipelineCache,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkCreateGraphicsPipelines = extern "system" fn(
    device: Device,
    pipeline_cache: PipelineCache,
    create_info_count: u32,
    p_create_infos: *const GraphicsPipelineCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_pipelines: *mut Pipeline,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkCreateComputePipelines = extern "system" fn(
    device: Device,
    pipeline_cache: PipelineCache,
    create_info_count: u32,
    p_create_infos: *const ComputePipelineCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_pipelines: *mut Pipeline,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDestroyPipeline = extern "system" fn(
    device: Device,
    pipeline: Pipeline,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCreatePipelineLayout = extern "system" fn(
    device: Device,
    p_create_info: *const PipelineLayoutCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_pipeline_layout: *mut PipelineLayout,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDestroyPipelineLayout = extern "system" fn(
    device: Device,
    pipeline_layout: PipelineLayout,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCreateSampler = extern "system" fn(
    device: Device,
    p_create_info: *const SamplerCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_sampler: *mut Sampler,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDestroySampler = extern "system" fn(
    device: Device,
    sampler: Sampler,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCreateDescriptorSetLayout = extern "system" fn(
    device: Device,
    p_create_info: *const DescriptorSetLayoutCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_set_layout: *mut DescriptorSetLayout,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDestroyDescriptorSetLayout = extern "system" fn(
    device: Device,
    descriptor_set_layout: DescriptorSetLayout,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCreateDescriptorPool = extern "system" fn(
    device: Device,
    p_create_info: *const DescriptorPoolCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_descriptor_pool: *mut DescriptorPool,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDestroyDescriptorPool = extern "system" fn(
    device: Device,
    descriptor_pool: DescriptorPool,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkResetDescriptorPool = extern "system" fn(
    device: Device,
    descriptor_pool: DescriptorPool,
    flags: DescriptorPoolResetFlags,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkAllocateDescriptorSets = extern "system" fn(
    device: Device,
    p_allocate_info: *const DescriptorSetAllocateInfo,
    p_descriptor_sets: *mut DescriptorSet,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkFreeDescriptorSets = extern "system" fn(
    device: Device,
    descriptor_pool: DescriptorPool,
    descriptor_set_count: u32,
    p_descriptor_sets: *const DescriptorSet,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkUpdateDescriptorSets = extern "system" fn(
    device: Device,
    descriptor_write_count: u32,
    p_descriptor_writes: *const WriteDescriptorSet,
    descriptor_copy_count: u32,
    p_descriptor_copies: *const CopyDescriptorSet,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCreateFramebuffer = extern "system" fn(
    device: Device,
    p_create_info: *const FramebufferCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_framebuffer: *mut Framebuffer,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDestroyFramebuffer = extern "system" fn(
    device: Device,
    framebuffer: Framebuffer,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCreateRenderPass = extern "system" fn(
    device: Device,
    p_create_info: *const RenderPassCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_render_pass: *mut RenderPass,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDestroyRenderPass = extern "system" fn(
    device: Device,
    render_pass: RenderPass,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkGetRenderAreaGranularity = extern "system" fn(
    device: Device,
    render_pass: RenderPass,
    p_granularity: *mut Extent2D,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCreateCommandPool = extern "system" fn(
    device: Device,
    p_create_info: *const CommandPoolCreateInfo,
    p_allocator: *const AllocationCallbacks,
    p_command_pool: *mut CommandPool,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkDestroyCommandPool = extern "system" fn(
    device: Device,
    command_pool: CommandPool,
    p_allocator: *const AllocationCallbacks,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkResetCommandPool = extern "system" fn(
    device: Device,
    command_pool: CommandPool,
    flags: CommandPoolResetFlags,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkAllocateCommandBuffers = extern "system" fn(
    device: Device,
    p_allocate_info: *const CommandBufferAllocateInfo,
    p_command_buffers: *mut CommandBuffer,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkFreeCommandBuffers = extern "system" fn(
    device: Device,
    command_pool: CommandPool,
    command_buffer_count: u32,
    p_command_buffers: *const CommandBuffer,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkBeginCommandBuffer = extern "system" fn(
    command_buffer: CommandBuffer,
    p_begin_info: *const CommandBufferBeginInfo,
) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkEndCommandBuffer = extern "system" fn(command_buffer: CommandBuffer) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkResetCommandBuffer =
    extern "system" fn(command_buffer: CommandBuffer, flags: CommandBufferResetFlags) -> Result;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdBindPipeline = extern "system" fn(
    command_buffer: CommandBuffer,
    pipeline_bind_point: PipelineBindPoint,
    pipeline: Pipeline,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdSetViewport = extern "system" fn(
    command_buffer: CommandBuffer,
    first_viewport: u32,
    viewport_count: u32,
    p_viewports: *const Viewport,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdSetScissor = extern "system" fn(
    command_buffer: CommandBuffer,
    first_scissor: u32,
    scissor_count: u32,
    p_scissors: *const Rect2D,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdSetLineWidth =
    extern "system" fn(command_buffer: CommandBuffer, line_width: f32) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdSetDepthBias = extern "system" fn(
    command_buffer: CommandBuffer,
    depth_bias_constant_factor: f32,
    depth_bias_clamp: f32,
    depth_bias_slope_factor: f32,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdSetBlendConstants =
    extern "system" fn(command_buffer: CommandBuffer, blend_constants: &[f32; 4]) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdSetDepthBounds = extern "system" fn(
    command_buffer: CommandBuffer,
    min_depth_bounds: f32,
    max_depth_bounds: f32,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdSetStencilCompareMask = extern "system" fn(
    command_buffer: CommandBuffer,
    face_mask: StencilFaceFlags,
    compare_mask: u32,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdSetStencilWriteMask = extern "system" fn(
    command_buffer: CommandBuffer,
    face_mask: StencilFaceFlags,
    write_mask: u32,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdSetStencilReference = extern "system" fn(
    command_buffer: CommandBuffer,
    face_mask: StencilFaceFlags,
    reference: u32,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdBindDescriptorSets = extern "system" fn(
    command_buffer: CommandBuffer,
    pipeline_bind_point: PipelineBindPoint,
    layout: PipelineLayout,
    first_set: u32,
    descriptor_set_count: u32,
    p_descriptor_sets: *const DescriptorSet,
    dynamic_offset_count: u32,
    p_dynamic_offsets: *const u32,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdBindIndexBuffer = extern "system" fn(
    command_buffer: CommandBuffer,
    buffer: Buffer,
    offset: DeviceSize,
    index_type: IndexType,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdBindVertexBuffers = extern "system" fn(
    command_buffer: CommandBuffer,
    first_binding: u32,
    binding_count: u32,
    p_buffers: *const Buffer,
    p_offsets: *const DeviceSize,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdDraw = extern "system" fn(
    command_buffer: CommandBuffer,
    vertex_count: u32,
    instance_count: u32,
    first_vertex: u32,
    first_instance: u32,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdDrawIndexed = extern "system" fn(
    command_buffer: CommandBuffer,
    index_count: u32,
    instance_count: u32,
    first_index: u32,
    vertex_offset: i32,
    first_instance: u32,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdDrawIndirect = extern "system" fn(
    command_buffer: CommandBuffer,
    buffer: Buffer,
    offset: DeviceSize,
    draw_count: u32,
    stride: u32,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdDrawIndexedIndirect = extern "system" fn(
    command_buffer: CommandBuffer,
    buffer: Buffer,
    offset: DeviceSize,
    draw_count: u32,
    stride: u32,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdDispatch = extern "system" fn(
    command_buffer: CommandBuffer,
    group_count_x: u32,
    group_count_y: u32,
    group_count_z: u32,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdDispatchIndirect =
    extern "system" fn(command_buffer: CommandBuffer, buffer: Buffer, offset: DeviceSize) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdCopyBuffer = extern "system" fn(
    command_buffer: CommandBuffer,
    src_buffer: Buffer,
    dst_buffer: Buffer,
    region_count: u32,
    p_regions: *const BufferCopy,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdCopyImage = extern "system" fn(
    command_buffer: CommandBuffer,
    src_image: Image,
    src_image_layout: ImageLayout,
    dst_image: Image,
    dst_image_layout: ImageLayout,
    region_count: u32,
    p_regions: *const ImageCopy,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdBlitImage = extern "system" fn(
    command_buffer: CommandBuffer,
    src_image: Image,
    src_image_layout: ImageLayout,
    dst_image: Image,
    dst_image_layout: ImageLayout,
    region_count: u32,
    p_regions: *const ImageBlit,
    filter: Filter,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdCopyBufferToImage = extern "system" fn(
    command_buffer: CommandBuffer,
    src_buffer: Buffer,
    dst_image: Image,
    dst_image_layout: ImageLayout,
    region_count: u32,
    p_regions: *const BufferImageCopy,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdCopyImageToBuffer = extern "system" fn(
    command_buffer: CommandBuffer,
    src_image: Image,
    src_image_layout: ImageLayout,
    dst_buffer: Buffer,
    region_count: u32,
    p_regions: *const BufferImageCopy,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdUpdateBuffer = extern "system" fn(
    command_buffer: CommandBuffer,
    dst_buffer: Buffer,
    dst_offset: DeviceSize,
    data_size: DeviceSize,
    p_data: *const c_void,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdFillBuffer = extern "system" fn(
    command_buffer: CommandBuffer,
    dst_buffer: Buffer,
    dst_offset: DeviceSize,
    size: DeviceSize,
    data: u32,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdClearColorImage = extern "system" fn(
    command_buffer: CommandBuffer,
    image: Image,
    image_layout: ImageLayout,
    p_color: *const ClearColorValue,
    range_count: u32,
    p_ranges: *const ImageSubresourceRange,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdClearDepthStencilImage = extern "system" fn(
    command_buffer: CommandBuffer,
    image: Image,
    image_layout: ImageLayout,
    p_depth_stencil: *const ClearDepthStencilValue,
    range_count: u32,
    p_ranges: *const ImageSubresourceRange,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdClearAttachments = extern "system" fn(
    command_buffer: CommandBuffer,
    attachment_count: u32,
    p_attachments: *const ClearAttachment,
    rect_count: u32,
    p_rects: *const ClearRect,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdResolveImage = extern "system" fn(
    command_buffer: CommandBuffer,
    src_image: Image,
    src_image_layout: ImageLayout,
    dst_image: Image,
    dst_image_layout: ImageLayout,
    region_count: u32,
    p_regions: *const ImageResolve,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdSetEvent = extern "system" fn(
    command_buffer: CommandBuffer,
    event: Event,
    stage_mask: PipelineStageFlags,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdResetEvent = extern "system" fn(
    command_buffer: CommandBuffer,
    event: Event,
    stage_mask: PipelineStageFlags,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdWaitEvents = extern "system" fn(
    command_buffer: CommandBuffer,
    event_count: u32,
    p_events: *const Event,
    src_stage_mask: PipelineStageFlags,
    dst_stage_mask: PipelineStageFlags,
    memory_barrier_count: u32,
    p_memory_barriers: *const MemoryBarrier,
    buffer_memory_barrier_count: u32,
    p_buffer_memory_barriers: *const BufferMemoryBarrier,
    image_memory_barrier_count: u32,
    p_image_memory_barriers: *const ImageMemoryBarrier,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdPipelineBarrier = extern "system" fn(
    command_buffer: CommandBuffer,
    src_stage_mask: PipelineStageFlags,
    dst_stage_mask: PipelineStageFlags,
    dependency_flags: DependencyFlags,
    memory_barrier_count: u32,
    p_memory_barriers: *const MemoryBarrier,
    buffer_memory_barrier_count: u32,
    p_buffer_memory_barriers: *const BufferMemoryBarrier,
    image_memory_barrier_count: u32,
    p_image_memory_barriers: *const ImageMemoryBarrier,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdBeginQuery = extern "system" fn(
    command_buffer: CommandBuffer,
    query_pool: QueryPool,
    query: u32,
    flags: QueryControlFlags,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdEndQuery =
    extern "system" fn(command_buffer: CommandBuffer, query_pool: QueryPool, query: u32) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdResetQueryPool = extern "system" fn(
    command_buffer: CommandBuffer,
    query_pool: QueryPool,
    first_query: u32,
    query_count: u32,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdWriteTimestamp = extern "system" fn(
    command_buffer: CommandBuffer,
    pipeline_stage: PipelineStageFlags,
    query_pool: QueryPool,
    query: u32,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdCopyQueryPoolResults = extern "system" fn(
    command_buffer: CommandBuffer,
    query_pool: QueryPool,
    first_query: u32,
    query_count: u32,
    dst_buffer: Buffer,
    dst_offset: DeviceSize,
    stride: DeviceSize,
    flags: QueryResultFlags,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdPushConstants = extern "system" fn(
    command_buffer: CommandBuffer,
    layout: PipelineLayout,
    stage_flags: ShaderStageFlags,
    offset: u32,
    size: u32,
    p_values: *const c_void,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdBeginRenderPass = extern "system" fn(
    command_buffer: CommandBuffer,
    p_render_pass_begin: *const RenderPassBeginInfo,
    contents: SubpassContents,
) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdNextSubpass =
    extern "system" fn(command_buffer: CommandBuffer, contents: SubpassContents) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdEndRenderPass = extern "system" fn(command_buffer: CommandBuffer) -> c_void;
#[allow(non_camel_case_types)]
pub type PFN_vkCmdExecuteCommands = extern "system" fn(
    command_buffer: CommandBuffer,
    command_buffer_count: u32,
    p_command_buffers: *const CommandBuffer,
) -> c_void;
pub struct DeviceFnV1_0 {
    pub destroy_device:
        extern "system" fn(device: Device, p_allocator: *const AllocationCallbacks) -> c_void,
    pub get_device_queue: extern "system" fn(
        device: Device,
        queue_family_index: u32,
        queue_index: u32,
        p_queue: *mut Queue,
    ) -> c_void,
    pub queue_submit: extern "system" fn(
        queue: Queue,
        submit_count: u32,
        p_submits: *const SubmitInfo,
        fence: Fence,
    ) -> Result,
    pub queue_wait_idle: extern "system" fn(queue: Queue) -> Result,
    pub device_wait_idle: extern "system" fn(device: Device) -> Result,
    pub allocate_memory: extern "system" fn(
        device: Device,
        p_allocate_info: *const MemoryAllocateInfo,
        p_allocator: *const AllocationCallbacks,
        p_memory: *mut DeviceMemory,
    ) -> Result,
    pub free_memory: extern "system" fn(
        device: Device,
        memory: DeviceMemory,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub map_memory: extern "system" fn(
        device: Device,
        memory: DeviceMemory,
        offset: DeviceSize,
        size: DeviceSize,
        flags: MemoryMapFlags,
        pp_data: *mut *mut c_void,
    ) -> Result,
    pub unmap_memory: extern "system" fn(device: Device, memory: DeviceMemory) -> c_void,
    pub flush_mapped_memory_ranges: extern "system" fn(
        device: Device,
        memory_range_count: u32,
        p_memory_ranges: *const MappedMemoryRange,
    ) -> Result,
    pub invalidate_mapped_memory_ranges: extern "system" fn(
        device: Device,
        memory_range_count: u32,
        p_memory_ranges: *const MappedMemoryRange,
    ) -> Result,
    pub get_device_memory_commitment: extern "system" fn(
        device: Device,
        memory: DeviceMemory,
        p_committed_memory_in_bytes: *mut DeviceSize,
    ) -> c_void,
    pub bind_buffer_memory: extern "system" fn(
        device: Device,
        buffer: Buffer,
        memory: DeviceMemory,
        memory_offset: DeviceSize,
    ) -> Result,
    pub bind_image_memory: extern "system" fn(
        device: Device,
        image: Image,
        memory: DeviceMemory,
        memory_offset: DeviceSize,
    ) -> Result,
    pub get_buffer_memory_requirements: extern "system" fn(
        device: Device,
        buffer: Buffer,
        p_memory_requirements: *mut MemoryRequirements,
    ) -> c_void,
    pub get_image_memory_requirements: extern "system" fn(
        device: Device,
        image: Image,
        p_memory_requirements: *mut MemoryRequirements,
    ) -> c_void,
    pub get_image_sparse_memory_requirements: extern "system" fn(
        device: Device,
        image: Image,
        p_sparse_memory_requirement_count: *mut u32,
        p_sparse_memory_requirements: *mut SparseImageMemoryRequirements,
    ) -> c_void,
    pub queue_bind_sparse: extern "system" fn(
        queue: Queue,
        bind_info_count: u32,
        p_bind_info: *const BindSparseInfo,
        fence: Fence,
    ) -> Result,
    pub create_fence: extern "system" fn(
        device: Device,
        p_create_info: *const FenceCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_fence: *mut Fence,
    ) -> Result,
    pub destroy_fence: extern "system" fn(
        device: Device,
        fence: Fence,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub reset_fences:
        extern "system" fn(device: Device, fence_count: u32, p_fences: *const Fence) -> Result,
    pub get_fence_status: extern "system" fn(device: Device, fence: Fence) -> Result,
    pub wait_for_fences: extern "system" fn(
        device: Device,
        fence_count: u32,
        p_fences: *const Fence,
        wait_all: Bool32,
        timeout: u64,
    ) -> Result,
    pub create_semaphore: extern "system" fn(
        device: Device,
        p_create_info: *const SemaphoreCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_semaphore: *mut Semaphore,
    ) -> Result,
    pub destroy_semaphore: extern "system" fn(
        device: Device,
        semaphore: Semaphore,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub create_event: extern "system" fn(
        device: Device,
        p_create_info: *const EventCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_event: *mut Event,
    ) -> Result,
    pub destroy_event: extern "system" fn(
        device: Device,
        event: Event,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub get_event_status: extern "system" fn(device: Device, event: Event) -> Result,
    pub set_event: extern "system" fn(device: Device, event: Event) -> Result,
    pub reset_event: extern "system" fn(device: Device, event: Event) -> Result,
    pub create_query_pool: extern "system" fn(
        device: Device,
        p_create_info: *const QueryPoolCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_query_pool: *mut QueryPool,
    ) -> Result,
    pub destroy_query_pool: extern "system" fn(
        device: Device,
        query_pool: QueryPool,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub get_query_pool_results: extern "system" fn(
        device: Device,
        query_pool: QueryPool,
        first_query: u32,
        query_count: u32,
        data_size: usize,
        p_data: *mut c_void,
        stride: DeviceSize,
        flags: QueryResultFlags,
    ) -> Result,
    pub create_buffer: extern "system" fn(
        device: Device,
        p_create_info: *const BufferCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_buffer: *mut Buffer,
    ) -> Result,
    pub destroy_buffer: extern "system" fn(
        device: Device,
        buffer: Buffer,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub create_buffer_view: extern "system" fn(
        device: Device,
        p_create_info: *const BufferViewCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_view: *mut BufferView,
    ) -> Result,
    pub destroy_buffer_view: extern "system" fn(
        device: Device,
        buffer_view: BufferView,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub create_image: extern "system" fn(
        device: Device,
        p_create_info: *const ImageCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_image: *mut Image,
    ) -> Result,
    pub destroy_image: extern "system" fn(
        device: Device,
        image: Image,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub get_image_subresource_layout: extern "system" fn(
        device: Device,
        image: Image,
        p_subresource: *const ImageSubresource,
        p_layout: *mut SubresourceLayout,
    ) -> c_void,
    pub create_image_view: extern "system" fn(
        device: Device,
        p_create_info: *const ImageViewCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_view: *mut ImageView,
    ) -> Result,
    pub destroy_image_view: extern "system" fn(
        device: Device,
        image_view: ImageView,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub create_shader_module: extern "system" fn(
        device: Device,
        p_create_info: *const ShaderModuleCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_shader_module: *mut ShaderModule,
    ) -> Result,
    pub destroy_shader_module: extern "system" fn(
        device: Device,
        shader_module: ShaderModule,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub create_pipeline_cache: extern "system" fn(
        device: Device,
        p_create_info: *const PipelineCacheCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_pipeline_cache: *mut PipelineCache,
    ) -> Result,
    pub destroy_pipeline_cache: extern "system" fn(
        device: Device,
        pipeline_cache: PipelineCache,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub get_pipeline_cache_data: extern "system" fn(
        device: Device,
        pipeline_cache: PipelineCache,
        p_data_size: *mut usize,
        p_data: *mut c_void,
    ) -> Result,
    pub merge_pipeline_caches: extern "system" fn(
        device: Device,
        dst_cache: PipelineCache,
        src_cache_count: u32,
        p_src_caches: *const PipelineCache,
    ) -> Result,
    pub create_graphics_pipelines: extern "system" fn(
        device: Device,
        pipeline_cache: PipelineCache,
        create_info_count: u32,
        p_create_infos: *const GraphicsPipelineCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_pipelines: *mut Pipeline,
    ) -> Result,
    pub create_compute_pipelines: extern "system" fn(
        device: Device,
        pipeline_cache: PipelineCache,
        create_info_count: u32,
        p_create_infos: *const ComputePipelineCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_pipelines: *mut Pipeline,
    ) -> Result,
    pub destroy_pipeline: extern "system" fn(
        device: Device,
        pipeline: Pipeline,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub create_pipeline_layout: extern "system" fn(
        device: Device,
        p_create_info: *const PipelineLayoutCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_pipeline_layout: *mut PipelineLayout,
    ) -> Result,
    pub destroy_pipeline_layout: extern "system" fn(
        device: Device,
        pipeline_layout: PipelineLayout,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub create_sampler: extern "system" fn(
        device: Device,
        p_create_info: *const SamplerCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_sampler: *mut Sampler,
    ) -> Result,
    pub destroy_sampler: extern "system" fn(
        device: Device,
        sampler: Sampler,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub create_descriptor_set_layout: extern "system" fn(
        device: Device,
        p_create_info: *const DescriptorSetLayoutCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_set_layout: *mut DescriptorSetLayout,
    ) -> Result,
    pub destroy_descriptor_set_layout: extern "system" fn(
        device: Device,
        descriptor_set_layout: DescriptorSetLayout,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub create_descriptor_pool: extern "system" fn(
        device: Device,
        p_create_info: *const DescriptorPoolCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_descriptor_pool: *mut DescriptorPool,
    ) -> Result,
    pub destroy_descriptor_pool: extern "system" fn(
        device: Device,
        descriptor_pool: DescriptorPool,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub reset_descriptor_pool: extern "system" fn(
        device: Device,
        descriptor_pool: DescriptorPool,
        flags: DescriptorPoolResetFlags,
    ) -> Result,
    pub allocate_descriptor_sets: extern "system" fn(
        device: Device,
        p_allocate_info: *const DescriptorSetAllocateInfo,
        p_descriptor_sets: *mut DescriptorSet,
    ) -> Result,
    pub free_descriptor_sets: extern "system" fn(
        device: Device,
        descriptor_pool: DescriptorPool,
        descriptor_set_count: u32,
        p_descriptor_sets: *const DescriptorSet,
    ) -> Result,
    pub update_descriptor_sets: extern "system" fn(
        device: Device,
        descriptor_write_count: u32,
        p_descriptor_writes: *const WriteDescriptorSet,
        descriptor_copy_count: u32,
        p_descriptor_copies: *const CopyDescriptorSet,
    ) -> c_void,
    pub create_framebuffer: extern "system" fn(
        device: Device,
        p_create_info: *const FramebufferCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_framebuffer: *mut Framebuffer,
    ) -> Result,
    pub destroy_framebuffer: extern "system" fn(
        device: Device,
        framebuffer: Framebuffer,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub create_render_pass: extern "system" fn(
        device: Device,
        p_create_info: *const RenderPassCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_render_pass: *mut RenderPass,
    ) -> Result,
    pub destroy_render_pass: extern "system" fn(
        device: Device,
        render_pass: RenderPass,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub get_render_area_granularity: extern "system" fn(
        device: Device,
        render_pass: RenderPass,
        p_granularity: *mut Extent2D,
    ) -> c_void,
    pub create_command_pool: extern "system" fn(
        device: Device,
        p_create_info: *const CommandPoolCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_command_pool: *mut CommandPool,
    ) -> Result,
    pub destroy_command_pool: extern "system" fn(
        device: Device,
        command_pool: CommandPool,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub reset_command_pool: extern "system" fn(
        device: Device,
        command_pool: CommandPool,
        flags: CommandPoolResetFlags,
    ) -> Result,
    pub allocate_command_buffers: extern "system" fn(
        device: Device,
        p_allocate_info: *const CommandBufferAllocateInfo,
        p_command_buffers: *mut CommandBuffer,
    ) -> Result,
    pub free_command_buffers: extern "system" fn(
        device: Device,
        command_pool: CommandPool,
        command_buffer_count: u32,
        p_command_buffers: *const CommandBuffer,
    ) -> c_void,
    pub begin_command_buffer: extern "system" fn(
        command_buffer: CommandBuffer,
        p_begin_info: *const CommandBufferBeginInfo,
    ) -> Result,
    pub end_command_buffer: extern "system" fn(command_buffer: CommandBuffer) -> Result,
    pub reset_command_buffer:
        extern "system" fn(command_buffer: CommandBuffer, flags: CommandBufferResetFlags) -> Result,
    pub cmd_bind_pipeline: extern "system" fn(
        command_buffer: CommandBuffer,
        pipeline_bind_point: PipelineBindPoint,
        pipeline: Pipeline,
    ) -> c_void,
    pub cmd_set_viewport: extern "system" fn(
        command_buffer: CommandBuffer,
        first_viewport: u32,
        viewport_count: u32,
        p_viewports: *const Viewport,
    ) -> c_void,
    pub cmd_set_scissor: extern "system" fn(
        command_buffer: CommandBuffer,
        first_scissor: u32,
        scissor_count: u32,
        p_scissors: *const Rect2D,
    ) -> c_void,
    pub cmd_set_line_width:
        extern "system" fn(command_buffer: CommandBuffer, line_width: f32) -> c_void,
    pub cmd_set_depth_bias: extern "system" fn(
        command_buffer: CommandBuffer,
        depth_bias_constant_factor: f32,
        depth_bias_clamp: f32,
        depth_bias_slope_factor: f32,
    ) -> c_void,
    pub cmd_set_blend_constants:
        extern "system" fn(command_buffer: CommandBuffer, blend_constants: &[f32; 4]) -> c_void,
    pub cmd_set_depth_bounds: extern "system" fn(
        command_buffer: CommandBuffer,
        min_depth_bounds: f32,
        max_depth_bounds: f32,
    ) -> c_void,
    pub cmd_set_stencil_compare_mask: extern "system" fn(
        command_buffer: CommandBuffer,
        face_mask: StencilFaceFlags,
        compare_mask: u32,
    ) -> c_void,
    pub cmd_set_stencil_write_mask: extern "system" fn(
        command_buffer: CommandBuffer,
        face_mask: StencilFaceFlags,
        write_mask: u32,
    ) -> c_void,
    pub cmd_set_stencil_reference: extern "system" fn(
        command_buffer: CommandBuffer,
        face_mask: StencilFaceFlags,
        reference: u32,
    ) -> c_void,
    pub cmd_bind_descriptor_sets: extern "system" fn(
        command_buffer: CommandBuffer,
        pipeline_bind_point: PipelineBindPoint,
        layout: PipelineLayout,
        first_set: u32,
        descriptor_set_count: u32,
        p_descriptor_sets: *const DescriptorSet,
        dynamic_offset_count: u32,
        p_dynamic_offsets: *const u32,
    ) -> c_void,
    pub cmd_bind_index_buffer: extern "system" fn(
        command_buffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        index_type: IndexType,
    ) -> c_void,
    pub cmd_bind_vertex_buffers: extern "system" fn(
        command_buffer: CommandBuffer,
        first_binding: u32,
        binding_count: u32,
        p_buffers: *const Buffer,
        p_offsets: *const DeviceSize,
    ) -> c_void,
    pub cmd_draw: extern "system" fn(
        command_buffer: CommandBuffer,
        vertex_count: u32,
        instance_count: u32,
        first_vertex: u32,
        first_instance: u32,
    ) -> c_void,
    pub cmd_draw_indexed: extern "system" fn(
        command_buffer: CommandBuffer,
        index_count: u32,
        instance_count: u32,
        first_index: u32,
        vertex_offset: i32,
        first_instance: u32,
    ) -> c_void,
    pub cmd_draw_indirect: extern "system" fn(
        command_buffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        draw_count: u32,
        stride: u32,
    ) -> c_void,
    pub cmd_draw_indexed_indirect: extern "system" fn(
        command_buffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        draw_count: u32,
        stride: u32,
    ) -> c_void,
    pub cmd_dispatch: extern "system" fn(
        command_buffer: CommandBuffer,
        group_count_x: u32,
        group_count_y: u32,
        group_count_z: u32,
    ) -> c_void,
    pub cmd_dispatch_indirect: extern "system" fn(
        command_buffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
    ) -> c_void,
    pub cmd_copy_buffer: extern "system" fn(
        command_buffer: CommandBuffer,
        src_buffer: Buffer,
        dst_buffer: Buffer,
        region_count: u32,
        p_regions: *const BufferCopy,
    ) -> c_void,
    pub cmd_copy_image: extern "system" fn(
        command_buffer: CommandBuffer,
        src_image: Image,
        src_image_layout: ImageLayout,
        dst_image: Image,
        dst_image_layout: ImageLayout,
        region_count: u32,
        p_regions: *const ImageCopy,
    ) -> c_void,
    pub cmd_blit_image: extern "system" fn(
        command_buffer: CommandBuffer,
        src_image: Image,
        src_image_layout: ImageLayout,
        dst_image: Image,
        dst_image_layout: ImageLayout,
        region_count: u32,
        p_regions: *const ImageBlit,
        filter: Filter,
    ) -> c_void,
    pub cmd_copy_buffer_to_image: extern "system" fn(
        command_buffer: CommandBuffer,
        src_buffer: Buffer,
        dst_image: Image,
        dst_image_layout: ImageLayout,
        region_count: u32,
        p_regions: *const BufferImageCopy,
    ) -> c_void,
    pub cmd_copy_image_to_buffer: extern "system" fn(
        command_buffer: CommandBuffer,
        src_image: Image,
        src_image_layout: ImageLayout,
        dst_buffer: Buffer,
        region_count: u32,
        p_regions: *const BufferImageCopy,
    ) -> c_void,
    pub cmd_update_buffer: extern "system" fn(
        command_buffer: CommandBuffer,
        dst_buffer: Buffer,
        dst_offset: DeviceSize,
        data_size: DeviceSize,
        p_data: *const c_void,
    ) -> c_void,
    pub cmd_fill_buffer: extern "system" fn(
        command_buffer: CommandBuffer,
        dst_buffer: Buffer,
        dst_offset: DeviceSize,
        size: DeviceSize,
        data: u32,
    ) -> c_void,
    pub cmd_clear_color_image: extern "system" fn(
        command_buffer: CommandBuffer,
        image: Image,
        image_layout: ImageLayout,
        p_color: *const ClearColorValue,
        range_count: u32,
        p_ranges: *const ImageSubresourceRange,
    ) -> c_void,
    pub cmd_clear_depth_stencil_image: extern "system" fn(
        command_buffer: CommandBuffer,
        image: Image,
        image_layout: ImageLayout,
        p_depth_stencil: *const ClearDepthStencilValue,
        range_count: u32,
        p_ranges: *const ImageSubresourceRange,
    ) -> c_void,
    pub cmd_clear_attachments: extern "system" fn(
        command_buffer: CommandBuffer,
        attachment_count: u32,
        p_attachments: *const ClearAttachment,
        rect_count: u32,
        p_rects: *const ClearRect,
    ) -> c_void,
    pub cmd_resolve_image: extern "system" fn(
        command_buffer: CommandBuffer,
        src_image: Image,
        src_image_layout: ImageLayout,
        dst_image: Image,
        dst_image_layout: ImageLayout,
        region_count: u32,
        p_regions: *const ImageResolve,
    ) -> c_void,
    pub cmd_set_event: extern "system" fn(
        command_buffer: CommandBuffer,
        event: Event,
        stage_mask: PipelineStageFlags,
    ) -> c_void,
    pub cmd_reset_event: extern "system" fn(
        command_buffer: CommandBuffer,
        event: Event,
        stage_mask: PipelineStageFlags,
    ) -> c_void,
    pub cmd_wait_events: extern "system" fn(
        command_buffer: CommandBuffer,
        event_count: u32,
        p_events: *const Event,
        src_stage_mask: PipelineStageFlags,
        dst_stage_mask: PipelineStageFlags,
        memory_barrier_count: u32,
        p_memory_barriers: *const MemoryBarrier,
        buffer_memory_barrier_count: u32,
        p_buffer_memory_barriers: *const BufferMemoryBarrier,
        image_memory_barrier_count: u32,
        p_image_memory_barriers: *const ImageMemoryBarrier,
    ) -> c_void,
    pub cmd_pipeline_barrier: extern "system" fn(
        command_buffer: CommandBuffer,
        src_stage_mask: PipelineStageFlags,
        dst_stage_mask: PipelineStageFlags,
        dependency_flags: DependencyFlags,
        memory_barrier_count: u32,
        p_memory_barriers: *const MemoryBarrier,
        buffer_memory_barrier_count: u32,
        p_buffer_memory_barriers: *const BufferMemoryBarrier,
        image_memory_barrier_count: u32,
        p_image_memory_barriers: *const ImageMemoryBarrier,
    ) -> c_void,
    pub cmd_begin_query: extern "system" fn(
        command_buffer: CommandBuffer,
        query_pool: QueryPool,
        query: u32,
        flags: QueryControlFlags,
    ) -> c_void,
    pub cmd_end_query: extern "system" fn(
        command_buffer: CommandBuffer,
        query_pool: QueryPool,
        query: u32,
    ) -> c_void,
    pub cmd_reset_query_pool: extern "system" fn(
        command_buffer: CommandBuffer,
        query_pool: QueryPool,
        first_query: u32,
        query_count: u32,
    ) -> c_void,
    pub cmd_write_timestamp: extern "system" fn(
        command_buffer: CommandBuffer,
        pipeline_stage: PipelineStageFlags,
        query_pool: QueryPool,
        query: u32,
    ) -> c_void,
    pub cmd_copy_query_pool_results: extern "system" fn(
        command_buffer: CommandBuffer,
        query_pool: QueryPool,
        first_query: u32,
        query_count: u32,
        dst_buffer: Buffer,
        dst_offset: DeviceSize,
        stride: DeviceSize,
        flags: QueryResultFlags,
    ) -> c_void,
    pub cmd_push_constants: extern "system" fn(
        command_buffer: CommandBuffer,
        layout: PipelineLayout,
        stage_flags: ShaderStageFlags,
        offset: u32,
        size: u32,
        p_values: *const c_void,
    ) -> c_void,
    pub cmd_begin_render_pass: extern "system" fn(
        command_buffer: CommandBuffer,
        p_render_pass_begin: *const RenderPassBeginInfo,
        contents: SubpassContents,
    ) -> c_void,
    pub cmd_next_subpass:
        extern "system" fn(command_buffer: CommandBuffer, contents: SubpassContents) -> c_void,
    pub cmd_end_render_pass: extern "system" fn(command_buffer: CommandBuffer) -> c_void,
    pub cmd_execute_commands: extern "system" fn(
        command_buffer: CommandBuffer,
        command_buffer_count: u32,
        p_command_buffers: *const CommandBuffer,
    ) -> c_void,
}
unsafe impl Send for DeviceFnV1_0 {}
unsafe impl Sync for DeviceFnV1_0 {}
impl ::std::clone::Clone for DeviceFnV1_0 {
    fn clone(&self) -> Self {
        DeviceFnV1_0 {
            destroy_device: self.destroy_device,
            get_device_queue: self.get_device_queue,
            queue_submit: self.queue_submit,
            queue_wait_idle: self.queue_wait_idle,
            device_wait_idle: self.device_wait_idle,
            allocate_memory: self.allocate_memory,
            free_memory: self.free_memory,
            map_memory: self.map_memory,
            unmap_memory: self.unmap_memory,
            flush_mapped_memory_ranges: self.flush_mapped_memory_ranges,
            invalidate_mapped_memory_ranges: self.invalidate_mapped_memory_ranges,
            get_device_memory_commitment: self.get_device_memory_commitment,
            bind_buffer_memory: self.bind_buffer_memory,
            bind_image_memory: self.bind_image_memory,
            get_buffer_memory_requirements: self.get_buffer_memory_requirements,
            get_image_memory_requirements: self.get_image_memory_requirements,
            get_image_sparse_memory_requirements: self.get_image_sparse_memory_requirements,
            queue_bind_sparse: self.queue_bind_sparse,
            create_fence: self.create_fence,
            destroy_fence: self.destroy_fence,
            reset_fences: self.reset_fences,
            get_fence_status: self.get_fence_status,
            wait_for_fences: self.wait_for_fences,
            create_semaphore: self.create_semaphore,
            destroy_semaphore: self.destroy_semaphore,
            create_event: self.create_event,
            destroy_event: self.destroy_event,
            get_event_status: self.get_event_status,
            set_event: self.set_event,
            reset_event: self.reset_event,
            create_query_pool: self.create_query_pool,
            destroy_query_pool: self.destroy_query_pool,
            get_query_pool_results: self.get_query_pool_results,
            create_buffer: self.create_buffer,
            destroy_buffer: self.destroy_buffer,
            create_buffer_view: self.create_buffer_view,
            destroy_buffer_view: self.destroy_buffer_view,
            create_image: self.create_image,
            destroy_image: self.destroy_image,
            get_image_subresource_layout: self.get_image_subresource_layout,
            create_image_view: self.create_image_view,
            destroy_image_view: self.destroy_image_view,
            create_shader_module: self.create_shader_module,
            destroy_shader_module: self.destroy_shader_module,
            create_pipeline_cache: self.create_pipeline_cache,
            destroy_pipeline_cache: self.destroy_pipeline_cache,
            get_pipeline_cache_data: self.get_pipeline_cache_data,
            merge_pipeline_caches: self.merge_pipeline_caches,
            create_graphics_pipelines: self.create_graphics_pipelines,
            create_compute_pipelines: self.create_compute_pipelines,
            destroy_pipeline: self.destroy_pipeline,
            create_pipeline_layout: self.create_pipeline_layout,
            destroy_pipeline_layout: self.destroy_pipeline_layout,
            create_sampler: self.create_sampler,
            destroy_sampler: self.destroy_sampler,
            create_descriptor_set_layout: self.create_descriptor_set_layout,
            destroy_descriptor_set_layout: self.destroy_descriptor_set_layout,
            create_descriptor_pool: self.create_descriptor_pool,
            destroy_descriptor_pool: self.destroy_descriptor_pool,
            reset_descriptor_pool: self.reset_descriptor_pool,
            allocate_descriptor_sets: self.allocate_descriptor_sets,
            free_descriptor_sets: self.free_descriptor_sets,
            update_descriptor_sets: self.update_descriptor_sets,
            create_framebuffer: self.create_framebuffer,
            destroy_framebuffer: self.destroy_framebuffer,
            create_render_pass: self.create_render_pass,
            destroy_render_pass: self.destroy_render_pass,
            get_render_area_granularity: self.get_render_area_granularity,
            create_command_pool: self.create_command_pool,
            destroy_command_pool: self.destroy_command_pool,
            reset_command_pool: self.reset_command_pool,
            allocate_command_buffers: self.allocate_command_buffers,
            free_command_buffers: self.free_command_buffers,
            begin_command_buffer: self.begin_command_buffer,
            end_command_buffer: self.end_command_buffer,
            reset_command_buffer: self.reset_command_buffer,
            cmd_bind_pipeline: self.cmd_bind_pipeline,
            cmd_set_viewport: self.cmd_set_viewport,
            cmd_set_scissor: self.cmd_set_scissor,
            cmd_set_line_width: self.cmd_set_line_width,
            cmd_set_depth_bias: self.cmd_set_depth_bias,
            cmd_set_blend_constants: self.cmd_set_blend_constants,
            cmd_set_depth_bounds: self.cmd_set_depth_bounds,
            cmd_set_stencil_compare_mask: self.cmd_set_stencil_compare_mask,
            cmd_set_stencil_write_mask: self.cmd_set_stencil_write_mask,
            cmd_set_stencil_reference: self.cmd_set_stencil_reference,
            cmd_bind_descriptor_sets: self.cmd_bind_descriptor_sets,
            cmd_bind_index_buffer: self.cmd_bind_index_buffer,
            cmd_bind_vertex_buffers: self.cmd_bind_vertex_buffers,
            cmd_draw: self.cmd_draw,
            cmd_draw_indexed: self.cmd_draw_indexed,
            cmd_draw_indirect: self.cmd_draw_indirect,
            cmd_draw_indexed_indirect: self.cmd_draw_indexed_indirect,
            cmd_dispatch: self.cmd_dispatch,
            cmd_dispatch_indirect: self.cmd_dispatch_indirect,
            cmd_copy_buffer: self.cmd_copy_buffer,
            cmd_copy_image: self.cmd_copy_image,
            cmd_blit_image: self.cmd_blit_image,
            cmd_copy_buffer_to_image: self.cmd_copy_buffer_to_image,
            cmd_copy_image_to_buffer: self.cmd_copy_image_to_buffer,
            cmd_update_buffer: self.cmd_update_buffer,
            cmd_fill_buffer: self.cmd_fill_buffer,
            cmd_clear_color_image: self.cmd_clear_color_image,
            cmd_clear_depth_stencil_image: self.cmd_clear_depth_stencil_image,
            cmd_clear_attachments: self.cmd_clear_attachments,
            cmd_resolve_image: self.cmd_resolve_image,
            cmd_set_event: self.cmd_set_event,
            cmd_reset_event: self.cmd_reset_event,
            cmd_wait_events: self.cmd_wait_events,
            cmd_pipeline_barrier: self.cmd_pipeline_barrier,
            cmd_begin_query: self.cmd_begin_query,
            cmd_end_query: self.cmd_end_query,
            cmd_reset_query_pool: self.cmd_reset_query_pool,
            cmd_write_timestamp: self.cmd_write_timestamp,
            cmd_copy_query_pool_results: self.cmd_copy_query_pool_results,
            cmd_push_constants: self.cmd_push_constants,
            cmd_begin_render_pass: self.cmd_begin_render_pass,
            cmd_next_subpass: self.cmd_next_subpass,
            cmd_end_render_pass: self.cmd_end_render_pass,
            cmd_execute_commands: self.cmd_execute_commands,
        }
    }
}
impl DeviceFnV1_0 {
    pub fn load<F>(mut _f: F) -> Self
    where
        F: FnMut(&::std::ffi::CStr) -> *const c_void,
    {
        DeviceFnV1_0 {
            destroy_device: unsafe {
                extern "system" fn destroy_device(
                    _device: Device,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(destroy_device)))
                }
                let raw_name = stringify!(vkDestroyDevice);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_device
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_device_queue: unsafe {
                extern "system" fn get_device_queue(
                    _device: Device,
                    _queue_family_index: u32,
                    _queue_index: u32,
                    _p_queue: *mut Queue,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(get_device_queue)))
                }
                let raw_name = stringify!(vkGetDeviceQueue);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_device_queue
                } else {
                    ::std::mem::transmute(val)
                }
            },
            queue_submit: unsafe {
                extern "system" fn queue_submit(
                    _queue: Queue,
                    _submit_count: u32,
                    _p_submits: *const SubmitInfo,
                    _fence: Fence,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(queue_submit)))
                }
                let raw_name = stringify!(vkQueueSubmit);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    queue_submit
                } else {
                    ::std::mem::transmute(val)
                }
            },
            queue_wait_idle: unsafe {
                extern "system" fn queue_wait_idle(_queue: Queue) -> Result {
                    panic!(concat!("Unable to load ", stringify!(queue_wait_idle)))
                }
                let raw_name = stringify!(vkQueueWaitIdle);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    queue_wait_idle
                } else {
                    ::std::mem::transmute(val)
                }
            },
            device_wait_idle: unsafe {
                extern "system" fn device_wait_idle(_device: Device) -> Result {
                    panic!(concat!("Unable to load ", stringify!(device_wait_idle)))
                }
                let raw_name = stringify!(vkDeviceWaitIdle);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    device_wait_idle
                } else {
                    ::std::mem::transmute(val)
                }
            },
            allocate_memory: unsafe {
                extern "system" fn allocate_memory(
                    _device: Device,
                    _p_allocate_info: *const MemoryAllocateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_memory: *mut DeviceMemory,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(allocate_memory)))
                }
                let raw_name = stringify!(vkAllocateMemory);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    allocate_memory
                } else {
                    ::std::mem::transmute(val)
                }
            },
            free_memory: unsafe {
                extern "system" fn free_memory(
                    _device: Device,
                    _memory: DeviceMemory,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(free_memory)))
                }
                let raw_name = stringify!(vkFreeMemory);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    free_memory
                } else {
                    ::std::mem::transmute(val)
                }
            },
            map_memory: unsafe {
                extern "system" fn map_memory(
                    _device: Device,
                    _memory: DeviceMemory,
                    _offset: DeviceSize,
                    _size: DeviceSize,
                    _flags: MemoryMapFlags,
                    _pp_data: *mut *mut c_void,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(map_memory)))
                }
                let raw_name = stringify!(vkMapMemory);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    map_memory
                } else {
                    ::std::mem::transmute(val)
                }
            },
            unmap_memory: unsafe {
                extern "system" fn unmap_memory(_device: Device, _memory: DeviceMemory) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(unmap_memory)))
                }
                let raw_name = stringify!(vkUnmapMemory);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    unmap_memory
                } else {
                    ::std::mem::transmute(val)
                }
            },
            flush_mapped_memory_ranges: unsafe {
                extern "system" fn flush_mapped_memory_ranges(
                    _device: Device,
                    _memory_range_count: u32,
                    _p_memory_ranges: *const MappedMemoryRange,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(flush_mapped_memory_ranges)
                    ))
                }
                let raw_name = stringify!(vkFlushMappedMemoryRanges);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    flush_mapped_memory_ranges
                } else {
                    ::std::mem::transmute(val)
                }
            },
            invalidate_mapped_memory_ranges: unsafe {
                extern "system" fn invalidate_mapped_memory_ranges(
                    _device: Device,
                    _memory_range_count: u32,
                    _p_memory_ranges: *const MappedMemoryRange,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(invalidate_mapped_memory_ranges)
                    ))
                }
                let raw_name = stringify!(vkInvalidateMappedMemoryRanges);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    invalidate_mapped_memory_ranges
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_device_memory_commitment: unsafe {
                extern "system" fn get_device_memory_commitment(
                    _device: Device,
                    _memory: DeviceMemory,
                    _p_committed_memory_in_bytes: *mut DeviceSize,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_device_memory_commitment)
                    ))
                }
                let raw_name = stringify!(vkGetDeviceMemoryCommitment);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_device_memory_commitment
                } else {
                    ::std::mem::transmute(val)
                }
            },
            bind_buffer_memory: unsafe {
                extern "system" fn bind_buffer_memory(
                    _device: Device,
                    _buffer: Buffer,
                    _memory: DeviceMemory,
                    _memory_offset: DeviceSize,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(bind_buffer_memory)))
                }
                let raw_name = stringify!(vkBindBufferMemory);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    bind_buffer_memory
                } else {
                    ::std::mem::transmute(val)
                }
            },
            bind_image_memory: unsafe {
                extern "system" fn bind_image_memory(
                    _device: Device,
                    _image: Image,
                    _memory: DeviceMemory,
                    _memory_offset: DeviceSize,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(bind_image_memory)))
                }
                let raw_name = stringify!(vkBindImageMemory);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    bind_image_memory
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_buffer_memory_requirements: unsafe {
                extern "system" fn get_buffer_memory_requirements(
                    _device: Device,
                    _buffer: Buffer,
                    _p_memory_requirements: *mut MemoryRequirements,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_buffer_memory_requirements)
                    ))
                }
                let raw_name = stringify!(vkGetBufferMemoryRequirements);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_buffer_memory_requirements
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_image_memory_requirements: unsafe {
                extern "system" fn get_image_memory_requirements(
                    _device: Device,
                    _image: Image,
                    _p_memory_requirements: *mut MemoryRequirements,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_image_memory_requirements)
                    ))
                }
                let raw_name = stringify!(vkGetImageMemoryRequirements);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_image_memory_requirements
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_image_sparse_memory_requirements: unsafe {
                extern "system" fn get_image_sparse_memory_requirements(
                    _device: Device,
                    _image: Image,
                    _p_sparse_memory_requirement_count: *mut u32,
                    _p_sparse_memory_requirements: *mut SparseImageMemoryRequirements,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_image_sparse_memory_requirements)
                    ))
                }
                let raw_name = stringify!(vkGetImageSparseMemoryRequirements);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_image_sparse_memory_requirements
                } else {
                    ::std::mem::transmute(val)
                }
            },
            queue_bind_sparse: unsafe {
                extern "system" fn queue_bind_sparse(
                    _queue: Queue,
                    _bind_info_count: u32,
                    _p_bind_info: *const BindSparseInfo,
                    _fence: Fence,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(queue_bind_sparse)))
                }
                let raw_name = stringify!(vkQueueBindSparse);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    queue_bind_sparse
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_fence: unsafe {
                extern "system" fn create_fence(
                    _device: Device,
                    _p_create_info: *const FenceCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_fence: *mut Fence,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(create_fence)))
                }
                let raw_name = stringify!(vkCreateFence);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_fence
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_fence: unsafe {
                extern "system" fn destroy_fence(
                    _device: Device,
                    _fence: Fence,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(destroy_fence)))
                }
                let raw_name = stringify!(vkDestroyFence);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_fence
                } else {
                    ::std::mem::transmute(val)
                }
            },
            reset_fences: unsafe {
                extern "system" fn reset_fences(
                    _device: Device,
                    _fence_count: u32,
                    _p_fences: *const Fence,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(reset_fences)))
                }
                let raw_name = stringify!(vkResetFences);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    reset_fences
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_fence_status: unsafe {
                extern "system" fn get_fence_status(_device: Device, _fence: Fence) -> Result {
                    panic!(concat!("Unable to load ", stringify!(get_fence_status)))
                }
                let raw_name = stringify!(vkGetFenceStatus);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_fence_status
                } else {
                    ::std::mem::transmute(val)
                }
            },
            wait_for_fences: unsafe {
                extern "system" fn wait_for_fences(
                    _device: Device,
                    _fence_count: u32,
                    _p_fences: *const Fence,
                    _wait_all: Bool32,
                    _timeout: u64,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(wait_for_fences)))
                }
                let raw_name = stringify!(vkWaitForFences);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    wait_for_fences
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_semaphore: unsafe {
                extern "system" fn create_semaphore(
                    _device: Device,
                    _p_create_info: *const SemaphoreCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_semaphore: *mut Semaphore,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(create_semaphore)))
                }
                let raw_name = stringify!(vkCreateSemaphore);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_semaphore
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_semaphore: unsafe {
                extern "system" fn destroy_semaphore(
                    _device: Device,
                    _semaphore: Semaphore,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(destroy_semaphore)))
                }
                let raw_name = stringify!(vkDestroySemaphore);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_semaphore
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_event: unsafe {
                extern "system" fn create_event(
                    _device: Device,
                    _p_create_info: *const EventCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_event: *mut Event,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(create_event)))
                }
                let raw_name = stringify!(vkCreateEvent);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_event
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_event: unsafe {
                extern "system" fn destroy_event(
                    _device: Device,
                    _event: Event,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(destroy_event)))
                }
                let raw_name = stringify!(vkDestroyEvent);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_event
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_event_status: unsafe {
                extern "system" fn get_event_status(_device: Device, _event: Event) -> Result {
                    panic!(concat!("Unable to load ", stringify!(get_event_status)))
                }
                let raw_name = stringify!(vkGetEventStatus);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_event_status
                } else {
                    ::std::mem::transmute(val)
                }
            },
            set_event: unsafe {
                extern "system" fn set_event(_device: Device, _event: Event) -> Result {
                    panic!(concat!("Unable to load ", stringify!(set_event)))
                }
                let raw_name = stringify!(vkSetEvent);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    set_event
                } else {
                    ::std::mem::transmute(val)
                }
            },
            reset_event: unsafe {
                extern "system" fn reset_event(_device: Device, _event: Event) -> Result {
                    panic!(concat!("Unable to load ", stringify!(reset_event)))
                }
                let raw_name = stringify!(vkResetEvent);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    reset_event
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_query_pool: unsafe {
                extern "system" fn create_query_pool(
                    _device: Device,
                    _p_create_info: *const QueryPoolCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_query_pool: *mut QueryPool,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(create_query_pool)))
                }
                let raw_name = stringify!(vkCreateQueryPool);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_query_pool
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_query_pool: unsafe {
                extern "system" fn destroy_query_pool(
                    _device: Device,
                    _query_pool: QueryPool,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(destroy_query_pool)))
                }
                let raw_name = stringify!(vkDestroyQueryPool);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_query_pool
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_query_pool_results: unsafe {
                extern "system" fn get_query_pool_results(
                    _device: Device,
                    _query_pool: QueryPool,
                    _first_query: u32,
                    _query_count: u32,
                    _data_size: usize,
                    _p_data: *mut c_void,
                    _stride: DeviceSize,
                    _flags: QueryResultFlags,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_query_pool_results)
                    ))
                }
                let raw_name = stringify!(vkGetQueryPoolResults);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_query_pool_results
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_buffer: unsafe {
                extern "system" fn create_buffer(
                    _device: Device,
                    _p_create_info: *const BufferCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_buffer: *mut Buffer,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(create_buffer)))
                }
                let raw_name = stringify!(vkCreateBuffer);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_buffer
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_buffer: unsafe {
                extern "system" fn destroy_buffer(
                    _device: Device,
                    _buffer: Buffer,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(destroy_buffer)))
                }
                let raw_name = stringify!(vkDestroyBuffer);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_buffer
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_buffer_view: unsafe {
                extern "system" fn create_buffer_view(
                    _device: Device,
                    _p_create_info: *const BufferViewCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_view: *mut BufferView,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(create_buffer_view)))
                }
                let raw_name = stringify!(vkCreateBufferView);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_buffer_view
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_buffer_view: unsafe {
                extern "system" fn destroy_buffer_view(
                    _device: Device,
                    _buffer_view: BufferView,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(destroy_buffer_view)))
                }
                let raw_name = stringify!(vkDestroyBufferView);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_buffer_view
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_image: unsafe {
                extern "system" fn create_image(
                    _device: Device,
                    _p_create_info: *const ImageCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_image: *mut Image,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(create_image)))
                }
                let raw_name = stringify!(vkCreateImage);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_image
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_image: unsafe {
                extern "system" fn destroy_image(
                    _device: Device,
                    _image: Image,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(destroy_image)))
                }
                let raw_name = stringify!(vkDestroyImage);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_image
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_image_subresource_layout: unsafe {
                extern "system" fn get_image_subresource_layout(
                    _device: Device,
                    _image: Image,
                    _p_subresource: *const ImageSubresource,
                    _p_layout: *mut SubresourceLayout,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_image_subresource_layout)
                    ))
                }
                let raw_name = stringify!(vkGetImageSubresourceLayout);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_image_subresource_layout
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_image_view: unsafe {
                extern "system" fn create_image_view(
                    _device: Device,
                    _p_create_info: *const ImageViewCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_view: *mut ImageView,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(create_image_view)))
                }
                let raw_name = stringify!(vkCreateImageView);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_image_view
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_image_view: unsafe {
                extern "system" fn destroy_image_view(
                    _device: Device,
                    _image_view: ImageView,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(destroy_image_view)))
                }
                let raw_name = stringify!(vkDestroyImageView);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_image_view
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_shader_module: unsafe {
                extern "system" fn create_shader_module(
                    _device: Device,
                    _p_create_info: *const ShaderModuleCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_shader_module: *mut ShaderModule,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(create_shader_module)))
                }
                let raw_name = stringify!(vkCreateShaderModule);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_shader_module
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_shader_module: unsafe {
                extern "system" fn destroy_shader_module(
                    _device: Device,
                    _shader_module: ShaderModule,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(destroy_shader_module)
                    ))
                }
                let raw_name = stringify!(vkDestroyShaderModule);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_shader_module
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_pipeline_cache: unsafe {
                extern "system" fn create_pipeline_cache(
                    _device: Device,
                    _p_create_info: *const PipelineCacheCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_pipeline_cache: *mut PipelineCache,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(create_pipeline_cache)
                    ))
                }
                let raw_name = stringify!(vkCreatePipelineCache);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_pipeline_cache
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_pipeline_cache: unsafe {
                extern "system" fn destroy_pipeline_cache(
                    _device: Device,
                    _pipeline_cache: PipelineCache,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(destroy_pipeline_cache)
                    ))
                }
                let raw_name = stringify!(vkDestroyPipelineCache);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_pipeline_cache
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_pipeline_cache_data: unsafe {
                extern "system" fn get_pipeline_cache_data(
                    _device: Device,
                    _pipeline_cache: PipelineCache,
                    _p_data_size: *mut usize,
                    _p_data: *mut c_void,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_pipeline_cache_data)
                    ))
                }
                let raw_name = stringify!(vkGetPipelineCacheData);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_pipeline_cache_data
                } else {
                    ::std::mem::transmute(val)
                }
            },
            merge_pipeline_caches: unsafe {
                extern "system" fn merge_pipeline_caches(
                    _device: Device,
                    _dst_cache: PipelineCache,
                    _src_cache_count: u32,
                    _p_src_caches: *const PipelineCache,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(merge_pipeline_caches)
                    ))
                }
                let raw_name = stringify!(vkMergePipelineCaches);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    merge_pipeline_caches
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_graphics_pipelines: unsafe {
                extern "system" fn create_graphics_pipelines(
                    _device: Device,
                    _pipeline_cache: PipelineCache,
                    _create_info_count: u32,
                    _p_create_infos: *const GraphicsPipelineCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_pipelines: *mut Pipeline,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(create_graphics_pipelines)
                    ))
                }
                let raw_name = stringify!(vkCreateGraphicsPipelines);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_graphics_pipelines
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_compute_pipelines: unsafe {
                extern "system" fn create_compute_pipelines(
                    _device: Device,
                    _pipeline_cache: PipelineCache,
                    _create_info_count: u32,
                    _p_create_infos: *const ComputePipelineCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_pipelines: *mut Pipeline,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(create_compute_pipelines)
                    ))
                }
                let raw_name = stringify!(vkCreateComputePipelines);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_compute_pipelines
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_pipeline: unsafe {
                extern "system" fn destroy_pipeline(
                    _device: Device,
                    _pipeline: Pipeline,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(destroy_pipeline)))
                }
                let raw_name = stringify!(vkDestroyPipeline);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_pipeline
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_pipeline_layout: unsafe {
                extern "system" fn create_pipeline_layout(
                    _device: Device,
                    _p_create_info: *const PipelineLayoutCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_pipeline_layout: *mut PipelineLayout,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(create_pipeline_layout)
                    ))
                }
                let raw_name = stringify!(vkCreatePipelineLayout);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_pipeline_layout
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_pipeline_layout: unsafe {
                extern "system" fn destroy_pipeline_layout(
                    _device: Device,
                    _pipeline_layout: PipelineLayout,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(destroy_pipeline_layout)
                    ))
                }
                let raw_name = stringify!(vkDestroyPipelineLayout);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_pipeline_layout
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_sampler: unsafe {
                extern "system" fn create_sampler(
                    _device: Device,
                    _p_create_info: *const SamplerCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_sampler: *mut Sampler,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(create_sampler)))
                }
                let raw_name = stringify!(vkCreateSampler);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_sampler
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_sampler: unsafe {
                extern "system" fn destroy_sampler(
                    _device: Device,
                    _sampler: Sampler,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(destroy_sampler)))
                }
                let raw_name = stringify!(vkDestroySampler);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_sampler
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_descriptor_set_layout: unsafe {
                extern "system" fn create_descriptor_set_layout(
                    _device: Device,
                    _p_create_info: *const DescriptorSetLayoutCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_set_layout: *mut DescriptorSetLayout,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(create_descriptor_set_layout)
                    ))
                }
                let raw_name = stringify!(vkCreateDescriptorSetLayout);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_descriptor_set_layout
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_descriptor_set_layout: unsafe {
                extern "system" fn destroy_descriptor_set_layout(
                    _device: Device,
                    _descriptor_set_layout: DescriptorSetLayout,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(destroy_descriptor_set_layout)
                    ))
                }
                let raw_name = stringify!(vkDestroyDescriptorSetLayout);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_descriptor_set_layout
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_descriptor_pool: unsafe {
                extern "system" fn create_descriptor_pool(
                    _device: Device,
                    _p_create_info: *const DescriptorPoolCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_descriptor_pool: *mut DescriptorPool,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(create_descriptor_pool)
                    ))
                }
                let raw_name = stringify!(vkCreateDescriptorPool);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_descriptor_pool
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_descriptor_pool: unsafe {
                extern "system" fn destroy_descriptor_pool(
                    _device: Device,
                    _descriptor_pool: DescriptorPool,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(destroy_descriptor_pool)
                    ))
                }
                let raw_name = stringify!(vkDestroyDescriptorPool);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_descriptor_pool
                } else {
                    ::std::mem::transmute(val)
                }
            },
            reset_descriptor_pool: unsafe {
                extern "system" fn reset_descriptor_pool(
                    _device: Device,
                    _descriptor_pool: DescriptorPool,
                    _flags: DescriptorPoolResetFlags,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(reset_descriptor_pool)
                    ))
                }
                let raw_name = stringify!(vkResetDescriptorPool);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    reset_descriptor_pool
                } else {
                    ::std::mem::transmute(val)
                }
            },
            allocate_descriptor_sets: unsafe {
                extern "system" fn allocate_descriptor_sets(
                    _device: Device,
                    _p_allocate_info: *const DescriptorSetAllocateInfo,
                    _p_descriptor_sets: *mut DescriptorSet,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(allocate_descriptor_sets)
                    ))
                }
                let raw_name = stringify!(vkAllocateDescriptorSets);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    allocate_descriptor_sets
                } else {
                    ::std::mem::transmute(val)
                }
            },
            free_descriptor_sets: unsafe {
                extern "system" fn free_descriptor_sets(
                    _device: Device,
                    _descriptor_pool: DescriptorPool,
                    _descriptor_set_count: u32,
                    _p_descriptor_sets: *const DescriptorSet,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(free_descriptor_sets)))
                }
                let raw_name = stringify!(vkFreeDescriptorSets);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    free_descriptor_sets
                } else {
                    ::std::mem::transmute(val)
                }
            },
            update_descriptor_sets: unsafe {
                extern "system" fn update_descriptor_sets(
                    _device: Device,
                    _descriptor_write_count: u32,
                    _p_descriptor_writes: *const WriteDescriptorSet,
                    _descriptor_copy_count: u32,
                    _p_descriptor_copies: *const CopyDescriptorSet,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(update_descriptor_sets)
                    ))
                }
                let raw_name = stringify!(vkUpdateDescriptorSets);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    update_descriptor_sets
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_framebuffer: unsafe {
                extern "system" fn create_framebuffer(
                    _device: Device,
                    _p_create_info: *const FramebufferCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_framebuffer: *mut Framebuffer,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(create_framebuffer)))
                }
                let raw_name = stringify!(vkCreateFramebuffer);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_framebuffer
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_framebuffer: unsafe {
                extern "system" fn destroy_framebuffer(
                    _device: Device,
                    _framebuffer: Framebuffer,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(destroy_framebuffer)))
                }
                let raw_name = stringify!(vkDestroyFramebuffer);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_framebuffer
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_render_pass: unsafe {
                extern "system" fn create_render_pass(
                    _device: Device,
                    _p_create_info: *const RenderPassCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_render_pass: *mut RenderPass,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(create_render_pass)))
                }
                let raw_name = stringify!(vkCreateRenderPass);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_render_pass
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_render_pass: unsafe {
                extern "system" fn destroy_render_pass(
                    _device: Device,
                    _render_pass: RenderPass,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(destroy_render_pass)))
                }
                let raw_name = stringify!(vkDestroyRenderPass);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_render_pass
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_render_area_granularity: unsafe {
                extern "system" fn get_render_area_granularity(
                    _device: Device,
                    _render_pass: RenderPass,
                    _p_granularity: *mut Extent2D,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_render_area_granularity)
                    ))
                }
                let raw_name = stringify!(vkGetRenderAreaGranularity);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_render_area_granularity
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_command_pool: unsafe {
                extern "system" fn create_command_pool(
                    _device: Device,
                    _p_create_info: *const CommandPoolCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_command_pool: *mut CommandPool,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(create_command_pool)))
                }
                let raw_name = stringify!(vkCreateCommandPool);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_command_pool
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_command_pool: unsafe {
                extern "system" fn destroy_command_pool(
                    _device: Device,
                    _command_pool: CommandPool,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(destroy_command_pool)))
                }
                let raw_name = stringify!(vkDestroyCommandPool);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_command_pool
                } else {
                    ::std::mem::transmute(val)
                }
            },
            reset_command_pool: unsafe {
                extern "system" fn reset_command_pool(
                    _device: Device,
                    _command_pool: CommandPool,
                    _flags: CommandPoolResetFlags,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(reset_command_pool)))
                }
                let raw_name = stringify!(vkResetCommandPool);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    reset_command_pool
                } else {
                    ::std::mem::transmute(val)
                }
            },
            allocate_command_buffers: unsafe {
                extern "system" fn allocate_command_buffers(
                    _device: Device,
                    _p_allocate_info: *const CommandBufferAllocateInfo,
                    _p_command_buffers: *mut CommandBuffer,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(allocate_command_buffers)
                    ))
                }
                let raw_name = stringify!(vkAllocateCommandBuffers);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    allocate_command_buffers
                } else {
                    ::std::mem::transmute(val)
                }
            },
            free_command_buffers: unsafe {
                extern "system" fn free_command_buffers(
                    _device: Device,
                    _command_pool: CommandPool,
                    _command_buffer_count: u32,
                    _p_command_buffers: *const CommandBuffer,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(free_command_buffers)))
                }
                let raw_name = stringify!(vkFreeCommandBuffers);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    free_command_buffers
                } else {
                    ::std::mem::transmute(val)
                }
            },
            begin_command_buffer: unsafe {
                extern "system" fn begin_command_buffer(
                    _command_buffer: CommandBuffer,
                    _p_begin_info: *const CommandBufferBeginInfo,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(begin_command_buffer)))
                }
                let raw_name = stringify!(vkBeginCommandBuffer);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    begin_command_buffer
                } else {
                    ::std::mem::transmute(val)
                }
            },
            end_command_buffer: unsafe {
                extern "system" fn end_command_buffer(_command_buffer: CommandBuffer) -> Result {
                    panic!(concat!("Unable to load ", stringify!(end_command_buffer)))
                }
                let raw_name = stringify!(vkEndCommandBuffer);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    end_command_buffer
                } else {
                    ::std::mem::transmute(val)
                }
            },
            reset_command_buffer: unsafe {
                extern "system" fn reset_command_buffer(
                    _command_buffer: CommandBuffer,
                    _flags: CommandBufferResetFlags,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(reset_command_buffer)))
                }
                let raw_name = stringify!(vkResetCommandBuffer);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    reset_command_buffer
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_bind_pipeline: unsafe {
                extern "system" fn cmd_bind_pipeline(
                    _command_buffer: CommandBuffer,
                    _pipeline_bind_point: PipelineBindPoint,
                    _pipeline: Pipeline,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_bind_pipeline)))
                }
                let raw_name = stringify!(vkCmdBindPipeline);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_bind_pipeline
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_set_viewport: unsafe {
                extern "system" fn cmd_set_viewport(
                    _command_buffer: CommandBuffer,
                    _first_viewport: u32,
                    _viewport_count: u32,
                    _p_viewports: *const Viewport,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_set_viewport)))
                }
                let raw_name = stringify!(vkCmdSetViewport);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_set_viewport
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_set_scissor: unsafe {
                extern "system" fn cmd_set_scissor(
                    _command_buffer: CommandBuffer,
                    _first_scissor: u32,
                    _scissor_count: u32,
                    _p_scissors: *const Rect2D,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_set_scissor)))
                }
                let raw_name = stringify!(vkCmdSetScissor);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_set_scissor
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_set_line_width: unsafe {
                extern "system" fn cmd_set_line_width(
                    _command_buffer: CommandBuffer,
                    _line_width: f32,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_set_line_width)))
                }
                let raw_name = stringify!(vkCmdSetLineWidth);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_set_line_width
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_set_depth_bias: unsafe {
                extern "system" fn cmd_set_depth_bias(
                    _command_buffer: CommandBuffer,
                    _depth_bias_constant_factor: f32,
                    _depth_bias_clamp: f32,
                    _depth_bias_slope_factor: f32,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_set_depth_bias)))
                }
                let raw_name = stringify!(vkCmdSetDepthBias);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_set_depth_bias
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_set_blend_constants: unsafe {
                extern "system" fn cmd_set_blend_constants(
                    _command_buffer: CommandBuffer,
                    _blend_constants: &[f32; 4],
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_set_blend_constants)
                    ))
                }
                let raw_name = stringify!(vkCmdSetBlendConstants);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_set_blend_constants
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_set_depth_bounds: unsafe {
                extern "system" fn cmd_set_depth_bounds(
                    _command_buffer: CommandBuffer,
                    _min_depth_bounds: f32,
                    _max_depth_bounds: f32,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_set_depth_bounds)))
                }
                let raw_name = stringify!(vkCmdSetDepthBounds);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_set_depth_bounds
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_set_stencil_compare_mask: unsafe {
                extern "system" fn cmd_set_stencil_compare_mask(
                    _command_buffer: CommandBuffer,
                    _face_mask: StencilFaceFlags,
                    _compare_mask: u32,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_set_stencil_compare_mask)
                    ))
                }
                let raw_name = stringify!(vkCmdSetStencilCompareMask);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_set_stencil_compare_mask
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_set_stencil_write_mask: unsafe {
                extern "system" fn cmd_set_stencil_write_mask(
                    _command_buffer: CommandBuffer,
                    _face_mask: StencilFaceFlags,
                    _write_mask: u32,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_set_stencil_write_mask)
                    ))
                }
                let raw_name = stringify!(vkCmdSetStencilWriteMask);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_set_stencil_write_mask
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_set_stencil_reference: unsafe {
                extern "system" fn cmd_set_stencil_reference(
                    _command_buffer: CommandBuffer,
                    _face_mask: StencilFaceFlags,
                    _reference: u32,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_set_stencil_reference)
                    ))
                }
                let raw_name = stringify!(vkCmdSetStencilReference);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_set_stencil_reference
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_bind_descriptor_sets: unsafe {
                extern "system" fn cmd_bind_descriptor_sets(
                    _command_buffer: CommandBuffer,
                    _pipeline_bind_point: PipelineBindPoint,
                    _layout: PipelineLayout,
                    _first_set: u32,
                    _descriptor_set_count: u32,
                    _p_descriptor_sets: *const DescriptorSet,
                    _dynamic_offset_count: u32,
                    _p_dynamic_offsets: *const u32,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_bind_descriptor_sets)
                    ))
                }
                let raw_name = stringify!(vkCmdBindDescriptorSets);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_bind_descriptor_sets
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_bind_index_buffer: unsafe {
                extern "system" fn cmd_bind_index_buffer(
                    _command_buffer: CommandBuffer,
                    _buffer: Buffer,
                    _offset: DeviceSize,
                    _index_type: IndexType,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_bind_index_buffer)
                    ))
                }
                let raw_name = stringify!(vkCmdBindIndexBuffer);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_bind_index_buffer
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_bind_vertex_buffers: unsafe {
                extern "system" fn cmd_bind_vertex_buffers(
                    _command_buffer: CommandBuffer,
                    _first_binding: u32,
                    _binding_count: u32,
                    _p_buffers: *const Buffer,
                    _p_offsets: *const DeviceSize,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_bind_vertex_buffers)
                    ))
                }
                let raw_name = stringify!(vkCmdBindVertexBuffers);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_bind_vertex_buffers
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_draw: unsafe {
                extern "system" fn cmd_draw(
                    _command_buffer: CommandBuffer,
                    _vertex_count: u32,
                    _instance_count: u32,
                    _first_vertex: u32,
                    _first_instance: u32,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_draw)))
                }
                let raw_name = stringify!(vkCmdDraw);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_draw
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_draw_indexed: unsafe {
                extern "system" fn cmd_draw_indexed(
                    _command_buffer: CommandBuffer,
                    _index_count: u32,
                    _instance_count: u32,
                    _first_index: u32,
                    _vertex_offset: i32,
                    _first_instance: u32,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_draw_indexed)))
                }
                let raw_name = stringify!(vkCmdDrawIndexed);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_draw_indexed
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_draw_indirect: unsafe {
                extern "system" fn cmd_draw_indirect(
                    _command_buffer: CommandBuffer,
                    _buffer: Buffer,
                    _offset: DeviceSize,
                    _draw_count: u32,
                    _stride: u32,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_draw_indirect)))
                }
                let raw_name = stringify!(vkCmdDrawIndirect);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_draw_indirect
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_draw_indexed_indirect: unsafe {
                extern "system" fn cmd_draw_indexed_indirect(
                    _command_buffer: CommandBuffer,
                    _buffer: Buffer,
                    _offset: DeviceSize,
                    _draw_count: u32,
                    _stride: u32,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_draw_indexed_indirect)
                    ))
                }
                let raw_name = stringify!(vkCmdDrawIndexedIndirect);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_draw_indexed_indirect
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_dispatch: unsafe {
                extern "system" fn cmd_dispatch(
                    _command_buffer: CommandBuffer,
                    _group_count_x: u32,
                    _group_count_y: u32,
                    _group_count_z: u32,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_dispatch)))
                }
                let raw_name = stringify!(vkCmdDispatch);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_dispatch
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_dispatch_indirect: unsafe {
                extern "system" fn cmd_dispatch_indirect(
                    _command_buffer: CommandBuffer,
                    _buffer: Buffer,
                    _offset: DeviceSize,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_dispatch_indirect)
                    ))
                }
                let raw_name = stringify!(vkCmdDispatchIndirect);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_dispatch_indirect
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_copy_buffer: unsafe {
                extern "system" fn cmd_copy_buffer(
                    _command_buffer: CommandBuffer,
                    _src_buffer: Buffer,
                    _dst_buffer: Buffer,
                    _region_count: u32,
                    _p_regions: *const BufferCopy,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_copy_buffer)))
                }
                let raw_name = stringify!(vkCmdCopyBuffer);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_copy_buffer
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_copy_image: unsafe {
                extern "system" fn cmd_copy_image(
                    _command_buffer: CommandBuffer,
                    _src_image: Image,
                    _src_image_layout: ImageLayout,
                    _dst_image: Image,
                    _dst_image_layout: ImageLayout,
                    _region_count: u32,
                    _p_regions: *const ImageCopy,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_copy_image)))
                }
                let raw_name = stringify!(vkCmdCopyImage);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_copy_image
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_blit_image: unsafe {
                extern "system" fn cmd_blit_image(
                    _command_buffer: CommandBuffer,
                    _src_image: Image,
                    _src_image_layout: ImageLayout,
                    _dst_image: Image,
                    _dst_image_layout: ImageLayout,
                    _region_count: u32,
                    _p_regions: *const ImageBlit,
                    _filter: Filter,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_blit_image)))
                }
                let raw_name = stringify!(vkCmdBlitImage);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_blit_image
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_copy_buffer_to_image: unsafe {
                extern "system" fn cmd_copy_buffer_to_image(
                    _command_buffer: CommandBuffer,
                    _src_buffer: Buffer,
                    _dst_image: Image,
                    _dst_image_layout: ImageLayout,
                    _region_count: u32,
                    _p_regions: *const BufferImageCopy,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_copy_buffer_to_image)
                    ))
                }
                let raw_name = stringify!(vkCmdCopyBufferToImage);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_copy_buffer_to_image
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_copy_image_to_buffer: unsafe {
                extern "system" fn cmd_copy_image_to_buffer(
                    _command_buffer: CommandBuffer,
                    _src_image: Image,
                    _src_image_layout: ImageLayout,
                    _dst_buffer: Buffer,
                    _region_count: u32,
                    _p_regions: *const BufferImageCopy,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_copy_image_to_buffer)
                    ))
                }
                let raw_name = stringify!(vkCmdCopyImageToBuffer);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_copy_image_to_buffer
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_update_buffer: unsafe {
                extern "system" fn cmd_update_buffer(
                    _command_buffer: CommandBuffer,
                    _dst_buffer: Buffer,
                    _dst_offset: DeviceSize,
                    _data_size: DeviceSize,
                    _p_data: *const c_void,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_update_buffer)))
                }
                let raw_name = stringify!(vkCmdUpdateBuffer);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_update_buffer
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_fill_buffer: unsafe {
                extern "system" fn cmd_fill_buffer(
                    _command_buffer: CommandBuffer,
                    _dst_buffer: Buffer,
                    _dst_offset: DeviceSize,
                    _size: DeviceSize,
                    _data: u32,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_fill_buffer)))
                }
                let raw_name = stringify!(vkCmdFillBuffer);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_fill_buffer
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_clear_color_image: unsafe {
                extern "system" fn cmd_clear_color_image(
                    _command_buffer: CommandBuffer,
                    _image: Image,
                    _image_layout: ImageLayout,
                    _p_color: *const ClearColorValue,
                    _range_count: u32,
                    _p_ranges: *const ImageSubresourceRange,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_clear_color_image)
                    ))
                }
                let raw_name = stringify!(vkCmdClearColorImage);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_clear_color_image
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_clear_depth_stencil_image: unsafe {
                extern "system" fn cmd_clear_depth_stencil_image(
                    _command_buffer: CommandBuffer,
                    _image: Image,
                    _image_layout: ImageLayout,
                    _p_depth_stencil: *const ClearDepthStencilValue,
                    _range_count: u32,
                    _p_ranges: *const ImageSubresourceRange,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_clear_depth_stencil_image)
                    ))
                }
                let raw_name = stringify!(vkCmdClearDepthStencilImage);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_clear_depth_stencil_image
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_clear_attachments: unsafe {
                extern "system" fn cmd_clear_attachments(
                    _command_buffer: CommandBuffer,
                    _attachment_count: u32,
                    _p_attachments: *const ClearAttachment,
                    _rect_count: u32,
                    _p_rects: *const ClearRect,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_clear_attachments)
                    ))
                }
                let raw_name = stringify!(vkCmdClearAttachments);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_clear_attachments
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_resolve_image: unsafe {
                extern "system" fn cmd_resolve_image(
                    _command_buffer: CommandBuffer,
                    _src_image: Image,
                    _src_image_layout: ImageLayout,
                    _dst_image: Image,
                    _dst_image_layout: ImageLayout,
                    _region_count: u32,
                    _p_regions: *const ImageResolve,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_resolve_image)))
                }
                let raw_name = stringify!(vkCmdResolveImage);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_resolve_image
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_set_event: unsafe {
                extern "system" fn cmd_set_event(
                    _command_buffer: CommandBuffer,
                    _event: Event,
                    _stage_mask: PipelineStageFlags,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_set_event)))
                }
                let raw_name = stringify!(vkCmdSetEvent);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_set_event
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_reset_event: unsafe {
                extern "system" fn cmd_reset_event(
                    _command_buffer: CommandBuffer,
                    _event: Event,
                    _stage_mask: PipelineStageFlags,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_reset_event)))
                }
                let raw_name = stringify!(vkCmdResetEvent);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_reset_event
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_wait_events: unsafe {
                extern "system" fn cmd_wait_events(
                    _command_buffer: CommandBuffer,
                    _event_count: u32,
                    _p_events: *const Event,
                    _src_stage_mask: PipelineStageFlags,
                    _dst_stage_mask: PipelineStageFlags,
                    _memory_barrier_count: u32,
                    _p_memory_barriers: *const MemoryBarrier,
                    _buffer_memory_barrier_count: u32,
                    _p_buffer_memory_barriers: *const BufferMemoryBarrier,
                    _image_memory_barrier_count: u32,
                    _p_image_memory_barriers: *const ImageMemoryBarrier,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_wait_events)))
                }
                let raw_name = stringify!(vkCmdWaitEvents);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_wait_events
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_pipeline_barrier: unsafe {
                extern "system" fn cmd_pipeline_barrier(
                    _command_buffer: CommandBuffer,
                    _src_stage_mask: PipelineStageFlags,
                    _dst_stage_mask: PipelineStageFlags,
                    _dependency_flags: DependencyFlags,
                    _memory_barrier_count: u32,
                    _p_memory_barriers: *const MemoryBarrier,
                    _buffer_memory_barrier_count: u32,
                    _p_buffer_memory_barriers: *const BufferMemoryBarrier,
                    _image_memory_barrier_count: u32,
                    _p_image_memory_barriers: *const ImageMemoryBarrier,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_pipeline_barrier)))
                }
                let raw_name = stringify!(vkCmdPipelineBarrier);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_pipeline_barrier
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_begin_query: unsafe {
                extern "system" fn cmd_begin_query(
                    _command_buffer: CommandBuffer,
                    _query_pool: QueryPool,
                    _query: u32,
                    _flags: QueryControlFlags,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_begin_query)))
                }
                let raw_name = stringify!(vkCmdBeginQuery);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_begin_query
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_end_query: unsafe {
                extern "system" fn cmd_end_query(
                    _command_buffer: CommandBuffer,
                    _query_pool: QueryPool,
                    _query: u32,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_end_query)))
                }
                let raw_name = stringify!(vkCmdEndQuery);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_end_query
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_reset_query_pool: unsafe {
                extern "system" fn cmd_reset_query_pool(
                    _command_buffer: CommandBuffer,
                    _query_pool: QueryPool,
                    _first_query: u32,
                    _query_count: u32,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_reset_query_pool)))
                }
                let raw_name = stringify!(vkCmdResetQueryPool);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_reset_query_pool
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_write_timestamp: unsafe {
                extern "system" fn cmd_write_timestamp(
                    _command_buffer: CommandBuffer,
                    _pipeline_stage: PipelineStageFlags,
                    _query_pool: QueryPool,
                    _query: u32,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_write_timestamp)))
                }
                let raw_name = stringify!(vkCmdWriteTimestamp);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_write_timestamp
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_copy_query_pool_results: unsafe {
                extern "system" fn cmd_copy_query_pool_results(
                    _command_buffer: CommandBuffer,
                    _query_pool: QueryPool,
                    _first_query: u32,
                    _query_count: u32,
                    _dst_buffer: Buffer,
                    _dst_offset: DeviceSize,
                    _stride: DeviceSize,
                    _flags: QueryResultFlags,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_copy_query_pool_results)
                    ))
                }
                let raw_name = stringify!(vkCmdCopyQueryPoolResults);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_copy_query_pool_results
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_push_constants: unsafe {
                extern "system" fn cmd_push_constants(
                    _command_buffer: CommandBuffer,
                    _layout: PipelineLayout,
                    _stage_flags: ShaderStageFlags,
                    _offset: u32,
                    _size: u32,
                    _p_values: *const c_void,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_push_constants)))
                }
                let raw_name = stringify!(vkCmdPushConstants);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_push_constants
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_begin_render_pass: unsafe {
                extern "system" fn cmd_begin_render_pass(
                    _command_buffer: CommandBuffer,
                    _p_render_pass_begin: *const RenderPassBeginInfo,
                    _contents: SubpassContents,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_begin_render_pass)
                    ))
                }
                let raw_name = stringify!(vkCmdBeginRenderPass);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_begin_render_pass
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_next_subpass: unsafe {
                extern "system" fn cmd_next_subpass(
                    _command_buffer: CommandBuffer,
                    _contents: SubpassContents,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_next_subpass)))
                }
                let raw_name = stringify!(vkCmdNextSubpass);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_next_subpass
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_end_render_pass: unsafe {
                extern "system" fn cmd_end_render_pass(_command_buffer: CommandBuffer) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_end_render_pass)))
                }
                let raw_name = stringify!(vkCmdEndRenderPass);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_end_render_pass
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_execute_commands: unsafe {
                extern "system" fn cmd_execute_commands(
                    _command_buffer: CommandBuffer,
                    _command_buffer_count: u32,
                    _p_command_buffers: *const CommandBuffer,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_execute_commands)))
                }
                let raw_name = stringify!(vkCmdExecuteCommands);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_execute_commands
                } else {
                    ::std::mem::transmute(val)
                }
            },
        }
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyDevice.html>"]
    pub unsafe fn destroy_device(
        &self,
        device: Device,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_device)(device, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeviceQueue.html>"]
    pub unsafe fn get_device_queue(
        &self,
        device: Device,
        queue_family_index: u32,
        queue_index: u32,
        p_queue: *mut Queue,
    ) -> c_void {
        (self.get_device_queue)(device, queue_family_index, queue_index, p_queue)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkQueueSubmit.html>"]
    pub unsafe fn queue_submit(
        &self,
        queue: Queue,
        submit_count: u32,
        p_submits: *const SubmitInfo,
        fence: Fence,
    ) -> Result {
        (self.queue_submit)(queue, submit_count, p_submits, fence)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkQueueWaitIdle.html>"]
    pub unsafe fn queue_wait_idle(&self, queue: Queue) -> Result {
        (self.queue_wait_idle)(queue)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDeviceWaitIdle.html>"]
    pub unsafe fn device_wait_idle(&self, device: Device) -> Result {
        (self.device_wait_idle)(device)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkAllocateMemory.html>"]
    pub unsafe fn allocate_memory(
        &self,
        device: Device,
        p_allocate_info: *const MemoryAllocateInfo,
        p_allocator: *const AllocationCallbacks,
        p_memory: *mut DeviceMemory,
    ) -> Result {
        (self.allocate_memory)(device, p_allocate_info, p_allocator, p_memory)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkFreeMemory.html>"]
    pub unsafe fn free_memory(
        &self,
        device: Device,
        memory: DeviceMemory,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.free_memory)(device, memory, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkMapMemory.html>"]
    pub unsafe fn map_memory(
        &self,
        device: Device,
        memory: DeviceMemory,
        offset: DeviceSize,
        size: DeviceSize,
        flags: MemoryMapFlags,
        pp_data: *mut *mut c_void,
    ) -> Result {
        (self.map_memory)(device, memory, offset, size, flags, pp_data)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkUnmapMemory.html>"]
    pub unsafe fn unmap_memory(&self, device: Device, memory: DeviceMemory) -> c_void {
        (self.unmap_memory)(device, memory)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkFlushMappedMemoryRanges.html>"]
    pub unsafe fn flush_mapped_memory_ranges(
        &self,
        device: Device,
        memory_range_count: u32,
        p_memory_ranges: *const MappedMemoryRange,
    ) -> Result {
        (self.flush_mapped_memory_ranges)(device, memory_range_count, p_memory_ranges)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkInvalidateMappedMemoryRanges.html>"]
    pub unsafe fn invalidate_mapped_memory_ranges(
        &self,
        device: Device,
        memory_range_count: u32,
        p_memory_ranges: *const MappedMemoryRange,
    ) -> Result {
        (self.invalidate_mapped_memory_ranges)(device, memory_range_count, p_memory_ranges)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeviceMemoryCommitment.html>"]
    pub unsafe fn get_device_memory_commitment(
        &self,
        device: Device,
        memory: DeviceMemory,
        p_committed_memory_in_bytes: *mut DeviceSize,
    ) -> c_void {
        (self.get_device_memory_commitment)(device, memory, p_committed_memory_in_bytes)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkBindBufferMemory.html>"]
    pub unsafe fn bind_buffer_memory(
        &self,
        device: Device,
        buffer: Buffer,
        memory: DeviceMemory,
        memory_offset: DeviceSize,
    ) -> Result {
        (self.bind_buffer_memory)(device, buffer, memory, memory_offset)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkBindImageMemory.html>"]
    pub unsafe fn bind_image_memory(
        &self,
        device: Device,
        image: Image,
        memory: DeviceMemory,
        memory_offset: DeviceSize,
    ) -> Result {
        (self.bind_image_memory)(device, image, memory, memory_offset)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetBufferMemoryRequirements.html>"]
    pub unsafe fn get_buffer_memory_requirements(
        &self,
        device: Device,
        buffer: Buffer,
        p_memory_requirements: *mut MemoryRequirements,
    ) -> c_void {
        (self.get_buffer_memory_requirements)(device, buffer, p_memory_requirements)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetImageMemoryRequirements.html>"]
    pub unsafe fn get_image_memory_requirements(
        &self,
        device: Device,
        image: Image,
        p_memory_requirements: *mut MemoryRequirements,
    ) -> c_void {
        (self.get_image_memory_requirements)(device, image, p_memory_requirements)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetImageSparseMemoryRequirements.html>"]
    pub unsafe fn get_image_sparse_memory_requirements(
        &self,
        device: Device,
        image: Image,
        p_sparse_memory_requirement_count: *mut u32,
        p_sparse_memory_requirements: *mut SparseImageMemoryRequirements,
    ) -> c_void {
        (self.get_image_sparse_memory_requirements)(
            device,
            image,
            p_sparse_memory_requirement_count,
            p_sparse_memory_requirements,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkQueueBindSparse.html>"]
    pub unsafe fn queue_bind_sparse(
        &self,
        queue: Queue,
        bind_info_count: u32,
        p_bind_info: *const BindSparseInfo,
        fence: Fence,
    ) -> Result {
        (self.queue_bind_sparse)(queue, bind_info_count, p_bind_info, fence)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateFence.html>"]
    pub unsafe fn create_fence(
        &self,
        device: Device,
        p_create_info: *const FenceCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_fence: *mut Fence,
    ) -> Result {
        (self.create_fence)(device, p_create_info, p_allocator, p_fence)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyFence.html>"]
    pub unsafe fn destroy_fence(
        &self,
        device: Device,
        fence: Fence,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_fence)(device, fence, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkResetFences.html>"]
    pub unsafe fn reset_fences(
        &self,
        device: Device,
        fence_count: u32,
        p_fences: *const Fence,
    ) -> Result {
        (self.reset_fences)(device, fence_count, p_fences)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetFenceStatus.html>"]
    pub unsafe fn get_fence_status(&self, device: Device, fence: Fence) -> Result {
        (self.get_fence_status)(device, fence)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkWaitForFences.html>"]
    pub unsafe fn wait_for_fences(
        &self,
        device: Device,
        fence_count: u32,
        p_fences: *const Fence,
        wait_all: Bool32,
        timeout: u64,
    ) -> Result {
        (self.wait_for_fences)(device, fence_count, p_fences, wait_all, timeout)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateSemaphore.html>"]
    pub unsafe fn create_semaphore(
        &self,
        device: Device,
        p_create_info: *const SemaphoreCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_semaphore: *mut Semaphore,
    ) -> Result {
        (self.create_semaphore)(device, p_create_info, p_allocator, p_semaphore)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroySemaphore.html>"]
    pub unsafe fn destroy_semaphore(
        &self,
        device: Device,
        semaphore: Semaphore,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_semaphore)(device, semaphore, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateEvent.html>"]
    pub unsafe fn create_event(
        &self,
        device: Device,
        p_create_info: *const EventCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_event: *mut Event,
    ) -> Result {
        (self.create_event)(device, p_create_info, p_allocator, p_event)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyEvent.html>"]
    pub unsafe fn destroy_event(
        &self,
        device: Device,
        event: Event,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_event)(device, event, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetEventStatus.html>"]
    pub unsafe fn get_event_status(&self, device: Device, event: Event) -> Result {
        (self.get_event_status)(device, event)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkSetEvent.html>"]
    pub unsafe fn set_event(&self, device: Device, event: Event) -> Result {
        (self.set_event)(device, event)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkResetEvent.html>"]
    pub unsafe fn reset_event(&self, device: Device, event: Event) -> Result {
        (self.reset_event)(device, event)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateQueryPool.html>"]
    pub unsafe fn create_query_pool(
        &self,
        device: Device,
        p_create_info: *const QueryPoolCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_query_pool: *mut QueryPool,
    ) -> Result {
        (self.create_query_pool)(device, p_create_info, p_allocator, p_query_pool)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyQueryPool.html>"]
    pub unsafe fn destroy_query_pool(
        &self,
        device: Device,
        query_pool: QueryPool,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_query_pool)(device, query_pool, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetQueryPoolResults.html>"]
    pub unsafe fn get_query_pool_results(
        &self,
        device: Device,
        query_pool: QueryPool,
        first_query: u32,
        query_count: u32,
        data_size: usize,
        p_data: *mut c_void,
        stride: DeviceSize,
        flags: QueryResultFlags,
    ) -> Result {
        (self.get_query_pool_results)(
            device,
            query_pool,
            first_query,
            query_count,
            data_size,
            p_data,
            stride,
            flags,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateBuffer.html>"]
    pub unsafe fn create_buffer(
        &self,
        device: Device,
        p_create_info: *const BufferCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_buffer: *mut Buffer,
    ) -> Result {
        (self.create_buffer)(device, p_create_info, p_allocator, p_buffer)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyBuffer.html>"]
    pub unsafe fn destroy_buffer(
        &self,
        device: Device,
        buffer: Buffer,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_buffer)(device, buffer, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateBufferView.html>"]
    pub unsafe fn create_buffer_view(
        &self,
        device: Device,
        p_create_info: *const BufferViewCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_view: *mut BufferView,
    ) -> Result {
        (self.create_buffer_view)(device, p_create_info, p_allocator, p_view)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyBufferView.html>"]
    pub unsafe fn destroy_buffer_view(
        &self,
        device: Device,
        buffer_view: BufferView,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_buffer_view)(device, buffer_view, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateImage.html>"]
    pub unsafe fn create_image(
        &self,
        device: Device,
        p_create_info: *const ImageCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_image: *mut Image,
    ) -> Result {
        (self.create_image)(device, p_create_info, p_allocator, p_image)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyImage.html>"]
    pub unsafe fn destroy_image(
        &self,
        device: Device,
        image: Image,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_image)(device, image, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetImageSubresourceLayout.html>"]
    pub unsafe fn get_image_subresource_layout(
        &self,
        device: Device,
        image: Image,
        p_subresource: *const ImageSubresource,
        p_layout: *mut SubresourceLayout,
    ) -> c_void {
        (self.get_image_subresource_layout)(device, image, p_subresource, p_layout)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateImageView.html>"]
    pub unsafe fn create_image_view(
        &self,
        device: Device,
        p_create_info: *const ImageViewCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_view: *mut ImageView,
    ) -> Result {
        (self.create_image_view)(device, p_create_info, p_allocator, p_view)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyImageView.html>"]
    pub unsafe fn destroy_image_view(
        &self,
        device: Device,
        image_view: ImageView,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_image_view)(device, image_view, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateShaderModule.html>"]
    pub unsafe fn create_shader_module(
        &self,
        device: Device,
        p_create_info: *const ShaderModuleCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_shader_module: *mut ShaderModule,
    ) -> Result {
        (self.create_shader_module)(device, p_create_info, p_allocator, p_shader_module)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyShaderModule.html>"]
    pub unsafe fn destroy_shader_module(
        &self,
        device: Device,
        shader_module: ShaderModule,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_shader_module)(device, shader_module, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreatePipelineCache.html>"]
    pub unsafe fn create_pipeline_cache(
        &self,
        device: Device,
        p_create_info: *const PipelineCacheCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_pipeline_cache: *mut PipelineCache,
    ) -> Result {
        (self.create_pipeline_cache)(device, p_create_info, p_allocator, p_pipeline_cache)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyPipelineCache.html>"]
    pub unsafe fn destroy_pipeline_cache(
        &self,
        device: Device,
        pipeline_cache: PipelineCache,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_pipeline_cache)(device, pipeline_cache, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPipelineCacheData.html>"]
    pub unsafe fn get_pipeline_cache_data(
        &self,
        device: Device,
        pipeline_cache: PipelineCache,
        p_data_size: *mut usize,
        p_data: *mut c_void,
    ) -> Result {
        (self.get_pipeline_cache_data)(device, pipeline_cache, p_data_size, p_data)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkMergePipelineCaches.html>"]
    pub unsafe fn merge_pipeline_caches(
        &self,
        device: Device,
        dst_cache: PipelineCache,
        src_cache_count: u32,
        p_src_caches: *const PipelineCache,
    ) -> Result {
        (self.merge_pipeline_caches)(device, dst_cache, src_cache_count, p_src_caches)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateGraphicsPipelines.html>"]
    pub unsafe fn create_graphics_pipelines(
        &self,
        device: Device,
        pipeline_cache: PipelineCache,
        create_info_count: u32,
        p_create_infos: *const GraphicsPipelineCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_pipelines: *mut Pipeline,
    ) -> Result {
        (self.create_graphics_pipelines)(
            device,
            pipeline_cache,
            create_info_count,
            p_create_infos,
            p_allocator,
            p_pipelines,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateComputePipelines.html>"]
    pub unsafe fn create_compute_pipelines(
        &self,
        device: Device,
        pipeline_cache: PipelineCache,
        create_info_count: u32,
        p_create_infos: *const ComputePipelineCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_pipelines: *mut Pipeline,
    ) -> Result {
        (self.create_compute_pipelines)(
            device,
            pipeline_cache,
            create_info_count,
            p_create_infos,
            p_allocator,
            p_pipelines,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyPipeline.html>"]
    pub unsafe fn destroy_pipeline(
        &self,
        device: Device,
        pipeline: Pipeline,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_pipeline)(device, pipeline, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreatePipelineLayout.html>"]
    pub unsafe fn create_pipeline_layout(
        &self,
        device: Device,
        p_create_info: *const PipelineLayoutCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_pipeline_layout: *mut PipelineLayout,
    ) -> Result {
        (self.create_pipeline_layout)(device, p_create_info, p_allocator, p_pipeline_layout)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyPipelineLayout.html>"]
    pub unsafe fn destroy_pipeline_layout(
        &self,
        device: Device,
        pipeline_layout: PipelineLayout,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_pipeline_layout)(device, pipeline_layout, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateSampler.html>"]
    pub unsafe fn create_sampler(
        &self,
        device: Device,
        p_create_info: *const SamplerCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_sampler: *mut Sampler,
    ) -> Result {
        (self.create_sampler)(device, p_create_info, p_allocator, p_sampler)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroySampler.html>"]
    pub unsafe fn destroy_sampler(
        &self,
        device: Device,
        sampler: Sampler,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_sampler)(device, sampler, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateDescriptorSetLayout.html>"]
    pub unsafe fn create_descriptor_set_layout(
        &self,
        device: Device,
        p_create_info: *const DescriptorSetLayoutCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_set_layout: *mut DescriptorSetLayout,
    ) -> Result {
        (self.create_descriptor_set_layout)(device, p_create_info, p_allocator, p_set_layout)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyDescriptorSetLayout.html>"]
    pub unsafe fn destroy_descriptor_set_layout(
        &self,
        device: Device,
        descriptor_set_layout: DescriptorSetLayout,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_descriptor_set_layout)(device, descriptor_set_layout, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateDescriptorPool.html>"]
    pub unsafe fn create_descriptor_pool(
        &self,
        device: Device,
        p_create_info: *const DescriptorPoolCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_descriptor_pool: *mut DescriptorPool,
    ) -> Result {
        (self.create_descriptor_pool)(device, p_create_info, p_allocator, p_descriptor_pool)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyDescriptorPool.html>"]
    pub unsafe fn destroy_descriptor_pool(
        &self,
        device: Device,
        descriptor_pool: DescriptorPool,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_descriptor_pool)(device, descriptor_pool, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkResetDescriptorPool.html>"]
    pub unsafe fn reset_descriptor_pool(
        &self,
        device: Device,
        descriptor_pool: DescriptorPool,
        flags: DescriptorPoolResetFlags,
    ) -> Result {
        (self.reset_descriptor_pool)(device, descriptor_pool, flags)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkAllocateDescriptorSets.html>"]
    pub unsafe fn allocate_descriptor_sets(
        &self,
        device: Device,
        p_allocate_info: *const DescriptorSetAllocateInfo,
        p_descriptor_sets: *mut DescriptorSet,
    ) -> Result {
        (self.allocate_descriptor_sets)(device, p_allocate_info, p_descriptor_sets)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkFreeDescriptorSets.html>"]
    pub unsafe fn free_descriptor_sets(
        &self,
        device: Device,
        descriptor_pool: DescriptorPool,
        descriptor_set_count: u32,
        p_descriptor_sets: *const DescriptorSet,
    ) -> Result {
        (self.free_descriptor_sets)(
            device,
            descriptor_pool,
            descriptor_set_count,
            p_descriptor_sets,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkUpdateDescriptorSets.html>"]
    pub unsafe fn update_descriptor_sets(
        &self,
        device: Device,
        descriptor_write_count: u32,
        p_descriptor_writes: *const WriteDescriptorSet,
        descriptor_copy_count: u32,
        p_descriptor_copies: *const CopyDescriptorSet,
    ) -> c_void {
        (self.update_descriptor_sets)(
            device,
            descriptor_write_count,
            p_descriptor_writes,
            descriptor_copy_count,
            p_descriptor_copies,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateFramebuffer.html>"]
    pub unsafe fn create_framebuffer(
        &self,
        device: Device,
        p_create_info: *const FramebufferCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_framebuffer: *mut Framebuffer,
    ) -> Result {
        (self.create_framebuffer)(device, p_create_info, p_allocator, p_framebuffer)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyFramebuffer.html>"]
    pub unsafe fn destroy_framebuffer(
        &self,
        device: Device,
        framebuffer: Framebuffer,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_framebuffer)(device, framebuffer, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateRenderPass.html>"]
    pub unsafe fn create_render_pass(
        &self,
        device: Device,
        p_create_info: *const RenderPassCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_render_pass: *mut RenderPass,
    ) -> Result {
        (self.create_render_pass)(device, p_create_info, p_allocator, p_render_pass)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyRenderPass.html>"]
    pub unsafe fn destroy_render_pass(
        &self,
        device: Device,
        render_pass: RenderPass,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_render_pass)(device, render_pass, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetRenderAreaGranularity.html>"]
    pub unsafe fn get_render_area_granularity(
        &self,
        device: Device,
        render_pass: RenderPass,
        p_granularity: *mut Extent2D,
    ) -> c_void {
        (self.get_render_area_granularity)(device, render_pass, p_granularity)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateCommandPool.html>"]
    pub unsafe fn create_command_pool(
        &self,
        device: Device,
        p_create_info: *const CommandPoolCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_command_pool: *mut CommandPool,
    ) -> Result {
        (self.create_command_pool)(device, p_create_info, p_allocator, p_command_pool)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyCommandPool.html>"]
    pub unsafe fn destroy_command_pool(
        &self,
        device: Device,
        command_pool: CommandPool,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_command_pool)(device, command_pool, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkResetCommandPool.html>"]
    pub unsafe fn reset_command_pool(
        &self,
        device: Device,
        command_pool: CommandPool,
        flags: CommandPoolResetFlags,
    ) -> Result {
        (self.reset_command_pool)(device, command_pool, flags)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkAllocateCommandBuffers.html>"]
    pub unsafe fn allocate_command_buffers(
        &self,
        device: Device,
        p_allocate_info: *const CommandBufferAllocateInfo,
        p_command_buffers: *mut CommandBuffer,
    ) -> Result {
        (self.allocate_command_buffers)(device, p_allocate_info, p_command_buffers)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkFreeCommandBuffers.html>"]
    pub unsafe fn free_command_buffers(
        &self,
        device: Device,
        command_pool: CommandPool,
        command_buffer_count: u32,
        p_command_buffers: *const CommandBuffer,
    ) -> c_void {
        (self.free_command_buffers)(
            device,
            command_pool,
            command_buffer_count,
            p_command_buffers,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkBeginCommandBuffer.html>"]
    pub unsafe fn begin_command_buffer(
        &self,
        command_buffer: CommandBuffer,
        p_begin_info: *const CommandBufferBeginInfo,
    ) -> Result {
        (self.begin_command_buffer)(command_buffer, p_begin_info)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkEndCommandBuffer.html>"]
    pub unsafe fn end_command_buffer(&self, command_buffer: CommandBuffer) -> Result {
        (self.end_command_buffer)(command_buffer)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkResetCommandBuffer.html>"]
    pub unsafe fn reset_command_buffer(
        &self,
        command_buffer: CommandBuffer,
        flags: CommandBufferResetFlags,
    ) -> Result {
        (self.reset_command_buffer)(command_buffer, flags)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBindPipeline.html>"]
    pub unsafe fn cmd_bind_pipeline(
        &self,
        command_buffer: CommandBuffer,
        pipeline_bind_point: PipelineBindPoint,
        pipeline: Pipeline,
    ) -> c_void {
        (self.cmd_bind_pipeline)(command_buffer, pipeline_bind_point, pipeline)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetViewport.html>"]
    pub unsafe fn cmd_set_viewport(
        &self,
        command_buffer: CommandBuffer,
        first_viewport: u32,
        viewport_count: u32,
        p_viewports: *const Viewport,
    ) -> c_void {
        (self.cmd_set_viewport)(command_buffer, first_viewport, viewport_count, p_viewports)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetScissor.html>"]
    pub unsafe fn cmd_set_scissor(
        &self,
        command_buffer: CommandBuffer,
        first_scissor: u32,
        scissor_count: u32,
        p_scissors: *const Rect2D,
    ) -> c_void {
        (self.cmd_set_scissor)(command_buffer, first_scissor, scissor_count, p_scissors)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetLineWidth.html>"]
    pub unsafe fn cmd_set_line_width(
        &self,
        command_buffer: CommandBuffer,
        line_width: f32,
    ) -> c_void {
        (self.cmd_set_line_width)(command_buffer, line_width)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetDepthBias.html>"]
    pub unsafe fn cmd_set_depth_bias(
        &self,
        command_buffer: CommandBuffer,
        depth_bias_constant_factor: f32,
        depth_bias_clamp: f32,
        depth_bias_slope_factor: f32,
    ) -> c_void {
        (self.cmd_set_depth_bias)(
            command_buffer,
            depth_bias_constant_factor,
            depth_bias_clamp,
            depth_bias_slope_factor,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetBlendConstants.html>"]
    pub unsafe fn cmd_set_blend_constants(
        &self,
        command_buffer: CommandBuffer,
        blend_constants: &[f32; 4],
    ) -> c_void {
        (self.cmd_set_blend_constants)(command_buffer, blend_constants)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetDepthBounds.html>"]
    pub unsafe fn cmd_set_depth_bounds(
        &self,
        command_buffer: CommandBuffer,
        min_depth_bounds: f32,
        max_depth_bounds: f32,
    ) -> c_void {
        (self.cmd_set_depth_bounds)(command_buffer, min_depth_bounds, max_depth_bounds)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetStencilCompareMask.html>"]
    pub unsafe fn cmd_set_stencil_compare_mask(
        &self,
        command_buffer: CommandBuffer,
        face_mask: StencilFaceFlags,
        compare_mask: u32,
    ) -> c_void {
        (self.cmd_set_stencil_compare_mask)(command_buffer, face_mask, compare_mask)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetStencilWriteMask.html>"]
    pub unsafe fn cmd_set_stencil_write_mask(
        &self,
        command_buffer: CommandBuffer,
        face_mask: StencilFaceFlags,
        write_mask: u32,
    ) -> c_void {
        (self.cmd_set_stencil_write_mask)(command_buffer, face_mask, write_mask)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetStencilReference.html>"]
    pub unsafe fn cmd_set_stencil_reference(
        &self,
        command_buffer: CommandBuffer,
        face_mask: StencilFaceFlags,
        reference: u32,
    ) -> c_void {
        (self.cmd_set_stencil_reference)(command_buffer, face_mask, reference)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBindDescriptorSets.html>"]
    pub unsafe fn cmd_bind_descriptor_sets(
        &self,
        command_buffer: CommandBuffer,
        pipeline_bind_point: PipelineBindPoint,
        layout: PipelineLayout,
        first_set: u32,
        descriptor_set_count: u32,
        p_descriptor_sets: *const DescriptorSet,
        dynamic_offset_count: u32,
        p_dynamic_offsets: *const u32,
    ) -> c_void {
        (self.cmd_bind_descriptor_sets)(
            command_buffer,
            pipeline_bind_point,
            layout,
            first_set,
            descriptor_set_count,
            p_descriptor_sets,
            dynamic_offset_count,
            p_dynamic_offsets,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBindIndexBuffer.html>"]
    pub unsafe fn cmd_bind_index_buffer(
        &self,
        command_buffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        index_type: IndexType,
    ) -> c_void {
        (self.cmd_bind_index_buffer)(command_buffer, buffer, offset, index_type)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBindVertexBuffers.html>"]
    pub unsafe fn cmd_bind_vertex_buffers(
        &self,
        command_buffer: CommandBuffer,
        first_binding: u32,
        binding_count: u32,
        p_buffers: *const Buffer,
        p_offsets: *const DeviceSize,
    ) -> c_void {
        (self.cmd_bind_vertex_buffers)(
            command_buffer,
            first_binding,
            binding_count,
            p_buffers,
            p_offsets,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDraw.html>"]
    pub unsafe fn cmd_draw(
        &self,
        command_buffer: CommandBuffer,
        vertex_count: u32,
        instance_count: u32,
        first_vertex: u32,
        first_instance: u32,
    ) -> c_void {
        (self.cmd_draw)(
            command_buffer,
            vertex_count,
            instance_count,
            first_vertex,
            first_instance,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDrawIndexed.html>"]
    pub unsafe fn cmd_draw_indexed(
        &self,
        command_buffer: CommandBuffer,
        index_count: u32,
        instance_count: u32,
        first_index: u32,
        vertex_offset: i32,
        first_instance: u32,
    ) -> c_void {
        (self.cmd_draw_indexed)(
            command_buffer,
            index_count,
            instance_count,
            first_index,
            vertex_offset,
            first_instance,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDrawIndirect.html>"]
    pub unsafe fn cmd_draw_indirect(
        &self,
        command_buffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        draw_count: u32,
        stride: u32,
    ) -> c_void {
        (self.cmd_draw_indirect)(command_buffer, buffer, offset, draw_count, stride)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDrawIndexedIndirect.html>"]
    pub unsafe fn cmd_draw_indexed_indirect(
        &self,
        command_buffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        draw_count: u32,
        stride: u32,
    ) -> c_void {
        (self.cmd_draw_indexed_indirect)(command_buffer, buffer, offset, draw_count, stride)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDispatch.html>"]
    pub unsafe fn cmd_dispatch(
        &self,
        command_buffer: CommandBuffer,
        group_count_x: u32,
        group_count_y: u32,
        group_count_z: u32,
    ) -> c_void {
        (self.cmd_dispatch)(command_buffer, group_count_x, group_count_y, group_count_z)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDispatchIndirect.html>"]
    pub unsafe fn cmd_dispatch_indirect(
        &self,
        command_buffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
    ) -> c_void {
        (self.cmd_dispatch_indirect)(command_buffer, buffer, offset)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdCopyBuffer.html>"]
    pub unsafe fn cmd_copy_buffer(
        &self,
        command_buffer: CommandBuffer,
        src_buffer: Buffer,
        dst_buffer: Buffer,
        region_count: u32,
        p_regions: *const BufferCopy,
    ) -> c_void {
        (self.cmd_copy_buffer)(
            command_buffer,
            src_buffer,
            dst_buffer,
            region_count,
            p_regions,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdCopyImage.html>"]
    pub unsafe fn cmd_copy_image(
        &self,
        command_buffer: CommandBuffer,
        src_image: Image,
        src_image_layout: ImageLayout,
        dst_image: Image,
        dst_image_layout: ImageLayout,
        region_count: u32,
        p_regions: *const ImageCopy,
    ) -> c_void {
        (self.cmd_copy_image)(
            command_buffer,
            src_image,
            src_image_layout,
            dst_image,
            dst_image_layout,
            region_count,
            p_regions,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBlitImage.html>"]
    pub unsafe fn cmd_blit_image(
        &self,
        command_buffer: CommandBuffer,
        src_image: Image,
        src_image_layout: ImageLayout,
        dst_image: Image,
        dst_image_layout: ImageLayout,
        region_count: u32,
        p_regions: *const ImageBlit,
        filter: Filter,
    ) -> c_void {
        (self.cmd_blit_image)(
            command_buffer,
            src_image,
            src_image_layout,
            dst_image,
            dst_image_layout,
            region_count,
            p_regions,
            filter,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdCopyBufferToImage.html>"]
    pub unsafe fn cmd_copy_buffer_to_image(
        &self,
        command_buffer: CommandBuffer,
        src_buffer: Buffer,
        dst_image: Image,
        dst_image_layout: ImageLayout,
        region_count: u32,
        p_regions: *const BufferImageCopy,
    ) -> c_void {
        (self.cmd_copy_buffer_to_image)(
            command_buffer,
            src_buffer,
            dst_image,
            dst_image_layout,
            region_count,
            p_regions,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdCopyImageToBuffer.html>"]
    pub unsafe fn cmd_copy_image_to_buffer(
        &self,
        command_buffer: CommandBuffer,
        src_image: Image,
        src_image_layout: ImageLayout,
        dst_buffer: Buffer,
        region_count: u32,
        p_regions: *const BufferImageCopy,
    ) -> c_void {
        (self.cmd_copy_image_to_buffer)(
            command_buffer,
            src_image,
            src_image_layout,
            dst_buffer,
            region_count,
            p_regions,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdUpdateBuffer.html>"]
    pub unsafe fn cmd_update_buffer(
        &self,
        command_buffer: CommandBuffer,
        dst_buffer: Buffer,
        dst_offset: DeviceSize,
        data_size: DeviceSize,
        p_data: *const c_void,
    ) -> c_void {
        (self.cmd_update_buffer)(command_buffer, dst_buffer, dst_offset, data_size, p_data)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdFillBuffer.html>"]
    pub unsafe fn cmd_fill_buffer(
        &self,
        command_buffer: CommandBuffer,
        dst_buffer: Buffer,
        dst_offset: DeviceSize,
        size: DeviceSize,
        data: u32,
    ) -> c_void {
        (self.cmd_fill_buffer)(command_buffer, dst_buffer, dst_offset, size, data)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdClearColorImage.html>"]
    pub unsafe fn cmd_clear_color_image(
        &self,
        command_buffer: CommandBuffer,
        image: Image,
        image_layout: ImageLayout,
        p_color: *const ClearColorValue,
        range_count: u32,
        p_ranges: *const ImageSubresourceRange,
    ) -> c_void {
        (self.cmd_clear_color_image)(
            command_buffer,
            image,
            image_layout,
            p_color,
            range_count,
            p_ranges,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdClearDepthStencilImage.html>"]
    pub unsafe fn cmd_clear_depth_stencil_image(
        &self,
        command_buffer: CommandBuffer,
        image: Image,
        image_layout: ImageLayout,
        p_depth_stencil: *const ClearDepthStencilValue,
        range_count: u32,
        p_ranges: *const ImageSubresourceRange,
    ) -> c_void {
        (self.cmd_clear_depth_stencil_image)(
            command_buffer,
            image,
            image_layout,
            p_depth_stencil,
            range_count,
            p_ranges,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdClearAttachments.html>"]
    pub unsafe fn cmd_clear_attachments(
        &self,
        command_buffer: CommandBuffer,
        attachment_count: u32,
        p_attachments: *const ClearAttachment,
        rect_count: u32,
        p_rects: *const ClearRect,
    ) -> c_void {
        (self.cmd_clear_attachments)(
            command_buffer,
            attachment_count,
            p_attachments,
            rect_count,
            p_rects,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdResolveImage.html>"]
    pub unsafe fn cmd_resolve_image(
        &self,
        command_buffer: CommandBuffer,
        src_image: Image,
        src_image_layout: ImageLayout,
        dst_image: Image,
        dst_image_layout: ImageLayout,
        region_count: u32,
        p_regions: *const ImageResolve,
    ) -> c_void {
        (self.cmd_resolve_image)(
            command_buffer,
            src_image,
            src_image_layout,
            dst_image,
            dst_image_layout,
            region_count,
            p_regions,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetEvent.html>"]
    pub unsafe fn cmd_set_event(
        &self,
        command_buffer: CommandBuffer,
        event: Event,
        stage_mask: PipelineStageFlags,
    ) -> c_void {
        (self.cmd_set_event)(command_buffer, event, stage_mask)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdResetEvent.html>"]
    pub unsafe fn cmd_reset_event(
        &self,
        command_buffer: CommandBuffer,
        event: Event,
        stage_mask: PipelineStageFlags,
    ) -> c_void {
        (self.cmd_reset_event)(command_buffer, event, stage_mask)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdWaitEvents.html>"]
    pub unsafe fn cmd_wait_events(
        &self,
        command_buffer: CommandBuffer,
        event_count: u32,
        p_events: *const Event,
        src_stage_mask: PipelineStageFlags,
        dst_stage_mask: PipelineStageFlags,
        memory_barrier_count: u32,
        p_memory_barriers: *const MemoryBarrier,
        buffer_memory_barrier_count: u32,
        p_buffer_memory_barriers: *const BufferMemoryBarrier,
        image_memory_barrier_count: u32,
        p_image_memory_barriers: *const ImageMemoryBarrier,
    ) -> c_void {
        (self.cmd_wait_events)(
            command_buffer,
            event_count,
            p_events,
            src_stage_mask,
            dst_stage_mask,
            memory_barrier_count,
            p_memory_barriers,
            buffer_memory_barrier_count,
            p_buffer_memory_barriers,
            image_memory_barrier_count,
            p_image_memory_barriers,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdPipelineBarrier.html>"]
    pub unsafe fn cmd_pipeline_barrier(
        &self,
        command_buffer: CommandBuffer,
        src_stage_mask: PipelineStageFlags,
        dst_stage_mask: PipelineStageFlags,
        dependency_flags: DependencyFlags,
        memory_barrier_count: u32,
        p_memory_barriers: *const MemoryBarrier,
        buffer_memory_barrier_count: u32,
        p_buffer_memory_barriers: *const BufferMemoryBarrier,
        image_memory_barrier_count: u32,
        p_image_memory_barriers: *const ImageMemoryBarrier,
    ) -> c_void {
        (self.cmd_pipeline_barrier)(
            command_buffer,
            src_stage_mask,
            dst_stage_mask,
            dependency_flags,
            memory_barrier_count,
            p_memory_barriers,
            buffer_memory_barrier_count,
            p_buffer_memory_barriers,
            image_memory_barrier_count,
            p_image_memory_barriers,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBeginQuery.html>"]
    pub unsafe fn cmd_begin_query(
        &self,
        command_buffer: CommandBuffer,
        query_pool: QueryPool,
        query: u32,
        flags: QueryControlFlags,
    ) -> c_void {
        (self.cmd_begin_query)(command_buffer, query_pool, query, flags)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdEndQuery.html>"]
    pub unsafe fn cmd_end_query(
        &self,
        command_buffer: CommandBuffer,
        query_pool: QueryPool,
        query: u32,
    ) -> c_void {
        (self.cmd_end_query)(command_buffer, query_pool, query)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdResetQueryPool.html>"]
    pub unsafe fn cmd_reset_query_pool(
        &self,
        command_buffer: CommandBuffer,
        query_pool: QueryPool,
        first_query: u32,
        query_count: u32,
    ) -> c_void {
        (self.cmd_reset_query_pool)(command_buffer, query_pool, first_query, query_count)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdWriteTimestamp.html>"]
    pub unsafe fn cmd_write_timestamp(
        &self,
        command_buffer: CommandBuffer,
        pipeline_stage: PipelineStageFlags,
        query_pool: QueryPool,
        query: u32,
    ) -> c_void {
        (self.cmd_write_timestamp)(command_buffer, pipeline_stage, query_pool, query)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdCopyQueryPoolResults.html>"]
    pub unsafe fn cmd_copy_query_pool_results(
        &self,
        command_buffer: CommandBuffer,
        query_pool: QueryPool,
        first_query: u32,
        query_count: u32,
        dst_buffer: Buffer,
        dst_offset: DeviceSize,
        stride: DeviceSize,
        flags: QueryResultFlags,
    ) -> c_void {
        (self.cmd_copy_query_pool_results)(
            command_buffer,
            query_pool,
            first_query,
            query_count,
            dst_buffer,
            dst_offset,
            stride,
            flags,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdPushConstants.html>"]
    pub unsafe fn cmd_push_constants(
        &self,
        command_buffer: CommandBuffer,
        layout: PipelineLayout,
        stage_flags: ShaderStageFlags,
        offset: u32,
        size: u32,
        p_values: *const c_void,
    ) -> c_void {
        (self.cmd_push_constants)(command_buffer, layout, stage_flags, offset, size, p_values)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBeginRenderPass.html>"]
    pub unsafe fn cmd_begin_render_pass(
        &self,
        command_buffer: CommandBuffer,
        p_render_pass_begin: *const RenderPassBeginInfo,
        contents: SubpassContents,
    ) -> c_void {
        (self.cmd_begin_render_pass)(command_buffer, p_render_pass_begin, contents)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdNextSubpass.html>"]
    pub unsafe fn cmd_next_subpass(
        &self,
        command_buffer: CommandBuffer,
        contents: SubpassContents,
    ) -> c_void {
        (self.cmd_next_subpass)(command_buffer, contents)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdEndRenderPass.html>"]
    pub unsafe fn cmd_end_render_pass(&self, command_buffer: CommandBuffer) -> c_void {
        (self.cmd_end_render_pass)(command_buffer)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdExecuteCommands.html>"]
    pub unsafe fn cmd_execute_commands(
        &self,
        command_buffer: CommandBuffer,
        command_buffer_count: u32,
        p_command_buffers: *const CommandBuffer,
    ) -> c_void {
        (self.cmd_execute_commands)(command_buffer, command_buffer_count, p_command_buffers)
    }
}
#[allow(non_camel_case_types)]
pub type PFN_vkEnumerateInstanceVersion = extern "system" fn(p_api_version: *mut u32) -> Result;
pub struct EntryFnV1_1 {
    pub enumerate_instance_version: extern "system" fn(p_api_version: *mut u32) -> Result,
}
unsafe impl Send for EntryFnV1_1 {}
unsafe impl Sync for EntryFnV1_1 {}
impl ::std::clone::Clone for EntryFnV1_1 {
    fn clone(&self) -> Self {
        EntryFnV1_1 {
            enumerate_instance_version: self.enumerate_instance_version,
        }
    }
}
impl EntryFnV1_1 {
    pub fn load<F>(mut _f: F) -> Self
    where
        F: FnMut(&::std::ffi::CStr) -> *const c_void,
    {
        EntryFnV1_1 {
            enumerate_instance_version: unsafe {
                extern "system" fn enumerate_instance_version(_p_api_version: *mut u32) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(enumerate_instance_version)
                    ))
                }
                let raw_name = stringify!(vkEnumerateInstanceVersion);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    enumerate_instance_version
                } else {
                    ::std::mem::transmute(val)
                }
            },
        }
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkEnumerateInstanceVersion.html>"]
    pub unsafe fn enumerate_instance_version(&self, p_api_version: *mut u32) -> Result {
        (self.enumerate_instance_version)(p_api_version)
    }
}
pub struct InstanceFnV1_1 {
    pub enumerate_physical_device_groups: extern "system" fn(
        instance: Instance,
        p_physical_device_group_count: *mut u32,
        p_physical_device_group_properties: *mut PhysicalDeviceGroupProperties,
    ) -> Result,
    pub get_physical_device_features2: extern "system" fn(
        physical_device: PhysicalDevice,
        p_features: *mut PhysicalDeviceFeatures2,
    ) -> c_void,
    pub get_physical_device_properties2: extern "system" fn(
        physical_device: PhysicalDevice,
        p_properties: *mut PhysicalDeviceProperties2,
    ) -> c_void,
    pub get_physical_device_format_properties2: extern "system" fn(
        physical_device: PhysicalDevice,
        format: Format,
        p_format_properties: *mut FormatProperties2,
    ) -> c_void,
    pub get_physical_device_image_format_properties2: extern "system" fn(
        physical_device: PhysicalDevice,
        p_image_format_info: *const PhysicalDeviceImageFormatInfo2,
        p_image_format_properties: *mut ImageFormatProperties2,
    ) -> Result,
    pub get_physical_device_queue_family_properties2: extern "system" fn(
        physical_device: PhysicalDevice,
        p_queue_family_property_count: *mut u32,
        p_queue_family_properties: *mut QueueFamilyProperties2,
    ) -> c_void,
    pub get_physical_device_memory_properties2: extern "system" fn(
        physical_device: PhysicalDevice,
        p_memory_properties: *mut PhysicalDeviceMemoryProperties2,
    ) -> c_void,
    pub get_physical_device_sparse_image_format_properties2: extern "system" fn(
        physical_device: PhysicalDevice,
        p_format_info: *const PhysicalDeviceSparseImageFormatInfo2,
        p_property_count: *mut u32,
        p_properties: *mut SparseImageFormatProperties2,
    ) -> c_void,
    pub get_physical_device_external_buffer_properties: extern "system" fn(
        physical_device: PhysicalDevice,
        p_external_buffer_info: *const PhysicalDeviceExternalBufferInfo,
        p_external_buffer_properties: *mut ExternalBufferProperties,
    ) -> c_void,
    pub get_physical_device_external_fence_properties: extern "system" fn(
        physical_device: PhysicalDevice,
        p_external_fence_info: *const PhysicalDeviceExternalFenceInfo,
        p_external_fence_properties: *mut ExternalFenceProperties,
    ) -> c_void,
    pub get_physical_device_external_semaphore_properties: extern "system" fn(
        physical_device: PhysicalDevice,
        p_external_semaphore_info: *const PhysicalDeviceExternalSemaphoreInfo,
        p_external_semaphore_properties: *mut ExternalSemaphoreProperties,
    ) -> c_void,
}
unsafe impl Send for InstanceFnV1_1 {}
unsafe impl Sync for InstanceFnV1_1 {}
impl ::std::clone::Clone for InstanceFnV1_1 {
    fn clone(&self) -> Self {
        InstanceFnV1_1 {
            enumerate_physical_device_groups: self.enumerate_physical_device_groups,
            get_physical_device_features2: self.get_physical_device_features2,
            get_physical_device_properties2: self.get_physical_device_properties2,
            get_physical_device_format_properties2: self.get_physical_device_format_properties2,
            get_physical_device_image_format_properties2: self
                .get_physical_device_image_format_properties2,
            get_physical_device_queue_family_properties2: self
                .get_physical_device_queue_family_properties2,
            get_physical_device_memory_properties2: self.get_physical_device_memory_properties2,
            get_physical_device_sparse_image_format_properties2: self
                .get_physical_device_sparse_image_format_properties2,
            get_physical_device_external_buffer_properties: self
                .get_physical_device_external_buffer_properties,
            get_physical_device_external_fence_properties: self
                .get_physical_device_external_fence_properties,
            get_physical_device_external_semaphore_properties: self
                .get_physical_device_external_semaphore_properties,
        }
    }
}
impl InstanceFnV1_1 {
    pub fn load<F>(mut _f: F) -> Self
    where
        F: FnMut(&::std::ffi::CStr) -> *const c_void,
    {
        InstanceFnV1_1 {
            enumerate_physical_device_groups: unsafe {
                extern "system" fn enumerate_physical_device_groups(
                    _instance: Instance,
                    _p_physical_device_group_count: *mut u32,
                    _p_physical_device_group_properties: *mut PhysicalDeviceGroupProperties,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(enumerate_physical_device_groups)
                    ))
                }
                let raw_name = stringify!(vkEnumeratePhysicalDeviceGroups);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    enumerate_physical_device_groups
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_physical_device_features2: unsafe {
                extern "system" fn get_physical_device_features2(
                    _physical_device: PhysicalDevice,
                    _p_features: *mut PhysicalDeviceFeatures2,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_physical_device_features2)
                    ))
                }
                let raw_name = stringify!(vkGetPhysicalDeviceFeatures2);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_physical_device_features2
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_physical_device_properties2: unsafe {
                extern "system" fn get_physical_device_properties2(
                    _physical_device: PhysicalDevice,
                    _p_properties: *mut PhysicalDeviceProperties2,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_physical_device_properties2)
                    ))
                }
                let raw_name = stringify!(vkGetPhysicalDeviceProperties2);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_physical_device_properties2
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_physical_device_format_properties2: unsafe {
                extern "system" fn get_physical_device_format_properties2(
                    _physical_device: PhysicalDevice,
                    _format: Format,
                    _p_format_properties: *mut FormatProperties2,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_physical_device_format_properties2)
                    ))
                }
                let raw_name = stringify!(vkGetPhysicalDeviceFormatProperties2);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_physical_device_format_properties2
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_physical_device_image_format_properties2: unsafe {
                extern "system" fn get_physical_device_image_format_properties2(
                    _physical_device: PhysicalDevice,
                    _p_image_format_info: *const PhysicalDeviceImageFormatInfo2,
                    _p_image_format_properties: *mut ImageFormatProperties2,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_physical_device_image_format_properties2)
                    ))
                }
                let raw_name = stringify!(vkGetPhysicalDeviceImageFormatProperties2);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_physical_device_image_format_properties2
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_physical_device_queue_family_properties2: unsafe {
                extern "system" fn get_physical_device_queue_family_properties2(
                    _physical_device: PhysicalDevice,
                    _p_queue_family_property_count: *mut u32,
                    _p_queue_family_properties: *mut QueueFamilyProperties2,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_physical_device_queue_family_properties2)
                    ))
                }
                let raw_name = stringify!(vkGetPhysicalDeviceQueueFamilyProperties2);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_physical_device_queue_family_properties2
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_physical_device_memory_properties2: unsafe {
                extern "system" fn get_physical_device_memory_properties2(
                    _physical_device: PhysicalDevice,
                    _p_memory_properties: *mut PhysicalDeviceMemoryProperties2,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_physical_device_memory_properties2)
                    ))
                }
                let raw_name = stringify!(vkGetPhysicalDeviceMemoryProperties2);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_physical_device_memory_properties2
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_physical_device_sparse_image_format_properties2: unsafe {
                extern "system" fn get_physical_device_sparse_image_format_properties2(
                    _physical_device: PhysicalDevice,
                    _p_format_info: *const PhysicalDeviceSparseImageFormatInfo2,
                    _p_property_count: *mut u32,
                    _p_properties: *mut SparseImageFormatProperties2,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_physical_device_sparse_image_format_properties2)
                    ))
                }
                let raw_name = stringify!(vkGetPhysicalDeviceSparseImageFormatProperties2);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_physical_device_sparse_image_format_properties2
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_physical_device_external_buffer_properties: unsafe {
                extern "system" fn get_physical_device_external_buffer_properties(
                    _physical_device: PhysicalDevice,
                    _p_external_buffer_info: *const PhysicalDeviceExternalBufferInfo,
                    _p_external_buffer_properties: *mut ExternalBufferProperties,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_physical_device_external_buffer_properties)
                    ))
                }
                let raw_name = stringify!(vkGetPhysicalDeviceExternalBufferProperties);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_physical_device_external_buffer_properties
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_physical_device_external_fence_properties: unsafe {
                extern "system" fn get_physical_device_external_fence_properties(
                    _physical_device: PhysicalDevice,
                    _p_external_fence_info: *const PhysicalDeviceExternalFenceInfo,
                    _p_external_fence_properties: *mut ExternalFenceProperties,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_physical_device_external_fence_properties)
                    ))
                }
                let raw_name = stringify!(vkGetPhysicalDeviceExternalFenceProperties);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_physical_device_external_fence_properties
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_physical_device_external_semaphore_properties: unsafe {
                extern "system" fn get_physical_device_external_semaphore_properties(
                    _physical_device: PhysicalDevice,
                    _p_external_semaphore_info: *const PhysicalDeviceExternalSemaphoreInfo,
                    _p_external_semaphore_properties: *mut ExternalSemaphoreProperties,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_physical_device_external_semaphore_properties)
                    ))
                }
                let raw_name = stringify!(vkGetPhysicalDeviceExternalSemaphoreProperties);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_physical_device_external_semaphore_properties
                } else {
                    ::std::mem::transmute(val)
                }
            },
        }
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkEnumeratePhysicalDeviceGroups.html>"]
    pub unsafe fn enumerate_physical_device_groups(
        &self,
        instance: Instance,
        p_physical_device_group_count: *mut u32,
        p_physical_device_group_properties: *mut PhysicalDeviceGroupProperties,
    ) -> Result {
        (self.enumerate_physical_device_groups)(
            instance,
            p_physical_device_group_count,
            p_physical_device_group_properties,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceFeatures2.html>"]
    pub unsafe fn get_physical_device_features2(
        &self,
        physical_device: PhysicalDevice,
        p_features: *mut PhysicalDeviceFeatures2,
    ) -> c_void {
        (self.get_physical_device_features2)(physical_device, p_features)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceProperties2.html>"]
    pub unsafe fn get_physical_device_properties2(
        &self,
        physical_device: PhysicalDevice,
        p_properties: *mut PhysicalDeviceProperties2,
    ) -> c_void {
        (self.get_physical_device_properties2)(physical_device, p_properties)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceFormatProperties2.html>"]
    pub unsafe fn get_physical_device_format_properties2(
        &self,
        physical_device: PhysicalDevice,
        format: Format,
        p_format_properties: *mut FormatProperties2,
    ) -> c_void {
        (self.get_physical_device_format_properties2)(physical_device, format, p_format_properties)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceImageFormatProperties2.html>"]
    pub unsafe fn get_physical_device_image_format_properties2(
        &self,
        physical_device: PhysicalDevice,
        p_image_format_info: *const PhysicalDeviceImageFormatInfo2,
        p_image_format_properties: *mut ImageFormatProperties2,
    ) -> Result {
        (self.get_physical_device_image_format_properties2)(
            physical_device,
            p_image_format_info,
            p_image_format_properties,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceQueueFamilyProperties2.html>"]
    pub unsafe fn get_physical_device_queue_family_properties2(
        &self,
        physical_device: PhysicalDevice,
        p_queue_family_property_count: *mut u32,
        p_queue_family_properties: *mut QueueFamilyProperties2,
    ) -> c_void {
        (self.get_physical_device_queue_family_properties2)(
            physical_device,
            p_queue_family_property_count,
            p_queue_family_properties,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceMemoryProperties2.html>"]
    pub unsafe fn get_physical_device_memory_properties2(
        &self,
        physical_device: PhysicalDevice,
        p_memory_properties: *mut PhysicalDeviceMemoryProperties2,
    ) -> c_void {
        (self.get_physical_device_memory_properties2)(physical_device, p_memory_properties)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceSparseImageFormatProperties2.html>"]
    pub unsafe fn get_physical_device_sparse_image_format_properties2(
        &self,
        physical_device: PhysicalDevice,
        p_format_info: *const PhysicalDeviceSparseImageFormatInfo2,
        p_property_count: *mut u32,
        p_properties: *mut SparseImageFormatProperties2,
    ) -> c_void {
        (self.get_physical_device_sparse_image_format_properties2)(
            physical_device,
            p_format_info,
            p_property_count,
            p_properties,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceExternalBufferProperties.html>"]
    pub unsafe fn get_physical_device_external_buffer_properties(
        &self,
        physical_device: PhysicalDevice,
        p_external_buffer_info: *const PhysicalDeviceExternalBufferInfo,
        p_external_buffer_properties: *mut ExternalBufferProperties,
    ) -> c_void {
        (self.get_physical_device_external_buffer_properties)(
            physical_device,
            p_external_buffer_info,
            p_external_buffer_properties,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceExternalFenceProperties.html>"]
    pub unsafe fn get_physical_device_external_fence_properties(
        &self,
        physical_device: PhysicalDevice,
        p_external_fence_info: *const PhysicalDeviceExternalFenceInfo,
        p_external_fence_properties: *mut ExternalFenceProperties,
    ) -> c_void {
        (self.get_physical_device_external_fence_properties)(
            physical_device,
            p_external_fence_info,
            p_external_fence_properties,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetPhysicalDeviceExternalSemaphoreProperties.html>"]
    pub unsafe fn get_physical_device_external_semaphore_properties(
        &self,
        physical_device: PhysicalDevice,
        p_external_semaphore_info: *const PhysicalDeviceExternalSemaphoreInfo,
        p_external_semaphore_properties: *mut ExternalSemaphoreProperties,
    ) -> c_void {
        (self.get_physical_device_external_semaphore_properties)(
            physical_device,
            p_external_semaphore_info,
            p_external_semaphore_properties,
        )
    }
}
#[allow(non_camel_case_types)]
pub type PFN_vkGetDeviceQueue2 = extern "system" fn(
    device: Device,
    bind_info_count: u32,
    p_bind_infos: *const BindBufferMemoryInfo,
) -> Result;
pub struct DeviceFnV1_1 {
    pub bind_buffer_memory2: extern "system" fn(
        device: Device,
        bind_info_count: u32,
        p_bind_infos: *const BindBufferMemoryInfo,
    ) -> Result,
    pub bind_image_memory2: extern "system" fn(
        device: Device,
        bind_info_count: u32,
        p_bind_infos: *const BindImageMemoryInfo,
    ) -> Result,
    pub get_device_group_peer_memory_features: extern "system" fn(
        device: Device,
        heap_index: u32,
        local_device_index: u32,
        remote_device_index: u32,
        p_peer_memory_features: *mut PeerMemoryFeatureFlags,
    ) -> c_void,
    pub cmd_set_device_mask:
        extern "system" fn(command_buffer: CommandBuffer, device_mask: u32) -> c_void,
    pub cmd_dispatch_base: extern "system" fn(
        command_buffer: CommandBuffer,
        base_group_x: u32,
        base_group_y: u32,
        base_group_z: u32,
        group_count_x: u32,
        group_count_y: u32,
        group_count_z: u32,
    ) -> c_void,
    pub get_image_memory_requirements2: extern "system" fn(
        device: Device,
        p_info: *const ImageMemoryRequirementsInfo2,
        p_memory_requirements: *mut MemoryRequirements2,
    ) -> c_void,
    pub get_buffer_memory_requirements2: extern "system" fn(
        device: Device,
        p_info: *const BufferMemoryRequirementsInfo2,
        p_memory_requirements: *mut MemoryRequirements2,
    ) -> c_void,
    pub get_image_sparse_memory_requirements2: extern "system" fn(
        device: Device,
        p_info: *const ImageSparseMemoryRequirementsInfo2,
        p_sparse_memory_requirement_count: *mut u32,
        p_sparse_memory_requirements: *mut SparseImageMemoryRequirements2,
    ) -> c_void,
    pub trim_command_pool: extern "system" fn(
        device: Device,
        command_pool: CommandPool,
        flags: CommandPoolTrimFlags,
    ) -> c_void,
    pub get_device_queue2: extern "system" fn(
        device: Device,
        p_queue_info: *const DeviceQueueInfo2,
        p_queue: *mut Queue,
    ) -> c_void,
    pub create_sampler_ycbcr_conversion: extern "system" fn(
        device: Device,
        p_create_info: *const SamplerYcbcrConversionCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_ycbcr_conversion: *mut SamplerYcbcrConversion,
    ) -> Result,
    pub destroy_sampler_ycbcr_conversion: extern "system" fn(
        device: Device,
        ycbcr_conversion: SamplerYcbcrConversion,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub create_descriptor_update_template: extern "system" fn(
        device: Device,
        p_create_info: *const DescriptorUpdateTemplateCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_descriptor_update_template: *mut DescriptorUpdateTemplate,
    ) -> Result,
    pub destroy_descriptor_update_template: extern "system" fn(
        device: Device,
        descriptor_update_template: DescriptorUpdateTemplate,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void,
    pub update_descriptor_set_with_template: extern "system" fn(
        device: Device,
        descriptor_set: DescriptorSet,
        descriptor_update_template: DescriptorUpdateTemplate,
        p_data: *const c_void,
    ) -> c_void,
    pub get_descriptor_set_layout_support: extern "system" fn(
        device: Device,
        p_create_info: *const DescriptorSetLayoutCreateInfo,
        p_support: *mut DescriptorSetLayoutSupport,
    ) -> c_void,
}
unsafe impl Send for DeviceFnV1_1 {}
unsafe impl Sync for DeviceFnV1_1 {}
impl ::std::clone::Clone for DeviceFnV1_1 {
    fn clone(&self) -> Self {
        DeviceFnV1_1 {
            bind_buffer_memory2: self.bind_buffer_memory2,
            bind_image_memory2: self.bind_image_memory2,
            get_device_group_peer_memory_features: self.get_device_group_peer_memory_features,
            cmd_set_device_mask: self.cmd_set_device_mask,
            cmd_dispatch_base: self.cmd_dispatch_base,
            get_image_memory_requirements2: self.get_image_memory_requirements2,
            get_buffer_memory_requirements2: self.get_buffer_memory_requirements2,
            get_image_sparse_memory_requirements2: self.get_image_sparse_memory_requirements2,
            trim_command_pool: self.trim_command_pool,
            get_device_queue2: self.get_device_queue2,
            create_sampler_ycbcr_conversion: self.create_sampler_ycbcr_conversion,
            destroy_sampler_ycbcr_conversion: self.destroy_sampler_ycbcr_conversion,
            create_descriptor_update_template: self.create_descriptor_update_template,
            destroy_descriptor_update_template: self.destroy_descriptor_update_template,
            update_descriptor_set_with_template: self.update_descriptor_set_with_template,
            get_descriptor_set_layout_support: self.get_descriptor_set_layout_support,
        }
    }
}
impl DeviceFnV1_1 {
    pub fn load<F>(mut _f: F) -> Self
    where
        F: FnMut(&::std::ffi::CStr) -> *const c_void,
    {
        DeviceFnV1_1 {
            bind_buffer_memory2: unsafe {
                extern "system" fn bind_buffer_memory2(
                    _device: Device,
                    _bind_info_count: u32,
                    _p_bind_infos: *const BindBufferMemoryInfo,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(bind_buffer_memory2)))
                }
                let raw_name = stringify!(vkBindBufferMemory2);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    bind_buffer_memory2
                } else {
                    ::std::mem::transmute(val)
                }
            },
            bind_image_memory2: unsafe {
                extern "system" fn bind_image_memory2(
                    _device: Device,
                    _bind_info_count: u32,
                    _p_bind_infos: *const BindImageMemoryInfo,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(bind_image_memory2)))
                }
                let raw_name = stringify!(vkBindImageMemory2);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    bind_image_memory2
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_device_group_peer_memory_features: unsafe {
                extern "system" fn get_device_group_peer_memory_features(
                    _device: Device,
                    _heap_index: u32,
                    _local_device_index: u32,
                    _remote_device_index: u32,
                    _p_peer_memory_features: *mut PeerMemoryFeatureFlags,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_device_group_peer_memory_features)
                    ))
                }
                let raw_name = stringify!(vkGetDeviceGroupPeerMemoryFeatures);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_device_group_peer_memory_features
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_set_device_mask: unsafe {
                extern "system" fn cmd_set_device_mask(
                    _command_buffer: CommandBuffer,
                    _device_mask: u32,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_set_device_mask)))
                }
                let raw_name = stringify!(vkCmdSetDeviceMask);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_set_device_mask
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_dispatch_base: unsafe {
                extern "system" fn cmd_dispatch_base(
                    _command_buffer: CommandBuffer,
                    _base_group_x: u32,
                    _base_group_y: u32,
                    _base_group_z: u32,
                    _group_count_x: u32,
                    _group_count_y: u32,
                    _group_count_z: u32,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_dispatch_base)))
                }
                let raw_name = stringify!(vkCmdDispatchBase);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_dispatch_base
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_image_memory_requirements2: unsafe {
                extern "system" fn get_image_memory_requirements2(
                    _device: Device,
                    _p_info: *const ImageMemoryRequirementsInfo2,
                    _p_memory_requirements: *mut MemoryRequirements2,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_image_memory_requirements2)
                    ))
                }
                let raw_name = stringify!(vkGetImageMemoryRequirements2);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_image_memory_requirements2
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_buffer_memory_requirements2: unsafe {
                extern "system" fn get_buffer_memory_requirements2(
                    _device: Device,
                    _p_info: *const BufferMemoryRequirementsInfo2,
                    _p_memory_requirements: *mut MemoryRequirements2,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_buffer_memory_requirements2)
                    ))
                }
                let raw_name = stringify!(vkGetBufferMemoryRequirements2);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_buffer_memory_requirements2
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_image_sparse_memory_requirements2: unsafe {
                extern "system" fn get_image_sparse_memory_requirements2(
                    _device: Device,
                    _p_info: *const ImageSparseMemoryRequirementsInfo2,
                    _p_sparse_memory_requirement_count: *mut u32,
                    _p_sparse_memory_requirements: *mut SparseImageMemoryRequirements2,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_image_sparse_memory_requirements2)
                    ))
                }
                let raw_name = stringify!(vkGetImageSparseMemoryRequirements2);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_image_sparse_memory_requirements2
                } else {
                    ::std::mem::transmute(val)
                }
            },
            trim_command_pool: unsafe {
                extern "system" fn trim_command_pool(
                    _device: Device,
                    _command_pool: CommandPool,
                    _flags: CommandPoolTrimFlags,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(trim_command_pool)))
                }
                let raw_name = stringify!(vkTrimCommandPool);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    trim_command_pool
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_device_queue2: unsafe {
                extern "system" fn get_device_queue2(
                    _device: Device,
                    _p_queue_info: *const DeviceQueueInfo2,
                    _p_queue: *mut Queue,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(get_device_queue2)))
                }
                let raw_name = stringify!(vkGetDeviceQueue2);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_device_queue2
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_sampler_ycbcr_conversion: unsafe {
                extern "system" fn create_sampler_ycbcr_conversion(
                    _device: Device,
                    _p_create_info: *const SamplerYcbcrConversionCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_ycbcr_conversion: *mut SamplerYcbcrConversion,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(create_sampler_ycbcr_conversion)
                    ))
                }
                let raw_name = stringify!(vkCreateSamplerYcbcrConversion);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_sampler_ycbcr_conversion
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_sampler_ycbcr_conversion: unsafe {
                extern "system" fn destroy_sampler_ycbcr_conversion(
                    _device: Device,
                    _ycbcr_conversion: SamplerYcbcrConversion,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(destroy_sampler_ycbcr_conversion)
                    ))
                }
                let raw_name = stringify!(vkDestroySamplerYcbcrConversion);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_sampler_ycbcr_conversion
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_descriptor_update_template: unsafe {
                extern "system" fn create_descriptor_update_template(
                    _device: Device,
                    _p_create_info: *const DescriptorUpdateTemplateCreateInfo,
                    _p_allocator: *const AllocationCallbacks,
                    _p_descriptor_update_template: *mut DescriptorUpdateTemplate,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(create_descriptor_update_template)
                    ))
                }
                let raw_name = stringify!(vkCreateDescriptorUpdateTemplate);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_descriptor_update_template
                } else {
                    ::std::mem::transmute(val)
                }
            },
            destroy_descriptor_update_template: unsafe {
                extern "system" fn destroy_descriptor_update_template(
                    _device: Device,
                    _descriptor_update_template: DescriptorUpdateTemplate,
                    _p_allocator: *const AllocationCallbacks,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(destroy_descriptor_update_template)
                    ))
                }
                let raw_name = stringify!(vkDestroyDescriptorUpdateTemplate);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    destroy_descriptor_update_template
                } else {
                    ::std::mem::transmute(val)
                }
            },
            update_descriptor_set_with_template: unsafe {
                extern "system" fn update_descriptor_set_with_template(
                    _device: Device,
                    _descriptor_set: DescriptorSet,
                    _descriptor_update_template: DescriptorUpdateTemplate,
                    _p_data: *const c_void,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(update_descriptor_set_with_template)
                    ))
                }
                let raw_name = stringify!(vkUpdateDescriptorSetWithTemplate);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    update_descriptor_set_with_template
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_descriptor_set_layout_support: unsafe {
                extern "system" fn get_descriptor_set_layout_support(
                    _device: Device,
                    _p_create_info: *const DescriptorSetLayoutCreateInfo,
                    _p_support: *mut DescriptorSetLayoutSupport,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_descriptor_set_layout_support)
                    ))
                }
                let raw_name = stringify!(vkGetDescriptorSetLayoutSupport);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_descriptor_set_layout_support
                } else {
                    ::std::mem::transmute(val)
                }
            },
        }
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkBindBufferMemory2.html>"]
    pub unsafe fn bind_buffer_memory2(
        &self,
        device: Device,
        bind_info_count: u32,
        p_bind_infos: *const BindBufferMemoryInfo,
    ) -> Result {
        (self.bind_buffer_memory2)(device, bind_info_count, p_bind_infos)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkBindImageMemory2.html>"]
    pub unsafe fn bind_image_memory2(
        &self,
        device: Device,
        bind_info_count: u32,
        p_bind_infos: *const BindImageMemoryInfo,
    ) -> Result {
        (self.bind_image_memory2)(device, bind_info_count, p_bind_infos)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeviceGroupPeerMemoryFeatures.html>"]
    pub unsafe fn get_device_group_peer_memory_features(
        &self,
        device: Device,
        heap_index: u32,
        local_device_index: u32,
        remote_device_index: u32,
        p_peer_memory_features: *mut PeerMemoryFeatureFlags,
    ) -> c_void {
        (self.get_device_group_peer_memory_features)(
            device,
            heap_index,
            local_device_index,
            remote_device_index,
            p_peer_memory_features,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetDeviceMask.html>"]
    pub unsafe fn cmd_set_device_mask(
        &self,
        command_buffer: CommandBuffer,
        device_mask: u32,
    ) -> c_void {
        (self.cmd_set_device_mask)(command_buffer, device_mask)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDispatchBase.html>"]
    pub unsafe fn cmd_dispatch_base(
        &self,
        command_buffer: CommandBuffer,
        base_group_x: u32,
        base_group_y: u32,
        base_group_z: u32,
        group_count_x: u32,
        group_count_y: u32,
        group_count_z: u32,
    ) -> c_void {
        (self.cmd_dispatch_base)(
            command_buffer,
            base_group_x,
            base_group_y,
            base_group_z,
            group_count_x,
            group_count_y,
            group_count_z,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetImageMemoryRequirements2.html>"]
    pub unsafe fn get_image_memory_requirements2(
        &self,
        device: Device,
        p_info: *const ImageMemoryRequirementsInfo2,
        p_memory_requirements: *mut MemoryRequirements2,
    ) -> c_void {
        (self.get_image_memory_requirements2)(device, p_info, p_memory_requirements)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetBufferMemoryRequirements2.html>"]
    pub unsafe fn get_buffer_memory_requirements2(
        &self,
        device: Device,
        p_info: *const BufferMemoryRequirementsInfo2,
        p_memory_requirements: *mut MemoryRequirements2,
    ) -> c_void {
        (self.get_buffer_memory_requirements2)(device, p_info, p_memory_requirements)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetImageSparseMemoryRequirements2.html>"]
    pub unsafe fn get_image_sparse_memory_requirements2(
        &self,
        device: Device,
        p_info: *const ImageSparseMemoryRequirementsInfo2,
        p_sparse_memory_requirement_count: *mut u32,
        p_sparse_memory_requirements: *mut SparseImageMemoryRequirements2,
    ) -> c_void {
        (self.get_image_sparse_memory_requirements2)(
            device,
            p_info,
            p_sparse_memory_requirement_count,
            p_sparse_memory_requirements,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkTrimCommandPool.html>"]
    pub unsafe fn trim_command_pool(
        &self,
        device: Device,
        command_pool: CommandPool,
        flags: CommandPoolTrimFlags,
    ) -> c_void {
        (self.trim_command_pool)(device, command_pool, flags)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeviceQueue2.html>"]
    pub unsafe fn get_device_queue2(
        &self,
        device: Device,
        p_queue_info: *const DeviceQueueInfo2,
        p_queue: *mut Queue,
    ) -> c_void {
        (self.get_device_queue2)(device, p_queue_info, p_queue)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateSamplerYcbcrConversion.html>"]
    pub unsafe fn create_sampler_ycbcr_conversion(
        &self,
        device: Device,
        p_create_info: *const SamplerYcbcrConversionCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_ycbcr_conversion: *mut SamplerYcbcrConversion,
    ) -> Result {
        (self.create_sampler_ycbcr_conversion)(
            device,
            p_create_info,
            p_allocator,
            p_ycbcr_conversion,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroySamplerYcbcrConversion.html>"]
    pub unsafe fn destroy_sampler_ycbcr_conversion(
        &self,
        device: Device,
        ycbcr_conversion: SamplerYcbcrConversion,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_sampler_ycbcr_conversion)(device, ycbcr_conversion, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateDescriptorUpdateTemplate.html>"]
    pub unsafe fn create_descriptor_update_template(
        &self,
        device: Device,
        p_create_info: *const DescriptorUpdateTemplateCreateInfo,
        p_allocator: *const AllocationCallbacks,
        p_descriptor_update_template: *mut DescriptorUpdateTemplate,
    ) -> Result {
        (self.create_descriptor_update_template)(
            device,
            p_create_info,
            p_allocator,
            p_descriptor_update_template,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkDestroyDescriptorUpdateTemplate.html>"]
    pub unsafe fn destroy_descriptor_update_template(
        &self,
        device: Device,
        descriptor_update_template: DescriptorUpdateTemplate,
        p_allocator: *const AllocationCallbacks,
    ) -> c_void {
        (self.destroy_descriptor_update_template)(device, descriptor_update_template, p_allocator)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkUpdateDescriptorSetWithTemplate.html>"]
    pub unsafe fn update_descriptor_set_with_template(
        &self,
        device: Device,
        descriptor_set: DescriptorSet,
        descriptor_update_template: DescriptorUpdateTemplate,
        p_data: *const c_void,
    ) -> c_void {
        (self.update_descriptor_set_with_template)(
            device,
            descriptor_set,
            descriptor_update_template,
            p_data,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDescriptorSetLayoutSupport.html>"]
    pub unsafe fn get_descriptor_set_layout_support(
        &self,
        device: Device,
        p_create_info: *const DescriptorSetLayoutCreateInfo,
        p_support: *mut DescriptorSetLayoutSupport,
    ) -> c_void {
        (self.get_descriptor_set_layout_support)(device, p_create_info, p_support)
    }
}
pub struct EntryFnV1_2 {}
unsafe impl Send for EntryFnV1_2 {}
unsafe impl Sync for EntryFnV1_2 {}
impl ::std::clone::Clone for EntryFnV1_2 {
    fn clone(&self) -> Self {
        EntryFnV1_2 {}
    }
}
impl EntryFnV1_2 {
    pub fn load<F>(mut _f: F) -> Self
    where
        F: FnMut(&::std::ffi::CStr) -> *const c_void,
    {
        EntryFnV1_2 {}
    }
}
pub struct InstanceFnV1_2 {}
unsafe impl Send for InstanceFnV1_2 {}
unsafe impl Sync for InstanceFnV1_2 {}
impl ::std::clone::Clone for InstanceFnV1_2 {
    fn clone(&self) -> Self {
        InstanceFnV1_2 {}
    }
}
impl InstanceFnV1_2 {
    pub fn load<F>(mut _f: F) -> Self
    where
        F: FnMut(&::std::ffi::CStr) -> *const c_void,
    {
        InstanceFnV1_2 {}
    }
}
pub struct DeviceFnV1_2 {
    pub cmd_draw_indirect_count: extern "system" fn(
        command_buffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        count_buffer: Buffer,
        count_buffer_offset: DeviceSize,
        max_draw_count: u32,
        stride: u32,
    ) -> c_void,
    pub cmd_draw_indexed_indirect_count: extern "system" fn(
        command_buffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        count_buffer: Buffer,
        count_buffer_offset: DeviceSize,
        max_draw_count: u32,
        stride: u32,
    ) -> c_void,
    pub create_render_pass2: extern "system" fn(
        device: Device,
        p_create_info: *const RenderPassCreateInfo2,
        p_allocator: *const AllocationCallbacks,
        p_render_pass: *mut RenderPass,
    ) -> Result,
    pub cmd_begin_render_pass2: extern "system" fn(
        command_buffer: CommandBuffer,
        p_render_pass_begin: *const RenderPassBeginInfo,
        p_subpass_begin_info: *const SubpassBeginInfo,
    ) -> c_void,
    pub cmd_next_subpass2: extern "system" fn(
        command_buffer: CommandBuffer,
        p_subpass_begin_info: *const SubpassBeginInfo,
        p_subpass_end_info: *const SubpassEndInfo,
    ) -> c_void,
    pub cmd_end_render_pass2: extern "system" fn(
        command_buffer: CommandBuffer,
        p_subpass_end_info: *const SubpassEndInfo,
    ) -> c_void,
    pub reset_query_pool: extern "system" fn(
        device: Device,
        query_pool: QueryPool,
        first_query: u32,
        query_count: u32,
    ) -> c_void,
    pub get_semaphore_counter_value:
        extern "system" fn(device: Device, semaphore: Semaphore, p_value: *mut u64) -> Result,
    pub wait_semaphores: extern "system" fn(
        device: Device,
        p_wait_info: *const SemaphoreWaitInfo,
        timeout: u64,
    ) -> Result,
    pub signal_semaphore:
        extern "system" fn(device: Device, p_signal_info: *const SemaphoreSignalInfo) -> Result,
    pub get_buffer_device_address:
        extern "system" fn(device: Device, p_info: *const BufferDeviceAddressInfo) -> DeviceAddress,
    pub get_buffer_opaque_capture_address:
        extern "system" fn(device: Device, p_info: *const BufferDeviceAddressInfo) -> u64,
    pub get_device_memory_opaque_capture_address: extern "system" fn(
        device: Device,
        p_info: *const DeviceMemoryOpaqueCaptureAddressInfo,
    ) -> u64,
}
unsafe impl Send for DeviceFnV1_2 {}
unsafe impl Sync for DeviceFnV1_2 {}
impl ::std::clone::Clone for DeviceFnV1_2 {
    fn clone(&self) -> Self {
        DeviceFnV1_2 {
            cmd_draw_indirect_count: self.cmd_draw_indirect_count,
            cmd_draw_indexed_indirect_count: self.cmd_draw_indexed_indirect_count,
            create_render_pass2: self.create_render_pass2,
            cmd_begin_render_pass2: self.cmd_begin_render_pass2,
            cmd_next_subpass2: self.cmd_next_subpass2,
            cmd_end_render_pass2: self.cmd_end_render_pass2,
            reset_query_pool: self.reset_query_pool,
            get_semaphore_counter_value: self.get_semaphore_counter_value,
            wait_semaphores: self.wait_semaphores,
            signal_semaphore: self.signal_semaphore,
            get_buffer_device_address: self.get_buffer_device_address,
            get_buffer_opaque_capture_address: self.get_buffer_opaque_capture_address,
            get_device_memory_opaque_capture_address: self.get_device_memory_opaque_capture_address,
        }
    }
}
impl DeviceFnV1_2 {
    pub fn load<F>(mut _f: F) -> Self
    where
        F: FnMut(&::std::ffi::CStr) -> *const c_void,
    {
        DeviceFnV1_2 {
            cmd_draw_indirect_count: unsafe {
                extern "system" fn cmd_draw_indirect_count(
                    _command_buffer: CommandBuffer,
                    _buffer: Buffer,
                    _offset: DeviceSize,
                    _count_buffer: Buffer,
                    _count_buffer_offset: DeviceSize,
                    _max_draw_count: u32,
                    _stride: u32,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_draw_indirect_count)
                    ))
                }
                let raw_name = stringify!(vkCmdDrawIndirectCount);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_draw_indirect_count
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_draw_indexed_indirect_count: unsafe {
                extern "system" fn cmd_draw_indexed_indirect_count(
                    _command_buffer: CommandBuffer,
                    _buffer: Buffer,
                    _offset: DeviceSize,
                    _count_buffer: Buffer,
                    _count_buffer_offset: DeviceSize,
                    _max_draw_count: u32,
                    _stride: u32,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_draw_indexed_indirect_count)
                    ))
                }
                let raw_name = stringify!(vkCmdDrawIndexedIndirectCount);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_draw_indexed_indirect_count
                } else {
                    ::std::mem::transmute(val)
                }
            },
            create_render_pass2: unsafe {
                extern "system" fn create_render_pass2(
                    _device: Device,
                    _p_create_info: *const RenderPassCreateInfo2,
                    _p_allocator: *const AllocationCallbacks,
                    _p_render_pass: *mut RenderPass,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(create_render_pass2)))
                }
                let raw_name = stringify!(vkCreateRenderPass2);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    create_render_pass2
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_begin_render_pass2: unsafe {
                extern "system" fn cmd_begin_render_pass2(
                    _command_buffer: CommandBuffer,
                    _p_render_pass_begin: *const RenderPassBeginInfo,
                    _p_subpass_begin_info: *const SubpassBeginInfo,
                ) -> c_void {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(cmd_begin_render_pass2)
                    ))
                }
                let raw_name = stringify!(vkCmdBeginRenderPass2);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_begin_render_pass2
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_next_subpass2: unsafe {
                extern "system" fn cmd_next_subpass2(
                    _command_buffer: CommandBuffer,
                    _p_subpass_begin_info: *const SubpassBeginInfo,
                    _p_subpass_end_info: *const SubpassEndInfo,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_next_subpass2)))
                }
                let raw_name = stringify!(vkCmdNextSubpass2);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_next_subpass2
                } else {
                    ::std::mem::transmute(val)
                }
            },
            cmd_end_render_pass2: unsafe {
                extern "system" fn cmd_end_render_pass2(
                    _command_buffer: CommandBuffer,
                    _p_subpass_end_info: *const SubpassEndInfo,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(cmd_end_render_pass2)))
                }
                let raw_name = stringify!(vkCmdEndRenderPass2);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    cmd_end_render_pass2
                } else {
                    ::std::mem::transmute(val)
                }
            },
            reset_query_pool: unsafe {
                extern "system" fn reset_query_pool(
                    _device: Device,
                    _query_pool: QueryPool,
                    _first_query: u32,
                    _query_count: u32,
                ) -> c_void {
                    panic!(concat!("Unable to load ", stringify!(reset_query_pool)))
                }
                let raw_name = stringify!(vkResetQueryPool);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    reset_query_pool
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_semaphore_counter_value: unsafe {
                extern "system" fn get_semaphore_counter_value(
                    _device: Device,
                    _semaphore: Semaphore,
                    _p_value: *mut u64,
                ) -> Result {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_semaphore_counter_value)
                    ))
                }
                let raw_name = stringify!(vkGetSemaphoreCounterValue);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_semaphore_counter_value
                } else {
                    ::std::mem::transmute(val)
                }
            },
            wait_semaphores: unsafe {
                extern "system" fn wait_semaphores(
                    _device: Device,
                    _p_wait_info: *const SemaphoreWaitInfo,
                    _timeout: u64,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(wait_semaphores)))
                }
                let raw_name = stringify!(vkWaitSemaphores);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    wait_semaphores
                } else {
                    ::std::mem::transmute(val)
                }
            },
            signal_semaphore: unsafe {
                extern "system" fn signal_semaphore(
                    _device: Device,
                    _p_signal_info: *const SemaphoreSignalInfo,
                ) -> Result {
                    panic!(concat!("Unable to load ", stringify!(signal_semaphore)))
                }
                let raw_name = stringify!(vkSignalSemaphore);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    signal_semaphore
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_buffer_device_address: unsafe {
                extern "system" fn get_buffer_device_address(
                    _device: Device,
                    _p_info: *const BufferDeviceAddressInfo,
                ) -> DeviceAddress {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_buffer_device_address)
                    ))
                }
                let raw_name = stringify!(vkGetBufferDeviceAddress);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_buffer_device_address
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_buffer_opaque_capture_address: unsafe {
                extern "system" fn get_buffer_opaque_capture_address(
                    _device: Device,
                    _p_info: *const BufferDeviceAddressInfo,
                ) -> u64 {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_buffer_opaque_capture_address)
                    ))
                }
                let raw_name = stringify!(vkGetBufferOpaqueCaptureAddress);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_buffer_opaque_capture_address
                } else {
                    ::std::mem::transmute(val)
                }
            },
            get_device_memory_opaque_capture_address: unsafe {
                extern "system" fn get_device_memory_opaque_capture_address(
                    _device: Device,
                    _p_info: *const DeviceMemoryOpaqueCaptureAddressInfo,
                ) -> u64 {
                    panic!(concat!(
                        "Unable to load ",
                        stringify!(get_device_memory_opaque_capture_address)
                    ))
                }
                let raw_name = stringify!(vkGetDeviceMemoryOpaqueCaptureAddress);
                let cname = ::std::ffi::CString::new(raw_name).unwrap();
                let val = _f(&cname);
                if val.is_null() {
                    get_device_memory_opaque_capture_address
                } else {
                    ::std::mem::transmute(val)
                }
            },
        }
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDrawIndirectCount.html>"]
    pub unsafe fn cmd_draw_indirect_count(
        &self,
        command_buffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        count_buffer: Buffer,
        count_buffer_offset: DeviceSize,
        max_draw_count: u32,
        stride: u32,
    ) -> c_void {
        (self.cmd_draw_indirect_count)(
            command_buffer,
            buffer,
            offset,
            count_buffer,
            count_buffer_offset,
            max_draw_count,
            stride,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDrawIndexedIndirectCount.html>"]
    pub unsafe fn cmd_draw_indexed_indirect_count(
        &self,
        command_buffer: CommandBuffer,
        buffer: Buffer,
        offset: DeviceSize,
        count_buffer: Buffer,
        count_buffer_offset: DeviceSize,
        max_draw_count: u32,
        stride: u32,
    ) -> c_void {
        (self.cmd_draw_indexed_indirect_count)(
            command_buffer,
            buffer,
            offset,
            count_buffer,
            count_buffer_offset,
            max_draw_count,
            stride,
        )
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCreateRenderPass2.html>"]
    pub unsafe fn create_render_pass2(
        &self,
        device: Device,
        p_create_info: *const RenderPassCreateInfo2,
        p_allocator: *const AllocationCallbacks,
        p_render_pass: *mut RenderPass,
    ) -> Result {
        (self.create_render_pass2)(device, p_create_info, p_allocator, p_render_pass)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdBeginRenderPass2.html>"]
    pub unsafe fn cmd_begin_render_pass2(
        &self,
        command_buffer: CommandBuffer,
        p_render_pass_begin: *const RenderPassBeginInfo,
        p_subpass_begin_info: *const SubpassBeginInfo,
    ) -> c_void {
        (self.cmd_begin_render_pass2)(command_buffer, p_render_pass_begin, p_subpass_begin_info)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdNextSubpass2.html>"]
    pub unsafe fn cmd_next_subpass2(
        &self,
        command_buffer: CommandBuffer,
        p_subpass_begin_info: *const SubpassBeginInfo,
        p_subpass_end_info: *const SubpassEndInfo,
    ) -> c_void {
        (self.cmd_next_subpass2)(command_buffer, p_subpass_begin_info, p_subpass_end_info)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdEndRenderPass2.html>"]
    pub unsafe fn cmd_end_render_pass2(
        &self,
        command_buffer: CommandBuffer,
        p_subpass_end_info: *const SubpassEndInfo,
    ) -> c_void {
        (self.cmd_end_render_pass2)(command_buffer, p_subpass_end_info)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkResetQueryPool.html>"]
    pub unsafe fn reset_query_pool(
        &self,
        device: Device,
        query_pool: QueryPool,
        first_query: u32,
        query_count: u32,
    ) -> c_void {
        (self.reset_query_pool)(device, query_pool, first_query, query_count)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetSemaphoreCounterValue.html>"]
    pub unsafe fn get_semaphore_counter_value(
        &self,
        device: Device,
        semaphore: Semaphore,
        p_value: *mut u64,
    ) -> Result {
        (self.get_semaphore_counter_value)(device, semaphore, p_value)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkWaitSemaphores.html>"]
    pub unsafe fn wait_semaphores(
        &self,
        device: Device,
        p_wait_info: *const SemaphoreWaitInfo,
        timeout: u64,
    ) -> Result {
        (self.wait_semaphores)(device, p_wait_info, timeout)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkSignalSemaphore.html>"]
    pub unsafe fn signal_semaphore(
        &self,
        device: Device,
        p_signal_info: *const SemaphoreSignalInfo,
    ) -> Result {
        (self.signal_semaphore)(device, p_signal_info)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetBufferDeviceAddress.html>"]
    pub unsafe fn get_buffer_device_address(
        &self,
        device: Device,
        p_info: *const BufferDeviceAddressInfo,
    ) -> DeviceAddress {
        (self.get_buffer_device_address)(device, p_info)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetBufferOpaqueCaptureAddress.html>"]
    pub unsafe fn get_buffer_opaque_capture_address(
        &self,
        device: Device,
        p_info: *const BufferDeviceAddressInfo,
    ) -> u64 {
        (self.get_buffer_opaque_capture_address)(device, p_info)
    }
    #[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeviceMemoryOpaqueCaptureAddress.html>"]
    pub unsafe fn get_device_memory_opaque_capture_address(
        &self,
        device: Device,
        p_info: *const DeviceMemoryOpaqueCaptureAddressInfo,
    ) -> u64 {
        (self.get_device_memory_opaque_capture_address)(device, p_info)
    }
}
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSampleMask.html>"]
pub type SampleMask = u32;
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBool32.html>"]
pub type Bool32 = u32;
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFlags.html>"]
pub type Flags = u32;
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceSize.html>"]
pub type DeviceSize = u64;
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceAddress.html>"]
pub type DeviceAddress = u64;
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueryPoolCreateFlags.html>"]
pub struct QueryPoolCreateFlags(Flags);
vk_bitflags_wrapped!(QueryPoolCreateFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineLayoutCreateFlags.html>"]
pub struct PipelineLayoutCreateFlags(Flags);
vk_bitflags_wrapped!(PipelineLayoutCreateFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineDepthStencilStateCreateFlags.html>"]
pub struct PipelineDepthStencilStateCreateFlags(Flags);
vk_bitflags_wrapped!(PipelineDepthStencilStateCreateFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineDynamicStateCreateFlags.html>"]
pub struct PipelineDynamicStateCreateFlags(Flags);
vk_bitflags_wrapped!(PipelineDynamicStateCreateFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineColorBlendStateCreateFlags.html>"]
pub struct PipelineColorBlendStateCreateFlags(Flags);
vk_bitflags_wrapped!(PipelineColorBlendStateCreateFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineMultisampleStateCreateFlags.html>"]
pub struct PipelineMultisampleStateCreateFlags(Flags);
vk_bitflags_wrapped!(PipelineMultisampleStateCreateFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineRasterizationStateCreateFlags.html>"]
pub struct PipelineRasterizationStateCreateFlags(Flags);
vk_bitflags_wrapped!(PipelineRasterizationStateCreateFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineViewportStateCreateFlags.html>"]
pub struct PipelineViewportStateCreateFlags(Flags);
vk_bitflags_wrapped!(PipelineViewportStateCreateFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineTessellationStateCreateFlags.html>"]
pub struct PipelineTessellationStateCreateFlags(Flags);
vk_bitflags_wrapped!(PipelineTessellationStateCreateFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineInputAssemblyStateCreateFlags.html>"]
pub struct PipelineInputAssemblyStateCreateFlags(Flags);
vk_bitflags_wrapped!(PipelineInputAssemblyStateCreateFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineVertexInputStateCreateFlags.html>"]
pub struct PipelineVertexInputStateCreateFlags(Flags);
vk_bitflags_wrapped!(PipelineVertexInputStateCreateFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferViewCreateFlags.html>"]
pub struct BufferViewCreateFlags(Flags);
vk_bitflags_wrapped!(BufferViewCreateFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkInstanceCreateFlags.html>"]
pub struct InstanceCreateFlags(Flags);
vk_bitflags_wrapped!(InstanceCreateFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceCreateFlags.html>"]
pub struct DeviceCreateFlags(Flags);
vk_bitflags_wrapped!(DeviceCreateFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkEventCreateFlags.html>"]
pub struct EventCreateFlags(Flags);
vk_bitflags_wrapped!(EventCreateFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryMapFlags.html>"]
pub struct MemoryMapFlags(Flags);
vk_bitflags_wrapped!(MemoryMapFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorPoolResetFlags.html>"]
pub struct DescriptorPoolResetFlags(Flags);
vk_bitflags_wrapped!(DescriptorPoolResetFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorUpdateTemplateCreateFlags.html>"]
pub struct DescriptorUpdateTemplateCreateFlags(Flags);
vk_bitflags_wrapped!(DescriptorUpdateTemplateCreateFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayModeCreateFlagsKHR.html>"]
pub struct DisplayModeCreateFlagsKHR(Flags);
vk_bitflags_wrapped!(DisplayModeCreateFlagsKHR, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplaySurfaceCreateFlagsKHR.html>"]
pub struct DisplaySurfaceCreateFlagsKHR(Flags);
vk_bitflags_wrapped!(DisplaySurfaceCreateFlagsKHR, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAndroidSurfaceCreateFlagsKHR.html>"]
pub struct AndroidSurfaceCreateFlagsKHR(Flags);
vk_bitflags_wrapped!(AndroidSurfaceCreateFlagsKHR, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkViSurfaceCreateFlagsNN.html>"]
pub struct ViSurfaceCreateFlagsNN(Flags);
vk_bitflags_wrapped!(ViSurfaceCreateFlagsNN, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkWaylandSurfaceCreateFlagsKHR.html>"]
pub struct WaylandSurfaceCreateFlagsKHR(Flags);
vk_bitflags_wrapped!(WaylandSurfaceCreateFlagsKHR, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkWin32SurfaceCreateFlagsKHR.html>"]
pub struct Win32SurfaceCreateFlagsKHR(Flags);
vk_bitflags_wrapped!(Win32SurfaceCreateFlagsKHR, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkXlibSurfaceCreateFlagsKHR.html>"]
pub struct XlibSurfaceCreateFlagsKHR(Flags);
vk_bitflags_wrapped!(XlibSurfaceCreateFlagsKHR, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkXcbSurfaceCreateFlagsKHR.html>"]
pub struct XcbSurfaceCreateFlagsKHR(Flags);
vk_bitflags_wrapped!(XcbSurfaceCreateFlagsKHR, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkIOSSurfaceCreateFlagsMVK.html>"]
pub struct IOSSurfaceCreateFlagsMVK(Flags);
vk_bitflags_wrapped!(IOSSurfaceCreateFlagsMVK, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMacOSSurfaceCreateFlagsMVK.html>"]
pub struct MacOSSurfaceCreateFlagsMVK(Flags);
vk_bitflags_wrapped!(MacOSSurfaceCreateFlagsMVK, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMetalSurfaceCreateFlagsEXT.html>"]
pub struct MetalSurfaceCreateFlagsEXT(Flags);
vk_bitflags_wrapped!(MetalSurfaceCreateFlagsEXT, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImagePipeSurfaceCreateFlagsFUCHSIA.html>"]
pub struct ImagePipeSurfaceCreateFlagsFUCHSIA(Flags);
vk_bitflags_wrapped!(ImagePipeSurfaceCreateFlagsFUCHSIA, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkStreamDescriptorSurfaceCreateFlagsGGP.html>"]
pub struct StreamDescriptorSurfaceCreateFlagsGGP(Flags);
vk_bitflags_wrapped!(StreamDescriptorSurfaceCreateFlagsGGP, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkHeadlessSurfaceCreateFlagsEXT.html>"]
pub struct HeadlessSurfaceCreateFlagsEXT(Flags);
vk_bitflags_wrapped!(HeadlessSurfaceCreateFlagsEXT, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandPoolTrimFlags.html>"]
pub struct CommandPoolTrimFlags(Flags);
vk_bitflags_wrapped!(CommandPoolTrimFlags, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineViewportSwizzleStateCreateFlagsNV.html>"]
pub struct PipelineViewportSwizzleStateCreateFlagsNV(Flags);
vk_bitflags_wrapped!(PipelineViewportSwizzleStateCreateFlagsNV, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineDiscardRectangleStateCreateFlagsEXT.html>"]
pub struct PipelineDiscardRectangleStateCreateFlagsEXT(Flags);
vk_bitflags_wrapped!(PipelineDiscardRectangleStateCreateFlagsEXT, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCoverageToColorStateCreateFlagsNV.html>"]
pub struct PipelineCoverageToColorStateCreateFlagsNV(Flags);
vk_bitflags_wrapped!(PipelineCoverageToColorStateCreateFlagsNV, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCoverageModulationStateCreateFlagsNV.html>"]
pub struct PipelineCoverageModulationStateCreateFlagsNV(Flags);
vk_bitflags_wrapped!(PipelineCoverageModulationStateCreateFlagsNV, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCoverageReductionStateCreateFlagsNV.html>"]
pub struct PipelineCoverageReductionStateCreateFlagsNV(Flags);
vk_bitflags_wrapped!(PipelineCoverageReductionStateCreateFlagsNV, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkValidationCacheCreateFlagsEXT.html>"]
pub struct ValidationCacheCreateFlagsEXT(Flags);
vk_bitflags_wrapped!(ValidationCacheCreateFlagsEXT, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugUtilsMessengerCreateFlagsEXT.html>"]
pub struct DebugUtilsMessengerCreateFlagsEXT(Flags);
vk_bitflags_wrapped!(DebugUtilsMessengerCreateFlagsEXT, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugUtilsMessengerCallbackDataFlagsEXT.html>"]
pub struct DebugUtilsMessengerCallbackDataFlagsEXT(Flags);
vk_bitflags_wrapped!(DebugUtilsMessengerCallbackDataFlagsEXT, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineRasterizationConservativeStateCreateFlagsEXT.html>"]
pub struct PipelineRasterizationConservativeStateCreateFlagsEXT(Flags);
vk_bitflags_wrapped!(
    PipelineRasterizationConservativeStateCreateFlagsEXT,
    0b0,
    Flags
);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineRasterizationStateStreamCreateFlagsEXT.html>"]
pub struct PipelineRasterizationStateStreamCreateFlagsEXT(Flags);
vk_bitflags_wrapped!(PipelineRasterizationStateStreamCreateFlagsEXT, 0b0, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineRasterizationDepthClipStateCreateFlagsEXT.html>"]
pub struct PipelineRasterizationDepthClipStateCreateFlagsEXT(Flags);
vk_bitflags_wrapped!(
    PipelineRasterizationDepthClipStateCreateFlagsEXT,
    0b0,
    Flags
);
define_handle!(
    Instance,
    INSTANCE,
    doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkInstance.html>"
);
define_handle ! ( PhysicalDevice , PHYSICAL_DEVICE , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevice.html>" ) ;
define_handle!(
    Device,
    DEVICE,
    doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDevice.html>"
);
define_handle!(
    Queue,
    QUEUE,
    doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueue.html>"
);
define_handle ! ( CommandBuffer , COMMAND_BUFFER , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandBuffer.html>" ) ;
handle_nondispatchable ! ( DeviceMemory , DEVICE_MEMORY , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceMemory.html>" ) ;
handle_nondispatchable ! ( CommandPool , COMMAND_POOL , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandPool.html>" ) ;
handle_nondispatchable!(
    Buffer,
    BUFFER,
    doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBuffer.html>"
);
handle_nondispatchable!(
    BufferView,
    BUFFER_VIEW,
    doc =
        "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferView.html>"
);
handle_nondispatchable!(
    Image,
    IMAGE,
    doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImage.html>"
);
handle_nondispatchable!(
    ImageView,
    IMAGE_VIEW,
    doc =
        "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageView.html>"
);
handle_nondispatchable ! ( ShaderModule , SHADER_MODULE , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkShaderModule.html>" ) ;
handle_nondispatchable!(
    Pipeline,
    PIPELINE,
    doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipeline.html>"
);
handle_nondispatchable ! ( PipelineLayout , PIPELINE_LAYOUT , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineLayout.html>" ) ;
handle_nondispatchable!(
    Sampler,
    SAMPLER,
    doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSampler.html>"
);
handle_nondispatchable ! ( DescriptorSet , DESCRIPTOR_SET , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorSet.html>" ) ;
handle_nondispatchable ! ( DescriptorSetLayout , DESCRIPTOR_SET_LAYOUT , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorSetLayout.html>" ) ;
handle_nondispatchable ! ( DescriptorPool , DESCRIPTOR_POOL , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorPool.html>" ) ;
handle_nondispatchable!(
    Fence,
    FENCE,
    doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFence.html>"
);
handle_nondispatchable!(
    Semaphore,
    SEMAPHORE,
    doc =
        "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphore.html>"
);
handle_nondispatchable!(
    Event,
    EVENT,
    doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkEvent.html>"
);
handle_nondispatchable!(
    QueryPool,
    QUERY_POOL,
    doc =
        "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueryPool.html>"
);
handle_nondispatchable ! ( Framebuffer , FRAMEBUFFER , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFramebuffer.html>" ) ;
handle_nondispatchable!(
    RenderPass,
    RENDER_PASS,
    doc =
        "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRenderPass.html>"
);
handle_nondispatchable ! ( PipelineCache , PIPELINE_CACHE , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCache.html>" ) ;
handle_nondispatchable ! ( IndirectCommandsLayoutNV , INDIRECT_COMMANDS_LAYOUT_NV , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkIndirectCommandsLayoutNV.html>" ) ;
handle_nondispatchable ! ( DescriptorUpdateTemplate , DESCRIPTOR_UPDATE_TEMPLATE , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorUpdateTemplate.html>" ) ;
handle_nondispatchable ! ( SamplerYcbcrConversion , SAMPLER_YCBCR_CONVERSION , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerYcbcrConversion.html>" ) ;
handle_nondispatchable ! ( ValidationCacheEXT , VALIDATION_CACHE_EXT , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkValidationCacheEXT.html>" ) ;
handle_nondispatchable ! ( AccelerationStructureKHR , ACCELERATION_STRUCTURE_KHR , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAccelerationStructureKHR.html>" ) ;
handle_nondispatchable ! ( PerformanceConfigurationINTEL , PERFORMANCE_CONFIGURATION_INTEL , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPerformanceConfigurationINTEL.html>" ) ;
handle_nondispatchable ! ( DeferredOperationKHR , DEFERRED_OPERATION_KHR , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeferredOperationKHR.html>" ) ;
handle_nondispatchable!(
    DisplayKHR,
    DISPLAY_KHR,
    doc =
        "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayKHR.html>"
);
handle_nondispatchable ! ( DisplayModeKHR , DISPLAY_MODE_KHR , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayModeKHR.html>" ) ;
handle_nondispatchable!(
    SurfaceKHR,
    SURFACE_KHR,
    doc =
        "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSurfaceKHR.html>"
);
handle_nondispatchable ! ( SwapchainKHR , SWAPCHAIN_KHR , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSwapchainKHR.html>" ) ;
handle_nondispatchable ! ( DebugReportCallbackEXT , DEBUG_REPORT_CALLBACK_EXT , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugReportCallbackEXT.html>" ) ;
handle_nondispatchable ! ( DebugUtilsMessengerEXT , DEBUG_UTILS_MESSENGER_EXT , doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugUtilsMessengerEXT.html>" ) ;
#[allow(non_camel_case_types)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/PFN_vkInternalAllocationNotification.html>"]
pub type PFN_vkInternalAllocationNotification = Option<
    unsafe extern "system" fn(
        p_user_data: *mut c_void,
        size: usize,
        allocation_type: InternalAllocationType,
        allocation_scope: SystemAllocationScope,
    ) -> c_void,
>;
#[allow(non_camel_case_types)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/PFN_vkInternalFreeNotification.html>"]
pub type PFN_vkInternalFreeNotification = Option<
    unsafe extern "system" fn(
        p_user_data: *mut c_void,
        size: usize,
        allocation_type: InternalAllocationType,
        allocation_scope: SystemAllocationScope,
    ) -> c_void,
>;
#[allow(non_camel_case_types)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/PFN_vkReallocationFunction.html>"]
pub type PFN_vkReallocationFunction = Option<
    unsafe extern "system" fn(
        p_user_data: *mut c_void,
        p_original: *mut c_void,
        size: usize,
        alignment: usize,
        allocation_scope: SystemAllocationScope,
    ) -> *mut c_void,
>;
#[allow(non_camel_case_types)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/PFN_vkAllocationFunction.html>"]
pub type PFN_vkAllocationFunction = Option<
    unsafe extern "system" fn(
        p_user_data: *mut c_void,
        size: usize,
        alignment: usize,
        allocation_scope: SystemAllocationScope,
    ) -> *mut c_void,
>;
#[allow(non_camel_case_types)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/PFN_vkFreeFunction.html>"]
pub type PFN_vkFreeFunction =
    Option<unsafe extern "system" fn(p_user_data: *mut c_void, p_memory: *mut c_void) -> c_void>;
#[allow(non_camel_case_types)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/PFN_vkVoidFunction.html>"]
pub type PFN_vkVoidFunction = Option<unsafe extern "system" fn() -> c_void>;
#[allow(non_camel_case_types)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/PFN_vkDebugReportCallbackEXT.html>"]
pub type PFN_vkDebugReportCallbackEXT = Option<
    unsafe extern "system" fn(
        flags: DebugReportFlagsEXT,
        object_type: DebugReportObjectTypeEXT,
        object: u64,
        location: usize,
        message_code: i32,
        p_layer_prefix: *const c_char,
        p_message: *const c_char,
        p_user_data: *mut c_void,
    ) -> Bool32,
>;
#[allow(non_camel_case_types)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/PFN_vkDebugUtilsMessengerCallbackEXT.html>"]
pub type PFN_vkDebugUtilsMessengerCallbackEXT = Option<
    unsafe extern "system" fn(
        message_severity: DebugUtilsMessageSeverityFlagsEXT,
        message_types: DebugUtilsMessageTypeFlagsEXT,
        p_callback_data: *const DebugUtilsMessengerCallbackDataEXT,
        p_user_data: *mut c_void,
    ) -> Bool32,
>;
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBaseOutStructure.html>"]
pub struct BaseOutStructure {
    pub s_type: StructureType,
    pub p_next: *mut BaseOutStructure,
}
impl ::std::default::Default for BaseOutStructure {
    fn default() -> BaseOutStructure {
        BaseOutStructure {
            s_type: unsafe { ::std::mem::zeroed() },
            p_next: ::std::ptr::null_mut(),
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBaseInStructure.html>"]
pub struct BaseInStructure {
    pub s_type: StructureType,
    pub p_next: *const BaseInStructure,
}
impl ::std::default::Default for BaseInStructure {
    fn default() -> BaseInStructure {
        BaseInStructure {
            s_type: unsafe { ::std::mem::zeroed() },
            p_next: ::std::ptr::null(),
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq, Eq, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkOffset2D.html>"]
pub struct Offset2D {
    pub x: i32,
    pub y: i32,
}
impl Offset2D {
    pub fn builder<'a>() -> Offset2DBuilder<'a> {
        Offset2DBuilder {
            inner: Offset2D::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct Offset2DBuilder<'a> {
    inner: Offset2D,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for Offset2DBuilder<'a> {
    type Target = Offset2D;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for Offset2DBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> Offset2DBuilder<'a> {
    pub fn x(mut self, x: i32) -> Offset2DBuilder<'a> {
        self.inner.x = x;
        self
    }
    pub fn y(mut self, y: i32) -> Offset2DBuilder<'a> {
        self.inner.y = y;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> Offset2D {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq, Eq, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkOffset3D.html>"]
pub struct Offset3D {
    pub x: i32,
    pub y: i32,
    pub z: i32,
}
impl Offset3D {
    pub fn builder<'a>() -> Offset3DBuilder<'a> {
        Offset3DBuilder {
            inner: Offset3D::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct Offset3DBuilder<'a> {
    inner: Offset3D,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for Offset3DBuilder<'a> {
    type Target = Offset3D;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for Offset3DBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> Offset3DBuilder<'a> {
    pub fn x(mut self, x: i32) -> Offset3DBuilder<'a> {
        self.inner.x = x;
        self
    }
    pub fn y(mut self, y: i32) -> Offset3DBuilder<'a> {
        self.inner.y = y;
        self
    }
    pub fn z(mut self, z: i32) -> Offset3DBuilder<'a> {
        self.inner.z = z;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> Offset3D {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq, Eq, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExtent2D.html>"]
pub struct Extent2D {
    pub width: u32,
    pub height: u32,
}
impl Extent2D {
    pub fn builder<'a>() -> Extent2DBuilder<'a> {
        Extent2DBuilder {
            inner: Extent2D::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct Extent2DBuilder<'a> {
    inner: Extent2D,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for Extent2DBuilder<'a> {
    type Target = Extent2D;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for Extent2DBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> Extent2DBuilder<'a> {
    pub fn width(mut self, width: u32) -> Extent2DBuilder<'a> {
        self.inner.width = width;
        self
    }
    pub fn height(mut self, height: u32) -> Extent2DBuilder<'a> {
        self.inner.height = height;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> Extent2D {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq, Eq, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExtent3D.html>"]
pub struct Extent3D {
    pub width: u32,
    pub height: u32,
    pub depth: u32,
}
impl Extent3D {
    pub fn builder<'a>() -> Extent3DBuilder<'a> {
        Extent3DBuilder {
            inner: Extent3D::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct Extent3DBuilder<'a> {
    inner: Extent3D,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for Extent3DBuilder<'a> {
    type Target = Extent3D;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for Extent3DBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> Extent3DBuilder<'a> {
    pub fn width(mut self, width: u32) -> Extent3DBuilder<'a> {
        self.inner.width = width;
        self
    }
    pub fn height(mut self, height: u32) -> Extent3DBuilder<'a> {
        self.inner.height = height;
        self
    }
    pub fn depth(mut self, depth: u32) -> Extent3DBuilder<'a> {
        self.inner.depth = depth;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> Extent3D {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkViewport.html>"]
pub struct Viewport {
    pub x: f32,
    pub y: f32,
    pub width: f32,
    pub height: f32,
    pub min_depth: f32,
    pub max_depth: f32,
}
impl Viewport {
    pub fn builder<'a>() -> ViewportBuilder<'a> {
        ViewportBuilder {
            inner: Viewport::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ViewportBuilder<'a> {
    inner: Viewport,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ViewportBuilder<'a> {
    type Target = Viewport;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ViewportBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ViewportBuilder<'a> {
    pub fn x(mut self, x: f32) -> ViewportBuilder<'a> {
        self.inner.x = x;
        self
    }
    pub fn y(mut self, y: f32) -> ViewportBuilder<'a> {
        self.inner.y = y;
        self
    }
    pub fn width(mut self, width: f32) -> ViewportBuilder<'a> {
        self.inner.width = width;
        self
    }
    pub fn height(mut self, height: f32) -> ViewportBuilder<'a> {
        self.inner.height = height;
        self
    }
    pub fn min_depth(mut self, min_depth: f32) -> ViewportBuilder<'a> {
        self.inner.min_depth = min_depth;
        self
    }
    pub fn max_depth(mut self, max_depth: f32) -> ViewportBuilder<'a> {
        self.inner.max_depth = max_depth;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> Viewport {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq, Eq, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRect2D.html>"]
pub struct Rect2D {
    pub offset: Offset2D,
    pub extent: Extent2D,
}
impl Rect2D {
    pub fn builder<'a>() -> Rect2DBuilder<'a> {
        Rect2DBuilder {
            inner: Rect2D::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct Rect2DBuilder<'a> {
    inner: Rect2D,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for Rect2DBuilder<'a> {
    type Target = Rect2D;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for Rect2DBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> Rect2DBuilder<'a> {
    pub fn offset(mut self, offset: Offset2D) -> Rect2DBuilder<'a> {
        self.inner.offset = offset;
        self
    }
    pub fn extent(mut self, extent: Extent2D) -> Rect2DBuilder<'a> {
        self.inner.extent = extent;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> Rect2D {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq, Eq, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkClearRect.html>"]
pub struct ClearRect {
    pub rect: Rect2D,
    pub base_array_layer: u32,
    pub layer_count: u32,
}
impl ClearRect {
    pub fn builder<'a>() -> ClearRectBuilder<'a> {
        ClearRectBuilder {
            inner: ClearRect::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ClearRectBuilder<'a> {
    inner: ClearRect,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ClearRectBuilder<'a> {
    type Target = ClearRect;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ClearRectBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ClearRectBuilder<'a> {
    pub fn rect(mut self, rect: Rect2D) -> ClearRectBuilder<'a> {
        self.inner.rect = rect;
        self
    }
    pub fn base_array_layer(mut self, base_array_layer: u32) -> ClearRectBuilder<'a> {
        self.inner.base_array_layer = base_array_layer;
        self
    }
    pub fn layer_count(mut self, layer_count: u32) -> ClearRectBuilder<'a> {
        self.inner.layer_count = layer_count;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ClearRect {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkComponentMapping.html>"]
pub struct ComponentMapping {
    pub r: ComponentSwizzle,
    pub g: ComponentSwizzle,
    pub b: ComponentSwizzle,
    pub a: ComponentSwizzle,
}
impl ComponentMapping {
    pub fn builder<'a>() -> ComponentMappingBuilder<'a> {
        ComponentMappingBuilder {
            inner: ComponentMapping::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ComponentMappingBuilder<'a> {
    inner: ComponentMapping,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ComponentMappingBuilder<'a> {
    type Target = ComponentMapping;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ComponentMappingBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ComponentMappingBuilder<'a> {
    pub fn r(mut self, r: ComponentSwizzle) -> ComponentMappingBuilder<'a> {
        self.inner.r = r;
        self
    }
    pub fn g(mut self, g: ComponentSwizzle) -> ComponentMappingBuilder<'a> {
        self.inner.g = g;
        self
    }
    pub fn b(mut self, b: ComponentSwizzle) -> ComponentMappingBuilder<'a> {
        self.inner.b = b;
        self
    }
    pub fn a(mut self, a: ComponentSwizzle) -> ComponentMappingBuilder<'a> {
        self.inner.a = a;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ComponentMapping {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceProperties.html>"]
pub struct PhysicalDeviceProperties {
    pub api_version: u32,
    pub driver_version: u32,
    pub vendor_id: u32,
    pub device_id: u32,
    pub device_type: PhysicalDeviceType,
    pub device_name: [c_char; MAX_PHYSICAL_DEVICE_NAME_SIZE],
    pub pipeline_cache_uuid: [u8; UUID_SIZE],
    pub limits: PhysicalDeviceLimits,
    pub sparse_properties: PhysicalDeviceSparseProperties,
}
impl fmt::Debug for PhysicalDeviceProperties {
    fn fmt(&self, fmt: &mut fmt::Formatter) -> fmt::Result {
        fmt.debug_struct("PhysicalDeviceProperties")
            .field("api_version", &self.api_version)
            .field("driver_version", &self.driver_version)
            .field("vendor_id", &self.vendor_id)
            .field("device_id", &self.device_id)
            .field("device_type", &self.device_type)
            .field("device_name", &unsafe {
                ::std::ffi::CStr::from_ptr(self.device_name.as_ptr() as *const c_char)
            })
            .field("pipeline_cache_uuid", &self.pipeline_cache_uuid)
            .field("limits", &self.limits)
            .field("sparse_properties", &self.sparse_properties)
            .finish()
    }
}
impl ::std::default::Default for PhysicalDeviceProperties {
    fn default() -> PhysicalDeviceProperties {
        PhysicalDeviceProperties {
            api_version: u32::default(),
            driver_version: u32::default(),
            vendor_id: u32::default(),
            device_id: u32::default(),
            device_type: PhysicalDeviceType::default(),
            device_name: unsafe { ::std::mem::zeroed() },
            pipeline_cache_uuid: unsafe { ::std::mem::zeroed() },
            limits: PhysicalDeviceLimits::default(),
            sparse_properties: PhysicalDeviceSparseProperties::default(),
        }
    }
}
impl PhysicalDeviceProperties {
    pub fn builder<'a>() -> PhysicalDevicePropertiesBuilder<'a> {
        PhysicalDevicePropertiesBuilder {
            inner: PhysicalDeviceProperties::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDevicePropertiesBuilder<'a> {
    inner: PhysicalDeviceProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PhysicalDevicePropertiesBuilder<'a> {
    type Target = PhysicalDeviceProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDevicePropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDevicePropertiesBuilder<'a> {
    pub fn api_version(mut self, api_version: u32) -> PhysicalDevicePropertiesBuilder<'a> {
        self.inner.api_version = api_version;
        self
    }
    pub fn driver_version(mut self, driver_version: u32) -> PhysicalDevicePropertiesBuilder<'a> {
        self.inner.driver_version = driver_version;
        self
    }
    pub fn vendor_id(mut self, vendor_id: u32) -> PhysicalDevicePropertiesBuilder<'a> {
        self.inner.vendor_id = vendor_id;
        self
    }
    pub fn device_id(mut self, device_id: u32) -> PhysicalDevicePropertiesBuilder<'a> {
        self.inner.device_id = device_id;
        self
    }
    pub fn device_type(
        mut self,
        device_type: PhysicalDeviceType,
    ) -> PhysicalDevicePropertiesBuilder<'a> {
        self.inner.device_type = device_type;
        self
    }
    pub fn device_name(
        mut self,
        device_name: [c_char; MAX_PHYSICAL_DEVICE_NAME_SIZE],
    ) -> PhysicalDevicePropertiesBuilder<'a> {
        self.inner.device_name = device_name;
        self
    }
    pub fn pipeline_cache_uuid(
        mut self,
        pipeline_cache_uuid: [u8; UUID_SIZE],
    ) -> PhysicalDevicePropertiesBuilder<'a> {
        self.inner.pipeline_cache_uuid = pipeline_cache_uuid;
        self
    }
    pub fn limits(mut self, limits: PhysicalDeviceLimits) -> PhysicalDevicePropertiesBuilder<'a> {
        self.inner.limits = limits;
        self
    }
    pub fn sparse_properties(
        mut self,
        sparse_properties: PhysicalDeviceSparseProperties,
    ) -> PhysicalDevicePropertiesBuilder<'a> {
        self.inner.sparse_properties = sparse_properties;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceProperties {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExtensionProperties.html>"]
pub struct ExtensionProperties {
    pub extension_name: [c_char; MAX_EXTENSION_NAME_SIZE],
    pub spec_version: u32,
}
impl fmt::Debug for ExtensionProperties {
    fn fmt(&self, fmt: &mut fmt::Formatter) -> fmt::Result {
        fmt.debug_struct("ExtensionProperties")
            .field("extension_name", &unsafe {
                ::std::ffi::CStr::from_ptr(self.extension_name.as_ptr() as *const c_char)
            })
            .field("spec_version", &self.spec_version)
            .finish()
    }
}
impl ::std::default::Default for ExtensionProperties {
    fn default() -> ExtensionProperties {
        ExtensionProperties {
            extension_name: unsafe { ::std::mem::zeroed() },
            spec_version: u32::default(),
        }
    }
}
impl ExtensionProperties {
    pub fn builder<'a>() -> ExtensionPropertiesBuilder<'a> {
        ExtensionPropertiesBuilder {
            inner: ExtensionProperties::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExtensionPropertiesBuilder<'a> {
    inner: ExtensionProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ExtensionPropertiesBuilder<'a> {
    type Target = ExtensionProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExtensionPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExtensionPropertiesBuilder<'a> {
    pub fn extension_name(
        mut self,
        extension_name: [c_char; MAX_EXTENSION_NAME_SIZE],
    ) -> ExtensionPropertiesBuilder<'a> {
        self.inner.extension_name = extension_name;
        self
    }
    pub fn spec_version(mut self, spec_version: u32) -> ExtensionPropertiesBuilder<'a> {
        self.inner.spec_version = spec_version;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExtensionProperties {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkLayerProperties.html>"]
pub struct LayerProperties {
    pub layer_name: [c_char; MAX_EXTENSION_NAME_SIZE],
    pub spec_version: u32,
    pub implementation_version: u32,
    pub description: [c_char; MAX_DESCRIPTION_SIZE],
}
impl fmt::Debug for LayerProperties {
    fn fmt(&self, fmt: &mut fmt::Formatter) -> fmt::Result {
        fmt.debug_struct("LayerProperties")
            .field("layer_name", &unsafe {
                ::std::ffi::CStr::from_ptr(self.layer_name.as_ptr() as *const c_char)
            })
            .field("spec_version", &self.spec_version)
            .field("implementation_version", &self.implementation_version)
            .field("description", &unsafe {
                ::std::ffi::CStr::from_ptr(self.description.as_ptr() as *const c_char)
            })
            .finish()
    }
}
impl ::std::default::Default for LayerProperties {
    fn default() -> LayerProperties {
        LayerProperties {
            layer_name: unsafe { ::std::mem::zeroed() },
            spec_version: u32::default(),
            implementation_version: u32::default(),
            description: unsafe { ::std::mem::zeroed() },
        }
    }
}
impl LayerProperties {
    pub fn builder<'a>() -> LayerPropertiesBuilder<'a> {
        LayerPropertiesBuilder {
            inner: LayerProperties::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct LayerPropertiesBuilder<'a> {
    inner: LayerProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for LayerPropertiesBuilder<'a> {
    type Target = LayerProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for LayerPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> LayerPropertiesBuilder<'a> {
    pub fn layer_name(
        mut self,
        layer_name: [c_char; MAX_EXTENSION_NAME_SIZE],
    ) -> LayerPropertiesBuilder<'a> {
        self.inner.layer_name = layer_name;
        self
    }
    pub fn spec_version(mut self, spec_version: u32) -> LayerPropertiesBuilder<'a> {
        self.inner.spec_version = spec_version;
        self
    }
    pub fn implementation_version(
        mut self,
        implementation_version: u32,
    ) -> LayerPropertiesBuilder<'a> {
        self.inner.implementation_version = implementation_version;
        self
    }
    pub fn description(
        mut self,
        description: [c_char; MAX_DESCRIPTION_SIZE],
    ) -> LayerPropertiesBuilder<'a> {
        self.inner.description = description;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> LayerProperties {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkApplicationInfo.html>"]
pub struct ApplicationInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_application_name: *const c_char,
    pub application_version: u32,
    pub p_engine_name: *const c_char,
    pub engine_version: u32,
    pub api_version: u32,
}
impl ::std::default::Default for ApplicationInfo {
    fn default() -> ApplicationInfo {
        ApplicationInfo {
            s_type: StructureType::APPLICATION_INFO,
            p_next: ::std::ptr::null(),
            p_application_name: ::std::ptr::null(),
            application_version: u32::default(),
            p_engine_name: ::std::ptr::null(),
            engine_version: u32::default(),
            api_version: u32::default(),
        }
    }
}
impl ApplicationInfo {
    pub fn builder<'a>() -> ApplicationInfoBuilder<'a> {
        ApplicationInfoBuilder {
            inner: ApplicationInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ApplicationInfoBuilder<'a> {
    inner: ApplicationInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsApplicationInfo {}
impl<'a> ::std::ops::Deref for ApplicationInfoBuilder<'a> {
    type Target = ApplicationInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ApplicationInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ApplicationInfoBuilder<'a> {
    pub fn application_name(
        mut self,
        application_name: &'a ::std::ffi::CStr,
    ) -> ApplicationInfoBuilder<'a> {
        self.inner.p_application_name = application_name.as_ptr();
        self
    }
    pub fn application_version(mut self, application_version: u32) -> ApplicationInfoBuilder<'a> {
        self.inner.application_version = application_version;
        self
    }
    pub fn engine_name(mut self, engine_name: &'a ::std::ffi::CStr) -> ApplicationInfoBuilder<'a> {
        self.inner.p_engine_name = engine_name.as_ptr();
        self
    }
    pub fn engine_version(mut self, engine_version: u32) -> ApplicationInfoBuilder<'a> {
        self.inner.engine_version = engine_version;
        self
    }
    pub fn api_version(mut self, api_version: u32) -> ApplicationInfoBuilder<'a> {
        self.inner.api_version = api_version;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsApplicationInfo>(
        mut self,
        next: &'a mut T,
    ) -> ApplicationInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ApplicationInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAllocationCallbacks.html>"]
pub struct AllocationCallbacks {
    pub p_user_data: *mut c_void,
    pub pfn_allocation: PFN_vkAllocationFunction,
    pub pfn_reallocation: PFN_vkReallocationFunction,
    pub pfn_free: PFN_vkFreeFunction,
    pub pfn_internal_allocation: PFN_vkInternalAllocationNotification,
    pub pfn_internal_free: PFN_vkInternalFreeNotification,
}
impl fmt::Debug for AllocationCallbacks {
    fn fmt(&self, fmt: &mut fmt::Formatter) -> fmt::Result {
        fmt.debug_struct("AllocationCallbacks")
            .field("p_user_data", &self.p_user_data)
            .field(
                "pfn_allocation",
                &(self.pfn_allocation.map(|x| x as *const ())),
            )
            .field(
                "pfn_reallocation",
                &(self.pfn_reallocation.map(|x| x as *const ())),
            )
            .field("pfn_free", &(self.pfn_free.map(|x| x as *const ())))
            .field(
                "pfn_internal_allocation",
                &(self.pfn_internal_allocation.map(|x| x as *const ())),
            )
            .field(
                "pfn_internal_free",
                &(self.pfn_internal_free.map(|x| x as *const ())),
            )
            .finish()
    }
}
impl ::std::default::Default for AllocationCallbacks {
    fn default() -> AllocationCallbacks {
        AllocationCallbacks {
            p_user_data: ::std::ptr::null_mut(),
            pfn_allocation: PFN_vkAllocationFunction::default(),
            pfn_reallocation: PFN_vkReallocationFunction::default(),
            pfn_free: PFN_vkFreeFunction::default(),
            pfn_internal_allocation: PFN_vkInternalAllocationNotification::default(),
            pfn_internal_free: PFN_vkInternalFreeNotification::default(),
        }
    }
}
impl AllocationCallbacks {
    pub fn builder<'a>() -> AllocationCallbacksBuilder<'a> {
        AllocationCallbacksBuilder {
            inner: AllocationCallbacks::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct AllocationCallbacksBuilder<'a> {
    inner: AllocationCallbacks,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for AllocationCallbacksBuilder<'a> {
    type Target = AllocationCallbacks;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for AllocationCallbacksBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> AllocationCallbacksBuilder<'a> {
    pub fn user_data(mut self, user_data: *mut c_void) -> AllocationCallbacksBuilder<'a> {
        self.inner.p_user_data = user_data;
        self
    }
    pub fn pfn_allocation(
        mut self,
        pfn_allocation: PFN_vkAllocationFunction,
    ) -> AllocationCallbacksBuilder<'a> {
        self.inner.pfn_allocation = pfn_allocation;
        self
    }
    pub fn pfn_reallocation(
        mut self,
        pfn_reallocation: PFN_vkReallocationFunction,
    ) -> AllocationCallbacksBuilder<'a> {
        self.inner.pfn_reallocation = pfn_reallocation;
        self
    }
    pub fn pfn_free(mut self, pfn_free: PFN_vkFreeFunction) -> AllocationCallbacksBuilder<'a> {
        self.inner.pfn_free = pfn_free;
        self
    }
    pub fn pfn_internal_allocation(
        mut self,
        pfn_internal_allocation: PFN_vkInternalAllocationNotification,
    ) -> AllocationCallbacksBuilder<'a> {
        self.inner.pfn_internal_allocation = pfn_internal_allocation;
        self
    }
    pub fn pfn_internal_free(
        mut self,
        pfn_internal_free: PFN_vkInternalFreeNotification,
    ) -> AllocationCallbacksBuilder<'a> {
        self.inner.pfn_internal_free = pfn_internal_free;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> AllocationCallbacks {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceQueueCreateInfo.html>"]
pub struct DeviceQueueCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DeviceQueueCreateFlags,
    pub queue_family_index: u32,
    pub queue_count: u32,
    pub p_queue_priorities: *const f32,
}
impl ::std::default::Default for DeviceQueueCreateInfo {
    fn default() -> DeviceQueueCreateInfo {
        DeviceQueueCreateInfo {
            s_type: StructureType::DEVICE_QUEUE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: DeviceQueueCreateFlags::default(),
            queue_family_index: u32::default(),
            queue_count: u32::default(),
            p_queue_priorities: ::std::ptr::null(),
        }
    }
}
impl DeviceQueueCreateInfo {
    pub fn builder<'a>() -> DeviceQueueCreateInfoBuilder<'a> {
        DeviceQueueCreateInfoBuilder {
            inner: DeviceQueueCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DeviceQueueCreateInfoBuilder<'a> {
    inner: DeviceQueueCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsDeviceQueueCreateInfo {}
impl<'a> ::std::ops::Deref for DeviceQueueCreateInfoBuilder<'a> {
    type Target = DeviceQueueCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DeviceQueueCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DeviceQueueCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: DeviceQueueCreateFlags) -> DeviceQueueCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn queue_family_index(
        mut self,
        queue_family_index: u32,
    ) -> DeviceQueueCreateInfoBuilder<'a> {
        self.inner.queue_family_index = queue_family_index;
        self
    }
    pub fn queue_priorities(
        mut self,
        queue_priorities: &'a [f32],
    ) -> DeviceQueueCreateInfoBuilder<'a> {
        self.inner.queue_count = queue_priorities.len() as _;
        self.inner.p_queue_priorities = queue_priorities.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDeviceQueueCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> DeviceQueueCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DeviceQueueCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceCreateInfo.html>"]
pub struct DeviceCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DeviceCreateFlags,
    pub queue_create_info_count: u32,
    pub p_queue_create_infos: *const DeviceQueueCreateInfo,
    pub enabled_layer_count: u32,
    pub pp_enabled_layer_names: *const *const c_char,
    pub enabled_extension_count: u32,
    pub pp_enabled_extension_names: *const *const c_char,
    pub p_enabled_features: *const PhysicalDeviceFeatures,
}
impl ::std::default::Default for DeviceCreateInfo {
    fn default() -> DeviceCreateInfo {
        DeviceCreateInfo {
            s_type: StructureType::DEVICE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: DeviceCreateFlags::default(),
            queue_create_info_count: u32::default(),
            p_queue_create_infos: ::std::ptr::null(),
            enabled_layer_count: u32::default(),
            pp_enabled_layer_names: ::std::ptr::null(),
            enabled_extension_count: u32::default(),
            pp_enabled_extension_names: ::std::ptr::null(),
            p_enabled_features: ::std::ptr::null(),
        }
    }
}
impl DeviceCreateInfo {
    pub fn builder<'a>() -> DeviceCreateInfoBuilder<'a> {
        DeviceCreateInfoBuilder {
            inner: DeviceCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DeviceCreateInfoBuilder<'a> {
    inner: DeviceCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsDeviceCreateInfo {}
impl<'a> ::std::ops::Deref for DeviceCreateInfoBuilder<'a> {
    type Target = DeviceCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DeviceCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DeviceCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: DeviceCreateFlags) -> DeviceCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn queue_create_infos(
        mut self,
        queue_create_infos: &'a [DeviceQueueCreateInfo],
    ) -> DeviceCreateInfoBuilder<'a> {
        self.inner.queue_create_info_count = queue_create_infos.len() as _;
        self.inner.p_queue_create_infos = queue_create_infos.as_ptr();
        self
    }
    pub fn enabled_layer_names(
        mut self,
        enabled_layer_names: &'a [*const c_char],
    ) -> DeviceCreateInfoBuilder<'a> {
        self.inner.pp_enabled_layer_names = enabled_layer_names.as_ptr();
        self.inner.enabled_layer_count = enabled_layer_names.len() as _;
        self
    }
    pub fn enabled_extension_names(
        mut self,
        enabled_extension_names: &'a [*const c_char],
    ) -> DeviceCreateInfoBuilder<'a> {
        self.inner.pp_enabled_extension_names = enabled_extension_names.as_ptr();
        self.inner.enabled_extension_count = enabled_extension_names.len() as _;
        self
    }
    pub fn enabled_features(
        mut self,
        enabled_features: &'a PhysicalDeviceFeatures,
    ) -> DeviceCreateInfoBuilder<'a> {
        self.inner.p_enabled_features = enabled_features;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDeviceCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> DeviceCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DeviceCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkInstanceCreateInfo.html>"]
pub struct InstanceCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: InstanceCreateFlags,
    pub p_application_info: *const ApplicationInfo,
    pub enabled_layer_count: u32,
    pub pp_enabled_layer_names: *const *const c_char,
    pub enabled_extension_count: u32,
    pub pp_enabled_extension_names: *const *const c_char,
}
impl ::std::default::Default for InstanceCreateInfo {
    fn default() -> InstanceCreateInfo {
        InstanceCreateInfo {
            s_type: StructureType::INSTANCE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: InstanceCreateFlags::default(),
            p_application_info: ::std::ptr::null(),
            enabled_layer_count: u32::default(),
            pp_enabled_layer_names: ::std::ptr::null(),
            enabled_extension_count: u32::default(),
            pp_enabled_extension_names: ::std::ptr::null(),
        }
    }
}
impl InstanceCreateInfo {
    pub fn builder<'a>() -> InstanceCreateInfoBuilder<'a> {
        InstanceCreateInfoBuilder {
            inner: InstanceCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct InstanceCreateInfoBuilder<'a> {
    inner: InstanceCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsInstanceCreateInfo {}
impl<'a> ::std::ops::Deref for InstanceCreateInfoBuilder<'a> {
    type Target = InstanceCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for InstanceCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> InstanceCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: InstanceCreateFlags) -> InstanceCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn application_info(
        mut self,
        application_info: &'a ApplicationInfo,
    ) -> InstanceCreateInfoBuilder<'a> {
        self.inner.p_application_info = application_info;
        self
    }
    pub fn enabled_layer_names(
        mut self,
        enabled_layer_names: &'a [*const c_char],
    ) -> InstanceCreateInfoBuilder<'a> {
        self.inner.pp_enabled_layer_names = enabled_layer_names.as_ptr();
        self.inner.enabled_layer_count = enabled_layer_names.len() as _;
        self
    }
    pub fn enabled_extension_names(
        mut self,
        enabled_extension_names: &'a [*const c_char],
    ) -> InstanceCreateInfoBuilder<'a> {
        self.inner.pp_enabled_extension_names = enabled_extension_names.as_ptr();
        self.inner.enabled_extension_count = enabled_extension_names.len() as _;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsInstanceCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> InstanceCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> InstanceCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueueFamilyProperties.html>"]
pub struct QueueFamilyProperties {
    pub queue_flags: QueueFlags,
    pub queue_count: u32,
    pub timestamp_valid_bits: u32,
    pub min_image_transfer_granularity: Extent3D,
}
impl QueueFamilyProperties {
    pub fn builder<'a>() -> QueueFamilyPropertiesBuilder<'a> {
        QueueFamilyPropertiesBuilder {
            inner: QueueFamilyProperties::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct QueueFamilyPropertiesBuilder<'a> {
    inner: QueueFamilyProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for QueueFamilyPropertiesBuilder<'a> {
    type Target = QueueFamilyProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for QueueFamilyPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> QueueFamilyPropertiesBuilder<'a> {
    pub fn queue_flags(mut self, queue_flags: QueueFlags) -> QueueFamilyPropertiesBuilder<'a> {
        self.inner.queue_flags = queue_flags;
        self
    }
    pub fn queue_count(mut self, queue_count: u32) -> QueueFamilyPropertiesBuilder<'a> {
        self.inner.queue_count = queue_count;
        self
    }
    pub fn timestamp_valid_bits(
        mut self,
        timestamp_valid_bits: u32,
    ) -> QueueFamilyPropertiesBuilder<'a> {
        self.inner.timestamp_valid_bits = timestamp_valid_bits;
        self
    }
    pub fn min_image_transfer_granularity(
        mut self,
        min_image_transfer_granularity: Extent3D,
    ) -> QueueFamilyPropertiesBuilder<'a> {
        self.inner.min_image_transfer_granularity = min_image_transfer_granularity;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> QueueFamilyProperties {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMemoryProperties.html>"]
pub struct PhysicalDeviceMemoryProperties {
    pub memory_type_count: u32,
    pub memory_types: [MemoryType; MAX_MEMORY_TYPES],
    pub memory_heap_count: u32,
    pub memory_heaps: [MemoryHeap; MAX_MEMORY_HEAPS],
}
impl ::std::default::Default for PhysicalDeviceMemoryProperties {
    fn default() -> PhysicalDeviceMemoryProperties {
        PhysicalDeviceMemoryProperties {
            memory_type_count: u32::default(),
            memory_types: unsafe { ::std::mem::zeroed() },
            memory_heap_count: u32::default(),
            memory_heaps: unsafe { ::std::mem::zeroed() },
        }
    }
}
impl PhysicalDeviceMemoryProperties {
    pub fn builder<'a>() -> PhysicalDeviceMemoryPropertiesBuilder<'a> {
        PhysicalDeviceMemoryPropertiesBuilder {
            inner: PhysicalDeviceMemoryProperties::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceMemoryPropertiesBuilder<'a> {
    inner: PhysicalDeviceMemoryProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PhysicalDeviceMemoryPropertiesBuilder<'a> {
    type Target = PhysicalDeviceMemoryProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceMemoryPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceMemoryPropertiesBuilder<'a> {
    pub fn memory_type_count(
        mut self,
        memory_type_count: u32,
    ) -> PhysicalDeviceMemoryPropertiesBuilder<'a> {
        self.inner.memory_type_count = memory_type_count;
        self
    }
    pub fn memory_types(
        mut self,
        memory_types: [MemoryType; MAX_MEMORY_TYPES],
    ) -> PhysicalDeviceMemoryPropertiesBuilder<'a> {
        self.inner.memory_types = memory_types;
        self
    }
    pub fn memory_heap_count(
        mut self,
        memory_heap_count: u32,
    ) -> PhysicalDeviceMemoryPropertiesBuilder<'a> {
        self.inner.memory_heap_count = memory_heap_count;
        self
    }
    pub fn memory_heaps(
        mut self,
        memory_heaps: [MemoryHeap; MAX_MEMORY_HEAPS],
    ) -> PhysicalDeviceMemoryPropertiesBuilder<'a> {
        self.inner.memory_heaps = memory_heaps;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceMemoryProperties {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryAllocateInfo.html>"]
pub struct MemoryAllocateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub allocation_size: DeviceSize,
    pub memory_type_index: u32,
}
impl ::std::default::Default for MemoryAllocateInfo {
    fn default() -> MemoryAllocateInfo {
        MemoryAllocateInfo {
            s_type: StructureType::MEMORY_ALLOCATE_INFO,
            p_next: ::std::ptr::null(),
            allocation_size: DeviceSize::default(),
            memory_type_index: u32::default(),
        }
    }
}
impl MemoryAllocateInfo {
    pub fn builder<'a>() -> MemoryAllocateInfoBuilder<'a> {
        MemoryAllocateInfoBuilder {
            inner: MemoryAllocateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryAllocateInfoBuilder<'a> {
    inner: MemoryAllocateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsMemoryAllocateInfo {}
impl<'a> ::std::ops::Deref for MemoryAllocateInfoBuilder<'a> {
    type Target = MemoryAllocateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryAllocateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryAllocateInfoBuilder<'a> {
    pub fn allocation_size(mut self, allocation_size: DeviceSize) -> MemoryAllocateInfoBuilder<'a> {
        self.inner.allocation_size = allocation_size;
        self
    }
    pub fn memory_type_index(mut self, memory_type_index: u32) -> MemoryAllocateInfoBuilder<'a> {
        self.inner.memory_type_index = memory_type_index;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsMemoryAllocateInfo>(
        mut self,
        next: &'a mut T,
    ) -> MemoryAllocateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryAllocateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryRequirements.html>"]
pub struct MemoryRequirements {
    pub size: DeviceSize,
    pub alignment: DeviceSize,
    pub memory_type_bits: u32,
}
impl MemoryRequirements {
    pub fn builder<'a>() -> MemoryRequirementsBuilder<'a> {
        MemoryRequirementsBuilder {
            inner: MemoryRequirements::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryRequirementsBuilder<'a> {
    inner: MemoryRequirements,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MemoryRequirementsBuilder<'a> {
    type Target = MemoryRequirements;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryRequirementsBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryRequirementsBuilder<'a> {
    pub fn size(mut self, size: DeviceSize) -> MemoryRequirementsBuilder<'a> {
        self.inner.size = size;
        self
    }
    pub fn alignment(mut self, alignment: DeviceSize) -> MemoryRequirementsBuilder<'a> {
        self.inner.alignment = alignment;
        self
    }
    pub fn memory_type_bits(mut self, memory_type_bits: u32) -> MemoryRequirementsBuilder<'a> {
        self.inner.memory_type_bits = memory_type_bits;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryRequirements {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseImageFormatProperties.html>"]
pub struct SparseImageFormatProperties {
    pub aspect_mask: ImageAspectFlags,
    pub image_granularity: Extent3D,
    pub flags: SparseImageFormatFlags,
}
impl SparseImageFormatProperties {
    pub fn builder<'a>() -> SparseImageFormatPropertiesBuilder<'a> {
        SparseImageFormatPropertiesBuilder {
            inner: SparseImageFormatProperties::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SparseImageFormatPropertiesBuilder<'a> {
    inner: SparseImageFormatProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SparseImageFormatPropertiesBuilder<'a> {
    type Target = SparseImageFormatProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SparseImageFormatPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SparseImageFormatPropertiesBuilder<'a> {
    pub fn aspect_mask(
        mut self,
        aspect_mask: ImageAspectFlags,
    ) -> SparseImageFormatPropertiesBuilder<'a> {
        self.inner.aspect_mask = aspect_mask;
        self
    }
    pub fn image_granularity(
        mut self,
        image_granularity: Extent3D,
    ) -> SparseImageFormatPropertiesBuilder<'a> {
        self.inner.image_granularity = image_granularity;
        self
    }
    pub fn flags(
        mut self,
        flags: SparseImageFormatFlags,
    ) -> SparseImageFormatPropertiesBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SparseImageFormatProperties {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseImageMemoryRequirements.html>"]
pub struct SparseImageMemoryRequirements {
    pub format_properties: SparseImageFormatProperties,
    pub image_mip_tail_first_lod: u32,
    pub image_mip_tail_size: DeviceSize,
    pub image_mip_tail_offset: DeviceSize,
    pub image_mip_tail_stride: DeviceSize,
}
impl SparseImageMemoryRequirements {
    pub fn builder<'a>() -> SparseImageMemoryRequirementsBuilder<'a> {
        SparseImageMemoryRequirementsBuilder {
            inner: SparseImageMemoryRequirements::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SparseImageMemoryRequirementsBuilder<'a> {
    inner: SparseImageMemoryRequirements,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SparseImageMemoryRequirementsBuilder<'a> {
    type Target = SparseImageMemoryRequirements;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SparseImageMemoryRequirementsBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SparseImageMemoryRequirementsBuilder<'a> {
    pub fn format_properties(
        mut self,
        format_properties: SparseImageFormatProperties,
    ) -> SparseImageMemoryRequirementsBuilder<'a> {
        self.inner.format_properties = format_properties;
        self
    }
    pub fn image_mip_tail_first_lod(
        mut self,
        image_mip_tail_first_lod: u32,
    ) -> SparseImageMemoryRequirementsBuilder<'a> {
        self.inner.image_mip_tail_first_lod = image_mip_tail_first_lod;
        self
    }
    pub fn image_mip_tail_size(
        mut self,
        image_mip_tail_size: DeviceSize,
    ) -> SparseImageMemoryRequirementsBuilder<'a> {
        self.inner.image_mip_tail_size = image_mip_tail_size;
        self
    }
    pub fn image_mip_tail_offset(
        mut self,
        image_mip_tail_offset: DeviceSize,
    ) -> SparseImageMemoryRequirementsBuilder<'a> {
        self.inner.image_mip_tail_offset = image_mip_tail_offset;
        self
    }
    pub fn image_mip_tail_stride(
        mut self,
        image_mip_tail_stride: DeviceSize,
    ) -> SparseImageMemoryRequirementsBuilder<'a> {
        self.inner.image_mip_tail_stride = image_mip_tail_stride;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SparseImageMemoryRequirements {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryType.html>"]
pub struct MemoryType {
    pub property_flags: MemoryPropertyFlags,
    pub heap_index: u32,
}
impl MemoryType {
    pub fn builder<'a>() -> MemoryTypeBuilder<'a> {
        MemoryTypeBuilder {
            inner: MemoryType::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryTypeBuilder<'a> {
    inner: MemoryType,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MemoryTypeBuilder<'a> {
    type Target = MemoryType;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryTypeBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryTypeBuilder<'a> {
    pub fn property_flags(mut self, property_flags: MemoryPropertyFlags) -> MemoryTypeBuilder<'a> {
        self.inner.property_flags = property_flags;
        self
    }
    pub fn heap_index(mut self, heap_index: u32) -> MemoryTypeBuilder<'a> {
        self.inner.heap_index = heap_index;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryType {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryHeap.html>"]
pub struct MemoryHeap {
    pub size: DeviceSize,
    pub flags: MemoryHeapFlags,
}
impl MemoryHeap {
    pub fn builder<'a>() -> MemoryHeapBuilder<'a> {
        MemoryHeapBuilder {
            inner: MemoryHeap::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryHeapBuilder<'a> {
    inner: MemoryHeap,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MemoryHeapBuilder<'a> {
    type Target = MemoryHeap;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryHeapBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryHeapBuilder<'a> {
    pub fn size(mut self, size: DeviceSize) -> MemoryHeapBuilder<'a> {
        self.inner.size = size;
        self
    }
    pub fn flags(mut self, flags: MemoryHeapFlags) -> MemoryHeapBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryHeap {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMappedMemoryRange.html>"]
pub struct MappedMemoryRange {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub memory: DeviceMemory,
    pub offset: DeviceSize,
    pub size: DeviceSize,
}
impl ::std::default::Default for MappedMemoryRange {
    fn default() -> MappedMemoryRange {
        MappedMemoryRange {
            s_type: StructureType::MAPPED_MEMORY_RANGE,
            p_next: ::std::ptr::null(),
            memory: DeviceMemory::default(),
            offset: DeviceSize::default(),
            size: DeviceSize::default(),
        }
    }
}
impl MappedMemoryRange {
    pub fn builder<'a>() -> MappedMemoryRangeBuilder<'a> {
        MappedMemoryRangeBuilder {
            inner: MappedMemoryRange::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MappedMemoryRangeBuilder<'a> {
    inner: MappedMemoryRange,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsMappedMemoryRange {}
impl<'a> ::std::ops::Deref for MappedMemoryRangeBuilder<'a> {
    type Target = MappedMemoryRange;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MappedMemoryRangeBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MappedMemoryRangeBuilder<'a> {
    pub fn memory(mut self, memory: DeviceMemory) -> MappedMemoryRangeBuilder<'a> {
        self.inner.memory = memory;
        self
    }
    pub fn offset(mut self, offset: DeviceSize) -> MappedMemoryRangeBuilder<'a> {
        self.inner.offset = offset;
        self
    }
    pub fn size(mut self, size: DeviceSize) -> MappedMemoryRangeBuilder<'a> {
        self.inner.size = size;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsMappedMemoryRange>(
        mut self,
        next: &'a mut T,
    ) -> MappedMemoryRangeBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MappedMemoryRange {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFormatProperties.html>"]
pub struct FormatProperties {
    pub linear_tiling_features: FormatFeatureFlags,
    pub optimal_tiling_features: FormatFeatureFlags,
    pub buffer_features: FormatFeatureFlags,
}
impl FormatProperties {
    pub fn builder<'a>() -> FormatPropertiesBuilder<'a> {
        FormatPropertiesBuilder {
            inner: FormatProperties::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct FormatPropertiesBuilder<'a> {
    inner: FormatProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for FormatPropertiesBuilder<'a> {
    type Target = FormatProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for FormatPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> FormatPropertiesBuilder<'a> {
    pub fn linear_tiling_features(
        mut self,
        linear_tiling_features: FormatFeatureFlags,
    ) -> FormatPropertiesBuilder<'a> {
        self.inner.linear_tiling_features = linear_tiling_features;
        self
    }
    pub fn optimal_tiling_features(
        mut self,
        optimal_tiling_features: FormatFeatureFlags,
    ) -> FormatPropertiesBuilder<'a> {
        self.inner.optimal_tiling_features = optimal_tiling_features;
        self
    }
    pub fn buffer_features(
        mut self,
        buffer_features: FormatFeatureFlags,
    ) -> FormatPropertiesBuilder<'a> {
        self.inner.buffer_features = buffer_features;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> FormatProperties {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageFormatProperties.html>"]
pub struct ImageFormatProperties {
    pub max_extent: Extent3D,
    pub max_mip_levels: u32,
    pub max_array_layers: u32,
    pub sample_counts: SampleCountFlags,
    pub max_resource_size: DeviceSize,
}
impl ImageFormatProperties {
    pub fn builder<'a>() -> ImageFormatPropertiesBuilder<'a> {
        ImageFormatPropertiesBuilder {
            inner: ImageFormatProperties::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageFormatPropertiesBuilder<'a> {
    inner: ImageFormatProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImageFormatPropertiesBuilder<'a> {
    type Target = ImageFormatProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageFormatPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageFormatPropertiesBuilder<'a> {
    pub fn max_extent(mut self, max_extent: Extent3D) -> ImageFormatPropertiesBuilder<'a> {
        self.inner.max_extent = max_extent;
        self
    }
    pub fn max_mip_levels(mut self, max_mip_levels: u32) -> ImageFormatPropertiesBuilder<'a> {
        self.inner.max_mip_levels = max_mip_levels;
        self
    }
    pub fn max_array_layers(mut self, max_array_layers: u32) -> ImageFormatPropertiesBuilder<'a> {
        self.inner.max_array_layers = max_array_layers;
        self
    }
    pub fn sample_counts(
        mut self,
        sample_counts: SampleCountFlags,
    ) -> ImageFormatPropertiesBuilder<'a> {
        self.inner.sample_counts = sample_counts;
        self
    }
    pub fn max_resource_size(
        mut self,
        max_resource_size: DeviceSize,
    ) -> ImageFormatPropertiesBuilder<'a> {
        self.inner.max_resource_size = max_resource_size;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageFormatProperties {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorBufferInfo.html>"]
pub struct DescriptorBufferInfo {
    pub buffer: Buffer,
    pub offset: DeviceSize,
    pub range: DeviceSize,
}
impl DescriptorBufferInfo {
    pub fn builder<'a>() -> DescriptorBufferInfoBuilder<'a> {
        DescriptorBufferInfoBuilder {
            inner: DescriptorBufferInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DescriptorBufferInfoBuilder<'a> {
    inner: DescriptorBufferInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DescriptorBufferInfoBuilder<'a> {
    type Target = DescriptorBufferInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DescriptorBufferInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DescriptorBufferInfoBuilder<'a> {
    pub fn buffer(mut self, buffer: Buffer) -> DescriptorBufferInfoBuilder<'a> {
        self.inner.buffer = buffer;
        self
    }
    pub fn offset(mut self, offset: DeviceSize) -> DescriptorBufferInfoBuilder<'a> {
        self.inner.offset = offset;
        self
    }
    pub fn range(mut self, range: DeviceSize) -> DescriptorBufferInfoBuilder<'a> {
        self.inner.range = range;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DescriptorBufferInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorImageInfo.html>"]
pub struct DescriptorImageInfo {
    pub sampler: Sampler,
    pub image_view: ImageView,
    pub image_layout: ImageLayout,
}
impl DescriptorImageInfo {
    pub fn builder<'a>() -> DescriptorImageInfoBuilder<'a> {
        DescriptorImageInfoBuilder {
            inner: DescriptorImageInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DescriptorImageInfoBuilder<'a> {
    inner: DescriptorImageInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DescriptorImageInfoBuilder<'a> {
    type Target = DescriptorImageInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DescriptorImageInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DescriptorImageInfoBuilder<'a> {
    pub fn sampler(mut self, sampler: Sampler) -> DescriptorImageInfoBuilder<'a> {
        self.inner.sampler = sampler;
        self
    }
    pub fn image_view(mut self, image_view: ImageView) -> DescriptorImageInfoBuilder<'a> {
        self.inner.image_view = image_view;
        self
    }
    pub fn image_layout(mut self, image_layout: ImageLayout) -> DescriptorImageInfoBuilder<'a> {
        self.inner.image_layout = image_layout;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DescriptorImageInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkWriteDescriptorSet.html>"]
pub struct WriteDescriptorSet {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub dst_set: DescriptorSet,
    pub dst_binding: u32,
    pub dst_array_element: u32,
    pub descriptor_count: u32,
    pub descriptor_type: DescriptorType,
    pub p_image_info: *const DescriptorImageInfo,
    pub p_buffer_info: *const DescriptorBufferInfo,
    pub p_texel_buffer_view: *const BufferView,
}
impl ::std::default::Default for WriteDescriptorSet {
    fn default() -> WriteDescriptorSet {
        WriteDescriptorSet {
            s_type: StructureType::WRITE_DESCRIPTOR_SET,
            p_next: ::std::ptr::null(),
            dst_set: DescriptorSet::default(),
            dst_binding: u32::default(),
            dst_array_element: u32::default(),
            descriptor_count: u32::default(),
            descriptor_type: DescriptorType::default(),
            p_image_info: ::std::ptr::null(),
            p_buffer_info: ::std::ptr::null(),
            p_texel_buffer_view: ::std::ptr::null(),
        }
    }
}
impl WriteDescriptorSet {
    pub fn builder<'a>() -> WriteDescriptorSetBuilder<'a> {
        WriteDescriptorSetBuilder {
            inner: WriteDescriptorSet::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct WriteDescriptorSetBuilder<'a> {
    inner: WriteDescriptorSet,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsWriteDescriptorSet {}
impl<'a> ::std::ops::Deref for WriteDescriptorSetBuilder<'a> {
    type Target = WriteDescriptorSet;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for WriteDescriptorSetBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> WriteDescriptorSetBuilder<'a> {
    pub fn dst_set(mut self, dst_set: DescriptorSet) -> WriteDescriptorSetBuilder<'a> {
        self.inner.dst_set = dst_set;
        self
    }
    pub fn dst_binding(mut self, dst_binding: u32) -> WriteDescriptorSetBuilder<'a> {
        self.inner.dst_binding = dst_binding;
        self
    }
    pub fn dst_array_element(mut self, dst_array_element: u32) -> WriteDescriptorSetBuilder<'a> {
        self.inner.dst_array_element = dst_array_element;
        self
    }
    pub fn descriptor_type(
        mut self,
        descriptor_type: DescriptorType,
    ) -> WriteDescriptorSetBuilder<'a> {
        self.inner.descriptor_type = descriptor_type;
        self
    }
    pub fn image_info(
        mut self,
        image_info: &'a [DescriptorImageInfo],
    ) -> WriteDescriptorSetBuilder<'a> {
        self.inner.descriptor_count = image_info.len() as _;
        self.inner.p_image_info = image_info.as_ptr();
        self
    }
    pub fn buffer_info(
        mut self,
        buffer_info: &'a [DescriptorBufferInfo],
    ) -> WriteDescriptorSetBuilder<'a> {
        self.inner.descriptor_count = buffer_info.len() as _;
        self.inner.p_buffer_info = buffer_info.as_ptr();
        self
    }
    pub fn texel_buffer_view(
        mut self,
        texel_buffer_view: &'a [BufferView],
    ) -> WriteDescriptorSetBuilder<'a> {
        self.inner.descriptor_count = texel_buffer_view.len() as _;
        self.inner.p_texel_buffer_view = texel_buffer_view.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsWriteDescriptorSet>(
        mut self,
        next: &'a mut T,
    ) -> WriteDescriptorSetBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> WriteDescriptorSet {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCopyDescriptorSet.html>"]
pub struct CopyDescriptorSet {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub src_set: DescriptorSet,
    pub src_binding: u32,
    pub src_array_element: u32,
    pub dst_set: DescriptorSet,
    pub dst_binding: u32,
    pub dst_array_element: u32,
    pub descriptor_count: u32,
}
impl ::std::default::Default for CopyDescriptorSet {
    fn default() -> CopyDescriptorSet {
        CopyDescriptorSet {
            s_type: StructureType::COPY_DESCRIPTOR_SET,
            p_next: ::std::ptr::null(),
            src_set: DescriptorSet::default(),
            src_binding: u32::default(),
            src_array_element: u32::default(),
            dst_set: DescriptorSet::default(),
            dst_binding: u32::default(),
            dst_array_element: u32::default(),
            descriptor_count: u32::default(),
        }
    }
}
impl CopyDescriptorSet {
    pub fn builder<'a>() -> CopyDescriptorSetBuilder<'a> {
        CopyDescriptorSetBuilder {
            inner: CopyDescriptorSet::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct CopyDescriptorSetBuilder<'a> {
    inner: CopyDescriptorSet,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsCopyDescriptorSet {}
impl<'a> ::std::ops::Deref for CopyDescriptorSetBuilder<'a> {
    type Target = CopyDescriptorSet;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for CopyDescriptorSetBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> CopyDescriptorSetBuilder<'a> {
    pub fn src_set(mut self, src_set: DescriptorSet) -> CopyDescriptorSetBuilder<'a> {
        self.inner.src_set = src_set;
        self
    }
    pub fn src_binding(mut self, src_binding: u32) -> CopyDescriptorSetBuilder<'a> {
        self.inner.src_binding = src_binding;
        self
    }
    pub fn src_array_element(mut self, src_array_element: u32) -> CopyDescriptorSetBuilder<'a> {
        self.inner.src_array_element = src_array_element;
        self
    }
    pub fn dst_set(mut self, dst_set: DescriptorSet) -> CopyDescriptorSetBuilder<'a> {
        self.inner.dst_set = dst_set;
        self
    }
    pub fn dst_binding(mut self, dst_binding: u32) -> CopyDescriptorSetBuilder<'a> {
        self.inner.dst_binding = dst_binding;
        self
    }
    pub fn dst_array_element(mut self, dst_array_element: u32) -> CopyDescriptorSetBuilder<'a> {
        self.inner.dst_array_element = dst_array_element;
        self
    }
    pub fn descriptor_count(mut self, descriptor_count: u32) -> CopyDescriptorSetBuilder<'a> {
        self.inner.descriptor_count = descriptor_count;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsCopyDescriptorSet>(
        mut self,
        next: &'a mut T,
    ) -> CopyDescriptorSetBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> CopyDescriptorSet {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferCreateInfo.html>"]
pub struct BufferCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: BufferCreateFlags,
    pub size: DeviceSize,
    pub usage: BufferUsageFlags,
    pub sharing_mode: SharingMode,
    pub queue_family_index_count: u32,
    pub p_queue_family_indices: *const u32,
}
impl ::std::default::Default for BufferCreateInfo {
    fn default() -> BufferCreateInfo {
        BufferCreateInfo {
            s_type: StructureType::BUFFER_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: BufferCreateFlags::default(),
            size: DeviceSize::default(),
            usage: BufferUsageFlags::default(),
            sharing_mode: SharingMode::default(),
            queue_family_index_count: u32::default(),
            p_queue_family_indices: ::std::ptr::null(),
        }
    }
}
impl BufferCreateInfo {
    pub fn builder<'a>() -> BufferCreateInfoBuilder<'a> {
        BufferCreateInfoBuilder {
            inner: BufferCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BufferCreateInfoBuilder<'a> {
    inner: BufferCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsBufferCreateInfo {}
impl<'a> ::std::ops::Deref for BufferCreateInfoBuilder<'a> {
    type Target = BufferCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BufferCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BufferCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: BufferCreateFlags) -> BufferCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn size(mut self, size: DeviceSize) -> BufferCreateInfoBuilder<'a> {
        self.inner.size = size;
        self
    }
    pub fn usage(mut self, usage: BufferUsageFlags) -> BufferCreateInfoBuilder<'a> {
        self.inner.usage = usage;
        self
    }
    pub fn sharing_mode(mut self, sharing_mode: SharingMode) -> BufferCreateInfoBuilder<'a> {
        self.inner.sharing_mode = sharing_mode;
        self
    }
    pub fn queue_family_indices(
        mut self,
        queue_family_indices: &'a [u32],
    ) -> BufferCreateInfoBuilder<'a> {
        self.inner.queue_family_index_count = queue_family_indices.len() as _;
        self.inner.p_queue_family_indices = queue_family_indices.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsBufferCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> BufferCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BufferCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferViewCreateInfo.html>"]
pub struct BufferViewCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: BufferViewCreateFlags,
    pub buffer: Buffer,
    pub format: Format,
    pub offset: DeviceSize,
    pub range: DeviceSize,
}
impl ::std::default::Default for BufferViewCreateInfo {
    fn default() -> BufferViewCreateInfo {
        BufferViewCreateInfo {
            s_type: StructureType::BUFFER_VIEW_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: BufferViewCreateFlags::default(),
            buffer: Buffer::default(),
            format: Format::default(),
            offset: DeviceSize::default(),
            range: DeviceSize::default(),
        }
    }
}
impl BufferViewCreateInfo {
    pub fn builder<'a>() -> BufferViewCreateInfoBuilder<'a> {
        BufferViewCreateInfoBuilder {
            inner: BufferViewCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BufferViewCreateInfoBuilder<'a> {
    inner: BufferViewCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsBufferViewCreateInfo {}
impl<'a> ::std::ops::Deref for BufferViewCreateInfoBuilder<'a> {
    type Target = BufferViewCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BufferViewCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BufferViewCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: BufferViewCreateFlags) -> BufferViewCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn buffer(mut self, buffer: Buffer) -> BufferViewCreateInfoBuilder<'a> {
        self.inner.buffer = buffer;
        self
    }
    pub fn format(mut self, format: Format) -> BufferViewCreateInfoBuilder<'a> {
        self.inner.format = format;
        self
    }
    pub fn offset(mut self, offset: DeviceSize) -> BufferViewCreateInfoBuilder<'a> {
        self.inner.offset = offset;
        self
    }
    pub fn range(mut self, range: DeviceSize) -> BufferViewCreateInfoBuilder<'a> {
        self.inner.range = range;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsBufferViewCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> BufferViewCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BufferViewCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageSubresource.html>"]
pub struct ImageSubresource {
    pub aspect_mask: ImageAspectFlags,
    pub mip_level: u32,
    pub array_layer: u32,
}
impl ImageSubresource {
    pub fn builder<'a>() -> ImageSubresourceBuilder<'a> {
        ImageSubresourceBuilder {
            inner: ImageSubresource::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageSubresourceBuilder<'a> {
    inner: ImageSubresource,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImageSubresourceBuilder<'a> {
    type Target = ImageSubresource;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageSubresourceBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageSubresourceBuilder<'a> {
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> ImageSubresourceBuilder<'a> {
        self.inner.aspect_mask = aspect_mask;
        self
    }
    pub fn mip_level(mut self, mip_level: u32) -> ImageSubresourceBuilder<'a> {
        self.inner.mip_level = mip_level;
        self
    }
    pub fn array_layer(mut self, array_layer: u32) -> ImageSubresourceBuilder<'a> {
        self.inner.array_layer = array_layer;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageSubresource {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageSubresourceLayers.html>"]
pub struct ImageSubresourceLayers {
    pub aspect_mask: ImageAspectFlags,
    pub mip_level: u32,
    pub base_array_layer: u32,
    pub layer_count: u32,
}
impl ImageSubresourceLayers {
    pub fn builder<'a>() -> ImageSubresourceLayersBuilder<'a> {
        ImageSubresourceLayersBuilder {
            inner: ImageSubresourceLayers::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageSubresourceLayersBuilder<'a> {
    inner: ImageSubresourceLayers,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImageSubresourceLayersBuilder<'a> {
    type Target = ImageSubresourceLayers;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageSubresourceLayersBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageSubresourceLayersBuilder<'a> {
    pub fn aspect_mask(
        mut self,
        aspect_mask: ImageAspectFlags,
    ) -> ImageSubresourceLayersBuilder<'a> {
        self.inner.aspect_mask = aspect_mask;
        self
    }
    pub fn mip_level(mut self, mip_level: u32) -> ImageSubresourceLayersBuilder<'a> {
        self.inner.mip_level = mip_level;
        self
    }
    pub fn base_array_layer(mut self, base_array_layer: u32) -> ImageSubresourceLayersBuilder<'a> {
        self.inner.base_array_layer = base_array_layer;
        self
    }
    pub fn layer_count(mut self, layer_count: u32) -> ImageSubresourceLayersBuilder<'a> {
        self.inner.layer_count = layer_count;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageSubresourceLayers {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageSubresourceRange.html>"]
pub struct ImageSubresourceRange {
    pub aspect_mask: ImageAspectFlags,
    pub base_mip_level: u32,
    pub level_count: u32,
    pub base_array_layer: u32,
    pub layer_count: u32,
}
impl ImageSubresourceRange {
    pub fn builder<'a>() -> ImageSubresourceRangeBuilder<'a> {
        ImageSubresourceRangeBuilder {
            inner: ImageSubresourceRange::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageSubresourceRangeBuilder<'a> {
    inner: ImageSubresourceRange,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImageSubresourceRangeBuilder<'a> {
    type Target = ImageSubresourceRange;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageSubresourceRangeBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageSubresourceRangeBuilder<'a> {
    pub fn aspect_mask(
        mut self,
        aspect_mask: ImageAspectFlags,
    ) -> ImageSubresourceRangeBuilder<'a> {
        self.inner.aspect_mask = aspect_mask;
        self
    }
    pub fn base_mip_level(mut self, base_mip_level: u32) -> ImageSubresourceRangeBuilder<'a> {
        self.inner.base_mip_level = base_mip_level;
        self
    }
    pub fn level_count(mut self, level_count: u32) -> ImageSubresourceRangeBuilder<'a> {
        self.inner.level_count = level_count;
        self
    }
    pub fn base_array_layer(mut self, base_array_layer: u32) -> ImageSubresourceRangeBuilder<'a> {
        self.inner.base_array_layer = base_array_layer;
        self
    }
    pub fn layer_count(mut self, layer_count: u32) -> ImageSubresourceRangeBuilder<'a> {
        self.inner.layer_count = layer_count;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageSubresourceRange {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryBarrier.html>"]
pub struct MemoryBarrier {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub src_access_mask: AccessFlags,
    pub dst_access_mask: AccessFlags,
}
impl ::std::default::Default for MemoryBarrier {
    fn default() -> MemoryBarrier {
        MemoryBarrier {
            s_type: StructureType::MEMORY_BARRIER,
            p_next: ::std::ptr::null(),
            src_access_mask: AccessFlags::default(),
            dst_access_mask: AccessFlags::default(),
        }
    }
}
impl MemoryBarrier {
    pub fn builder<'a>() -> MemoryBarrierBuilder<'a> {
        MemoryBarrierBuilder {
            inner: MemoryBarrier::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryBarrierBuilder<'a> {
    inner: MemoryBarrier,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsMemoryBarrier {}
impl<'a> ::std::ops::Deref for MemoryBarrierBuilder<'a> {
    type Target = MemoryBarrier;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryBarrierBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryBarrierBuilder<'a> {
    pub fn src_access_mask(mut self, src_access_mask: AccessFlags) -> MemoryBarrierBuilder<'a> {
        self.inner.src_access_mask = src_access_mask;
        self
    }
    pub fn dst_access_mask(mut self, dst_access_mask: AccessFlags) -> MemoryBarrierBuilder<'a> {
        self.inner.dst_access_mask = dst_access_mask;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsMemoryBarrier>(
        mut self,
        next: &'a mut T,
    ) -> MemoryBarrierBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryBarrier {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferMemoryBarrier.html>"]
pub struct BufferMemoryBarrier {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub src_access_mask: AccessFlags,
    pub dst_access_mask: AccessFlags,
    pub src_queue_family_index: u32,
    pub dst_queue_family_index: u32,
    pub buffer: Buffer,
    pub offset: DeviceSize,
    pub size: DeviceSize,
}
impl ::std::default::Default for BufferMemoryBarrier {
    fn default() -> BufferMemoryBarrier {
        BufferMemoryBarrier {
            s_type: StructureType::BUFFER_MEMORY_BARRIER,
            p_next: ::std::ptr::null(),
            src_access_mask: AccessFlags::default(),
            dst_access_mask: AccessFlags::default(),
            src_queue_family_index: u32::default(),
            dst_queue_family_index: u32::default(),
            buffer: Buffer::default(),
            offset: DeviceSize::default(),
            size: DeviceSize::default(),
        }
    }
}
impl BufferMemoryBarrier {
    pub fn builder<'a>() -> BufferMemoryBarrierBuilder<'a> {
        BufferMemoryBarrierBuilder {
            inner: BufferMemoryBarrier::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BufferMemoryBarrierBuilder<'a> {
    inner: BufferMemoryBarrier,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsBufferMemoryBarrier {}
impl<'a> ::std::ops::Deref for BufferMemoryBarrierBuilder<'a> {
    type Target = BufferMemoryBarrier;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BufferMemoryBarrierBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BufferMemoryBarrierBuilder<'a> {
    pub fn src_access_mask(
        mut self,
        src_access_mask: AccessFlags,
    ) -> BufferMemoryBarrierBuilder<'a> {
        self.inner.src_access_mask = src_access_mask;
        self
    }
    pub fn dst_access_mask(
        mut self,
        dst_access_mask: AccessFlags,
    ) -> BufferMemoryBarrierBuilder<'a> {
        self.inner.dst_access_mask = dst_access_mask;
        self
    }
    pub fn src_queue_family_index(
        mut self,
        src_queue_family_index: u32,
    ) -> BufferMemoryBarrierBuilder<'a> {
        self.inner.src_queue_family_index = src_queue_family_index;
        self
    }
    pub fn dst_queue_family_index(
        mut self,
        dst_queue_family_index: u32,
    ) -> BufferMemoryBarrierBuilder<'a> {
        self.inner.dst_queue_family_index = dst_queue_family_index;
        self
    }
    pub fn buffer(mut self, buffer: Buffer) -> BufferMemoryBarrierBuilder<'a> {
        self.inner.buffer = buffer;
        self
    }
    pub fn offset(mut self, offset: DeviceSize) -> BufferMemoryBarrierBuilder<'a> {
        self.inner.offset = offset;
        self
    }
    pub fn size(mut self, size: DeviceSize) -> BufferMemoryBarrierBuilder<'a> {
        self.inner.size = size;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsBufferMemoryBarrier>(
        mut self,
        next: &'a mut T,
    ) -> BufferMemoryBarrierBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BufferMemoryBarrier {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageMemoryBarrier.html>"]
pub struct ImageMemoryBarrier {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub src_access_mask: AccessFlags,
    pub dst_access_mask: AccessFlags,
    pub old_layout: ImageLayout,
    pub new_layout: ImageLayout,
    pub src_queue_family_index: u32,
    pub dst_queue_family_index: u32,
    pub image: Image,
    pub subresource_range: ImageSubresourceRange,
}
impl ::std::default::Default for ImageMemoryBarrier {
    fn default() -> ImageMemoryBarrier {
        ImageMemoryBarrier {
            s_type: StructureType::IMAGE_MEMORY_BARRIER,
            p_next: ::std::ptr::null(),
            src_access_mask: AccessFlags::default(),
            dst_access_mask: AccessFlags::default(),
            old_layout: ImageLayout::default(),
            new_layout: ImageLayout::default(),
            src_queue_family_index: u32::default(),
            dst_queue_family_index: u32::default(),
            image: Image::default(),
            subresource_range: ImageSubresourceRange::default(),
        }
    }
}
impl ImageMemoryBarrier {
    pub fn builder<'a>() -> ImageMemoryBarrierBuilder<'a> {
        ImageMemoryBarrierBuilder {
            inner: ImageMemoryBarrier::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageMemoryBarrierBuilder<'a> {
    inner: ImageMemoryBarrier,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsImageMemoryBarrier {}
impl<'a> ::std::ops::Deref for ImageMemoryBarrierBuilder<'a> {
    type Target = ImageMemoryBarrier;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageMemoryBarrierBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageMemoryBarrierBuilder<'a> {
    pub fn src_access_mask(
        mut self,
        src_access_mask: AccessFlags,
    ) -> ImageMemoryBarrierBuilder<'a> {
        self.inner.src_access_mask = src_access_mask;
        self
    }
    pub fn dst_access_mask(
        mut self,
        dst_access_mask: AccessFlags,
    ) -> ImageMemoryBarrierBuilder<'a> {
        self.inner.dst_access_mask = dst_access_mask;
        self
    }
    pub fn old_layout(mut self, old_layout: ImageLayout) -> ImageMemoryBarrierBuilder<'a> {
        self.inner.old_layout = old_layout;
        self
    }
    pub fn new_layout(mut self, new_layout: ImageLayout) -> ImageMemoryBarrierBuilder<'a> {
        self.inner.new_layout = new_layout;
        self
    }
    pub fn src_queue_family_index(
        mut self,
        src_queue_family_index: u32,
    ) -> ImageMemoryBarrierBuilder<'a> {
        self.inner.src_queue_family_index = src_queue_family_index;
        self
    }
    pub fn dst_queue_family_index(
        mut self,
        dst_queue_family_index: u32,
    ) -> ImageMemoryBarrierBuilder<'a> {
        self.inner.dst_queue_family_index = dst_queue_family_index;
        self
    }
    pub fn image(mut self, image: Image) -> ImageMemoryBarrierBuilder<'a> {
        self.inner.image = image;
        self
    }
    pub fn subresource_range(
        mut self,
        subresource_range: ImageSubresourceRange,
    ) -> ImageMemoryBarrierBuilder<'a> {
        self.inner.subresource_range = subresource_range;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsImageMemoryBarrier>(
        mut self,
        next: &'a mut T,
    ) -> ImageMemoryBarrierBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageMemoryBarrier {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageCreateInfo.html>"]
pub struct ImageCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ImageCreateFlags,
    pub image_type: ImageType,
    pub format: Format,
    pub extent: Extent3D,
    pub mip_levels: u32,
    pub array_layers: u32,
    pub samples: SampleCountFlags,
    pub tiling: ImageTiling,
    pub usage: ImageUsageFlags,
    pub sharing_mode: SharingMode,
    pub queue_family_index_count: u32,
    pub p_queue_family_indices: *const u32,
    pub initial_layout: ImageLayout,
}
impl ::std::default::Default for ImageCreateInfo {
    fn default() -> ImageCreateInfo {
        ImageCreateInfo {
            s_type: StructureType::IMAGE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: ImageCreateFlags::default(),
            image_type: ImageType::default(),
            format: Format::default(),
            extent: Extent3D::default(),
            mip_levels: u32::default(),
            array_layers: u32::default(),
            samples: SampleCountFlags::default(),
            tiling: ImageTiling::default(),
            usage: ImageUsageFlags::default(),
            sharing_mode: SharingMode::default(),
            queue_family_index_count: u32::default(),
            p_queue_family_indices: ::std::ptr::null(),
            initial_layout: ImageLayout::default(),
        }
    }
}
impl ImageCreateInfo {
    pub fn builder<'a>() -> ImageCreateInfoBuilder<'a> {
        ImageCreateInfoBuilder {
            inner: ImageCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageCreateInfoBuilder<'a> {
    inner: ImageCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsImageCreateInfo {}
impl<'a> ::std::ops::Deref for ImageCreateInfoBuilder<'a> {
    type Target = ImageCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: ImageCreateFlags) -> ImageCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn image_type(mut self, image_type: ImageType) -> ImageCreateInfoBuilder<'a> {
        self.inner.image_type = image_type;
        self
    }
    pub fn format(mut self, format: Format) -> ImageCreateInfoBuilder<'a> {
        self.inner.format = format;
        self
    }
    pub fn extent(mut self, extent: Extent3D) -> ImageCreateInfoBuilder<'a> {
        self.inner.extent = extent;
        self
    }
    pub fn mip_levels(mut self, mip_levels: u32) -> ImageCreateInfoBuilder<'a> {
        self.inner.mip_levels = mip_levels;
        self
    }
    pub fn array_layers(mut self, array_layers: u32) -> ImageCreateInfoBuilder<'a> {
        self.inner.array_layers = array_layers;
        self
    }
    pub fn samples(mut self, samples: SampleCountFlags) -> ImageCreateInfoBuilder<'a> {
        self.inner.samples = samples;
        self
    }
    pub fn tiling(mut self, tiling: ImageTiling) -> ImageCreateInfoBuilder<'a> {
        self.inner.tiling = tiling;
        self
    }
    pub fn usage(mut self, usage: ImageUsageFlags) -> ImageCreateInfoBuilder<'a> {
        self.inner.usage = usage;
        self
    }
    pub fn sharing_mode(mut self, sharing_mode: SharingMode) -> ImageCreateInfoBuilder<'a> {
        self.inner.sharing_mode = sharing_mode;
        self
    }
    pub fn queue_family_indices(
        mut self,
        queue_family_indices: &'a [u32],
    ) -> ImageCreateInfoBuilder<'a> {
        self.inner.queue_family_index_count = queue_family_indices.len() as _;
        self.inner.p_queue_family_indices = queue_family_indices.as_ptr();
        self
    }
    pub fn initial_layout(mut self, initial_layout: ImageLayout) -> ImageCreateInfoBuilder<'a> {
        self.inner.initial_layout = initial_layout;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsImageCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> ImageCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubresourceLayout.html>"]
pub struct SubresourceLayout {
    pub offset: DeviceSize,
    pub size: DeviceSize,
    pub row_pitch: DeviceSize,
    pub array_pitch: DeviceSize,
    pub depth_pitch: DeviceSize,
}
impl SubresourceLayout {
    pub fn builder<'a>() -> SubresourceLayoutBuilder<'a> {
        SubresourceLayoutBuilder {
            inner: SubresourceLayout::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SubresourceLayoutBuilder<'a> {
    inner: SubresourceLayout,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SubresourceLayoutBuilder<'a> {
    type Target = SubresourceLayout;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SubresourceLayoutBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SubresourceLayoutBuilder<'a> {
    pub fn offset(mut self, offset: DeviceSize) -> SubresourceLayoutBuilder<'a> {
        self.inner.offset = offset;
        self
    }
    pub fn size(mut self, size: DeviceSize) -> SubresourceLayoutBuilder<'a> {
        self.inner.size = size;
        self
    }
    pub fn row_pitch(mut self, row_pitch: DeviceSize) -> SubresourceLayoutBuilder<'a> {
        self.inner.row_pitch = row_pitch;
        self
    }
    pub fn array_pitch(mut self, array_pitch: DeviceSize) -> SubresourceLayoutBuilder<'a> {
        self.inner.array_pitch = array_pitch;
        self
    }
    pub fn depth_pitch(mut self, depth_pitch: DeviceSize) -> SubresourceLayoutBuilder<'a> {
        self.inner.depth_pitch = depth_pitch;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SubresourceLayout {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageViewCreateInfo.html>"]
pub struct ImageViewCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ImageViewCreateFlags,
    pub image: Image,
    pub view_type: ImageViewType,
    pub format: Format,
    pub components: ComponentMapping,
    pub subresource_range: ImageSubresourceRange,
}
impl ::std::default::Default for ImageViewCreateInfo {
    fn default() -> ImageViewCreateInfo {
        ImageViewCreateInfo {
            s_type: StructureType::IMAGE_VIEW_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: ImageViewCreateFlags::default(),
            image: Image::default(),
            view_type: ImageViewType::default(),
            format: Format::default(),
            components: ComponentMapping::default(),
            subresource_range: ImageSubresourceRange::default(),
        }
    }
}
impl ImageViewCreateInfo {
    pub fn builder<'a>() -> ImageViewCreateInfoBuilder<'a> {
        ImageViewCreateInfoBuilder {
            inner: ImageViewCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageViewCreateInfoBuilder<'a> {
    inner: ImageViewCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsImageViewCreateInfo {}
impl<'a> ::std::ops::Deref for ImageViewCreateInfoBuilder<'a> {
    type Target = ImageViewCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageViewCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageViewCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: ImageViewCreateFlags) -> ImageViewCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn image(mut self, image: Image) -> ImageViewCreateInfoBuilder<'a> {
        self.inner.image = image;
        self
    }
    pub fn view_type(mut self, view_type: ImageViewType) -> ImageViewCreateInfoBuilder<'a> {
        self.inner.view_type = view_type;
        self
    }
    pub fn format(mut self, format: Format) -> ImageViewCreateInfoBuilder<'a> {
        self.inner.format = format;
        self
    }
    pub fn components(mut self, components: ComponentMapping) -> ImageViewCreateInfoBuilder<'a> {
        self.inner.components = components;
        self
    }
    pub fn subresource_range(
        mut self,
        subresource_range: ImageSubresourceRange,
    ) -> ImageViewCreateInfoBuilder<'a> {
        self.inner.subresource_range = subresource_range;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsImageViewCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> ImageViewCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageViewCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferCopy.html>"]
pub struct BufferCopy {
    pub src_offset: DeviceSize,
    pub dst_offset: DeviceSize,
    pub size: DeviceSize,
}
impl BufferCopy {
    pub fn builder<'a>() -> BufferCopyBuilder<'a> {
        BufferCopyBuilder {
            inner: BufferCopy::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BufferCopyBuilder<'a> {
    inner: BufferCopy,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for BufferCopyBuilder<'a> {
    type Target = BufferCopy;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BufferCopyBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BufferCopyBuilder<'a> {
    pub fn src_offset(mut self, src_offset: DeviceSize) -> BufferCopyBuilder<'a> {
        self.inner.src_offset = src_offset;
        self
    }
    pub fn dst_offset(mut self, dst_offset: DeviceSize) -> BufferCopyBuilder<'a> {
        self.inner.dst_offset = dst_offset;
        self
    }
    pub fn size(mut self, size: DeviceSize) -> BufferCopyBuilder<'a> {
        self.inner.size = size;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BufferCopy {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseMemoryBind.html>"]
pub struct SparseMemoryBind {
    pub resource_offset: DeviceSize,
    pub size: DeviceSize,
    pub memory: DeviceMemory,
    pub memory_offset: DeviceSize,
    pub flags: SparseMemoryBindFlags,
}
impl SparseMemoryBind {
    pub fn builder<'a>() -> SparseMemoryBindBuilder<'a> {
        SparseMemoryBindBuilder {
            inner: SparseMemoryBind::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SparseMemoryBindBuilder<'a> {
    inner: SparseMemoryBind,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SparseMemoryBindBuilder<'a> {
    type Target = SparseMemoryBind;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SparseMemoryBindBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SparseMemoryBindBuilder<'a> {
    pub fn resource_offset(mut self, resource_offset: DeviceSize) -> SparseMemoryBindBuilder<'a> {
        self.inner.resource_offset = resource_offset;
        self
    }
    pub fn size(mut self, size: DeviceSize) -> SparseMemoryBindBuilder<'a> {
        self.inner.size = size;
        self
    }
    pub fn memory(mut self, memory: DeviceMemory) -> SparseMemoryBindBuilder<'a> {
        self.inner.memory = memory;
        self
    }
    pub fn memory_offset(mut self, memory_offset: DeviceSize) -> SparseMemoryBindBuilder<'a> {
        self.inner.memory_offset = memory_offset;
        self
    }
    pub fn flags(mut self, flags: SparseMemoryBindFlags) -> SparseMemoryBindBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SparseMemoryBind {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseImageMemoryBind.html>"]
pub struct SparseImageMemoryBind {
    pub subresource: ImageSubresource,
    pub offset: Offset3D,
    pub extent: Extent3D,
    pub memory: DeviceMemory,
    pub memory_offset: DeviceSize,
    pub flags: SparseMemoryBindFlags,
}
impl SparseImageMemoryBind {
    pub fn builder<'a>() -> SparseImageMemoryBindBuilder<'a> {
        SparseImageMemoryBindBuilder {
            inner: SparseImageMemoryBind::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SparseImageMemoryBindBuilder<'a> {
    inner: SparseImageMemoryBind,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SparseImageMemoryBindBuilder<'a> {
    type Target = SparseImageMemoryBind;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SparseImageMemoryBindBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SparseImageMemoryBindBuilder<'a> {
    pub fn subresource(
        mut self,
        subresource: ImageSubresource,
    ) -> SparseImageMemoryBindBuilder<'a> {
        self.inner.subresource = subresource;
        self
    }
    pub fn offset(mut self, offset: Offset3D) -> SparseImageMemoryBindBuilder<'a> {
        self.inner.offset = offset;
        self
    }
    pub fn extent(mut self, extent: Extent3D) -> SparseImageMemoryBindBuilder<'a> {
        self.inner.extent = extent;
        self
    }
    pub fn memory(mut self, memory: DeviceMemory) -> SparseImageMemoryBindBuilder<'a> {
        self.inner.memory = memory;
        self
    }
    pub fn memory_offset(mut self, memory_offset: DeviceSize) -> SparseImageMemoryBindBuilder<'a> {
        self.inner.memory_offset = memory_offset;
        self
    }
    pub fn flags(mut self, flags: SparseMemoryBindFlags) -> SparseImageMemoryBindBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SparseImageMemoryBind {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseBufferMemoryBindInfo.html>"]
pub struct SparseBufferMemoryBindInfo {
    pub buffer: Buffer,
    pub bind_count: u32,
    pub p_binds: *const SparseMemoryBind,
}
impl ::std::default::Default for SparseBufferMemoryBindInfo {
    fn default() -> SparseBufferMemoryBindInfo {
        SparseBufferMemoryBindInfo {
            buffer: Buffer::default(),
            bind_count: u32::default(),
            p_binds: ::std::ptr::null(),
        }
    }
}
impl SparseBufferMemoryBindInfo {
    pub fn builder<'a>() -> SparseBufferMemoryBindInfoBuilder<'a> {
        SparseBufferMemoryBindInfoBuilder {
            inner: SparseBufferMemoryBindInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SparseBufferMemoryBindInfoBuilder<'a> {
    inner: SparseBufferMemoryBindInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SparseBufferMemoryBindInfoBuilder<'a> {
    type Target = SparseBufferMemoryBindInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SparseBufferMemoryBindInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SparseBufferMemoryBindInfoBuilder<'a> {
    pub fn buffer(mut self, buffer: Buffer) -> SparseBufferMemoryBindInfoBuilder<'a> {
        self.inner.buffer = buffer;
        self
    }
    pub fn binds(mut self, binds: &'a [SparseMemoryBind]) -> SparseBufferMemoryBindInfoBuilder<'a> {
        self.inner.bind_count = binds.len() as _;
        self.inner.p_binds = binds.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SparseBufferMemoryBindInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseImageOpaqueMemoryBindInfo.html>"]
pub struct SparseImageOpaqueMemoryBindInfo {
    pub image: Image,
    pub bind_count: u32,
    pub p_binds: *const SparseMemoryBind,
}
impl ::std::default::Default for SparseImageOpaqueMemoryBindInfo {
    fn default() -> SparseImageOpaqueMemoryBindInfo {
        SparseImageOpaqueMemoryBindInfo {
            image: Image::default(),
            bind_count: u32::default(),
            p_binds: ::std::ptr::null(),
        }
    }
}
impl SparseImageOpaqueMemoryBindInfo {
    pub fn builder<'a>() -> SparseImageOpaqueMemoryBindInfoBuilder<'a> {
        SparseImageOpaqueMemoryBindInfoBuilder {
            inner: SparseImageOpaqueMemoryBindInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SparseImageOpaqueMemoryBindInfoBuilder<'a> {
    inner: SparseImageOpaqueMemoryBindInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SparseImageOpaqueMemoryBindInfoBuilder<'a> {
    type Target = SparseImageOpaqueMemoryBindInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SparseImageOpaqueMemoryBindInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SparseImageOpaqueMemoryBindInfoBuilder<'a> {
    pub fn image(mut self, image: Image) -> SparseImageOpaqueMemoryBindInfoBuilder<'a> {
        self.inner.image = image;
        self
    }
    pub fn binds(
        mut self,
        binds: &'a [SparseMemoryBind],
    ) -> SparseImageOpaqueMemoryBindInfoBuilder<'a> {
        self.inner.bind_count = binds.len() as _;
        self.inner.p_binds = binds.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SparseImageOpaqueMemoryBindInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseImageMemoryBindInfo.html>"]
pub struct SparseImageMemoryBindInfo {
    pub image: Image,
    pub bind_count: u32,
    pub p_binds: *const SparseImageMemoryBind,
}
impl ::std::default::Default for SparseImageMemoryBindInfo {
    fn default() -> SparseImageMemoryBindInfo {
        SparseImageMemoryBindInfo {
            image: Image::default(),
            bind_count: u32::default(),
            p_binds: ::std::ptr::null(),
        }
    }
}
impl SparseImageMemoryBindInfo {
    pub fn builder<'a>() -> SparseImageMemoryBindInfoBuilder<'a> {
        SparseImageMemoryBindInfoBuilder {
            inner: SparseImageMemoryBindInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SparseImageMemoryBindInfoBuilder<'a> {
    inner: SparseImageMemoryBindInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SparseImageMemoryBindInfoBuilder<'a> {
    type Target = SparseImageMemoryBindInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SparseImageMemoryBindInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SparseImageMemoryBindInfoBuilder<'a> {
    pub fn image(mut self, image: Image) -> SparseImageMemoryBindInfoBuilder<'a> {
        self.inner.image = image;
        self
    }
    pub fn binds(
        mut self,
        binds: &'a [SparseImageMemoryBind],
    ) -> SparseImageMemoryBindInfoBuilder<'a> {
        self.inner.bind_count = binds.len() as _;
        self.inner.p_binds = binds.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SparseImageMemoryBindInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindSparseInfo.html>"]
pub struct BindSparseInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub wait_semaphore_count: u32,
    pub p_wait_semaphores: *const Semaphore,
    pub buffer_bind_count: u32,
    pub p_buffer_binds: *const SparseBufferMemoryBindInfo,
    pub image_opaque_bind_count: u32,
    pub p_image_opaque_binds: *const SparseImageOpaqueMemoryBindInfo,
    pub image_bind_count: u32,
    pub p_image_binds: *const SparseImageMemoryBindInfo,
    pub signal_semaphore_count: u32,
    pub p_signal_semaphores: *const Semaphore,
}
impl ::std::default::Default for BindSparseInfo {
    fn default() -> BindSparseInfo {
        BindSparseInfo {
            s_type: StructureType::BIND_SPARSE_INFO,
            p_next: ::std::ptr::null(),
            wait_semaphore_count: u32::default(),
            p_wait_semaphores: ::std::ptr::null(),
            buffer_bind_count: u32::default(),
            p_buffer_binds: ::std::ptr::null(),
            image_opaque_bind_count: u32::default(),
            p_image_opaque_binds: ::std::ptr::null(),
            image_bind_count: u32::default(),
            p_image_binds: ::std::ptr::null(),
            signal_semaphore_count: u32::default(),
            p_signal_semaphores: ::std::ptr::null(),
        }
    }
}
impl BindSparseInfo {
    pub fn builder<'a>() -> BindSparseInfoBuilder<'a> {
        BindSparseInfoBuilder {
            inner: BindSparseInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BindSparseInfoBuilder<'a> {
    inner: BindSparseInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsBindSparseInfo {}
impl<'a> ::std::ops::Deref for BindSparseInfoBuilder<'a> {
    type Target = BindSparseInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BindSparseInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BindSparseInfoBuilder<'a> {
    pub fn wait_semaphores(
        mut self,
        wait_semaphores: &'a [Semaphore],
    ) -> BindSparseInfoBuilder<'a> {
        self.inner.wait_semaphore_count = wait_semaphores.len() as _;
        self.inner.p_wait_semaphores = wait_semaphores.as_ptr();
        self
    }
    pub fn buffer_binds(
        mut self,
        buffer_binds: &'a [SparseBufferMemoryBindInfo],
    ) -> BindSparseInfoBuilder<'a> {
        self.inner.buffer_bind_count = buffer_binds.len() as _;
        self.inner.p_buffer_binds = buffer_binds.as_ptr();
        self
    }
    pub fn image_opaque_binds(
        mut self,
        image_opaque_binds: &'a [SparseImageOpaqueMemoryBindInfo],
    ) -> BindSparseInfoBuilder<'a> {
        self.inner.image_opaque_bind_count = image_opaque_binds.len() as _;
        self.inner.p_image_opaque_binds = image_opaque_binds.as_ptr();
        self
    }
    pub fn image_binds(
        mut self,
        image_binds: &'a [SparseImageMemoryBindInfo],
    ) -> BindSparseInfoBuilder<'a> {
        self.inner.image_bind_count = image_binds.len() as _;
        self.inner.p_image_binds = image_binds.as_ptr();
        self
    }
    pub fn signal_semaphores(
        mut self,
        signal_semaphores: &'a [Semaphore],
    ) -> BindSparseInfoBuilder<'a> {
        self.inner.signal_semaphore_count = signal_semaphores.len() as _;
        self.inner.p_signal_semaphores = signal_semaphores.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsBindSparseInfo>(
        mut self,
        next: &'a mut T,
    ) -> BindSparseInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BindSparseInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageCopy.html>"]
pub struct ImageCopy {
    pub src_subresource: ImageSubresourceLayers,
    pub src_offset: Offset3D,
    pub dst_subresource: ImageSubresourceLayers,
    pub dst_offset: Offset3D,
    pub extent: Extent3D,
}
impl ImageCopy {
    pub fn builder<'a>() -> ImageCopyBuilder<'a> {
        ImageCopyBuilder {
            inner: ImageCopy::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageCopyBuilder<'a> {
    inner: ImageCopy,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImageCopyBuilder<'a> {
    type Target = ImageCopy;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageCopyBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageCopyBuilder<'a> {
    pub fn src_subresource(
        mut self,
        src_subresource: ImageSubresourceLayers,
    ) -> ImageCopyBuilder<'a> {
        self.inner.src_subresource = src_subresource;
        self
    }
    pub fn src_offset(mut self, src_offset: Offset3D) -> ImageCopyBuilder<'a> {
        self.inner.src_offset = src_offset;
        self
    }
    pub fn dst_subresource(
        mut self,
        dst_subresource: ImageSubresourceLayers,
    ) -> ImageCopyBuilder<'a> {
        self.inner.dst_subresource = dst_subresource;
        self
    }
    pub fn dst_offset(mut self, dst_offset: Offset3D) -> ImageCopyBuilder<'a> {
        self.inner.dst_offset = dst_offset;
        self
    }
    pub fn extent(mut self, extent: Extent3D) -> ImageCopyBuilder<'a> {
        self.inner.extent = extent;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageCopy {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageBlit.html>"]
pub struct ImageBlit {
    pub src_subresource: ImageSubresourceLayers,
    pub src_offsets: [Offset3D; 2],
    pub dst_subresource: ImageSubresourceLayers,
    pub dst_offsets: [Offset3D; 2],
}
impl ::std::default::Default for ImageBlit {
    fn default() -> ImageBlit {
        ImageBlit {
            src_subresource: ImageSubresourceLayers::default(),
            src_offsets: unsafe { ::std::mem::zeroed() },
            dst_subresource: ImageSubresourceLayers::default(),
            dst_offsets: unsafe { ::std::mem::zeroed() },
        }
    }
}
impl ImageBlit {
    pub fn builder<'a>() -> ImageBlitBuilder<'a> {
        ImageBlitBuilder {
            inner: ImageBlit::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageBlitBuilder<'a> {
    inner: ImageBlit,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImageBlitBuilder<'a> {
    type Target = ImageBlit;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageBlitBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageBlitBuilder<'a> {
    pub fn src_subresource(
        mut self,
        src_subresource: ImageSubresourceLayers,
    ) -> ImageBlitBuilder<'a> {
        self.inner.src_subresource = src_subresource;
        self
    }
    pub fn src_offsets(mut self, src_offsets: [Offset3D; 2]) -> ImageBlitBuilder<'a> {
        self.inner.src_offsets = src_offsets;
        self
    }
    pub fn dst_subresource(
        mut self,
        dst_subresource: ImageSubresourceLayers,
    ) -> ImageBlitBuilder<'a> {
        self.inner.dst_subresource = dst_subresource;
        self
    }
    pub fn dst_offsets(mut self, dst_offsets: [Offset3D; 2]) -> ImageBlitBuilder<'a> {
        self.inner.dst_offsets = dst_offsets;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageBlit {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBufferImageCopy.html>"]
pub struct BufferImageCopy {
    pub buffer_offset: DeviceSize,
    pub buffer_row_length: u32,
    pub buffer_image_height: u32,
    pub image_subresource: ImageSubresourceLayers,
    pub image_offset: Offset3D,
    pub image_extent: Extent3D,
}
impl BufferImageCopy {
    pub fn builder<'a>() -> BufferImageCopyBuilder<'a> {
        BufferImageCopyBuilder {
            inner: BufferImageCopy::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BufferImageCopyBuilder<'a> {
    inner: BufferImageCopy,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for BufferImageCopyBuilder<'a> {
    type Target = BufferImageCopy;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BufferImageCopyBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BufferImageCopyBuilder<'a> {
    pub fn buffer_offset(mut self, buffer_offset: DeviceSize) -> BufferImageCopyBuilder<'a> {
        self.inner.buffer_offset = buffer_offset;
        self
    }
    pub fn buffer_row_length(mut self, buffer_row_length: u32) -> BufferImageCopyBuilder<'a> {
        self.inner.buffer_row_length = buffer_row_length;
        self
    }
    pub fn buffer_image_height(mut self, buffer_image_height: u32) -> BufferImageCopyBuilder<'a> {
        self.inner.buffer_image_height = buffer_image_height;
        self
    }
    pub fn image_subresource(
        mut self,
        image_subresource: ImageSubresourceLayers,
    ) -> BufferImageCopyBuilder<'a> {
        self.inner.image_subresource = image_subresource;
        self
    }
    pub fn image_offset(mut self, image_offset: Offset3D) -> BufferImageCopyBuilder<'a> {
        self.inner.image_offset = image_offset;
        self
    }
    pub fn image_extent(mut self, image_extent: Extent3D) -> BufferImageCopyBuilder<'a> {
        self.inner.image_extent = image_extent;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BufferImageCopy {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageResolve.html>"]
pub struct ImageResolve {
    pub src_subresource: ImageSubresourceLayers,
    pub src_offset: Offset3D,
    pub dst_subresource: ImageSubresourceLayers,
    pub dst_offset: Offset3D,
    pub extent: Extent3D,
}
impl ImageResolve {
    pub fn builder<'a>() -> ImageResolveBuilder<'a> {
        ImageResolveBuilder {
            inner: ImageResolve::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageResolveBuilder<'a> {
    inner: ImageResolve,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImageResolveBuilder<'a> {
    type Target = ImageResolve;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageResolveBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageResolveBuilder<'a> {
    pub fn src_subresource(
        mut self,
        src_subresource: ImageSubresourceLayers,
    ) -> ImageResolveBuilder<'a> {
        self.inner.src_subresource = src_subresource;
        self
    }
    pub fn src_offset(mut self, src_offset: Offset3D) -> ImageResolveBuilder<'a> {
        self.inner.src_offset = src_offset;
        self
    }
    pub fn dst_subresource(
        mut self,
        dst_subresource: ImageSubresourceLayers,
    ) -> ImageResolveBuilder<'a> {
        self.inner.dst_subresource = dst_subresource;
        self
    }
    pub fn dst_offset(mut self, dst_offset: Offset3D) -> ImageResolveBuilder<'a> {
        self.inner.dst_offset = dst_offset;
        self
    }
    pub fn extent(mut self, extent: Extent3D) -> ImageResolveBuilder<'a> {
        self.inner.extent = extent;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageResolve {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkShaderModuleCreateInfo.html>"]
pub struct ShaderModuleCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ShaderModuleCreateFlags,
    pub code_size: usize,
    pub p_code: *const u32,
}
impl ::std::default::Default for ShaderModuleCreateInfo {
    fn default() -> ShaderModuleCreateInfo {
        ShaderModuleCreateInfo {
            s_type: StructureType::SHADER_MODULE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: ShaderModuleCreateFlags::default(),
            code_size: usize::default(),
            p_code: ::std::ptr::null(),
        }
    }
}
impl ShaderModuleCreateInfo {
    pub fn builder<'a>() -> ShaderModuleCreateInfoBuilder<'a> {
        ShaderModuleCreateInfoBuilder {
            inner: ShaderModuleCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ShaderModuleCreateInfoBuilder<'a> {
    inner: ShaderModuleCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsShaderModuleCreateInfo {}
impl<'a> ::std::ops::Deref for ShaderModuleCreateInfoBuilder<'a> {
    type Target = ShaderModuleCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ShaderModuleCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ShaderModuleCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: ShaderModuleCreateFlags) -> ShaderModuleCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn code(mut self, code: &'a [u32]) -> ShaderModuleCreateInfoBuilder<'a> {
        self.inner.code_size = code.len() * 4;
        self.inner.p_code = code.as_ptr() as *const u32;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsShaderModuleCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> ShaderModuleCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ShaderModuleCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorSetLayoutBinding.html>"]
pub struct DescriptorSetLayoutBinding {
    pub binding: u32,
    pub descriptor_type: DescriptorType,
    pub descriptor_count: u32,
    pub stage_flags: ShaderStageFlags,
    pub p_immutable_samplers: *const Sampler,
}
impl ::std::default::Default for DescriptorSetLayoutBinding {
    fn default() -> DescriptorSetLayoutBinding {
        DescriptorSetLayoutBinding {
            binding: u32::default(),
            descriptor_type: DescriptorType::default(),
            descriptor_count: u32::default(),
            stage_flags: ShaderStageFlags::default(),
            p_immutable_samplers: ::std::ptr::null(),
        }
    }
}
impl DescriptorSetLayoutBinding {
    pub fn builder<'a>() -> DescriptorSetLayoutBindingBuilder<'a> {
        DescriptorSetLayoutBindingBuilder {
            inner: DescriptorSetLayoutBinding::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DescriptorSetLayoutBindingBuilder<'a> {
    inner: DescriptorSetLayoutBinding,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DescriptorSetLayoutBindingBuilder<'a> {
    type Target = DescriptorSetLayoutBinding;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DescriptorSetLayoutBindingBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DescriptorSetLayoutBindingBuilder<'a> {
    pub fn binding(mut self, binding: u32) -> DescriptorSetLayoutBindingBuilder<'a> {
        self.inner.binding = binding;
        self
    }
    pub fn descriptor_type(
        mut self,
        descriptor_type: DescriptorType,
    ) -> DescriptorSetLayoutBindingBuilder<'a> {
        self.inner.descriptor_type = descriptor_type;
        self
    }
    pub fn descriptor_count(
        mut self,
        descriptor_count: u32,
    ) -> DescriptorSetLayoutBindingBuilder<'a> {
        self.inner.descriptor_count = descriptor_count;
        self
    }
    pub fn stage_flags(
        mut self,
        stage_flags: ShaderStageFlags,
    ) -> DescriptorSetLayoutBindingBuilder<'a> {
        self.inner.stage_flags = stage_flags;
        self
    }
    pub fn immutable_samplers(
        mut self,
        immutable_samplers: &'a [Sampler],
    ) -> DescriptorSetLayoutBindingBuilder<'a> {
        self.inner.descriptor_count = immutable_samplers.len() as _;
        self.inner.p_immutable_samplers = immutable_samplers.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DescriptorSetLayoutBinding {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorSetLayoutCreateInfo.html>"]
pub struct DescriptorSetLayoutCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DescriptorSetLayoutCreateFlags,
    pub binding_count: u32,
    pub p_bindings: *const DescriptorSetLayoutBinding,
}
impl ::std::default::Default for DescriptorSetLayoutCreateInfo {
    fn default() -> DescriptorSetLayoutCreateInfo {
        DescriptorSetLayoutCreateInfo {
            s_type: StructureType::DESCRIPTOR_SET_LAYOUT_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: DescriptorSetLayoutCreateFlags::default(),
            binding_count: u32::default(),
            p_bindings: ::std::ptr::null(),
        }
    }
}
impl DescriptorSetLayoutCreateInfo {
    pub fn builder<'a>() -> DescriptorSetLayoutCreateInfoBuilder<'a> {
        DescriptorSetLayoutCreateInfoBuilder {
            inner: DescriptorSetLayoutCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DescriptorSetLayoutCreateInfoBuilder<'a> {
    inner: DescriptorSetLayoutCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsDescriptorSetLayoutCreateInfo {}
impl<'a> ::std::ops::Deref for DescriptorSetLayoutCreateInfoBuilder<'a> {
    type Target = DescriptorSetLayoutCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DescriptorSetLayoutCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DescriptorSetLayoutCreateInfoBuilder<'a> {
    pub fn flags(
        mut self,
        flags: DescriptorSetLayoutCreateFlags,
    ) -> DescriptorSetLayoutCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn bindings(
        mut self,
        bindings: &'a [DescriptorSetLayoutBinding],
    ) -> DescriptorSetLayoutCreateInfoBuilder<'a> {
        self.inner.binding_count = bindings.len() as _;
        self.inner.p_bindings = bindings.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDescriptorSetLayoutCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> DescriptorSetLayoutCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DescriptorSetLayoutCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorPoolSize.html>"]
pub struct DescriptorPoolSize {
    pub ty: DescriptorType,
    pub descriptor_count: u32,
}
impl DescriptorPoolSize {
    pub fn builder<'a>() -> DescriptorPoolSizeBuilder<'a> {
        DescriptorPoolSizeBuilder {
            inner: DescriptorPoolSize::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DescriptorPoolSizeBuilder<'a> {
    inner: DescriptorPoolSize,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DescriptorPoolSizeBuilder<'a> {
    type Target = DescriptorPoolSize;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DescriptorPoolSizeBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DescriptorPoolSizeBuilder<'a> {
    pub fn ty(mut self, ty: DescriptorType) -> DescriptorPoolSizeBuilder<'a> {
        self.inner.ty = ty;
        self
    }
    pub fn descriptor_count(mut self, descriptor_count: u32) -> DescriptorPoolSizeBuilder<'a> {
        self.inner.descriptor_count = descriptor_count;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DescriptorPoolSize {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorPoolCreateInfo.html>"]
pub struct DescriptorPoolCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DescriptorPoolCreateFlags,
    pub max_sets: u32,
    pub pool_size_count: u32,
    pub p_pool_sizes: *const DescriptorPoolSize,
}
impl ::std::default::Default for DescriptorPoolCreateInfo {
    fn default() -> DescriptorPoolCreateInfo {
        DescriptorPoolCreateInfo {
            s_type: StructureType::DESCRIPTOR_POOL_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: DescriptorPoolCreateFlags::default(),
            max_sets: u32::default(),
            pool_size_count: u32::default(),
            p_pool_sizes: ::std::ptr::null(),
        }
    }
}
impl DescriptorPoolCreateInfo {
    pub fn builder<'a>() -> DescriptorPoolCreateInfoBuilder<'a> {
        DescriptorPoolCreateInfoBuilder {
            inner: DescriptorPoolCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DescriptorPoolCreateInfoBuilder<'a> {
    inner: DescriptorPoolCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsDescriptorPoolCreateInfo {}
impl<'a> ::std::ops::Deref for DescriptorPoolCreateInfoBuilder<'a> {
    type Target = DescriptorPoolCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DescriptorPoolCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DescriptorPoolCreateInfoBuilder<'a> {
    pub fn flags(
        mut self,
        flags: DescriptorPoolCreateFlags,
    ) -> DescriptorPoolCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn max_sets(mut self, max_sets: u32) -> DescriptorPoolCreateInfoBuilder<'a> {
        self.inner.max_sets = max_sets;
        self
    }
    pub fn pool_sizes(
        mut self,
        pool_sizes: &'a [DescriptorPoolSize],
    ) -> DescriptorPoolCreateInfoBuilder<'a> {
        self.inner.pool_size_count = pool_sizes.len() as _;
        self.inner.p_pool_sizes = pool_sizes.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDescriptorPoolCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> DescriptorPoolCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DescriptorPoolCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDescriptorSetAllocateInfo.html>"]
pub struct DescriptorSetAllocateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub descriptor_pool: DescriptorPool,
    pub descriptor_set_count: u32,
    pub p_set_layouts: *const DescriptorSetLayout,
}
impl ::std::default::Default for DescriptorSetAllocateInfo {
    fn default() -> DescriptorSetAllocateInfo {
        DescriptorSetAllocateInfo {
            s_type: StructureType::DESCRIPTOR_SET_ALLOCATE_INFO,
            p_next: ::std::ptr::null(),
            descriptor_pool: DescriptorPool::default(),
            descriptor_set_count: u32::default(),
            p_set_layouts: ::std::ptr::null(),
        }
    }
}
impl DescriptorSetAllocateInfo {
    pub fn builder<'a>() -> DescriptorSetAllocateInfoBuilder<'a> {
        DescriptorSetAllocateInfoBuilder {
            inner: DescriptorSetAllocateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DescriptorSetAllocateInfoBuilder<'a> {
    inner: DescriptorSetAllocateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsDescriptorSetAllocateInfo {}
impl<'a> ::std::ops::Deref for DescriptorSetAllocateInfoBuilder<'a> {
    type Target = DescriptorSetAllocateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DescriptorSetAllocateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DescriptorSetAllocateInfoBuilder<'a> {
    pub fn descriptor_pool(
        mut self,
        descriptor_pool: DescriptorPool,
    ) -> DescriptorSetAllocateInfoBuilder<'a> {
        self.inner.descriptor_pool = descriptor_pool;
        self
    }
    pub fn set_layouts(
        mut self,
        set_layouts: &'a [DescriptorSetLayout],
    ) -> DescriptorSetAllocateInfoBuilder<'a> {
        self.inner.descriptor_set_count = set_layouts.len() as _;
        self.inner.p_set_layouts = set_layouts.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDescriptorSetAllocateInfo>(
        mut self,
        next: &'a mut T,
    ) -> DescriptorSetAllocateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DescriptorSetAllocateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSpecializationMapEntry.html>"]
pub struct SpecializationMapEntry {
    pub constant_id: u32,
    pub offset: u32,
    pub size: usize,
}
impl SpecializationMapEntry {
    pub fn builder<'a>() -> SpecializationMapEntryBuilder<'a> {
        SpecializationMapEntryBuilder {
            inner: SpecializationMapEntry::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SpecializationMapEntryBuilder<'a> {
    inner: SpecializationMapEntry,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SpecializationMapEntryBuilder<'a> {
    type Target = SpecializationMapEntry;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SpecializationMapEntryBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SpecializationMapEntryBuilder<'a> {
    pub fn constant_id(mut self, constant_id: u32) -> SpecializationMapEntryBuilder<'a> {
        self.inner.constant_id = constant_id;
        self
    }
    pub fn offset(mut self, offset: u32) -> SpecializationMapEntryBuilder<'a> {
        self.inner.offset = offset;
        self
    }
    pub fn size(mut self, size: usize) -> SpecializationMapEntryBuilder<'a> {
        self.inner.size = size;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SpecializationMapEntry {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSpecializationInfo.html>"]
pub struct SpecializationInfo {
    pub map_entry_count: u32,
    pub p_map_entries: *const SpecializationMapEntry,
    pub data_size: usize,
    pub p_data: *const c_void,
}
impl ::std::default::Default for SpecializationInfo {
    fn default() -> SpecializationInfo {
        SpecializationInfo {
            map_entry_count: u32::default(),
            p_map_entries: ::std::ptr::null(),
            data_size: usize::default(),
            p_data: ::std::ptr::null(),
        }
    }
}
impl SpecializationInfo {
    pub fn builder<'a>() -> SpecializationInfoBuilder<'a> {
        SpecializationInfoBuilder {
            inner: SpecializationInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SpecializationInfoBuilder<'a> {
    inner: SpecializationInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SpecializationInfoBuilder<'a> {
    type Target = SpecializationInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SpecializationInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SpecializationInfoBuilder<'a> {
    pub fn map_entries(
        mut self,
        map_entries: &'a [SpecializationMapEntry],
    ) -> SpecializationInfoBuilder<'a> {
        self.inner.map_entry_count = map_entries.len() as _;
        self.inner.p_map_entries = map_entries.as_ptr();
        self
    }
    pub fn data(mut self, data: &'a [u8]) -> SpecializationInfoBuilder<'a> {
        self.inner.data_size = data.len() as _;
        self.inner.p_data = data.as_ptr() as *const c_void;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SpecializationInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineShaderStageCreateInfo.html>"]
pub struct PipelineShaderStageCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineShaderStageCreateFlags,
    pub stage: ShaderStageFlags,
    pub module: ShaderModule,
    pub p_name: *const c_char,
    pub p_specialization_info: *const SpecializationInfo,
}
impl ::std::default::Default for PipelineShaderStageCreateInfo {
    fn default() -> PipelineShaderStageCreateInfo {
        PipelineShaderStageCreateInfo {
            s_type: StructureType::PIPELINE_SHADER_STAGE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: PipelineShaderStageCreateFlags::default(),
            stage: ShaderStageFlags::default(),
            module: ShaderModule::default(),
            p_name: ::std::ptr::null(),
            p_specialization_info: ::std::ptr::null(),
        }
    }
}
impl PipelineShaderStageCreateInfo {
    pub fn builder<'a>() -> PipelineShaderStageCreateInfoBuilder<'a> {
        PipelineShaderStageCreateInfoBuilder {
            inner: PipelineShaderStageCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineShaderStageCreateInfoBuilder<'a> {
    inner: PipelineShaderStageCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineShaderStageCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineShaderStageCreateInfoBuilder<'a> {
    type Target = PipelineShaderStageCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineShaderStageCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineShaderStageCreateInfoBuilder<'a> {
    pub fn flags(
        mut self,
        flags: PipelineShaderStageCreateFlags,
    ) -> PipelineShaderStageCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn stage(mut self, stage: ShaderStageFlags) -> PipelineShaderStageCreateInfoBuilder<'a> {
        self.inner.stage = stage;
        self
    }
    pub fn module(mut self, module: ShaderModule) -> PipelineShaderStageCreateInfoBuilder<'a> {
        self.inner.module = module;
        self
    }
    pub fn name(mut self, name: &'a ::std::ffi::CStr) -> PipelineShaderStageCreateInfoBuilder<'a> {
        self.inner.p_name = name.as_ptr();
        self
    }
    pub fn specialization_info(
        mut self,
        specialization_info: &'a SpecializationInfo,
    ) -> PipelineShaderStageCreateInfoBuilder<'a> {
        self.inner.p_specialization_info = specialization_info;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineShaderStageCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> PipelineShaderStageCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineShaderStageCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkComputePipelineCreateInfo.html>"]
pub struct ComputePipelineCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineCreateFlags,
    pub stage: PipelineShaderStageCreateInfo,
    pub layout: PipelineLayout,
    pub base_pipeline_handle: Pipeline,
    pub base_pipeline_index: i32,
}
impl ::std::default::Default for ComputePipelineCreateInfo {
    fn default() -> ComputePipelineCreateInfo {
        ComputePipelineCreateInfo {
            s_type: StructureType::COMPUTE_PIPELINE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: PipelineCreateFlags::default(),
            stage: PipelineShaderStageCreateInfo::default(),
            layout: PipelineLayout::default(),
            base_pipeline_handle: Pipeline::default(),
            base_pipeline_index: i32::default(),
        }
    }
}
impl ComputePipelineCreateInfo {
    pub fn builder<'a>() -> ComputePipelineCreateInfoBuilder<'a> {
        ComputePipelineCreateInfoBuilder {
            inner: ComputePipelineCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ComputePipelineCreateInfoBuilder<'a> {
    inner: ComputePipelineCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsComputePipelineCreateInfo {}
impl<'a> ::std::ops::Deref for ComputePipelineCreateInfoBuilder<'a> {
    type Target = ComputePipelineCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ComputePipelineCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ComputePipelineCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: PipelineCreateFlags) -> ComputePipelineCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn stage(
        mut self,
        stage: PipelineShaderStageCreateInfo,
    ) -> ComputePipelineCreateInfoBuilder<'a> {
        self.inner.stage = stage;
        self
    }
    pub fn layout(mut self, layout: PipelineLayout) -> ComputePipelineCreateInfoBuilder<'a> {
        self.inner.layout = layout;
        self
    }
    pub fn base_pipeline_handle(
        mut self,
        base_pipeline_handle: Pipeline,
    ) -> ComputePipelineCreateInfoBuilder<'a> {
        self.inner.base_pipeline_handle = base_pipeline_handle;
        self
    }
    pub fn base_pipeline_index(
        mut self,
        base_pipeline_index: i32,
    ) -> ComputePipelineCreateInfoBuilder<'a> {
        self.inner.base_pipeline_index = base_pipeline_index;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsComputePipelineCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> ComputePipelineCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ComputePipelineCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkVertexInputBindingDescription.html>"]
pub struct VertexInputBindingDescription {
    pub binding: u32,
    pub stride: u32,
    pub input_rate: VertexInputRate,
}
impl VertexInputBindingDescription {
    pub fn builder<'a>() -> VertexInputBindingDescriptionBuilder<'a> {
        VertexInputBindingDescriptionBuilder {
            inner: VertexInputBindingDescription::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct VertexInputBindingDescriptionBuilder<'a> {
    inner: VertexInputBindingDescription,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for VertexInputBindingDescriptionBuilder<'a> {
    type Target = VertexInputBindingDescription;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for VertexInputBindingDescriptionBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> VertexInputBindingDescriptionBuilder<'a> {
    pub fn binding(mut self, binding: u32) -> VertexInputBindingDescriptionBuilder<'a> {
        self.inner.binding = binding;
        self
    }
    pub fn stride(mut self, stride: u32) -> VertexInputBindingDescriptionBuilder<'a> {
        self.inner.stride = stride;
        self
    }
    pub fn input_rate(
        mut self,
        input_rate: VertexInputRate,
    ) -> VertexInputBindingDescriptionBuilder<'a> {
        self.inner.input_rate = input_rate;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> VertexInputBindingDescription {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkVertexInputAttributeDescription.html>"]
pub struct VertexInputAttributeDescription {
    pub location: u32,
    pub binding: u32,
    pub format: Format,
    pub offset: u32,
}
impl VertexInputAttributeDescription {
    pub fn builder<'a>() -> VertexInputAttributeDescriptionBuilder<'a> {
        VertexInputAttributeDescriptionBuilder {
            inner: VertexInputAttributeDescription::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct VertexInputAttributeDescriptionBuilder<'a> {
    inner: VertexInputAttributeDescription,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for VertexInputAttributeDescriptionBuilder<'a> {
    type Target = VertexInputAttributeDescription;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for VertexInputAttributeDescriptionBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> VertexInputAttributeDescriptionBuilder<'a> {
    pub fn location(mut self, location: u32) -> VertexInputAttributeDescriptionBuilder<'a> {
        self.inner.location = location;
        self
    }
    pub fn binding(mut self, binding: u32) -> VertexInputAttributeDescriptionBuilder<'a> {
        self.inner.binding = binding;
        self
    }
    pub fn format(mut self, format: Format) -> VertexInputAttributeDescriptionBuilder<'a> {
        self.inner.format = format;
        self
    }
    pub fn offset(mut self, offset: u32) -> VertexInputAttributeDescriptionBuilder<'a> {
        self.inner.offset = offset;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> VertexInputAttributeDescription {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineVertexInputStateCreateInfo.html>"]
pub struct PipelineVertexInputStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineVertexInputStateCreateFlags,
    pub vertex_binding_description_count: u32,
    pub p_vertex_binding_descriptions: *const VertexInputBindingDescription,
    pub vertex_attribute_description_count: u32,
    pub p_vertex_attribute_descriptions: *const VertexInputAttributeDescription,
}
impl ::std::default::Default for PipelineVertexInputStateCreateInfo {
    fn default() -> PipelineVertexInputStateCreateInfo {
        PipelineVertexInputStateCreateInfo {
            s_type: StructureType::PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: PipelineVertexInputStateCreateFlags::default(),
            vertex_binding_description_count: u32::default(),
            p_vertex_binding_descriptions: ::std::ptr::null(),
            vertex_attribute_description_count: u32::default(),
            p_vertex_attribute_descriptions: ::std::ptr::null(),
        }
    }
}
impl PipelineVertexInputStateCreateInfo {
    pub fn builder<'a>() -> PipelineVertexInputStateCreateInfoBuilder<'a> {
        PipelineVertexInputStateCreateInfoBuilder {
            inner: PipelineVertexInputStateCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineVertexInputStateCreateInfoBuilder<'a> {
    inner: PipelineVertexInputStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineVertexInputStateCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineVertexInputStateCreateInfoBuilder<'a> {
    type Target = PipelineVertexInputStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineVertexInputStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineVertexInputStateCreateInfoBuilder<'a> {
    pub fn flags(
        mut self,
        flags: PipelineVertexInputStateCreateFlags,
    ) -> PipelineVertexInputStateCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn vertex_binding_descriptions(
        mut self,
        vertex_binding_descriptions: &'a [VertexInputBindingDescription],
    ) -> PipelineVertexInputStateCreateInfoBuilder<'a> {
        self.inner.vertex_binding_description_count = vertex_binding_descriptions.len() as _;
        self.inner.p_vertex_binding_descriptions = vertex_binding_descriptions.as_ptr();
        self
    }
    pub fn vertex_attribute_descriptions(
        mut self,
        vertex_attribute_descriptions: &'a [VertexInputAttributeDescription],
    ) -> PipelineVertexInputStateCreateInfoBuilder<'a> {
        self.inner.vertex_attribute_description_count = vertex_attribute_descriptions.len() as _;
        self.inner.p_vertex_attribute_descriptions = vertex_attribute_descriptions.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineVertexInputStateCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> PipelineVertexInputStateCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineVertexInputStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineInputAssemblyStateCreateInfo.html>"]
pub struct PipelineInputAssemblyStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineInputAssemblyStateCreateFlags,
    pub topology: PrimitiveTopology,
    pub primitive_restart_enable: Bool32,
}
impl ::std::default::Default for PipelineInputAssemblyStateCreateInfo {
    fn default() -> PipelineInputAssemblyStateCreateInfo {
        PipelineInputAssemblyStateCreateInfo {
            s_type: StructureType::PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: PipelineInputAssemblyStateCreateFlags::default(),
            topology: PrimitiveTopology::default(),
            primitive_restart_enable: Bool32::default(),
        }
    }
}
impl PipelineInputAssemblyStateCreateInfo {
    pub fn builder<'a>() -> PipelineInputAssemblyStateCreateInfoBuilder<'a> {
        PipelineInputAssemblyStateCreateInfoBuilder {
            inner: PipelineInputAssemblyStateCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineInputAssemblyStateCreateInfoBuilder<'a> {
    inner: PipelineInputAssemblyStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineInputAssemblyStateCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineInputAssemblyStateCreateInfoBuilder<'a> {
    type Target = PipelineInputAssemblyStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineInputAssemblyStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineInputAssemblyStateCreateInfoBuilder<'a> {
    pub fn flags(
        mut self,
        flags: PipelineInputAssemblyStateCreateFlags,
    ) -> PipelineInputAssemblyStateCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn topology(
        mut self,
        topology: PrimitiveTopology,
    ) -> PipelineInputAssemblyStateCreateInfoBuilder<'a> {
        self.inner.topology = topology;
        self
    }
    pub fn primitive_restart_enable(
        mut self,
        primitive_restart_enable: bool,
    ) -> PipelineInputAssemblyStateCreateInfoBuilder<'a> {
        self.inner.primitive_restart_enable = primitive_restart_enable.into();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineInputAssemblyStateCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> PipelineInputAssemblyStateCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineInputAssemblyStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineTessellationStateCreateInfo.html>"]
pub struct PipelineTessellationStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineTessellationStateCreateFlags,
    pub patch_control_points: u32,
}
impl ::std::default::Default for PipelineTessellationStateCreateInfo {
    fn default() -> PipelineTessellationStateCreateInfo {
        PipelineTessellationStateCreateInfo {
            s_type: StructureType::PIPELINE_TESSELLATION_STATE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: PipelineTessellationStateCreateFlags::default(),
            patch_control_points: u32::default(),
        }
    }
}
impl PipelineTessellationStateCreateInfo {
    pub fn builder<'a>() -> PipelineTessellationStateCreateInfoBuilder<'a> {
        PipelineTessellationStateCreateInfoBuilder {
            inner: PipelineTessellationStateCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineTessellationStateCreateInfoBuilder<'a> {
    inner: PipelineTessellationStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineTessellationStateCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineTessellationStateCreateInfoBuilder<'a> {
    type Target = PipelineTessellationStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineTessellationStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineTessellationStateCreateInfoBuilder<'a> {
    pub fn flags(
        mut self,
        flags: PipelineTessellationStateCreateFlags,
    ) -> PipelineTessellationStateCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn patch_control_points(
        mut self,
        patch_control_points: u32,
    ) -> PipelineTessellationStateCreateInfoBuilder<'a> {
        self.inner.patch_control_points = patch_control_points;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineTessellationStateCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> PipelineTessellationStateCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineTessellationStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineViewportStateCreateInfo.html>"]
pub struct PipelineViewportStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineViewportStateCreateFlags,
    pub viewport_count: u32,
    pub p_viewports: *const Viewport,
    pub scissor_count: u32,
    pub p_scissors: *const Rect2D,
}
impl ::std::default::Default for PipelineViewportStateCreateInfo {
    fn default() -> PipelineViewportStateCreateInfo {
        PipelineViewportStateCreateInfo {
            s_type: StructureType::PIPELINE_VIEWPORT_STATE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: PipelineViewportStateCreateFlags::default(),
            viewport_count: u32::default(),
            p_viewports: ::std::ptr::null(),
            scissor_count: u32::default(),
            p_scissors: ::std::ptr::null(),
        }
    }
}
impl PipelineViewportStateCreateInfo {
    pub fn builder<'a>() -> PipelineViewportStateCreateInfoBuilder<'a> {
        PipelineViewportStateCreateInfoBuilder {
            inner: PipelineViewportStateCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineViewportStateCreateInfoBuilder<'a> {
    inner: PipelineViewportStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineViewportStateCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineViewportStateCreateInfoBuilder<'a> {
    type Target = PipelineViewportStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineViewportStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineViewportStateCreateInfoBuilder<'a> {
    pub fn flags(
        mut self,
        flags: PipelineViewportStateCreateFlags,
    ) -> PipelineViewportStateCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn viewport_count(
        mut self,
        viewport_count: u32,
    ) -> PipelineViewportStateCreateInfoBuilder<'a> {
        self.inner.viewport_count = viewport_count;
        self
    }
    pub fn viewports(
        mut self,
        viewports: &'a [Viewport],
    ) -> PipelineViewportStateCreateInfoBuilder<'a> {
        self.inner.viewport_count = viewports.len() as _;
        self.inner.p_viewports = viewports.as_ptr();
        self
    }
    pub fn scissor_count(
        mut self,
        scissor_count: u32,
    ) -> PipelineViewportStateCreateInfoBuilder<'a> {
        self.inner.scissor_count = scissor_count;
        self
    }
    pub fn scissors(
        mut self,
        scissors: &'a [Rect2D],
    ) -> PipelineViewportStateCreateInfoBuilder<'a> {
        self.inner.scissor_count = scissors.len() as _;
        self.inner.p_scissors = scissors.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineViewportStateCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> PipelineViewportStateCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineViewportStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineRasterizationStateCreateInfo.html>"]
pub struct PipelineRasterizationStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineRasterizationStateCreateFlags,
    pub depth_clamp_enable: Bool32,
    pub rasterizer_discard_enable: Bool32,
    pub polygon_mode: PolygonMode,
    pub cull_mode: CullModeFlags,
    pub front_face: FrontFace,
    pub depth_bias_enable: Bool32,
    pub depth_bias_constant_factor: f32,
    pub depth_bias_clamp: f32,
    pub depth_bias_slope_factor: f32,
    pub line_width: f32,
}
impl ::std::default::Default for PipelineRasterizationStateCreateInfo {
    fn default() -> PipelineRasterizationStateCreateInfo {
        PipelineRasterizationStateCreateInfo {
            s_type: StructureType::PIPELINE_RASTERIZATION_STATE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: PipelineRasterizationStateCreateFlags::default(),
            depth_clamp_enable: Bool32::default(),
            rasterizer_discard_enable: Bool32::default(),
            polygon_mode: PolygonMode::default(),
            cull_mode: CullModeFlags::default(),
            front_face: FrontFace::default(),
            depth_bias_enable: Bool32::default(),
            depth_bias_constant_factor: f32::default(),
            depth_bias_clamp: f32::default(),
            depth_bias_slope_factor: f32::default(),
            line_width: f32::default(),
        }
    }
}
impl PipelineRasterizationStateCreateInfo {
    pub fn builder<'a>() -> PipelineRasterizationStateCreateInfoBuilder<'a> {
        PipelineRasterizationStateCreateInfoBuilder {
            inner: PipelineRasterizationStateCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineRasterizationStateCreateInfoBuilder<'a> {
    inner: PipelineRasterizationStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineRasterizationStateCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineRasterizationStateCreateInfoBuilder<'a> {
    type Target = PipelineRasterizationStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineRasterizationStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineRasterizationStateCreateInfoBuilder<'a> {
    pub fn flags(
        mut self,
        flags: PipelineRasterizationStateCreateFlags,
    ) -> PipelineRasterizationStateCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn depth_clamp_enable(
        mut self,
        depth_clamp_enable: bool,
    ) -> PipelineRasterizationStateCreateInfoBuilder<'a> {
        self.inner.depth_clamp_enable = depth_clamp_enable.into();
        self
    }
    pub fn rasterizer_discard_enable(
        mut self,
        rasterizer_discard_enable: bool,
    ) -> PipelineRasterizationStateCreateInfoBuilder<'a> {
        self.inner.rasterizer_discard_enable = rasterizer_discard_enable.into();
        self
    }
    pub fn polygon_mode(
        mut self,
        polygon_mode: PolygonMode,
    ) -> PipelineRasterizationStateCreateInfoBuilder<'a> {
        self.inner.polygon_mode = polygon_mode;
        self
    }
    pub fn cull_mode(
        mut self,
        cull_mode: CullModeFlags,
    ) -> PipelineRasterizationStateCreateInfoBuilder<'a> {
        self.inner.cull_mode = cull_mode;
        self
    }
    pub fn front_face(
        mut self,
        front_face: FrontFace,
    ) -> PipelineRasterizationStateCreateInfoBuilder<'a> {
        self.inner.front_face = front_face;
        self
    }
    pub fn depth_bias_enable(
        mut self,
        depth_bias_enable: bool,
    ) -> PipelineRasterizationStateCreateInfoBuilder<'a> {
        self.inner.depth_bias_enable = depth_bias_enable.into();
        self
    }
    pub fn depth_bias_constant_factor(
        mut self,
        depth_bias_constant_factor: f32,
    ) -> PipelineRasterizationStateCreateInfoBuilder<'a> {
        self.inner.depth_bias_constant_factor = depth_bias_constant_factor;
        self
    }
    pub fn depth_bias_clamp(
        mut self,
        depth_bias_clamp: f32,
    ) -> PipelineRasterizationStateCreateInfoBuilder<'a> {
        self.inner.depth_bias_clamp = depth_bias_clamp;
        self
    }
    pub fn depth_bias_slope_factor(
        mut self,
        depth_bias_slope_factor: f32,
    ) -> PipelineRasterizationStateCreateInfoBuilder<'a> {
        self.inner.depth_bias_slope_factor = depth_bias_slope_factor;
        self
    }
    pub fn line_width(
        mut self,
        line_width: f32,
    ) -> PipelineRasterizationStateCreateInfoBuilder<'a> {
        self.inner.line_width = line_width;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineRasterizationStateCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> PipelineRasterizationStateCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineRasterizationStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineMultisampleStateCreateInfo.html>"]
pub struct PipelineMultisampleStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineMultisampleStateCreateFlags,
    pub rasterization_samples: SampleCountFlags,
    pub sample_shading_enable: Bool32,
    pub min_sample_shading: f32,
    pub p_sample_mask: *const SampleMask,
    pub alpha_to_coverage_enable: Bool32,
    pub alpha_to_one_enable: Bool32,
}
impl ::std::default::Default for PipelineMultisampleStateCreateInfo {
    fn default() -> PipelineMultisampleStateCreateInfo {
        PipelineMultisampleStateCreateInfo {
            s_type: StructureType::PIPELINE_MULTISAMPLE_STATE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: PipelineMultisampleStateCreateFlags::default(),
            rasterization_samples: SampleCountFlags::default(),
            sample_shading_enable: Bool32::default(),
            min_sample_shading: f32::default(),
            p_sample_mask: ::std::ptr::null(),
            alpha_to_coverage_enable: Bool32::default(),
            alpha_to_one_enable: Bool32::default(),
        }
    }
}
impl PipelineMultisampleStateCreateInfo {
    pub fn builder<'a>() -> PipelineMultisampleStateCreateInfoBuilder<'a> {
        PipelineMultisampleStateCreateInfoBuilder {
            inner: PipelineMultisampleStateCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineMultisampleStateCreateInfoBuilder<'a> {
    inner: PipelineMultisampleStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineMultisampleStateCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineMultisampleStateCreateInfoBuilder<'a> {
    type Target = PipelineMultisampleStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineMultisampleStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineMultisampleStateCreateInfoBuilder<'a> {
    pub fn flags(
        mut self,
        flags: PipelineMultisampleStateCreateFlags,
    ) -> PipelineMultisampleStateCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn rasterization_samples(
        mut self,
        rasterization_samples: SampleCountFlags,
    ) -> PipelineMultisampleStateCreateInfoBuilder<'a> {
        self.inner.rasterization_samples = rasterization_samples;
        self
    }
    pub fn sample_shading_enable(
        mut self,
        sample_shading_enable: bool,
    ) -> PipelineMultisampleStateCreateInfoBuilder<'a> {
        self.inner.sample_shading_enable = sample_shading_enable.into();
        self
    }
    pub fn min_sample_shading(
        mut self,
        min_sample_shading: f32,
    ) -> PipelineMultisampleStateCreateInfoBuilder<'a> {
        self.inner.min_sample_shading = min_sample_shading;
        self
    }
    pub fn sample_mask(
        mut self,
        sample_mask: &'a [SampleMask],
    ) -> PipelineMultisampleStateCreateInfoBuilder<'a> {
        self.inner.p_sample_mask = sample_mask.as_ptr() as *const SampleMask;
        self
    }
    pub fn alpha_to_coverage_enable(
        mut self,
        alpha_to_coverage_enable: bool,
    ) -> PipelineMultisampleStateCreateInfoBuilder<'a> {
        self.inner.alpha_to_coverage_enable = alpha_to_coverage_enable.into();
        self
    }
    pub fn alpha_to_one_enable(
        mut self,
        alpha_to_one_enable: bool,
    ) -> PipelineMultisampleStateCreateInfoBuilder<'a> {
        self.inner.alpha_to_one_enable = alpha_to_one_enable.into();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineMultisampleStateCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> PipelineMultisampleStateCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineMultisampleStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineColorBlendAttachmentState.html>"]
pub struct PipelineColorBlendAttachmentState {
    pub blend_enable: Bool32,
    pub src_color_blend_factor: BlendFactor,
    pub dst_color_blend_factor: BlendFactor,
    pub color_blend_op: BlendOp,
    pub src_alpha_blend_factor: BlendFactor,
    pub dst_alpha_blend_factor: BlendFactor,
    pub alpha_blend_op: BlendOp,
    pub color_write_mask: ColorComponentFlags,
}
impl PipelineColorBlendAttachmentState {
    pub fn builder<'a>() -> PipelineColorBlendAttachmentStateBuilder<'a> {
        PipelineColorBlendAttachmentStateBuilder {
            inner: PipelineColorBlendAttachmentState::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineColorBlendAttachmentStateBuilder<'a> {
    inner: PipelineColorBlendAttachmentState,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PipelineColorBlendAttachmentStateBuilder<'a> {
    type Target = PipelineColorBlendAttachmentState;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineColorBlendAttachmentStateBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineColorBlendAttachmentStateBuilder<'a> {
    pub fn blend_enable(
        mut self,
        blend_enable: bool,
    ) -> PipelineColorBlendAttachmentStateBuilder<'a> {
        self.inner.blend_enable = blend_enable.into();
        self
    }
    pub fn src_color_blend_factor(
        mut self,
        src_color_blend_factor: BlendFactor,
    ) -> PipelineColorBlendAttachmentStateBuilder<'a> {
        self.inner.src_color_blend_factor = src_color_blend_factor;
        self
    }
    pub fn dst_color_blend_factor(
        mut self,
        dst_color_blend_factor: BlendFactor,
    ) -> PipelineColorBlendAttachmentStateBuilder<'a> {
        self.inner.dst_color_blend_factor = dst_color_blend_factor;
        self
    }
    pub fn color_blend_op(
        mut self,
        color_blend_op: BlendOp,
    ) -> PipelineColorBlendAttachmentStateBuilder<'a> {
        self.inner.color_blend_op = color_blend_op;
        self
    }
    pub fn src_alpha_blend_factor(
        mut self,
        src_alpha_blend_factor: BlendFactor,
    ) -> PipelineColorBlendAttachmentStateBuilder<'a> {
        self.inner.src_alpha_blend_factor = src_alpha_blend_factor;
        self
    }
    pub fn dst_alpha_blend_factor(
        mut self,
        dst_alpha_blend_factor: BlendFactor,
    ) -> PipelineColorBlendAttachmentStateBuilder<'a> {
        self.inner.dst_alpha_blend_factor = dst_alpha_blend_factor;
        self
    }
    pub fn alpha_blend_op(
        mut self,
        alpha_blend_op: BlendOp,
    ) -> PipelineColorBlendAttachmentStateBuilder<'a> {
        self.inner.alpha_blend_op = alpha_blend_op;
        self
    }
    pub fn color_write_mask(
        mut self,
        color_write_mask: ColorComponentFlags,
    ) -> PipelineColorBlendAttachmentStateBuilder<'a> {
        self.inner.color_write_mask = color_write_mask;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineColorBlendAttachmentState {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineColorBlendStateCreateInfo.html>"]
pub struct PipelineColorBlendStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineColorBlendStateCreateFlags,
    pub logic_op_enable: Bool32,
    pub logic_op: LogicOp,
    pub attachment_count: u32,
    pub p_attachments: *const PipelineColorBlendAttachmentState,
    pub blend_constants: [f32; 4],
}
impl ::std::default::Default for PipelineColorBlendStateCreateInfo {
    fn default() -> PipelineColorBlendStateCreateInfo {
        PipelineColorBlendStateCreateInfo {
            s_type: StructureType::PIPELINE_COLOR_BLEND_STATE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: PipelineColorBlendStateCreateFlags::default(),
            logic_op_enable: Bool32::default(),
            logic_op: LogicOp::default(),
            attachment_count: u32::default(),
            p_attachments: ::std::ptr::null(),
            blend_constants: unsafe { ::std::mem::zeroed() },
        }
    }
}
impl PipelineColorBlendStateCreateInfo {
    pub fn builder<'a>() -> PipelineColorBlendStateCreateInfoBuilder<'a> {
        PipelineColorBlendStateCreateInfoBuilder {
            inner: PipelineColorBlendStateCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineColorBlendStateCreateInfoBuilder<'a> {
    inner: PipelineColorBlendStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineColorBlendStateCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineColorBlendStateCreateInfoBuilder<'a> {
    type Target = PipelineColorBlendStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineColorBlendStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineColorBlendStateCreateInfoBuilder<'a> {
    pub fn flags(
        mut self,
        flags: PipelineColorBlendStateCreateFlags,
    ) -> PipelineColorBlendStateCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn logic_op_enable(
        mut self,
        logic_op_enable: bool,
    ) -> PipelineColorBlendStateCreateInfoBuilder<'a> {
        self.inner.logic_op_enable = logic_op_enable.into();
        self
    }
    pub fn logic_op(mut self, logic_op: LogicOp) -> PipelineColorBlendStateCreateInfoBuilder<'a> {
        self.inner.logic_op = logic_op;
        self
    }
    pub fn attachments(
        mut self,
        attachments: &'a [PipelineColorBlendAttachmentState],
    ) -> PipelineColorBlendStateCreateInfoBuilder<'a> {
        self.inner.attachment_count = attachments.len() as _;
        self.inner.p_attachments = attachments.as_ptr();
        self
    }
    pub fn blend_constants(
        mut self,
        blend_constants: [f32; 4],
    ) -> PipelineColorBlendStateCreateInfoBuilder<'a> {
        self.inner.blend_constants = blend_constants;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineColorBlendStateCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> PipelineColorBlendStateCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineColorBlendStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineDynamicStateCreateInfo.html>"]
pub struct PipelineDynamicStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineDynamicStateCreateFlags,
    pub dynamic_state_count: u32,
    pub p_dynamic_states: *const DynamicState,
}
impl ::std::default::Default for PipelineDynamicStateCreateInfo {
    fn default() -> PipelineDynamicStateCreateInfo {
        PipelineDynamicStateCreateInfo {
            s_type: StructureType::PIPELINE_DYNAMIC_STATE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: PipelineDynamicStateCreateFlags::default(),
            dynamic_state_count: u32::default(),
            p_dynamic_states: ::std::ptr::null(),
        }
    }
}
impl PipelineDynamicStateCreateInfo {
    pub fn builder<'a>() -> PipelineDynamicStateCreateInfoBuilder<'a> {
        PipelineDynamicStateCreateInfoBuilder {
            inner: PipelineDynamicStateCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineDynamicStateCreateInfoBuilder<'a> {
    inner: PipelineDynamicStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineDynamicStateCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineDynamicStateCreateInfoBuilder<'a> {
    type Target = PipelineDynamicStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineDynamicStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineDynamicStateCreateInfoBuilder<'a> {
    pub fn flags(
        mut self,
        flags: PipelineDynamicStateCreateFlags,
    ) -> PipelineDynamicStateCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn dynamic_states(
        mut self,
        dynamic_states: &'a [DynamicState],
    ) -> PipelineDynamicStateCreateInfoBuilder<'a> {
        self.inner.dynamic_state_count = dynamic_states.len() as _;
        self.inner.p_dynamic_states = dynamic_states.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineDynamicStateCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> PipelineDynamicStateCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineDynamicStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkStencilOpState.html>"]
pub struct StencilOpState {
    pub fail_op: StencilOp,
    pub pass_op: StencilOp,
    pub depth_fail_op: StencilOp,
    pub compare_op: CompareOp,
    pub compare_mask: u32,
    pub write_mask: u32,
    pub reference: u32,
}
impl StencilOpState {
    pub fn builder<'a>() -> StencilOpStateBuilder<'a> {
        StencilOpStateBuilder {
            inner: StencilOpState::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct StencilOpStateBuilder<'a> {
    inner: StencilOpState,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for StencilOpStateBuilder<'a> {
    type Target = StencilOpState;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for StencilOpStateBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> StencilOpStateBuilder<'a> {
    pub fn fail_op(mut self, fail_op: StencilOp) -> StencilOpStateBuilder<'a> {
        self.inner.fail_op = fail_op;
        self
    }
    pub fn pass_op(mut self, pass_op: StencilOp) -> StencilOpStateBuilder<'a> {
        self.inner.pass_op = pass_op;
        self
    }
    pub fn depth_fail_op(mut self, depth_fail_op: StencilOp) -> StencilOpStateBuilder<'a> {
        self.inner.depth_fail_op = depth_fail_op;
        self
    }
    pub fn compare_op(mut self, compare_op: CompareOp) -> StencilOpStateBuilder<'a> {
        self.inner.compare_op = compare_op;
        self
    }
    pub fn compare_mask(mut self, compare_mask: u32) -> StencilOpStateBuilder<'a> {
        self.inner.compare_mask = compare_mask;
        self
    }
    pub fn write_mask(mut self, write_mask: u32) -> StencilOpStateBuilder<'a> {
        self.inner.write_mask = write_mask;
        self
    }
    pub fn reference(mut self, reference: u32) -> StencilOpStateBuilder<'a> {
        self.inner.reference = reference;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> StencilOpState {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineDepthStencilStateCreateInfo.html>"]
pub struct PipelineDepthStencilStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineDepthStencilStateCreateFlags,
    pub depth_test_enable: Bool32,
    pub depth_write_enable: Bool32,
    pub depth_compare_op: CompareOp,
    pub depth_bounds_test_enable: Bool32,
    pub stencil_test_enable: Bool32,
    pub front: StencilOpState,
    pub back: StencilOpState,
    pub min_depth_bounds: f32,
    pub max_depth_bounds: f32,
}
impl ::std::default::Default for PipelineDepthStencilStateCreateInfo {
    fn default() -> PipelineDepthStencilStateCreateInfo {
        PipelineDepthStencilStateCreateInfo {
            s_type: StructureType::PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: PipelineDepthStencilStateCreateFlags::default(),
            depth_test_enable: Bool32::default(),
            depth_write_enable: Bool32::default(),
            depth_compare_op: CompareOp::default(),
            depth_bounds_test_enable: Bool32::default(),
            stencil_test_enable: Bool32::default(),
            front: StencilOpState::default(),
            back: StencilOpState::default(),
            min_depth_bounds: f32::default(),
            max_depth_bounds: f32::default(),
        }
    }
}
impl PipelineDepthStencilStateCreateInfo {
    pub fn builder<'a>() -> PipelineDepthStencilStateCreateInfoBuilder<'a> {
        PipelineDepthStencilStateCreateInfoBuilder {
            inner: PipelineDepthStencilStateCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineDepthStencilStateCreateInfoBuilder<'a> {
    inner: PipelineDepthStencilStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineDepthStencilStateCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineDepthStencilStateCreateInfoBuilder<'a> {
    type Target = PipelineDepthStencilStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineDepthStencilStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineDepthStencilStateCreateInfoBuilder<'a> {
    pub fn flags(
        mut self,
        flags: PipelineDepthStencilStateCreateFlags,
    ) -> PipelineDepthStencilStateCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn depth_test_enable(
        mut self,
        depth_test_enable: bool,
    ) -> PipelineDepthStencilStateCreateInfoBuilder<'a> {
        self.inner.depth_test_enable = depth_test_enable.into();
        self
    }
    pub fn depth_write_enable(
        mut self,
        depth_write_enable: bool,
    ) -> PipelineDepthStencilStateCreateInfoBuilder<'a> {
        self.inner.depth_write_enable = depth_write_enable.into();
        self
    }
    pub fn depth_compare_op(
        mut self,
        depth_compare_op: CompareOp,
    ) -> PipelineDepthStencilStateCreateInfoBuilder<'a> {
        self.inner.depth_compare_op = depth_compare_op;
        self
    }
    pub fn depth_bounds_test_enable(
        mut self,
        depth_bounds_test_enable: bool,
    ) -> PipelineDepthStencilStateCreateInfoBuilder<'a> {
        self.inner.depth_bounds_test_enable = depth_bounds_test_enable.into();
        self
    }
    pub fn stencil_test_enable(
        mut self,
        stencil_test_enable: bool,
    ) -> PipelineDepthStencilStateCreateInfoBuilder<'a> {
        self.inner.stencil_test_enable = stencil_test_enable.into();
        self
    }
    pub fn front(
        mut self,
        front: StencilOpState,
    ) -> PipelineDepthStencilStateCreateInfoBuilder<'a> {
        self.inner.front = front;
        self
    }
    pub fn back(mut self, back: StencilOpState) -> PipelineDepthStencilStateCreateInfoBuilder<'a> {
        self.inner.back = back;
        self
    }
    pub fn min_depth_bounds(
        mut self,
        min_depth_bounds: f32,
    ) -> PipelineDepthStencilStateCreateInfoBuilder<'a> {
        self.inner.min_depth_bounds = min_depth_bounds;
        self
    }
    pub fn max_depth_bounds(
        mut self,
        max_depth_bounds: f32,
    ) -> PipelineDepthStencilStateCreateInfoBuilder<'a> {
        self.inner.max_depth_bounds = max_depth_bounds;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineDepthStencilStateCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> PipelineDepthStencilStateCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineDepthStencilStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGraphicsPipelineCreateInfo.html>"]
pub struct GraphicsPipelineCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineCreateFlags,
    pub stage_count: u32,
    pub p_stages: *const PipelineShaderStageCreateInfo,
    pub p_vertex_input_state: *const PipelineVertexInputStateCreateInfo,
    pub p_input_assembly_state: *const PipelineInputAssemblyStateCreateInfo,
    pub p_tessellation_state: *const PipelineTessellationStateCreateInfo,
    pub p_viewport_state: *const PipelineViewportStateCreateInfo,
    pub p_rasterization_state: *const PipelineRasterizationStateCreateInfo,
    pub p_multisample_state: *const PipelineMultisampleStateCreateInfo,
    pub p_depth_stencil_state: *const PipelineDepthStencilStateCreateInfo,
    pub p_color_blend_state: *const PipelineColorBlendStateCreateInfo,
    pub p_dynamic_state: *const PipelineDynamicStateCreateInfo,
    pub layout: PipelineLayout,
    pub render_pass: RenderPass,
    pub subpass: u32,
    pub base_pipeline_handle: Pipeline,
    pub base_pipeline_index: i32,
}
impl ::std::default::Default for GraphicsPipelineCreateInfo {
    fn default() -> GraphicsPipelineCreateInfo {
        GraphicsPipelineCreateInfo {
            s_type: StructureType::GRAPHICS_PIPELINE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: PipelineCreateFlags::default(),
            stage_count: u32::default(),
            p_stages: ::std::ptr::null(),
            p_vertex_input_state: ::std::ptr::null(),
            p_input_assembly_state: ::std::ptr::null(),
            p_tessellation_state: ::std::ptr::null(),
            p_viewport_state: ::std::ptr::null(),
            p_rasterization_state: ::std::ptr::null(),
            p_multisample_state: ::std::ptr::null(),
            p_depth_stencil_state: ::std::ptr::null(),
            p_color_blend_state: ::std::ptr::null(),
            p_dynamic_state: ::std::ptr::null(),
            layout: PipelineLayout::default(),
            render_pass: RenderPass::default(),
            subpass: u32::default(),
            base_pipeline_handle: Pipeline::default(),
            base_pipeline_index: i32::default(),
        }
    }
}
impl GraphicsPipelineCreateInfo {
    pub fn builder<'a>() -> GraphicsPipelineCreateInfoBuilder<'a> {
        GraphicsPipelineCreateInfoBuilder {
            inner: GraphicsPipelineCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct GraphicsPipelineCreateInfoBuilder<'a> {
    inner: GraphicsPipelineCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsGraphicsPipelineCreateInfo {}
impl<'a> ::std::ops::Deref for GraphicsPipelineCreateInfoBuilder<'a> {
    type Target = GraphicsPipelineCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for GraphicsPipelineCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> GraphicsPipelineCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: PipelineCreateFlags) -> GraphicsPipelineCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn stages(
        mut self,
        stages: &'a [PipelineShaderStageCreateInfo],
    ) -> GraphicsPipelineCreateInfoBuilder<'a> {
        self.inner.stage_count = stages.len() as _;
        self.inner.p_stages = stages.as_ptr();
        self
    }
    pub fn vertex_input_state(
        mut self,
        vertex_input_state: &'a PipelineVertexInputStateCreateInfo,
    ) -> GraphicsPipelineCreateInfoBuilder<'a> {
        self.inner.p_vertex_input_state = vertex_input_state;
        self
    }
    pub fn input_assembly_state(
        mut self,
        input_assembly_state: &'a PipelineInputAssemblyStateCreateInfo,
    ) -> GraphicsPipelineCreateInfoBuilder<'a> {
        self.inner.p_input_assembly_state = input_assembly_state;
        self
    }
    pub fn tessellation_state(
        mut self,
        tessellation_state: &'a PipelineTessellationStateCreateInfo,
    ) -> GraphicsPipelineCreateInfoBuilder<'a> {
        self.inner.p_tessellation_state = tessellation_state;
        self
    }
    pub fn viewport_state(
        mut self,
        viewport_state: &'a PipelineViewportStateCreateInfo,
    ) -> GraphicsPipelineCreateInfoBuilder<'a> {
        self.inner.p_viewport_state = viewport_state;
        self
    }
    pub fn rasterization_state(
        mut self,
        rasterization_state: &'a PipelineRasterizationStateCreateInfo,
    ) -> GraphicsPipelineCreateInfoBuilder<'a> {
        self.inner.p_rasterization_state = rasterization_state;
        self
    }
    pub fn multisample_state(
        mut self,
        multisample_state: &'a PipelineMultisampleStateCreateInfo,
    ) -> GraphicsPipelineCreateInfoBuilder<'a> {
        self.inner.p_multisample_state = multisample_state;
        self
    }
    pub fn depth_stencil_state(
        mut self,
        depth_stencil_state: &'a PipelineDepthStencilStateCreateInfo,
    ) -> GraphicsPipelineCreateInfoBuilder<'a> {
        self.inner.p_depth_stencil_state = depth_stencil_state;
        self
    }
    pub fn color_blend_state(
        mut self,
        color_blend_state: &'a PipelineColorBlendStateCreateInfo,
    ) -> GraphicsPipelineCreateInfoBuilder<'a> {
        self.inner.p_color_blend_state = color_blend_state;
        self
    }
    pub fn dynamic_state(
        mut self,
        dynamic_state: &'a PipelineDynamicStateCreateInfo,
    ) -> GraphicsPipelineCreateInfoBuilder<'a> {
        self.inner.p_dynamic_state = dynamic_state;
        self
    }
    pub fn layout(mut self, layout: PipelineLayout) -> GraphicsPipelineCreateInfoBuilder<'a> {
        self.inner.layout = layout;
        self
    }
    pub fn render_pass(mut self, render_pass: RenderPass) -> GraphicsPipelineCreateInfoBuilder<'a> {
        self.inner.render_pass = render_pass;
        self
    }
    pub fn subpass(mut self, subpass: u32) -> GraphicsPipelineCreateInfoBuilder<'a> {
        self.inner.subpass = subpass;
        self
    }
    pub fn base_pipeline_handle(
        mut self,
        base_pipeline_handle: Pipeline,
    ) -> GraphicsPipelineCreateInfoBuilder<'a> {
        self.inner.base_pipeline_handle = base_pipeline_handle;
        self
    }
    pub fn base_pipeline_index(
        mut self,
        base_pipeline_index: i32,
    ) -> GraphicsPipelineCreateInfoBuilder<'a> {
        self.inner.base_pipeline_index = base_pipeline_index;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsGraphicsPipelineCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> GraphicsPipelineCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> GraphicsPipelineCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineCacheCreateInfo.html>"]
pub struct PipelineCacheCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineCacheCreateFlags,
    pub initial_data_size: usize,
    pub p_initial_data: *const c_void,
}
impl ::std::default::Default for PipelineCacheCreateInfo {
    fn default() -> PipelineCacheCreateInfo {
        PipelineCacheCreateInfo {
            s_type: StructureType::PIPELINE_CACHE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: PipelineCacheCreateFlags::default(),
            initial_data_size: usize::default(),
            p_initial_data: ::std::ptr::null(),
        }
    }
}
impl PipelineCacheCreateInfo {
    pub fn builder<'a>() -> PipelineCacheCreateInfoBuilder<'a> {
        PipelineCacheCreateInfoBuilder {
            inner: PipelineCacheCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineCacheCreateInfoBuilder<'a> {
    inner: PipelineCacheCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineCacheCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineCacheCreateInfoBuilder<'a> {
    type Target = PipelineCacheCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineCacheCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineCacheCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: PipelineCacheCreateFlags) -> PipelineCacheCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn initial_data(mut self, initial_data: &'a [u8]) -> PipelineCacheCreateInfoBuilder<'a> {
        self.inner.initial_data_size = initial_data.len() as _;
        self.inner.p_initial_data = initial_data.as_ptr() as *const c_void;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineCacheCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> PipelineCacheCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineCacheCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPushConstantRange.html>"]
pub struct PushConstantRange {
    pub stage_flags: ShaderStageFlags,
    pub offset: u32,
    pub size: u32,
}
impl PushConstantRange {
    pub fn builder<'a>() -> PushConstantRangeBuilder<'a> {
        PushConstantRangeBuilder {
            inner: PushConstantRange::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PushConstantRangeBuilder<'a> {
    inner: PushConstantRange,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PushConstantRangeBuilder<'a> {
    type Target = PushConstantRange;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PushConstantRangeBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PushConstantRangeBuilder<'a> {
    pub fn stage_flags(mut self, stage_flags: ShaderStageFlags) -> PushConstantRangeBuilder<'a> {
        self.inner.stage_flags = stage_flags;
        self
    }
    pub fn offset(mut self, offset: u32) -> PushConstantRangeBuilder<'a> {
        self.inner.offset = offset;
        self
    }
    pub fn size(mut self, size: u32) -> PushConstantRangeBuilder<'a> {
        self.inner.size = size;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PushConstantRange {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineLayoutCreateInfo.html>"]
pub struct PipelineLayoutCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineLayoutCreateFlags,
    pub set_layout_count: u32,
    pub p_set_layouts: *const DescriptorSetLayout,
    pub push_constant_range_count: u32,
    pub p_push_constant_ranges: *const PushConstantRange,
}
impl ::std::default::Default for PipelineLayoutCreateInfo {
    fn default() -> PipelineLayoutCreateInfo {
        PipelineLayoutCreateInfo {
            s_type: StructureType::PIPELINE_LAYOUT_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: PipelineLayoutCreateFlags::default(),
            set_layout_count: u32::default(),
            p_set_layouts: ::std::ptr::null(),
            push_constant_range_count: u32::default(),
            p_push_constant_ranges: ::std::ptr::null(),
        }
    }
}
impl PipelineLayoutCreateInfo {
    pub fn builder<'a>() -> PipelineLayoutCreateInfoBuilder<'a> {
        PipelineLayoutCreateInfoBuilder {
            inner: PipelineLayoutCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineLayoutCreateInfoBuilder<'a> {
    inner: PipelineLayoutCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineLayoutCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineLayoutCreateInfoBuilder<'a> {
    type Target = PipelineLayoutCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineLayoutCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineLayoutCreateInfoBuilder<'a> {
    pub fn flags(
        mut self,
        flags: PipelineLayoutCreateFlags,
    ) -> PipelineLayoutCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn set_layouts(
        mut self,
        set_layouts: &'a [DescriptorSetLayout],
    ) -> PipelineLayoutCreateInfoBuilder<'a> {
        self.inner.set_layout_count = set_layouts.len() as _;
        self.inner.p_set_layouts = set_layouts.as_ptr();
        self
    }
    pub fn push_constant_ranges(
        mut self,
        push_constant_ranges: &'a [PushConstantRange],
    ) -> PipelineLayoutCreateInfoBuilder<'a> {
        self.inner.push_constant_range_count = push_constant_ranges.len() as _;
        self.inner.p_push_constant_ranges = push_constant_ranges.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineLayoutCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> PipelineLayoutCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineLayoutCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSamplerCreateInfo.html>"]
pub struct SamplerCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: SamplerCreateFlags,
    pub mag_filter: Filter,
    pub min_filter: Filter,
    pub mipmap_mode: SamplerMipmapMode,
    pub address_mode_u: SamplerAddressMode,
    pub address_mode_v: SamplerAddressMode,
    pub address_mode_w: SamplerAddressMode,
    pub mip_lod_bias: f32,
    pub anisotropy_enable: Bool32,
    pub max_anisotropy: f32,
    pub compare_enable: Bool32,
    pub compare_op: CompareOp,
    pub min_lod: f32,
    pub max_lod: f32,
    pub border_color: BorderColor,
    pub unnormalized_coordinates: Bool32,
}
impl ::std::default::Default for SamplerCreateInfo {
    fn default() -> SamplerCreateInfo {
        SamplerCreateInfo {
            s_type: StructureType::SAMPLER_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: SamplerCreateFlags::default(),
            mag_filter: Filter::default(),
            min_filter: Filter::default(),
            mipmap_mode: SamplerMipmapMode::default(),
            address_mode_u: SamplerAddressMode::default(),
            address_mode_v: SamplerAddressMode::default(),
            address_mode_w: SamplerAddressMode::default(),
            mip_lod_bias: f32::default(),
            anisotropy_enable: Bool32::default(),
            max_anisotropy: f32::default(),
            compare_enable: Bool32::default(),
            compare_op: CompareOp::default(),
            min_lod: f32::default(),
            max_lod: f32::default(),
            border_color: BorderColor::default(),
            unnormalized_coordinates: Bool32::default(),
        }
    }
}
impl SamplerCreateInfo {
    pub fn builder<'a>() -> SamplerCreateInfoBuilder<'a> {
        SamplerCreateInfoBuilder {
            inner: SamplerCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SamplerCreateInfoBuilder<'a> {
    inner: SamplerCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsSamplerCreateInfo {}
impl<'a> ::std::ops::Deref for SamplerCreateInfoBuilder<'a> {
    type Target = SamplerCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SamplerCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SamplerCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: SamplerCreateFlags) -> SamplerCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn mag_filter(mut self, mag_filter: Filter) -> SamplerCreateInfoBuilder<'a> {
        self.inner.mag_filter = mag_filter;
        self
    }
    pub fn min_filter(mut self, min_filter: Filter) -> SamplerCreateInfoBuilder<'a> {
        self.inner.min_filter = min_filter;
        self
    }
    pub fn mipmap_mode(mut self, mipmap_mode: SamplerMipmapMode) -> SamplerCreateInfoBuilder<'a> {
        self.inner.mipmap_mode = mipmap_mode;
        self
    }
    pub fn address_mode_u(
        mut self,
        address_mode_u: SamplerAddressMode,
    ) -> SamplerCreateInfoBuilder<'a> {
        self.inner.address_mode_u = address_mode_u;
        self
    }
    pub fn address_mode_v(
        mut self,
        address_mode_v: SamplerAddressMode,
    ) -> SamplerCreateInfoBuilder<'a> {
        self.inner.address_mode_v = address_mode_v;
        self
    }
    pub fn address_mode_w(
        mut self,
        address_mode_w: SamplerAddressMode,
    ) -> SamplerCreateInfoBuilder<'a> {
        self.inner.address_mode_w = address_mode_w;
        self
    }
    pub fn mip_lod_bias(mut self, mip_lod_bias: f32) -> SamplerCreateInfoBuilder<'a> {
        self.inner.mip_lod_bias = mip_lod_bias;
        self
    }
    pub fn anisotropy_enable(mut self, anisotropy_enable: bool) -> SamplerCreateInfoBuilder<'a> {
        self.inner.anisotropy_enable = anisotropy_enable.into();
        self
    }
    pub fn max_anisotropy(mut self, max_anisotropy: f32) -> SamplerCreateInfoBuilder<'a> {
        self.inner.max_anisotropy = max_anisotropy;
        self
    }
    pub fn compare_enable(mut self, compare_enable: bool) -> SamplerCreateInfoBuilder<'a> {
        self.inner.compare_enable = compare_enable.into();
        self
    }
    pub fn compare_op(mut self, compare_op: CompareOp) -> SamplerCreateInfoBuilder<'a> {
        self.inner.compare_op = compare_op;
        self
    }
    pub fn min_lod(mut self, min_lod: f32) -> SamplerCreateInfoBuilder<'a> {
        self.inner.min_lod = min_lod;
        self
    }
    pub fn max_lod(mut self, max_lod: f32) -> SamplerCreateInfoBuilder<'a> {
        self.inner.max_lod = max_lod;
        self
    }
    pub fn border_color(mut self, border_color: BorderColor) -> SamplerCreateInfoBuilder<'a> {
        self.inner.border_color = border_color;
        self
    }
    pub fn unnormalized_coordinates(
        mut self,
        unnormalized_coordinates: bool,
    ) -> SamplerCreateInfoBuilder<'a> {
        self.inner.unnormalized_coordinates = unnormalized_coordinates.into();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSamplerCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> SamplerCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SamplerCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandPoolCreateInfo.html>"]
pub struct CommandPoolCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: CommandPoolCreateFlags,
    pub queue_family_index: u32,
}
impl ::std::default::Default for CommandPoolCreateInfo {
    fn default() -> CommandPoolCreateInfo {
        CommandPoolCreateInfo {
            s_type: StructureType::COMMAND_POOL_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: CommandPoolCreateFlags::default(),
            queue_family_index: u32::default(),
        }
    }
}
impl CommandPoolCreateInfo {
    pub fn builder<'a>() -> CommandPoolCreateInfoBuilder<'a> {
        CommandPoolCreateInfoBuilder {
            inner: CommandPoolCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct CommandPoolCreateInfoBuilder<'a> {
    inner: CommandPoolCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsCommandPoolCreateInfo {}
impl<'a> ::std::ops::Deref for CommandPoolCreateInfoBuilder<'a> {
    type Target = CommandPoolCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for CommandPoolCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> CommandPoolCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: CommandPoolCreateFlags) -> CommandPoolCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn queue_family_index(
        mut self,
        queue_family_index: u32,
    ) -> CommandPoolCreateInfoBuilder<'a> {
        self.inner.queue_family_index = queue_family_index;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsCommandPoolCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> CommandPoolCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> CommandPoolCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandBufferAllocateInfo.html>"]
pub struct CommandBufferAllocateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub command_pool: CommandPool,
    pub level: CommandBufferLevel,
    pub command_buffer_count: u32,
}
impl ::std::default::Default for CommandBufferAllocateInfo {
    fn default() -> CommandBufferAllocateInfo {
        CommandBufferAllocateInfo {
            s_type: StructureType::COMMAND_BUFFER_ALLOCATE_INFO,
            p_next: ::std::ptr::null(),
            command_pool: CommandPool::default(),
            level: CommandBufferLevel::default(),
            command_buffer_count: u32::default(),
        }
    }
}
impl CommandBufferAllocateInfo {
    pub fn builder<'a>() -> CommandBufferAllocateInfoBuilder<'a> {
        CommandBufferAllocateInfoBuilder {
            inner: CommandBufferAllocateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct CommandBufferAllocateInfoBuilder<'a> {
    inner: CommandBufferAllocateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsCommandBufferAllocateInfo {}
impl<'a> ::std::ops::Deref for CommandBufferAllocateInfoBuilder<'a> {
    type Target = CommandBufferAllocateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for CommandBufferAllocateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> CommandBufferAllocateInfoBuilder<'a> {
    pub fn command_pool(
        mut self,
        command_pool: CommandPool,
    ) -> CommandBufferAllocateInfoBuilder<'a> {
        self.inner.command_pool = command_pool;
        self
    }
    pub fn level(mut self, level: CommandBufferLevel) -> CommandBufferAllocateInfoBuilder<'a> {
        self.inner.level = level;
        self
    }
    pub fn command_buffer_count(
        mut self,
        command_buffer_count: u32,
    ) -> CommandBufferAllocateInfoBuilder<'a> {
        self.inner.command_buffer_count = command_buffer_count;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsCommandBufferAllocateInfo>(
        mut self,
        next: &'a mut T,
    ) -> CommandBufferAllocateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> CommandBufferAllocateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandBufferInheritanceInfo.html>"]
pub struct CommandBufferInheritanceInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub render_pass: RenderPass,
    pub subpass: u32,
    pub framebuffer: Framebuffer,
    pub occlusion_query_enable: Bool32,
    pub query_flags: QueryControlFlags,
    pub pipeline_statistics: QueryPipelineStatisticFlags,
}
impl ::std::default::Default for CommandBufferInheritanceInfo {
    fn default() -> CommandBufferInheritanceInfo {
        CommandBufferInheritanceInfo {
            s_type: StructureType::COMMAND_BUFFER_INHERITANCE_INFO,
            p_next: ::std::ptr::null(),
            render_pass: RenderPass::default(),
            subpass: u32::default(),
            framebuffer: Framebuffer::default(),
            occlusion_query_enable: Bool32::default(),
            query_flags: QueryControlFlags::default(),
            pipeline_statistics: QueryPipelineStatisticFlags::default(),
        }
    }
}
impl CommandBufferInheritanceInfo {
    pub fn builder<'a>() -> CommandBufferInheritanceInfoBuilder<'a> {
        CommandBufferInheritanceInfoBuilder {
            inner: CommandBufferInheritanceInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct CommandBufferInheritanceInfoBuilder<'a> {
    inner: CommandBufferInheritanceInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsCommandBufferInheritanceInfo {}
impl<'a> ::std::ops::Deref for CommandBufferInheritanceInfoBuilder<'a> {
    type Target = CommandBufferInheritanceInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for CommandBufferInheritanceInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> CommandBufferInheritanceInfoBuilder<'a> {
    pub fn render_pass(
        mut self,
        render_pass: RenderPass,
    ) -> CommandBufferInheritanceInfoBuilder<'a> {
        self.inner.render_pass = render_pass;
        self
    }
    pub fn subpass(mut self, subpass: u32) -> CommandBufferInheritanceInfoBuilder<'a> {
        self.inner.subpass = subpass;
        self
    }
    pub fn framebuffer(
        mut self,
        framebuffer: Framebuffer,
    ) -> CommandBufferInheritanceInfoBuilder<'a> {
        self.inner.framebuffer = framebuffer;
        self
    }
    pub fn occlusion_query_enable(
        mut self,
        occlusion_query_enable: bool,
    ) -> CommandBufferInheritanceInfoBuilder<'a> {
        self.inner.occlusion_query_enable = occlusion_query_enable.into();
        self
    }
    pub fn query_flags(
        mut self,
        query_flags: QueryControlFlags,
    ) -> CommandBufferInheritanceInfoBuilder<'a> {
        self.inner.query_flags = query_flags;
        self
    }
    pub fn pipeline_statistics(
        mut self,
        pipeline_statistics: QueryPipelineStatisticFlags,
    ) -> CommandBufferInheritanceInfoBuilder<'a> {
        self.inner.pipeline_statistics = pipeline_statistics;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsCommandBufferInheritanceInfo>(
        mut self,
        next: &'a mut T,
    ) -> CommandBufferInheritanceInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> CommandBufferInheritanceInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkCommandBufferBeginInfo.html>"]
pub struct CommandBufferBeginInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: CommandBufferUsageFlags,
    pub p_inheritance_info: *const CommandBufferInheritanceInfo,
}
impl ::std::default::Default for CommandBufferBeginInfo {
    fn default() -> CommandBufferBeginInfo {
        CommandBufferBeginInfo {
            s_type: StructureType::COMMAND_BUFFER_BEGIN_INFO,
            p_next: ::std::ptr::null(),
            flags: CommandBufferUsageFlags::default(),
            p_inheritance_info: ::std::ptr::null(),
        }
    }
}
impl CommandBufferBeginInfo {
    pub fn builder<'a>() -> CommandBufferBeginInfoBuilder<'a> {
        CommandBufferBeginInfoBuilder {
            inner: CommandBufferBeginInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct CommandBufferBeginInfoBuilder<'a> {
    inner: CommandBufferBeginInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsCommandBufferBeginInfo {}
impl<'a> ::std::ops::Deref for CommandBufferBeginInfoBuilder<'a> {
    type Target = CommandBufferBeginInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for CommandBufferBeginInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> CommandBufferBeginInfoBuilder<'a> {
    pub fn flags(mut self, flags: CommandBufferUsageFlags) -> CommandBufferBeginInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn inheritance_info(
        mut self,
        inheritance_info: &'a CommandBufferInheritanceInfo,
    ) -> CommandBufferBeginInfoBuilder<'a> {
        self.inner.p_inheritance_info = inheritance_info;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsCommandBufferBeginInfo>(
        mut self,
        next: &'a mut T,
    ) -> CommandBufferBeginInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> CommandBufferBeginInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRenderPassBeginInfo.html>"]
pub struct RenderPassBeginInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub render_pass: RenderPass,
    pub framebuffer: Framebuffer,
    pub render_area: Rect2D,
    pub clear_value_count: u32,
    pub p_clear_values: *const ClearValue,
}
impl fmt::Debug for RenderPassBeginInfo {
    fn fmt(&self, fmt: &mut fmt::Formatter) -> fmt::Result {
        fmt.debug_struct("RenderPassBeginInfo")
            .field("s_type", &self.s_type)
            .field("p_next", &self.p_next)
            .field("render_pass", &self.render_pass)
            .field("framebuffer", &self.framebuffer)
            .field("render_area", &self.render_area)
            .field("clear_value_count", &self.clear_value_count)
            .field("p_clear_values", &"union")
            .finish()
    }
}
impl ::std::default::Default for RenderPassBeginInfo {
    fn default() -> RenderPassBeginInfo {
        RenderPassBeginInfo {
            s_type: StructureType::RENDER_PASS_BEGIN_INFO,
            p_next: ::std::ptr::null(),
            render_pass: RenderPass::default(),
            framebuffer: Framebuffer::default(),
            render_area: Rect2D::default(),
            clear_value_count: u32::default(),
            p_clear_values: ::std::ptr::null(),
        }
    }
}
impl RenderPassBeginInfo {
    pub fn builder<'a>() -> RenderPassBeginInfoBuilder<'a> {
        RenderPassBeginInfoBuilder {
            inner: RenderPassBeginInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct RenderPassBeginInfoBuilder<'a> {
    inner: RenderPassBeginInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsRenderPassBeginInfo {}
impl<'a> ::std::ops::Deref for RenderPassBeginInfoBuilder<'a> {
    type Target = RenderPassBeginInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for RenderPassBeginInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> RenderPassBeginInfoBuilder<'a> {
    pub fn render_pass(mut self, render_pass: RenderPass) -> RenderPassBeginInfoBuilder<'a> {
        self.inner.render_pass = render_pass;
        self
    }
    pub fn framebuffer(mut self, framebuffer: Framebuffer) -> RenderPassBeginInfoBuilder<'a> {
        self.inner.framebuffer = framebuffer;
        self
    }
    pub fn render_area(mut self, render_area: Rect2D) -> RenderPassBeginInfoBuilder<'a> {
        self.inner.render_area = render_area;
        self
    }
    pub fn clear_values(
        mut self,
        clear_values: &'a [ClearValue],
    ) -> RenderPassBeginInfoBuilder<'a> {
        self.inner.clear_value_count = clear_values.len() as _;
        self.inner.p_clear_values = clear_values.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsRenderPassBeginInfo>(
        mut self,
        next: &'a mut T,
    ) -> RenderPassBeginInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> RenderPassBeginInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkClearColorValue.html>"]
pub union ClearColorValue {
    pub float32: [f32; 4],
    pub int32: [i32; 4],
    pub uint32: [u32; 4],
}
impl ::std::default::Default for ClearColorValue {
    fn default() -> ClearColorValue {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkClearDepthStencilValue.html>"]
pub struct ClearDepthStencilValue {
    pub depth: f32,
    pub stencil: u32,
}
impl ClearDepthStencilValue {
    pub fn builder<'a>() -> ClearDepthStencilValueBuilder<'a> {
        ClearDepthStencilValueBuilder {
            inner: ClearDepthStencilValue::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ClearDepthStencilValueBuilder<'a> {
    inner: ClearDepthStencilValue,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ClearDepthStencilValueBuilder<'a> {
    type Target = ClearDepthStencilValue;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ClearDepthStencilValueBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ClearDepthStencilValueBuilder<'a> {
    pub fn depth(mut self, depth: f32) -> ClearDepthStencilValueBuilder<'a> {
        self.inner.depth = depth;
        self
    }
    pub fn stencil(mut self, stencil: u32) -> ClearDepthStencilValueBuilder<'a> {
        self.inner.stencil = stencil;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ClearDepthStencilValue {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkClearValue.html>"]
pub union ClearValue {
    pub color: ClearColorValue,
    pub depth_stencil: ClearDepthStencilValue,
}
impl ::std::default::Default for ClearValue {
    fn default() -> ClearValue {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkClearAttachment.html>"]
pub struct ClearAttachment {
    pub aspect_mask: ImageAspectFlags,
    pub color_attachment: u32,
    pub clear_value: ClearValue,
}
impl fmt::Debug for ClearAttachment {
    fn fmt(&self, fmt: &mut fmt::Formatter) -> fmt::Result {
        fmt.debug_struct("ClearAttachment")
            .field("aspect_mask", &self.aspect_mask)
            .field("color_attachment", &self.color_attachment)
            .field("clear_value", &"union")
            .finish()
    }
}
impl ClearAttachment {
    pub fn builder<'a>() -> ClearAttachmentBuilder<'a> {
        ClearAttachmentBuilder {
            inner: ClearAttachment::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ClearAttachmentBuilder<'a> {
    inner: ClearAttachment,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ClearAttachmentBuilder<'a> {
    type Target = ClearAttachment;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ClearAttachmentBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ClearAttachmentBuilder<'a> {
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> ClearAttachmentBuilder<'a> {
        self.inner.aspect_mask = aspect_mask;
        self
    }
    pub fn color_attachment(mut self, color_attachment: u32) -> ClearAttachmentBuilder<'a> {
        self.inner.color_attachment = color_attachment;
        self
    }
    pub fn clear_value(mut self, clear_value: ClearValue) -> ClearAttachmentBuilder<'a> {
        self.inner.clear_value = clear_value;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ClearAttachment {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAttachmentDescription.html>"]
pub struct AttachmentDescription {
    pub flags: AttachmentDescriptionFlags,
    pub format: Format,
    pub samples: SampleCountFlags,
    pub load_op: AttachmentLoadOp,
    pub store_op: AttachmentStoreOp,
    pub stencil_load_op: AttachmentLoadOp,
    pub stencil_store_op: AttachmentStoreOp,
    pub initial_layout: ImageLayout,
    pub final_layout: ImageLayout,
}
impl AttachmentDescription {
    pub fn builder<'a>() -> AttachmentDescriptionBuilder<'a> {
        AttachmentDescriptionBuilder {
            inner: AttachmentDescription::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct AttachmentDescriptionBuilder<'a> {
    inner: AttachmentDescription,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for AttachmentDescriptionBuilder<'a> {
    type Target = AttachmentDescription;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for AttachmentDescriptionBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> AttachmentDescriptionBuilder<'a> {
    pub fn flags(mut self, flags: AttachmentDescriptionFlags) -> AttachmentDescriptionBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn format(mut self, format: Format) -> AttachmentDescriptionBuilder<'a> {
        self.inner.format = format;
        self
    }
    pub fn samples(mut self, samples: SampleCountFlags) -> AttachmentDescriptionBuilder<'a> {
        self.inner.samples = samples;
        self
    }
    pub fn load_op(mut self, load_op: AttachmentLoadOp) -> AttachmentDescriptionBuilder<'a> {
        self.inner.load_op = load_op;
        self
    }
    pub fn store_op(mut self, store_op: AttachmentStoreOp) -> AttachmentDescriptionBuilder<'a> {
        self.inner.store_op = store_op;
        self
    }
    pub fn stencil_load_op(
        mut self,
        stencil_load_op: AttachmentLoadOp,
    ) -> AttachmentDescriptionBuilder<'a> {
        self.inner.stencil_load_op = stencil_load_op;
        self
    }
    pub fn stencil_store_op(
        mut self,
        stencil_store_op: AttachmentStoreOp,
    ) -> AttachmentDescriptionBuilder<'a> {
        self.inner.stencil_store_op = stencil_store_op;
        self
    }
    pub fn initial_layout(
        mut self,
        initial_layout: ImageLayout,
    ) -> AttachmentDescriptionBuilder<'a> {
        self.inner.initial_layout = initial_layout;
        self
    }
    pub fn final_layout(mut self, final_layout: ImageLayout) -> AttachmentDescriptionBuilder<'a> {
        self.inner.final_layout = final_layout;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> AttachmentDescription {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAttachmentReference.html>"]
pub struct AttachmentReference {
    pub attachment: u32,
    pub layout: ImageLayout,
}
impl AttachmentReference {
    pub fn builder<'a>() -> AttachmentReferenceBuilder<'a> {
        AttachmentReferenceBuilder {
            inner: AttachmentReference::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct AttachmentReferenceBuilder<'a> {
    inner: AttachmentReference,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for AttachmentReferenceBuilder<'a> {
    type Target = AttachmentReference;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for AttachmentReferenceBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> AttachmentReferenceBuilder<'a> {
    pub fn attachment(mut self, attachment: u32) -> AttachmentReferenceBuilder<'a> {
        self.inner.attachment = attachment;
        self
    }
    pub fn layout(mut self, layout: ImageLayout) -> AttachmentReferenceBuilder<'a> {
        self.inner.layout = layout;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> AttachmentReference {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubpassDescription.html>"]
pub struct SubpassDescription {
    pub flags: SubpassDescriptionFlags,
    pub pipeline_bind_point: PipelineBindPoint,
    pub input_attachment_count: u32,
    pub p_input_attachments: *const AttachmentReference,
    pub color_attachment_count: u32,
    pub p_color_attachments: *const AttachmentReference,
    pub p_resolve_attachments: *const AttachmentReference,
    pub p_depth_stencil_attachment: *const AttachmentReference,
    pub preserve_attachment_count: u32,
    pub p_preserve_attachments: *const u32,
}
impl ::std::default::Default for SubpassDescription {
    fn default() -> SubpassDescription {
        SubpassDescription {
            flags: SubpassDescriptionFlags::default(),
            pipeline_bind_point: PipelineBindPoint::default(),
            input_attachment_count: u32::default(),
            p_input_attachments: ::std::ptr::null(),
            color_attachment_count: u32::default(),
            p_color_attachments: ::std::ptr::null(),
            p_resolve_attachments: ::std::ptr::null(),
            p_depth_stencil_attachment: ::std::ptr::null(),
            preserve_attachment_count: u32::default(),
            p_preserve_attachments: ::std::ptr::null(),
        }
    }
}
impl SubpassDescription {
    pub fn builder<'a>() -> SubpassDescriptionBuilder<'a> {
        SubpassDescriptionBuilder {
            inner: SubpassDescription::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SubpassDescriptionBuilder<'a> {
    inner: SubpassDescription,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SubpassDescriptionBuilder<'a> {
    type Target = SubpassDescription;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SubpassDescriptionBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SubpassDescriptionBuilder<'a> {
    pub fn flags(mut self, flags: SubpassDescriptionFlags) -> SubpassDescriptionBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn pipeline_bind_point(
        mut self,
        pipeline_bind_point: PipelineBindPoint,
    ) -> SubpassDescriptionBuilder<'a> {
        self.inner.pipeline_bind_point = pipeline_bind_point;
        self
    }
    pub fn input_attachments(
        mut self,
        input_attachments: &'a [AttachmentReference],
    ) -> SubpassDescriptionBuilder<'a> {
        self.inner.input_attachment_count = input_attachments.len() as _;
        self.inner.p_input_attachments = input_attachments.as_ptr();
        self
    }
    pub fn color_attachments(
        mut self,
        color_attachments: &'a [AttachmentReference],
    ) -> SubpassDescriptionBuilder<'a> {
        self.inner.color_attachment_count = color_attachments.len() as _;
        self.inner.p_color_attachments = color_attachments.as_ptr();
        self
    }
    pub fn resolve_attachments(
        mut self,
        resolve_attachments: &'a [AttachmentReference],
    ) -> SubpassDescriptionBuilder<'a> {
        self.inner.color_attachment_count = resolve_attachments.len() as _;
        self.inner.p_resolve_attachments = resolve_attachments.as_ptr();
        self
    }
    pub fn depth_stencil_attachment(
        mut self,
        depth_stencil_attachment: &'a AttachmentReference,
    ) -> SubpassDescriptionBuilder<'a> {
        self.inner.p_depth_stencil_attachment = depth_stencil_attachment;
        self
    }
    pub fn preserve_attachments(
        mut self,
        preserve_attachments: &'a [u32],
    ) -> SubpassDescriptionBuilder<'a> {
        self.inner.preserve_attachment_count = preserve_attachments.len() as _;
        self.inner.p_preserve_attachments = preserve_attachments.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SubpassDescription {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubpassDependency.html>"]
pub struct SubpassDependency {
    pub src_subpass: u32,
    pub dst_subpass: u32,
    pub src_stage_mask: PipelineStageFlags,
    pub dst_stage_mask: PipelineStageFlags,
    pub src_access_mask: AccessFlags,
    pub dst_access_mask: AccessFlags,
    pub dependency_flags: DependencyFlags,
}
impl SubpassDependency {
    pub fn builder<'a>() -> SubpassDependencyBuilder<'a> {
        SubpassDependencyBuilder {
            inner: SubpassDependency::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SubpassDependencyBuilder<'a> {
    inner: SubpassDependency,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SubpassDependencyBuilder<'a> {
    type Target = SubpassDependency;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SubpassDependencyBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SubpassDependencyBuilder<'a> {
    pub fn src_subpass(mut self, src_subpass: u32) -> SubpassDependencyBuilder<'a> {
        self.inner.src_subpass = src_subpass;
        self
    }
    pub fn dst_subpass(mut self, dst_subpass: u32) -> SubpassDependencyBuilder<'a> {
        self.inner.dst_subpass = dst_subpass;
        self
    }
    pub fn src_stage_mask(
        mut self,
        src_stage_mask: PipelineStageFlags,
    ) -> SubpassDependencyBuilder<'a> {
        self.inner.src_stage_mask = src_stage_mask;
        self
    }
    pub fn dst_stage_mask(
        mut self,
        dst_stage_mask: PipelineStageFlags,
    ) -> SubpassDependencyBuilder<'a> {
        self.inner.dst_stage_mask = dst_stage_mask;
        self
    }
    pub fn src_access_mask(mut self, src_access_mask: AccessFlags) -> SubpassDependencyBuilder<'a> {
        self.inner.src_access_mask = src_access_mask;
        self
    }
    pub fn dst_access_mask(mut self, dst_access_mask: AccessFlags) -> SubpassDependencyBuilder<'a> {
        self.inner.dst_access_mask = dst_access_mask;
        self
    }
    pub fn dependency_flags(
        mut self,
        dependency_flags: DependencyFlags,
    ) -> SubpassDependencyBuilder<'a> {
        self.inner.dependency_flags = dependency_flags;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SubpassDependency {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRenderPassCreateInfo.html>"]
pub struct RenderPassCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: RenderPassCreateFlags,
    pub attachment_count: u32,
    pub p_attachments: *const AttachmentDescription,
    pub subpass_count: u32,
    pub p_subpasses: *const SubpassDescription,
    pub dependency_count: u32,
    pub p_dependencies: *const SubpassDependency,
}
impl ::std::default::Default for RenderPassCreateInfo {
    fn default() -> RenderPassCreateInfo {
        RenderPassCreateInfo {
            s_type: StructureType::RENDER_PASS_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: RenderPassCreateFlags::default(),
            attachment_count: u32::default(),
            p_attachments: ::std::ptr::null(),
            subpass_count: u32::default(),
            p_subpasses: ::std::ptr::null(),
            dependency_count: u32::default(),
            p_dependencies: ::std::ptr::null(),
        }
    }
}
impl RenderPassCreateInfo {
    pub fn builder<'a>() -> RenderPassCreateInfoBuilder<'a> {
        RenderPassCreateInfoBuilder {
            inner: RenderPassCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct RenderPassCreateInfoBuilder<'a> {
    inner: RenderPassCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsRenderPassCreateInfo {}
impl<'a> ::std::ops::Deref for RenderPassCreateInfoBuilder<'a> {
    type Target = RenderPassCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for RenderPassCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> RenderPassCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: RenderPassCreateFlags) -> RenderPassCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn attachments(
        mut self,
        attachments: &'a [AttachmentDescription],
    ) -> RenderPassCreateInfoBuilder<'a> {
        self.inner.attachment_count = attachments.len() as _;
        self.inner.p_attachments = attachments.as_ptr();
        self
    }
    pub fn subpasses(
        mut self,
        subpasses: &'a [SubpassDescription],
    ) -> RenderPassCreateInfoBuilder<'a> {
        self.inner.subpass_count = subpasses.len() as _;
        self.inner.p_subpasses = subpasses.as_ptr();
        self
    }
    pub fn dependencies(
        mut self,
        dependencies: &'a [SubpassDependency],
    ) -> RenderPassCreateInfoBuilder<'a> {
        self.inner.dependency_count = dependencies.len() as _;
        self.inner.p_dependencies = dependencies.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsRenderPassCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> RenderPassCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> RenderPassCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkEventCreateInfo.html>"]
pub struct EventCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: EventCreateFlags,
}
impl ::std::default::Default for EventCreateInfo {
    fn default() -> EventCreateInfo {
        EventCreateInfo {
            s_type: StructureType::EVENT_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: EventCreateFlags::default(),
        }
    }
}
impl EventCreateInfo {
    pub fn builder<'a>() -> EventCreateInfoBuilder<'a> {
        EventCreateInfoBuilder {
            inner: EventCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct EventCreateInfoBuilder<'a> {
    inner: EventCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsEventCreateInfo {}
impl<'a> ::std::ops::Deref for EventCreateInfoBuilder<'a> {
    type Target = EventCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for EventCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> EventCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: EventCreateFlags) -> EventCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsEventCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> EventCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> EventCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFenceCreateInfo.html>"]
pub struct FenceCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: FenceCreateFlags,
}
impl ::std::default::Default for FenceCreateInfo {
    fn default() -> FenceCreateInfo {
        FenceCreateInfo {
            s_type: StructureType::FENCE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: FenceCreateFlags::default(),
        }
    }
}
impl FenceCreateInfo {
    pub fn builder<'a>() -> FenceCreateInfoBuilder<'a> {
        FenceCreateInfoBuilder {
            inner: FenceCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct FenceCreateInfoBuilder<'a> {
    inner: FenceCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsFenceCreateInfo {}
impl<'a> ::std::ops::Deref for FenceCreateInfoBuilder<'a> {
    type Target = FenceCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for FenceCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> FenceCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: FenceCreateFlags) -> FenceCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsFenceCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> FenceCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> FenceCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFeatures.html>"]
pub struct PhysicalDeviceFeatures {
    pub robust_buffer_access: Bool32,
    pub full_draw_index_uint32: Bool32,
    pub image_cube_array: Bool32,
    pub independent_blend: Bool32,
    pub geometry_shader: Bool32,
    pub tessellation_shader: Bool32,
    pub sample_rate_shading: Bool32,
    pub dual_src_blend: Bool32,
    pub logic_op: Bool32,
    pub multi_draw_indirect: Bool32,
    pub draw_indirect_first_instance: Bool32,
    pub depth_clamp: Bool32,
    pub depth_bias_clamp: Bool32,
    pub fill_mode_non_solid: Bool32,
    pub depth_bounds: Bool32,
    pub wide_lines: Bool32,
    pub large_points: Bool32,
    pub alpha_to_one: Bool32,
    pub multi_viewport: Bool32,
    pub sampler_anisotropy: Bool32,
    pub texture_compression_etc2: Bool32,
    pub texture_compression_astc_ldr: Bool32,
    pub texture_compression_bc: Bool32,
    pub occlusion_query_precise: Bool32,
    pub pipeline_statistics_query: Bool32,
    pub vertex_pipeline_stores_and_atomics: Bool32,
    pub fragment_stores_and_atomics: Bool32,
    pub shader_tessellation_and_geometry_point_size: Bool32,
    pub shader_image_gather_extended: Bool32,
    pub shader_storage_image_extended_formats: Bool32,
    pub shader_storage_image_multisample: Bool32,
    pub shader_storage_image_read_without_format: Bool32,
    pub shader_storage_image_write_without_format: Bool32,
    pub shader_uniform_buffer_array_dynamic_indexing: Bool32,
    pub shader_sampled_image_array_dynamic_indexing: Bool32,
    pub shader_storage_buffer_array_dynamic_indexing: Bool32,
    pub shader_storage_image_array_dynamic_indexing: Bool32,
    pub shader_clip_distance: Bool32,
    pub shader_cull_distance: Bool32,
    pub shader_float64: Bool32,
    pub shader_int64: Bool32,
    pub shader_int16: Bool32,
    pub shader_resource_residency: Bool32,
    pub shader_resource_min_lod: Bool32,
    pub sparse_binding: Bool32,
    pub sparse_residency_buffer: Bool32,
    pub sparse_residency_image2_d: Bool32,
    pub sparse_residency_image3_d: Bool32,
    pub sparse_residency2_samples: Bool32,
    pub sparse_residency4_samples: Bool32,
    pub sparse_residency8_samples: Bool32,
    pub sparse_residency16_samples: Bool32,
    pub sparse_residency_aliased: Bool32,
    pub variable_multisample_rate: Bool32,
    pub inherited_queries: Bool32,
}
impl PhysicalDeviceFeatures {
    pub fn builder<'a>() -> PhysicalDeviceFeaturesBuilder<'a> {
        PhysicalDeviceFeaturesBuilder {
            inner: PhysicalDeviceFeatures::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceFeaturesBuilder<'a> {
    inner: PhysicalDeviceFeatures,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PhysicalDeviceFeaturesBuilder<'a> {
    type Target = PhysicalDeviceFeatures;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceFeaturesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceFeaturesBuilder<'a> {
    pub fn robust_buffer_access(
        mut self,
        robust_buffer_access: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.robust_buffer_access = robust_buffer_access.into();
        self
    }
    pub fn full_draw_index_uint32(
        mut self,
        full_draw_index_uint32: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.full_draw_index_uint32 = full_draw_index_uint32.into();
        self
    }
    pub fn image_cube_array(mut self, image_cube_array: bool) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.image_cube_array = image_cube_array.into();
        self
    }
    pub fn independent_blend(
        mut self,
        independent_blend: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.independent_blend = independent_blend.into();
        self
    }
    pub fn geometry_shader(mut self, geometry_shader: bool) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.geometry_shader = geometry_shader.into();
        self
    }
    pub fn tessellation_shader(
        mut self,
        tessellation_shader: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.tessellation_shader = tessellation_shader.into();
        self
    }
    pub fn sample_rate_shading(
        mut self,
        sample_rate_shading: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.sample_rate_shading = sample_rate_shading.into();
        self
    }
    pub fn dual_src_blend(mut self, dual_src_blend: bool) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.dual_src_blend = dual_src_blend.into();
        self
    }
    pub fn logic_op(mut self, logic_op: bool) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.logic_op = logic_op.into();
        self
    }
    pub fn multi_draw_indirect(
        mut self,
        multi_draw_indirect: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.multi_draw_indirect = multi_draw_indirect.into();
        self
    }
    pub fn draw_indirect_first_instance(
        mut self,
        draw_indirect_first_instance: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.draw_indirect_first_instance = draw_indirect_first_instance.into();
        self
    }
    pub fn depth_clamp(mut self, depth_clamp: bool) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.depth_clamp = depth_clamp.into();
        self
    }
    pub fn depth_bias_clamp(mut self, depth_bias_clamp: bool) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.depth_bias_clamp = depth_bias_clamp.into();
        self
    }
    pub fn fill_mode_non_solid(
        mut self,
        fill_mode_non_solid: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.fill_mode_non_solid = fill_mode_non_solid.into();
        self
    }
    pub fn depth_bounds(mut self, depth_bounds: bool) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.depth_bounds = depth_bounds.into();
        self
    }
    pub fn wide_lines(mut self, wide_lines: bool) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.wide_lines = wide_lines.into();
        self
    }
    pub fn large_points(mut self, large_points: bool) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.large_points = large_points.into();
        self
    }
    pub fn alpha_to_one(mut self, alpha_to_one: bool) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.alpha_to_one = alpha_to_one.into();
        self
    }
    pub fn multi_viewport(mut self, multi_viewport: bool) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.multi_viewport = multi_viewport.into();
        self
    }
    pub fn sampler_anisotropy(
        mut self,
        sampler_anisotropy: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.sampler_anisotropy = sampler_anisotropy.into();
        self
    }
    pub fn texture_compression_etc2(
        mut self,
        texture_compression_etc2: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.texture_compression_etc2 = texture_compression_etc2.into();
        self
    }
    pub fn texture_compression_astc_ldr(
        mut self,
        texture_compression_astc_ldr: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.texture_compression_astc_ldr = texture_compression_astc_ldr.into();
        self
    }
    pub fn texture_compression_bc(
        mut self,
        texture_compression_bc: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.texture_compression_bc = texture_compression_bc.into();
        self
    }
    pub fn occlusion_query_precise(
        mut self,
        occlusion_query_precise: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.occlusion_query_precise = occlusion_query_precise.into();
        self
    }
    pub fn pipeline_statistics_query(
        mut self,
        pipeline_statistics_query: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.pipeline_statistics_query = pipeline_statistics_query.into();
        self
    }
    pub fn vertex_pipeline_stores_and_atomics(
        mut self,
        vertex_pipeline_stores_and_atomics: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.vertex_pipeline_stores_and_atomics = vertex_pipeline_stores_and_atomics.into();
        self
    }
    pub fn fragment_stores_and_atomics(
        mut self,
        fragment_stores_and_atomics: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.fragment_stores_and_atomics = fragment_stores_and_atomics.into();
        self
    }
    pub fn shader_tessellation_and_geometry_point_size(
        mut self,
        shader_tessellation_and_geometry_point_size: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.shader_tessellation_and_geometry_point_size =
            shader_tessellation_and_geometry_point_size.into();
        self
    }
    pub fn shader_image_gather_extended(
        mut self,
        shader_image_gather_extended: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.shader_image_gather_extended = shader_image_gather_extended.into();
        self
    }
    pub fn shader_storage_image_extended_formats(
        mut self,
        shader_storage_image_extended_formats: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.shader_storage_image_extended_formats =
            shader_storage_image_extended_formats.into();
        self
    }
    pub fn shader_storage_image_multisample(
        mut self,
        shader_storage_image_multisample: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.shader_storage_image_multisample = shader_storage_image_multisample.into();
        self
    }
    pub fn shader_storage_image_read_without_format(
        mut self,
        shader_storage_image_read_without_format: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.shader_storage_image_read_without_format =
            shader_storage_image_read_without_format.into();
        self
    }
    pub fn shader_storage_image_write_without_format(
        mut self,
        shader_storage_image_write_without_format: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.shader_storage_image_write_without_format =
            shader_storage_image_write_without_format.into();
        self
    }
    pub fn shader_uniform_buffer_array_dynamic_indexing(
        mut self,
        shader_uniform_buffer_array_dynamic_indexing: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.shader_uniform_buffer_array_dynamic_indexing =
            shader_uniform_buffer_array_dynamic_indexing.into();
        self
    }
    pub fn shader_sampled_image_array_dynamic_indexing(
        mut self,
        shader_sampled_image_array_dynamic_indexing: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.shader_sampled_image_array_dynamic_indexing =
            shader_sampled_image_array_dynamic_indexing.into();
        self
    }
    pub fn shader_storage_buffer_array_dynamic_indexing(
        mut self,
        shader_storage_buffer_array_dynamic_indexing: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.shader_storage_buffer_array_dynamic_indexing =
            shader_storage_buffer_array_dynamic_indexing.into();
        self
    }
    pub fn shader_storage_image_array_dynamic_indexing(
        mut self,
        shader_storage_image_array_dynamic_indexing: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.shader_storage_image_array_dynamic_indexing =
            shader_storage_image_array_dynamic_indexing.into();
        self
    }
    pub fn shader_clip_distance(
        mut self,
        shader_clip_distance: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.shader_clip_distance = shader_clip_distance.into();
        self
    }
    pub fn shader_cull_distance(
        mut self,
        shader_cull_distance: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.shader_cull_distance = shader_cull_distance.into();
        self
    }
    pub fn shader_float64(mut self, shader_float64: bool) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.shader_float64 = shader_float64.into();
        self
    }
    pub fn shader_int64(mut self, shader_int64: bool) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.shader_int64 = shader_int64.into();
        self
    }
    pub fn shader_int16(mut self, shader_int16: bool) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.shader_int16 = shader_int16.into();
        self
    }
    pub fn shader_resource_residency(
        mut self,
        shader_resource_residency: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.shader_resource_residency = shader_resource_residency.into();
        self
    }
    pub fn shader_resource_min_lod(
        mut self,
        shader_resource_min_lod: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.shader_resource_min_lod = shader_resource_min_lod.into();
        self
    }
    pub fn sparse_binding(mut self, sparse_binding: bool) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.sparse_binding = sparse_binding.into();
        self
    }
    pub fn sparse_residency_buffer(
        mut self,
        sparse_residency_buffer: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.sparse_residency_buffer = sparse_residency_buffer.into();
        self
    }
    pub fn sparse_residency_image2_d(
        mut self,
        sparse_residency_image2_d: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.sparse_residency_image2_d = sparse_residency_image2_d.into();
        self
    }
    pub fn sparse_residency_image3_d(
        mut self,
        sparse_residency_image3_d: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.sparse_residency_image3_d = sparse_residency_image3_d.into();
        self
    }
    pub fn sparse_residency2_samples(
        mut self,
        sparse_residency2_samples: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.sparse_residency2_samples = sparse_residency2_samples.into();
        self
    }
    pub fn sparse_residency4_samples(
        mut self,
        sparse_residency4_samples: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.sparse_residency4_samples = sparse_residency4_samples.into();
        self
    }
    pub fn sparse_residency8_samples(
        mut self,
        sparse_residency8_samples: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.sparse_residency8_samples = sparse_residency8_samples.into();
        self
    }
    pub fn sparse_residency16_samples(
        mut self,
        sparse_residency16_samples: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.sparse_residency16_samples = sparse_residency16_samples.into();
        self
    }
    pub fn sparse_residency_aliased(
        mut self,
        sparse_residency_aliased: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.sparse_residency_aliased = sparse_residency_aliased.into();
        self
    }
    pub fn variable_multisample_rate(
        mut self,
        variable_multisample_rate: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.variable_multisample_rate = variable_multisample_rate.into();
        self
    }
    pub fn inherited_queries(
        mut self,
        inherited_queries: bool,
    ) -> PhysicalDeviceFeaturesBuilder<'a> {
        self.inner.inherited_queries = inherited_queries.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceFeatures {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSparseProperties.html>"]
pub struct PhysicalDeviceSparseProperties {
    pub residency_standard2_d_block_shape: Bool32,
    pub residency_standard2_d_multisample_block_shape: Bool32,
    pub residency_standard3_d_block_shape: Bool32,
    pub residency_aligned_mip_size: Bool32,
    pub residency_non_resident_strict: Bool32,
}
impl PhysicalDeviceSparseProperties {
    pub fn builder<'a>() -> PhysicalDeviceSparsePropertiesBuilder<'a> {
        PhysicalDeviceSparsePropertiesBuilder {
            inner: PhysicalDeviceSparseProperties::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceSparsePropertiesBuilder<'a> {
    inner: PhysicalDeviceSparseProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PhysicalDeviceSparsePropertiesBuilder<'a> {
    type Target = PhysicalDeviceSparseProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceSparsePropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceSparsePropertiesBuilder<'a> {
    pub fn residency_standard2_d_block_shape(
        mut self,
        residency_standard2_d_block_shape: bool,
    ) -> PhysicalDeviceSparsePropertiesBuilder<'a> {
        self.inner.residency_standard2_d_block_shape = residency_standard2_d_block_shape.into();
        self
    }
    pub fn residency_standard2_d_multisample_block_shape(
        mut self,
        residency_standard2_d_multisample_block_shape: bool,
    ) -> PhysicalDeviceSparsePropertiesBuilder<'a> {
        self.inner.residency_standard2_d_multisample_block_shape =
            residency_standard2_d_multisample_block_shape.into();
        self
    }
    pub fn residency_standard3_d_block_shape(
        mut self,
        residency_standard3_d_block_shape: bool,
    ) -> PhysicalDeviceSparsePropertiesBuilder<'a> {
        self.inner.residency_standard3_d_block_shape = residency_standard3_d_block_shape.into();
        self
    }
    pub fn residency_aligned_mip_size(
        mut self,
        residency_aligned_mip_size: bool,
    ) -> PhysicalDeviceSparsePropertiesBuilder<'a> {
        self.inner.residency_aligned_mip_size = residency_aligned_mip_size.into();
        self
    }
    pub fn residency_non_resident_strict(
        mut self,
        residency_non_resident_strict: bool,
    ) -> PhysicalDeviceSparsePropertiesBuilder<'a> {
        self.inner.residency_non_resident_strict = residency_non_resident_strict.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceSparseProperties {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceLimits.html>"]
pub struct PhysicalDeviceLimits {
    pub max_image_dimension1_d: u32,
    pub max_image_dimension2_d: u32,
    pub max_image_dimension3_d: u32,
    pub max_image_dimension_cube: u32,
    pub max_image_array_layers: u32,
    pub max_texel_buffer_elements: u32,
    pub max_uniform_buffer_range: u32,
    pub max_storage_buffer_range: u32,
    pub max_push_constants_size: u32,
    pub max_memory_allocation_count: u32,
    pub max_sampler_allocation_count: u32,
    pub buffer_image_granularity: DeviceSize,
    pub sparse_address_space_size: DeviceSize,
    pub max_bound_descriptor_sets: u32,
    pub max_per_stage_descriptor_samplers: u32,
    pub max_per_stage_descriptor_uniform_buffers: u32,
    pub max_per_stage_descriptor_storage_buffers: u32,
    pub max_per_stage_descriptor_sampled_images: u32,
    pub max_per_stage_descriptor_storage_images: u32,
    pub max_per_stage_descriptor_input_attachments: u32,
    pub max_per_stage_resources: u32,
    pub max_descriptor_set_samplers: u32,
    pub max_descriptor_set_uniform_buffers: u32,
    pub max_descriptor_set_uniform_buffers_dynamic: u32,
    pub max_descriptor_set_storage_buffers: u32,
    pub max_descriptor_set_storage_buffers_dynamic: u32,
    pub max_descriptor_set_sampled_images: u32,
    pub max_descriptor_set_storage_images: u32,
    pub max_descriptor_set_input_attachments: u32,
    pub max_vertex_input_attributes: u32,
    pub max_vertex_input_bindings: u32,
    pub max_vertex_input_attribute_offset: u32,
    pub max_vertex_input_binding_stride: u32,
    pub max_vertex_output_components: u32,
    pub max_tessellation_generation_level: u32,
    pub max_tessellation_patch_size: u32,
    pub max_tessellation_control_per_vertex_input_components: u32,
    pub max_tessellation_control_per_vertex_output_components: u32,
    pub max_tessellation_control_per_patch_output_components: u32,
    pub max_tessellation_control_total_output_components: u32,
    pub max_tessellation_evaluation_input_components: u32,
    pub max_tessellation_evaluation_output_components: u32,
    pub max_geometry_shader_invocations: u32,
    pub max_geometry_input_components: u32,
    pub max_geometry_output_components: u32,
    pub max_geometry_output_vertices: u32,
    pub max_geometry_total_output_components: u32,
    pub max_fragment_input_components: u32,
    pub max_fragment_output_attachments: u32,
    pub max_fragment_dual_src_attachments: u32,
    pub max_fragment_combined_output_resources: u32,
    pub max_compute_shared_memory_size: u32,
    pub max_compute_work_group_count: [u32; 3],
    pub max_compute_work_group_invocations: u32,
    pub max_compute_work_group_size: [u32; 3],
    pub sub_pixel_precision_bits: u32,
    pub sub_texel_precision_bits: u32,
    pub mipmap_precision_bits: u32,
    pub max_draw_indexed_index_value: u32,
    pub max_draw_indirect_count: u32,
    pub max_sampler_lod_bias: f32,
    pub max_sampler_anisotropy: f32,
    pub max_viewports: u32,
    pub max_viewport_dimensions: [u32; 2],
    pub viewport_bounds_range: [f32; 2],
    pub viewport_sub_pixel_bits: u32,
    pub min_memory_map_alignment: usize,
    pub min_texel_buffer_offset_alignment: DeviceSize,
    pub min_uniform_buffer_offset_alignment: DeviceSize,
    pub min_storage_buffer_offset_alignment: DeviceSize,
    pub min_texel_offset: i32,
    pub max_texel_offset: u32,
    pub min_texel_gather_offset: i32,
    pub max_texel_gather_offset: u32,
    pub min_interpolation_offset: f32,
    pub max_interpolation_offset: f32,
    pub sub_pixel_interpolation_offset_bits: u32,
    pub max_framebuffer_width: u32,
    pub max_framebuffer_height: u32,
    pub max_framebuffer_layers: u32,
    pub framebuffer_color_sample_counts: SampleCountFlags,
    pub framebuffer_depth_sample_counts: SampleCountFlags,
    pub framebuffer_stencil_sample_counts: SampleCountFlags,
    pub framebuffer_no_attachments_sample_counts: SampleCountFlags,
    pub max_color_attachments: u32,
    pub sampled_image_color_sample_counts: SampleCountFlags,
    pub sampled_image_integer_sample_counts: SampleCountFlags,
    pub sampled_image_depth_sample_counts: SampleCountFlags,
    pub sampled_image_stencil_sample_counts: SampleCountFlags,
    pub storage_image_sample_counts: SampleCountFlags,
    pub max_sample_mask_words: u32,
    pub timestamp_compute_and_graphics: Bool32,
    pub timestamp_period: f32,
    pub max_clip_distances: u32,
    pub max_cull_distances: u32,
    pub max_combined_clip_and_cull_distances: u32,
    pub discrete_queue_priorities: u32,
    pub point_size_range: [f32; 2],
    pub line_width_range: [f32; 2],
    pub point_size_granularity: f32,
    pub line_width_granularity: f32,
    pub strict_lines: Bool32,
    pub standard_sample_locations: Bool32,
    pub optimal_buffer_copy_offset_alignment: DeviceSize,
    pub optimal_buffer_copy_row_pitch_alignment: DeviceSize,
    pub non_coherent_atom_size: DeviceSize,
}
impl ::std::default::Default for PhysicalDeviceLimits {
    fn default() -> PhysicalDeviceLimits {
        PhysicalDeviceLimits {
            max_image_dimension1_d: u32::default(),
            max_image_dimension2_d: u32::default(),
            max_image_dimension3_d: u32::default(),
            max_image_dimension_cube: u32::default(),
            max_image_array_layers: u32::default(),
            max_texel_buffer_elements: u32::default(),
            max_uniform_buffer_range: u32::default(),
            max_storage_buffer_range: u32::default(),
            max_push_constants_size: u32::default(),
            max_memory_allocation_count: u32::default(),
            max_sampler_allocation_count: u32::default(),
            buffer_image_granularity: DeviceSize::default(),
            sparse_address_space_size: DeviceSize::default(),
            max_bound_descriptor_sets: u32::default(),
            max_per_stage_descriptor_samplers: u32::default(),
            max_per_stage_descriptor_uniform_buffers: u32::default(),
            max_per_stage_descriptor_storage_buffers: u32::default(),
            max_per_stage_descriptor_sampled_images: u32::default(),
            max_per_stage_descriptor_storage_images: u32::default(),
            max_per_stage_descriptor_input_attachments: u32::default(),
            max_per_stage_resources: u32::default(),
            max_descriptor_set_samplers: u32::default(),
            max_descriptor_set_uniform_buffers: u32::default(),
            max_descriptor_set_uniform_buffers_dynamic: u32::default(),
            max_descriptor_set_storage_buffers: u32::default(),
            max_descriptor_set_storage_buffers_dynamic: u32::default(),
            max_descriptor_set_sampled_images: u32::default(),
            max_descriptor_set_storage_images: u32::default(),
            max_descriptor_set_input_attachments: u32::default(),
            max_vertex_input_attributes: u32::default(),
            max_vertex_input_bindings: u32::default(),
            max_vertex_input_attribute_offset: u32::default(),
            max_vertex_input_binding_stride: u32::default(),
            max_vertex_output_components: u32::default(),
            max_tessellation_generation_level: u32::default(),
            max_tessellation_patch_size: u32::default(),
            max_tessellation_control_per_vertex_input_components: u32::default(),
            max_tessellation_control_per_vertex_output_components: u32::default(),
            max_tessellation_control_per_patch_output_components: u32::default(),
            max_tessellation_control_total_output_components: u32::default(),
            max_tessellation_evaluation_input_components: u32::default(),
            max_tessellation_evaluation_output_components: u32::default(),
            max_geometry_shader_invocations: u32::default(),
            max_geometry_input_components: u32::default(),
            max_geometry_output_components: u32::default(),
            max_geometry_output_vertices: u32::default(),
            max_geometry_total_output_components: u32::default(),
            max_fragment_input_components: u32::default(),
            max_fragment_output_attachments: u32::default(),
            max_fragment_dual_src_attachments: u32::default(),
            max_fragment_combined_output_resources: u32::default(),
            max_compute_shared_memory_size: u32::default(),
            max_compute_work_group_count: unsafe { ::std::mem::zeroed() },
            max_compute_work_group_invocations: u32::default(),
            max_compute_work_group_size: unsafe { ::std::mem::zeroed() },
            sub_pixel_precision_bits: u32::default(),
            sub_texel_precision_bits: u32::default(),
            mipmap_precision_bits: u32::default(),
            max_draw_indexed_index_value: u32::default(),
            max_draw_indirect_count: u32::default(),
            max_sampler_lod_bias: f32::default(),
            max_sampler_anisotropy: f32::default(),
            max_viewports: u32::default(),
            max_viewport_dimensions: unsafe { ::std::mem::zeroed() },
            viewport_bounds_range: unsafe { ::std::mem::zeroed() },
            viewport_sub_pixel_bits: u32::default(),
            min_memory_map_alignment: usize::default(),
            min_texel_buffer_offset_alignment: DeviceSize::default(),
            min_uniform_buffer_offset_alignment: DeviceSize::default(),
            min_storage_buffer_offset_alignment: DeviceSize::default(),
            min_texel_offset: i32::default(),
            max_texel_offset: u32::default(),
            min_texel_gather_offset: i32::default(),
            max_texel_gather_offset: u32::default(),
            min_interpolation_offset: f32::default(),
            max_interpolation_offset: f32::default(),
            sub_pixel_interpolation_offset_bits: u32::default(),
            max_framebuffer_width: u32::default(),
            max_framebuffer_height: u32::default(),
            max_framebuffer_layers: u32::default(),
            framebuffer_color_sample_counts: SampleCountFlags::default(),
            framebuffer_depth_sample_counts: SampleCountFlags::default(),
            framebuffer_stencil_sample_counts: SampleCountFlags::default(),
            framebuffer_no_attachments_sample_counts: SampleCountFlags::default(),
            max_color_attachments: u32::default(),
            sampled_image_color_sample_counts: SampleCountFlags::default(),
            sampled_image_integer_sample_counts: SampleCountFlags::default(),
            sampled_image_depth_sample_counts: SampleCountFlags::default(),
            sampled_image_stencil_sample_counts: SampleCountFlags::default(),
            storage_image_sample_counts: SampleCountFlags::default(),
            max_sample_mask_words: u32::default(),
            timestamp_compute_and_graphics: Bool32::default(),
            timestamp_period: f32::default(),
            max_clip_distances: u32::default(),
            max_cull_distances: u32::default(),
            max_combined_clip_and_cull_distances: u32::default(),
            discrete_queue_priorities: u32::default(),
            point_size_range: unsafe { ::std::mem::zeroed() },
            line_width_range: unsafe { ::std::mem::zeroed() },
            point_size_granularity: f32::default(),
            line_width_granularity: f32::default(),
            strict_lines: Bool32::default(),
            standard_sample_locations: Bool32::default(),
            optimal_buffer_copy_offset_alignment: DeviceSize::default(),
            optimal_buffer_copy_row_pitch_alignment: DeviceSize::default(),
            non_coherent_atom_size: DeviceSize::default(),
        }
    }
}
impl PhysicalDeviceLimits {
    pub fn builder<'a>() -> PhysicalDeviceLimitsBuilder<'a> {
        PhysicalDeviceLimitsBuilder {
            inner: PhysicalDeviceLimits::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceLimitsBuilder<'a> {
    inner: PhysicalDeviceLimits,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PhysicalDeviceLimitsBuilder<'a> {
    type Target = PhysicalDeviceLimits;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceLimitsBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceLimitsBuilder<'a> {
    pub fn max_image_dimension1_d(
        mut self,
        max_image_dimension1_d: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_image_dimension1_d = max_image_dimension1_d;
        self
    }
    pub fn max_image_dimension2_d(
        mut self,
        max_image_dimension2_d: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_image_dimension2_d = max_image_dimension2_d;
        self
    }
    pub fn max_image_dimension3_d(
        mut self,
        max_image_dimension3_d: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_image_dimension3_d = max_image_dimension3_d;
        self
    }
    pub fn max_image_dimension_cube(
        mut self,
        max_image_dimension_cube: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_image_dimension_cube = max_image_dimension_cube;
        self
    }
    pub fn max_image_array_layers(
        mut self,
        max_image_array_layers: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_image_array_layers = max_image_array_layers;
        self
    }
    pub fn max_texel_buffer_elements(
        mut self,
        max_texel_buffer_elements: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_texel_buffer_elements = max_texel_buffer_elements;
        self
    }
    pub fn max_uniform_buffer_range(
        mut self,
        max_uniform_buffer_range: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_uniform_buffer_range = max_uniform_buffer_range;
        self
    }
    pub fn max_storage_buffer_range(
        mut self,
        max_storage_buffer_range: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_storage_buffer_range = max_storage_buffer_range;
        self
    }
    pub fn max_push_constants_size(
        mut self,
        max_push_constants_size: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_push_constants_size = max_push_constants_size;
        self
    }
    pub fn max_memory_allocation_count(
        mut self,
        max_memory_allocation_count: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_memory_allocation_count = max_memory_allocation_count;
        self
    }
    pub fn max_sampler_allocation_count(
        mut self,
        max_sampler_allocation_count: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_sampler_allocation_count = max_sampler_allocation_count;
        self
    }
    pub fn buffer_image_granularity(
        mut self,
        buffer_image_granularity: DeviceSize,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.buffer_image_granularity = buffer_image_granularity;
        self
    }
    pub fn sparse_address_space_size(
        mut self,
        sparse_address_space_size: DeviceSize,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.sparse_address_space_size = sparse_address_space_size;
        self
    }
    pub fn max_bound_descriptor_sets(
        mut self,
        max_bound_descriptor_sets: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_bound_descriptor_sets = max_bound_descriptor_sets;
        self
    }
    pub fn max_per_stage_descriptor_samplers(
        mut self,
        max_per_stage_descriptor_samplers: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_per_stage_descriptor_samplers = max_per_stage_descriptor_samplers;
        self
    }
    pub fn max_per_stage_descriptor_uniform_buffers(
        mut self,
        max_per_stage_descriptor_uniform_buffers: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_per_stage_descriptor_uniform_buffers =
            max_per_stage_descriptor_uniform_buffers;
        self
    }
    pub fn max_per_stage_descriptor_storage_buffers(
        mut self,
        max_per_stage_descriptor_storage_buffers: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_per_stage_descriptor_storage_buffers =
            max_per_stage_descriptor_storage_buffers;
        self
    }
    pub fn max_per_stage_descriptor_sampled_images(
        mut self,
        max_per_stage_descriptor_sampled_images: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_per_stage_descriptor_sampled_images =
            max_per_stage_descriptor_sampled_images;
        self
    }
    pub fn max_per_stage_descriptor_storage_images(
        mut self,
        max_per_stage_descriptor_storage_images: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_per_stage_descriptor_storage_images =
            max_per_stage_descriptor_storage_images;
        self
    }
    pub fn max_per_stage_descriptor_input_attachments(
        mut self,
        max_per_stage_descriptor_input_attachments: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_per_stage_descriptor_input_attachments =
            max_per_stage_descriptor_input_attachments;
        self
    }
    pub fn max_per_stage_resources(
        mut self,
        max_per_stage_resources: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_per_stage_resources = max_per_stage_resources;
        self
    }
    pub fn max_descriptor_set_samplers(
        mut self,
        max_descriptor_set_samplers: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_descriptor_set_samplers = max_descriptor_set_samplers;
        self
    }
    pub fn max_descriptor_set_uniform_buffers(
        mut self,
        max_descriptor_set_uniform_buffers: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_descriptor_set_uniform_buffers = max_descriptor_set_uniform_buffers;
        self
    }
    pub fn max_descriptor_set_uniform_buffers_dynamic(
        mut self,
        max_descriptor_set_uniform_buffers_dynamic: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_descriptor_set_uniform_buffers_dynamic =
            max_descriptor_set_uniform_buffers_dynamic;
        self
    }
    pub fn max_descriptor_set_storage_buffers(
        mut self,
        max_descriptor_set_storage_buffers: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_descriptor_set_storage_buffers = max_descriptor_set_storage_buffers;
        self
    }
    pub fn max_descriptor_set_storage_buffers_dynamic(
        mut self,
        max_descriptor_set_storage_buffers_dynamic: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_descriptor_set_storage_buffers_dynamic =
            max_descriptor_set_storage_buffers_dynamic;
        self
    }
    pub fn max_descriptor_set_sampled_images(
        mut self,
        max_descriptor_set_sampled_images: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_descriptor_set_sampled_images = max_descriptor_set_sampled_images;
        self
    }
    pub fn max_descriptor_set_storage_images(
        mut self,
        max_descriptor_set_storage_images: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_descriptor_set_storage_images = max_descriptor_set_storage_images;
        self
    }
    pub fn max_descriptor_set_input_attachments(
        mut self,
        max_descriptor_set_input_attachments: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_descriptor_set_input_attachments = max_descriptor_set_input_attachments;
        self
    }
    pub fn max_vertex_input_attributes(
        mut self,
        max_vertex_input_attributes: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_vertex_input_attributes = max_vertex_input_attributes;
        self
    }
    pub fn max_vertex_input_bindings(
        mut self,
        max_vertex_input_bindings: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_vertex_input_bindings = max_vertex_input_bindings;
        self
    }
    pub fn max_vertex_input_attribute_offset(
        mut self,
        max_vertex_input_attribute_offset: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_vertex_input_attribute_offset = max_vertex_input_attribute_offset;
        self
    }
    pub fn max_vertex_input_binding_stride(
        mut self,
        max_vertex_input_binding_stride: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_vertex_input_binding_stride = max_vertex_input_binding_stride;
        self
    }
    pub fn max_vertex_output_components(
        mut self,
        max_vertex_output_components: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_vertex_output_components = max_vertex_output_components;
        self
    }
    pub fn max_tessellation_generation_level(
        mut self,
        max_tessellation_generation_level: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_tessellation_generation_level = max_tessellation_generation_level;
        self
    }
    pub fn max_tessellation_patch_size(
        mut self,
        max_tessellation_patch_size: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_tessellation_patch_size = max_tessellation_patch_size;
        self
    }
    pub fn max_tessellation_control_per_vertex_input_components(
        mut self,
        max_tessellation_control_per_vertex_input_components: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner
            .max_tessellation_control_per_vertex_input_components =
            max_tessellation_control_per_vertex_input_components;
        self
    }
    pub fn max_tessellation_control_per_vertex_output_components(
        mut self,
        max_tessellation_control_per_vertex_output_components: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner
            .max_tessellation_control_per_vertex_output_components =
            max_tessellation_control_per_vertex_output_components;
        self
    }
    pub fn max_tessellation_control_per_patch_output_components(
        mut self,
        max_tessellation_control_per_patch_output_components: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner
            .max_tessellation_control_per_patch_output_components =
            max_tessellation_control_per_patch_output_components;
        self
    }
    pub fn max_tessellation_control_total_output_components(
        mut self,
        max_tessellation_control_total_output_components: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_tessellation_control_total_output_components =
            max_tessellation_control_total_output_components;
        self
    }
    pub fn max_tessellation_evaluation_input_components(
        mut self,
        max_tessellation_evaluation_input_components: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_tessellation_evaluation_input_components =
            max_tessellation_evaluation_input_components;
        self
    }
    pub fn max_tessellation_evaluation_output_components(
        mut self,
        max_tessellation_evaluation_output_components: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_tessellation_evaluation_output_components =
            max_tessellation_evaluation_output_components;
        self
    }
    pub fn max_geometry_shader_invocations(
        mut self,
        max_geometry_shader_invocations: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_geometry_shader_invocations = max_geometry_shader_invocations;
        self
    }
    pub fn max_geometry_input_components(
        mut self,
        max_geometry_input_components: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_geometry_input_components = max_geometry_input_components;
        self
    }
    pub fn max_geometry_output_components(
        mut self,
        max_geometry_output_components: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_geometry_output_components = max_geometry_output_components;
        self
    }
    pub fn max_geometry_output_vertices(
        mut self,
        max_geometry_output_vertices: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_geometry_output_vertices = max_geometry_output_vertices;
        self
    }
    pub fn max_geometry_total_output_components(
        mut self,
        max_geometry_total_output_components: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_geometry_total_output_components = max_geometry_total_output_components;
        self
    }
    pub fn max_fragment_input_components(
        mut self,
        max_fragment_input_components: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_fragment_input_components = max_fragment_input_components;
        self
    }
    pub fn max_fragment_output_attachments(
        mut self,
        max_fragment_output_attachments: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_fragment_output_attachments = max_fragment_output_attachments;
        self
    }
    pub fn max_fragment_dual_src_attachments(
        mut self,
        max_fragment_dual_src_attachments: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_fragment_dual_src_attachments = max_fragment_dual_src_attachments;
        self
    }
    pub fn max_fragment_combined_output_resources(
        mut self,
        max_fragment_combined_output_resources: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_fragment_combined_output_resources = max_fragment_combined_output_resources;
        self
    }
    pub fn max_compute_shared_memory_size(
        mut self,
        max_compute_shared_memory_size: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_compute_shared_memory_size = max_compute_shared_memory_size;
        self
    }
    pub fn max_compute_work_group_count(
        mut self,
        max_compute_work_group_count: [u32; 3],
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_compute_work_group_count = max_compute_work_group_count;
        self
    }
    pub fn max_compute_work_group_invocations(
        mut self,
        max_compute_work_group_invocations: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_compute_work_group_invocations = max_compute_work_group_invocations;
        self
    }
    pub fn max_compute_work_group_size(
        mut self,
        max_compute_work_group_size: [u32; 3],
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_compute_work_group_size = max_compute_work_group_size;
        self
    }
    pub fn sub_pixel_precision_bits(
        mut self,
        sub_pixel_precision_bits: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.sub_pixel_precision_bits = sub_pixel_precision_bits;
        self
    }
    pub fn sub_texel_precision_bits(
        mut self,
        sub_texel_precision_bits: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.sub_texel_precision_bits = sub_texel_precision_bits;
        self
    }
    pub fn mipmap_precision_bits(
        mut self,
        mipmap_precision_bits: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.mipmap_precision_bits = mipmap_precision_bits;
        self
    }
    pub fn max_draw_indexed_index_value(
        mut self,
        max_draw_indexed_index_value: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_draw_indexed_index_value = max_draw_indexed_index_value;
        self
    }
    pub fn max_draw_indirect_count(
        mut self,
        max_draw_indirect_count: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_draw_indirect_count = max_draw_indirect_count;
        self
    }
    pub fn max_sampler_lod_bias(
        mut self,
        max_sampler_lod_bias: f32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_sampler_lod_bias = max_sampler_lod_bias;
        self
    }
    pub fn max_sampler_anisotropy(
        mut self,
        max_sampler_anisotropy: f32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_sampler_anisotropy = max_sampler_anisotropy;
        self
    }
    pub fn max_viewports(mut self, max_viewports: u32) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_viewports = max_viewports;
        self
    }
    pub fn max_viewport_dimensions(
        mut self,
        max_viewport_dimensions: [u32; 2],
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_viewport_dimensions = max_viewport_dimensions;
        self
    }
    pub fn viewport_bounds_range(
        mut self,
        viewport_bounds_range: [f32; 2],
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.viewport_bounds_range = viewport_bounds_range;
        self
    }
    pub fn viewport_sub_pixel_bits(
        mut self,
        viewport_sub_pixel_bits: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.viewport_sub_pixel_bits = viewport_sub_pixel_bits;
        self
    }
    pub fn min_memory_map_alignment(
        mut self,
        min_memory_map_alignment: usize,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.min_memory_map_alignment = min_memory_map_alignment;
        self
    }
    pub fn min_texel_buffer_offset_alignment(
        mut self,
        min_texel_buffer_offset_alignment: DeviceSize,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.min_texel_buffer_offset_alignment = min_texel_buffer_offset_alignment;
        self
    }
    pub fn min_uniform_buffer_offset_alignment(
        mut self,
        min_uniform_buffer_offset_alignment: DeviceSize,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.min_uniform_buffer_offset_alignment = min_uniform_buffer_offset_alignment;
        self
    }
    pub fn min_storage_buffer_offset_alignment(
        mut self,
        min_storage_buffer_offset_alignment: DeviceSize,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.min_storage_buffer_offset_alignment = min_storage_buffer_offset_alignment;
        self
    }
    pub fn min_texel_offset(mut self, min_texel_offset: i32) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.min_texel_offset = min_texel_offset;
        self
    }
    pub fn max_texel_offset(mut self, max_texel_offset: u32) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_texel_offset = max_texel_offset;
        self
    }
    pub fn min_texel_gather_offset(
        mut self,
        min_texel_gather_offset: i32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.min_texel_gather_offset = min_texel_gather_offset;
        self
    }
    pub fn max_texel_gather_offset(
        mut self,
        max_texel_gather_offset: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_texel_gather_offset = max_texel_gather_offset;
        self
    }
    pub fn min_interpolation_offset(
        mut self,
        min_interpolation_offset: f32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.min_interpolation_offset = min_interpolation_offset;
        self
    }
    pub fn max_interpolation_offset(
        mut self,
        max_interpolation_offset: f32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_interpolation_offset = max_interpolation_offset;
        self
    }
    pub fn sub_pixel_interpolation_offset_bits(
        mut self,
        sub_pixel_interpolation_offset_bits: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.sub_pixel_interpolation_offset_bits = sub_pixel_interpolation_offset_bits;
        self
    }
    pub fn max_framebuffer_width(
        mut self,
        max_framebuffer_width: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_framebuffer_width = max_framebuffer_width;
        self
    }
    pub fn max_framebuffer_height(
        mut self,
        max_framebuffer_height: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_framebuffer_height = max_framebuffer_height;
        self
    }
    pub fn max_framebuffer_layers(
        mut self,
        max_framebuffer_layers: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_framebuffer_layers = max_framebuffer_layers;
        self
    }
    pub fn framebuffer_color_sample_counts(
        mut self,
        framebuffer_color_sample_counts: SampleCountFlags,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.framebuffer_color_sample_counts = framebuffer_color_sample_counts;
        self
    }
    pub fn framebuffer_depth_sample_counts(
        mut self,
        framebuffer_depth_sample_counts: SampleCountFlags,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.framebuffer_depth_sample_counts = framebuffer_depth_sample_counts;
        self
    }
    pub fn framebuffer_stencil_sample_counts(
        mut self,
        framebuffer_stencil_sample_counts: SampleCountFlags,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.framebuffer_stencil_sample_counts = framebuffer_stencil_sample_counts;
        self
    }
    pub fn framebuffer_no_attachments_sample_counts(
        mut self,
        framebuffer_no_attachments_sample_counts: SampleCountFlags,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.framebuffer_no_attachments_sample_counts =
            framebuffer_no_attachments_sample_counts;
        self
    }
    pub fn max_color_attachments(
        mut self,
        max_color_attachments: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_color_attachments = max_color_attachments;
        self
    }
    pub fn sampled_image_color_sample_counts(
        mut self,
        sampled_image_color_sample_counts: SampleCountFlags,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.sampled_image_color_sample_counts = sampled_image_color_sample_counts;
        self
    }
    pub fn sampled_image_integer_sample_counts(
        mut self,
        sampled_image_integer_sample_counts: SampleCountFlags,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.sampled_image_integer_sample_counts = sampled_image_integer_sample_counts;
        self
    }
    pub fn sampled_image_depth_sample_counts(
        mut self,
        sampled_image_depth_sample_counts: SampleCountFlags,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.sampled_image_depth_sample_counts = sampled_image_depth_sample_counts;
        self
    }
    pub fn sampled_image_stencil_sample_counts(
        mut self,
        sampled_image_stencil_sample_counts: SampleCountFlags,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.sampled_image_stencil_sample_counts = sampled_image_stencil_sample_counts;
        self
    }
    pub fn storage_image_sample_counts(
        mut self,
        storage_image_sample_counts: SampleCountFlags,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.storage_image_sample_counts = storage_image_sample_counts;
        self
    }
    pub fn max_sample_mask_words(
        mut self,
        max_sample_mask_words: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_sample_mask_words = max_sample_mask_words;
        self
    }
    pub fn timestamp_compute_and_graphics(
        mut self,
        timestamp_compute_and_graphics: bool,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.timestamp_compute_and_graphics = timestamp_compute_and_graphics.into();
        self
    }
    pub fn timestamp_period(mut self, timestamp_period: f32) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.timestamp_period = timestamp_period;
        self
    }
    pub fn max_clip_distances(
        mut self,
        max_clip_distances: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_clip_distances = max_clip_distances;
        self
    }
    pub fn max_cull_distances(
        mut self,
        max_cull_distances: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_cull_distances = max_cull_distances;
        self
    }
    pub fn max_combined_clip_and_cull_distances(
        mut self,
        max_combined_clip_and_cull_distances: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.max_combined_clip_and_cull_distances = max_combined_clip_and_cull_distances;
        self
    }
    pub fn discrete_queue_priorities(
        mut self,
        discrete_queue_priorities: u32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.discrete_queue_priorities = discrete_queue_priorities;
        self
    }
    pub fn point_size_range(
        mut self,
        point_size_range: [f32; 2],
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.point_size_range = point_size_range;
        self
    }
    pub fn line_width_range(
        mut self,
        line_width_range: [f32; 2],
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.line_width_range = line_width_range;
        self
    }
    pub fn point_size_granularity(
        mut self,
        point_size_granularity: f32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.point_size_granularity = point_size_granularity;
        self
    }
    pub fn line_width_granularity(
        mut self,
        line_width_granularity: f32,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.line_width_granularity = line_width_granularity;
        self
    }
    pub fn strict_lines(mut self, strict_lines: bool) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.strict_lines = strict_lines.into();
        self
    }
    pub fn standard_sample_locations(
        mut self,
        standard_sample_locations: bool,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.standard_sample_locations = standard_sample_locations.into();
        self
    }
    pub fn optimal_buffer_copy_offset_alignment(
        mut self,
        optimal_buffer_copy_offset_alignment: DeviceSize,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.optimal_buffer_copy_offset_alignment = optimal_buffer_copy_offset_alignment;
        self
    }
    pub fn optimal_buffer_copy_row_pitch_alignment(
        mut self,
        optimal_buffer_copy_row_pitch_alignment: DeviceSize,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.optimal_buffer_copy_row_pitch_alignment =
            optimal_buffer_copy_row_pitch_alignment;
        self
    }
    pub fn non_coherent_atom_size(
        mut self,
        non_coherent_atom_size: DeviceSize,
    ) -> PhysicalDeviceLimitsBuilder<'a> {
        self.inner.non_coherent_atom_size = non_coherent_atom_size;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceLimits {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreCreateInfo.html>"]
pub struct SemaphoreCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: SemaphoreCreateFlags,
}
impl ::std::default::Default for SemaphoreCreateInfo {
    fn default() -> SemaphoreCreateInfo {
        SemaphoreCreateInfo {
            s_type: StructureType::SEMAPHORE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: SemaphoreCreateFlags::default(),
        }
    }
}
impl SemaphoreCreateInfo {
    pub fn builder<'a>() -> SemaphoreCreateInfoBuilder<'a> {
        SemaphoreCreateInfoBuilder {
            inner: SemaphoreCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SemaphoreCreateInfoBuilder<'a> {
    inner: SemaphoreCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsSemaphoreCreateInfo {}
impl<'a> ::std::ops::Deref for SemaphoreCreateInfoBuilder<'a> {
    type Target = SemaphoreCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SemaphoreCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SemaphoreCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: SemaphoreCreateFlags) -> SemaphoreCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSemaphoreCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> SemaphoreCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SemaphoreCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueryPoolCreateInfo.html>"]
pub struct QueryPoolCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: QueryPoolCreateFlags,
    pub query_type: QueryType,
    pub query_count: u32,
    pub pipeline_statistics: QueryPipelineStatisticFlags,
}
impl ::std::default::Default for QueryPoolCreateInfo {
    fn default() -> QueryPoolCreateInfo {
        QueryPoolCreateInfo {
            s_type: StructureType::QUERY_POOL_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: QueryPoolCreateFlags::default(),
            query_type: QueryType::default(),
            query_count: u32::default(),
            pipeline_statistics: QueryPipelineStatisticFlags::default(),
        }
    }
}
impl QueryPoolCreateInfo {
    pub fn builder<'a>() -> QueryPoolCreateInfoBuilder<'a> {
        QueryPoolCreateInfoBuilder {
            inner: QueryPoolCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct QueryPoolCreateInfoBuilder<'a> {
    inner: QueryPoolCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsQueryPoolCreateInfo {}
impl<'a> ::std::ops::Deref for QueryPoolCreateInfoBuilder<'a> {
    type Target = QueryPoolCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for QueryPoolCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> QueryPoolCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: QueryPoolCreateFlags) -> QueryPoolCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn query_type(mut self, query_type: QueryType) -> QueryPoolCreateInfoBuilder<'a> {
        self.inner.query_type = query_type;
        self
    }
    pub fn query_count(mut self, query_count: u32) -> QueryPoolCreateInfoBuilder<'a> {
        self.inner.query_count = query_count;
        self
    }
    pub fn pipeline_statistics(
        mut self,
        pipeline_statistics: QueryPipelineStatisticFlags,
    ) -> QueryPoolCreateInfoBuilder<'a> {
        self.inner.pipeline_statistics = pipeline_statistics;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsQueryPoolCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> QueryPoolCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> QueryPoolCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFramebufferCreateInfo.html>"]
pub struct FramebufferCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: FramebufferCreateFlags,
    pub render_pass: RenderPass,
    pub attachment_count: u32,
    pub p_attachments: *const ImageView,
    pub width: u32,
    pub height: u32,
    pub layers: u32,
}
impl ::std::default::Default for FramebufferCreateInfo {
    fn default() -> FramebufferCreateInfo {
        FramebufferCreateInfo {
            s_type: StructureType::FRAMEBUFFER_CREATE_INFO,
            p_next: ::std::ptr::null(),
            flags: FramebufferCreateFlags::default(),
            render_pass: RenderPass::default(),
            attachment_count: u32::default(),
            p_attachments: ::std::ptr::null(),
            width: u32::default(),
            height: u32::default(),
            layers: u32::default(),
        }
    }
}
impl FramebufferCreateInfo {
    pub fn builder<'a>() -> FramebufferCreateInfoBuilder<'a> {
        FramebufferCreateInfoBuilder {
            inner: FramebufferCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct FramebufferCreateInfoBuilder<'a> {
    inner: FramebufferCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsFramebufferCreateInfo {}
impl<'a> ::std::ops::Deref for FramebufferCreateInfoBuilder<'a> {
    type Target = FramebufferCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for FramebufferCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> FramebufferCreateInfoBuilder<'a> {
    pub fn flags(mut self, flags: FramebufferCreateFlags) -> FramebufferCreateInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn render_pass(mut self, render_pass: RenderPass) -> FramebufferCreateInfoBuilder<'a> {
        self.inner.render_pass = render_pass;
        self
    }
    pub fn attachments(mut self, attachments: &'a [ImageView]) -> FramebufferCreateInfoBuilder<'a> {
        self.inner.attachment_count = attachments.len() as _;
        self.inner.p_attachments = attachments.as_ptr();
        self
    }
    pub fn width(mut self, width: u32) -> FramebufferCreateInfoBuilder<'a> {
        self.inner.width = width;
        self
    }
    pub fn height(mut self, height: u32) -> FramebufferCreateInfoBuilder<'a> {
        self.inner.height = height;
        self
    }
    pub fn layers(mut self, layers: u32) -> FramebufferCreateInfoBuilder<'a> {
        self.inner.layers = layers;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsFramebufferCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> FramebufferCreateInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> FramebufferCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDrawIndirectCommand.html>"]
pub struct DrawIndirectCommand {
    pub vertex_count: u32,
    pub instance_count: u32,
    pub first_vertex: u32,
    pub first_instance: u32,
}
impl DrawIndirectCommand {
    pub fn builder<'a>() -> DrawIndirectCommandBuilder<'a> {
        DrawIndirectCommandBuilder {
            inner: DrawIndirectCommand::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DrawIndirectCommandBuilder<'a> {
    inner: DrawIndirectCommand,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DrawIndirectCommandBuilder<'a> {
    type Target = DrawIndirectCommand;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DrawIndirectCommandBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DrawIndirectCommandBuilder<'a> {
    pub fn vertex_count(mut self, vertex_count: u32) -> DrawIndirectCommandBuilder<'a> {
        self.inner.vertex_count = vertex_count;
        self
    }
    pub fn instance_count(mut self, instance_count: u32) -> DrawIndirectCommandBuilder<'a> {
        self.inner.instance_count = instance_count;
        self
    }
    pub fn first_vertex(mut self, first_vertex: u32) -> DrawIndirectCommandBuilder<'a> {
        self.inner.first_vertex = first_vertex;
        self
    }
    pub fn first_instance(mut self, first_instance: u32) -> DrawIndirectCommandBuilder<'a> {
        self.inner.first_instance = first_instance;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DrawIndirectCommand {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDrawIndexedIndirectCommand.html>"]
pub struct DrawIndexedIndirectCommand {
    pub index_count: u32,
    pub instance_count: u32,
    pub first_index: u32,
    pub vertex_offset: i32,
    pub first_instance: u32,
}
impl DrawIndexedIndirectCommand {
    pub fn builder<'a>() -> DrawIndexedIndirectCommandBuilder<'a> {
        DrawIndexedIndirectCommandBuilder {
            inner: DrawIndexedIndirectCommand::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DrawIndexedIndirectCommandBuilder<'a> {
    inner: DrawIndexedIndirectCommand,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DrawIndexedIndirectCommandBuilder<'a> {
    type Target = DrawIndexedIndirectCommand;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DrawIndexedIndirectCommandBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DrawIndexedIndirectCommandBuilder<'a> {
    pub fn index_count(mut self, index_count: u32) -> DrawIndexedIndirectCommandBuilder<'a> {
        self.inner.index_count = index_count;
        self
    }
    pub fn instance_count(mut self, instance_count: u32) -> DrawIndexedIndirectCommandBuilder<'a> {
        self.inner.instance_count = instance_count;
        self
    }
    pub fn first_index(mut self, first_index: u32) -> DrawIndexedIndirectCommandBuilder<'a> {
        self.inner.first_index = first_index;
        self
    }
    pub fn vertex_offset(mut self, vertex_offset: i32) -> DrawIndexedIndirectCommandBuilder<'a> {
        self.inner.vertex_offset = vertex_offset;
        self
    }
    pub fn first_instance(mut self, first_instance: u32) -> DrawIndexedIndirectCommandBuilder<'a> {
        self.inner.first_instance = first_instance;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DrawIndexedIndirectCommand {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDispatchIndirectCommand.html>"]
pub struct DispatchIndirectCommand {
    pub x: u32,
    pub y: u32,
    pub z: u32,
}
impl DispatchIndirectCommand {
    pub fn builder<'a>() -> DispatchIndirectCommandBuilder<'a> {
        DispatchIndirectCommandBuilder {
            inner: DispatchIndirectCommand::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DispatchIndirectCommandBuilder<'a> {
    inner: DispatchIndirectCommand,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DispatchIndirectCommandBuilder<'a> {
    type Target = DispatchIndirectCommand;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DispatchIndirectCommandBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DispatchIndirectCommandBuilder<'a> {
    pub fn x(mut self, x: u32) -> DispatchIndirectCommandBuilder<'a> {
        self.inner.x = x;
        self
    }
    pub fn y(mut self, y: u32) -> DispatchIndirectCommandBuilder<'a> {
        self.inner.y = y;
        self
    }
    pub fn z(mut self, z: u32) -> DispatchIndirectCommandBuilder<'a> {
        self.inner.z = z;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DispatchIndirectCommand {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSubmitInfo.html>"]
pub struct SubmitInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub wait_semaphore_count: u32,
    pub p_wait_semaphores: *const Semaphore,
    pub p_wait_dst_stage_mask: *const PipelineStageFlags,
    pub command_buffer_count: u32,
    pub p_command_buffers: *const CommandBuffer,
    pub signal_semaphore_count: u32,
    pub p_signal_semaphores: *const Semaphore,
}
impl ::std::default::Default for SubmitInfo {
    fn default() -> SubmitInfo {
        SubmitInfo {
            s_type: StructureType::SUBMIT_INFO,
            p_next: ::std::ptr::null(),
            wait_semaphore_count: u32::default(),
            p_wait_semaphores: ::std::ptr::null(),
            p_wait_dst_stage_mask: ::std::ptr::null(),
            command_buffer_count: u32::default(),
            p_command_buffers: ::std::ptr::null(),
            signal_semaphore_count: u32::default(),
            p_signal_semaphores: ::std::ptr::null(),
        }
    }
}
impl SubmitInfo {
    pub fn builder<'a>() -> SubmitInfoBuilder<'a> {
        SubmitInfoBuilder {
            inner: SubmitInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SubmitInfoBuilder<'a> {
    inner: SubmitInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsSubmitInfo {}
impl<'a> ::std::ops::Deref for SubmitInfoBuilder<'a> {
    type Target = SubmitInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SubmitInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SubmitInfoBuilder<'a> {
    pub fn wait_semaphores(mut self, wait_semaphores: &'a [Semaphore]) -> SubmitInfoBuilder<'a> {
        self.inner.wait_semaphore_count = wait_semaphores.len() as _;
        self.inner.p_wait_semaphores = wait_semaphores.as_ptr();
        self
    }
    pub fn wait_dst_stage_mask(
        mut self,
        wait_dst_stage_mask: &'a [PipelineStageFlags],
    ) -> SubmitInfoBuilder<'a> {
        self.inner.wait_semaphore_count = wait_dst_stage_mask.len() as _;
        self.inner.p_wait_dst_stage_mask = wait_dst_stage_mask.as_ptr();
        self
    }
    pub fn command_buffers(
        mut self,
        command_buffers: &'a [CommandBuffer],
    ) -> SubmitInfoBuilder<'a> {
        self.inner.command_buffer_count = command_buffers.len() as _;
        self.inner.p_command_buffers = command_buffers.as_ptr();
        self
    }
    pub fn signal_semaphores(
        mut self,
        signal_semaphores: &'a [Semaphore],
    ) -> SubmitInfoBuilder<'a> {
        self.inner.signal_semaphore_count = signal_semaphores.len() as _;
        self.inner.p_signal_semaphores = signal_semaphores.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSubmitInfo>(mut self, next: &'a mut T) -> SubmitInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SubmitInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayPropertiesKHR.html>"]
pub struct DisplayPropertiesKHR {
    pub display: DisplayKHR,
    pub display_name: *const c_char,
    pub physical_dimensions: Extent2D,
    pub physical_resolution: Extent2D,
    pub supported_transforms: SurfaceTransformFlagsKHR,
    pub plane_reorder_possible: Bool32,
    pub persistent_content: Bool32,
}
impl ::std::default::Default for DisplayPropertiesKHR {
    fn default() -> DisplayPropertiesKHR {
        DisplayPropertiesKHR {
            display: DisplayKHR::default(),
            display_name: ::std::ptr::null(),
            physical_dimensions: Extent2D::default(),
            physical_resolution: Extent2D::default(),
            supported_transforms: SurfaceTransformFlagsKHR::default(),
            plane_reorder_possible: Bool32::default(),
            persistent_content: Bool32::default(),
        }
    }
}
impl DisplayPropertiesKHR {
    pub fn builder<'a>() -> DisplayPropertiesKHRBuilder<'a> {
        DisplayPropertiesKHRBuilder {
            inner: DisplayPropertiesKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayPropertiesKHRBuilder<'a> {
    inner: DisplayPropertiesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplayPropertiesKHRBuilder<'a> {
    type Target = DisplayPropertiesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayPropertiesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayPropertiesKHRBuilder<'a> {
    pub fn display(mut self, display: DisplayKHR) -> DisplayPropertiesKHRBuilder<'a> {
        self.inner.display = display;
        self
    }
    pub fn display_name(mut self, display_name: *const c_char) -> DisplayPropertiesKHRBuilder<'a> {
        self.inner.display_name = display_name;
        self
    }
    pub fn physical_dimensions(
        mut self,
        physical_dimensions: Extent2D,
    ) -> DisplayPropertiesKHRBuilder<'a> {
        self.inner.physical_dimensions = physical_dimensions;
        self
    }
    pub fn physical_resolution(
        mut self,
        physical_resolution: Extent2D,
    ) -> DisplayPropertiesKHRBuilder<'a> {
        self.inner.physical_resolution = physical_resolution;
        self
    }
    pub fn supported_transforms(
        mut self,
        supported_transforms: SurfaceTransformFlagsKHR,
    ) -> DisplayPropertiesKHRBuilder<'a> {
        self.inner.supported_transforms = supported_transforms;
        self
    }
    pub fn plane_reorder_possible(
        mut self,
        plane_reorder_possible: bool,
    ) -> DisplayPropertiesKHRBuilder<'a> {
        self.inner.plane_reorder_possible = plane_reorder_possible.into();
        self
    }
    pub fn persistent_content(
        mut self,
        persistent_content: bool,
    ) -> DisplayPropertiesKHRBuilder<'a> {
        self.inner.persistent_content = persistent_content.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayPropertiesKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayPlanePropertiesKHR.html>"]
pub struct DisplayPlanePropertiesKHR {
    pub current_display: DisplayKHR,
    pub current_stack_index: u32,
}
impl DisplayPlanePropertiesKHR {
    pub fn builder<'a>() -> DisplayPlanePropertiesKHRBuilder<'a> {
        DisplayPlanePropertiesKHRBuilder {
            inner: DisplayPlanePropertiesKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayPlanePropertiesKHRBuilder<'a> {
    inner: DisplayPlanePropertiesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplayPlanePropertiesKHRBuilder<'a> {
    type Target = DisplayPlanePropertiesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayPlanePropertiesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayPlanePropertiesKHRBuilder<'a> {
    pub fn current_display(
        mut self,
        current_display: DisplayKHR,
    ) -> DisplayPlanePropertiesKHRBuilder<'a> {
        self.inner.current_display = current_display;
        self
    }
    pub fn current_stack_index(
        mut self,
        current_stack_index: u32,
    ) -> DisplayPlanePropertiesKHRBuilder<'a> {
        self.inner.current_stack_index = current_stack_index;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayPlanePropertiesKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayModeParametersKHR.html>"]
pub struct DisplayModeParametersKHR {
    pub visible_region: Extent2D,
    pub refresh_rate: u32,
}
impl DisplayModeParametersKHR {
    pub fn builder<'a>() -> DisplayModeParametersKHRBuilder<'a> {
        DisplayModeParametersKHRBuilder {
            inner: DisplayModeParametersKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayModeParametersKHRBuilder<'a> {
    inner: DisplayModeParametersKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplayModeParametersKHRBuilder<'a> {
    type Target = DisplayModeParametersKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayModeParametersKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayModeParametersKHRBuilder<'a> {
    pub fn visible_region(
        mut self,
        visible_region: Extent2D,
    ) -> DisplayModeParametersKHRBuilder<'a> {
        self.inner.visible_region = visible_region;
        self
    }
    pub fn refresh_rate(mut self, refresh_rate: u32) -> DisplayModeParametersKHRBuilder<'a> {
        self.inner.refresh_rate = refresh_rate;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayModeParametersKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayModePropertiesKHR.html>"]
pub struct DisplayModePropertiesKHR {
    pub display_mode: DisplayModeKHR,
    pub parameters: DisplayModeParametersKHR,
}
impl DisplayModePropertiesKHR {
    pub fn builder<'a>() -> DisplayModePropertiesKHRBuilder<'a> {
        DisplayModePropertiesKHRBuilder {
            inner: DisplayModePropertiesKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayModePropertiesKHRBuilder<'a> {
    inner: DisplayModePropertiesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplayModePropertiesKHRBuilder<'a> {
    type Target = DisplayModePropertiesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayModePropertiesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayModePropertiesKHRBuilder<'a> {
    pub fn display_mode(
        mut self,
        display_mode: DisplayModeKHR,
    ) -> DisplayModePropertiesKHRBuilder<'a> {
        self.inner.display_mode = display_mode;
        self
    }
    pub fn parameters(
        mut self,
        parameters: DisplayModeParametersKHR,
    ) -> DisplayModePropertiesKHRBuilder<'a> {
        self.inner.parameters = parameters;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayModePropertiesKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayModeCreateInfoKHR.html>"]
pub struct DisplayModeCreateInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DisplayModeCreateFlagsKHR,
    pub parameters: DisplayModeParametersKHR,
}
impl ::std::default::Default for DisplayModeCreateInfoKHR {
    fn default() -> DisplayModeCreateInfoKHR {
        DisplayModeCreateInfoKHR {
            s_type: StructureType::DISPLAY_MODE_CREATE_INFO_KHR,
            p_next: ::std::ptr::null(),
            flags: DisplayModeCreateFlagsKHR::default(),
            parameters: DisplayModeParametersKHR::default(),
        }
    }
}
impl DisplayModeCreateInfoKHR {
    pub fn builder<'a>() -> DisplayModeCreateInfoKHRBuilder<'a> {
        DisplayModeCreateInfoKHRBuilder {
            inner: DisplayModeCreateInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayModeCreateInfoKHRBuilder<'a> {
    inner: DisplayModeCreateInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsDisplayModeCreateInfoKHR {}
impl<'a> ::std::ops::Deref for DisplayModeCreateInfoKHRBuilder<'a> {
    type Target = DisplayModeCreateInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayModeCreateInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayModeCreateInfoKHRBuilder<'a> {
    pub fn flags(
        mut self,
        flags: DisplayModeCreateFlagsKHR,
    ) -> DisplayModeCreateInfoKHRBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn parameters(
        mut self,
        parameters: DisplayModeParametersKHR,
    ) -> DisplayModeCreateInfoKHRBuilder<'a> {
        self.inner.parameters = parameters;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDisplayModeCreateInfoKHR>(
        mut self,
        next: &'a mut T,
    ) -> DisplayModeCreateInfoKHRBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayModeCreateInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayPlaneCapabilitiesKHR.html>"]
pub struct DisplayPlaneCapabilitiesKHR {
    pub supported_alpha: DisplayPlaneAlphaFlagsKHR,
    pub min_src_position: Offset2D,
    pub max_src_position: Offset2D,
    pub min_src_extent: Extent2D,
    pub max_src_extent: Extent2D,
    pub min_dst_position: Offset2D,
    pub max_dst_position: Offset2D,
    pub min_dst_extent: Extent2D,
    pub max_dst_extent: Extent2D,
}
impl DisplayPlaneCapabilitiesKHR {
    pub fn builder<'a>() -> DisplayPlaneCapabilitiesKHRBuilder<'a> {
        DisplayPlaneCapabilitiesKHRBuilder {
            inner: DisplayPlaneCapabilitiesKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayPlaneCapabilitiesKHRBuilder<'a> {
    inner: DisplayPlaneCapabilitiesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplayPlaneCapabilitiesKHRBuilder<'a> {
    type Target = DisplayPlaneCapabilitiesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayPlaneCapabilitiesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayPlaneCapabilitiesKHRBuilder<'a> {
    pub fn supported_alpha(
        mut self,
        supported_alpha: DisplayPlaneAlphaFlagsKHR,
    ) -> DisplayPlaneCapabilitiesKHRBuilder<'a> {
        self.inner.supported_alpha = supported_alpha;
        self
    }
    pub fn min_src_position(
        mut self,
        min_src_position: Offset2D,
    ) -> DisplayPlaneCapabilitiesKHRBuilder<'a> {
        self.inner.min_src_position = min_src_position;
        self
    }
    pub fn max_src_position(
        mut self,
        max_src_position: Offset2D,
    ) -> DisplayPlaneCapabilitiesKHRBuilder<'a> {
        self.inner.max_src_position = max_src_position;
        self
    }
    pub fn min_src_extent(
        mut self,
        min_src_extent: Extent2D,
    ) -> DisplayPlaneCapabilitiesKHRBuilder<'a> {
        self.inner.min_src_extent = min_src_extent;
        self
    }
    pub fn max_src_extent(
        mut self,
        max_src_extent: Extent2D,
    ) -> DisplayPlaneCapabilitiesKHRBuilder<'a> {
        self.inner.max_src_extent = max_src_extent;
        self
    }
    pub fn min_dst_position(
        mut self,
        min_dst_position: Offset2D,
    ) -> DisplayPlaneCapabilitiesKHRBuilder<'a> {
        self.inner.min_dst_position = min_dst_position;
        self
    }
    pub fn max_dst_position(
        mut self,
        max_dst_position: Offset2D,
    ) -> DisplayPlaneCapabilitiesKHRBuilder<'a> {
        self.inner.max_dst_position = max_dst_position;
        self
    }
    pub fn min_dst_extent(
        mut self,
        min_dst_extent: Extent2D,
    ) -> DisplayPlaneCapabilitiesKHRBuilder<'a> {
        self.inner.min_dst_extent = min_dst_extent;
        self
    }
    pub fn max_dst_extent(
        mut self,
        max_dst_extent: Extent2D,
    ) -> DisplayPlaneCapabilitiesKHRBuilder<'a> {
        self.inner.max_dst_extent = max_dst_extent;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayPlaneCapabilitiesKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplaySurfaceCreateInfoKHR.html>"]
pub struct DisplaySurfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DisplaySurfaceCreateFlagsKHR,
    pub display_mode: DisplayModeKHR,
    pub plane_index: u32,
    pub plane_stack_index: u32,
    pub transform: SurfaceTransformFlagsKHR,
    pub global_alpha: f32,
    pub alpha_mode: DisplayPlaneAlphaFlagsKHR,
    pub image_extent: Extent2D,
}
impl ::std::default::Default for DisplaySurfaceCreateInfoKHR {
    fn default() -> DisplaySurfaceCreateInfoKHR {
        DisplaySurfaceCreateInfoKHR {
            s_type: StructureType::DISPLAY_SURFACE_CREATE_INFO_KHR,
            p_next: ::std::ptr::null(),
            flags: DisplaySurfaceCreateFlagsKHR::default(),
            display_mode: DisplayModeKHR::default(),
            plane_index: u32::default(),
            plane_stack_index: u32::default(),
            transform: SurfaceTransformFlagsKHR::default(),
            global_alpha: f32::default(),
            alpha_mode: DisplayPlaneAlphaFlagsKHR::default(),
            image_extent: Extent2D::default(),
        }
    }
}
impl DisplaySurfaceCreateInfoKHR {
    pub fn builder<'a>() -> DisplaySurfaceCreateInfoKHRBuilder<'a> {
        DisplaySurfaceCreateInfoKHRBuilder {
            inner: DisplaySurfaceCreateInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplaySurfaceCreateInfoKHRBuilder<'a> {
    inner: DisplaySurfaceCreateInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsDisplaySurfaceCreateInfoKHR {}
impl<'a> ::std::ops::Deref for DisplaySurfaceCreateInfoKHRBuilder<'a> {
    type Target = DisplaySurfaceCreateInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplaySurfaceCreateInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplaySurfaceCreateInfoKHRBuilder<'a> {
    pub fn flags(
        mut self,
        flags: DisplaySurfaceCreateFlagsKHR,
    ) -> DisplaySurfaceCreateInfoKHRBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn display_mode(
        mut self,
        display_mode: DisplayModeKHR,
    ) -> DisplaySurfaceCreateInfoKHRBuilder<'a> {
        self.inner.display_mode = display_mode;
        self
    }
    pub fn plane_index(mut self, plane_index: u32) -> DisplaySurfaceCreateInfoKHRBuilder<'a> {
        self.inner.plane_index = plane_index;
        self
    }
    pub fn plane_stack_index(
        mut self,
        plane_stack_index: u32,
    ) -> DisplaySurfaceCreateInfoKHRBuilder<'a> {
        self.inner.plane_stack_index = plane_stack_index;
        self
    }
    pub fn transform(
        mut self,
        transform: SurfaceTransformFlagsKHR,
    ) -> DisplaySurfaceCreateInfoKHRBuilder<'a> {
        self.inner.transform = transform;
        self
    }
    pub fn global_alpha(mut self, global_alpha: f32) -> DisplaySurfaceCreateInfoKHRBuilder<'a> {
        self.inner.global_alpha = global_alpha;
        self
    }
    pub fn alpha_mode(
        mut self,
        alpha_mode: DisplayPlaneAlphaFlagsKHR,
    ) -> DisplaySurfaceCreateInfoKHRBuilder<'a> {
        self.inner.alpha_mode = alpha_mode;
        self
    }
    pub fn image_extent(
        mut self,
        image_extent: Extent2D,
    ) -> DisplaySurfaceCreateInfoKHRBuilder<'a> {
        self.inner.image_extent = image_extent;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDisplaySurfaceCreateInfoKHR>(
        mut self,
        next: &'a mut T,
    ) -> DisplaySurfaceCreateInfoKHRBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplaySurfaceCreateInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDisplayPresentInfoKHR.html>"]
pub struct DisplayPresentInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub src_rect: Rect2D,
    pub dst_rect: Rect2D,
    pub persistent: Bool32,
}
impl ::std::default::Default for DisplayPresentInfoKHR {
    fn default() -> DisplayPresentInfoKHR {
        DisplayPresentInfoKHR {
            s_type: StructureType::DISPLAY_PRESENT_INFO_KHR,
            p_next: ::std::ptr::null(),
            src_rect: Rect2D::default(),
            dst_rect: Rect2D::default(),
            persistent: Bool32::default(),
        }
    }
}
impl DisplayPresentInfoKHR {
    pub fn builder<'a>() -> DisplayPresentInfoKHRBuilder<'a> {
        DisplayPresentInfoKHRBuilder {
            inner: DisplayPresentInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayPresentInfoKHRBuilder<'a> {
    inner: DisplayPresentInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPresentInfoKHR for DisplayPresentInfoKHRBuilder<'_> {}
unsafe impl ExtendsPresentInfoKHR for DisplayPresentInfoKHR {}
impl<'a> ::std::ops::Deref for DisplayPresentInfoKHRBuilder<'a> {
    type Target = DisplayPresentInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayPresentInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayPresentInfoKHRBuilder<'a> {
    pub fn src_rect(mut self, src_rect: Rect2D) -> DisplayPresentInfoKHRBuilder<'a> {
        self.inner.src_rect = src_rect;
        self
    }
    pub fn dst_rect(mut self, dst_rect: Rect2D) -> DisplayPresentInfoKHRBuilder<'a> {
        self.inner.dst_rect = dst_rect;
        self
    }
    pub fn persistent(mut self, persistent: bool) -> DisplayPresentInfoKHRBuilder<'a> {
        self.inner.persistent = persistent.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayPresentInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSurfaceCapabilitiesKHR.html>"]
pub struct SurfaceCapabilitiesKHR {
    pub min_image_count: u32,
    pub max_image_count: u32,
    pub current_extent: Extent2D,
    pub min_image_extent: Extent2D,
    pub max_image_extent: Extent2D,
    pub max_image_array_layers: u32,
    pub supported_transforms: SurfaceTransformFlagsKHR,
    pub current_transform: SurfaceTransformFlagsKHR,
    pub supported_composite_alpha: CompositeAlphaFlagsKHR,
    pub supported_usage_flags: ImageUsageFlags,
}
impl SurfaceCapabilitiesKHR {
    pub fn builder<'a>() -> SurfaceCapabilitiesKHRBuilder<'a> {
        SurfaceCapabilitiesKHRBuilder {
            inner: SurfaceCapabilitiesKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SurfaceCapabilitiesKHRBuilder<'a> {
    inner: SurfaceCapabilitiesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SurfaceCapabilitiesKHRBuilder<'a> {
    type Target = SurfaceCapabilitiesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SurfaceCapabilitiesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SurfaceCapabilitiesKHRBuilder<'a> {
    pub fn min_image_count(mut self, min_image_count: u32) -> SurfaceCapabilitiesKHRBuilder<'a> {
        self.inner.min_image_count = min_image_count;
        self
    }
    pub fn max_image_count(mut self, max_image_count: u32) -> SurfaceCapabilitiesKHRBuilder<'a> {
        self.inner.max_image_count = max_image_count;
        self
    }
    pub fn current_extent(mut self, current_extent: Extent2D) -> SurfaceCapabilitiesKHRBuilder<'a> {
        self.inner.current_extent = current_extent;
        self
    }
    pub fn min_image_extent(
        mut self,
        min_image_extent: Extent2D,
    ) -> SurfaceCapabilitiesKHRBuilder<'a> {
        self.inner.min_image_extent = min_image_extent;
        self
    }
    pub fn max_image_extent(
        mut self,
        max_image_extent: Extent2D,
    ) -> SurfaceCapabilitiesKHRBuilder<'a> {
        self.inner.max_image_extent = max_image_extent;
        self
    }
    pub fn max_image_array_layers(
        mut self,
        max_image_array_layers: u32,
    ) -> SurfaceCapabilitiesKHRBuilder<'a> {
        self.inner.max_image_array_layers = max_image_array_layers;
        self
    }
    pub fn supported_transforms(
        mut self,
        supported_transforms: SurfaceTransformFlagsKHR,
    ) -> SurfaceCapabilitiesKHRBuilder<'a> {
        self.inner.supported_transforms = supported_transforms;
        self
    }
    pub fn current_transform(
        mut self,
        current_transform: SurfaceTransformFlagsKHR,
    ) -> SurfaceCapabilitiesKHRBuilder<'a> {
        self.inner.current_transform = current_transform;
        self
    }
    pub fn supported_composite_alpha(
        mut self,
        supported_composite_alpha: CompositeAlphaFlagsKHR,
    ) -> SurfaceCapabilitiesKHRBuilder<'a> {
        self.inner.supported_composite_alpha = supported_composite_alpha;
        self
    }
    pub fn supported_usage_flags(
        mut self,
        supported_usage_flags: ImageUsageFlags,
    ) -> SurfaceCapabilitiesKHRBuilder<'a> {
        self.inner.supported_usage_flags = supported_usage_flags;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SurfaceCapabilitiesKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkAndroidSurfaceCreateInfoKHR.html>"]
pub struct AndroidSurfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: AndroidSurfaceCreateFlagsKHR,
    pub window: *mut ANativeWindow,
}
impl ::std::default::Default for AndroidSurfaceCreateInfoKHR {
    fn default() -> AndroidSurfaceCreateInfoKHR {
        AndroidSurfaceCreateInfoKHR {
            s_type: StructureType::ANDROID_SURFACE_CREATE_INFO_KHR,
            p_next: ::std::ptr::null(),
            flags: AndroidSurfaceCreateFlagsKHR::default(),
            window: ::std::ptr::null_mut(),
        }
    }
}
impl AndroidSurfaceCreateInfoKHR {
    pub fn builder<'a>() -> AndroidSurfaceCreateInfoKHRBuilder<'a> {
        AndroidSurfaceCreateInfoKHRBuilder {
            inner: AndroidSurfaceCreateInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct AndroidSurfaceCreateInfoKHRBuilder<'a> {
    inner: AndroidSurfaceCreateInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsAndroidSurfaceCreateInfoKHR {}
impl<'a> ::std::ops::Deref for AndroidSurfaceCreateInfoKHRBuilder<'a> {
    type Target = AndroidSurfaceCreateInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for AndroidSurfaceCreateInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> AndroidSurfaceCreateInfoKHRBuilder<'a> {
    pub fn flags(
        mut self,
        flags: AndroidSurfaceCreateFlagsKHR,
    ) -> AndroidSurfaceCreateInfoKHRBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn window(mut self, window: *mut ANativeWindow) -> AndroidSurfaceCreateInfoKHRBuilder<'a> {
        self.inner.window = window;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsAndroidSurfaceCreateInfoKHR>(
        mut self,
        next: &'a mut T,
    ) -> AndroidSurfaceCreateInfoKHRBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> AndroidSurfaceCreateInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkViSurfaceCreateInfoNN.html>"]
pub struct ViSurfaceCreateInfoNN {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ViSurfaceCreateFlagsNN,
    pub window: *mut c_void,
}
impl ::std::default::Default for ViSurfaceCreateInfoNN {
    fn default() -> ViSurfaceCreateInfoNN {
        ViSurfaceCreateInfoNN {
            s_type: StructureType::VI_SURFACE_CREATE_INFO_NN,
            p_next: ::std::ptr::null(),
            flags: ViSurfaceCreateFlagsNN::default(),
            window: ::std::ptr::null_mut(),
        }
    }
}
impl ViSurfaceCreateInfoNN {
    pub fn builder<'a>() -> ViSurfaceCreateInfoNNBuilder<'a> {
        ViSurfaceCreateInfoNNBuilder {
            inner: ViSurfaceCreateInfoNN::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ViSurfaceCreateInfoNNBuilder<'a> {
    inner: ViSurfaceCreateInfoNN,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsViSurfaceCreateInfoNN {}
impl<'a> ::std::ops::Deref for ViSurfaceCreateInfoNNBuilder<'a> {
    type Target = ViSurfaceCreateInfoNN;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ViSurfaceCreateInfoNNBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ViSurfaceCreateInfoNNBuilder<'a> {
    pub fn flags(mut self, flags: ViSurfaceCreateFlagsNN) -> ViSurfaceCreateInfoNNBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn window(mut self, window: *mut c_void) -> ViSurfaceCreateInfoNNBuilder<'a> {
        self.inner.window = window;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsViSurfaceCreateInfoNN>(
        mut self,
        next: &'a mut T,
    ) -> ViSurfaceCreateInfoNNBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ViSurfaceCreateInfoNN {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkWaylandSurfaceCreateInfoKHR.html>"]
pub struct WaylandSurfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: WaylandSurfaceCreateFlagsKHR,
    pub display: *mut wl_display,
    pub surface: *mut wl_surface,
}
impl ::std::default::Default for WaylandSurfaceCreateInfoKHR {
    fn default() -> WaylandSurfaceCreateInfoKHR {
        WaylandSurfaceCreateInfoKHR {
            s_type: StructureType::WAYLAND_SURFACE_CREATE_INFO_KHR,
            p_next: ::std::ptr::null(),
            flags: WaylandSurfaceCreateFlagsKHR::default(),
            display: ::std::ptr::null_mut(),
            surface: ::std::ptr::null_mut(),
        }
    }
}
impl WaylandSurfaceCreateInfoKHR {
    pub fn builder<'a>() -> WaylandSurfaceCreateInfoKHRBuilder<'a> {
        WaylandSurfaceCreateInfoKHRBuilder {
            inner: WaylandSurfaceCreateInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct WaylandSurfaceCreateInfoKHRBuilder<'a> {
    inner: WaylandSurfaceCreateInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsWaylandSurfaceCreateInfoKHR {}
impl<'a> ::std::ops::Deref for WaylandSurfaceCreateInfoKHRBuilder<'a> {
    type Target = WaylandSurfaceCreateInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for WaylandSurfaceCreateInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> WaylandSurfaceCreateInfoKHRBuilder<'a> {
    pub fn flags(
        mut self,
        flags: WaylandSurfaceCreateFlagsKHR,
    ) -> WaylandSurfaceCreateInfoKHRBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn display(mut self, display: *mut wl_display) -> WaylandSurfaceCreateInfoKHRBuilder<'a> {
        self.inner.display = display;
        self
    }
    pub fn surface(mut self, surface: *mut wl_surface) -> WaylandSurfaceCreateInfoKHRBuilder<'a> {
        self.inner.surface = surface;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsWaylandSurfaceCreateInfoKHR>(
        mut self,
        next: &'a mut T,
    ) -> WaylandSurfaceCreateInfoKHRBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> WaylandSurfaceCreateInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkWin32SurfaceCreateInfoKHR.html>"]
pub struct Win32SurfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: Win32SurfaceCreateFlagsKHR,
    pub hinstance: HINSTANCE,
    pub hwnd: HWND,
}
impl ::std::default::Default for Win32SurfaceCreateInfoKHR {
    fn default() -> Win32SurfaceCreateInfoKHR {
        Win32SurfaceCreateInfoKHR {
            s_type: StructureType::WIN32_SURFACE_CREATE_INFO_KHR,
            p_next: ::std::ptr::null(),
            flags: Win32SurfaceCreateFlagsKHR::default(),
            hinstance: unsafe { ::std::mem::zeroed() },
            hwnd: unsafe { ::std::mem::zeroed() },
        }
    }
}
impl Win32SurfaceCreateInfoKHR {
    pub fn builder<'a>() -> Win32SurfaceCreateInfoKHRBuilder<'a> {
        Win32SurfaceCreateInfoKHRBuilder {
            inner: Win32SurfaceCreateInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct Win32SurfaceCreateInfoKHRBuilder<'a> {
    inner: Win32SurfaceCreateInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsWin32SurfaceCreateInfoKHR {}
impl<'a> ::std::ops::Deref for Win32SurfaceCreateInfoKHRBuilder<'a> {
    type Target = Win32SurfaceCreateInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for Win32SurfaceCreateInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> Win32SurfaceCreateInfoKHRBuilder<'a> {
    pub fn flags(
        mut self,
        flags: Win32SurfaceCreateFlagsKHR,
    ) -> Win32SurfaceCreateInfoKHRBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn hinstance(mut self, hinstance: HINSTANCE) -> Win32SurfaceCreateInfoKHRBuilder<'a> {
        self.inner.hinstance = hinstance;
        self
    }
    pub fn hwnd(mut self, hwnd: HWND) -> Win32SurfaceCreateInfoKHRBuilder<'a> {
        self.inner.hwnd = hwnd;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsWin32SurfaceCreateInfoKHR>(
        mut self,
        next: &'a mut T,
    ) -> Win32SurfaceCreateInfoKHRBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> Win32SurfaceCreateInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkXlibSurfaceCreateInfoKHR.html>"]
pub struct XlibSurfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: XlibSurfaceCreateFlagsKHR,
    pub dpy: *mut Display,
    pub window: Window,
}
impl ::std::default::Default for XlibSurfaceCreateInfoKHR {
    fn default() -> XlibSurfaceCreateInfoKHR {
        XlibSurfaceCreateInfoKHR {
            s_type: StructureType::XLIB_SURFACE_CREATE_INFO_KHR,
            p_next: ::std::ptr::null(),
            flags: XlibSurfaceCreateFlagsKHR::default(),
            dpy: ::std::ptr::null_mut(),
            window: Window::default(),
        }
    }
}
impl XlibSurfaceCreateInfoKHR {
    pub fn builder<'a>() -> XlibSurfaceCreateInfoKHRBuilder<'a> {
        XlibSurfaceCreateInfoKHRBuilder {
            inner: XlibSurfaceCreateInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct XlibSurfaceCreateInfoKHRBuilder<'a> {
    inner: XlibSurfaceCreateInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsXlibSurfaceCreateInfoKHR {}
impl<'a> ::std::ops::Deref for XlibSurfaceCreateInfoKHRBuilder<'a> {
    type Target = XlibSurfaceCreateInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for XlibSurfaceCreateInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> XlibSurfaceCreateInfoKHRBuilder<'a> {
    pub fn flags(
        mut self,
        flags: XlibSurfaceCreateFlagsKHR,
    ) -> XlibSurfaceCreateInfoKHRBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn dpy(mut self, dpy: *mut Display) -> XlibSurfaceCreateInfoKHRBuilder<'a> {
        self.inner.dpy = dpy;
        self
    }
    pub fn window(mut self, window: Window) -> XlibSurfaceCreateInfoKHRBuilder<'a> {
        self.inner.window = window;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsXlibSurfaceCreateInfoKHR>(
        mut self,
        next: &'a mut T,
    ) -> XlibSurfaceCreateInfoKHRBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> XlibSurfaceCreateInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkXcbSurfaceCreateInfoKHR.html>"]
pub struct XcbSurfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: XcbSurfaceCreateFlagsKHR,
    pub connection: *mut xcb_connection_t,
    pub window: xcb_window_t,
}
impl ::std::default::Default for XcbSurfaceCreateInfoKHR {
    fn default() -> XcbSurfaceCreateInfoKHR {
        XcbSurfaceCreateInfoKHR {
            s_type: StructureType::XCB_SURFACE_CREATE_INFO_KHR,
            p_next: ::std::ptr::null(),
            flags: XcbSurfaceCreateFlagsKHR::default(),
            connection: ::std::ptr::null_mut(),
            window: xcb_window_t::default(),
        }
    }
}
impl XcbSurfaceCreateInfoKHR {
    pub fn builder<'a>() -> XcbSurfaceCreateInfoKHRBuilder<'a> {
        XcbSurfaceCreateInfoKHRBuilder {
            inner: XcbSurfaceCreateInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct XcbSurfaceCreateInfoKHRBuilder<'a> {
    inner: XcbSurfaceCreateInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsXcbSurfaceCreateInfoKHR {}
impl<'a> ::std::ops::Deref for XcbSurfaceCreateInfoKHRBuilder<'a> {
    type Target = XcbSurfaceCreateInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for XcbSurfaceCreateInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> XcbSurfaceCreateInfoKHRBuilder<'a> {
    pub fn flags(mut self, flags: XcbSurfaceCreateFlagsKHR) -> XcbSurfaceCreateInfoKHRBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn connection(
        mut self,
        connection: *mut xcb_connection_t,
    ) -> XcbSurfaceCreateInfoKHRBuilder<'a> {
        self.inner.connection = connection;
        self
    }
    pub fn window(mut self, window: xcb_window_t) -> XcbSurfaceCreateInfoKHRBuilder<'a> {
        self.inner.window = window;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsXcbSurfaceCreateInfoKHR>(
        mut self,
        next: &'a mut T,
    ) -> XcbSurfaceCreateInfoKHRBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> XcbSurfaceCreateInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImagePipeSurfaceCreateInfoFUCHSIA.html>"]
pub struct ImagePipeSurfaceCreateInfoFUCHSIA {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ImagePipeSurfaceCreateFlagsFUCHSIA,
    pub image_pipe_handle: zx_handle_t,
}
impl ::std::default::Default for ImagePipeSurfaceCreateInfoFUCHSIA {
    fn default() -> ImagePipeSurfaceCreateInfoFUCHSIA {
        ImagePipeSurfaceCreateInfoFUCHSIA {
            s_type: StructureType::IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA,
            p_next: ::std::ptr::null(),
            flags: ImagePipeSurfaceCreateFlagsFUCHSIA::default(),
            image_pipe_handle: zx_handle_t::default(),
        }
    }
}
impl ImagePipeSurfaceCreateInfoFUCHSIA {
    pub fn builder<'a>() -> ImagePipeSurfaceCreateInfoFUCHSIABuilder<'a> {
        ImagePipeSurfaceCreateInfoFUCHSIABuilder {
            inner: ImagePipeSurfaceCreateInfoFUCHSIA::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImagePipeSurfaceCreateInfoFUCHSIABuilder<'a> {
    inner: ImagePipeSurfaceCreateInfoFUCHSIA,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsImagePipeSurfaceCreateInfoFUCHSIA {}
impl<'a> ::std::ops::Deref for ImagePipeSurfaceCreateInfoFUCHSIABuilder<'a> {
    type Target = ImagePipeSurfaceCreateInfoFUCHSIA;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImagePipeSurfaceCreateInfoFUCHSIABuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImagePipeSurfaceCreateInfoFUCHSIABuilder<'a> {
    pub fn flags(
        mut self,
        flags: ImagePipeSurfaceCreateFlagsFUCHSIA,
    ) -> ImagePipeSurfaceCreateInfoFUCHSIABuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn image_pipe_handle(
        mut self,
        image_pipe_handle: zx_handle_t,
    ) -> ImagePipeSurfaceCreateInfoFUCHSIABuilder<'a> {
        self.inner.image_pipe_handle = image_pipe_handle;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsImagePipeSurfaceCreateInfoFUCHSIA>(
        mut self,
        next: &'a mut T,
    ) -> ImagePipeSurfaceCreateInfoFUCHSIABuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImagePipeSurfaceCreateInfoFUCHSIA {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkStreamDescriptorSurfaceCreateInfoGGP.html>"]
pub struct StreamDescriptorSurfaceCreateInfoGGP {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: StreamDescriptorSurfaceCreateFlagsGGP,
    pub stream_descriptor: GgpStreamDescriptor,
}
impl ::std::default::Default for StreamDescriptorSurfaceCreateInfoGGP {
    fn default() -> StreamDescriptorSurfaceCreateInfoGGP {
        StreamDescriptorSurfaceCreateInfoGGP {
            s_type: StructureType::STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP,
            p_next: ::std::ptr::null(),
            flags: StreamDescriptorSurfaceCreateFlagsGGP::default(),
            stream_descriptor: GgpStreamDescriptor::default(),
        }
    }
}
impl StreamDescriptorSurfaceCreateInfoGGP {
    pub fn builder<'a>() -> StreamDescriptorSurfaceCreateInfoGGPBuilder<'a> {
        StreamDescriptorSurfaceCreateInfoGGPBuilder {
            inner: StreamDescriptorSurfaceCreateInfoGGP::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct StreamDescriptorSurfaceCreateInfoGGPBuilder<'a> {
    inner: StreamDescriptorSurfaceCreateInfoGGP,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsStreamDescriptorSurfaceCreateInfoGGP {}
impl<'a> ::std::ops::Deref for StreamDescriptorSurfaceCreateInfoGGPBuilder<'a> {
    type Target = StreamDescriptorSurfaceCreateInfoGGP;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for StreamDescriptorSurfaceCreateInfoGGPBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> StreamDescriptorSurfaceCreateInfoGGPBuilder<'a> {
    pub fn flags(
        mut self,
        flags: StreamDescriptorSurfaceCreateFlagsGGP,
    ) -> StreamDescriptorSurfaceCreateInfoGGPBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn stream_descriptor(
        mut self,
        stream_descriptor: GgpStreamDescriptor,
    ) -> StreamDescriptorSurfaceCreateInfoGGPBuilder<'a> {
        self.inner.stream_descriptor = stream_descriptor;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsStreamDescriptorSurfaceCreateInfoGGP>(
        mut self,
        next: &'a mut T,
    ) -> StreamDescriptorSurfaceCreateInfoGGPBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> StreamDescriptorSurfaceCreateInfoGGP {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug, PartialEq, Eq, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSurfaceFormatKHR.html>"]
pub struct SurfaceFormatKHR {
    pub format: Format,
    pub color_space: ColorSpaceKHR,
}
impl SurfaceFormatKHR {
    pub fn builder<'a>() -> SurfaceFormatKHRBuilder<'a> {
        SurfaceFormatKHRBuilder {
            inner: SurfaceFormatKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SurfaceFormatKHRBuilder<'a> {
    inner: SurfaceFormatKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SurfaceFormatKHRBuilder<'a> {
    type Target = SurfaceFormatKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SurfaceFormatKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SurfaceFormatKHRBuilder<'a> {
    pub fn format(mut self, format: Format) -> SurfaceFormatKHRBuilder<'a> {
        self.inner.format = format;
        self
    }
    pub fn color_space(mut self, color_space: ColorSpaceKHR) -> SurfaceFormatKHRBuilder<'a> {
        self.inner.color_space = color_space;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SurfaceFormatKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSwapchainCreateInfoKHR.html>"]
pub struct SwapchainCreateInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: SwapchainCreateFlagsKHR,
    pub surface: SurfaceKHR,
    pub min_image_count: u32,
    pub image_format: Format,
    pub image_color_space: ColorSpaceKHR,
    pub image_extent: Extent2D,
    pub image_array_layers: u32,
    pub image_usage: ImageUsageFlags,
    pub image_sharing_mode: SharingMode,
    pub queue_family_index_count: u32,
    pub p_queue_family_indices: *const u32,
    pub pre_transform: SurfaceTransformFlagsKHR,
    pub composite_alpha: CompositeAlphaFlagsKHR,
    pub present_mode: PresentModeKHR,
    pub clipped: Bool32,
    pub old_swapchain: SwapchainKHR,
}
impl ::std::default::Default for SwapchainCreateInfoKHR {
    fn default() -> SwapchainCreateInfoKHR {
        SwapchainCreateInfoKHR {
            s_type: StructureType::SWAPCHAIN_CREATE_INFO_KHR,
            p_next: ::std::ptr::null(),
            flags: SwapchainCreateFlagsKHR::default(),
            surface: SurfaceKHR::default(),
            min_image_count: u32::default(),
            image_format: Format::default(),
            image_color_space: ColorSpaceKHR::default(),
            image_extent: Extent2D::default(),
            image_array_layers: u32::default(),
            image_usage: ImageUsageFlags::default(),
            image_sharing_mode: SharingMode::default(),
            queue_family_index_count: u32::default(),
            p_queue_family_indices: ::std::ptr::null(),
            pre_transform: SurfaceTransformFlagsKHR::default(),
            composite_alpha: CompositeAlphaFlagsKHR::default(),
            present_mode: PresentModeKHR::default(),
            clipped: Bool32::default(),
            old_swapchain: SwapchainKHR::default(),
        }
    }
}
impl SwapchainCreateInfoKHR {
    pub fn builder<'a>() -> SwapchainCreateInfoKHRBuilder<'a> {
        SwapchainCreateInfoKHRBuilder {
            inner: SwapchainCreateInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SwapchainCreateInfoKHRBuilder<'a> {
    inner: SwapchainCreateInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsSwapchainCreateInfoKHR {}
impl<'a> ::std::ops::Deref for SwapchainCreateInfoKHRBuilder<'a> {
    type Target = SwapchainCreateInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SwapchainCreateInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SwapchainCreateInfoKHRBuilder<'a> {
    pub fn flags(mut self, flags: SwapchainCreateFlagsKHR) -> SwapchainCreateInfoKHRBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn surface(mut self, surface: SurfaceKHR) -> SwapchainCreateInfoKHRBuilder<'a> {
        self.inner.surface = surface;
        self
    }
    pub fn min_image_count(mut self, min_image_count: u32) -> SwapchainCreateInfoKHRBuilder<'a> {
        self.inner.min_image_count = min_image_count;
        self
    }
    pub fn image_format(mut self, image_format: Format) -> SwapchainCreateInfoKHRBuilder<'a> {
        self.inner.image_format = image_format;
        self
    }
    pub fn image_color_space(
        mut self,
        image_color_space: ColorSpaceKHR,
    ) -> SwapchainCreateInfoKHRBuilder<'a> {
        self.inner.image_color_space = image_color_space;
        self
    }
    pub fn image_extent(mut self, image_extent: Extent2D) -> SwapchainCreateInfoKHRBuilder<'a> {
        self.inner.image_extent = image_extent;
        self
    }
    pub fn image_array_layers(
        mut self,
        image_array_layers: u32,
    ) -> SwapchainCreateInfoKHRBuilder<'a> {
        self.inner.image_array_layers = image_array_layers;
        self
    }
    pub fn image_usage(
        mut self,
        image_usage: ImageUsageFlags,
    ) -> SwapchainCreateInfoKHRBuilder<'a> {
        self.inner.image_usage = image_usage;
        self
    }
    pub fn image_sharing_mode(
        mut self,
        image_sharing_mode: SharingMode,
    ) -> SwapchainCreateInfoKHRBuilder<'a> {
        self.inner.image_sharing_mode = image_sharing_mode;
        self
    }
    pub fn queue_family_indices(
        mut self,
        queue_family_indices: &'a [u32],
    ) -> SwapchainCreateInfoKHRBuilder<'a> {
        self.inner.queue_family_index_count = queue_family_indices.len() as _;
        self.inner.p_queue_family_indices = queue_family_indices.as_ptr();
        self
    }
    pub fn pre_transform(
        mut self,
        pre_transform: SurfaceTransformFlagsKHR,
    ) -> SwapchainCreateInfoKHRBuilder<'a> {
        self.inner.pre_transform = pre_transform;
        self
    }
    pub fn composite_alpha(
        mut self,
        composite_alpha: CompositeAlphaFlagsKHR,
    ) -> SwapchainCreateInfoKHRBuilder<'a> {
        self.inner.composite_alpha = composite_alpha;
        self
    }
    pub fn present_mode(
        mut self,
        present_mode: PresentModeKHR,
    ) -> SwapchainCreateInfoKHRBuilder<'a> {
        self.inner.present_mode = present_mode;
        self
    }
    pub fn clipped(mut self, clipped: bool) -> SwapchainCreateInfoKHRBuilder<'a> {
        self.inner.clipped = clipped.into();
        self
    }
    pub fn old_swapchain(
        mut self,
        old_swapchain: SwapchainKHR,
    ) -> SwapchainCreateInfoKHRBuilder<'a> {
        self.inner.old_swapchain = old_swapchain;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSwapchainCreateInfoKHR>(
        mut self,
        next: &'a mut T,
    ) -> SwapchainCreateInfoKHRBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SwapchainCreateInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPresentInfoKHR.html>"]
pub struct PresentInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub wait_semaphore_count: u32,
    pub p_wait_semaphores: *const Semaphore,
    pub swapchain_count: u32,
    pub p_swapchains: *const SwapchainKHR,
    pub p_image_indices: *const u32,
    pub p_results: *mut Result,
}
impl ::std::default::Default for PresentInfoKHR {
    fn default() -> PresentInfoKHR {
        PresentInfoKHR {
            s_type: StructureType::PRESENT_INFO_KHR,
            p_next: ::std::ptr::null(),
            wait_semaphore_count: u32::default(),
            p_wait_semaphores: ::std::ptr::null(),
            swapchain_count: u32::default(),
            p_swapchains: ::std::ptr::null(),
            p_image_indices: ::std::ptr::null(),
            p_results: ::std::ptr::null_mut(),
        }
    }
}
impl PresentInfoKHR {
    pub fn builder<'a>() -> PresentInfoKHRBuilder<'a> {
        PresentInfoKHRBuilder {
            inner: PresentInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PresentInfoKHRBuilder<'a> {
    inner: PresentInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPresentInfoKHR {}
impl<'a> ::std::ops::Deref for PresentInfoKHRBuilder<'a> {
    type Target = PresentInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PresentInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PresentInfoKHRBuilder<'a> {
    pub fn wait_semaphores(
        mut self,
        wait_semaphores: &'a [Semaphore],
    ) -> PresentInfoKHRBuilder<'a> {
        self.inner.wait_semaphore_count = wait_semaphores.len() as _;
        self.inner.p_wait_semaphores = wait_semaphores.as_ptr();
        self
    }
    pub fn swapchains(mut self, swapchains: &'a [SwapchainKHR]) -> PresentInfoKHRBuilder<'a> {
        self.inner.swapchain_count = swapchains.len() as _;
        self.inner.p_swapchains = swapchains.as_ptr();
        self
    }
    pub fn image_indices(mut self, image_indices: &'a [u32]) -> PresentInfoKHRBuilder<'a> {
        self.inner.swapchain_count = image_indices.len() as _;
        self.inner.p_image_indices = image_indices.as_ptr();
        self
    }
    pub fn results(mut self, results: &'a mut [Result]) -> PresentInfoKHRBuilder<'a> {
        self.inner.swapchain_count = results.len() as _;
        self.inner.p_results = results.as_mut_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPresentInfoKHR>(
        mut self,
        next: &'a mut T,
    ) -> PresentInfoKHRBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PresentInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugReportCallbackCreateInfoEXT.html>"]
pub struct DebugReportCallbackCreateInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DebugReportFlagsEXT,
    pub pfn_callback: PFN_vkDebugReportCallbackEXT,
    pub p_user_data: *mut c_void,
}
impl fmt::Debug for DebugReportCallbackCreateInfoEXT {
    fn fmt(&self, fmt: &mut fmt::Formatter) -> fmt::Result {
        fmt.debug_struct("DebugReportCallbackCreateInfoEXT")
            .field("s_type", &self.s_type)
            .field("p_next", &self.p_next)
            .field("flags", &self.flags)
            .field("pfn_callback", &(self.pfn_callback.map(|x| x as *const ())))
            .field("p_user_data", &self.p_user_data)
            .finish()
    }
}
impl ::std::default::Default for DebugReportCallbackCreateInfoEXT {
    fn default() -> DebugReportCallbackCreateInfoEXT {
        DebugReportCallbackCreateInfoEXT {
            s_type: StructureType::DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT,
            p_next: ::std::ptr::null(),
            flags: DebugReportFlagsEXT::default(),
            pfn_callback: PFN_vkDebugReportCallbackEXT::default(),
            p_user_data: ::std::ptr::null_mut(),
        }
    }
}
impl DebugReportCallbackCreateInfoEXT {
    pub fn builder<'a>() -> DebugReportCallbackCreateInfoEXTBuilder<'a> {
        DebugReportCallbackCreateInfoEXTBuilder {
            inner: DebugReportCallbackCreateInfoEXT::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DebugReportCallbackCreateInfoEXTBuilder<'a> {
    inner: DebugReportCallbackCreateInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsInstanceCreateInfo for DebugReportCallbackCreateInfoEXTBuilder<'_> {}
unsafe impl ExtendsInstanceCreateInfo for DebugReportCallbackCreateInfoEXT {}
impl<'a> ::std::ops::Deref for DebugReportCallbackCreateInfoEXTBuilder<'a> {
    type Target = DebugReportCallbackCreateInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DebugReportCallbackCreateInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DebugReportCallbackCreateInfoEXTBuilder<'a> {
    pub fn flags(
        mut self,
        flags: DebugReportFlagsEXT,
    ) -> DebugReportCallbackCreateInfoEXTBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn pfn_callback(
        mut self,
        pfn_callback: PFN_vkDebugReportCallbackEXT,
    ) -> DebugReportCallbackCreateInfoEXTBuilder<'a> {
        self.inner.pfn_callback = pfn_callback;
        self
    }
    pub fn user_data(
        mut self,
        user_data: *mut c_void,
    ) -> DebugReportCallbackCreateInfoEXTBuilder<'a> {
        self.inner.p_user_data = user_data;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DebugReportCallbackCreateInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkValidationFlagsEXT.html>"]
pub struct ValidationFlagsEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub disabled_validation_check_count: u32,
    pub p_disabled_validation_checks: *const ValidationCheckEXT,
}
impl ::std::default::Default for ValidationFlagsEXT {
    fn default() -> ValidationFlagsEXT {
        ValidationFlagsEXT {
            s_type: StructureType::VALIDATION_FLAGS_EXT,
            p_next: ::std::ptr::null(),
            disabled_validation_check_count: u32::default(),
            p_disabled_validation_checks: ::std::ptr::null(),
        }
    }
}
impl ValidationFlagsEXT {
    pub fn builder<'a>() -> ValidationFlagsEXTBuilder<'a> {
        ValidationFlagsEXTBuilder {
            inner: ValidationFlagsEXT::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ValidationFlagsEXTBuilder<'a> {
    inner: ValidationFlagsEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsInstanceCreateInfo for ValidationFlagsEXTBuilder<'_> {}
unsafe impl ExtendsInstanceCreateInfo for ValidationFlagsEXT {}
impl<'a> ::std::ops::Deref for ValidationFlagsEXTBuilder<'a> {
    type Target = ValidationFlagsEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ValidationFlagsEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ValidationFlagsEXTBuilder<'a> {
    pub fn disabled_validation_checks(
        mut self,
        disabled_validation_checks: &'a [ValidationCheckEXT],
    ) -> ValidationFlagsEXTBuilder<'a> {
        self.inner.disabled_validation_check_count = disabled_validation_checks.len() as _;
        self.inner.p_disabled_validation_checks = disabled_validation_checks.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ValidationFlagsEXT {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkValidationFeaturesEXT.html>"]
pub struct ValidationFeaturesEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub enabled_validation_feature_count: u32,
    pub p_enabled_validation_features: *const ValidationFeatureEnableEXT,
    pub disabled_validation_feature_count: u32,
    pub p_disabled_validation_features: *const ValidationFeatureDisableEXT,
}
impl ::std::default::Default for ValidationFeaturesEXT {
    fn default() -> ValidationFeaturesEXT {
        ValidationFeaturesEXT {
            s_type: StructureType::VALIDATION_FEATURES_EXT,
            p_next: ::std::ptr::null(),
            enabled_validation_feature_count: u32::default(),
            p_enabled_validation_features: ::std::ptr::null(),
            disabled_validation_feature_count: u32::default(),
            p_disabled_validation_features: ::std::ptr::null(),
        }
    }
}
impl ValidationFeaturesEXT {
    pub fn builder<'a>() -> ValidationFeaturesEXTBuilder<'a> {
        ValidationFeaturesEXTBuilder {
            inner: ValidationFeaturesEXT::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ValidationFeaturesEXTBuilder<'a> {
    inner: ValidationFeaturesEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsInstanceCreateInfo for ValidationFeaturesEXTBuilder<'_> {}
unsafe impl ExtendsInstanceCreateInfo for ValidationFeaturesEXT {}
impl<'a> ::std::ops::Deref for ValidationFeaturesEXTBuilder<'a> {
    type Target = ValidationFeaturesEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ValidationFeaturesEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ValidationFeaturesEXTBuilder<'a> {
    pub fn enabled_validation_features(
        mut self,
        enabled_validation_features: &'a [ValidationFeatureEnableEXT],
    ) -> ValidationFeaturesEXTBuilder<'a> {
        self.inner.enabled_validation_feature_count = enabled_validation_features.len() as _;
        self.inner.p_enabled_validation_features = enabled_validation_features.as_ptr();
        self
    }
    pub fn disabled_validation_features(
        mut self,
        disabled_validation_features: &'a [ValidationFeatureDisableEXT],
    ) -> ValidationFeaturesEXTBuilder<'a> {
        self.inner.disabled_validation_feature_count = disabled_validation_features.len() as _;
        self.inner.p_disabled_validation_features = disabled_validation_features.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ValidationFeaturesEXT {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPipelineRasterizationStateRasterizationOrderAMD.html>"]
pub struct PipelineRasterizationStateRasterizationOrderAMD {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub rasterization_order: RasterizationOrderAMD,
}
impl ::std::default::Default for PipelineRasterizationStateRasterizationOrderAMD {
    fn default() -> PipelineRasterizationStateRasterizationOrderAMD {
        PipelineRasterizationStateRasterizationOrderAMD {
            s_type: StructureType::PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD,
            p_next: ::std::ptr::null(),
            rasterization_order: RasterizationOrderAMD::default(),
        }
    }
}
impl PipelineRasterizationStateRasterizationOrderAMD {
    pub fn builder<'a>() -> PipelineRasterizationStateRasterizationOrderAMDBuilder<'a> {
        PipelineRasterizationStateRasterizationOrderAMDBuilder {
            inner: PipelineRasterizationStateRasterizationOrderAMD::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineRasterizationStateRasterizationOrderAMDBuilder<'a> {
    inner: PipelineRasterizationStateRasterizationOrderAMD,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPipelineRasterizationStateCreateInfo
    for PipelineRasterizationStateRasterizationOrderAMDBuilder<'_>
{
}
unsafe impl ExtendsPipelineRasterizationStateCreateInfo
    for PipelineRasterizationStateRasterizationOrderAMD
{
}
impl<'a> ::std::ops::Deref for PipelineRasterizationStateRasterizationOrderAMDBuilder<'a> {
    type Target = PipelineRasterizationStateRasterizationOrderAMD;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineRasterizationStateRasterizationOrderAMDBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineRasterizationStateRasterizationOrderAMDBuilder<'a> {
    pub fn rasterization_order(
        mut self,
        rasterization_order: RasterizationOrderAMD,
    ) -> PipelineRasterizationStateRasterizationOrderAMDBuilder<'a> {
        self.inner.rasterization_order = rasterization_order;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineRasterizationStateRasterizationOrderAMD {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugMarkerObjectNameInfoEXT.html>"]
pub struct DebugMarkerObjectNameInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub object_type: DebugReportObjectTypeEXT,
    pub object: u64,
    pub p_object_name: *const c_char,
}
impl ::std::default::Default for DebugMarkerObjectNameInfoEXT {
    fn default() -> DebugMarkerObjectNameInfoEXT {
        DebugMarkerObjectNameInfoEXT {
            s_type: StructureType::DEBUG_MARKER_OBJECT_NAME_INFO_EXT,
            p_next: ::std::ptr::null(),
            object_type: DebugReportObjectTypeEXT::default(),
            object: u64::default(),
            p_object_name: ::std::ptr::null(),
        }
    }
}
impl DebugMarkerObjectNameInfoEXT {
    pub fn builder<'a>() -> DebugMarkerObjectNameInfoEXTBuilder<'a> {
        DebugMarkerObjectNameInfoEXTBuilder {
            inner: DebugMarkerObjectNameInfoEXT::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DebugMarkerObjectNameInfoEXTBuilder<'a> {
    inner: DebugMarkerObjectNameInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsDebugMarkerObjectNameInfoEXT {}
impl<'a> ::std::ops::Deref for DebugMarkerObjectNameInfoEXTBuilder<'a> {
    type Target = DebugMarkerObjectNameInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DebugMarkerObjectNameInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DebugMarkerObjectNameInfoEXTBuilder<'a> {
    pub fn object_type(
        mut self,
        object_type: DebugReportObjectTypeEXT,
    ) -> DebugMarkerObjectNameInfoEXTBuilder<'a> {
        self.inner.object_type = object_type;
        self
    }
    pub fn object(mut self, object: u64) -> DebugMarkerObjectNameInfoEXTBuilder<'a> {
        self.inner.object = object;
        self
    }
    pub fn object_name(
        mut self,
        object_name: &'a ::std::ffi::CStr,
    ) -> DebugMarkerObjectNameInfoEXTBuilder<'a> {
        self.inner.p_object_name = object_name.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDebugMarkerObjectNameInfoEXT>(
        mut self,
        next: &'a mut T,
    ) -> DebugMarkerObjectNameInfoEXTBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DebugMarkerObjectNameInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugMarkerObjectTagInfoEXT.html>"]
pub struct DebugMarkerObjectTagInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub object_type: DebugReportObjectTypeEXT,
    pub object: u64,
    pub tag_name: u64,
    pub tag_size: usize,
    pub p_tag: *const c_void,
}
impl ::std::default::Default for DebugMarkerObjectTagInfoEXT {
    fn default() -> DebugMarkerObjectTagInfoEXT {
        DebugMarkerObjectTagInfoEXT {
            s_type: StructureType::DEBUG_MARKER_OBJECT_TAG_INFO_EXT,
            p_next: ::std::ptr::null(),
            object_type: DebugReportObjectTypeEXT::default(),
            object: u64::default(),
            tag_name: u64::default(),
            tag_size: usize::default(),
            p_tag: ::std::ptr::null(),
        }
    }
}
impl DebugMarkerObjectTagInfoEXT {
    pub fn builder<'a>() -> DebugMarkerObjectTagInfoEXTBuilder<'a> {
        DebugMarkerObjectTagInfoEXTBuilder {
            inner: DebugMarkerObjectTagInfoEXT::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DebugMarkerObjectTagInfoEXTBuilder<'a> {
    inner: DebugMarkerObjectTagInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsDebugMarkerObjectTagInfoEXT {}
impl<'a> ::std::ops::Deref for DebugMarkerObjectTagInfoEXTBuilder<'a> {
    type Target = DebugMarkerObjectTagInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DebugMarkerObjectTagInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DebugMarkerObjectTagInfoEXTBuilder<'a> {
    pub fn object_type(
        mut self,
        object_type: DebugReportObjectTypeEXT,
    ) -> DebugMarkerObjectTagInfoEXTBuilder<'a> {
        self.inner.object_type = object_type;
        self
    }
    pub fn object(mut self, object: u64) -> DebugMarkerObjectTagInfoEXTBuilder<'a> {
        self.inner.object = object;
        self
    }
    pub fn tag_name(mut self, tag_name: u64) -> DebugMarkerObjectTagInfoEXTBuilder<'a> {
        self.inner.tag_name = tag_name;
        self
    }
    pub fn tag(mut self, tag: &'a [u8]) -> DebugMarkerObjectTagInfoEXTBuilder<'a> {
        self.inner.tag_size = tag.len() as _;
        self.inner.p_tag = tag.as_ptr() as *const c_void;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDebugMarkerObjectTagInfoEXT>(
        mut self,
        next: &'a mut T,
    ) -> DebugMarkerObjectTagInfoEXTBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DebugMarkerObjectTagInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDebugMarkerMarkerInfoEXT.html>"]
pub struct DebugMarkerMarkerInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_marker_name: *const c_char,
    pub color: [f32; 4],
}
impl ::std::default::Default for DebugMarkerMarkerInfoEXT {
    fn default() -> DebugMarkerMarkerInfoEXT {
        DebugMarkerMarkerInfoEXT {
            s_type: StructureType::DEBUG_MARKER_MARKER_INFO_EXT,
            p_next: ::std::ptr::null(),
            p_marker_name: ::std::ptr::null(),
            color: unsafe { ::std::mem::zeroed() },
        }
    }
}
impl DebugMarkerMarkerInfoEXT {
    pub fn builder<'a>() -> DebugMarkerMarkerInfoEXTBuilder<'a> {
        DebugMarkerMarkerInfoEXTBuilder {
            inner: DebugMarkerMarkerInfoEXT::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DebugMarkerMarkerInfoEXTBuilder<'a> {
    inner: DebugMarkerMarkerInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsDebugMarkerMarkerInfoEXT {}
impl<'a> ::std::ops::Deref for DebugMarkerMarkerInfoEXTBuilder<'a> {
    type Target = DebugMarkerMarkerInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DebugMarkerMarkerInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DebugMarkerMarkerInfoEXTBuilder<'a> {
    pub fn marker_name(
        mut self,
        marker_name: &'a ::std::ffi::CStr,
    ) -> DebugMarkerMarkerInfoEXTBuilder<'a> {
        self.inner.p_marker_name = marker_name.as_ptr();
        self
    }
    pub fn color(mut self, color: [f32; 4]) -> DebugMarkerMarkerInfoEXTBuilder<'a> {
        self.inner.color = color;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDebugMarkerMarkerInfoEXT>(
        mut self,
        next: &'a mut T,
    ) -> DebugMarkerMarkerInfoEXTBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DebugMarkerMarkerInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDedicatedAllocationImageCreateInfoNV.html>"]
pub struct DedicatedAllocationImageCreateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub dedicated_allocation: Bool32,
}
impl ::std::default::Default for DedicatedAllocationImageCreateInfoNV {
    fn default() -> DedicatedAllocationImageCreateInfoNV {
        DedicatedAllocationImageCreateInfoNV {
            s_type: StructureType::DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV,
            p_next: ::std::ptr::null(),
            dedicated_allocation: Bool32::default(),
        }
    }
}
impl DedicatedAllocationImageCreateInfoNV {
    pub fn builder<'a>() -> DedicatedAllocationImageCreateInfoNVBuilder<'a> {
        DedicatedAllocationImageCreateInfoNVBuilder {
            inner: DedicatedAllocationImageCreateInfoNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DedicatedAllocationImageCreateInfoNVBuilder<'a> {
    inner: DedicatedAllocationImageCreateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsImageCreateInfo for DedicatedAllocationImageCreateInfoNVBuilder<'_> {}
unsafe impl ExtendsImageCreateInfo for DedicatedAllocationImageCreateInfoNV {}
impl<'a> ::std::ops::Deref for DedicatedAllocationImageCreateInfoNVBuilder<'a> {
    type Target = DedicatedAllocationImageCreateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DedicatedAllocationImageCreateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DedicatedAllocationImageCreateInfoNVBuilder<'a> {
    pub fn dedicated_allocation(
        mut self,
        dedicated_allocation: bool,
    ) -> DedicatedAllocationImageCreateInfoNVBuilder<'a> {
        self.inner.dedicated_allocation = dedicated_allocation.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DedicatedAllocationImageCreateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDedicatedAllocationBufferCreateInfoNV.html>"]
pub struct DedicatedAllocationBufferCreateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub dedicated_allocation: Bool32,
}
impl ::std::default::Default for DedicatedAllocationBufferCreateInfoNV {
    fn default() -> DedicatedAllocationBufferCreateInfoNV {
        DedicatedAllocationBufferCreateInfoNV {
            s_type: StructureType::DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV,
            p_next: ::std::ptr::null(),
            dedicated_allocation: Bool32::default(),
        }
    }
}
impl DedicatedAllocationBufferCreateInfoNV {
    pub fn builder<'a>() -> DedicatedAllocationBufferCreateInfoNVBuilder<'a> {
        DedicatedAllocationBufferCreateInfoNVBuilder {
            inner: DedicatedAllocationBufferCreateInfoNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DedicatedAllocationBufferCreateInfoNVBuilder<'a> {
    inner: DedicatedAllocationBufferCreateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsBufferCreateInfo for DedicatedAllocationBufferCreateInfoNVBuilder<'_> {}
unsafe impl ExtendsBufferCreateInfo for DedicatedAllocationBufferCreateInfoNV {}
impl<'a> ::std::ops::Deref for DedicatedAllocationBufferCreateInfoNVBuilder<'a> {
    type Target = DedicatedAllocationBufferCreateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DedicatedAllocationBufferCreateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DedicatedAllocationBufferCreateInfoNVBuilder<'a> {
    pub fn dedicated_allocation(
        mut self,
        dedicated_allocation: bool,
    ) -> DedicatedAllocationBufferCreateInfoNVBuilder<'a> {
        self.inner.dedicated_allocation = dedicated_allocation.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DedicatedAllocationBufferCreateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDedicatedAllocationMemoryAllocateInfoNV.html>"]
pub struct DedicatedAllocationMemoryAllocateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub image: Image,
    pub buffer: Buffer,
}
impl ::std::default::Default for DedicatedAllocationMemoryAllocateInfoNV {
    fn default() -> DedicatedAllocationMemoryAllocateInfoNV {
        DedicatedAllocationMemoryAllocateInfoNV {
            s_type: StructureType::DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV,
            p_next: ::std::ptr::null(),
            image: Image::default(),
            buffer: Buffer::default(),
        }
    }
}
impl DedicatedAllocationMemoryAllocateInfoNV {
    pub fn builder<'a>() -> DedicatedAllocationMemoryAllocateInfoNVBuilder<'a> {
        DedicatedAllocationMemoryAllocateInfoNVBuilder {
            inner: DedicatedAllocationMemoryAllocateInfoNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DedicatedAllocationMemoryAllocateInfoNVBuilder<'a> {
    inner: DedicatedAllocationMemoryAllocateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for DedicatedAllocationMemoryAllocateInfoNVBuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for DedicatedAllocationMemoryAllocateInfoNV {}
impl<'a> ::std::ops::Deref for DedicatedAllocationMemoryAllocateInfoNVBuilder<'a> {
    type Target = DedicatedAllocationMemoryAllocateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DedicatedAllocationMemoryAllocateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DedicatedAllocationMemoryAllocateInfoNVBuilder<'a> {
    pub fn image(mut self, image: Image) -> DedicatedAllocationMemoryAllocateInfoNVBuilder<'a> {
        self.inner.image = image;
        self
    }
    pub fn buffer(mut self, buffer: Buffer) -> DedicatedAllocationMemoryAllocateInfoNVBuilder<'a> {
        self.inner.buffer = buffer;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DedicatedAllocationMemoryAllocateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalImageFormatPropertiesNV.html>"]
pub struct ExternalImageFormatPropertiesNV {
    pub image_format_properties: ImageFormatProperties,
    pub external_memory_features: ExternalMemoryFeatureFlagsNV,
    pub export_from_imported_handle_types: ExternalMemoryHandleTypeFlagsNV,
    pub compatible_handle_types: ExternalMemoryHandleTypeFlagsNV,
}
impl ExternalImageFormatPropertiesNV {
    pub fn builder<'a>() -> ExternalImageFormatPropertiesNVBuilder<'a> {
        ExternalImageFormatPropertiesNVBuilder {
            inner: ExternalImageFormatPropertiesNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExternalImageFormatPropertiesNVBuilder<'a> {
    inner: ExternalImageFormatPropertiesNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ExternalImageFormatPropertiesNVBuilder<'a> {
    type Target = ExternalImageFormatPropertiesNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExternalImageFormatPropertiesNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExternalImageFormatPropertiesNVBuilder<'a> {
    pub fn image_format_properties(
        mut self,
        image_format_properties: ImageFormatProperties,
    ) -> ExternalImageFormatPropertiesNVBuilder<'a> {
        self.inner.image_format_properties = image_format_properties;
        self
    }
    pub fn external_memory_features(
        mut self,
        external_memory_features: ExternalMemoryFeatureFlagsNV,
    ) -> ExternalImageFormatPropertiesNVBuilder<'a> {
        self.inner.external_memory_features = external_memory_features;
        self
    }
    pub fn export_from_imported_handle_types(
        mut self,
        export_from_imported_handle_types: ExternalMemoryHandleTypeFlagsNV,
    ) -> ExternalImageFormatPropertiesNVBuilder<'a> {
        self.inner.export_from_imported_handle_types = export_from_imported_handle_types;
        self
    }
    pub fn compatible_handle_types(
        mut self,
        compatible_handle_types: ExternalMemoryHandleTypeFlagsNV,
    ) -> ExternalImageFormatPropertiesNVBuilder<'a> {
        self.inner.compatible_handle_types = compatible_handle_types;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExternalImageFormatPropertiesNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalMemoryImageCreateInfoNV.html>"]
pub struct ExternalMemoryImageCreateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlagsNV,
}
impl ::std::default::Default for ExternalMemoryImageCreateInfoNV {
    fn default() -> ExternalMemoryImageCreateInfoNV {
        ExternalMemoryImageCreateInfoNV {
            s_type: StructureType::EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV,
            p_next: ::std::ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlagsNV::default(),
        }
    }
}
impl ExternalMemoryImageCreateInfoNV {
    pub fn builder<'a>() -> ExternalMemoryImageCreateInfoNVBuilder<'a> {
        ExternalMemoryImageCreateInfoNVBuilder {
            inner: ExternalMemoryImageCreateInfoNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExternalMemoryImageCreateInfoNVBuilder<'a> {
    inner: ExternalMemoryImageCreateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsImageCreateInfo for ExternalMemoryImageCreateInfoNVBuilder<'_> {}
unsafe impl ExtendsImageCreateInfo for ExternalMemoryImageCreateInfoNV {}
impl<'a> ::std::ops::Deref for ExternalMemoryImageCreateInfoNVBuilder<'a> {
    type Target = ExternalMemoryImageCreateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExternalMemoryImageCreateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExternalMemoryImageCreateInfoNVBuilder<'a> {
    pub fn handle_types(
        mut self,
        handle_types: ExternalMemoryHandleTypeFlagsNV,
    ) -> ExternalMemoryImageCreateInfoNVBuilder<'a> {
        self.inner.handle_types = handle_types;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExternalMemoryImageCreateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExportMemoryAllocateInfoNV.html>"]
pub struct ExportMemoryAllocateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlagsNV,
}
impl ::std::default::Default for ExportMemoryAllocateInfoNV {
    fn default() -> ExportMemoryAllocateInfoNV {
        ExportMemoryAllocateInfoNV {
            s_type: StructureType::EXPORT_MEMORY_ALLOCATE_INFO_NV,
            p_next: ::std::ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlagsNV::default(),
        }
    }
}
impl ExportMemoryAllocateInfoNV {
    pub fn builder<'a>() -> ExportMemoryAllocateInfoNVBuilder<'a> {
        ExportMemoryAllocateInfoNVBuilder {
            inner: ExportMemoryAllocateInfoNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExportMemoryAllocateInfoNVBuilder<'a> {
    inner: ExportMemoryAllocateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryAllocateInfoNVBuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryAllocateInfoNV {}
impl<'a> ::std::ops::Deref for ExportMemoryAllocateInfoNVBuilder<'a> {
    type Target = ExportMemoryAllocateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExportMemoryAllocateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExportMemoryAllocateInfoNVBuilder<'a> {
    pub fn handle_types(
        mut self,
        handle_types: ExternalMemoryHandleTypeFlagsNV,
    ) -> ExportMemoryAllocateInfoNVBuilder<'a> {
        self.inner.handle_types = handle_types;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExportMemoryAllocateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImportMemoryWin32HandleInfoNV.html>"]
pub struct ImportMemoryWin32HandleInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlagsNV,
    pub handle: HANDLE,
}
impl ::std::default::Default for ImportMemoryWin32HandleInfoNV {
    fn default() -> ImportMemoryWin32HandleInfoNV {
        ImportMemoryWin32HandleInfoNV {
            s_type: StructureType::IMPORT_MEMORY_WIN32_HANDLE_INFO_NV,
            p_next: ::std::ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlagsNV::default(),
            handle: unsafe { ::std::mem::zeroed() },
        }
    }
}
impl ImportMemoryWin32HandleInfoNV {
    pub fn builder<'a>() -> ImportMemoryWin32HandleInfoNVBuilder<'a> {
        ImportMemoryWin32HandleInfoNVBuilder {
            inner: ImportMemoryWin32HandleInfoNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImportMemoryWin32HandleInfoNVBuilder<'a> {
    inner: ImportMemoryWin32HandleInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryWin32HandleInfoNVBuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryWin32HandleInfoNV {}
impl<'a> ::std::ops::Deref for ImportMemoryWin32HandleInfoNVBuilder<'a> {
    type Target = ImportMemoryWin32HandleInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImportMemoryWin32HandleInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImportMemoryWin32HandleInfoNVBuilder<'a> {
    pub fn handle_type(
        mut self,
        handle_type: ExternalMemoryHandleTypeFlagsNV,
    ) -> ImportMemoryWin32HandleInfoNVBuilder<'a> {
        self.inner.handle_type = handle_type;
        self
    }
    pub fn handle(mut self, handle: HANDLE) -> ImportMemoryWin32HandleInfoNVBuilder<'a> {
        self.inner.handle = handle;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImportMemoryWin32HandleInfoNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExportMemoryWin32HandleInfoNV.html>"]
pub struct ExportMemoryWin32HandleInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_attributes: *const SECURITY_ATTRIBUTES,
    pub dw_access: DWORD,
}
impl ::std::default::Default for ExportMemoryWin32HandleInfoNV {
    fn default() -> ExportMemoryWin32HandleInfoNV {
        ExportMemoryWin32HandleInfoNV {
            s_type: StructureType::EXPORT_MEMORY_WIN32_HANDLE_INFO_NV,
            p_next: ::std::ptr::null(),
            p_attributes: ::std::ptr::null(),
            dw_access: DWORD::default(),
        }
    }
}
impl ExportMemoryWin32HandleInfoNV {
    pub fn builder<'a>() -> ExportMemoryWin32HandleInfoNVBuilder<'a> {
        ExportMemoryWin32HandleInfoNVBuilder {
            inner: ExportMemoryWin32HandleInfoNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExportMemoryWin32HandleInfoNVBuilder<'a> {
    inner: ExportMemoryWin32HandleInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryWin32HandleInfoNVBuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryWin32HandleInfoNV {}
impl<'a> ::std::ops::Deref for ExportMemoryWin32HandleInfoNVBuilder<'a> {
    type Target = ExportMemoryWin32HandleInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExportMemoryWin32HandleInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExportMemoryWin32HandleInfoNVBuilder<'a> {
    pub fn attributes(
        mut self,
        attributes: &'a SECURITY_ATTRIBUTES,
    ) -> ExportMemoryWin32HandleInfoNVBuilder<'a> {
        self.inner.p_attributes = attributes;
        self
    }
    pub fn dw_access(mut self, dw_access: DWORD) -> ExportMemoryWin32HandleInfoNVBuilder<'a> {
        self.inner.dw_access = dw_access;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExportMemoryWin32HandleInfoNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkWin32KeyedMutexAcquireReleaseInfoNV.html>"]
pub struct Win32KeyedMutexAcquireReleaseInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub acquire_count: u32,
    pub p_acquire_syncs: *const DeviceMemory,
    pub p_acquire_keys: *const u64,
    pub p_acquire_timeout_milliseconds: *const u32,
    pub release_count: u32,
    pub p_release_syncs: *const DeviceMemory,
    pub p_release_keys: *const u64,
}
impl ::std::default::Default for Win32KeyedMutexAcquireReleaseInfoNV {
    fn default() -> Win32KeyedMutexAcquireReleaseInfoNV {
        Win32KeyedMutexAcquireReleaseInfoNV {
            s_type: StructureType::WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV,
            p_next: ::std::ptr::null(),
            acquire_count: u32::default(),
            p_acquire_syncs: ::std::ptr::null(),
            p_acquire_keys: ::std::ptr::null(),
            p_acquire_timeout_milliseconds: ::std::ptr::null(),
            release_count: u32::default(),
            p_release_syncs: ::std::ptr::null(),
            p_release_keys: ::std::ptr::null(),
        }
    }
}
impl Win32KeyedMutexAcquireReleaseInfoNV {
    pub fn builder<'a>() -> Win32KeyedMutexAcquireReleaseInfoNVBuilder<'a> {
        Win32KeyedMutexAcquireReleaseInfoNVBuilder {
            inner: Win32KeyedMutexAcquireReleaseInfoNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct Win32KeyedMutexAcquireReleaseInfoNVBuilder<'a> {
    inner: Win32KeyedMutexAcquireReleaseInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSubmitInfo for Win32KeyedMutexAcquireReleaseInfoNVBuilder<'_> {}
unsafe impl ExtendsSubmitInfo for Win32KeyedMutexAcquireReleaseInfoNV {}
impl<'a> ::std::ops::Deref for Win32KeyedMutexAcquireReleaseInfoNVBuilder<'a> {
    type Target = Win32KeyedMutexAcquireReleaseInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for Win32KeyedMutexAcquireReleaseInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> Win32KeyedMutexAcquireReleaseInfoNVBuilder<'a> {
    pub fn acquire_syncs(
        mut self,
        acquire_syncs: &'a [DeviceMemory],
    ) -> Win32KeyedMutexAcquireReleaseInfoNVBuilder<'a> {
        self.inner.acquire_count = acquire_syncs.len() as _;
        self.inner.p_acquire_syncs = acquire_syncs.as_ptr();
        self
    }
    pub fn acquire_keys(
        mut self,
        acquire_keys: &'a [u64],
    ) -> Win32KeyedMutexAcquireReleaseInfoNVBuilder<'a> {
        self.inner.acquire_count = acquire_keys.len() as _;
        self.inner.p_acquire_keys = acquire_keys.as_ptr();
        self
    }
    pub fn acquire_timeout_milliseconds(
        mut self,
        acquire_timeout_milliseconds: &'a [u32],
    ) -> Win32KeyedMutexAcquireReleaseInfoNVBuilder<'a> {
        self.inner.acquire_count = acquire_timeout_milliseconds.len() as _;
        self.inner.p_acquire_timeout_milliseconds = acquire_timeout_milliseconds.as_ptr();
        self
    }
    pub fn release_syncs(
        mut self,
        release_syncs: &'a [DeviceMemory],
    ) -> Win32KeyedMutexAcquireReleaseInfoNVBuilder<'a> {
        self.inner.release_count = release_syncs.len() as _;
        self.inner.p_release_syncs = release_syncs.as_ptr();
        self
    }
    pub fn release_keys(
        mut self,
        release_keys: &'a [u64],
    ) -> Win32KeyedMutexAcquireReleaseInfoNVBuilder<'a> {
        self.inner.release_count = release_keys.len() as _;
        self.inner.p_release_keys = release_keys.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> Win32KeyedMutexAcquireReleaseInfoNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV.html>"]
pub struct PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub device_generated_commands: Bool32,
}
impl ::std::default::Default for PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
    fn default() -> PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
        PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
            s_type: StructureType::PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV,
            p_next: ::std::ptr::null_mut(),
            device_generated_commands: Bool32::default(),
        }
    }
}
impl PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
    pub fn builder<'a>() -> PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder<'a> {
        PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder {
            inner: PhysicalDeviceDeviceGeneratedCommandsFeaturesNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder<'a> {
    inner: PhysicalDeviceDeviceGeneratedCommandsFeaturesNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {}
impl<'a> ::std::ops::Deref for PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder<'a> {
    type Target = PhysicalDeviceDeviceGeneratedCommandsFeaturesNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder<'a> {
    pub fn device_generated_commands(
        mut self,
        device_generated_commands: bool,
    ) -> PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder<'a> {
        self.inner.device_generated_commands = device_generated_commands.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV.html>"]
pub struct PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub max_graphics_shader_group_count: u32,
    pub max_indirect_sequence_count: u32,
    pub max_indirect_commands_token_count: u32,
    pub max_indirect_commands_stream_count: u32,
    pub max_indirect_commands_token_offset: u32,
    pub max_indirect_commands_stream_stride: u32,
    pub min_sequences_count_buffer_offset_alignment: u32,
    pub min_sequences_index_buffer_offset_alignment: u32,
    pub min_indirect_commands_buffer_offset_alignment: u32,
}
impl ::std::default::Default for PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
    fn default() -> PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
        PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
            s_type: StructureType::PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV,
            p_next: ::std::ptr::null(),
            max_graphics_shader_group_count: u32::default(),
            max_indirect_sequence_count: u32::default(),
            max_indirect_commands_token_count: u32::default(),
            max_indirect_commands_stream_count: u32::default(),
            max_indirect_commands_token_offset: u32::default(),
            max_indirect_commands_stream_stride: u32::default(),
            min_sequences_count_buffer_offset_alignment: u32::default(),
            min_sequences_index_buffer_offset_alignment: u32::default(),
            min_indirect_commands_buffer_offset_alignment: u32::default(),
        }
    }
}
impl PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
    pub fn builder<'a>() -> PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
        PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder {
            inner: PhysicalDeviceDeviceGeneratedCommandsPropertiesNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
    inner: PhysicalDeviceDeviceGeneratedCommandsPropertiesNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'_>
{
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {}
impl<'a> ::std::ops::Deref for PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
    type Target = PhysicalDeviceDeviceGeneratedCommandsPropertiesNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
    pub fn max_graphics_shader_group_count(
        mut self,
        max_graphics_shader_group_count: u32,
    ) -> PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
        self.inner.max_graphics_shader_group_count = max_graphics_shader_group_count;
        self
    }
    pub fn max_indirect_sequence_count(
        mut self,
        max_indirect_sequence_count: u32,
    ) -> PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
        self.inner.max_indirect_sequence_count = max_indirect_sequence_count;
        self
    }
    pub fn max_indirect_commands_token_count(
        mut self,
        max_indirect_commands_token_count: u32,
    ) -> PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
        self.inner.max_indirect_commands_token_count = max_indirect_commands_token_count;
        self
    }
    pub fn max_indirect_commands_stream_count(
        mut self,
        max_indirect_commands_stream_count: u32,
    ) -> PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
        self.inner.max_indirect_commands_stream_count = max_indirect_commands_stream_count;
        self
    }
    pub fn max_indirect_commands_token_offset(
        mut self,
        max_indirect_commands_token_offset: u32,
    ) -> PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
        self.inner.max_indirect_commands_token_offset = max_indirect_commands_token_offset;
        self
    }
    pub fn max_indirect_commands_stream_stride(
        mut self,
        max_indirect_commands_stream_stride: u32,
    ) -> PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
        self.inner.max_indirect_commands_stream_stride = max_indirect_commands_stream_stride;
        self
    }
    pub fn min_sequences_count_buffer_offset_alignment(
        mut self,
        min_sequences_count_buffer_offset_alignment: u32,
    ) -> PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
        self.inner.min_sequences_count_buffer_offset_alignment =
            min_sequences_count_buffer_offset_alignment;
        self
    }
    pub fn min_sequences_index_buffer_offset_alignment(
        mut self,
        min_sequences_index_buffer_offset_alignment: u32,
    ) -> PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
        self.inner.min_sequences_index_buffer_offset_alignment =
            min_sequences_index_buffer_offset_alignment;
        self
    }
    pub fn min_indirect_commands_buffer_offset_alignment(
        mut self,
        min_indirect_commands_buffer_offset_alignment: u32,
    ) -> PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
        self.inner.min_indirect_commands_buffer_offset_alignment =
            min_indirect_commands_buffer_offset_alignment;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGraphicsShaderGroupCreateInfoNV.html>"]
pub struct GraphicsShaderGroupCreateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub stage_count: u32,
    pub p_stages: *const PipelineShaderStageCreateInfo,
    pub p_vertex_input_state: *const PipelineVertexInputStateCreateInfo,
    pub p_tessellation_state: *const PipelineTessellationStateCreateInfo,
}
impl ::std::default::Default for GraphicsShaderGroupCreateInfoNV {
    fn default() -> GraphicsShaderGroupCreateInfoNV {
        GraphicsShaderGroupCreateInfoNV {
            s_type: StructureType::GRAPHICS_SHADER_GROUP_CREATE_INFO_NV,
            p_next: ::std::ptr::null(),
            stage_count: u32::default(),
            p_stages: ::std::ptr::null(),
            p_vertex_input_state: ::std::ptr::null(),
            p_tessellation_state: ::std::ptr::null(),
        }
    }
}
impl GraphicsShaderGroupCreateInfoNV {
    pub fn builder<'a>() -> GraphicsShaderGroupCreateInfoNVBuilder<'a> {
        GraphicsShaderGroupCreateInfoNVBuilder {
            inner: GraphicsShaderGroupCreateInfoNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct GraphicsShaderGroupCreateInfoNVBuilder<'a> {
    inner: GraphicsShaderGroupCreateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsGraphicsShaderGroupCreateInfoNV {}
impl<'a> ::std::ops::Deref for GraphicsShaderGroupCreateInfoNVBuilder<'a> {
    type Target = GraphicsShaderGroupCreateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for GraphicsShaderGroupCreateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> GraphicsShaderGroupCreateInfoNVBuilder<'a> {
    pub fn stages(
        mut self,
        stages: &'a [PipelineShaderStageCreateInfo],
    ) -> GraphicsShaderGroupCreateInfoNVBuilder<'a> {
        self.inner.stage_count = stages.len() as _;
        self.inner.p_stages = stages.as_ptr();
        self
    }
    pub fn vertex_input_state(
        mut self,
        vertex_input_state: &'a PipelineVertexInputStateCreateInfo,
    ) -> GraphicsShaderGroupCreateInfoNVBuilder<'a> {
        self.inner.p_vertex_input_state = vertex_input_state;
        self
    }
    pub fn tessellation_state(
        mut self,
        tessellation_state: &'a PipelineTessellationStateCreateInfo,
    ) -> GraphicsShaderGroupCreateInfoNVBuilder<'a> {
        self.inner.p_tessellation_state = tessellation_state;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsGraphicsShaderGroupCreateInfoNV>(
        mut self,
        next: &'a mut T,
    ) -> GraphicsShaderGroupCreateInfoNVBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> GraphicsShaderGroupCreateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGraphicsPipelineShaderGroupsCreateInfoNV.html>"]
pub struct GraphicsPipelineShaderGroupsCreateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub group_count: u32,
    pub p_groups: *const GraphicsShaderGroupCreateInfoNV,
    pub pipeline_count: u32,
    pub p_pipelines: *const Pipeline,
}
impl ::std::default::Default for GraphicsPipelineShaderGroupsCreateInfoNV {
    fn default() -> GraphicsPipelineShaderGroupsCreateInfoNV {
        GraphicsPipelineShaderGroupsCreateInfoNV {
            s_type: StructureType::GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV,
            p_next: ::std::ptr::null(),
            group_count: u32::default(),
            p_groups: ::std::ptr::null(),
            pipeline_count: u32::default(),
            p_pipelines: ::std::ptr::null(),
        }
    }
}
impl GraphicsPipelineShaderGroupsCreateInfoNV {
    pub fn builder<'a>() -> GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'a> {
        GraphicsPipelineShaderGroupsCreateInfoNVBuilder {
            inner: GraphicsPipelineShaderGroupsCreateInfoNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'a> {
    inner: GraphicsPipelineShaderGroupsCreateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsGraphicsPipelineCreateInfo
    for GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'_>
{
}
unsafe impl ExtendsGraphicsPipelineCreateInfo for GraphicsPipelineShaderGroupsCreateInfoNV {}
impl<'a> ::std::ops::Deref for GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'a> {
    type Target = GraphicsPipelineShaderGroupsCreateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'a> {
    pub fn groups(
        mut self,
        groups: &'a [GraphicsShaderGroupCreateInfoNV],
    ) -> GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'a> {
        self.inner.group_count = groups.len() as _;
        self.inner.p_groups = groups.as_ptr();
        self
    }
    pub fn pipelines(
        mut self,
        pipelines: &'a [Pipeline],
    ) -> GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'a> {
        self.inner.pipeline_count = pipelines.len() as _;
        self.inner.p_pipelines = pipelines.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> GraphicsPipelineShaderGroupsCreateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindShaderGroupIndirectCommandNV.html>"]
pub struct BindShaderGroupIndirectCommandNV {
    pub group_index: u32,
}
impl BindShaderGroupIndirectCommandNV {
    pub fn builder<'a>() -> BindShaderGroupIndirectCommandNVBuilder<'a> {
        BindShaderGroupIndirectCommandNVBuilder {
            inner: BindShaderGroupIndirectCommandNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BindShaderGroupIndirectCommandNVBuilder<'a> {
    inner: BindShaderGroupIndirectCommandNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for BindShaderGroupIndirectCommandNVBuilder<'a> {
    type Target = BindShaderGroupIndirectCommandNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BindShaderGroupIndirectCommandNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BindShaderGroupIndirectCommandNVBuilder<'a> {
    pub fn group_index(mut self, group_index: u32) -> BindShaderGroupIndirectCommandNVBuilder<'a> {
        self.inner.group_index = group_index;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BindShaderGroupIndirectCommandNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindIndexBufferIndirectCommandNV.html>"]
pub struct BindIndexBufferIndirectCommandNV {
    pub buffer_address: DeviceAddress,
    pub size: u32,
    pub index_type: IndexType,
}
impl BindIndexBufferIndirectCommandNV {
    pub fn builder<'a>() -> BindIndexBufferIndirectCommandNVBuilder<'a> {
        BindIndexBufferIndirectCommandNVBuilder {
            inner: BindIndexBufferIndirectCommandNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BindIndexBufferIndirectCommandNVBuilder<'a> {
    inner: BindIndexBufferIndirectCommandNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for BindIndexBufferIndirectCommandNVBuilder<'a> {
    type Target = BindIndexBufferIndirectCommandNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BindIndexBufferIndirectCommandNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BindIndexBufferIndirectCommandNVBuilder<'a> {
    pub fn buffer_address(
        mut self,
        buffer_address: DeviceAddress,
    ) -> BindIndexBufferIndirectCommandNVBuilder<'a> {
        self.inner.buffer_address = buffer_address;
        self
    }
    pub fn size(mut self, size: u32) -> BindIndexBufferIndirectCommandNVBuilder<'a> {
        self.inner.size = size;
        self
    }
    pub fn index_type(
        mut self,
        index_type: IndexType,
    ) -> BindIndexBufferIndirectCommandNVBuilder<'a> {
        self.inner.index_type = index_type;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BindIndexBufferIndirectCommandNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindVertexBufferIndirectCommandNV.html>"]
pub struct BindVertexBufferIndirectCommandNV {
    pub buffer_address: DeviceAddress,
    pub size: u32,
    pub stride: u32,
}
impl BindVertexBufferIndirectCommandNV {
    pub fn builder<'a>() -> BindVertexBufferIndirectCommandNVBuilder<'a> {
        BindVertexBufferIndirectCommandNVBuilder {
            inner: BindVertexBufferIndirectCommandNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BindVertexBufferIndirectCommandNVBuilder<'a> {
    inner: BindVertexBufferIndirectCommandNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for BindVertexBufferIndirectCommandNVBuilder<'a> {
    type Target = BindVertexBufferIndirectCommandNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BindVertexBufferIndirectCommandNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BindVertexBufferIndirectCommandNVBuilder<'a> {
    pub fn buffer_address(
        mut self,
        buffer_address: DeviceAddress,
    ) -> BindVertexBufferIndirectCommandNVBuilder<'a> {
        self.inner.buffer_address = buffer_address;
        self
    }
    pub fn size(mut self, size: u32) -> BindVertexBufferIndirectCommandNVBuilder<'a> {
        self.inner.size = size;
        self
    }
    pub fn stride(mut self, stride: u32) -> BindVertexBufferIndirectCommandNVBuilder<'a> {
        self.inner.stride = stride;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BindVertexBufferIndirectCommandNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSetStateFlagsIndirectCommandNV.html>"]
pub struct SetStateFlagsIndirectCommandNV {
    pub data: u32,
}
impl SetStateFlagsIndirectCommandNV {
    pub fn builder<'a>() -> SetStateFlagsIndirectCommandNVBuilder<'a> {
        SetStateFlagsIndirectCommandNVBuilder {
            inner: SetStateFlagsIndirectCommandNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SetStateFlagsIndirectCommandNVBuilder<'a> {
    inner: SetStateFlagsIndirectCommandNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SetStateFlagsIndirectCommandNVBuilder<'a> {
    type Target = SetStateFlagsIndirectCommandNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SetStateFlagsIndirectCommandNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SetStateFlagsIndirectCommandNVBuilder<'a> {
    pub fn data(mut self, data: u32) -> SetStateFlagsIndirectCommandNVBuilder<'a> {
        self.inner.data = data;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SetStateFlagsIndirectCommandNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkIndirectCommandsStreamNV.html>"]
pub struct IndirectCommandsStreamNV {
    pub buffer: Buffer,
    pub offset: DeviceSize,
}
impl IndirectCommandsStreamNV {
    pub fn builder<'a>() -> IndirectCommandsStreamNVBuilder<'a> {
        IndirectCommandsStreamNVBuilder {
            inner: IndirectCommandsStreamNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct IndirectCommandsStreamNVBuilder<'a> {
    inner: IndirectCommandsStreamNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for IndirectCommandsStreamNVBuilder<'a> {
    type Target = IndirectCommandsStreamNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for IndirectCommandsStreamNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> IndirectCommandsStreamNVBuilder<'a> {
    pub fn buffer(mut self, buffer: Buffer) -> IndirectCommandsStreamNVBuilder<'a> {
        self.inner.buffer = buffer;
        self
    }
    pub fn offset(mut self, offset: DeviceSize) -> IndirectCommandsStreamNVBuilder<'a> {
        self.inner.offset = offset;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> IndirectCommandsStreamNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkIndirectCommandsLayoutTokenNV.html>"]
pub struct IndirectCommandsLayoutTokenNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub token_type: IndirectCommandsTokenTypeNV,
    pub stream: u32,
    pub offset: u32,
    pub vertex_binding_unit: u32,
    pub vertex_dynamic_stride: Bool32,
    pub pushconstant_pipeline_layout: PipelineLayout,
    pub pushconstant_shader_stage_flags: ShaderStageFlags,
    pub pushconstant_offset: u32,
    pub pushconstant_size: u32,
    pub indirect_state_flags: IndirectStateFlagsNV,
    pub index_type_count: u32,
    pub p_index_types: *const IndexType,
    pub p_index_type_values: *const u32,
}
impl ::std::default::Default for IndirectCommandsLayoutTokenNV {
    fn default() -> IndirectCommandsLayoutTokenNV {
        IndirectCommandsLayoutTokenNV {
            s_type: StructureType::INDIRECT_COMMANDS_LAYOUT_TOKEN_NV,
            p_next: ::std::ptr::null(),
            token_type: IndirectCommandsTokenTypeNV::default(),
            stream: u32::default(),
            offset: u32::default(),
            vertex_binding_unit: u32::default(),
            vertex_dynamic_stride: Bool32::default(),
            pushconstant_pipeline_layout: PipelineLayout::default(),
            pushconstant_shader_stage_flags: ShaderStageFlags::default(),
            pushconstant_offset: u32::default(),
            pushconstant_size: u32::default(),
            indirect_state_flags: IndirectStateFlagsNV::default(),
            index_type_count: u32::default(),
            p_index_types: ::std::ptr::null(),
            p_index_type_values: ::std::ptr::null(),
        }
    }
}
impl IndirectCommandsLayoutTokenNV {
    pub fn builder<'a>() -> IndirectCommandsLayoutTokenNVBuilder<'a> {
        IndirectCommandsLayoutTokenNVBuilder {
            inner: IndirectCommandsLayoutTokenNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct IndirectCommandsLayoutTokenNVBuilder<'a> {
    inner: IndirectCommandsLayoutTokenNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsIndirectCommandsLayoutTokenNV {}
impl<'a> ::std::ops::Deref for IndirectCommandsLayoutTokenNVBuilder<'a> {
    type Target = IndirectCommandsLayoutTokenNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for IndirectCommandsLayoutTokenNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> IndirectCommandsLayoutTokenNVBuilder<'a> {
    pub fn token_type(
        mut self,
        token_type: IndirectCommandsTokenTypeNV,
    ) -> IndirectCommandsLayoutTokenNVBuilder<'a> {
        self.inner.token_type = token_type;
        self
    }
    pub fn stream(mut self, stream: u32) -> IndirectCommandsLayoutTokenNVBuilder<'a> {
        self.inner.stream = stream;
        self
    }
    pub fn offset(mut self, offset: u32) -> IndirectCommandsLayoutTokenNVBuilder<'a> {
        self.inner.offset = offset;
        self
    }
    pub fn vertex_binding_unit(
        mut self,
        vertex_binding_unit: u32,
    ) -> IndirectCommandsLayoutTokenNVBuilder<'a> {
        self.inner.vertex_binding_unit = vertex_binding_unit;
        self
    }
    pub fn vertex_dynamic_stride(
        mut self,
        vertex_dynamic_stride: bool,
    ) -> IndirectCommandsLayoutTokenNVBuilder<'a> {
        self.inner.vertex_dynamic_stride = vertex_dynamic_stride.into();
        self
    }
    pub fn pushconstant_pipeline_layout(
        mut self,
        pushconstant_pipeline_layout: PipelineLayout,
    ) -> IndirectCommandsLayoutTokenNVBuilder<'a> {
        self.inner.pushconstant_pipeline_layout = pushconstant_pipeline_layout;
        self
    }
    pub fn pushconstant_shader_stage_flags(
        mut self,
        pushconstant_shader_stage_flags: ShaderStageFlags,
    ) -> IndirectCommandsLayoutTokenNVBuilder<'a> {
        self.inner.pushconstant_shader_stage_flags = pushconstant_shader_stage_flags;
        self
    }
    pub fn pushconstant_offset(
        mut self,
        pushconstant_offset: u32,
    ) -> IndirectCommandsLayoutTokenNVBuilder<'a> {
        self.inner.pushconstant_offset = pushconstant_offset;
        self
    }
    pub fn pushconstant_size(
        mut self,
        pushconstant_size: u32,
    ) -> IndirectCommandsLayoutTokenNVBuilder<'a> {
        self.inner.pushconstant_size = pushconstant_size;
        self
    }
    pub fn indirect_state_flags(
        mut self,
        indirect_state_flags: IndirectStateFlagsNV,
    ) -> IndirectCommandsLayoutTokenNVBuilder<'a> {
        self.inner.indirect_state_flags = indirect_state_flags;
        self
    }
    pub fn index_types(
        mut self,
        index_types: &'a [IndexType],
    ) -> IndirectCommandsLayoutTokenNVBuilder<'a> {
        self.inner.index_type_count = index_types.len() as _;
        self.inner.p_index_types = index_types.as_ptr();
        self
    }
    pub fn index_type_values(
        mut self,
        index_type_values: &'a [u32],
    ) -> IndirectCommandsLayoutTokenNVBuilder<'a> {
        self.inner.index_type_count = index_type_values.len() as _;
        self.inner.p_index_type_values = index_type_values.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsIndirectCommandsLayoutTokenNV>(
        mut self,
        next: &'a mut T,
    ) -> IndirectCommandsLayoutTokenNVBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> IndirectCommandsLayoutTokenNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkIndirectCommandsLayoutCreateInfoNV.html>"]
pub struct IndirectCommandsLayoutCreateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: IndirectCommandsLayoutUsageFlagsNV,
    pub pipeline_bind_point: PipelineBindPoint,
    pub token_count: u32,
    pub p_tokens: *const IndirectCommandsLayoutTokenNV,
    pub stream_count: u32,
    pub p_stream_strides: *const u32,
}
impl ::std::default::Default for IndirectCommandsLayoutCreateInfoNV {
    fn default() -> IndirectCommandsLayoutCreateInfoNV {
        IndirectCommandsLayoutCreateInfoNV {
            s_type: StructureType::INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV,
            p_next: ::std::ptr::null(),
            flags: IndirectCommandsLayoutUsageFlagsNV::default(),
            pipeline_bind_point: PipelineBindPoint::default(),
            token_count: u32::default(),
            p_tokens: ::std::ptr::null(),
            stream_count: u32::default(),
            p_stream_strides: ::std::ptr::null(),
        }
    }
}
impl IndirectCommandsLayoutCreateInfoNV {
    pub fn builder<'a>() -> IndirectCommandsLayoutCreateInfoNVBuilder<'a> {
        IndirectCommandsLayoutCreateInfoNVBuilder {
            inner: IndirectCommandsLayoutCreateInfoNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct IndirectCommandsLayoutCreateInfoNVBuilder<'a> {
    inner: IndirectCommandsLayoutCreateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsIndirectCommandsLayoutCreateInfoNV {}
impl<'a> ::std::ops::Deref for IndirectCommandsLayoutCreateInfoNVBuilder<'a> {
    type Target = IndirectCommandsLayoutCreateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for IndirectCommandsLayoutCreateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> IndirectCommandsLayoutCreateInfoNVBuilder<'a> {
    pub fn flags(
        mut self,
        flags: IndirectCommandsLayoutUsageFlagsNV,
    ) -> IndirectCommandsLayoutCreateInfoNVBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn pipeline_bind_point(
        mut self,
        pipeline_bind_point: PipelineBindPoint,
    ) -> IndirectCommandsLayoutCreateInfoNVBuilder<'a> {
        self.inner.pipeline_bind_point = pipeline_bind_point;
        self
    }
    pub fn tokens(
        mut self,
        tokens: &'a [IndirectCommandsLayoutTokenNV],
    ) -> IndirectCommandsLayoutCreateInfoNVBuilder<'a> {
        self.inner.token_count = tokens.len() as _;
        self.inner.p_tokens = tokens.as_ptr();
        self
    }
    pub fn stream_strides(
        mut self,
        stream_strides: &'a [u32],
    ) -> IndirectCommandsLayoutCreateInfoNVBuilder<'a> {
        self.inner.stream_count = stream_strides.len() as _;
        self.inner.p_stream_strides = stream_strides.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsIndirectCommandsLayoutCreateInfoNV>(
        mut self,
        next: &'a mut T,
    ) -> IndirectCommandsLayoutCreateInfoNVBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> IndirectCommandsLayoutCreateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGeneratedCommandsInfoNV.html>"]
pub struct GeneratedCommandsInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub pipeline_bind_point: PipelineBindPoint,
    pub pipeline: Pipeline,
    pub indirect_commands_layout: IndirectCommandsLayoutNV,
    pub stream_count: u32,
    pub p_streams: *const IndirectCommandsStreamNV,
    pub sequences_count: u32,
    pub preprocess_buffer: Buffer,
    pub preprocess_offset: DeviceSize,
    pub preprocess_size: DeviceSize,
    pub sequences_count_buffer: Buffer,
    pub sequences_count_offset: DeviceSize,
    pub sequences_index_buffer: Buffer,
    pub sequences_index_offset: DeviceSize,
}
impl ::std::default::Default for GeneratedCommandsInfoNV {
    fn default() -> GeneratedCommandsInfoNV {
        GeneratedCommandsInfoNV {
            s_type: StructureType::GENERATED_COMMANDS_INFO_NV,
            p_next: ::std::ptr::null(),
            pipeline_bind_point: PipelineBindPoint::default(),
            pipeline: Pipeline::default(),
            indirect_commands_layout: IndirectCommandsLayoutNV::default(),
            stream_count: u32::default(),
            p_streams: ::std::ptr::null(),
            sequences_count: u32::default(),
            preprocess_buffer: Buffer::default(),
            preprocess_offset: DeviceSize::default(),
            preprocess_size: DeviceSize::default(),
            sequences_count_buffer: Buffer::default(),
            sequences_count_offset: DeviceSize::default(),
            sequences_index_buffer: Buffer::default(),
            sequences_index_offset: DeviceSize::default(),
        }
    }
}
impl GeneratedCommandsInfoNV {
    pub fn builder<'a>() -> GeneratedCommandsInfoNVBuilder<'a> {
        GeneratedCommandsInfoNVBuilder {
            inner: GeneratedCommandsInfoNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct GeneratedCommandsInfoNVBuilder<'a> {
    inner: GeneratedCommandsInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsGeneratedCommandsInfoNV {}
impl<'a> ::std::ops::Deref for GeneratedCommandsInfoNVBuilder<'a> {
    type Target = GeneratedCommandsInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for GeneratedCommandsInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> GeneratedCommandsInfoNVBuilder<'a> {
    pub fn pipeline_bind_point(
        mut self,
        pipeline_bind_point: PipelineBindPoint,
    ) -> GeneratedCommandsInfoNVBuilder<'a> {
        self.inner.pipeline_bind_point = pipeline_bind_point;
        self
    }
    pub fn pipeline(mut self, pipeline: Pipeline) -> GeneratedCommandsInfoNVBuilder<'a> {
        self.inner.pipeline = pipeline;
        self
    }
    pub fn indirect_commands_layout(
        mut self,
        indirect_commands_layout: IndirectCommandsLayoutNV,
    ) -> GeneratedCommandsInfoNVBuilder<'a> {
        self.inner.indirect_commands_layout = indirect_commands_layout;
        self
    }
    pub fn streams(
        mut self,
        streams: &'a [IndirectCommandsStreamNV],
    ) -> GeneratedCommandsInfoNVBuilder<'a> {
        self.inner.stream_count = streams.len() as _;
        self.inner.p_streams = streams.as_ptr();
        self
    }
    pub fn sequences_count(mut self, sequences_count: u32) -> GeneratedCommandsInfoNVBuilder<'a> {
        self.inner.sequences_count = sequences_count;
        self
    }
    pub fn preprocess_buffer(
        mut self,
        preprocess_buffer: Buffer,
    ) -> GeneratedCommandsInfoNVBuilder<'a> {
        self.inner.preprocess_buffer = preprocess_buffer;
        self
    }
    pub fn preprocess_offset(
        mut self,
        preprocess_offset: DeviceSize,
    ) -> GeneratedCommandsInfoNVBuilder<'a> {
        self.inner.preprocess_offset = preprocess_offset;
        self
    }
    pub fn preprocess_size(
        mut self,
        preprocess_size: DeviceSize,
    ) -> GeneratedCommandsInfoNVBuilder<'a> {
        self.inner.preprocess_size = preprocess_size;
        self
    }
    pub fn sequences_count_buffer(
        mut self,
        sequences_count_buffer: Buffer,
    ) -> GeneratedCommandsInfoNVBuilder<'a> {
        self.inner.sequences_count_buffer = sequences_count_buffer;
        self
    }
    pub fn sequences_count_offset(
        mut self,
        sequences_count_offset: DeviceSize,
    ) -> GeneratedCommandsInfoNVBuilder<'a> {
        self.inner.sequences_count_offset = sequences_count_offset;
        self
    }
    pub fn sequences_index_buffer(
        mut self,
        sequences_index_buffer: Buffer,
    ) -> GeneratedCommandsInfoNVBuilder<'a> {
        self.inner.sequences_index_buffer = sequences_index_buffer;
        self
    }
    pub fn sequences_index_offset(
        mut self,
        sequences_index_offset: DeviceSize,
    ) -> GeneratedCommandsInfoNVBuilder<'a> {
        self.inner.sequences_index_offset = sequences_index_offset;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsGeneratedCommandsInfoNV>(
        mut self,
        next: &'a mut T,
    ) -> GeneratedCommandsInfoNVBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> GeneratedCommandsInfoNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkGeneratedCommandsMemoryRequirementsInfoNV.html>"]
pub struct GeneratedCommandsMemoryRequirementsInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub pipeline_bind_point: PipelineBindPoint,
    pub pipeline: Pipeline,
    pub indirect_commands_layout: IndirectCommandsLayoutNV,
    pub max_sequences_count: u32,
}
impl ::std::default::Default for GeneratedCommandsMemoryRequirementsInfoNV {
    fn default() -> GeneratedCommandsMemoryRequirementsInfoNV {
        GeneratedCommandsMemoryRequirementsInfoNV {
            s_type: StructureType::GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV,
            p_next: ::std::ptr::null(),
            pipeline_bind_point: PipelineBindPoint::default(),
            pipeline: Pipeline::default(),
            indirect_commands_layout: IndirectCommandsLayoutNV::default(),
            max_sequences_count: u32::default(),
        }
    }
}
impl GeneratedCommandsMemoryRequirementsInfoNV {
    pub fn builder<'a>() -> GeneratedCommandsMemoryRequirementsInfoNVBuilder<'a> {
        GeneratedCommandsMemoryRequirementsInfoNVBuilder {
            inner: GeneratedCommandsMemoryRequirementsInfoNV::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct GeneratedCommandsMemoryRequirementsInfoNVBuilder<'a> {
    inner: GeneratedCommandsMemoryRequirementsInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsGeneratedCommandsMemoryRequirementsInfoNV {}
impl<'a> ::std::ops::Deref for GeneratedCommandsMemoryRequirementsInfoNVBuilder<'a> {
    type Target = GeneratedCommandsMemoryRequirementsInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for GeneratedCommandsMemoryRequirementsInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> GeneratedCommandsMemoryRequirementsInfoNVBuilder<'a> {
    pub fn pipeline_bind_point(
        mut self,
        pipeline_bind_point: PipelineBindPoint,
    ) -> GeneratedCommandsMemoryRequirementsInfoNVBuilder<'a> {
        self.inner.pipeline_bind_point = pipeline_bind_point;
        self
    }
    pub fn pipeline(
        mut self,
        pipeline: Pipeline,
    ) -> GeneratedCommandsMemoryRequirementsInfoNVBuilder<'a> {
        self.inner.pipeline = pipeline;
        self
    }
    pub fn indirect_commands_layout(
        mut self,
        indirect_commands_layout: IndirectCommandsLayoutNV,
    ) -> GeneratedCommandsMemoryRequirementsInfoNVBuilder<'a> {
        self.inner.indirect_commands_layout = indirect_commands_layout;
        self
    }
    pub fn max_sequences_count(
        mut self,
        max_sequences_count: u32,
    ) -> GeneratedCommandsMemoryRequirementsInfoNVBuilder<'a> {
        self.inner.max_sequences_count = max_sequences_count;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsGeneratedCommandsMemoryRequirementsInfoNV>(
        mut self,
        next: &'a mut T,
    ) -> GeneratedCommandsMemoryRequirementsInfoNVBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> GeneratedCommandsMemoryRequirementsInfoNV {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceFeatures2.html>"]
pub struct PhysicalDeviceFeatures2 {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub features: PhysicalDeviceFeatures,
}
impl ::std::default::Default for PhysicalDeviceFeatures2 {
    fn default() -> PhysicalDeviceFeatures2 {
        PhysicalDeviceFeatures2 {
            s_type: StructureType::PHYSICAL_DEVICE_FEATURES_2,
            p_next: ::std::ptr::null_mut(),
            features: PhysicalDeviceFeatures::default(),
        }
    }
}
impl PhysicalDeviceFeatures2 {
    pub fn builder<'a>() -> PhysicalDeviceFeatures2Builder<'a> {
        PhysicalDeviceFeatures2Builder {
            inner: PhysicalDeviceFeatures2::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceFeatures2Builder<'a> {
    inner: PhysicalDeviceFeatures2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceFeatures2Builder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceFeatures2 {}
impl<'a> ::std::ops::Deref for PhysicalDeviceFeatures2Builder<'a> {
    type Target = PhysicalDeviceFeatures2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceFeatures2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceFeatures2Builder<'a> {
    pub fn features(
        mut self,
        features: PhysicalDeviceFeatures,
    ) -> PhysicalDeviceFeatures2Builder<'a> {
        self.inner.features = features;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceFeatures2 {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceProperties2.html>"]
pub struct PhysicalDeviceProperties2 {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub properties: PhysicalDeviceProperties,
}
impl ::std::default::Default for PhysicalDeviceProperties2 {
    fn default() -> PhysicalDeviceProperties2 {
        PhysicalDeviceProperties2 {
            s_type: StructureType::PHYSICAL_DEVICE_PROPERTIES_2,
            p_next: ::std::ptr::null_mut(),
            properties: PhysicalDeviceProperties::default(),
        }
    }
}
impl PhysicalDeviceProperties2 {
    pub fn builder<'a>() -> PhysicalDeviceProperties2Builder<'a> {
        PhysicalDeviceProperties2Builder {
            inner: PhysicalDeviceProperties2::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceProperties2Builder<'a> {
    inner: PhysicalDeviceProperties2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPhysicalDeviceProperties2 {}
impl<'a> ::std::ops::Deref for PhysicalDeviceProperties2Builder<'a> {
    type Target = PhysicalDeviceProperties2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceProperties2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceProperties2Builder<'a> {
    pub fn properties(
        mut self,
        properties: PhysicalDeviceProperties,
    ) -> PhysicalDeviceProperties2Builder<'a> {
        self.inner.properties = properties;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceProperties2>(
        mut self,
        next: &'a mut T,
    ) -> PhysicalDeviceProperties2Builder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceProperties2 {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkFormatProperties2.html>"]
pub struct FormatProperties2 {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub format_properties: FormatProperties,
}
impl ::std::default::Default for FormatProperties2 {
    fn default() -> FormatProperties2 {
        FormatProperties2 {
            s_type: StructureType::FORMAT_PROPERTIES_2,
            p_next: ::std::ptr::null_mut(),
            format_properties: FormatProperties::default(),
        }
    }
}
impl FormatProperties2 {
    pub fn builder<'a>() -> FormatProperties2Builder<'a> {
        FormatProperties2Builder {
            inner: FormatProperties2::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct FormatProperties2Builder<'a> {
    inner: FormatProperties2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsFormatProperties2 {}
impl<'a> ::std::ops::Deref for FormatProperties2Builder<'a> {
    type Target = FormatProperties2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for FormatProperties2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> FormatProperties2Builder<'a> {
    pub fn format_properties(
        mut self,
        format_properties: FormatProperties,
    ) -> FormatProperties2Builder<'a> {
        self.inner.format_properties = format_properties;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsFormatProperties2>(
        mut self,
        next: &'a mut T,
    ) -> FormatProperties2Builder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> FormatProperties2 {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImageFormatProperties2.html>"]
pub struct ImageFormatProperties2 {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub image_format_properties: ImageFormatProperties,
}
impl ::std::default::Default for ImageFormatProperties2 {
    fn default() -> ImageFormatProperties2 {
        ImageFormatProperties2 {
            s_type: StructureType::IMAGE_FORMAT_PROPERTIES_2,
            p_next: ::std::ptr::null_mut(),
            image_format_properties: ImageFormatProperties::default(),
        }
    }
}
impl ImageFormatProperties2 {
    pub fn builder<'a>() -> ImageFormatProperties2Builder<'a> {
        ImageFormatProperties2Builder {
            inner: ImageFormatProperties2::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageFormatProperties2Builder<'a> {
    inner: ImageFormatProperties2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsImageFormatProperties2 {}
impl<'a> ::std::ops::Deref for ImageFormatProperties2Builder<'a> {
    type Target = ImageFormatProperties2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageFormatProperties2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageFormatProperties2Builder<'a> {
    pub fn image_format_properties(
        mut self,
        image_format_properties: ImageFormatProperties,
    ) -> ImageFormatProperties2Builder<'a> {
        self.inner.image_format_properties = image_format_properties;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsImageFormatProperties2>(
        mut self,
        next: &'a mut T,
    ) -> ImageFormatProperties2Builder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageFormatProperties2 {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceImageFormatInfo2.html>"]
pub struct PhysicalDeviceImageFormatInfo2 {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub format: Format,
    pub ty: ImageType,
    pub tiling: ImageTiling,
    pub usage: ImageUsageFlags,
    pub flags: ImageCreateFlags,
}
impl ::std::default::Default for PhysicalDeviceImageFormatInfo2 {
    fn default() -> PhysicalDeviceImageFormatInfo2 {
        PhysicalDeviceImageFormatInfo2 {
            s_type: StructureType::PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2,
            p_next: ::std::ptr::null(),
            format: Format::default(),
            ty: ImageType::default(),
            tiling: ImageTiling::default(),
            usage: ImageUsageFlags::default(),
            flags: ImageCreateFlags::default(),
        }
    }
}
impl PhysicalDeviceImageFormatInfo2 {
    pub fn builder<'a>() -> PhysicalDeviceImageFormatInfo2Builder<'a> {
        PhysicalDeviceImageFormatInfo2Builder {
            inner: PhysicalDeviceImageFormatInfo2::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceImageFormatInfo2Builder<'a> {
    inner: PhysicalDeviceImageFormatInfo2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPhysicalDeviceImageFormatInfo2 {}
impl<'a> ::std::ops::Deref for PhysicalDeviceImageFormatInfo2Builder<'a> {
    type Target = PhysicalDeviceImageFormatInfo2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceImageFormatInfo2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceImageFormatInfo2Builder<'a> {
    pub fn format(mut self, format: Format) -> PhysicalDeviceImageFormatInfo2Builder<'a> {
        self.inner.format = format;
        self
    }
    pub fn ty(mut self, ty: ImageType) -> PhysicalDeviceImageFormatInfo2Builder<'a> {
        self.inner.ty = ty;
        self
    }
    pub fn tiling(mut self, tiling: ImageTiling) -> PhysicalDeviceImageFormatInfo2Builder<'a> {
        self.inner.tiling = tiling;
        self
    }
    pub fn usage(mut self, usage: ImageUsageFlags) -> PhysicalDeviceImageFormatInfo2Builder<'a> {
        self.inner.usage = usage;
        self
    }
    pub fn flags(mut self, flags: ImageCreateFlags) -> PhysicalDeviceImageFormatInfo2Builder<'a> {
        self.inner.flags = flags;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceImageFormatInfo2>(
        mut self,
        next: &'a mut T,
    ) -> PhysicalDeviceImageFormatInfo2Builder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceImageFormatInfo2 {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkQueueFamilyProperties2.html>"]
pub struct QueueFamilyProperties2 {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub queue_family_properties: QueueFamilyProperties,
}
impl ::std::default::Default for QueueFamilyProperties2 {
    fn default() -> QueueFamilyProperties2 {
        QueueFamilyProperties2 {
            s_type: StructureType::QUEUE_FAMILY_PROPERTIES_2,
            p_next: ::std::ptr::null_mut(),
            queue_family_properties: QueueFamilyProperties::default(),
        }
    }
}
impl QueueFamilyProperties2 {
    pub fn builder<'a>() -> QueueFamilyProperties2Builder<'a> {
        QueueFamilyProperties2Builder {
            inner: QueueFamilyProperties2::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct QueueFamilyProperties2Builder<'a> {
    inner: QueueFamilyProperties2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsQueueFamilyProperties2 {}
impl<'a> ::std::ops::Deref for QueueFamilyProperties2Builder<'a> {
    type Target = QueueFamilyProperties2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for QueueFamilyProperties2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> QueueFamilyProperties2Builder<'a> {
    pub fn queue_family_properties(
        mut self,
        queue_family_properties: QueueFamilyProperties,
    ) -> QueueFamilyProperties2Builder<'a> {
        self.inner.queue_family_properties = queue_family_properties;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsQueueFamilyProperties2>(
        mut self,
        next: &'a mut T,
    ) -> QueueFamilyProperties2Builder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> QueueFamilyProperties2 {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceMemoryProperties2.html>"]
pub struct PhysicalDeviceMemoryProperties2 {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub memory_properties: PhysicalDeviceMemoryProperties,
}
impl ::std::default::Default for PhysicalDeviceMemoryProperties2 {
    fn default() -> PhysicalDeviceMemoryProperties2 {
        PhysicalDeviceMemoryProperties2 {
            s_type: StructureType::PHYSICAL_DEVICE_MEMORY_PROPERTIES_2,
            p_next: ::std::ptr::null_mut(),
            memory_properties: PhysicalDeviceMemoryProperties::default(),
        }
    }
}
impl PhysicalDeviceMemoryProperties2 {
    pub fn builder<'a>() -> PhysicalDeviceMemoryProperties2Builder<'a> {
        PhysicalDeviceMemoryProperties2Builder {
            inner: PhysicalDeviceMemoryProperties2::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceMemoryProperties2Builder<'a> {
    inner: PhysicalDeviceMemoryProperties2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPhysicalDeviceMemoryProperties2 {}
impl<'a> ::std::ops::Deref for PhysicalDeviceMemoryProperties2Builder<'a> {
    type Target = PhysicalDeviceMemoryProperties2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceMemoryProperties2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceMemoryProperties2Builder<'a> {
    pub fn memory_properties(
        mut self,
        memory_properties: PhysicalDeviceMemoryProperties,
    ) -> PhysicalDeviceMemoryProperties2Builder<'a> {
        self.inner.memory_properties = memory_properties;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceMemoryProperties2>(
        mut self,
        next: &'a mut T,
    ) -> PhysicalDeviceMemoryProperties2Builder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceMemoryProperties2 {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSparseImageFormatProperties2.html>"]
pub struct SparseImageFormatProperties2 {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub properties: SparseImageFormatProperties,
}
impl ::std::default::Default for SparseImageFormatProperties2 {
    fn default() -> SparseImageFormatProperties2 {
        SparseImageFormatProperties2 {
            s_type: StructureType::SPARSE_IMAGE_FORMAT_PROPERTIES_2,
            p_next: ::std::ptr::null_mut(),
            properties: SparseImageFormatProperties::default(),
        }
    }
}
impl SparseImageFormatProperties2 {
    pub fn builder<'a>() -> SparseImageFormatProperties2Builder<'a> {
        SparseImageFormatProperties2Builder {
            inner: SparseImageFormatProperties2::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SparseImageFormatProperties2Builder<'a> {
    inner: SparseImageFormatProperties2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsSparseImageFormatProperties2 {}
impl<'a> ::std::ops::Deref for SparseImageFormatProperties2Builder<'a> {
    type Target = SparseImageFormatProperties2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SparseImageFormatProperties2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SparseImageFormatProperties2Builder<'a> {
    pub fn properties(
        mut self,
        properties: SparseImageFormatProperties,
    ) -> SparseImageFormatProperties2Builder<'a> {
        self.inner.properties = properties;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSparseImageFormatProperties2>(
        mut self,
        next: &'a mut T,
    ) -> SparseImageFormatProperties2Builder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SparseImageFormatProperties2 {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceSparseImageFormatInfo2.html>"]
pub struct PhysicalDeviceSparseImageFormatInfo2 {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub format: Format,
    pub ty: ImageType,
    pub samples: SampleCountFlags,
    pub usage: ImageUsageFlags,
    pub tiling: ImageTiling,
}
impl ::std::default::Default for PhysicalDeviceSparseImageFormatInfo2 {
    fn default() -> PhysicalDeviceSparseImageFormatInfo2 {
        PhysicalDeviceSparseImageFormatInfo2 {
            s_type: StructureType::PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2,
            p_next: ::std::ptr::null(),
            format: Format::default(),
            ty: ImageType::default(),
            samples: SampleCountFlags::default(),
            usage: ImageUsageFlags::default(),
            tiling: ImageTiling::default(),
        }
    }
}
impl PhysicalDeviceSparseImageFormatInfo2 {
    pub fn builder<'a>() -> PhysicalDeviceSparseImageFormatInfo2Builder<'a> {
        PhysicalDeviceSparseImageFormatInfo2Builder {
            inner: PhysicalDeviceSparseImageFormatInfo2::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceSparseImageFormatInfo2Builder<'a> {
    inner: PhysicalDeviceSparseImageFormatInfo2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPhysicalDeviceSparseImageFormatInfo2 {}
impl<'a> ::std::ops::Deref for PhysicalDeviceSparseImageFormatInfo2Builder<'a> {
    type Target = PhysicalDeviceSparseImageFormatInfo2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceSparseImageFormatInfo2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceSparseImageFormatInfo2Builder<'a> {
    pub fn format(mut self, format: Format) -> PhysicalDeviceSparseImageFormatInfo2Builder<'a> {
        self.inner.format = format;
        self
    }
    pub fn ty(mut self, ty: ImageType) -> PhysicalDeviceSparseImageFormatInfo2Builder<'a> {
        self.inner.ty = ty;
        self
    }
    pub fn samples(
        mut self,
        samples: SampleCountFlags,
    ) -> PhysicalDeviceSparseImageFormatInfo2Builder<'a> {
        self.inner.samples = samples;
        self
    }
    pub fn usage(
        mut self,
        usage: ImageUsageFlags,
    ) -> PhysicalDeviceSparseImageFormatInfo2Builder<'a> {
        self.inner.usage = usage;
        self
    }
    pub fn tiling(
        mut self,
        tiling: ImageTiling,
    ) -> PhysicalDeviceSparseImageFormatInfo2Builder<'a> {
        self.inner.tiling = tiling;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceSparseImageFormatInfo2>(
        mut self,
        next: &'a mut T,
    ) -> PhysicalDeviceSparseImageFormatInfo2Builder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceSparseImageFormatInfo2 {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDevicePushDescriptorPropertiesKHR.html>"]
pub struct PhysicalDevicePushDescriptorPropertiesKHR {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_push_descriptors: u32,
}
impl ::std::default::Default for PhysicalDevicePushDescriptorPropertiesKHR {
    fn default() -> PhysicalDevicePushDescriptorPropertiesKHR {
        PhysicalDevicePushDescriptorPropertiesKHR {
            s_type: StructureType::PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR,
            p_next: ::std::ptr::null_mut(),
            max_push_descriptors: u32::default(),
        }
    }
}
impl PhysicalDevicePushDescriptorPropertiesKHR {
    pub fn builder<'a>() -> PhysicalDevicePushDescriptorPropertiesKHRBuilder<'a> {
        PhysicalDevicePushDescriptorPropertiesKHRBuilder {
            inner: PhysicalDevicePushDescriptorPropertiesKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDevicePushDescriptorPropertiesKHRBuilder<'a> {
    inner: PhysicalDevicePushDescriptorPropertiesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDevicePushDescriptorPropertiesKHRBuilder<'_>
{
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDevicePushDescriptorPropertiesKHR {}
impl<'a> ::std::ops::Deref for PhysicalDevicePushDescriptorPropertiesKHRBuilder<'a> {
    type Target = PhysicalDevicePushDescriptorPropertiesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDevicePushDescriptorPropertiesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDevicePushDescriptorPropertiesKHRBuilder<'a> {
    pub fn max_push_descriptors(
        mut self,
        max_push_descriptors: u32,
    ) -> PhysicalDevicePushDescriptorPropertiesKHRBuilder<'a> {
        self.inner.max_push_descriptors = max_push_descriptors;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDevicePushDescriptorPropertiesKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkConformanceVersion.html>"]
pub struct ConformanceVersion {
    pub major: u8,
    pub minor: u8,
    pub subminor: u8,
    pub patch: u8,
}
impl ConformanceVersion {
    pub fn builder<'a>() -> ConformanceVersionBuilder<'a> {
        ConformanceVersionBuilder {
            inner: ConformanceVersion::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ConformanceVersionBuilder<'a> {
    inner: ConformanceVersion,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ConformanceVersionBuilder<'a> {
    type Target = ConformanceVersion;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ConformanceVersionBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ConformanceVersionBuilder<'a> {
    pub fn major(mut self, major: u8) -> ConformanceVersionBuilder<'a> {
        self.inner.major = major;
        self
    }
    pub fn minor(mut self, minor: u8) -> ConformanceVersionBuilder<'a> {
        self.inner.minor = minor;
        self
    }
    pub fn subminor(mut self, subminor: u8) -> ConformanceVersionBuilder<'a> {
        self.inner.subminor = subminor;
        self
    }
    pub fn patch(mut self, patch: u8) -> ConformanceVersionBuilder<'a> {
        self.inner.patch = patch;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ConformanceVersion {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceDriverProperties.html>"]
pub struct PhysicalDeviceDriverProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub driver_id: DriverId,
    pub driver_name: [c_char; MAX_DRIVER_NAME_SIZE],
    pub driver_info: [c_char; MAX_DRIVER_INFO_SIZE],
    pub conformance_version: ConformanceVersion,
}
impl fmt::Debug for PhysicalDeviceDriverProperties {
    fn fmt(&self, fmt: &mut fmt::Formatter) -> fmt::Result {
        fmt.debug_struct("PhysicalDeviceDriverProperties")
            .field("s_type", &self.s_type)
            .field("p_next", &self.p_next)
            .field("driver_id", &self.driver_id)
            .field("driver_name", &unsafe {
                ::std::ffi::CStr::from_ptr(self.driver_name.as_ptr() as *const c_char)
            })
            .field("driver_info", &unsafe {
                ::std::ffi::CStr::from_ptr(self.driver_info.as_ptr() as *const c_char)
            })
            .field("conformance_version", &self.conformance_version)
            .finish()
    }
}
impl ::std::default::Default for PhysicalDeviceDriverProperties {
    fn default() -> PhysicalDeviceDriverProperties {
        PhysicalDeviceDriverProperties {
            s_type: StructureType::PHYSICAL_DEVICE_DRIVER_PROPERTIES,
            p_next: ::std::ptr::null_mut(),
            driver_id: DriverId::default(),
            driver_name: unsafe { ::std::mem::zeroed() },
            driver_info: unsafe { ::std::mem::zeroed() },
            conformance_version: ConformanceVersion::default(),
        }
    }
}
impl PhysicalDeviceDriverProperties {
    pub fn builder<'a>() -> PhysicalDeviceDriverPropertiesBuilder<'a> {
        PhysicalDeviceDriverPropertiesBuilder {
            inner: PhysicalDeviceDriverProperties::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceDriverPropertiesBuilder<'a> {
    inner: PhysicalDeviceDriverProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceDriverPropertiesBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceDriverProperties {}
impl<'a> ::std::ops::Deref for PhysicalDeviceDriverPropertiesBuilder<'a> {
    type Target = PhysicalDeviceDriverProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceDriverPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceDriverPropertiesBuilder<'a> {
    pub fn driver_id(mut self, driver_id: DriverId) -> PhysicalDeviceDriverPropertiesBuilder<'a> {
        self.inner.driver_id = driver_id;
        self
    }
    pub fn driver_name(
        mut self,
        driver_name: [c_char; MAX_DRIVER_NAME_SIZE],
    ) -> PhysicalDeviceDriverPropertiesBuilder<'a> {
        self.inner.driver_name = driver_name;
        self
    }
    pub fn driver_info(
        mut self,
        driver_info: [c_char; MAX_DRIVER_INFO_SIZE],
    ) -> PhysicalDeviceDriverPropertiesBuilder<'a> {
        self.inner.driver_info = driver_info;
        self
    }
    pub fn conformance_version(
        mut self,
        conformance_version: ConformanceVersion,
    ) -> PhysicalDeviceDriverPropertiesBuilder<'a> {
        self.inner.conformance_version = conformance_version;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceDriverProperties {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPresentRegionsKHR.html>"]
pub struct PresentRegionsKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub swapchain_count: u32,
    pub p_regions: *const PresentRegionKHR,
}
impl ::std::default::Default for PresentRegionsKHR {
    fn default() -> PresentRegionsKHR {
        PresentRegionsKHR {
            s_type: StructureType::PRESENT_REGIONS_KHR,
            p_next: ::std::ptr::null(),
            swapchain_count: u32::default(),
            p_regions: ::std::ptr::null(),
        }
    }
}
impl PresentRegionsKHR {
    pub fn builder<'a>() -> PresentRegionsKHRBuilder<'a> {
        PresentRegionsKHRBuilder {
            inner: PresentRegionsKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PresentRegionsKHRBuilder<'a> {
    inner: PresentRegionsKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPresentInfoKHR for PresentRegionsKHRBuilder<'_> {}
unsafe impl ExtendsPresentInfoKHR for PresentRegionsKHR {}
impl<'a> ::std::ops::Deref for PresentRegionsKHRBuilder<'a> {
    type Target = PresentRegionsKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PresentRegionsKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PresentRegionsKHRBuilder<'a> {
    pub fn regions(mut self, regions: &'a [PresentRegionKHR]) -> PresentRegionsKHRBuilder<'a> {
        self.inner.swapchain_count = regions.len() as _;
        self.inner.p_regions = regions.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PresentRegionsKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPresentRegionKHR.html>"]
pub struct PresentRegionKHR {
    pub rectangle_count: u32,
    pub p_rectangles: *const RectLayerKHR,
}
impl ::std::default::Default for PresentRegionKHR {
    fn default() -> PresentRegionKHR {
        PresentRegionKHR {
            rectangle_count: u32::default(),
            p_rectangles: ::std::ptr::null(),
        }
    }
}
impl PresentRegionKHR {
    pub fn builder<'a>() -> PresentRegionKHRBuilder<'a> {
        PresentRegionKHRBuilder {
            inner: PresentRegionKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PresentRegionKHRBuilder<'a> {
    inner: PresentRegionKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PresentRegionKHRBuilder<'a> {
    type Target = PresentRegionKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PresentRegionKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PresentRegionKHRBuilder<'a> {
    pub fn rectangles(mut self, rectangles: &'a [RectLayerKHR]) -> PresentRegionKHRBuilder<'a> {
        self.inner.rectangle_count = rectangles.len() as _;
        self.inner.p_rectangles = rectangles.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PresentRegionKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkRectLayerKHR.html>"]
pub struct RectLayerKHR {
    pub offset: Offset2D,
    pub extent: Extent2D,
    pub layer: u32,
}
impl RectLayerKHR {
    pub fn builder<'a>() -> RectLayerKHRBuilder<'a> {
        RectLayerKHRBuilder {
            inner: RectLayerKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct RectLayerKHRBuilder<'a> {
    inner: RectLayerKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for RectLayerKHRBuilder<'a> {
    type Target = RectLayerKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for RectLayerKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> RectLayerKHRBuilder<'a> {
    pub fn offset(mut self, offset: Offset2D) -> RectLayerKHRBuilder<'a> {
        self.inner.offset = offset;
        self
    }
    pub fn extent(mut self, extent: Extent2D) -> RectLayerKHRBuilder<'a> {
        self.inner.extent = extent;
        self
    }
    pub fn layer(mut self, layer: u32) -> RectLayerKHRBuilder<'a> {
        self.inner.layer = layer;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> RectLayerKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceVariablePointersFeatures.html>"]
pub struct PhysicalDeviceVariablePointersFeatures {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub variable_pointers_storage_buffer: Bool32,
    pub variable_pointers: Bool32,
}
impl ::std::default::Default for PhysicalDeviceVariablePointersFeatures {
    fn default() -> PhysicalDeviceVariablePointersFeatures {
        PhysicalDeviceVariablePointersFeatures {
            s_type: StructureType::PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES,
            p_next: ::std::ptr::null_mut(),
            variable_pointers_storage_buffer: Bool32::default(),
            variable_pointers: Bool32::default(),
        }
    }
}
impl PhysicalDeviceVariablePointersFeatures {
    pub fn builder<'a>() -> PhysicalDeviceVariablePointersFeaturesBuilder<'a> {
        PhysicalDeviceVariablePointersFeaturesBuilder {
            inner: PhysicalDeviceVariablePointersFeatures::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceVariablePointersFeaturesBuilder<'a> {
    inner: PhysicalDeviceVariablePointersFeatures,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceVariablePointersFeaturesBuilder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceVariablePointersFeatures {}
impl<'a> ::std::ops::Deref for PhysicalDeviceVariablePointersFeaturesBuilder<'a> {
    type Target = PhysicalDeviceVariablePointersFeatures;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceVariablePointersFeaturesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceVariablePointersFeaturesBuilder<'a> {
    pub fn variable_pointers_storage_buffer(
        mut self,
        variable_pointers_storage_buffer: bool,
    ) -> PhysicalDeviceVariablePointersFeaturesBuilder<'a> {
        self.inner.variable_pointers_storage_buffer = variable_pointers_storage_buffer.into();
        self
    }
    pub fn variable_pointers(
        mut self,
        variable_pointers: bool,
    ) -> PhysicalDeviceVariablePointersFeaturesBuilder<'a> {
        self.inner.variable_pointers = variable_pointers.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceVariablePointersFeatures {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalMemoryProperties.html>"]
pub struct ExternalMemoryProperties {
    pub external_memory_features: ExternalMemoryFeatureFlags,
    pub export_from_imported_handle_types: ExternalMemoryHandleTypeFlags,
    pub compatible_handle_types: ExternalMemoryHandleTypeFlags,
}
impl ExternalMemoryProperties {
    pub fn builder<'a>() -> ExternalMemoryPropertiesBuilder<'a> {
        ExternalMemoryPropertiesBuilder {
            inner: ExternalMemoryProperties::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExternalMemoryPropertiesBuilder<'a> {
    inner: ExternalMemoryProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ExternalMemoryPropertiesBuilder<'a> {
    type Target = ExternalMemoryProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExternalMemoryPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExternalMemoryPropertiesBuilder<'a> {
    pub fn external_memory_features(
        mut self,
        external_memory_features: ExternalMemoryFeatureFlags,
    ) -> ExternalMemoryPropertiesBuilder<'a> {
        self.inner.external_memory_features = external_memory_features;
        self
    }
    pub fn export_from_imported_handle_types(
        mut self,
        export_from_imported_handle_types: ExternalMemoryHandleTypeFlags,
    ) -> ExternalMemoryPropertiesBuilder<'a> {
        self.inner.export_from_imported_handle_types = export_from_imported_handle_types;
        self
    }
    pub fn compatible_handle_types(
        mut self,
        compatible_handle_types: ExternalMemoryHandleTypeFlags,
    ) -> ExternalMemoryPropertiesBuilder<'a> {
        self.inner.compatible_handle_types = compatible_handle_types;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExternalMemoryProperties {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceExternalImageFormatInfo.html>"]
pub struct PhysicalDeviceExternalImageFormatInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlags,
}
impl ::std::default::Default for PhysicalDeviceExternalImageFormatInfo {
    fn default() -> PhysicalDeviceExternalImageFormatInfo {
        PhysicalDeviceExternalImageFormatInfo {
            s_type: StructureType::PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO,
            p_next: ::std::ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}
impl PhysicalDeviceExternalImageFormatInfo {
    pub fn builder<'a>() -> PhysicalDeviceExternalImageFormatInfoBuilder<'a> {
        PhysicalDeviceExternalImageFormatInfoBuilder {
            inner: PhysicalDeviceExternalImageFormatInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceExternalImageFormatInfoBuilder<'a> {
    inner: PhysicalDeviceExternalImageFormatInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceImageFormatInfo2
    for PhysicalDeviceExternalImageFormatInfoBuilder<'_>
{
}
unsafe impl ExtendsPhysicalDeviceImageFormatInfo2 for PhysicalDeviceExternalImageFormatInfo {}
impl<'a> ::std::ops::Deref for PhysicalDeviceExternalImageFormatInfoBuilder<'a> {
    type Target = PhysicalDeviceExternalImageFormatInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceExternalImageFormatInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceExternalImageFormatInfoBuilder<'a> {
    pub fn handle_type(
        mut self,
        handle_type: ExternalMemoryHandleTypeFlags,
    ) -> PhysicalDeviceExternalImageFormatInfoBuilder<'a> {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceExternalImageFormatInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalImageFormatProperties.html>"]
pub struct ExternalImageFormatProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub external_memory_properties: ExternalMemoryProperties,
}
impl ::std::default::Default for ExternalImageFormatProperties {
    fn default() -> ExternalImageFormatProperties {
        ExternalImageFormatProperties {
            s_type: StructureType::EXTERNAL_IMAGE_FORMAT_PROPERTIES,
            p_next: ::std::ptr::null_mut(),
            external_memory_properties: ExternalMemoryProperties::default(),
        }
    }
}
impl ExternalImageFormatProperties {
    pub fn builder<'a>() -> ExternalImageFormatPropertiesBuilder<'a> {
        ExternalImageFormatPropertiesBuilder {
            inner: ExternalImageFormatProperties::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExternalImageFormatPropertiesBuilder<'a> {
    inner: ExternalImageFormatProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsImageFormatProperties2 for ExternalImageFormatPropertiesBuilder<'_> {}
unsafe impl ExtendsImageFormatProperties2 for ExternalImageFormatProperties {}
impl<'a> ::std::ops::Deref for ExternalImageFormatPropertiesBuilder<'a> {
    type Target = ExternalImageFormatProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExternalImageFormatPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExternalImageFormatPropertiesBuilder<'a> {
    pub fn external_memory_properties(
        mut self,
        external_memory_properties: ExternalMemoryProperties,
    ) -> ExternalImageFormatPropertiesBuilder<'a> {
        self.inner.external_memory_properties = external_memory_properties;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExternalImageFormatProperties {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceExternalBufferInfo.html>"]
pub struct PhysicalDeviceExternalBufferInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: BufferCreateFlags,
    pub usage: BufferUsageFlags,
    pub handle_type: ExternalMemoryHandleTypeFlags,
}
impl ::std::default::Default for PhysicalDeviceExternalBufferInfo {
    fn default() -> PhysicalDeviceExternalBufferInfo {
        PhysicalDeviceExternalBufferInfo {
            s_type: StructureType::PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO,
            p_next: ::std::ptr::null(),
            flags: BufferCreateFlags::default(),
            usage: BufferUsageFlags::default(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}
impl PhysicalDeviceExternalBufferInfo {
    pub fn builder<'a>() -> PhysicalDeviceExternalBufferInfoBuilder<'a> {
        PhysicalDeviceExternalBufferInfoBuilder {
            inner: PhysicalDeviceExternalBufferInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceExternalBufferInfoBuilder<'a> {
    inner: PhysicalDeviceExternalBufferInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPhysicalDeviceExternalBufferInfo {}
impl<'a> ::std::ops::Deref for PhysicalDeviceExternalBufferInfoBuilder<'a> {
    type Target = PhysicalDeviceExternalBufferInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceExternalBufferInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceExternalBufferInfoBuilder<'a> {
    pub fn flags(
        mut self,
        flags: BufferCreateFlags,
    ) -> PhysicalDeviceExternalBufferInfoBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn usage(mut self, usage: BufferUsageFlags) -> PhysicalDeviceExternalBufferInfoBuilder<'a> {
        self.inner.usage = usage;
        self
    }
    pub fn handle_type(
        mut self,
        handle_type: ExternalMemoryHandleTypeFlags,
    ) -> PhysicalDeviceExternalBufferInfoBuilder<'a> {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceExternalBufferInfo>(
        mut self,
        next: &'a mut T,
    ) -> PhysicalDeviceExternalBufferInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceExternalBufferInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalBufferProperties.html>"]
pub struct ExternalBufferProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub external_memory_properties: ExternalMemoryProperties,
}
impl ::std::default::Default for ExternalBufferProperties {
    fn default() -> ExternalBufferProperties {
        ExternalBufferProperties {
            s_type: StructureType::EXTERNAL_BUFFER_PROPERTIES,
            p_next: ::std::ptr::null_mut(),
            external_memory_properties: ExternalMemoryProperties::default(),
        }
    }
}
impl ExternalBufferProperties {
    pub fn builder<'a>() -> ExternalBufferPropertiesBuilder<'a> {
        ExternalBufferPropertiesBuilder {
            inner: ExternalBufferProperties::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExternalBufferPropertiesBuilder<'a> {
    inner: ExternalBufferProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsExternalBufferProperties {}
impl<'a> ::std::ops::Deref for ExternalBufferPropertiesBuilder<'a> {
    type Target = ExternalBufferProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExternalBufferPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExternalBufferPropertiesBuilder<'a> {
    pub fn external_memory_properties(
        mut self,
        external_memory_properties: ExternalMemoryProperties,
    ) -> ExternalBufferPropertiesBuilder<'a> {
        self.inner.external_memory_properties = external_memory_properties;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsExternalBufferProperties>(
        mut self,
        next: &'a mut T,
    ) -> ExternalBufferPropertiesBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExternalBufferProperties {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceIDProperties.html>"]
pub struct PhysicalDeviceIDProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub device_uuid: [u8; UUID_SIZE],
    pub driver_uuid: [u8; UUID_SIZE],
    pub device_luid: [u8; LUID_SIZE],
    pub device_node_mask: u32,
    pub device_luid_valid: Bool32,
}
impl ::std::default::Default for PhysicalDeviceIDProperties {
    fn default() -> PhysicalDeviceIDProperties {
        PhysicalDeviceIDProperties {
            s_type: StructureType::PHYSICAL_DEVICE_ID_PROPERTIES,
            p_next: ::std::ptr::null_mut(),
            device_uuid: unsafe { ::std::mem::zeroed() },
            driver_uuid: unsafe { ::std::mem::zeroed() },
            device_luid: unsafe { ::std::mem::zeroed() },
            device_node_mask: u32::default(),
            device_luid_valid: Bool32::default(),
        }
    }
}
impl PhysicalDeviceIDProperties {
    pub fn builder<'a>() -> PhysicalDeviceIDPropertiesBuilder<'a> {
        PhysicalDeviceIDPropertiesBuilder {
            inner: PhysicalDeviceIDProperties::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceIDPropertiesBuilder<'a> {
    inner: PhysicalDeviceIDProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceIDPropertiesBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceIDProperties {}
impl<'a> ::std::ops::Deref for PhysicalDeviceIDPropertiesBuilder<'a> {
    type Target = PhysicalDeviceIDProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceIDPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceIDPropertiesBuilder<'a> {
    pub fn device_uuid(
        mut self,
        device_uuid: [u8; UUID_SIZE],
    ) -> PhysicalDeviceIDPropertiesBuilder<'a> {
        self.inner.device_uuid = device_uuid;
        self
    }
    pub fn driver_uuid(
        mut self,
        driver_uuid: [u8; UUID_SIZE],
    ) -> PhysicalDeviceIDPropertiesBuilder<'a> {
        self.inner.driver_uuid = driver_uuid;
        self
    }
    pub fn device_luid(
        mut self,
        device_luid: [u8; LUID_SIZE],
    ) -> PhysicalDeviceIDPropertiesBuilder<'a> {
        self.inner.device_luid = device_luid;
        self
    }
    pub fn device_node_mask(
        mut self,
        device_node_mask: u32,
    ) -> PhysicalDeviceIDPropertiesBuilder<'a> {
        self.inner.device_node_mask = device_node_mask;
        self
    }
    pub fn device_luid_valid(
        mut self,
        device_luid_valid: bool,
    ) -> PhysicalDeviceIDPropertiesBuilder<'a> {
        self.inner.device_luid_valid = device_luid_valid.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceIDProperties {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalMemoryImageCreateInfo.html>"]
pub struct ExternalMemoryImageCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlags,
}
impl ::std::default::Default for ExternalMemoryImageCreateInfo {
    fn default() -> ExternalMemoryImageCreateInfo {
        ExternalMemoryImageCreateInfo {
            s_type: StructureType::EXTERNAL_MEMORY_IMAGE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}
impl ExternalMemoryImageCreateInfo {
    pub fn builder<'a>() -> ExternalMemoryImageCreateInfoBuilder<'a> {
        ExternalMemoryImageCreateInfoBuilder {
            inner: ExternalMemoryImageCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExternalMemoryImageCreateInfoBuilder<'a> {
    inner: ExternalMemoryImageCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsImageCreateInfo for ExternalMemoryImageCreateInfoBuilder<'_> {}
unsafe impl ExtendsImageCreateInfo for ExternalMemoryImageCreateInfo {}
impl<'a> ::std::ops::Deref for ExternalMemoryImageCreateInfoBuilder<'a> {
    type Target = ExternalMemoryImageCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExternalMemoryImageCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExternalMemoryImageCreateInfoBuilder<'a> {
    pub fn handle_types(
        mut self,
        handle_types: ExternalMemoryHandleTypeFlags,
    ) -> ExternalMemoryImageCreateInfoBuilder<'a> {
        self.inner.handle_types = handle_types;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExternalMemoryImageCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalMemoryBufferCreateInfo.html>"]
pub struct ExternalMemoryBufferCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlags,
}
impl ::std::default::Default for ExternalMemoryBufferCreateInfo {
    fn default() -> ExternalMemoryBufferCreateInfo {
        ExternalMemoryBufferCreateInfo {
            s_type: StructureType::EXTERNAL_MEMORY_BUFFER_CREATE_INFO,
            p_next: ::std::ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}
impl ExternalMemoryBufferCreateInfo {
    pub fn builder<'a>() -> ExternalMemoryBufferCreateInfoBuilder<'a> {
        ExternalMemoryBufferCreateInfoBuilder {
            inner: ExternalMemoryBufferCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExternalMemoryBufferCreateInfoBuilder<'a> {
    inner: ExternalMemoryBufferCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsBufferCreateInfo for ExternalMemoryBufferCreateInfoBuilder<'_> {}
unsafe impl ExtendsBufferCreateInfo for ExternalMemoryBufferCreateInfo {}
impl<'a> ::std::ops::Deref for ExternalMemoryBufferCreateInfoBuilder<'a> {
    type Target = ExternalMemoryBufferCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExternalMemoryBufferCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExternalMemoryBufferCreateInfoBuilder<'a> {
    pub fn handle_types(
        mut self,
        handle_types: ExternalMemoryHandleTypeFlags,
    ) -> ExternalMemoryBufferCreateInfoBuilder<'a> {
        self.inner.handle_types = handle_types;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExternalMemoryBufferCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExportMemoryAllocateInfo.html>"]
pub struct ExportMemoryAllocateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlags,
}
impl ::std::default::Default for ExportMemoryAllocateInfo {
    fn default() -> ExportMemoryAllocateInfo {
        ExportMemoryAllocateInfo {
            s_type: StructureType::EXPORT_MEMORY_ALLOCATE_INFO,
            p_next: ::std::ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}
impl ExportMemoryAllocateInfo {
    pub fn builder<'a>() -> ExportMemoryAllocateInfoBuilder<'a> {
        ExportMemoryAllocateInfoBuilder {
            inner: ExportMemoryAllocateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExportMemoryAllocateInfoBuilder<'a> {
    inner: ExportMemoryAllocateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryAllocateInfoBuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryAllocateInfo {}
impl<'a> ::std::ops::Deref for ExportMemoryAllocateInfoBuilder<'a> {
    type Target = ExportMemoryAllocateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExportMemoryAllocateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExportMemoryAllocateInfoBuilder<'a> {
    pub fn handle_types(
        mut self,
        handle_types: ExternalMemoryHandleTypeFlags,
    ) -> ExportMemoryAllocateInfoBuilder<'a> {
        self.inner.handle_types = handle_types;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExportMemoryAllocateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImportMemoryWin32HandleInfoKHR.html>"]
pub struct ImportMemoryWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlags,
    pub handle: HANDLE,
    pub name: LPCWSTR,
}
impl ::std::default::Default for ImportMemoryWin32HandleInfoKHR {
    fn default() -> ImportMemoryWin32HandleInfoKHR {
        ImportMemoryWin32HandleInfoKHR {
            s_type: StructureType::IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR,
            p_next: ::std::ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
            handle: unsafe { ::std::mem::zeroed() },
            name: unsafe { ::std::mem::zeroed() },
        }
    }
}
impl ImportMemoryWin32HandleInfoKHR {
    pub fn builder<'a>() -> ImportMemoryWin32HandleInfoKHRBuilder<'a> {
        ImportMemoryWin32HandleInfoKHRBuilder {
            inner: ImportMemoryWin32HandleInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImportMemoryWin32HandleInfoKHRBuilder<'a> {
    inner: ImportMemoryWin32HandleInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryWin32HandleInfoKHRBuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryWin32HandleInfoKHR {}
impl<'a> ::std::ops::Deref for ImportMemoryWin32HandleInfoKHRBuilder<'a> {
    type Target = ImportMemoryWin32HandleInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImportMemoryWin32HandleInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImportMemoryWin32HandleInfoKHRBuilder<'a> {
    pub fn handle_type(
        mut self,
        handle_type: ExternalMemoryHandleTypeFlags,
    ) -> ImportMemoryWin32HandleInfoKHRBuilder<'a> {
        self.inner.handle_type = handle_type;
        self
    }
    pub fn handle(mut self, handle: HANDLE) -> ImportMemoryWin32HandleInfoKHRBuilder<'a> {
        self.inner.handle = handle;
        self
    }
    pub fn name(mut self, name: LPCWSTR) -> ImportMemoryWin32HandleInfoKHRBuilder<'a> {
        self.inner.name = name;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImportMemoryWin32HandleInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExportMemoryWin32HandleInfoKHR.html>"]
pub struct ExportMemoryWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_attributes: *const SECURITY_ATTRIBUTES,
    pub dw_access: DWORD,
    pub name: LPCWSTR,
}
impl ::std::default::Default for ExportMemoryWin32HandleInfoKHR {
    fn default() -> ExportMemoryWin32HandleInfoKHR {
        ExportMemoryWin32HandleInfoKHR {
            s_type: StructureType::EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR,
            p_next: ::std::ptr::null(),
            p_attributes: ::std::ptr::null(),
            dw_access: DWORD::default(),
            name: unsafe { ::std::mem::zeroed() },
        }
    }
}
impl ExportMemoryWin32HandleInfoKHR {
    pub fn builder<'a>() -> ExportMemoryWin32HandleInfoKHRBuilder<'a> {
        ExportMemoryWin32HandleInfoKHRBuilder {
            inner: ExportMemoryWin32HandleInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExportMemoryWin32HandleInfoKHRBuilder<'a> {
    inner: ExportMemoryWin32HandleInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryWin32HandleInfoKHRBuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryWin32HandleInfoKHR {}
impl<'a> ::std::ops::Deref for ExportMemoryWin32HandleInfoKHRBuilder<'a> {
    type Target = ExportMemoryWin32HandleInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExportMemoryWin32HandleInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExportMemoryWin32HandleInfoKHRBuilder<'a> {
    pub fn attributes(
        mut self,
        attributes: &'a SECURITY_ATTRIBUTES,
    ) -> ExportMemoryWin32HandleInfoKHRBuilder<'a> {
        self.inner.p_attributes = attributes;
        self
    }
    pub fn dw_access(mut self, dw_access: DWORD) -> ExportMemoryWin32HandleInfoKHRBuilder<'a> {
        self.inner.dw_access = dw_access;
        self
    }
    pub fn name(mut self, name: LPCWSTR) -> ExportMemoryWin32HandleInfoKHRBuilder<'a> {
        self.inner.name = name;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExportMemoryWin32HandleInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryWin32HandlePropertiesKHR.html>"]
pub struct MemoryWin32HandlePropertiesKHR {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub memory_type_bits: u32,
}
impl ::std::default::Default for MemoryWin32HandlePropertiesKHR {
    fn default() -> MemoryWin32HandlePropertiesKHR {
        MemoryWin32HandlePropertiesKHR {
            s_type: StructureType::MEMORY_WIN32_HANDLE_PROPERTIES_KHR,
            p_next: ::std::ptr::null_mut(),
            memory_type_bits: u32::default(),
        }
    }
}
impl MemoryWin32HandlePropertiesKHR {
    pub fn builder<'a>() -> MemoryWin32HandlePropertiesKHRBuilder<'a> {
        MemoryWin32HandlePropertiesKHRBuilder {
            inner: MemoryWin32HandlePropertiesKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryWin32HandlePropertiesKHRBuilder<'a> {
    inner: MemoryWin32HandlePropertiesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsMemoryWin32HandlePropertiesKHR {}
impl<'a> ::std::ops::Deref for MemoryWin32HandlePropertiesKHRBuilder<'a> {
    type Target = MemoryWin32HandlePropertiesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryWin32HandlePropertiesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryWin32HandlePropertiesKHRBuilder<'a> {
    pub fn memory_type_bits(
        mut self,
        memory_type_bits: u32,
    ) -> MemoryWin32HandlePropertiesKHRBuilder<'a> {
        self.inner.memory_type_bits = memory_type_bits;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsMemoryWin32HandlePropertiesKHR>(
        mut self,
        next: &'a mut T,
    ) -> MemoryWin32HandlePropertiesKHRBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryWin32HandlePropertiesKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryGetWin32HandleInfoKHR.html>"]
pub struct MemoryGetWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub memory: DeviceMemory,
    pub handle_type: ExternalMemoryHandleTypeFlags,
}
impl ::std::default::Default for MemoryGetWin32HandleInfoKHR {
    fn default() -> MemoryGetWin32HandleInfoKHR {
        MemoryGetWin32HandleInfoKHR {
            s_type: StructureType::MEMORY_GET_WIN32_HANDLE_INFO_KHR,
            p_next: ::std::ptr::null(),
            memory: DeviceMemory::default(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}
impl MemoryGetWin32HandleInfoKHR {
    pub fn builder<'a>() -> MemoryGetWin32HandleInfoKHRBuilder<'a> {
        MemoryGetWin32HandleInfoKHRBuilder {
            inner: MemoryGetWin32HandleInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryGetWin32HandleInfoKHRBuilder<'a> {
    inner: MemoryGetWin32HandleInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsMemoryGetWin32HandleInfoKHR {}
impl<'a> ::std::ops::Deref for MemoryGetWin32HandleInfoKHRBuilder<'a> {
    type Target = MemoryGetWin32HandleInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryGetWin32HandleInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryGetWin32HandleInfoKHRBuilder<'a> {
    pub fn memory(mut self, memory: DeviceMemory) -> MemoryGetWin32HandleInfoKHRBuilder<'a> {
        self.inner.memory = memory;
        self
    }
    pub fn handle_type(
        mut self,
        handle_type: ExternalMemoryHandleTypeFlags,
    ) -> MemoryGetWin32HandleInfoKHRBuilder<'a> {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsMemoryGetWin32HandleInfoKHR>(
        mut self,
        next: &'a mut T,
    ) -> MemoryGetWin32HandleInfoKHRBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryGetWin32HandleInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImportMemoryFdInfoKHR.html>"]
pub struct ImportMemoryFdInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlags,
    pub fd: c_int,
}
impl ::std::default::Default for ImportMemoryFdInfoKHR {
    fn default() -> ImportMemoryFdInfoKHR {
        ImportMemoryFdInfoKHR {
            s_type: StructureType::IMPORT_MEMORY_FD_INFO_KHR,
            p_next: ::std::ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
            fd: c_int::default(),
        }
    }
}
impl ImportMemoryFdInfoKHR {
    pub fn builder<'a>() -> ImportMemoryFdInfoKHRBuilder<'a> {
        ImportMemoryFdInfoKHRBuilder {
            inner: ImportMemoryFdInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImportMemoryFdInfoKHRBuilder<'a> {
    inner: ImportMemoryFdInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryFdInfoKHRBuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryFdInfoKHR {}
impl<'a> ::std::ops::Deref for ImportMemoryFdInfoKHRBuilder<'a> {
    type Target = ImportMemoryFdInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImportMemoryFdInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImportMemoryFdInfoKHRBuilder<'a> {
    pub fn handle_type(
        mut self,
        handle_type: ExternalMemoryHandleTypeFlags,
    ) -> ImportMemoryFdInfoKHRBuilder<'a> {
        self.inner.handle_type = handle_type;
        self
    }
    pub fn fd(mut self, fd: c_int) -> ImportMemoryFdInfoKHRBuilder<'a> {
        self.inner.fd = fd;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImportMemoryFdInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryFdPropertiesKHR.html>"]
pub struct MemoryFdPropertiesKHR {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub memory_type_bits: u32,
}
impl ::std::default::Default for MemoryFdPropertiesKHR {
    fn default() -> MemoryFdPropertiesKHR {
        MemoryFdPropertiesKHR {
            s_type: StructureType::MEMORY_FD_PROPERTIES_KHR,
            p_next: ::std::ptr::null_mut(),
            memory_type_bits: u32::default(),
        }
    }
}
impl MemoryFdPropertiesKHR {
    pub fn builder<'a>() -> MemoryFdPropertiesKHRBuilder<'a> {
        MemoryFdPropertiesKHRBuilder {
            inner: MemoryFdPropertiesKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryFdPropertiesKHRBuilder<'a> {
    inner: MemoryFdPropertiesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsMemoryFdPropertiesKHR {}
impl<'a> ::std::ops::Deref for MemoryFdPropertiesKHRBuilder<'a> {
    type Target = MemoryFdPropertiesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryFdPropertiesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryFdPropertiesKHRBuilder<'a> {
    pub fn memory_type_bits(mut self, memory_type_bits: u32) -> MemoryFdPropertiesKHRBuilder<'a> {
        self.inner.memory_type_bits = memory_type_bits;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsMemoryFdPropertiesKHR>(
        mut self,
        next: &'a mut T,
    ) -> MemoryFdPropertiesKHRBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryFdPropertiesKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryGetFdInfoKHR.html>"]
pub struct MemoryGetFdInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub memory: DeviceMemory,
    pub handle_type: ExternalMemoryHandleTypeFlags,
}
impl ::std::default::Default for MemoryGetFdInfoKHR {
    fn default() -> MemoryGetFdInfoKHR {
        MemoryGetFdInfoKHR {
            s_type: StructureType::MEMORY_GET_FD_INFO_KHR,
            p_next: ::std::ptr::null(),
            memory: DeviceMemory::default(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}
impl MemoryGetFdInfoKHR {
    pub fn builder<'a>() -> MemoryGetFdInfoKHRBuilder<'a> {
        MemoryGetFdInfoKHRBuilder {
            inner: MemoryGetFdInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryGetFdInfoKHRBuilder<'a> {
    inner: MemoryGetFdInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsMemoryGetFdInfoKHR {}
impl<'a> ::std::ops::Deref for MemoryGetFdInfoKHRBuilder<'a> {
    type Target = MemoryGetFdInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryGetFdInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryGetFdInfoKHRBuilder<'a> {
    pub fn memory(mut self, memory: DeviceMemory) -> MemoryGetFdInfoKHRBuilder<'a> {
        self.inner.memory = memory;
        self
    }
    pub fn handle_type(
        mut self,
        handle_type: ExternalMemoryHandleTypeFlags,
    ) -> MemoryGetFdInfoKHRBuilder<'a> {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsMemoryGetFdInfoKHR>(
        mut self,
        next: &'a mut T,
    ) -> MemoryGetFdInfoKHRBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryGetFdInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkWin32KeyedMutexAcquireReleaseInfoKHR.html>"]
pub struct Win32KeyedMutexAcquireReleaseInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub acquire_count: u32,
    pub p_acquire_syncs: *const DeviceMemory,
    pub p_acquire_keys: *const u64,
    pub p_acquire_timeouts: *const u32,
    pub release_count: u32,
    pub p_release_syncs: *const DeviceMemory,
    pub p_release_keys: *const u64,
}
impl ::std::default::Default for Win32KeyedMutexAcquireReleaseInfoKHR {
    fn default() -> Win32KeyedMutexAcquireReleaseInfoKHR {
        Win32KeyedMutexAcquireReleaseInfoKHR {
            s_type: StructureType::WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR,
            p_next: ::std::ptr::null(),
            acquire_count: u32::default(),
            p_acquire_syncs: ::std::ptr::null(),
            p_acquire_keys: ::std::ptr::null(),
            p_acquire_timeouts: ::std::ptr::null(),
            release_count: u32::default(),
            p_release_syncs: ::std::ptr::null(),
            p_release_keys: ::std::ptr::null(),
        }
    }
}
impl Win32KeyedMutexAcquireReleaseInfoKHR {
    pub fn builder<'a>() -> Win32KeyedMutexAcquireReleaseInfoKHRBuilder<'a> {
        Win32KeyedMutexAcquireReleaseInfoKHRBuilder {
            inner: Win32KeyedMutexAcquireReleaseInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct Win32KeyedMutexAcquireReleaseInfoKHRBuilder<'a> {
    inner: Win32KeyedMutexAcquireReleaseInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSubmitInfo for Win32KeyedMutexAcquireReleaseInfoKHRBuilder<'_> {}
unsafe impl ExtendsSubmitInfo for Win32KeyedMutexAcquireReleaseInfoKHR {}
impl<'a> ::std::ops::Deref for Win32KeyedMutexAcquireReleaseInfoKHRBuilder<'a> {
    type Target = Win32KeyedMutexAcquireReleaseInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for Win32KeyedMutexAcquireReleaseInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> Win32KeyedMutexAcquireReleaseInfoKHRBuilder<'a> {
    pub fn acquire_syncs(
        mut self,
        acquire_syncs: &'a [DeviceMemory],
    ) -> Win32KeyedMutexAcquireReleaseInfoKHRBuilder<'a> {
        self.inner.acquire_count = acquire_syncs.len() as _;
        self.inner.p_acquire_syncs = acquire_syncs.as_ptr();
        self
    }
    pub fn acquire_keys(
        mut self,
        acquire_keys: &'a [u64],
    ) -> Win32KeyedMutexAcquireReleaseInfoKHRBuilder<'a> {
        self.inner.acquire_count = acquire_keys.len() as _;
        self.inner.p_acquire_keys = acquire_keys.as_ptr();
        self
    }
    pub fn acquire_timeouts(
        mut self,
        acquire_timeouts: &'a [u32],
    ) -> Win32KeyedMutexAcquireReleaseInfoKHRBuilder<'a> {
        self.inner.acquire_count = acquire_timeouts.len() as _;
        self.inner.p_acquire_timeouts = acquire_timeouts.as_ptr();
        self
    }
    pub fn release_syncs(
        mut self,
        release_syncs: &'a [DeviceMemory],
    ) -> Win32KeyedMutexAcquireReleaseInfoKHRBuilder<'a> {
        self.inner.release_count = release_syncs.len() as _;
        self.inner.p_release_syncs = release_syncs.as_ptr();
        self
    }
    pub fn release_keys(
        mut self,
        release_keys: &'a [u64],
    ) -> Win32KeyedMutexAcquireReleaseInfoKHRBuilder<'a> {
        self.inner.release_count = release_keys.len() as _;
        self.inner.p_release_keys = release_keys.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> Win32KeyedMutexAcquireReleaseInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceExternalSemaphoreInfo.html>"]
pub struct PhysicalDeviceExternalSemaphoreInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
}
impl ::std::default::Default for PhysicalDeviceExternalSemaphoreInfo {
    fn default() -> PhysicalDeviceExternalSemaphoreInfo {
        PhysicalDeviceExternalSemaphoreInfo {
            s_type: StructureType::PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO,
            p_next: ::std::ptr::null(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
        }
    }
}
impl PhysicalDeviceExternalSemaphoreInfo {
    pub fn builder<'a>() -> PhysicalDeviceExternalSemaphoreInfoBuilder<'a> {
        PhysicalDeviceExternalSemaphoreInfoBuilder {
            inner: PhysicalDeviceExternalSemaphoreInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceExternalSemaphoreInfoBuilder<'a> {
    inner: PhysicalDeviceExternalSemaphoreInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPhysicalDeviceExternalSemaphoreInfo {}
impl<'a> ::std::ops::Deref for PhysicalDeviceExternalSemaphoreInfoBuilder<'a> {
    type Target = PhysicalDeviceExternalSemaphoreInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceExternalSemaphoreInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceExternalSemaphoreInfoBuilder<'a> {
    pub fn handle_type(
        mut self,
        handle_type: ExternalSemaphoreHandleTypeFlags,
    ) -> PhysicalDeviceExternalSemaphoreInfoBuilder<'a> {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceExternalSemaphoreInfo>(
        mut self,
        next: &'a mut T,
    ) -> PhysicalDeviceExternalSemaphoreInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceExternalSemaphoreInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalSemaphoreProperties.html>"]
pub struct ExternalSemaphoreProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub export_from_imported_handle_types: ExternalSemaphoreHandleTypeFlags,
    pub compatible_handle_types: ExternalSemaphoreHandleTypeFlags,
    pub external_semaphore_features: ExternalSemaphoreFeatureFlags,
}
impl ::std::default::Default for ExternalSemaphoreProperties {
    fn default() -> ExternalSemaphoreProperties {
        ExternalSemaphoreProperties {
            s_type: StructureType::EXTERNAL_SEMAPHORE_PROPERTIES,
            p_next: ::std::ptr::null_mut(),
            export_from_imported_handle_types: ExternalSemaphoreHandleTypeFlags::default(),
            compatible_handle_types: ExternalSemaphoreHandleTypeFlags::default(),
            external_semaphore_features: ExternalSemaphoreFeatureFlags::default(),
        }
    }
}
impl ExternalSemaphoreProperties {
    pub fn builder<'a>() -> ExternalSemaphorePropertiesBuilder<'a> {
        ExternalSemaphorePropertiesBuilder {
            inner: ExternalSemaphoreProperties::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExternalSemaphorePropertiesBuilder<'a> {
    inner: ExternalSemaphoreProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsExternalSemaphoreProperties {}
impl<'a> ::std::ops::Deref for ExternalSemaphorePropertiesBuilder<'a> {
    type Target = ExternalSemaphoreProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExternalSemaphorePropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExternalSemaphorePropertiesBuilder<'a> {
    pub fn export_from_imported_handle_types(
        mut self,
        export_from_imported_handle_types: ExternalSemaphoreHandleTypeFlags,
    ) -> ExternalSemaphorePropertiesBuilder<'a> {
        self.inner.export_from_imported_handle_types = export_from_imported_handle_types;
        self
    }
    pub fn compatible_handle_types(
        mut self,
        compatible_handle_types: ExternalSemaphoreHandleTypeFlags,
    ) -> ExternalSemaphorePropertiesBuilder<'a> {
        self.inner.compatible_handle_types = compatible_handle_types;
        self
    }
    pub fn external_semaphore_features(
        mut self,
        external_semaphore_features: ExternalSemaphoreFeatureFlags,
    ) -> ExternalSemaphorePropertiesBuilder<'a> {
        self.inner.external_semaphore_features = external_semaphore_features;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsExternalSemaphoreProperties>(
        mut self,
        next: &'a mut T,
    ) -> ExternalSemaphorePropertiesBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExternalSemaphoreProperties {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExportSemaphoreCreateInfo.html>"]
pub struct ExportSemaphoreCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalSemaphoreHandleTypeFlags,
}
impl ::std::default::Default for ExportSemaphoreCreateInfo {
    fn default() -> ExportSemaphoreCreateInfo {
        ExportSemaphoreCreateInfo {
            s_type: StructureType::EXPORT_SEMAPHORE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            handle_types: ExternalSemaphoreHandleTypeFlags::default(),
        }
    }
}
impl ExportSemaphoreCreateInfo {
    pub fn builder<'a>() -> ExportSemaphoreCreateInfoBuilder<'a> {
        ExportSemaphoreCreateInfoBuilder {
            inner: ExportSemaphoreCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExportSemaphoreCreateInfoBuilder<'a> {
    inner: ExportSemaphoreCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSemaphoreCreateInfo for ExportSemaphoreCreateInfoBuilder<'_> {}
unsafe impl ExtendsSemaphoreCreateInfo for ExportSemaphoreCreateInfo {}
impl<'a> ::std::ops::Deref for ExportSemaphoreCreateInfoBuilder<'a> {
    type Target = ExportSemaphoreCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExportSemaphoreCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExportSemaphoreCreateInfoBuilder<'a> {
    pub fn handle_types(
        mut self,
        handle_types: ExternalSemaphoreHandleTypeFlags,
    ) -> ExportSemaphoreCreateInfoBuilder<'a> {
        self.inner.handle_types = handle_types;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExportSemaphoreCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImportSemaphoreWin32HandleInfoKHR.html>"]
pub struct ImportSemaphoreWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub semaphore: Semaphore,
    pub flags: SemaphoreImportFlags,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
    pub handle: HANDLE,
    pub name: LPCWSTR,
}
impl ::std::default::Default for ImportSemaphoreWin32HandleInfoKHR {
    fn default() -> ImportSemaphoreWin32HandleInfoKHR {
        ImportSemaphoreWin32HandleInfoKHR {
            s_type: StructureType::IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR,
            p_next: ::std::ptr::null(),
            semaphore: Semaphore::default(),
            flags: SemaphoreImportFlags::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
            handle: unsafe { ::std::mem::zeroed() },
            name: unsafe { ::std::mem::zeroed() },
        }
    }
}
impl ImportSemaphoreWin32HandleInfoKHR {
    pub fn builder<'a>() -> ImportSemaphoreWin32HandleInfoKHRBuilder<'a> {
        ImportSemaphoreWin32HandleInfoKHRBuilder {
            inner: ImportSemaphoreWin32HandleInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImportSemaphoreWin32HandleInfoKHRBuilder<'a> {
    inner: ImportSemaphoreWin32HandleInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsImportSemaphoreWin32HandleInfoKHR {}
impl<'a> ::std::ops::Deref for ImportSemaphoreWin32HandleInfoKHRBuilder<'a> {
    type Target = ImportSemaphoreWin32HandleInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImportSemaphoreWin32HandleInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImportSemaphoreWin32HandleInfoKHRBuilder<'a> {
    pub fn semaphore(
        mut self,
        semaphore: Semaphore,
    ) -> ImportSemaphoreWin32HandleInfoKHRBuilder<'a> {
        self.inner.semaphore = semaphore;
        self
    }
    pub fn flags(
        mut self,
        flags: SemaphoreImportFlags,
    ) -> ImportSemaphoreWin32HandleInfoKHRBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn handle_type(
        mut self,
        handle_type: ExternalSemaphoreHandleTypeFlags,
    ) -> ImportSemaphoreWin32HandleInfoKHRBuilder<'a> {
        self.inner.handle_type = handle_type;
        self
    }
    pub fn handle(mut self, handle: HANDLE) -> ImportSemaphoreWin32HandleInfoKHRBuilder<'a> {
        self.inner.handle = handle;
        self
    }
    pub fn name(mut self, name: LPCWSTR) -> ImportSemaphoreWin32HandleInfoKHRBuilder<'a> {
        self.inner.name = name;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsImportSemaphoreWin32HandleInfoKHR>(
        mut self,
        next: &'a mut T,
    ) -> ImportSemaphoreWin32HandleInfoKHRBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImportSemaphoreWin32HandleInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExportSemaphoreWin32HandleInfoKHR.html>"]
pub struct ExportSemaphoreWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_attributes: *const SECURITY_ATTRIBUTES,
    pub dw_access: DWORD,
    pub name: LPCWSTR,
}
impl ::std::default::Default for ExportSemaphoreWin32HandleInfoKHR {
    fn default() -> ExportSemaphoreWin32HandleInfoKHR {
        ExportSemaphoreWin32HandleInfoKHR {
            s_type: StructureType::EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR,
            p_next: ::std::ptr::null(),
            p_attributes: ::std::ptr::null(),
            dw_access: DWORD::default(),
            name: unsafe { ::std::mem::zeroed() },
        }
    }
}
impl ExportSemaphoreWin32HandleInfoKHR {
    pub fn builder<'a>() -> ExportSemaphoreWin32HandleInfoKHRBuilder<'a> {
        ExportSemaphoreWin32HandleInfoKHRBuilder {
            inner: ExportSemaphoreWin32HandleInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExportSemaphoreWin32HandleInfoKHRBuilder<'a> {
    inner: ExportSemaphoreWin32HandleInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSemaphoreCreateInfo for ExportSemaphoreWin32HandleInfoKHRBuilder<'_> {}
unsafe impl ExtendsSemaphoreCreateInfo for ExportSemaphoreWin32HandleInfoKHR {}
impl<'a> ::std::ops::Deref for ExportSemaphoreWin32HandleInfoKHRBuilder<'a> {
    type Target = ExportSemaphoreWin32HandleInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExportSemaphoreWin32HandleInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExportSemaphoreWin32HandleInfoKHRBuilder<'a> {
    pub fn attributes(
        mut self,
        attributes: &'a SECURITY_ATTRIBUTES,
    ) -> ExportSemaphoreWin32HandleInfoKHRBuilder<'a> {
        self.inner.p_attributes = attributes;
        self
    }
    pub fn dw_access(mut self, dw_access: DWORD) -> ExportSemaphoreWin32HandleInfoKHRBuilder<'a> {
        self.inner.dw_access = dw_access;
        self
    }
    pub fn name(mut self, name: LPCWSTR) -> ExportSemaphoreWin32HandleInfoKHRBuilder<'a> {
        self.inner.name = name;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExportSemaphoreWin32HandleInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkD3D12FenceSubmitInfoKHR.html>"]
pub struct D3D12FenceSubmitInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub wait_semaphore_values_count: u32,
    pub p_wait_semaphore_values: *const u64,
    pub signal_semaphore_values_count: u32,
    pub p_signal_semaphore_values: *const u64,
}
impl ::std::default::Default for D3D12FenceSubmitInfoKHR {
    fn default() -> D3D12FenceSubmitInfoKHR {
        D3D12FenceSubmitInfoKHR {
            s_type: StructureType::D3D12_FENCE_SUBMIT_INFO_KHR,
            p_next: ::std::ptr::null(),
            wait_semaphore_values_count: u32::default(),
            p_wait_semaphore_values: ::std::ptr::null(),
            signal_semaphore_values_count: u32::default(),
            p_signal_semaphore_values: ::std::ptr::null(),
        }
    }
}
impl D3D12FenceSubmitInfoKHR {
    pub fn builder<'a>() -> D3D12FenceSubmitInfoKHRBuilder<'a> {
        D3D12FenceSubmitInfoKHRBuilder {
            inner: D3D12FenceSubmitInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct D3D12FenceSubmitInfoKHRBuilder<'a> {
    inner: D3D12FenceSubmitInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSubmitInfo for D3D12FenceSubmitInfoKHRBuilder<'_> {}
unsafe impl ExtendsSubmitInfo for D3D12FenceSubmitInfoKHR {}
impl<'a> ::std::ops::Deref for D3D12FenceSubmitInfoKHRBuilder<'a> {
    type Target = D3D12FenceSubmitInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for D3D12FenceSubmitInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> D3D12FenceSubmitInfoKHRBuilder<'a> {
    pub fn wait_semaphore_values(
        mut self,
        wait_semaphore_values: &'a [u64],
    ) -> D3D12FenceSubmitInfoKHRBuilder<'a> {
        self.inner.wait_semaphore_values_count = wait_semaphore_values.len() as _;
        self.inner.p_wait_semaphore_values = wait_semaphore_values.as_ptr();
        self
    }
    pub fn signal_semaphore_values(
        mut self,
        signal_semaphore_values: &'a [u64],
    ) -> D3D12FenceSubmitInfoKHRBuilder<'a> {
        self.inner.signal_semaphore_values_count = signal_semaphore_values.len() as _;
        self.inner.p_signal_semaphore_values = signal_semaphore_values.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> D3D12FenceSubmitInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreGetWin32HandleInfoKHR.html>"]
pub struct SemaphoreGetWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub semaphore: Semaphore,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
}
impl ::std::default::Default for SemaphoreGetWin32HandleInfoKHR {
    fn default() -> SemaphoreGetWin32HandleInfoKHR {
        SemaphoreGetWin32HandleInfoKHR {
            s_type: StructureType::SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR,
            p_next: ::std::ptr::null(),
            semaphore: Semaphore::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
        }
    }
}
impl SemaphoreGetWin32HandleInfoKHR {
    pub fn builder<'a>() -> SemaphoreGetWin32HandleInfoKHRBuilder<'a> {
        SemaphoreGetWin32HandleInfoKHRBuilder {
            inner: SemaphoreGetWin32HandleInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SemaphoreGetWin32HandleInfoKHRBuilder<'a> {
    inner: SemaphoreGetWin32HandleInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsSemaphoreGetWin32HandleInfoKHR {}
impl<'a> ::std::ops::Deref for SemaphoreGetWin32HandleInfoKHRBuilder<'a> {
    type Target = SemaphoreGetWin32HandleInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SemaphoreGetWin32HandleInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SemaphoreGetWin32HandleInfoKHRBuilder<'a> {
    pub fn semaphore(mut self, semaphore: Semaphore) -> SemaphoreGetWin32HandleInfoKHRBuilder<'a> {
        self.inner.semaphore = semaphore;
        self
    }
    pub fn handle_type(
        mut self,
        handle_type: ExternalSemaphoreHandleTypeFlags,
    ) -> SemaphoreGetWin32HandleInfoKHRBuilder<'a> {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSemaphoreGetWin32HandleInfoKHR>(
        mut self,
        next: &'a mut T,
    ) -> SemaphoreGetWin32HandleInfoKHRBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SemaphoreGetWin32HandleInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkImportSemaphoreFdInfoKHR.html>"]
pub struct ImportSemaphoreFdInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub semaphore: Semaphore,
    pub flags: SemaphoreImportFlags,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
    pub fd: c_int,
}
impl ::std::default::Default for ImportSemaphoreFdInfoKHR {
    fn default() -> ImportSemaphoreFdInfoKHR {
        ImportSemaphoreFdInfoKHR {
            s_type: StructureType::IMPORT_SEMAPHORE_FD_INFO_KHR,
            p_next: ::std::ptr::null(),
            semaphore: Semaphore::default(),
            flags: SemaphoreImportFlags::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
            fd: c_int::default(),
        }
    }
}
impl ImportSemaphoreFdInfoKHR {
    pub fn builder<'a>() -> ImportSemaphoreFdInfoKHRBuilder<'a> {
        ImportSemaphoreFdInfoKHRBuilder {
            inner: ImportSemaphoreFdInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImportSemaphoreFdInfoKHRBuilder<'a> {
    inner: ImportSemaphoreFdInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsImportSemaphoreFdInfoKHR {}
impl<'a> ::std::ops::Deref for ImportSemaphoreFdInfoKHRBuilder<'a> {
    type Target = ImportSemaphoreFdInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImportSemaphoreFdInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImportSemaphoreFdInfoKHRBuilder<'a> {
    pub fn semaphore(mut self, semaphore: Semaphore) -> ImportSemaphoreFdInfoKHRBuilder<'a> {
        self.inner.semaphore = semaphore;
        self
    }
    pub fn flags(mut self, flags: SemaphoreImportFlags) -> ImportSemaphoreFdInfoKHRBuilder<'a> {
        self.inner.flags = flags;
        self
    }
    pub fn handle_type(
        mut self,
        handle_type: ExternalSemaphoreHandleTypeFlags,
    ) -> ImportSemaphoreFdInfoKHRBuilder<'a> {
        self.inner.handle_type = handle_type;
        self
    }
    pub fn fd(mut self, fd: c_int) -> ImportSemaphoreFdInfoKHRBuilder<'a> {
        self.inner.fd = fd;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsImportSemaphoreFdInfoKHR>(
        mut self,
        next: &'a mut T,
    ) -> ImportSemaphoreFdInfoKHRBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImportSemaphoreFdInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkSemaphoreGetFdInfoKHR.html>"]
pub struct SemaphoreGetFdInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub semaphore: Semaphore,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
}
impl ::std::default::Default for SemaphoreGetFdInfoKHR {
    fn default() -> SemaphoreGetFdInfoKHR {
        SemaphoreGetFdInfoKHR {
            s_type: StructureType::SEMAPHORE_GET_FD_INFO_KHR,
            p_next: ::std::ptr::null(),
            semaphore: Semaphore::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
        }
    }
}
impl SemaphoreGetFdInfoKHR {
    pub fn builder<'a>() -> SemaphoreGetFdInfoKHRBuilder<'a> {
        SemaphoreGetFdInfoKHRBuilder {
            inner: SemaphoreGetFdInfoKHR::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SemaphoreGetFdInfoKHRBuilder<'a> {
    inner: SemaphoreGetFdInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsSemaphoreGetFdInfoKHR {}
impl<'a> ::std::ops::Deref for SemaphoreGetFdInfoKHRBuilder<'a> {
    type Target = SemaphoreGetFdInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SemaphoreGetFdInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SemaphoreGetFdInfoKHRBuilder<'a> {
    pub fn semaphore(mut self, semaphore: Semaphore) -> SemaphoreGetFdInfoKHRBuilder<'a> {
        self.inner.semaphore = semaphore;
        self
    }
    pub fn handle_type(
        mut self,
        handle_type: ExternalSemaphoreHandleTypeFlags,
    ) -> SemaphoreGetFdInfoKHRBuilder<'a> {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSemaphoreGetFdInfoKHR>(
        mut self,
        next: &'a mut T,
    ) -> SemaphoreGetFdInfoKHRBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SemaphoreGetFdInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPhysicalDeviceExternalFenceInfo.html>"]
pub struct PhysicalDeviceExternalFenceInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalFenceHandleTypeFlags,
}
impl ::std::default::Default for PhysicalDeviceExternalFenceInfo {
    fn default() -> PhysicalDeviceExternalFenceInfo {
        PhysicalDeviceExternalFenceInfo {
            s_type: StructureType::PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO,
            p_next: ::std::ptr::null(),
            handle_type: ExternalFenceHandleTypeFlags::default(),
        }
    }
}
impl PhysicalDeviceExternalFenceInfo {
    pub fn builder<'a>() -> PhysicalDeviceExternalFenceInfoBuilder<'a> {
        PhysicalDeviceExternalFenceInfoBuilder {
            inner: PhysicalDeviceExternalFenceInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceExternalFenceInfoBuilder<'a> {
    inner: PhysicalDeviceExternalFenceInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPhysicalDeviceExternalFenceInfo {}
impl<'a> ::std::ops::Deref for PhysicalDeviceExternalFenceInfoBuilder<'a> {
    type Target = PhysicalDeviceExternalFenceInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceExternalFenceInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceExternalFenceInfoBuilder<'a> {
    pub fn handle_type(
        mut self,
        handle_type: ExternalFenceHandleTypeFlags,
    ) -> PhysicalDeviceExternalFenceInfoBuilder<'a> {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceExternalFenceInfo>(
        mut self,
        next: &'a mut T,
    ) -> PhysicalDeviceExternalFenceInfoBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceExternalFenceInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExternalFenceProperties.html>"]
pub struct ExternalFenceProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub export_from_imported_handle_types: ExternalFenceHandleTypeFlags,
    pub compatible_handle_types: ExternalFenceHandleTypeFlags,
    pub external_fence_features: ExternalFenceFeatureFlags,
}
impl ::std::default::Default for ExternalFenceProperties {
    fn default() -> ExternalFenceProperties {
        ExternalFenceProperties {
            s_type: StructureType::EXTERNAL_FENCE_PROPERTIES,
            p_next: ::std::ptr::null_mut(),
            export_from_imported_handle_types: ExternalFenceHandleTypeFlags::default(),
            compatible_handle_types: ExternalFenceHandleTypeFlags::default(),
            external_fence_features: ExternalFenceFeatureFlags::default(),
        }
    }
}
impl ExternalFenceProperties {
    pub fn builder<'a>() -> ExternalFencePropertiesBuilder<'a> {
        ExternalFencePropertiesBuilder {
            inner: ExternalFenceProperties::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExternalFencePropertiesBuilder<'a> {
    inner: ExternalFenceProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsExternalFenceProperties {}
impl<'a> ::std::ops::Deref for ExternalFencePropertiesBuilder<'a> {
    type Target = ExternalFenceProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExternalFencePropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExternalFencePropertiesBuilder<'a> {
    pub fn export_from_imported_handle_types(
        mut self,
        export_from_imported_handle_types: ExternalFenceHandleTypeFlags,
    ) -> ExternalFencePropertiesBuilder<'a> {
        self.inner.export_from_imported_handle_types = export_from_imported_handle_types;
        self
    }
    pub fn compatible_handle_types(
        mut self,
        compatible_handle_types: ExternalFenceHandleTypeFlags,
    ) -> ExternalFencePropertiesBuilder<'a> {
        self.inner.compatible_handle_types = compatible_handle_types;
        self
    }
    pub fn external_fence_features(
        mut self,
        external_fence_features: ExternalFenceFeatureFlags,
    ) -> ExternalFencePropertiesBuilder<'a> {
        self.inner.external_fence_features = external_fence_features;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsExternalFenceProperties>(
        mut self,
        next: &'a mut T,
    ) -> ExternalFencePropertiesBuilder<'a> {
        unsafe {
            let next_ptr = next as *mut T as *mut BaseOutStructure;
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr as _;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExternalFenceProperties {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkExportFenceCreateInfo.html>"]
pub struct ExportFenceCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalFenceHandleTypeFlags,
}
impl ::std::default::Default for ExportFenceCreateInfo {
    fn default() -> ExportFenceCreateInfo {
        ExportFenceCreateInfo {
            s_type: StructureType::EXPORT_FENCE_CREATE_INFO,
            p_next: ::std::ptr::null(),
            handle_types: ExternalFenceHandleTypeFlags::default(),
        }
    }
}
impl ExportFenceCreateInfo {
    pub fn builder<'a>() -> ExportFenceCreateInfoBuilder<'a> {
        ExportFenceCreateInfoBuilder {
            inner: ExportFenceCreateInfo::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExportFenceCreateInfoBuilder<'a> {
    inner: ExportFenceCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsFenceCreateInfo for ExportFenceCreateInfoBuilder<'_> {}
unsafe impl ExtendsFenceCreateInfo for ExportFenceCreateInfo {}
impl<'a> ::std::ops::Deref for ExportFenceCreateInfoBuilder<'a> {
    type Target = ExportFenceCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExportFenceCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExportFenceCreateInfoBuilder<'a> {
    pub fn handle_types(
        mut self,
        handle_types: ExternalFenceHandleTypeFlags,
    ) -> ExportFenceCreateInfoBuilder<'a> {
        self.inner.handle_types = handle_types;
        self
    }
    #[doc = r" Calling build will **disca