.if t .ds TX "T\h'-.15m'\v'.2v'E\v'-.2v'\h'-.12m'X
.if t .ds LX L\v'-.22m'a\v'.22m'T\h'-.1667m'\v'.22m'E\h'-.125m'\v'-.22m'X
.TH MAKEINDEX L
.SH NAME
makeindex \- a general purpose, formatter-independent index processor
.SH SYNOPSIS
\fBmakeindex\fR [\fB\-ilqrc\fR] [\fB-s\fI sty\fR] [\fB-o\fI ind\fR]
[\fB-t\fI log\fR] [\fB-p\fI no\fR] [\fI idx0 idx1 idx2 ...\fR]
.SH DESCRIPTION
.PP
\fImakeindex\fR is a general purpose index processor.  It takes one or more
raw index files (normally generated by a formatter), sorts the entries,
and produces the actual index file.  It is not dependent on any particular
format of raw index file, although the \fI.idx\fR file generated
by \*(LX is default.  Up to three levels (0, 1, and 2) of subitem nesting
within the same entry is supported.
The input format may be redefined in a style file
so that raw index or glossary output from other formatters may be processed.
The style file also defines the style of output index file.
Unless specified otherwise, the file name base of the first input file
(\fIidx0\fR) is used to determine other related input/output files.
For each input file name specified, the name itself is first used.  If not
found and the name has no extension part, it is concatenated
with the \fI.idx\fR extension.  If this again fails, the program aborts.
.SH OPTIONS
.PP
.TP 10
\fB\-i\fR	
Use \fIstdin\fR as the input file.  When this option is specified and the
\fB\-o\fR is not, output is written to \fIstdout\fR.
.TP 10
\fB\-l\fR
Use letter ordering.  Default is word ordering (explained in the \fBORDERING\fR
section).
.TP 10
\fB\-q\fR
Quiet mode, send no messages to \fIstderr\fR.  By default progress and
error messages are sent to \fIstderr\fR as well as the transcript file.
The \fB\-q\fR option disables the \fIstderr\fR messages.
.TP 10
\fB\-r\fR
Disable implicit page range formation.  By default three or more successive
pages will be automatically abbreviated as a range (e.g. 1--5).  The \fB\-r\fR
option disables it, making the explicit range operators the only way to create
page ranges (see the \fBSPECIAL EFFECTS\fR section below).
.TP 10
\fB\-c\fR
Enable blank compression.  By default every blank counts in the
index key.  The \fB\-c\fR option ignores leading and trailing blanks and tabs
and compresses intermediate ones to a single space.
.TP 10
\fB\-s\fI sty\fR
Take \fIsty\fR as the style file.  There is no default for the style file
name.  The environment variable INDEXSTYLE defines the path where
the style file should be found.
.TP 10
\fB\-o\fI ind\fR
Take \fIind\fR as the output index file.  By default the file name base of
the first input file \fIidx0\fR concatenated with the extension \fI.ind\fR
is used as the output file name.
.TP 10
\fB\-t\fI log\fR
Take \fIlog\fR as the transcript file.  By default the file name base of
the first input file \fIidx0\fR concatenated with the extension \fI.ilg\fR
is used as the transcript file name.
.TP 10
\fB\-p\fI no\fR
Set the starting page number of the output index file to be \fIno\fR.
This is useful when the index file is to be formatted separately.
Other than pure numbers, three special cases are allowed for \fIno\fR:
\fIany\fR, \fIodd\fR, and \fIeven\fR.  In these special cases, the starting
page number is determined by retrieving the last page number
from the source log file.  The source log file name is determined by
concatenating the file name base of the first raw index file (\fIidx0\fR)
with the extension \fI.log\fR.  The last source page is obtained by
searching backward in the log file for the first instance of a number included
in \fB[\fR...\fB]\fR.  If a page number is missing or the log file is not
found, no attempt will be made to set the starting page number.
The meaning of each of these cases follows.
.RS
.TP 10
\fIany\fR
The starting page is the last source page number plus 1.
.TP 10
\fIodd\fR
The starting page is the first odd page following the last source page number.
.TP 10
\fIeven\fR
The starting page is the first even page following the last source page number.
.RE
.SH "STYLE FILE"
The style file format is very simple.  It is a list of <\fIspecifier\fR,
\fIattribute\fR> pairs.
There are two types of specifiers (input and output).
The pairs don't have to obey any particular order in the file.  
A line lead by `%' is a comment.  The following is a list of
all the specifiers and their respective arguments where <string> is an
arbitrary string delimited by double quotes ("..."),
<char> is a single letter embraced by
single quotes ('...'), and <number> is a nonnegative integer.
The maximum length of a <string> is 144.  Notice that a backslash
must be escaped (by an extra backslash) in the string quotation.
Anything not specified in the style file
will be assigned a default value, which is shown at the rightmost
column.
This file can reside anywhere in the path defined by the environment
variable INDEXSTYLE.
.PP 
\fB% Input Style Specifiers\fR
.TP 30
\fBkeyword\fR  <string>
"\\\\indexentry"
.RS
This is the command which tells \fImakeindex\fR that its argument is
an index entry. 
.RE
.TP 30
\fBarg_open\fR  <char>
\'{\'
.RS
This is the opening delimiter for the index entry argument.
.RE
.TP 30
\fBarg_close\fR  <char>
\'}\'
.RS
This is the closing delimiter for the index entry argument.
.RE
.TP 30
\fBrange_open\fR  <char>
\'(\'
.RS
The opening delimiter indicating the beginning of an explicit page range.
.RE
.TP 30
\fBrange_close\fR  <char>
\')\'
.RS
The closing delimiter indicating the end of an explicit page range.
.RE
.TP 30
\fBlevel\fR  <char>
\'!\'
.RS
The delimiter which denotes a new level of subitem.
.RE
.TP 30
\fBactual\fR  <char>
\'@\'
.RS
The symbol which indicates that the next entry is to appear in the actual
index file.
.RE
.TP 30
\fBencap\fR  <char>
\'|\'
.RS
The symbol which indicates that the rest of the argument list
is to be used as the encapsulating command for the page number.
.RE
.TP 30
\fBquote\fR  <char>
\'"\'
.TP 30
\fBescape\fR  <char>
\'\\\\\'
.RS
The symbol which escapes the next letter, unless its preceding letter
is \fBescape\fR.  In other words, \fBquote\fR is used to escape the letter
whcih immediately follows it.
But if it is preceded by \fBescape\fR, it does not escape anything.
Notice that the two symbols must be distinct.
.RE
.sp 1
.PP
\fB% Output Style Specifiers\fR
.TP 30
\fBpreamble\fR  <string>
"\\\\begin{theindex}\\n"
.RS
The preamble of actual index file.
.RE
.TP 30
\fBpostamble\fR  <string>
"\\n\\n\\\\end{theindex}\\n"
.RS
The postamble of actual index file.
.RE
.TP 30
\fBsetpage_prefix\fR  <string>
"\\n  \\\\setcounter{page}{"
.RS
The prefix of the command which sets the starting page number.
.RE
.TP 30
\fBsetpage_suffix\fR  <string>
"}\\n"
.RS
The suffix of the command which sets the starting page number.
.RE
.TP 30
\fBgroup_skip\fR  <string>
"\\n\\n  \\\\indexsapce\\n"
.RS
The vertical space to be inserted before a new group begins.
.RE
.TP 30
\fBlethead_prefix\fR  <string>
""
.RS
The header prefix to be inserted before a new letter begins.
.RE
.TP 30
\fBlethead_suffix\fR  <string>
""
.RS
The header suffix to be inserted before a new letter begins.
.RE
.TP 30
\fBlethead_flag\fR  <string>
0
.RS
The flag indicating the condition of inserting new letter header.
Default is 0, which means no header.  Positive means insert an uppercase
letter between prefix and suffix.  Negative means insert an lowercase letter.
.RE
.TP 30
\fBitem_0\fR  <string>
"\\n  \\\\item "
.RS
The command to be inserted between two primary (level 0) items.
.RE
.TP 30
\fBitem_1\fR  <string>
"\\n     \\\\subitem "
.RS
The command to be inserted between two secondary (level 1) items.
.RE
.TP 30
\fBitem_2\fR  <string>
"\\n       \\\\subsubitem "
.RS
The command to be inserted between two level 2 items.
.RE
.TP 30
\fBitem_01\fR  <string>
"\\n    \\\\subitem "
.RS
The command to be inserted between a level 0 item and a level 1 item.
.RE
.TP 30
\fBitem_x1\fR  <string>
"\\n    \\\\subitem "
.RS
The command to be inserted between a level 0 item and a level 1 item.
The difference between this and previous is that in this case the level 0
item doesn't have any page numbers.
.RE
.TP 30
\fBitem_12\fR  <string>
"\\n    \\\\subsubitem "
.RS
The command to be inserted between a level 1 item and a level 2 item.
.RE
.TP 30
\fBitem_x2\fR  <string>
"\\n    \\\\subsubitem "
.RS
The command to be inserted between a level 1 item and a level 2 item.
The difference between this and previous is that in this case the level 1 item
doesn't have any page number.
.RE
.TP 30
\fBdelim_0\fR  <string>
", "
.RS
The delimiter to be inserted between a level 0 key and its first page number.
Default is a comma followed by a blank.
.RE
.TP 30
\fBdelim_1\fR  <string>
", "
.RS
The delimiter to be inserted between a level 1 key and its first page number.
Default is a comma followed by a blank.
.RE
.TP 30
\fBdelim_2\fR  <string>
", "
.RS
The delimiter to be inserted between a level 2 key and its first page number.
Default is a comma followed by a blank.
.RE
.TP 30
\fBdelim_n\fR  <string>
", "
.RS
The delimiter to be inserted between two page numbers for the same key
in any level.  Default is a comma followed by a blank.
.RE
.TP 30
\fBdelim_r\fR  <string>
"--"
.RS
The delimiter to be inserted between the starting and ending page numbers
of a range.
.RE
.TP 30
\fBencap_prefix\fR  <string>
"\\\\"
.RS
The prefix for the command which encapsulates the page number.
.RE
.TP 30
\fBencap_infix\fR  <string>
"{"
.RS
The prefix for the command which encapsulates the page number.
.RE
.TP 30
\fBencap_suffix\fR  <string>
"}".
.RS
The prefix for the command which encapsulates the page number.
.RE
.TP 30
\fBline_max\fR  <number>
72
.RS
The maximum length of a line in the output beyond which a line wraps around.
.RE
.TP 30
\fBindent_space\fR  <string>
"\\t\\t"
.RS
The space to be inserted in front of a wrapped line.  Default is two tabs.
.RE
.TP 30
\fBindent_length\fR  <number>
16
.RS
The length of \fBindent_space\fR.  In the default case this is 16 (for 2 tabs).
.RE
.SH "EXAMPLE"
.PP
The following example shows a style file called \fIbook.isty\fR which
defines a stand-alone index for a book.  By stand-alone, we mean it can
be formatted independent of the main source.
.RS
.RS
\fBpreamble\fR
.br
"\\\\documentstyle[12pt]{book}
.br
\\\\begin{document}
.br
\\\\begin{theindex}
.br
{\\\\small\\n"
.sp 1
\fBpostamble\fR
.br
"\\n\\n}
.br
\\\\end{theindex}
.br
\\\\end{document}\\n"
.RE
.RE
.LP
Suppose a particular book style requires the index (as well as any
chapters) to start from an odd page number.
Given \fIfoo.idx\fR as the raw index file,
the following command line produces an index in file \fIfoo-.ind\fR.
.PP
.RS
\fImakeindex  \-s book.isty  \-o foo-.ind  \-p odd  foo\fR
.RE
.LP
The reason to use a non-default output file name is to avoid clobbering the
source output (presumably \fIfoo.dvi\fR) because if the index is in file
\fIfoo.ind\fR, its output will also be in \fIfoo.dvi\fR as a result of
separate formatting using \*(LX.  In the example the index is in
\fIfoo-.ind\fR, its output will be in \fIfoo-.dvi\fR and thus introduces
no confusion.
.SH "ORDERING"
.PP
By default \fImakeindex\fR assumes \fIword ordering\fR.  The \fB\-l\fR option
turns it into \fIletter ordering\fR.  The only difference is whether a blank
is treated as an effective letter or not.  In word ordering, a blank precedes
any letter in the alphabet, whereas in letter ordering, it doesn't count
at all.  This is best illustrated by the following example:
.PP
.RS
\fIword order			letter order\fR
.br
sea lion				seal
.br
seal				sea lion
.RE
.LP
Numbers are sorted in numeric order.  For instance,
.RS
9 (nine),  123
.br
10 (ten), see Derek, Bo
.RE
.PP
Letters are first sorted with uppercase and lowercase considered identical;
then, within identical words the uppercase letter precedes its lowercase
counterpart.
.PP
Patterns lead by a special symbol precede numbers, which precede
patterns lead by a letter.  The symbol here refers to anything not in
the union of digits and English alphabet.  This includes those which follow
\'z\' in the ASCII chart.  As a special case,
anything started with a digit but mixed with
non-digits is considered a symbol-leading pattern instead of a number.
.SH "SPECIAL EFFECTS"
In the normal case entries such as
.RS
\\indexentry{alpha}{1}
.br
\\indexentry{alpha!beta}{3}
.br
\\indexentry{alpha!beta!gamma}{10}
.RE
in the raw index file will be converted to
.RS
\\item alpha, 1
.br
  \\subitem beta, 3
.br
    \\subsubitem gamma, 10
.RE
in the output index file by \fImakeindex\fR.
Notice that the \fBlevel\fR symbol (`!') is used to delimit levels of nesting.
.PP
It is possible to make an item appear in a designated form by
using the \fBactual\fR (`@') operator.  For instance,
.RS
\\indexentry{alpha@{\\it alpha\\/}}{1}
.RE
will become
.RS
\\item {\\it alpha\\/}  1
.RE
after the conversion.  The idea is that the pattern preceding `@' is
used as sort key, whereas the one following it is put in the actual
result.  However, the same key with and without the \fBactual\fR part
are regarded as distinct entries.
.PP
It is also possible to encapsulate a page number with a designated
command using the \fBencap\fR (`|') operator.  For example, in the 
default case, 
.RS
\\indexentry{alpha|bold}{1}
.RE
will be converted to 
.RS
\\item alpha \\bold{1}
.RE
where \\bold{n} will expand to {\\bf n}.  This allows
the \fBencap\fR operator to be used to set pages
in different fonts, thereby conveying more information about whatever
being indexed.  For instance, given the same key the page where its definition
appears can be in one font while where its primary example
is given can be in another, with other ordinary appearances in a third.
Notice that in this example, the three output
attributes associated with page encapsulation \fBencap_prefix\fR,
\fBencap_infix\fR, and \fBencap_suffix\fR correspond respectively
to backslash, left brace, and right brace.  If this is to be formatted
by languages other than \*(LX, they would be defined differently.
.PP
By the same token, the \fBencap\fR operator can be used to 
make cross references in the index.  For instance,  
.RS
\\indexentry{alpha|see{beta}}{1}
.RE
will become
.RS
\\item alpha \\see{beta}{1}
.RE
in the output index file after the conversion, where 
.RS
\\see{beta}{1}
.RE
will expand to
.RS
{\\it see\\/} beta
.RE
Notice that in a cross reference like this the page number disappears.
Therefore, where to insert such a command in the source is immaterial.
.PP
A pair of \fBencap\fR concatenated with \fBrange_open\fR (`|(') and
with \fBrange_close\fR (`|)') creates an explicit page range.  That is,
.RS
\\indexentry{alpha|(}{1}
.br
\\indexentry{alpha|)}{5}
.RE
will become
.RS
\\item alpha, 1--5
.RE
Intermediate pages indexed by the same key will be merged into the range
implicitly.  This is especially useful when an entire section about
a particular subject is to be indexed, in which case only the range opening and
closing operators need to be inserted at the beginning and end of the
section, respectively.
.PP
This explicit page range formation can also include an extra command
to set the page range in a designated font.  Thus
.RS
\\indexentry{alpha|(bold}{1}
.br
\\indexentry{alpha|)}{5}
.RE
will become
.RS
\\item alpha, \\bold{1--5}
.RE
A couple of special cases are worth mentioning here.  First, entries like
.RS
\\indexentry{alpha|(}{1}
.br
\\indexentry{alpha|bold}{3}
.br
\\indexentry{alpha|)}{5}
.RE
will be interpreted as
.RS
\\item alpha, \\bold{3}, 1--5
.RE
but with a warning message in the
transcript about the encounter of an inconsistent page encapsulator.
Secondly, an explicit range beginning in a Roman page number and ending
in Ababic is considered an error.  In a case like this the range is broken
into two subranges, if possible, one in Roman, the other in Arabic.
For instnace,
.RS
\\indexentry{alpha|(}{i}
.br
\\indexentry{alpha}{iv}
.br
\\indexentry{alpha}{3}
.br
\\indexentry{alpha|)}{7}
.RE
will be turned into
.RS
\\item alpha, 1--iv, 3--7
.RE
with a warning message in the transcript complaining about the illegal
range formation.
.PP
Finally, every special symbol mentioned in this section may be
escaped by the \fBquote\fR operator (`"').  Thus
.RS
\\indexentry{alpha"@beta}{1}
.RE
will actually become
.RS
\\item alpha@beta,  1
.RE
as a result of executing \fImakeindex\fR.  However, if \fBquote\fR is
preceded by \fBescape\fR (`\\'), its following letter is not escaped.
That is,
.RS
\\indexentry{f\\"ur}{1}
.RE
means 
.RS
\\item f\\"ur, 1
.RE
which represents umlaut accented `u' to the \*(TX family of processors.
.SH "SEE ALSO"
.IR tex(l), latex(l), qsort(3)
.SH AUTHOR
.PP
Pehong Chen 
.br
Computer Science Division
.br
University of California, Berkeley
.br
phc@berkeley.edu
.SH THANKS
Leslie Lamport contributed significantly to the design.
Michael Harrison provided valuable comments and suggestions.
