/*################################################################################
# Linux Management Providers (LMP), DHCP provider package
# Copyright (C) 2009 Khahramon NURIDDINOV, qahramon0786@gmail.com,TUIT
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################*/

#include "OpenDRIM_DHCPProtocolEndpointAccess.h"

string systemName;
string Name;
const string systemCreationClassName = "OpenDRIM_ComputerSystem";
const string creationClassName = "OpenDRIM_DHCPProtocolEndpoint";

int DHCP_OpenDRIM_DHCPProtocolEndpoint_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(systemName, errorMessage));
	Name="dhclient";
	_L_;
	return OK;
}

int DHCP_OpenDRIM_DHCPProtocolEndpoint_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int DHCP_OpenDRIM_DHCPProtocolEndpoint_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_DHCPProtocolEndpoint>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_DHCPProtocolEndpoint instance;
	
	if(!CF_isExist("/sbin/dhclient"))
		return OK;
	
	instance.setName(Name);
	instance.setSystemCreationClassName(systemCreationClassName);
	instance.setSystemName(systemName);
	instance.setCreationClassName(creationClassName);
	
	if (discriminant == "ei")
		CF_assert(DHCP_OpenDRIM_DHCPProtocolEndpoint_populate(instance, errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int DHCP_OpenDRIM_DHCPProtocolEndpoint_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_DHCPProtocolEndpoint& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.SystemCreationClassName != systemCreationClassName ||
		instance.SystemName != systemName ||
		instance.CreationClassName != creationClassName ||
		instance.Name != Name)
	{
		errorMessage = "Invalid path";
		return NOT_FOUND;
	}
	CF_assert(DHCP_OpenDRIM_DHCPProtocolEndpoint_populate(instance, errorMessage));
	_L_;
	return OK;
}

int DHCP_OpenDRIM_DHCPProtocolEndpoint_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPProtocolEndpoint& newInstance, const OpenDRIM_DHCPProtocolEndpoint& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DHCP_OpenDRIM_DHCPProtocolEndpoint_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPProtocolEndpoint& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DHCP_OpenDRIM_DHCPProtocolEndpoint_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPProtocolEndpoint& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DHCP_OpenDRIM_DHCPProtocolEndpoint_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPProtocolEndpoint& instance, unsigned int& returnValue, const OpenDRIM_DHCPProtocolEndpoint_RequestStateChange_In& in, OpenDRIM_DHCPProtocolEndpoint_RequestStateChange_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DHCP_OpenDRIM_DHCPProtocolEndpoint_populate(OpenDRIM_DHCPProtocolEndpoint& instance, string& errorMessage) {
	_E_;
	/* Properties to fill from profile
	 * Mandatory:
	 * [X] SystemCreationClassName  [KEY]
	 * [X] CreationClassName        [KEY]
	 * [X] SystemName               [KEY]
	 * [X] Name                     [KEY]
	 * [X] NameFormat
	 * [X] ProtocolIFType
	 * [X] OtherTypeDescription
	 * [X] RequestedState => left to default value
	 * [X] EnabledState   => left to default value
	 * [X] ClientState
	 * [X] ElementName
	 */
	
	string elementName;
	string dhcpVersion;
	
	instance.setNameFormat("DHCP-client-name");
	instance.setProtocolIFType(1); // Other (required by the profile)
	instance.setOtherTypeDescription("DHCP");
	instance.setRequestedState(12);
	instance.setEnabledState(5);
	instance.setClientState(0);
	
	CF_getWhatisFL("dhclient",elementName,errorMessage);
	CF_runCommandFL("dhclient --version 2>&1",dhcpVersion,errorMessage);
	
	if(elementName.empty())
		elementName="DHCP client";
	
	if(!dhcpVersion.empty())
		elementName+=" ("+dhcpVersion+")";
	
	instance.setElementName(elementName);
	
	string filepath;
	string modifiedTime;
	int errorCode=get_dhcp_lease_path(filepath,errorMessage);
		if(errorCode!=OK)
		return ERROR;
	
	CF_assert(CF_lastModified(filepath, modifiedTime, errorMessage));
	instance.setTimeOfLastStateChange(modifiedTime);
	_L_;
	return OK;
}

