/*################################################################################
# Linux Management Providers (LMP), DHCP provider package
# Copyright (C) 2009 Khahramon NURIDDINOV, qahramon0786@gmail.com,TUIT
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################*/

#ifndef OPENDRIM_DHCPELEMENTCAPABILITIESACCESS_H_
#define OPENDRIM_DHCPELEMENTCAPABILITIESACCESS_H_

#include "DHCP_Common.h"

#include "OpenDRIM_DHCPElementCapabilities.h"
#include "assocOpenDRIM_DHCPElementCapabilities.h"

int DHCP_OpenDRIM_DHCPElementCapabilities_load(const CMPIBroker* broker, string& errorMessage);

int DHCP_OpenDRIM_DHCPElementCapabilities_unload(string& errorMessage);

int DHCP_OpenDRIM_DHCPElementCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_DHCPElementCapabilities>& instances, const char** properties, string& errorMessage, const string& discriminant);

int DHCP_OpenDRIM_DHCPElementCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_DHCPElementCapabilities& instance, const char** properties, string& errorMessage);

int DHCP_OpenDRIM_DHCPElementCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPElementCapabilities& newInstance, const OpenDRIM_DHCPElementCapabilities& oldInstance, const char** properties, string& errorMessage);

int DHCP_OpenDRIM_DHCPElementCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPElementCapabilities& instance, string& errorMessage);

int DHCP_OpenDRIM_DHCPElementCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPElementCapabilities& instance, string& errorMessage);

int DHCP_OpenDRIM_DHCPElementCapabilities_associatorCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int DHCP_OpenDRIM_DHCPElementCapabilities_associatorManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& Capabilities_associatedInstances, string& errorMessage, const string& discriminant);

int DHCP_OpenDRIM_DHCPElementCapabilities_referenceCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_DHCPElementCapabilities>& OpenDRIM_DHCPElementCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int DHCP_OpenDRIM_DHCPElementCapabilities_referenceManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& Capabilities_instances, vector<OpenDRIM_DHCPElementCapabilities>& OpenDRIM_DHCPElementCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int DHCP_OpenDRIM_DHCPElementCapabilities_populate(OpenDRIM_DHCPElementCapabilities& instance, string& errorMessage);

#endif /*OPENDRIM_DHCPELEMENTCAPABILITIESACCESS_H_*/
