import libtmux
import time

DONE_MARKER = f'{"*" * 10}DONE{"*" * 10}'
DONE_MARKER_EXPRESSION = "perl -e 'print ((\"*\" x 10) . \"DONE\" . (\"*\" x 10))'"

def search_for_pattern(pane: libtmux.Pane, pattern: str, timeout: int = 600) -> bool:
    for _ in range(timeout):
        time.sleep(1)
        lines = pane.capture_pane()
        assert not isinstance(lines, str)
        if pattern in '\n'.join(lines):
            return True
    dump_screen(pane)
    return False

def dump_screen(pane: libtmux.Pane):
    lines = pane.capture_pane()
    assert not isinstance(lines, str)
    print()
    print("TMUX SCREEN:")
    print("\n".join(lines))
    print()
