/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.regex.Pattern;
import org.odftoolkit.odfdom.type.OdfDataType;
import org.odftoolkit.odfdom.type.W3CSchemaType;

public class CountryCode
implements OdfDataType {
    private String mCountryCode;
    private static final Pattern countryCodePattern = Pattern.compile("^[A-Za-z0-9]{1,8}$");

    public CountryCode(String countryCode) throws IllegalArgumentException {
        if (!CountryCode.isValid(countryCode)) {
            throw new IllegalArgumentException("parameter is invalid for datatype CountryCode");
        }
        if (!W3CSchemaType.isValid("token", countryCode)) {
            throw new IllegalArgumentException("parameter is invalid for datatype CountryCode");
        }
        this.mCountryCode = countryCode;
    }

    public String toString() {
        return this.mCountryCode;
    }

    public static CountryCode valueOf(String stringValue) throws IllegalArgumentException {
        return new CountryCode(stringValue);
    }

    public static boolean isValid(String stringValue) {
        if (stringValue == null || !countryCodePattern.matcher(stringValue).matches()) {
            return false;
        }
        return W3CSchemaType.isValid("token", stringValue);
    }
}

