// Copyright 2017 The LUCI Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.12.1
// source: go.chromium.org/luci/common/proto/gitiles/gitiles.proto

package gitiles

import prpc "go.chromium.org/luci/grpc/prpc"

import (
	context "context"
	proto "github.com/golang/protobuf/proto"
	git "go.chromium.org/luci/common/proto/git"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// List copied from
// https://github.com/google/gitiles/blob/65edbe49f2b3882a5979f602383ef0c7b2b8ee0c/java/com/google/gitiles/ArchiveFormat.java
type ArchiveRequest_Format int32

const (
	ArchiveRequest_Invalid ArchiveRequest_Format = 0
	ArchiveRequest_GZIP    ArchiveRequest_Format = 1
	ArchiveRequest_TAR     ArchiveRequest_Format = 2
	ArchiveRequest_BZIP2   ArchiveRequest_Format = 3
	ArchiveRequest_XZ      ArchiveRequest_Format = 4
)

// Enum value maps for ArchiveRequest_Format.
var (
	ArchiveRequest_Format_name = map[int32]string{
		0: "Invalid",
		1: "GZIP",
		2: "TAR",
		3: "BZIP2",
		4: "XZ",
	}
	ArchiveRequest_Format_value = map[string]int32{
		"Invalid": 0,
		"GZIP":    1,
		"TAR":     2,
		"BZIP2":   3,
		"XZ":      4,
	}
)

func (x ArchiveRequest_Format) Enum() *ArchiveRequest_Format {
	p := new(ArchiveRequest_Format)
	*p = x
	return p
}

func (x ArchiveRequest_Format) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ArchiveRequest_Format) Descriptor() protoreflect.EnumDescriptor {
	return file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_enumTypes[0].Descriptor()
}

func (ArchiveRequest_Format) Type() protoreflect.EnumType {
	return &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_enumTypes[0]
}

func (x ArchiveRequest_Format) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ArchiveRequest_Format.Descriptor instead.
func (ArchiveRequest_Format) EnumDescriptor() ([]byte, []int) {
	return file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescGZIP(), []int{4, 0}
}

type DownloadFileRequest_Format int32

const (
	DownloadFileRequest_FormatInvalid DownloadFileRequest_Format = 0
	DownloadFileRequest_TEXT          DownloadFileRequest_Format = 1
)

// Enum value maps for DownloadFileRequest_Format.
var (
	DownloadFileRequest_Format_name = map[int32]string{
		0: "FormatInvalid",
		1: "TEXT",
	}
	DownloadFileRequest_Format_value = map[string]int32{
		"FormatInvalid": 0,
		"TEXT":          1,
	}
)

func (x DownloadFileRequest_Format) Enum() *DownloadFileRequest_Format {
	p := new(DownloadFileRequest_Format)
	*p = x
	return p
}

func (x DownloadFileRequest_Format) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DownloadFileRequest_Format) Descriptor() protoreflect.EnumDescriptor {
	return file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_enumTypes[1].Descriptor()
}

func (DownloadFileRequest_Format) Type() protoreflect.EnumType {
	return &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_enumTypes[1]
}

func (x DownloadFileRequest_Format) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DownloadFileRequest_Format.Descriptor instead.
func (DownloadFileRequest_Format) EnumDescriptor() ([]byte, []int) {
	return file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescGZIP(), []int{6, 0}
}

// LogRequest is request message for Gitiles.Log rpc.
type LogRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Gitiles project, e.g. "chromium/src" part in
	// https://chromium.googlesource.com/chromium/src/+/master
	// Required.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// The commit where to start the listing from.
	// The value can be:
	//   - a git revision as 40-char string or its prefix so long as its unique in repo.
	//   - a ref such as "refs/heads/branch"
	//   - a ref defined as n-th parent of R in the form "R~n".
	//     For example, "master~2" or "deadbeef~1".
	// Required.
	Committish string `protobuf:"bytes,3,opt,name=committish,proto3" json:"committish,omitempty"`
	// If specified, only commits not reachable from this commit (inclusive)
	// will be returned.
	//
	// In git's notation, this is
	//   $ git log ^exclude_ancestors_of committish
	//  OR
	//   $ git log exclude_ancestors_of..committish
	// https://git-scm.com/docs/gitrevisions#gitrevisions-Theememtwo-dotRangeNotation
	//
	// For example, given this repo
	//
	//     base -> A -> B -> C == refs/heads/master
	//        \
	//         X -> Y -> Z  == refs/heads/release
	//
	// calling Log(committish='refs/heads/release',
	//             exclude_ancestors_of='refs/heads/master')
	// will return ['Z', Y', 'X'].
	ExcludeAncestorsOf string `protobuf:"bytes,2,opt,name=exclude_ancestors_of,json=excludeAncestorsOf,proto3" json:"exclude_ancestors_of,omitempty"`
	// If true, include tree diff in commits.
	TreeDiff bool `protobuf:"varint,4,opt,name=tree_diff,json=treeDiff,proto3" json:"tree_diff,omitempty"`
	// Value of next_page_token in LogResponse to continue.
	PageToken string `protobuf:"bytes,10,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// If > 0, number of commits to retrieve.
	PageSize int32 `protobuf:"varint,11,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *LogRequest) Reset() {
	*x = LogRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogRequest) ProtoMessage() {}

func (x *LogRequest) ProtoReflect() protoreflect.Message {
	mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogRequest.ProtoReflect.Descriptor instead.
func (*LogRequest) Descriptor() ([]byte, []int) {
	return file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescGZIP(), []int{0}
}

func (x *LogRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *LogRequest) GetCommittish() string {
	if x != nil {
		return x.Committish
	}
	return ""
}

func (x *LogRequest) GetExcludeAncestorsOf() string {
	if x != nil {
		return x.ExcludeAncestorsOf
	}
	return ""
}

func (x *LogRequest) GetTreeDiff() bool {
	if x != nil {
		return x.TreeDiff
	}
	return false
}

func (x *LogRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *LogRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// LogRequest is response message for Gitiles.Log rpc.
type LogResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Retrieved commits.
	Log []*git.Commit `protobuf:"bytes,1,rep,name=log,proto3" json:"log,omitempty"`
	// A page token for next LogRequest to fetch next page of commits.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *LogResponse) Reset() {
	*x = LogResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogResponse) ProtoMessage() {}

func (x *LogResponse) ProtoReflect() protoreflect.Message {
	mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogResponse.ProtoReflect.Descriptor instead.
func (*LogResponse) Descriptor() ([]byte, []int) {
	return file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescGZIP(), []int{1}
}

func (x *LogResponse) GetLog() []*git.Commit {
	if x != nil {
		return x.Log
	}
	return nil
}

func (x *LogResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// RefsRequest is a request message of Gitiles.Refs RPC.
type RefsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Gitiles project, e.g. "chromium/src" part in
	// https://chromium.googlesource.com/chromium/src/+/master
	// Required.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Limits which refs to resolve to only those matching {refsPath}/*.
	//
	// Must be "refs" or start with "refs/".
	// Must not include glob '*'.
	// Use "refs/heads" to retrieve all branches.
	//
	// To fetch **all** refs in a repo, specify just "refs" but beware of two
	// caveats:
	//  * refs returned include a ref for each patchset for each Gerrit change
	//    associated with the repo.
	//  * returned map will contain special "HEAD" ref whose value in resulting map
	//    will be name of the actual ref to which "HEAD" points, which is typically
	//    "refs/heads/master".
	//
	// Thus, if you are looking for all tags and all branches of repo, it's
	// recommended to issue two Refs calls limited to "refs/tags" and "refs/heads"
	// instead of one call for "refs".
	//
	// Since Gerrit allows per-ref ACLs, it is possible that some refs matching
	// refPrefix would not be present in results because current user isn't granted
	// read permission on them.
	RefsPath string `protobuf:"bytes,2,opt,name=refs_path,json=refsPath,proto3" json:"refs_path,omitempty"`
}

func (x *RefsRequest) Reset() {
	*x = RefsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RefsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RefsRequest) ProtoMessage() {}

func (x *RefsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RefsRequest.ProtoReflect.Descriptor instead.
func (*RefsRequest) Descriptor() ([]byte, []int) {
	return file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescGZIP(), []int{2}
}

func (x *RefsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *RefsRequest) GetRefsPath() string {
	if x != nil {
		return x.RefsPath
	}
	return ""
}

// RefsResponse is a response message of Gitiles.Refs RPC.
type RefsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// revisions maps a ref to a revision.
	// Git branches have keys start with "refs/heads/".
	Revisions map[string]string `protobuf:"bytes,2,rep,name=revisions,proto3" json:"revisions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *RefsResponse) Reset() {
	*x = RefsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RefsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RefsResponse) ProtoMessage() {}

func (x *RefsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RefsResponse.ProtoReflect.Descriptor instead.
func (*RefsResponse) Descriptor() ([]byte, []int) {
	return file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescGZIP(), []int{3}
}

func (x *RefsResponse) GetRevisions() map[string]string {
	if x != nil {
		return x.Revisions
	}
	return nil
}

// ArchiveRequest is a request message of the Gitiles.Archive RPC.
type ArchiveRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Gitiles project, e.g. "chromium/src" part in
	// https://chromium.googlesource.com/chromium/src/+/master
	// Required.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// The ref at which to generate the project archive for.
	//
	// viz refs/for/branch or just branch
	Ref string `protobuf:"bytes,2,opt,name=ref,proto3" json:"ref,omitempty"`
	// Format of the returned project archive.
	Format ArchiveRequest_Format `protobuf:"varint,3,opt,name=format,proto3,enum=gitiles.ArchiveRequest_Format" json:"format,omitempty"`
}

func (x *ArchiveRequest) Reset() {
	*x = ArchiveRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveRequest) ProtoMessage() {}

func (x *ArchiveRequest) ProtoReflect() protoreflect.Message {
	mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveRequest.ProtoReflect.Descriptor instead.
func (*ArchiveRequest) Descriptor() ([]byte, []int) {
	return file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescGZIP(), []int{4}
}

func (x *ArchiveRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *ArchiveRequest) GetRef() string {
	if x != nil {
		return x.Ref
	}
	return ""
}

func (x *ArchiveRequest) GetFormat() ArchiveRequest_Format {
	if x != nil {
		return x.Format
	}
	return ArchiveRequest_Invalid
}

type ArchiveResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Suggested name of the returned archive.
	Filename string `protobuf:"bytes,1,opt,name=filename,proto3" json:"filename,omitempty"`
	// Contents of the archive streamed from gitiles.
	//
	// The underlying server RPC streams back the contents. This API simplifies
	// the RPC to a non-streaming response.
	Contents []byte `protobuf:"bytes,2,opt,name=contents,proto3" json:"contents,omitempty"`
}

func (x *ArchiveResponse) Reset() {
	*x = ArchiveResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveResponse) ProtoMessage() {}

func (x *ArchiveResponse) ProtoReflect() protoreflect.Message {
	mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveResponse.ProtoReflect.Descriptor instead.
func (*ArchiveResponse) Descriptor() ([]byte, []int) {
	return file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescGZIP(), []int{5}
}

func (x *ArchiveResponse) GetFilename() string {
	if x != nil {
		return x.Filename
	}
	return ""
}

func (x *ArchiveResponse) GetContents() []byte {
	if x != nil {
		return x.Contents
	}
	return nil
}

type DownloadFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Gitiles project, e.g. "chromium/src" part in
	// https://chromium.googlesource.com/chromium/src/+/master
	// Required.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// The commit where to start the listing from.
	// The value can be:
	//   - a git revision as 40-char string or its prefix so long as its unique in repo.
	//   - a ref such as "refs/heads/branch"
	//   - a ref defined as n-th parent of R in the form "R~n".
	//     For example, "master~2" or "deadbeef~1".
	// Required.
	Committish string `protobuf:"bytes,2,opt,name=committish,proto3" json:"committish,omitempty"`
	// Path relative to the project root to the file to download.
	Path string `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	// Format to download file in.
	Format DownloadFileRequest_Format `protobuf:"varint,4,opt,name=format,proto3,enum=gitiles.DownloadFileRequest_Format" json:"format,omitempty"`
}

func (x *DownloadFileRequest) Reset() {
	*x = DownloadFileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DownloadFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownloadFileRequest) ProtoMessage() {}

func (x *DownloadFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownloadFileRequest.ProtoReflect.Descriptor instead.
func (*DownloadFileRequest) Descriptor() ([]byte, []int) {
	return file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescGZIP(), []int{6}
}

func (x *DownloadFileRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *DownloadFileRequest) GetCommittish() string {
	if x != nil {
		return x.Committish
	}
	return ""
}

func (x *DownloadFileRequest) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *DownloadFileRequest) GetFormat() DownloadFileRequest_Format {
	if x != nil {
		return x.Format
	}
	return DownloadFileRequest_FormatInvalid
}

type DownloadFileResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Decoded contents of the downloaded file.
	//
	// The underlying server RPC streams back the contents. This API simplifies
	// the RPC to a non-streaming response.
	Contents string `protobuf:"bytes,1,opt,name=contents,proto3" json:"contents,omitempty"`
}

func (x *DownloadFileResponse) Reset() {
	*x = DownloadFileResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DownloadFileResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownloadFileResponse) ProtoMessage() {}

func (x *DownloadFileResponse) ProtoReflect() protoreflect.Message {
	mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownloadFileResponse.ProtoReflect.Descriptor instead.
func (*DownloadFileResponse) Descriptor() ([]byte, []int) {
	return file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescGZIP(), []int{7}
}

func (x *DownloadFileResponse) GetContents() string {
	if x != nil {
		return x.Contents
	}
	return ""
}

type ProjectsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ProjectsRequest) Reset() {
	*x = ProjectsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProjectsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProjectsRequest) ProtoMessage() {}

func (x *ProjectsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProjectsRequest.ProtoReflect.Descriptor instead.
func (*ProjectsRequest) Descriptor() ([]byte, []int) {
	return file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescGZIP(), []int{8}
}

type ProjectsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of available Gitiles projects
	Projects []string `protobuf:"bytes,1,rep,name=projects,proto3" json:"projects,omitempty"`
}

func (x *ProjectsResponse) Reset() {
	*x = ProjectsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProjectsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProjectsResponse) ProtoMessage() {}

func (x *ProjectsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProjectsResponse.ProtoReflect.Descriptor instead.
func (*ProjectsResponse) Descriptor() ([]byte, []int) {
	return file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescGZIP(), []int{9}
}

func (x *ProjectsResponse) GetProjects() []string {
	if x != nil {
		return x.Projects
	}
	return nil
}

var File_go_chromium_org_luci_common_proto_gitiles_gitiles_proto protoreflect.FileDescriptor

var file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x69, 0x75, 0x6d, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x6c, 0x75, 0x63, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x69, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x67, 0x69, 0x74, 0x69,
	0x6c, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x07, 0x67, 0x69, 0x74, 0x69, 0x6c,
	0x65, 0x73, 0x1a, 0x32, 0x67, 0x6f, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x69, 0x75, 0x6d, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x6c, 0x75, 0x63, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x69, 0x74, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd1, 0x01, 0x0a, 0x0a, 0x4c, 0x6f, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12,
	0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x69, 0x73, 0x68, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x69, 0x73, 0x68, 0x12,
	0x30, 0x0a, 0x14, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x73, 0x5f, 0x6f, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x65,
	0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x41, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x4f,
	0x66, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x72, 0x65, 0x65, 0x5f, 0x64, 0x69, 0x66, 0x66, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x74, 0x72, 0x65, 0x65, 0x44, 0x69, 0x66, 0x66, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x54, 0x0a, 0x0b, 0x4c, 0x6f,
	0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x03, 0x6c, 0x6f, 0x67,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x67, 0x69, 0x74, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x52, 0x03, 0x6c, 0x6f, 0x67, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x44, 0x0a, 0x0b, 0x52, 0x65, 0x66, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x65, 0x66,
	0x73, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65,
	0x66, 0x73, 0x50, 0x61, 0x74, 0x68, 0x22, 0x90, 0x01, 0x0a, 0x0c, 0x52, 0x65, 0x66, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x09, 0x72, 0x65, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x69, 0x74,
	0x69, 0x6c, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x66, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x09, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x3c, 0x0a, 0x0e, 0x52,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xb1, 0x01, 0x0a, 0x0e, 0x41, 0x72,
	0x63, 0x68, 0x69, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x72, 0x65, 0x66, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x72, 0x65, 0x66, 0x12, 0x36, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x67, 0x69, 0x74, 0x69, 0x6c,
	0x65, 0x73, 0x2e, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x22, 0x3b, 0x0a, 0x06, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x6e,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x47, 0x5a, 0x49, 0x50, 0x10,
	0x01, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x41, 0x52, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x5a,
	0x49, 0x50, 0x32, 0x10, 0x03, 0x12, 0x06, 0x0a, 0x02, 0x58, 0x5a, 0x10, 0x04, 0x22, 0x49, 0x0a,
	0x0f, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x1a, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xc7, 0x01, 0x0a, 0x13, 0x44, 0x6f, 0x77,
	0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x74, 0x69, 0x73, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x69, 0x73, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x3b,
	0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23,
	0x2e, 0x67, 0x69, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61,
	0x64, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x25, 0x0a, 0x06, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x11, 0x0a, 0x0d, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x49,
	0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x45, 0x58, 0x54,
	0x10, 0x01, 0x22, 0x32, 0x0a, 0x14, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x69,
	0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x11, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x2e, 0x0a, 0x10, 0x50, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1a, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x32, 0xc6, 0x02, 0x0a, 0x07, 0x47, 0x69,
	0x74, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x03, 0x4c, 0x6f, 0x67, 0x12, 0x13, 0x2e, 0x67,
	0x69, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x14, 0x2e, 0x67, 0x69, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x4c, 0x6f, 0x67, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x35, 0x0a, 0x04, 0x52, 0x65, 0x66,
	0x73, 0x12, 0x14, 0x2e, 0x67, 0x69, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x66, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x69, 0x74, 0x69, 0x6c, 0x65,
	0x73, 0x2e, 0x52, 0x65, 0x66, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x12, 0x3e, 0x0a, 0x07, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x12, 0x17, 0x2e, 0x67, 0x69,
	0x74, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x18, 0x2e, 0x67, 0x69, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x41,
	0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x12, 0x4d, 0x0a, 0x0c, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x69, 0x6c, 0x65,
	0x12, 0x1c, 0x2e, 0x67, 0x69, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c,
	0x6f, 0x61, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x69, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61,
	0x64, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12,
	0x41, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x18, 0x2e, 0x67, 0x69,
	0x74, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x67, 0x69, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x2e,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x42, 0x2b, 0x5a, 0x29, 0x67, 0x6f, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x69, 0x75,
	0x6d, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x6c, 0x75, 0x63, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x69, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescOnce sync.Once
	file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescData = file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDesc
)

func file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescGZIP() []byte {
	file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescOnce.Do(func() {
		file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescData = protoimpl.X.CompressGZIP(file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescData)
	})
	return file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDescData
}

var file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_goTypes = []interface{}{
	(ArchiveRequest_Format)(0),      // 0: gitiles.ArchiveRequest.Format
	(DownloadFileRequest_Format)(0), // 1: gitiles.DownloadFileRequest.Format
	(*LogRequest)(nil),              // 2: gitiles.LogRequest
	(*LogResponse)(nil),             // 3: gitiles.LogResponse
	(*RefsRequest)(nil),             // 4: gitiles.RefsRequest
	(*RefsResponse)(nil),            // 5: gitiles.RefsResponse
	(*ArchiveRequest)(nil),          // 6: gitiles.ArchiveRequest
	(*ArchiveResponse)(nil),         // 7: gitiles.ArchiveResponse
	(*DownloadFileRequest)(nil),     // 8: gitiles.DownloadFileRequest
	(*DownloadFileResponse)(nil),    // 9: gitiles.DownloadFileResponse
	(*ProjectsRequest)(nil),         // 10: gitiles.ProjectsRequest
	(*ProjectsResponse)(nil),        // 11: gitiles.ProjectsResponse
	nil,                             // 12: gitiles.RefsResponse.RevisionsEntry
	(*git.Commit)(nil),              // 13: git.Commit
}
var file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_depIdxs = []int32{
	13, // 0: gitiles.LogResponse.log:type_name -> git.Commit
	12, // 1: gitiles.RefsResponse.revisions:type_name -> gitiles.RefsResponse.RevisionsEntry
	0,  // 2: gitiles.ArchiveRequest.format:type_name -> gitiles.ArchiveRequest.Format
	1,  // 3: gitiles.DownloadFileRequest.format:type_name -> gitiles.DownloadFileRequest.Format
	2,  // 4: gitiles.Gitiles.Log:input_type -> gitiles.LogRequest
	4,  // 5: gitiles.Gitiles.Refs:input_type -> gitiles.RefsRequest
	6,  // 6: gitiles.Gitiles.Archive:input_type -> gitiles.ArchiveRequest
	8,  // 7: gitiles.Gitiles.DownloadFile:input_type -> gitiles.DownloadFileRequest
	10, // 8: gitiles.Gitiles.Projects:input_type -> gitiles.ProjectsRequest
	3,  // 9: gitiles.Gitiles.Log:output_type -> gitiles.LogResponse
	5,  // 10: gitiles.Gitiles.Refs:output_type -> gitiles.RefsResponse
	7,  // 11: gitiles.Gitiles.Archive:output_type -> gitiles.ArchiveResponse
	9,  // 12: gitiles.Gitiles.DownloadFile:output_type -> gitiles.DownloadFileResponse
	11, // 13: gitiles.Gitiles.Projects:output_type -> gitiles.ProjectsResponse
	9,  // [9:14] is the sub-list for method output_type
	4,  // [4:9] is the sub-list for method input_type
	4,  // [4:4] is the sub-list for extension type_name
	4,  // [4:4] is the sub-list for extension extendee
	0,  // [0:4] is the sub-list for field type_name
}

func init() { file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_init() }
func file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_init() {
	if File_go_chromium_org_luci_common_proto_gitiles_gitiles_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RefsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RefsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DownloadFileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DownloadFileResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProjectsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProjectsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_goTypes,
		DependencyIndexes: file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_depIdxs,
		EnumInfos:         file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_enumTypes,
		MessageInfos:      file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_msgTypes,
	}.Build()
	File_go_chromium_org_luci_common_proto_gitiles_gitiles_proto = out.File
	file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_rawDesc = nil
	file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_goTypes = nil
	file_go_chromium_org_luci_common_proto_gitiles_gitiles_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// GitilesClient is the client API for Gitiles service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type GitilesClient interface {
	// Log retrieves commit log.
	Log(ctx context.Context, in *LogRequest, opts ...grpc.CallOption) (*LogResponse, error)
	// Refs retrieves repo refs.
	Refs(ctx context.Context, in *RefsRequest, opts ...grpc.CallOption) (*RefsResponse, error)
	// Archive retrieves archived contents of the project.
	//
	// An archive is a shallow bundle of the contents of a repository.
	//
	// DEPRECATED: Use DownloadFile to obtain plain text files.
	// TODO(pprabhu): Migrate known users to DownloadFile and delete this RPC.
	Archive(ctx context.Context, in *ArchiveRequest, opts ...grpc.CallOption) (*ArchiveResponse, error)
	// DownloadFile retrieves a file from the project.
	DownloadFile(ctx context.Context, in *DownloadFileRequest, opts ...grpc.CallOption) (*DownloadFileResponse, error)
	// Projects retrieves list of available Gitiles projects
	Projects(ctx context.Context, in *ProjectsRequest, opts ...grpc.CallOption) (*ProjectsResponse, error)
}
type gitilesPRPCClient struct {
	client *prpc.Client
}

func NewGitilesPRPCClient(client *prpc.Client) GitilesClient {
	return &gitilesPRPCClient{client}
}

func (c *gitilesPRPCClient) Log(ctx context.Context, in *LogRequest, opts ...grpc.CallOption) (*LogResponse, error) {
	out := new(LogResponse)
	err := c.client.Call(ctx, "gitiles.Gitiles", "Log", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gitilesPRPCClient) Refs(ctx context.Context, in *RefsRequest, opts ...grpc.CallOption) (*RefsResponse, error) {
	out := new(RefsResponse)
	err := c.client.Call(ctx, "gitiles.Gitiles", "Refs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gitilesPRPCClient) Archive(ctx context.Context, in *ArchiveRequest, opts ...grpc.CallOption) (*ArchiveResponse, error) {
	out := new(ArchiveResponse)
	err := c.client.Call(ctx, "gitiles.Gitiles", "Archive", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gitilesPRPCClient) DownloadFile(ctx context.Context, in *DownloadFileRequest, opts ...grpc.CallOption) (*DownloadFileResponse, error) {
	out := new(DownloadFileResponse)
	err := c.client.Call(ctx, "gitiles.Gitiles", "DownloadFile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gitilesPRPCClient) Projects(ctx context.Context, in *ProjectsRequest, opts ...grpc.CallOption) (*ProjectsResponse, error) {
	out := new(ProjectsResponse)
	err := c.client.Call(ctx, "gitiles.Gitiles", "Projects", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

type gitilesClient struct {
	cc grpc.ClientConnInterface
}

func NewGitilesClient(cc grpc.ClientConnInterface) GitilesClient {
	return &gitilesClient{cc}
}

func (c *gitilesClient) Log(ctx context.Context, in *LogRequest, opts ...grpc.CallOption) (*LogResponse, error) {
	out := new(LogResponse)
	err := c.cc.Invoke(ctx, "/gitiles.Gitiles/Log", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gitilesClient) Refs(ctx context.Context, in *RefsRequest, opts ...grpc.CallOption) (*RefsResponse, error) {
	out := new(RefsResponse)
	err := c.cc.Invoke(ctx, "/gitiles.Gitiles/Refs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gitilesClient) Archive(ctx context.Context, in *ArchiveRequest, opts ...grpc.CallOption) (*ArchiveResponse, error) {
	out := new(ArchiveResponse)
	err := c.cc.Invoke(ctx, "/gitiles.Gitiles/Archive", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gitilesClient) DownloadFile(ctx context.Context, in *DownloadFileRequest, opts ...grpc.CallOption) (*DownloadFileResponse, error) {
	out := new(DownloadFileResponse)
	err := c.cc.Invoke(ctx, "/gitiles.Gitiles/DownloadFile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gitilesClient) Projects(ctx context.Context, in *ProjectsRequest, opts ...grpc.CallOption) (*ProjectsResponse, error) {
	out := new(ProjectsResponse)
	err := c.cc.Invoke(ctx, "/gitiles.Gitiles/Projects", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GitilesServer is the server API for Gitiles service.
type GitilesServer interface {
	// Log retrieves commit log.
	Log(context.Context, *LogRequest) (*LogResponse, error)
	// Refs retrieves repo refs.
	Refs(context.Context, *RefsRequest) (*RefsResponse, error)
	// Archive retrieves archived contents of the project.
	//
	// An archive is a shallow bundle of the contents of a repository.
	//
	// DEPRECATED: Use DownloadFile to obtain plain text files.
	// TODO(pprabhu): Migrate known users to DownloadFile and delete this RPC.
	Archive(context.Context, *ArchiveRequest) (*ArchiveResponse, error)
	// DownloadFile retrieves a file from the project.
	DownloadFile(context.Context, *DownloadFileRequest) (*DownloadFileResponse, error)
	// Projects retrieves list of available Gitiles projects
	Projects(context.Context, *ProjectsRequest) (*ProjectsResponse, error)
}

// UnimplementedGitilesServer can be embedded to have forward compatible implementations.
type UnimplementedGitilesServer struct {
}

func (*UnimplementedGitilesServer) Log(context.Context, *LogRequest) (*LogResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Log not implemented")
}
func (*UnimplementedGitilesServer) Refs(context.Context, *RefsRequest) (*RefsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Refs not implemented")
}
func (*UnimplementedGitilesServer) Archive(context.Context, *ArchiveRequest) (*ArchiveResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Archive not implemented")
}
func (*UnimplementedGitilesServer) DownloadFile(context.Context, *DownloadFileRequest) (*DownloadFileResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DownloadFile not implemented")
}
func (*UnimplementedGitilesServer) Projects(context.Context, *ProjectsRequest) (*ProjectsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Projects not implemented")
}

func RegisterGitilesServer(s prpc.Registrar, srv GitilesServer) {
	s.RegisterService(&_Gitiles_serviceDesc, srv)
}

func _Gitiles_Log_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GitilesServer).Log(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitiles.Gitiles/Log",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GitilesServer).Log(ctx, req.(*LogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gitiles_Refs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RefsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GitilesServer).Refs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitiles.Gitiles/Refs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GitilesServer).Refs(ctx, req.(*RefsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gitiles_Archive_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ArchiveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GitilesServer).Archive(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitiles.Gitiles/Archive",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GitilesServer).Archive(ctx, req.(*ArchiveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gitiles_DownloadFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DownloadFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GitilesServer).DownloadFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitiles.Gitiles/DownloadFile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GitilesServer).DownloadFile(ctx, req.(*DownloadFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gitiles_Projects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProjectsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GitilesServer).Projects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitiles.Gitiles/Projects",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GitilesServer).Projects(ctx, req.(*ProjectsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Gitiles_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gitiles.Gitiles",
	HandlerType: (*GitilesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Log",
			Handler:    _Gitiles_Log_Handler,
		},
		{
			MethodName: "Refs",
			Handler:    _Gitiles_Refs_Handler,
		},
		{
			MethodName: "Archive",
			Handler:    _Gitiles_Archive_Handler,
		},
		{
			MethodName: "DownloadFile",
			Handler:    _Gitiles_DownloadFile_Handler,
		},
		{
			MethodName: "Projects",
			Handler:    _Gitiles_Projects_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "go.chromium.org/luci/common/proto/gitiles/gitiles.proto",
}
