﻿// Copyright (c) .NET Foundation and contributors. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.
//

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Build.Framework;
using Microsoft.Build.Utilities;
using Moq;
using Xunit;

namespace Microsoft.NET.Sdk.BlazorWebAssembly.Tests
{
    public class ComputeBlazorPublishAssetsTest
    {
        [Fact]
        public void UpdatesAssets_WithLinked_Assemblies()
        {
            // Arrange
            var taskInstance = new ComputeBlazorPublishAssets
            {
                ExistingAssets = CreateLinkingExistingAssets(),
                ResolvedFilesToPublish = CreateLinkingResolvedFilesToPublish(),
                CopySymbols = false,
                InvariantGlobalization = false,
                TimeZoneSupport = true,
                PublishPath = "bin\\Debug\\net6.0\\publish\\"
            };

            taskInstance.BuildEngine = Mock.Of<IBuildEngine>();

            // Act
            taskInstance.Execute();

            // Assert
        }

        private ITaskItem[] CreateLinkingResolvedFilesToPublish() => new TaskItem[]
        {
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\dotnet.js", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "dotnet.js",
                ["RelativePath"] = "dotnet.js",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\dotnet.timezones.blat", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "dotnet.timezones.blat",
                ["RelativePath"] = "dotnet.timezones.blat",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\dotnet.wasm", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "dotnet.wasm",
                ["RelativePath"] = "dotnet.wasm",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\icudt.dat", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "icudt.dat",
                ["RelativePath"] = "icudt.dat",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\icudt_CJK.dat", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "icudt_CJK.dat",
                ["RelativePath"] = "icudt_CJK.dat",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\icudt_EFIGS.dat", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "icudt_EFIGS.dat",
                ["RelativePath"] = "icudt_EFIGS.dat",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\icudt_no_CJK.dat", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "icudt_no_CJK.dat",
                ["RelativePath"] = "icudt_no_CJK.dat",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\include\wasm\pinvoke.h", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "pinvoke.h",
                ["RelativePath"] = "pinvoke.h",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libSystem.IO.Compression.Native.a", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "libSystem.IO.Compression.Native.a",
                ["RelativePath"] = "libSystem.IO.Compression.Native.a",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libSystem.Native.a", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "libSystem.Native.a",
                ["RelativePath"] = "libSystem.Native.a",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libicui18n.a", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "libicui18n.a",
                ["RelativePath"] = "libicui18n.a",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libicuuc.a", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "libicuuc.a",
                ["RelativePath"] = "libicuuc.a",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libmono-component-diagnostics_tracing-static.a", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "libmono-component-diagnostics_tracing-static.a",
                ["RelativePath"] = "libmono-component-diagnostics_tracing-static.a",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libmono-component-diagnostics_tracing-stub-static.a", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "libmono-component-diagnostics_tracing-stub-static.a",
                ["RelativePath"] = "libmono-component-diagnostics_tracing-stub-static.a",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libmono-component-hot_reload-static.a", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "libmono-component-hot_reload-static.a",
                ["RelativePath"] = "libmono-component-hot_reload-static.a",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libmono-component-hot_reload-stub-static.a", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "libmono-component-hot_reload-stub-static.a",
                ["RelativePath"] = "libmono-component-hot_reload-stub-static.a",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libmono-ee-interp.a", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "libmono-ee-interp.a",
                ["RelativePath"] = "libmono-ee-interp.a",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libmono-icall-table.a", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "libmono-icall-table.a",
                ["RelativePath"] = "libmono-icall-table.a",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libmono-ilgen.a", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "libmono-ilgen.a",
                ["RelativePath"] = "libmono-ilgen.a",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libmono-profiler-aot.a", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "libmono-profiler-aot.a",
                ["RelativePath"] = "libmono-profiler-aot.a",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libmonosgen-2.0.a", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "libmonosgen-2.0.a",
                ["RelativePath"] = "libmonosgen-2.0.a",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\src\Emcc.props", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "Emcc.props",
                ["RelativePath"] = "Emcc.props",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\src\binding_support.js", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "binding_support.js",
                ["RelativePath"] = "binding_support.js",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\src\corebindings.c", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "corebindings.c",
                ["RelativePath"] = "corebindings.c",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\src\dotnet_support.js", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "dotnet_support.js",
                ["RelativePath"] = "dotnet_support.js",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\src\driver.c", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "driver.c",
                ["RelativePath"] = "driver.c",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\src\emcc-default.rsp", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "emcc-default.rsp",
                ["RelativePath"] = "emcc-default.rsp",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\src\library_mono.js", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "library_mono.js",
                ["RelativePath"] = "library_mono.js",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\src\pal_random.js", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "pal_random.js",
                ["RelativePath"] = "pal_random.js",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\src\pinvoke.c", new Dictionary<string,string>
            {
                ["FileVersion"] = "0.0.0.0",
                ["DestinationSubPath"] = "pinvoke.c",
                ["RelativePath"] = "pinvoke.c",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.AspNetCore.Authorization.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.AspNetCore.Authorization.dll",
                ["RelativePath"] = "Microsoft.AspNetCore.Authorization.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.AspNetCore.Authorization",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/net5.0/Microsoft.AspNetCore.Authorization.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.AspNetCore.Components.Forms.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.AspNetCore.Components.Forms.dll",
                ["RelativePath"] = "Microsoft.AspNetCore.Components.Forms.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.AspNetCore.Components.Forms",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/net5.0/Microsoft.AspNetCore.Components.Forms.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.AspNetCore.Components.Web.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.AspNetCore.Components.Web.dll",
                ["RelativePath"] = "Microsoft.AspNetCore.Components.Web.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.AspNetCore.Components.Web",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/net5.0/Microsoft.AspNetCore.Components.Web.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.AspNetCore.Components.WebAssembly.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.AspNetCore.Components.WebAssembly.dll",
                ["RelativePath"] = "Microsoft.AspNetCore.Components.WebAssembly.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.AspNetCore.Components.WebAssembly",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/net5.0/Microsoft.AspNetCore.Components.WebAssembly.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.AspNetCore.Components.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.AspNetCore.Components.dll",
                ["RelativePath"] = "Microsoft.AspNetCore.Components.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.AspNetCore.Components",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/net5.0/Microsoft.AspNetCore.Components.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.AspNetCore.Metadata.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.AspNetCore.Metadata.dll",
                ["RelativePath"] = "Microsoft.AspNetCore.Metadata.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.AspNetCore.Metadata",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/net5.0/Microsoft.AspNetCore.Metadata.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.Extensions.Configuration.Abstractions.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.Extensions.Configuration.Abstractions.dll",
                ["RelativePath"] = "Microsoft.Extensions.Configuration.Abstractions.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.Extensions.Configuration.Abstractions",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/netstandard2.0/Microsoft.Extensions.Configuration.Abstractions.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.Extensions.Configuration.Binder.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.Extensions.Configuration.Binder.dll",
                ["RelativePath"] = "Microsoft.Extensions.Configuration.Binder.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.Extensions.Configuration.Binder",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/netstandard2.0/Microsoft.Extensions.Configuration.Binder.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.Extensions.Configuration.FileExtensions.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.Extensions.Configuration.FileExtensions.dll",
                ["RelativePath"] = "Microsoft.Extensions.Configuration.FileExtensions.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.Extensions.Configuration.FileExtensions",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/netstandard2.0/Microsoft.Extensions.Configuration.FileExtensions.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.Extensions.Configuration.Json.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.Extensions.Configuration.Json.dll",
                ["RelativePath"] = "Microsoft.Extensions.Configuration.Json.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.Extensions.Configuration.Json",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/netstandard2.1/Microsoft.Extensions.Configuration.Json.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.Extensions.Configuration.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.Extensions.Configuration.dll",
                ["RelativePath"] = "Microsoft.Extensions.Configuration.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.Extensions.Configuration",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/netstandard2.0/Microsoft.Extensions.Configuration.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.Extensions.DependencyInjection.Abstractions.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.Extensions.DependencyInjection.Abstractions.dll",
                ["RelativePath"] = "Microsoft.Extensions.DependencyInjection.Abstractions.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.Extensions.DependencyInjection.Abstractions",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/netstandard2.0/Microsoft.Extensions.DependencyInjection.Abstractions.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.Extensions.DependencyInjection.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.Extensions.DependencyInjection.dll",
                ["RelativePath"] = "Microsoft.Extensions.DependencyInjection.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.Extensions.DependencyInjection",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/net5.0/Microsoft.Extensions.DependencyInjection.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.Extensions.FileProviders.Abstractions.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.Extensions.FileProviders.Abstractions.dll",
                ["RelativePath"] = "Microsoft.Extensions.FileProviders.Abstractions.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.Extensions.FileProviders.Abstractions",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/netstandard2.0/Microsoft.Extensions.FileProviders.Abstractions.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.Extensions.FileProviders.Physical.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.Extensions.FileProviders.Physical.dll",
                ["RelativePath"] = "Microsoft.Extensions.FileProviders.Physical.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.Extensions.FileProviders.Physical",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/netstandard2.0/Microsoft.Extensions.FileProviders.Physical.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.Extensions.FileSystemGlobbing.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.Extensions.FileSystemGlobbing.dll",
                ["RelativePath"] = "Microsoft.Extensions.FileSystemGlobbing.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.Extensions.FileSystemGlobbing",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/netstandard2.0/Microsoft.Extensions.FileSystemGlobbing.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.Extensions.Logging.Abstractions.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.Extensions.Logging.Abstractions.dll",
                ["RelativePath"] = "Microsoft.Extensions.Logging.Abstractions.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.Extensions.Logging.Abstractions",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/netstandard2.0/Microsoft.Extensions.Logging.Abstractions.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.Extensions.Logging.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.Extensions.Logging.dll",
                ["RelativePath"] = "Microsoft.Extensions.Logging.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.Extensions.Logging",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/netstandard2.1/Microsoft.Extensions.Logging.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.Extensions.Options.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.Extensions.Options.dll",
                ["RelativePath"] = "Microsoft.Extensions.Options.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.Extensions.Options",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/net5.0/Microsoft.Extensions.Options.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.Extensions.Primitives.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.Extensions.Primitives.dll",
                ["RelativePath"] = "Microsoft.Extensions.Primitives.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.Extensions.Primitives",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/netcoreapp3.0/Microsoft.Extensions.Primitives.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.JSInterop.WebAssembly.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.JSInterop.WebAssembly.dll",
                ["RelativePath"] = "Microsoft.JSInterop.WebAssembly.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.JSInterop.WebAssembly",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/net5.0/Microsoft.JSInterop.WebAssembly.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\Microsoft.JSInterop.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "Microsoft.JSInterop.dll",
                ["RelativePath"] = "Microsoft.JSInterop.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "Microsoft.JSInterop",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/net5.0/Microsoft.JSInterop.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Buffers.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Buffers.dll",
                ["RelativePath"] = "System.Buffers.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Collections.Concurrent.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Collections.Concurrent.dll",
                ["RelativePath"] = "System.Collections.Concurrent.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Collections.NonGeneric.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Collections.NonGeneric.dll",
                ["RelativePath"] = "System.Collections.NonGeneric.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Collections.Specialized.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Collections.Specialized.dll",
                ["RelativePath"] = "System.Collections.Specialized.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Collections.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Collections.dll",
                ["RelativePath"] = "System.Collections.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.ComponentModel.Annotations.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.ComponentModel.Annotations.dll",
                ["RelativePath"] = "System.ComponentModel.Annotations.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.ComponentModel.Primitives.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.ComponentModel.Primitives.dll",
                ["RelativePath"] = "System.ComponentModel.Primitives.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.ComponentModel.TypeConverter.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.ComponentModel.TypeConverter.dll",
                ["RelativePath"] = "System.ComponentModel.TypeConverter.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.ComponentModel.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.ComponentModel.dll",
                ["RelativePath"] = "System.ComponentModel.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Console.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Console.dll",
                ["RelativePath"] = "System.Console.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Diagnostics.Debug.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Diagnostics.Debug.dll",
                ["RelativePath"] = "System.Diagnostics.Debug.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Diagnostics.DiagnosticSource.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Diagnostics.DiagnosticSource.dll",
                ["RelativePath"] = "System.Diagnostics.DiagnosticSource.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Diagnostics.Tracing.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Diagnostics.Tracing.dll",
                ["RelativePath"] = "System.Diagnostics.Tracing.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.IO.FileSystem.Watcher.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.IO.FileSystem.Watcher.dll",
                ["RelativePath"] = "System.IO.FileSystem.Watcher.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.IO.Pipelines.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["DestinationSubPath"] = "System.IO.Pipelines.dll",
                ["RelativePath"] = "System.IO.Pipelines.dll",
                ["NuGetPackageVersion"] = "5.0.0",
                ["AssetType"] = "runtime",
                ["NuGetPackageId"] = "System.IO.Pipelines",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
                ["PathInPackage"] = "lib/netcoreapp3.0/System.IO.Pipelines.dll",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Linq.Expressions.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Linq.Expressions.dll",
                ["RelativePath"] = "System.Linq.Expressions.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Linq.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Linq.dll",
                ["RelativePath"] = "System.Linq.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Memory.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Memory.dll",
                ["RelativePath"] = "System.Memory.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Net.Http.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Net.Http.dll",
                ["RelativePath"] = "System.Net.Http.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.ObjectModel.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.ObjectModel.dll",
                ["RelativePath"] = "System.ObjectModel.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Private.CoreLib.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Private.CoreLib.dll",
                ["RelativePath"] = "System.Private.CoreLib.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "7cec85d7bea7798e",
                ["AssetType"] = "native",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "true",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Private.Runtime.InteropServices.JavaScript.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Private.Runtime.InteropServices.JavaScript.dll",
                ["RelativePath"] = "System.Private.Runtime.InteropServices.JavaScript.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Private.Uri.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Private.Uri.dll",
                ["RelativePath"] = "System.Private.Uri.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Reflection.Emit.ILGeneration.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Reflection.Emit.ILGeneration.dll",
                ["RelativePath"] = "System.Reflection.Emit.ILGeneration.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Reflection.Emit.Lightweight.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Reflection.Emit.Lightweight.dll",
                ["RelativePath"] = "System.Reflection.Emit.Lightweight.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Reflection.Primitives.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Reflection.Primitives.dll",
                ["RelativePath"] = "System.Reflection.Primitives.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Resources.ResourceManager.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Resources.ResourceManager.dll",
                ["RelativePath"] = "System.Resources.ResourceManager.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Runtime.CompilerServices.Unsafe.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Runtime.CompilerServices.Unsafe.dll",
                ["RelativePath"] = "System.Runtime.CompilerServices.Unsafe.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Runtime.Extensions.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Runtime.Extensions.dll",
                ["RelativePath"] = "System.Runtime.Extensions.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Runtime.InteropServices.RuntimeInformation.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Runtime.InteropServices.RuntimeInformation.dll",
                ["RelativePath"] = "System.Runtime.InteropServices.RuntimeInformation.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Runtime.Loader.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Runtime.Loader.dll",
                ["RelativePath"] = "System.Runtime.Loader.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Runtime.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Runtime.dll",
                ["RelativePath"] = "System.Runtime.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Security.Claims.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Security.Claims.dll",
                ["RelativePath"] = "System.Security.Claims.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Security.Cryptography.Algorithms.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Security.Cryptography.Algorithms.dll",
                ["RelativePath"] = "System.Security.Cryptography.Algorithms.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Security.Cryptography.Primitives.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Security.Cryptography.Primitives.dll",
                ["RelativePath"] = "System.Security.Cryptography.Primitives.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Text.Encodings.Web.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Text.Encodings.Web.dll",
                ["RelativePath"] = "System.Text.Encodings.Web.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Text.Json.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Text.Json.dll",
                ["RelativePath"] = "System.Text.Json.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Threading.Tasks.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Threading.Tasks.dll",
                ["RelativePath"] = "System.Threading.Tasks.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Threading.ThreadPool.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Threading.ThreadPool.dll",
                ["RelativePath"] = "System.Threading.ThreadPool.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.Threading.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.Threading.dll",
                ["RelativePath"] = "System.Threading.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "6.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\System.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "System.dll",
                ["RelativePath"] = "System.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "b77a5c561934e089",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "4.0.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\blazorwasm.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["RelativePath"] = "blazorwasm.dll",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"obj\Debug\net6.0\linked\netstandard.dll", new Dictionary<string, string>
            {
                ["PostprocessAssembly"] = "true",
                ["FileVersion"] = "6.0.21.32401",
                ["DestinationSubPath"] = "netstandard.dll",
                ["RelativePath"] = "netstandard.dll",
                ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                ["AssetType"] = "runtime",
                ["RuntimeIdentifier"] = "browser-wasm",
                ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                ["DropFromSingleFile"] = "",
                ["IsTrimmable"] = "",
                ["AssemblyVersion"] = "2.1.0.0",
                ["CopyLocal"] = "true",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            })
        };

        private ITaskItem[] CreateLinkingExistingAssets() => new TaskItem[]
        {
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\blazor.boot.json", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/blazor.boot.json",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "manifest",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"obj\Debug\net6.0\blazor.boot.json",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\blazor.webassembly.js", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/blazor.webassembly.js",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "All",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "boot",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.components.webassembly\5.0.0\build\net5.0\blazor.webassembly.js",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\blazorwasm.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/blazorwasm.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"obj\Debug\net6.0\blazorwasm.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\blazorwasm.pdb", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/blazorwasm.pdb",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "symbol",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"obj\Debug\net6.0\blazorwasm.pdb",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\dotnet.timezones.blat", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/dotnet.timezones.blat",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "native",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\dotnet.timezones.blat",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\dotnet.wasm", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/dotnet.wasm",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "native",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\dotnet.wasm",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\icudt_CJK.dat", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/icudt_CJK.dat",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "native",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\icudt_CJK.dat",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\icudt_EFIGS.dat", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/icudt_EFIGS.dat",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "native",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\icudt_EFIGS.dat",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\icudt_no_CJK.dat", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/icudt_no_CJK.dat",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "native",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\icudt_no_CJK.dat",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\icudt.dat", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/icudt.dat",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "native",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\icudt.dat",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Authorization.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.AspNetCore.Authorization.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.authorization\5.0.0\lib\net5.0\Microsoft.AspNetCore.Authorization.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Components.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.AspNetCore.Components.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.components\5.0.0\lib\net5.0\Microsoft.AspNetCore.Components.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Components.Forms.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.AspNetCore.Components.Forms.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.components.forms\5.0.0\lib\net5.0\Microsoft.AspNetCore.Components.Forms.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Components.Web.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.AspNetCore.Components.Web.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.components.web\5.0.0\lib\net5.0\Microsoft.AspNetCore.Components.Web.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Components.WebAssembly.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.AspNetCore.Components.WebAssembly.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.components.webassembly\5.0.0\lib\net5.0\Microsoft.AspNetCore.Components.WebAssembly.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Metadata.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.AspNetCore.Metadata.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.metadata\5.0.0\lib\net5.0\Microsoft.AspNetCore.Metadata.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.CSharp.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.CSharp.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\Microsoft.CSharp.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.Abstractions.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.Configuration.Abstractions.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.configuration.abstractions\5.0.0\lib\netstandard2.0\Microsoft.Extensions.Configuration.Abstractions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.Binder.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.Configuration.Binder.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.configuration.binder\5.0.0\lib\netstandard2.0\Microsoft.Extensions.Configuration.Binder.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.Configuration.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.configuration\5.0.0\lib\netstandard2.0\Microsoft.Extensions.Configuration.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.FileExtensions.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.Configuration.FileExtensions.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.configuration.fileextensions\5.0.0\lib\netstandard2.0\Microsoft.Extensions.Configuration.FileExtensions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.Json.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.Configuration.Json.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.configuration.json\5.0.0\lib\netstandard2.1\Microsoft.Extensions.Configuration.Json.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.DependencyInjection.Abstractions.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.DependencyInjection.Abstractions.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.dependencyinjection.abstractions\5.0.0\lib\netstandard2.0\Microsoft.Extensions.DependencyInjection.Abstractions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.DependencyInjection.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.DependencyInjection.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.dependencyinjection\5.0.0\lib\net5.0\Microsoft.Extensions.DependencyInjection.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.FileProviders.Abstractions.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.FileProviders.Abstractions.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.fileproviders.abstractions\5.0.0\lib\netstandard2.0\Microsoft.Extensions.FileProviders.Abstractions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.FileProviders.Physical.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.FileProviders.Physical.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.fileproviders.physical\5.0.0\lib\netstandard2.0\Microsoft.Extensions.FileProviders.Physical.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.FileSystemGlobbing.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.FileSystemGlobbing.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.filesystemglobbing\5.0.0\lib\netstandard2.0\Microsoft.Extensions.FileSystemGlobbing.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Logging.Abstractions.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.Logging.Abstractions.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.logging.abstractions\5.0.0\lib\netstandard2.0\Microsoft.Extensions.Logging.Abstractions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Logging.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.Logging.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.logging\5.0.0\lib\netstandard2.1\Microsoft.Extensions.Logging.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Options.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.Options.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.options\5.0.0\lib\net5.0\Microsoft.Extensions.Options.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Primitives.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.Primitives.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.primitives\5.0.0\lib\netcoreapp3.0\Microsoft.Extensions.Primitives.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.JSInterop.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.JSInterop.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.jsinterop\5.0.0\lib\net5.0\Microsoft.JSInterop.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.JSInterop.WebAssembly.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.JSInterop.WebAssembly.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.jsinterop.webassembly\5.0.0\lib\net5.0\Microsoft.JSInterop.WebAssembly.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.VisualBasic.Core.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.VisualBasic.Core.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\Microsoft.VisualBasic.Core.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.VisualBasic.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.VisualBasic.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\Microsoft.VisualBasic.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Win32.Primitives.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Win32.Primitives.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\Microsoft.Win32.Primitives.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Win32.Registry.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Win32.Registry.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\Microsoft.Win32.Registry.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\mscorlib.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/mscorlib.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\mscorlib.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\netstandard.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/netstandard.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\netstandard.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\RazorClassLibrary.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/RazorClassLibrary.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\razorclasslibrary\bin\Debug\netstandard2.1\RazorClassLibrary.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\RazorClassLibrary.pdb", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/RazorClassLibrary.pdb",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "symbol",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\razorclasslibrary\bin\Debug\netstandard2.1\RazorClassLibrary.pdb",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.AppContext.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.AppContext.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.AppContext.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Buffers.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Buffers.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Buffers.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.Concurrent.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Collections.Concurrent.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Collections.Concurrent.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Collections.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Collections.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.Immutable.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Collections.Immutable.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Collections.Immutable.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.NonGeneric.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Collections.NonGeneric.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Collections.NonGeneric.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.Specialized.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Collections.Specialized.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Collections.Specialized.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.Annotations.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ComponentModel.Annotations.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ComponentModel.Annotations.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.DataAnnotations.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ComponentModel.DataAnnotations.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ComponentModel.DataAnnotations.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ComponentModel.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ComponentModel.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.EventBasedAsync.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ComponentModel.EventBasedAsync.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ComponentModel.EventBasedAsync.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.Primitives.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ComponentModel.Primitives.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ComponentModel.Primitives.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.TypeConverter.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ComponentModel.TypeConverter.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ComponentModel.TypeConverter.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Configuration.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Configuration.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Configuration.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Console.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Console.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Console.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Core.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Core.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Core.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Data.Common.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Data.Common.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Data.Common.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Data.DataSetExtensions.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Data.DataSetExtensions.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Data.DataSetExtensions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Data.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Data.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Data.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Contracts.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.Contracts.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.Contracts.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Debug.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.Debug.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.Debug.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.DiagnosticSource.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.DiagnosticSource.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.DiagnosticSource.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.FileVersionInfo.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.FileVersionInfo.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.FileVersionInfo.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Process.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.Process.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.Process.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.StackTrace.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.StackTrace.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.StackTrace.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.TextWriterTraceListener.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.TextWriterTraceListener.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.TextWriterTraceListener.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Tools.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.Tools.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.Tools.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.TraceSource.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.TraceSource.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.TraceSource.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Tracing.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.Tracing.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.Tracing.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Drawing.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Drawing.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Drawing.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Drawing.Primitives.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Drawing.Primitives.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Drawing.Primitives.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Dynamic.Runtime.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Dynamic.Runtime.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Dynamic.Runtime.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Formats.Asn1.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Formats.Asn1.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Formats.Asn1.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Globalization.Calendars.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Globalization.Calendars.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Globalization.Calendars.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Globalization.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Globalization.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Globalization.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Globalization.Extensions.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Globalization.Extensions.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Globalization.Extensions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Compression.Brotli.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.Compression.Brotli.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.Compression.Brotli.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Compression.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.Compression.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.Compression.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Compression.FileSystem.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.Compression.FileSystem.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.Compression.FileSystem.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Compression.ZipFile.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.Compression.ZipFile.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.Compression.ZipFile.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.AccessControl.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.FileSystem.AccessControl.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.FileSystem.AccessControl.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.FileSystem.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.FileSystem.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.DriveInfo.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.FileSystem.DriveInfo.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.FileSystem.DriveInfo.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.Primitives.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.FileSystem.Primitives.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.FileSystem.Primitives.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.Watcher.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.FileSystem.Watcher.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.FileSystem.Watcher.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.IsolatedStorage.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.IsolatedStorage.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.IsolatedStorage.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.MemoryMappedFiles.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.MemoryMappedFiles.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.MemoryMappedFiles.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Pipelines.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.Pipelines.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\system.io.pipelines\5.0.0\lib\netcoreapp3.0\System.IO.Pipelines.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Pipes.AccessControl.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.Pipes.AccessControl.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.Pipes.AccessControl.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Pipes.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.Pipes.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.Pipes.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.UnmanagedMemoryStream.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.UnmanagedMemoryStream.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.UnmanagedMemoryStream.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Linq.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Linq.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Linq.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Linq.Expressions.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Linq.Expressions.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Linq.Expressions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Linq.Parallel.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Linq.Parallel.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Linq.Parallel.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Linq.Queryable.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Linq.Queryable.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Linq.Queryable.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Memory.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Memory.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Memory.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Http.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.Http.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Http.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Http.Json.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.Http.Json.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Http.Json.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.HttpListener.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.HttpListener.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.HttpListener.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Mail.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.Mail.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Mail.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.NameResolution.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.NameResolution.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.NameResolution.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.NetworkInformation.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.NetworkInformation.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.NetworkInformation.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Ping.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.Ping.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Ping.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Primitives.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.Primitives.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Primitives.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Quic.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.Quic.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Quic.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Requests.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.Requests.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Requests.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Security.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.Security.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Security.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.ServicePoint.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.ServicePoint.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.ServicePoint.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Sockets.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.Sockets.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Sockets.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebClient.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.WebClient.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.WebClient.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebHeaderCollection.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.WebHeaderCollection.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.WebHeaderCollection.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebProxy.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.WebProxy.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.WebProxy.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebSockets.Client.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.WebSockets.Client.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.WebSockets.Client.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebSockets.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.WebSockets.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.WebSockets.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Numerics.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Numerics.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Numerics.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Numerics.Vectors.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Numerics.Vectors.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Numerics.Vectors.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ObjectModel.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ObjectModel.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ObjectModel.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.CoreLib.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Private.CoreLib.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\System.Private.CoreLib.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.DataContractSerialization.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Private.DataContractSerialization.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Private.DataContractSerialization.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.Runtime.InteropServices.JavaScript.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Private.Runtime.InteropServices.JavaScript.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Private.Runtime.InteropServices.JavaScript.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.Uri.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Private.Uri.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Private.Uri.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.Xml.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Private.Xml.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Private.Xml.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.Xml.Linq.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Private.Xml.Linq.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Private.Xml.Linq.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.DispatchProxy.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Reflection.DispatchProxy.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.DispatchProxy.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Reflection.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Emit.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Reflection.Emit.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.Emit.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Emit.ILGeneration.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Reflection.Emit.ILGeneration.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.Emit.ILGeneration.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Emit.Lightweight.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Reflection.Emit.Lightweight.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.Emit.Lightweight.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Extensions.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Reflection.Extensions.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.Extensions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Metadata.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Reflection.Metadata.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.Metadata.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Primitives.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Reflection.Primitives.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.Primitives.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.TypeExtensions.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Reflection.TypeExtensions.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.TypeExtensions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Resources.Reader.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Resources.Reader.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Resources.Reader.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Resources.ResourceManager.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Resources.ResourceManager.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Resources.ResourceManager.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Resources.Writer.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Resources.Writer.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Resources.Writer.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.CompilerServices.Unsafe.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.CompilerServices.Unsafe.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.CompilerServices.Unsafe.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.CompilerServices.VisualC.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.CompilerServices.VisualC.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.CompilerServices.VisualC.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Extensions.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Extensions.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Extensions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Handles.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Handles.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Handles.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.InteropServices.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.InteropServices.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.InteropServices.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.InteropServices.RuntimeInformation.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.InteropServices.RuntimeInformation.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.InteropServices.RuntimeInformation.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Intrinsics.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Intrinsics.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Intrinsics.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Loader.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Loader.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Loader.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Numerics.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Numerics.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Numerics.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Serialization.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Serialization.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Serialization.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Serialization.Formatters.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Serialization.Formatters.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Serialization.Formatters.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Serialization.Json.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Serialization.Json.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Serialization.Json.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Serialization.Primitives.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Serialization.Primitives.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Serialization.Primitives.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Serialization.Xml.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Serialization.Xml.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Serialization.Xml.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.AccessControl.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.AccessControl.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.AccessControl.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Claims.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Claims.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Claims.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.Algorithms.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Cryptography.Algorithms.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Cryptography.Algorithms.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.Cng.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Cryptography.Cng.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Cryptography.Cng.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.Csp.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Cryptography.Csp.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Cryptography.Csp.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.Encoding.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Cryptography.Encoding.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Cryptography.Encoding.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.OpenSsl.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Cryptography.OpenSsl.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Cryptography.OpenSsl.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.Primitives.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Cryptography.Primitives.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Cryptography.Primitives.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.X509Certificates.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Cryptography.X509Certificates.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Cryptography.X509Certificates.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Principal.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Principal.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Principal.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Principal.Windows.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Principal.Windows.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Principal.Windows.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.SecureString.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.SecureString.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.SecureString.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ServiceModel.Web.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ServiceModel.Web.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ServiceModel.Web.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ServiceProcess.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ServiceProcess.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ServiceProcess.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Text.Encoding.CodePages.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Text.Encoding.CodePages.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Text.Encoding.CodePages.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Text.Encoding.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Text.Encoding.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Text.Encoding.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Text.Encoding.Extensions.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Text.Encoding.Extensions.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Text.Encoding.Extensions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Text.Encodings.Web.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Text.Encodings.Web.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Text.Encodings.Web.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Text.Json.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Text.Json.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Text.Json.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Text.RegularExpressions.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Text.RegularExpressions.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Text.RegularExpressions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Channels.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.Channels.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.Channels.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Overlapped.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.Overlapped.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.Overlapped.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Tasks.Dataflow.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.Tasks.Dataflow.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.Tasks.Dataflow.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Tasks.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.Tasks.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.Tasks.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Tasks.Extensions.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.Tasks.Extensions.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.Tasks.Extensions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Tasks.Parallel.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.Tasks.Parallel.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.Tasks.Parallel.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Thread.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.Thread.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.Thread.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.ThreadPool.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.ThreadPool.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.ThreadPool.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Timer.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.Timer.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.Timer.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Transactions.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Transactions.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Transactions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Transactions.Local.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Transactions.Local.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Transactions.Local.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ValueTuple.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ValueTuple.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ValueTuple.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Web.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Web.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Web.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Web.HttpUtility.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Web.HttpUtility.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Web.HttpUtility.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Windows.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Windows.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Windows.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Xml.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Xml.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.Linq.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Xml.Linq.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Xml.Linq.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.ReaderWriter.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Xml.ReaderWriter.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Xml.ReaderWriter.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.Serialization.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Xml.Serialization.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Xml.Serialization.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.XDocument.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Xml.XDocument.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Xml.XDocument.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.XmlDocument.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Xml.XmlDocument.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Xml.XmlDocument.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.XmlSerializer.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Xml.XmlSerializer.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Xml.XmlSerializer.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.XPath.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Xml.XPath.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Xml.XPath.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.XPath.XDocument.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Xml.XPath.XDocument.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Xml.XPath.XDocument.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\WindowsBase.dll", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/WindowsBase.dll",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "runtime",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\WindowsBase.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\blazor\_framework\dotnet.js", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/dotnet.6.0.0-preview.7.21324.1.js",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\blazor\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Primary",
                ["AssetTraitValue"] = "native",
                ["AssetTraitName"] = "BlazorWebAssemblyResource",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\dotnet.js",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\++AjHZP+.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Xml.XmlDocument.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.XmlDocument.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.XmlDocument.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\+7exWz4G.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Xml.Serialization.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.Serialization.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.Serialization.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\+GST+ZCo.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.Tasks.Parallel.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Tasks.Parallel.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Tasks.Parallel.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\+PHmEyJO.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.ThreadPool.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.ThreadPool.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.ThreadPool.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\+rE5QdxB.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\09hAy46l.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Private.CoreLib.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.CoreLib.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.CoreLib.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\0OR1xT0m.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Text.Json.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Text.Json.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Text.Json.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\0r6QjHVt.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.IsolatedStorage.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.IsolatedStorage.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.IsolatedStorage.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\1K6ys6zo.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Data.DataSetExtensions.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Data.DataSetExtensions.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Data.DataSetExtensions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\1L18q62E.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.Configuration.FileExtensions.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.FileExtensions.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.FileExtensions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\1waSeWsN.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/icudt_EFIGS.dat.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\icudt_EFIGS.dat",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\icudt_EFIGS.dat",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\29cl+S4X.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Reflection.Metadata.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Metadata.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Metadata.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\3F+WuQV2.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.Pipelines.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Pipelines.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Pipelines.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\3mghwLMy.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Dynamic.Runtime.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Dynamic.Runtime.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Dynamic.Runtime.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\3UR9NLe7.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Cryptography.X509Certificates.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.X509Certificates.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.X509Certificates.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\49UcIsxc.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Drawing.Primitives.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Drawing.Primitives.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Drawing.Primitives.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\4U222+xS.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Cryptography.Csp.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.Csp.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.Csp.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\4uolMv9n.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Text.Encodings.Web.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Text.Encodings.Web.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Text.Encodings.Web.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\5IFJB6FW.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.Primitives.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Primitives.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Primitives.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\5TuJVIxP.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.Logging.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Logging.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Logging.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\6A7FqhVq.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.AspNetCore.Components.Forms.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Components.Forms.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Components.Forms.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\6Mqx2irE.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/RazorClassLibrary.pdb.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\RazorClassLibrary.pdb",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\RazorClassLibrary.pdb",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\6nIG3hvA.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.Tasks.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Tasks.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Tasks.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\7ydsUPlT.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Cryptography.Cng.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.Cng.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.Cng.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\8F59I92j.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Reflection.Primitives.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Primitives.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Primitives.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\8ts+kHBv.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Text.RegularExpressions.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Text.RegularExpressions.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Text.RegularExpressions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\8xmpgxdp.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Reflection.Emit.ILGeneration.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Emit.ILGeneration.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Emit.ILGeneration.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\91yxkJc+.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.Configuration.Abstractions.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.Abstractions.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.Abstractions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\9c7j9Dbf.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.DependencyInjection.Abstractions.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.DependencyInjection.Abstractions.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.DependencyInjection.Abstractions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\9iKrSMTD.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Reflection.Extensions.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Extensions.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Extensions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\9xuaOifY.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Web.HttpUtility.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Web.HttpUtility.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Web.HttpUtility.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\9ZaYqcLQ.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.Tasks.Extensions.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Tasks.Extensions.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Tasks.Extensions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\ADf9tMgB.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ComponentModel.Annotations.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.Annotations.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.Annotations.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\AK9NAm4i.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Xml.Linq.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.Linq.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.Linq.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\alsM93Kv.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Globalization.Calendars.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Globalization.Calendars.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Globalization.Calendars.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\aOJDHjac.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Intrinsics.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Intrinsics.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Intrinsics.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\AuHsweFo.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Xml.XDocument.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.XDocument.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.XDocument.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\aVdEqr+B.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ValueTuple.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ValueTuple.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ValueTuple.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\BiEo5S0S.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Windows.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Windows.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Windows.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\bIsdSf33.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.NameResolution.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.NameResolution.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.NameResolution.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\BKqzh33S.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.Configuration.Binder.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.Binder.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.Binder.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\BKvs0t+J.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Resources.ResourceManager.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Resources.ResourceManager.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Resources.ResourceManager.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\BnEYByPZ.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/blazorwasm.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\blazorwasm.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\blazorwasm.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\BZb+xdgk.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.NetworkInformation.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.NetworkInformation.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.NetworkInformation.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\bZhqNqHe.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ServiceModel.Web.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ServiceModel.Web.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ServiceModel.Web.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\C0ajK+sf.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Collections.Concurrent.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.Concurrent.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.Concurrent.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\c0YOyV7v.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.Compression.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Compression.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Compression.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\C5atDOsv.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.Mail.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Mail.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Mail.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\cDcH9MTF.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Private.Runtime.InteropServices.JavaScript.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.Runtime.InteropServices.JavaScript.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.Runtime.InteropServices.JavaScript.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\chOYhhtW.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.CompilerServices.VisualC.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.CompilerServices.VisualC.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.CompilerServices.VisualC.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\cTMIfHRM.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Cryptography.Encoding.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.Encoding.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.Encoding.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\CTu1rY2T.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Collections.Specialized.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.Specialized.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.Specialized.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\D4S0+xrK.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ComponentModel.EventBasedAsync.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.EventBasedAsync.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.EventBasedAsync.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\dQmaGAaK.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.JSInterop.WebAssembly.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.JSInterop.WebAssembly.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.JSInterop.WebAssembly.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\DQrRbA8o.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Linq.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Linq.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Linq.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\DspdfN7k.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Xml.ReaderWriter.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.ReaderWriter.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.ReaderWriter.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\Dx4JSEZX.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Globalization.Extensions.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Globalization.Extensions.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Globalization.Extensions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\E7SCWN1k.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.Thread.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Thread.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Thread.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\ebrsSK51.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.InteropServices.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.InteropServices.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.InteropServices.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\eE1XLnCu.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.FileProviders.Physical.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.FileProviders.Physical.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.FileProviders.Physical.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\eywDgqSL.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.Channels.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Channels.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Channels.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\f+qaHXKZ.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\f6vnSBQN.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Numerics.Vectors.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Numerics.Vectors.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Numerics.Vectors.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\fAUwYSe0.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.AppContext.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.AppContext.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.AppContext.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\fbL8mi5l.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.Quic.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Quic.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Quic.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\FEZSEPjq.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Win32.Registry.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Win32.Registry.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Win32.Registry.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\FIh+1Aub.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Collections.Immutable.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.Immutable.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.Immutable.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\FO1zSx+7.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.Ping.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Ping.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Ping.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\fXR4zeI9.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.FileSystem.Watcher.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.Watcher.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.Watcher.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\g1q2e0BM.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Win32.Primitives.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Win32.Primitives.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Win32.Primitives.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\G7BTkzWb.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.Configuration.Json.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.Json.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.Json.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\G8A7zsbX.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Resources.Reader.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Resources.Reader.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Resources.Reader.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\gEECxi3X.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.DiagnosticSource.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.DiagnosticSource.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.DiagnosticSource.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\ggFzzH3Y.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Transactions.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Transactions.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Transactions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\gi+o8xn+.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Web.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Web.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Web.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\gjzM+0NL.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/RazorClassLibrary.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\RazorClassLibrary.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\RazorClassLibrary.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\gsSbvAOx.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.HttpListener.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.HttpListener.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.HttpListener.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\GX+wCB8D.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.TraceSource.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.TraceSource.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.TraceSource.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\gX9olCms.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Cryptography.Primitives.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.Primitives.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.Primitives.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\gXaCaBt0.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.Primitives.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Primitives.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Primitives.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\H0TgxxJ+.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.AspNetCore.Authorization.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Authorization.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Authorization.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\h5aC0kJo.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Linq.Queryable.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Linq.Queryable.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Linq.Queryable.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\H89RUa+r.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Text.Encoding.Extensions.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Text.Encoding.Extensions.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Text.Encoding.Extensions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\hDOQ4BoC.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.ServicePoint.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.ServicePoint.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.ServicePoint.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\hn58HiFu.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/icudt_CJK.dat.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\icudt_CJK.dat",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\icudt_CJK.dat",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\I+NGj+Bp.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.Sockets.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Sockets.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Sockets.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\IFTXYO2w.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.Compression.Brotli.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Compression.Brotli.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Compression.Brotli.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\iqxKyRyr.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Claims.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Claims.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Claims.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\J0B48RwJ.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.Overlapped.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Overlapped.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Overlapped.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\J1YsBvSQ.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Data.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Data.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Data.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\j7BaM4rh.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.Tools.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Tools.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Tools.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\JHu8YGRu.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.FileVersionInfo.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.FileVersionInfo.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.FileVersionInfo.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\JQMnaT2B.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Collections.NonGeneric.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.NonGeneric.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.NonGeneric.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\kDvwYPwK.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.WebProxy.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebProxy.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebProxy.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\KgyOxWnY.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.FileSystem.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\kJt4UPn3.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.Configuration.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\KROe+FDU.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/dotnet.wasm.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\dotnet.wasm",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\dotnet.wasm",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\kZ+QUnml.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.AspNetCore.Components.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Components.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Components.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\L+muk626.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Xml.XPath.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.XPath.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.XPath.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\l7yiyphu.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\lfyumLH8.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.InteropServices.RuntimeInformation.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.InteropServices.RuntimeInformation.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.InteropServices.RuntimeInformation.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\lIdO+COb.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\lPz5Zwef.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.DependencyInjection.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.DependencyInjection.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.DependencyInjection.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\lvQ9cJQr.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.Timer.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Timer.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Timer.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\M4cFAl+s.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Reflection.DispatchProxy.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.DispatchProxy.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.DispatchProxy.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\ma25nuWQ.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Private.DataContractSerialization.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.DataContractSerialization.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.DataContractSerialization.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\mazfj+LE.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.WebHeaderCollection.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebHeaderCollection.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebHeaderCollection.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\MLvztwzm.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Serialization.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Serialization.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Serialization.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\mnOsLO7s.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.MemoryMappedFiles.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.MemoryMappedFiles.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.MemoryMappedFiles.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\MTXEbmRg.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Loader.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Loader.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Loader.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\mYr12CK5.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.Compression.ZipFile.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Compression.ZipFile.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Compression.ZipFile.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\N6f9VoF3.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/blazorwasm.pdb.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\blazorwasm.pdb",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\blazorwasm.pdb",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\N8gHZVxp.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/netstandard.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\netstandard.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\netstandard.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\NeUkzqSl.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.Pipes.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Pipes.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Pipes.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\nH72VjGq.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.JSInterop.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.JSInterop.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.JSInterop.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\nNt414rI.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.Contracts.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Contracts.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Contracts.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\NRZk3IK+.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Transactions.Local.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Transactions.Local.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Transactions.Local.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\nUW+AdJy.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.Process.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Process.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Process.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\nvletfcp.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.FileSystem.Primitives.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.Primitives.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.Primitives.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\NyOLnSCm.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.StackTrace.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.StackTrace.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.StackTrace.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\O7RNVEsE.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Numerics.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Numerics.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Numerics.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\OHAkqiGD.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.TextWriterTraceListener.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.TextWriterTraceListener.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.TextWriterTraceListener.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\OkdSyBhJ.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\oPVPTMds.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Serialization.Formatters.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Serialization.Formatters.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Serialization.Formatters.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\p6wpuiim.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/WindowsBase.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\WindowsBase.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\WindowsBase.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\PR+UFvFH.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\PSGkP7gE.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Private.Xml.Linq.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.Xml.Linq.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.Xml.Linq.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\PsLQlZou.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ComponentModel.Primitives.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.Primitives.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.Primitives.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\PWXsRsnu.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Reflection.Emit.Lightweight.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Emit.Lightweight.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Emit.Lightweight.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\q73T0vaq.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Collections.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\q8h8GIn3.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Cryptography.Algorithms.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.Algorithms.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.Algorithms.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\qdYkl7S+.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ComponentModel.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\Qgkt+gVL.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/dotnet.timezones.blat.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\dotnet.timezones.blat",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\dotnet.timezones.blat",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\qMyg7+gn.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ComponentModel.DataAnnotations.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.DataAnnotations.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.DataAnnotations.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\QTokxP1E.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.VisualBasic.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.VisualBasic.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.VisualBasic.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\qVyhqJ1W.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Principal.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Principal.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Principal.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\qZOba4BY.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Serialization.Primitives.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Serialization.Primitives.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Serialization.Primitives.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\r1UIG6Lv.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ObjectModel.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ObjectModel.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ObjectModel.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\rd1EgXpw.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Resources.Writer.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Resources.Writer.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Resources.Writer.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\rFGJhAjY.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Globalization.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Globalization.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Globalization.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\RgK+XHSY.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/icudt.dat.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\icudt.dat",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\icudt.dat",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\rHQNq7U3.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.Http.Json.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Http.Json.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Http.Json.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\RJvJ5dIS.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Configuration.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Configuration.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Configuration.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\rOcVNg5N.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.Security.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Security.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Security.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\s49JonxW.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/blazor.webassembly.js.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "All",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\blazor.webassembly.js",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\blazor.webassembly.js",
                ["CopyToPublishDirectory"] = "PreserveNewest",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\SdTkr+bO.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Xml.XPath.XDocument.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.XPath.XDocument.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.XPath.XDocument.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\TdNoJyH+.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Reflection.Emit.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Emit.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Emit.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\tOfXlbH2.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Principal.Windows.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Principal.Windows.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Principal.Windows.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\tQXX2Vuu.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.Http.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Http.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Http.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\tse7tvh1.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Linq.Parallel.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Linq.Parallel.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Linq.Parallel.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\Tu+hLej+.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Text.Encoding.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Text.Encoding.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Text.Encoding.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\TVa+jgra.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.AspNetCore.Components.WebAssembly.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Components.WebAssembly.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Components.WebAssembly.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\TyAlVw6l.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.SecureString.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.SecureString.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.SecureString.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\tZf+70MT.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ServiceProcess.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ServiceProcess.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ServiceProcess.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\uBVgDlov.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/mscorlib.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\mscorlib.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\mscorlib.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\uhAfajoN.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.CSharp.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.CSharp.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.CSharp.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\Uj+uffiC.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Linq.Expressions.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Linq.Expressions.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Linq.Expressions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\UO86EJ8C.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.FileSystemGlobbing.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.FileSystemGlobbing.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.FileSystemGlobbing.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\uuppb8jf.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.UnmanagedMemoryStream.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.UnmanagedMemoryStream.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.UnmanagedMemoryStream.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\ux5ZtwDE.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/icudt_no_CJK.dat.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\icudt_no_CJK.dat",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\icudt_no_CJK.dat",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\UxOXd7ya.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Formats.Asn1.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Formats.Asn1.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Formats.Asn1.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\v1TLRI+g.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Private.Uri.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.Uri.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.Uri.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\v4ZhjQod.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.Compression.FileSystem.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Compression.FileSystem.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Compression.FileSystem.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\vcCd6GWl.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Drawing.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Drawing.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Drawing.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\vcdOrBDG.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.Tracing.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Tracing.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Tracing.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\vdIvkmr1.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Serialization.Xml.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Serialization.Xml.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Serialization.Xml.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\vH1y4veV.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.AccessControl.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.AccessControl.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.AccessControl.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\vsQEDgyD.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Reflection.TypeExtensions.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.TypeExtensions.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.TypeExtensions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\VtJ6a2du.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Core.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Core.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Core.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\VZ+SzOfo.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Extensions.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Extensions.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Extensions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\vzqp3C86.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.WebClient.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebClient.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebClient.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\W+GQpjGY.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Handles.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Handles.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Handles.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\w7Syoq4p.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Data.Common.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Data.Common.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Data.Common.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\WAwBCvqq.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.FileSystem.DriveInfo.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.DriveInfo.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.DriveInfo.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\whh8zCvv.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Memory.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Memory.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Memory.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\Wp8e+qhJ.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Diagnostics.Debug.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Debug.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Debug.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\xcAiOepw.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Numerics.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Numerics.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Numerics.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\XHy++t+s.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Xml.XmlSerializer.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.XmlSerializer.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.XmlSerializer.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\XYvgnebQ.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.Options.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Options.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Options.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\xZZY4cKw.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Threading.Tasks.Dataflow.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Tasks.Dataflow.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Threading.Tasks.Dataflow.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\y2qA34iA.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.Logging.Abstractions.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Logging.Abstractions.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Logging.Abstractions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\y9GIFfbQ.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.FileSystem.AccessControl.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.AccessControl.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.AccessControl.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\yh+m7zo6.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Security.Cryptography.OpenSsl.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.OpenSsl.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Security.Cryptography.OpenSsl.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\ykmQyz8Z.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Reflection.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\YLCBIfvn.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.IO.Pipes.AccessControl.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Pipes.AccessControl.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Pipes.AccessControl.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\yT3GJ6+W.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.Extensions.FileProviders.Abstractions.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.FileProviders.Abstractions.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.FileProviders.Abstractions.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\yuQdvMUh.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.ComponentModel.TypeConverter.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.TypeConverter.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.TypeConverter.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\yw7zJSzS.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Text.Encoding.CodePages.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Text.Encoding.CodePages.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Text.Encoding.CodePages.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\Yx878RYZ.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.WebSockets.Client.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebSockets.Client.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebSockets.Client.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\YXvVBLSJ.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.Requests.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Requests.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Requests.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\Z+iEohq6.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Console.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Console.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Console.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\z98ix4dL.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Private.Xml.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.Xml.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.Xml.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\ZGf6XRBp.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.AspNetCore.Components.Web.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Components.Web.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Components.Web.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\ZhLjnxam.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Xml.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Xml.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\zlfkHXIA.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Net.WebSockets.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebSockets.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebSockets.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\zOunwK6R.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Buffers.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Buffers.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Buffers.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\zqoqRkWG.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.AspNetCore.Metadata.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Metadata.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Metadata.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\ZrwJCZ8b.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.Serialization.Json.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Serialization.Json.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.Serialization.Json.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\ZvL2CDxW.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/System.Runtime.CompilerServices.Unsafe.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.CompilerServices.Unsafe.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Runtime.CompilerServices.Unsafe.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
            new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\obj\Debug\net6.0\build-gz\zwfoj9Kc.gz", new Dictionary<string,string>{
                ["RelativePath"] = "_framework/Microsoft.VisualBasic.Core.dll.gz",
                ["BasePath"] = "/",
                ["AssetMode"] = "All",
                ["AssetKind"] = "Build",
                ["SourceId"] = "blazorwasm",
                ["CopyToOutputDirectory"] = "PreserveNewest",
                ["RelatedAsset"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.VisualBasic.Core.dll",
                ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                ["SourceType"] = "Computed",
                ["AssetRole"] = "Alternative",
                ["AssetTraitValue"] = "gzip",
                ["AssetTraitName"] = "Content-Encoding",
                ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_WithL---11274BB5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.VisualBasic.Core.dll",
                ["CopyToPublishDirectory"] = "Never",
            }),
        };

        [Fact]
        public void Updates()
        {
            // Arrange
            var taskInstance = new ComputeBlazorPublishAssets
            {
                ExistingAssets = CreateExistingAssets(),
                ResolvedFilesToPublish = CreateResolvedFilesToPublish(),
                CopySymbols = false,
                InvariantGlobalization = false,
                TimeZoneSupport = true,
                PublishPath = "bin\\Debug\\net6.0\\publish\\"
            };

            taskInstance.BuildEngine = Mock.Of<IBuildEngine>();

            // Act
            taskInstance.Execute();

            // Assert
        }

        private ITaskItem[] CreateResolvedFilesToPublish()
        {
            return new TaskItem[] 
            {
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.authorization\5.0.0\lib\net5.0\Microsoft.AspNetCore.Authorization.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.AspNetCore.Authorization.dll",
                    ["RelativePath"] = @"Microsoft.AspNetCore.Authorization.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.AspNetCore.Authorization",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/net5.0/Microsoft.AspNetCore.Authorization.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.components.forms\5.0.0\lib\net5.0\Microsoft.AspNetCore.Components.Forms.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.AspNetCore.Components.Forms.dll",
                    ["RelativePath"] = @"Microsoft.AspNetCore.Components.Forms.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.AspNetCore.Components.Forms",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/net5.0/Microsoft.AspNetCore.Components.Forms.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.components.web\5.0.0\lib\net5.0\Microsoft.AspNetCore.Components.Web.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.AspNetCore.Components.Web.dll",
                    ["RelativePath"] = @"Microsoft.AspNetCore.Components.Web.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.AspNetCore.Components.Web",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/net5.0/Microsoft.AspNetCore.Components.Web.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.components.webassembly\5.0.0\lib\net5.0\Microsoft.AspNetCore.Components.WebAssembly.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.AspNetCore.Components.WebAssembly.dll",
                    ["RelativePath"] = @"Microsoft.AspNetCore.Components.WebAssembly.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.AspNetCore.Components.WebAssembly",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/net5.0/Microsoft.AspNetCore.Components.WebAssembly.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.components\5.0.0\lib\net5.0\Microsoft.AspNetCore.Components.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.AspNetCore.Components.dll",
                    ["RelativePath"] = @"Microsoft.AspNetCore.Components.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.AspNetCore.Components",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/net5.0/Microsoft.AspNetCore.Components.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.metadata\5.0.0\lib\net5.0\Microsoft.AspNetCore.Metadata.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.AspNetCore.Metadata.dll",
                    ["RelativePath"] = @"Microsoft.AspNetCore.Metadata.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.AspNetCore.Metadata",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/net5.0/Microsoft.AspNetCore.Metadata.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.common\3.4.0\lib\netstandard2.0\Microsoft.CodeAnalysis.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.CodeAnalysis.dll",
                    ["RelativePath"] = @"Microsoft.CodeAnalysis.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.Common",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/Microsoft.CodeAnalysis.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.common\3.4.0\lib\netstandard2.0\cs\Microsoft.CodeAnalysis.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"cs\Microsoft.CodeAnalysis.resources.dll",
                    ["RelativePath"] = @"cs\Microsoft.CodeAnalysis.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "cs",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.Common",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"cs\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/cs/Microsoft.CodeAnalysis.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.common\3.4.0\lib\netstandard2.0\de\Microsoft.CodeAnalysis.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"de\Microsoft.CodeAnalysis.resources.dll",
                    ["RelativePath"] = @"de\Microsoft.CodeAnalysis.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "de",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.Common",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"de\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/de/Microsoft.CodeAnalysis.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.common\3.4.0\lib\netstandard2.0\es\Microsoft.CodeAnalysis.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"es\Microsoft.CodeAnalysis.resources.dll",
                    ["RelativePath"] = @"es\Microsoft.CodeAnalysis.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "es",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.Common",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"es\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/es/Microsoft.CodeAnalysis.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.common\3.4.0\lib\netstandard2.0\fr\Microsoft.CodeAnalysis.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"fr\Microsoft.CodeAnalysis.resources.dll",
                    ["RelativePath"] = @"fr\Microsoft.CodeAnalysis.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "fr",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.Common",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"fr\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/fr/Microsoft.CodeAnalysis.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.common\3.4.0\lib\netstandard2.0\it\Microsoft.CodeAnalysis.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"it\Microsoft.CodeAnalysis.resources.dll",
                    ["RelativePath"] = @"it\Microsoft.CodeAnalysis.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "it",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.Common",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"it\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/it/Microsoft.CodeAnalysis.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.common\3.4.0\lib\netstandard2.0\ja\Microsoft.CodeAnalysis.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"ja\Microsoft.CodeAnalysis.resources.dll",
                    ["RelativePath"] = @"ja\Microsoft.CodeAnalysis.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "ja",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.Common",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"ja\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/ja/Microsoft.CodeAnalysis.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.common\3.4.0\lib\netstandard2.0\ko\Microsoft.CodeAnalysis.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"ko\Microsoft.CodeAnalysis.resources.dll",
                    ["RelativePath"] = @"ko\Microsoft.CodeAnalysis.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "ko",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.Common",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"ko\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/ko/Microsoft.CodeAnalysis.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.common\3.4.0\lib\netstandard2.0\pl\Microsoft.CodeAnalysis.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"pl\Microsoft.CodeAnalysis.resources.dll",
                    ["RelativePath"] = @"pl\Microsoft.CodeAnalysis.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "pl",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.Common",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"pl\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/pl/Microsoft.CodeAnalysis.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.common\3.4.0\lib\netstandard2.0\pt-BR\Microsoft.CodeAnalysis.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"pt-BR\Microsoft.CodeAnalysis.resources.dll",
                    ["RelativePath"] = @"pt-BR\Microsoft.CodeAnalysis.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "pt-BR",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.Common",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"pt-BR\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/pt-BR/Microsoft.CodeAnalysis.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.common\3.4.0\lib\netstandard2.0\ru\Microsoft.CodeAnalysis.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"ru\Microsoft.CodeAnalysis.resources.dll",
                    ["RelativePath"] = @"ru\Microsoft.CodeAnalysis.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "ru",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.Common",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"ru\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/ru/Microsoft.CodeAnalysis.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.common\3.4.0\lib\netstandard2.0\tr\Microsoft.CodeAnalysis.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"tr\Microsoft.CodeAnalysis.resources.dll",
                    ["RelativePath"] = @"tr\Microsoft.CodeAnalysis.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "tr",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.Common",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"tr\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/tr/Microsoft.CodeAnalysis.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.common\3.4.0\lib\netstandard2.0\zh-Hans\Microsoft.CodeAnalysis.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"zh-Hans\Microsoft.CodeAnalysis.resources.dll",
                    ["RelativePath"] = @"zh-Hans\Microsoft.CodeAnalysis.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "zh-Hans",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.Common",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"zh-Hans\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/zh-Hans/Microsoft.CodeAnalysis.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.common\3.4.0\lib\netstandard2.0\zh-Hant\Microsoft.CodeAnalysis.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"zh-Hant\Microsoft.CodeAnalysis.resources.dll",
                    ["RelativePath"] = @"zh-Hant\Microsoft.CodeAnalysis.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "zh-Hant",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.Common",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"zh-Hant\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/zh-Hant/Microsoft.CodeAnalysis.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.csharp\3.4.0\lib\netstandard2.0\Microsoft.CodeAnalysis.CSharp.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.CodeAnalysis.CSharp.dll",
                    ["RelativePath"] = @"Microsoft.CodeAnalysis.CSharp.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.CSharp",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/Microsoft.CodeAnalysis.CSharp.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.csharp\3.4.0\lib\netstandard2.0\cs\Microsoft.CodeAnalysis.CSharp.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"cs\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["RelativePath"] = @"cs\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "cs",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.CSharp",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"cs\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/cs/Microsoft.CodeAnalysis.CSharp.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.csharp\3.4.0\lib\netstandard2.0\de\Microsoft.CodeAnalysis.CSharp.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"de\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["RelativePath"] = @"de\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "de",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.CSharp",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"de\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/de/Microsoft.CodeAnalysis.CSharp.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.csharp\3.4.0\lib\netstandard2.0\es\Microsoft.CodeAnalysis.CSharp.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"es\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["RelativePath"] = @"es\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "es",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.CSharp",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"es\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/es/Microsoft.CodeAnalysis.CSharp.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.csharp\3.4.0\lib\netstandard2.0\fr\Microsoft.CodeAnalysis.CSharp.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"fr\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["RelativePath"] = @"fr\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "fr",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.CSharp",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"fr\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/fr/Microsoft.CodeAnalysis.CSharp.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.csharp\3.4.0\lib\netstandard2.0\it\Microsoft.CodeAnalysis.CSharp.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"it\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["RelativePath"] = @"it\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "it",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.CSharp",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"it\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/it/Microsoft.CodeAnalysis.CSharp.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.csharp\3.4.0\lib\netstandard2.0\ja\Microsoft.CodeAnalysis.CSharp.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"ja\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["RelativePath"] = @"ja\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "ja",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.CSharp",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"ja\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/ja/Microsoft.CodeAnalysis.CSharp.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.csharp\3.4.0\lib\netstandard2.0\ko\Microsoft.CodeAnalysis.CSharp.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"ko\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["RelativePath"] = @"ko\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "ko",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.CSharp",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"ko\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/ko/Microsoft.CodeAnalysis.CSharp.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.csharp\3.4.0\lib\netstandard2.0\pl\Microsoft.CodeAnalysis.CSharp.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"pl\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["RelativePath"] = @"pl\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "pl",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.CSharp",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"pl\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/pl/Microsoft.CodeAnalysis.CSharp.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.csharp\3.4.0\lib\netstandard2.0\pt-BR\Microsoft.CodeAnalysis.CSharp.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"pt-BR\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["RelativePath"] = @"pt-BR\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "pt-BR",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.CSharp",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"pt-BR\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/pt-BR/Microsoft.CodeAnalysis.CSharp.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.csharp\3.4.0\lib\netstandard2.0\ru\Microsoft.CodeAnalysis.CSharp.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"ru\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["RelativePath"] = @"ru\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "ru",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.CSharp",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"ru\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/ru/Microsoft.CodeAnalysis.CSharp.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.csharp\3.4.0\lib\netstandard2.0\tr\Microsoft.CodeAnalysis.CSharp.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"tr\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["RelativePath"] = @"tr\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "tr",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.CSharp",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"tr\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/tr/Microsoft.CodeAnalysis.CSharp.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.csharp\3.4.0\lib\netstandard2.0\zh-Hans\Microsoft.CodeAnalysis.CSharp.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"zh-Hans\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["RelativePath"] = @"zh-Hans\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "zh-Hans",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.CSharp",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"zh-Hans\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/zh-Hans/Microsoft.CodeAnalysis.CSharp.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.csharp\3.4.0\lib\netstandard2.0\zh-Hant\Microsoft.CodeAnalysis.CSharp.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"zh-Hant\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["RelativePath"] = @"zh-Hant\Microsoft.CodeAnalysis.CSharp.resources.dll",
                    ["NuGetPackageVersion"] = "3.4.0",
                    ["AssetType"] = "resources",
                    ["Culture"] = "zh-Hant",
                    ["NuGetPackageId"] = "Microsoft.CodeAnalysis.CSharp",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"zh-Hant\",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/zh-Hant/Microsoft.CodeAnalysis.CSharp.resources.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.configuration.abstractions\5.0.0\lib\netstandard2.0\Microsoft.Extensions.Configuration.Abstractions.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.Extensions.Configuration.Abstractions.dll",
                    ["RelativePath"] = @"Microsoft.Extensions.Configuration.Abstractions.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.Extensions.Configuration.Abstractions",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/Microsoft.Extensions.Configuration.Abstractions.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.configuration.binder\5.0.0\lib\netstandard2.0\Microsoft.Extensions.Configuration.Binder.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.Extensions.Configuration.Binder.dll",
                    ["RelativePath"] = @"Microsoft.Extensions.Configuration.Binder.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.Extensions.Configuration.Binder",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/Microsoft.Extensions.Configuration.Binder.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.configuration.fileextensions\5.0.0\lib\netstandard2.0\Microsoft.Extensions.Configuration.FileExtensions.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.Extensions.Configuration.FileExtensions.dll",
                    ["RelativePath"] = @"Microsoft.Extensions.Configuration.FileExtensions.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.Extensions.Configuration.FileExtensions",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/Microsoft.Extensions.Configuration.FileExtensions.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.configuration.json\5.0.0\lib\netstandard2.1\Microsoft.Extensions.Configuration.Json.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.Extensions.Configuration.Json.dll",
                    ["RelativePath"] = @"Microsoft.Extensions.Configuration.Json.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.Extensions.Configuration.Json",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.1/Microsoft.Extensions.Configuration.Json.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.configuration\5.0.0\lib\netstandard2.0\Microsoft.Extensions.Configuration.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.Extensions.Configuration.dll",
                    ["RelativePath"] = @"Microsoft.Extensions.Configuration.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.Extensions.Configuration",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/Microsoft.Extensions.Configuration.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.dependencyinjection.abstractions\5.0.0\lib\netstandard2.0\Microsoft.Extensions.DependencyInjection.Abstractions.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.Extensions.DependencyInjection.Abstractions.dll",
                    ["RelativePath"] = @"Microsoft.Extensions.DependencyInjection.Abstractions.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.Extensions.DependencyInjection.Abstractions",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/Microsoft.Extensions.DependencyInjection.Abstractions.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.dependencyinjection\5.0.0\lib\net5.0\Microsoft.Extensions.DependencyInjection.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.Extensions.DependencyInjection.dll",
                    ["RelativePath"] = @"Microsoft.Extensions.DependencyInjection.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.Extensions.DependencyInjection",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/net5.0/Microsoft.Extensions.DependencyInjection.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.fileproviders.abstractions\5.0.0\lib\netstandard2.0\Microsoft.Extensions.FileProviders.Abstractions.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.Extensions.FileProviders.Abstractions.dll",
                    ["RelativePath"] = @"Microsoft.Extensions.FileProviders.Abstractions.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.Extensions.FileProviders.Abstractions",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/Microsoft.Extensions.FileProviders.Abstractions.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.fileproviders.physical\5.0.0\lib\netstandard2.0\Microsoft.Extensions.FileProviders.Physical.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.Extensions.FileProviders.Physical.dll",
                    ["RelativePath"] = @"Microsoft.Extensions.FileProviders.Physical.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.Extensions.FileProviders.Physical",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/Microsoft.Extensions.FileProviders.Physical.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.filesystemglobbing\5.0.0\lib\netstandard2.0\Microsoft.Extensions.FileSystemGlobbing.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.Extensions.FileSystemGlobbing.dll",
                    ["RelativePath"] = @"Microsoft.Extensions.FileSystemGlobbing.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.Extensions.FileSystemGlobbing",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/Microsoft.Extensions.FileSystemGlobbing.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.logging.abstractions\5.0.0\lib\netstandard2.0\Microsoft.Extensions.Logging.Abstractions.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.Extensions.Logging.Abstractions.dll",
                    ["RelativePath"] = @"Microsoft.Extensions.Logging.Abstractions.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.Extensions.Logging.Abstractions",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.0/Microsoft.Extensions.Logging.Abstractions.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.logging\5.0.0\lib\netstandard2.1\Microsoft.Extensions.Logging.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.Extensions.Logging.dll",
                    ["RelativePath"] = @"Microsoft.Extensions.Logging.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.Extensions.Logging",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netstandard2.1/Microsoft.Extensions.Logging.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.options\5.0.0\lib\net5.0\Microsoft.Extensions.Options.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.Extensions.Options.dll",
                    ["RelativePath"] = @"Microsoft.Extensions.Options.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.Extensions.Options",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/net5.0/Microsoft.Extensions.Options.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.primitives\5.0.0\lib\netcoreapp3.0\Microsoft.Extensions.Primitives.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.Extensions.Primitives.dll",
                    ["RelativePath"] = @"Microsoft.Extensions.Primitives.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.Extensions.Primitives",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netcoreapp3.0/Microsoft.Extensions.Primitives.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.jsinterop.webassembly\5.0.0\lib\net5.0\Microsoft.JSInterop.WebAssembly.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.JSInterop.WebAssembly.dll",
                    ["RelativePath"] = @"Microsoft.JSInterop.WebAssembly.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.JSInterop.WebAssembly",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/net5.0/Microsoft.JSInterop.WebAssembly.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.jsinterop\5.0.0\lib\net5.0\Microsoft.JSInterop.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"Microsoft.JSInterop.dll",
                    ["RelativePath"] = @"Microsoft.JSInterop.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "Microsoft.JSInterop",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/net5.0/Microsoft.JSInterop.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\Microsoft.CSharp.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"Microsoft.CSharp.dll",
                    ["RelativePath"] = @"Microsoft.CSharp.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\Microsoft.VisualBasic.Core.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"Microsoft.VisualBasic.Core.dll",
                    ["RelativePath"] = @"Microsoft.VisualBasic.Core.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "11.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\Microsoft.VisualBasic.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"Microsoft.VisualBasic.dll",
                    ["RelativePath"] = @"Microsoft.VisualBasic.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "10.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\Microsoft.Win32.Primitives.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"Microsoft.Win32.Primitives.dll",
                    ["RelativePath"] = @"Microsoft.Win32.Primitives.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\Microsoft.Win32.Registry.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"Microsoft.Win32.Registry.dll",
                    ["RelativePath"] = @"Microsoft.Win32.Registry.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.AppContext.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.AppContext.dll",
                    ["RelativePath"] = @"System.AppContext.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Buffers.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Buffers.dll",
                    ["RelativePath"] = @"System.Buffers.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Collections.Concurrent.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Collections.Concurrent.dll",
                    ["RelativePath"] = @"System.Collections.Concurrent.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Collections.Immutable.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Collections.Immutable.dll",
                    ["RelativePath"] = @"System.Collections.Immutable.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Collections.NonGeneric.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Collections.NonGeneric.dll",
                    ["RelativePath"] = @"System.Collections.NonGeneric.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Collections.Specialized.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Collections.Specialized.dll",
                    ["RelativePath"] = @"System.Collections.Specialized.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Collections.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Collections.dll",
                    ["RelativePath"] = @"System.Collections.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ComponentModel.Annotations.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.ComponentModel.Annotations.dll",
                    ["RelativePath"] = @"System.ComponentModel.Annotations.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ComponentModel.DataAnnotations.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.ComponentModel.DataAnnotations.dll",
                    ["RelativePath"] = @"System.ComponentModel.DataAnnotations.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "31bf3856ad364e35",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ComponentModel.EventBasedAsync.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.ComponentModel.EventBasedAsync.dll",
                    ["RelativePath"] = @"System.ComponentModel.EventBasedAsync.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ComponentModel.Primitives.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.ComponentModel.Primitives.dll",
                    ["RelativePath"] = @"System.ComponentModel.Primitives.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ComponentModel.TypeConverter.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.ComponentModel.TypeConverter.dll",
                    ["RelativePath"] = @"System.ComponentModel.TypeConverter.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ComponentModel.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.ComponentModel.dll",
                    ["RelativePath"] = @"System.ComponentModel.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Configuration.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Configuration.dll",
                    ["RelativePath"] = @"System.Configuration.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Console.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Console.dll",
                    ["RelativePath"] = @"System.Console.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Core.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Core.dll",
                    ["RelativePath"] = @"System.Core.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b77a5c561934e089",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Data.Common.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Data.Common.dll",
                    ["RelativePath"] = @"System.Data.Common.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Data.DataSetExtensions.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Data.DataSetExtensions.dll",
                    ["RelativePath"] = @"System.Data.DataSetExtensions.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b77a5c561934e089",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Data.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Data.dll",
                    ["RelativePath"] = @"System.Data.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b77a5c561934e089",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.Contracts.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Diagnostics.Contracts.dll",
                    ["RelativePath"] = @"System.Diagnostics.Contracts.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.Debug.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Diagnostics.Debug.dll",
                    ["RelativePath"] = @"System.Diagnostics.Debug.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.DiagnosticSource.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Diagnostics.DiagnosticSource.dll",
                    ["RelativePath"] = @"System.Diagnostics.DiagnosticSource.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.FileVersionInfo.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Diagnostics.FileVersionInfo.dll",
                    ["RelativePath"] = @"System.Diagnostics.FileVersionInfo.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.Process.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Diagnostics.Process.dll",
                    ["RelativePath"] = @"System.Diagnostics.Process.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.StackTrace.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Diagnostics.StackTrace.dll",
                    ["RelativePath"] = @"System.Diagnostics.StackTrace.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.TextWriterTraceListener.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Diagnostics.TextWriterTraceListener.dll",
                    ["RelativePath"] = @"System.Diagnostics.TextWriterTraceListener.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.Tools.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Diagnostics.Tools.dll",
                    ["RelativePath"] = @"System.Diagnostics.Tools.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.TraceSource.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Diagnostics.TraceSource.dll",
                    ["RelativePath"] = @"System.Diagnostics.TraceSource.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.Tracing.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Diagnostics.Tracing.dll",
                    ["RelativePath"] = @"System.Diagnostics.Tracing.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Drawing.Primitives.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Drawing.Primitives.dll",
                    ["RelativePath"] = @"System.Drawing.Primitives.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Drawing.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Drawing.dll",
                    ["RelativePath"] = @"System.Drawing.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Dynamic.Runtime.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Dynamic.Runtime.dll",
                    ["RelativePath"] = @"System.Dynamic.Runtime.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Formats.Asn1.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Formats.Asn1.dll",
                    ["RelativePath"] = @"System.Formats.Asn1.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Globalization.Calendars.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Globalization.Calendars.dll",
                    ["RelativePath"] = @"System.Globalization.Calendars.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Globalization.Extensions.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Globalization.Extensions.dll",
                    ["RelativePath"] = @"System.Globalization.Extensions.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Globalization.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Globalization.dll",
                    ["RelativePath"] = @"System.Globalization.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.Compression.Brotli.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.IO.Compression.Brotli.dll",
                    ["RelativePath"] = @"System.IO.Compression.Brotli.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b77a5c561934e089",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.Compression.FileSystem.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.IO.Compression.FileSystem.dll",
                    ["RelativePath"] = @"System.IO.Compression.FileSystem.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b77a5c561934e089",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.Compression.ZipFile.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.IO.Compression.ZipFile.dll",
                    ["RelativePath"] = @"System.IO.Compression.ZipFile.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b77a5c561934e089",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.Compression.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.IO.Compression.dll",
                    ["RelativePath"] = @"System.IO.Compression.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b77a5c561934e089",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.FileSystem.AccessControl.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.IO.FileSystem.AccessControl.dll",
                    ["RelativePath"] = @"System.IO.FileSystem.AccessControl.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.FileSystem.DriveInfo.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.IO.FileSystem.DriveInfo.dll",
                    ["RelativePath"] = @"System.IO.FileSystem.DriveInfo.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.FileSystem.Primitives.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.IO.FileSystem.Primitives.dll",
                    ["RelativePath"] = @"System.IO.FileSystem.Primitives.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.FileSystem.Watcher.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.IO.FileSystem.Watcher.dll",
                    ["RelativePath"] = @"System.IO.FileSystem.Watcher.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.FileSystem.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.IO.FileSystem.dll",
                    ["RelativePath"] = @"System.IO.FileSystem.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.IsolatedStorage.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.IO.IsolatedStorage.dll",
                    ["RelativePath"] = @"System.IO.IsolatedStorage.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.MemoryMappedFiles.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.IO.MemoryMappedFiles.dll",
                    ["RelativePath"] = @"System.IO.MemoryMappedFiles.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.Pipes.AccessControl.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.IO.Pipes.AccessControl.dll",
                    ["RelativePath"] = @"System.IO.Pipes.AccessControl.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.Pipes.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.IO.Pipes.dll",
                    ["RelativePath"] = @"System.IO.Pipes.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.UnmanagedMemoryStream.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.IO.UnmanagedMemoryStream.dll",
                    ["RelativePath"] = @"System.IO.UnmanagedMemoryStream.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.IO.dll",
                    ["RelativePath"] = @"System.IO.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Linq.Expressions.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Linq.Expressions.dll",
                    ["RelativePath"] = @"System.Linq.Expressions.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Linq.Parallel.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Linq.Parallel.dll",
                    ["RelativePath"] = @"System.Linq.Parallel.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Linq.Queryable.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Linq.Queryable.dll",
                    ["RelativePath"] = @"System.Linq.Queryable.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Linq.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Linq.dll",
                    ["RelativePath"] = @"System.Linq.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Memory.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Memory.dll",
                    ["RelativePath"] = @"System.Memory.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Http.Json.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.Http.Json.dll",
                    ["RelativePath"] = @"System.Net.Http.Json.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Http.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.Http.dll",
                    ["RelativePath"] = @"System.Net.Http.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.HttpListener.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.HttpListener.dll",
                    ["RelativePath"] = @"System.Net.HttpListener.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Mail.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.Mail.dll",
                    ["RelativePath"] = @"System.Net.Mail.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.NameResolution.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.NameResolution.dll",
                    ["RelativePath"] = @"System.Net.NameResolution.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.NetworkInformation.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.NetworkInformation.dll",
                    ["RelativePath"] = @"System.Net.NetworkInformation.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Ping.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.Ping.dll",
                    ["RelativePath"] = @"System.Net.Ping.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Primitives.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.Primitives.dll",
                    ["RelativePath"] = @"System.Net.Primitives.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Quic.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.Quic.dll",
                    ["RelativePath"] = @"System.Net.Quic.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Requests.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.Requests.dll",
                    ["RelativePath"] = @"System.Net.Requests.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Security.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.Security.dll",
                    ["RelativePath"] = @"System.Net.Security.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.ServicePoint.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.ServicePoint.dll",
                    ["RelativePath"] = @"System.Net.ServicePoint.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Sockets.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.Sockets.dll",
                    ["RelativePath"] = @"System.Net.Sockets.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.WebClient.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.WebClient.dll",
                    ["RelativePath"] = @"System.Net.WebClient.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.WebHeaderCollection.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.WebHeaderCollection.dll",
                    ["RelativePath"] = @"System.Net.WebHeaderCollection.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.WebProxy.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.WebProxy.dll",
                    ["RelativePath"] = @"System.Net.WebProxy.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.WebSockets.Client.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.WebSockets.Client.dll",
                    ["RelativePath"] = @"System.Net.WebSockets.Client.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.WebSockets.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.WebSockets.dll",
                    ["RelativePath"] = @"System.Net.WebSockets.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Net.dll",
                    ["RelativePath"] = @"System.Net.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Numerics.Vectors.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Numerics.Vectors.dll",
                    ["RelativePath"] = @"System.Numerics.Vectors.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Numerics.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Numerics.dll",
                    ["RelativePath"] = @"System.Numerics.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b77a5c561934e089",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ObjectModel.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.ObjectModel.dll",
                    ["RelativePath"] = @"System.ObjectModel.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Private.DataContractSerialization.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Private.DataContractSerialization.dll",
                    ["RelativePath"] = @"System.Private.DataContractSerialization.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Private.Runtime.InteropServices.JavaScript.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Private.Runtime.InteropServices.JavaScript.dll",
                    ["RelativePath"] = @"System.Private.Runtime.InteropServices.JavaScript.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Private.Uri.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Private.Uri.dll",
                    ["RelativePath"] = @"System.Private.Uri.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Private.Xml.Linq.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Private.Xml.Linq.dll",
                    ["RelativePath"] = @"System.Private.Xml.Linq.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Private.Xml.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Private.Xml.dll",
                    ["RelativePath"] = @"System.Private.Xml.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.DispatchProxy.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Reflection.DispatchProxy.dll",
                    ["RelativePath"] = @"System.Reflection.DispatchProxy.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.Emit.ILGeneration.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Reflection.Emit.ILGeneration.dll",
                    ["RelativePath"] = @"System.Reflection.Emit.ILGeneration.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.Emit.Lightweight.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Reflection.Emit.Lightweight.dll",
                    ["RelativePath"] = @"System.Reflection.Emit.Lightweight.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.Emit.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Reflection.Emit.dll",
                    ["RelativePath"] = @"System.Reflection.Emit.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.Extensions.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Reflection.Extensions.dll",
                    ["RelativePath"] = @"System.Reflection.Extensions.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.Metadata.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Reflection.Metadata.dll",
                    ["RelativePath"] = @"System.Reflection.Metadata.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.Primitives.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Reflection.Primitives.dll",
                    ["RelativePath"] = @"System.Reflection.Primitives.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.TypeExtensions.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Reflection.TypeExtensions.dll",
                    ["RelativePath"] = @"System.Reflection.TypeExtensions.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Reflection.dll",
                    ["RelativePath"] = @"System.Reflection.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Resources.Reader.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Resources.Reader.dll",
                    ["RelativePath"] = @"System.Resources.Reader.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Resources.ResourceManager.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Resources.ResourceManager.dll",
                    ["RelativePath"] = @"System.Resources.ResourceManager.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Resources.Writer.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Resources.Writer.dll",
                    ["RelativePath"] = @"System.Resources.Writer.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.CompilerServices.Unsafe.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Runtime.CompilerServices.Unsafe.dll",
                    ["RelativePath"] = @"System.Runtime.CompilerServices.Unsafe.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.CompilerServices.VisualC.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Runtime.CompilerServices.VisualC.dll",
                    ["RelativePath"] = @"System.Runtime.CompilerServices.VisualC.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Extensions.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Runtime.Extensions.dll",
                    ["RelativePath"] = @"System.Runtime.Extensions.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Handles.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Runtime.Handles.dll",
                    ["RelativePath"] = @"System.Runtime.Handles.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.InteropServices.RuntimeInformation.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Runtime.InteropServices.RuntimeInformation.dll",
                    ["RelativePath"] = @"System.Runtime.InteropServices.RuntimeInformation.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.InteropServices.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Runtime.InteropServices.dll",
                    ["RelativePath"] = @"System.Runtime.InteropServices.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Intrinsics.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Runtime.Intrinsics.dll",
                    ["RelativePath"] = @"System.Runtime.Intrinsics.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Loader.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Runtime.Loader.dll",
                    ["RelativePath"] = @"System.Runtime.Loader.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Numerics.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Runtime.Numerics.dll",
                    ["RelativePath"] = @"System.Runtime.Numerics.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Serialization.Formatters.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Runtime.Serialization.Formatters.dll",
                    ["RelativePath"] = @"System.Runtime.Serialization.Formatters.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Serialization.Json.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Runtime.Serialization.Json.dll",
                    ["RelativePath"] = @"System.Runtime.Serialization.Json.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Serialization.Primitives.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Runtime.Serialization.Primitives.dll",
                    ["RelativePath"] = @"System.Runtime.Serialization.Primitives.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Serialization.Xml.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Runtime.Serialization.Xml.dll",
                    ["RelativePath"] = @"System.Runtime.Serialization.Xml.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.Serialization.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Runtime.Serialization.dll",
                    ["RelativePath"] = @"System.Runtime.Serialization.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b77a5c561934e089",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Runtime.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Runtime.dll",
                    ["RelativePath"] = @"System.Runtime.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.AccessControl.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Security.AccessControl.dll",
                    ["RelativePath"] = @"System.Security.AccessControl.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Claims.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Security.Claims.dll",
                    ["RelativePath"] = @"System.Security.Claims.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Cryptography.Algorithms.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Security.Cryptography.Algorithms.dll",
                    ["RelativePath"] = @"System.Security.Cryptography.Algorithms.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Cryptography.Cng.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Security.Cryptography.Cng.dll",
                    ["RelativePath"] = @"System.Security.Cryptography.Cng.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Cryptography.Csp.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Security.Cryptography.Csp.dll",
                    ["RelativePath"] = @"System.Security.Cryptography.Csp.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Cryptography.Encoding.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Security.Cryptography.Encoding.dll",
                    ["RelativePath"] = @"System.Security.Cryptography.Encoding.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Cryptography.OpenSsl.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Security.Cryptography.OpenSsl.dll",
                    ["RelativePath"] = @"System.Security.Cryptography.OpenSsl.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Cryptography.Primitives.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Security.Cryptography.Primitives.dll",
                    ["RelativePath"] = @"System.Security.Cryptography.Primitives.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Cryptography.X509Certificates.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Security.Cryptography.X509Certificates.dll",
                    ["RelativePath"] = @"System.Security.Cryptography.X509Certificates.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Principal.Windows.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Security.Principal.Windows.dll",
                    ["RelativePath"] = @"System.Security.Principal.Windows.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.Principal.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Security.Principal.dll",
                    ["RelativePath"] = @"System.Security.Principal.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.SecureString.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Security.SecureString.dll",
                    ["RelativePath"] = @"System.Security.SecureString.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Security.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Security.dll",
                    ["RelativePath"] = @"System.Security.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ServiceModel.Web.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.ServiceModel.Web.dll",
                    ["RelativePath"] = @"System.ServiceModel.Web.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "31bf3856ad364e35",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ServiceProcess.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.ServiceProcess.dll",
                    ["RelativePath"] = @"System.ServiceProcess.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Text.Encoding.CodePages.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Text.Encoding.CodePages.dll",
                    ["RelativePath"] = @"System.Text.Encoding.CodePages.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Text.Encoding.Extensions.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Text.Encoding.Extensions.dll",
                    ["RelativePath"] = @"System.Text.Encoding.Extensions.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Text.Encoding.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Text.Encoding.dll",
                    ["RelativePath"] = @"System.Text.Encoding.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Text.Encodings.Web.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Text.Encodings.Web.dll",
                    ["RelativePath"] = @"System.Text.Encodings.Web.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Text.Json.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Text.Json.dll",
                    ["RelativePath"] = @"System.Text.Json.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Text.RegularExpressions.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Text.RegularExpressions.dll",
                    ["RelativePath"] = @"System.Text.RegularExpressions.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.Channels.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Threading.Channels.dll",
                    ["RelativePath"] = @"System.Threading.Channels.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.Overlapped.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Threading.Overlapped.dll",
                    ["RelativePath"] = @"System.Threading.Overlapped.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.Tasks.Dataflow.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Threading.Tasks.Dataflow.dll",
                    ["RelativePath"] = @"System.Threading.Tasks.Dataflow.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.Tasks.Extensions.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Threading.Tasks.Extensions.dll",
                    ["RelativePath"] = @"System.Threading.Tasks.Extensions.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.Tasks.Parallel.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Threading.Tasks.Parallel.dll",
                    ["RelativePath"] = @"System.Threading.Tasks.Parallel.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.Tasks.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Threading.Tasks.dll",
                    ["RelativePath"] = @"System.Threading.Tasks.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.Thread.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Threading.Thread.dll",
                    ["RelativePath"] = @"System.Threading.Thread.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.ThreadPool.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Threading.ThreadPool.dll",
                    ["RelativePath"] = @"System.Threading.ThreadPool.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.Timer.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Threading.Timer.dll",
                    ["RelativePath"] = @"System.Threading.Timer.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Threading.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Threading.dll",
                    ["RelativePath"] = @"System.Threading.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Transactions.Local.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Transactions.Local.dll",
                    ["RelativePath"] = @"System.Transactions.Local.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Transactions.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Transactions.dll",
                    ["RelativePath"] = @"System.Transactions.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b77a5c561934e089",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ValueTuple.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.ValueTuple.dll",
                    ["RelativePath"] = @"System.ValueTuple.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Web.HttpUtility.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Web.HttpUtility.dll",
                    ["RelativePath"] = @"System.Web.HttpUtility.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Web.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Web.dll",
                    ["RelativePath"] = @"System.Web.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Windows.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Windows.dll",
                    ["RelativePath"] = @"System.Windows.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Xml.Linq.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Xml.Linq.dll",
                    ["RelativePath"] = @"System.Xml.Linq.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b77a5c561934e089",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Xml.ReaderWriter.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Xml.ReaderWriter.dll",
                    ["RelativePath"] = @"System.Xml.ReaderWriter.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Xml.Serialization.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Xml.Serialization.dll",
                    ["RelativePath"] = @"System.Xml.Serialization.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b77a5c561934e089",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Xml.XDocument.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Xml.XDocument.dll",
                    ["RelativePath"] = @"System.Xml.XDocument.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Xml.XPath.XDocument.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Xml.XPath.XDocument.dll",
                    ["RelativePath"] = @"System.Xml.XPath.XDocument.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Xml.XPath.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Xml.XPath.dll",
                    ["RelativePath"] = @"System.Xml.XPath.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Xml.XmlDocument.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Xml.XmlDocument.dll",
                    ["RelativePath"] = @"System.Xml.XmlDocument.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Xml.XmlSerializer.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Xml.XmlSerializer.dll",
                    ["RelativePath"] = @"System.Xml.XmlSerializer.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b03f5f7f11d50a3a",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Xml.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Xml.dll",
                    ["RelativePath"] = @"System.Xml.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b77a5c561934e089",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.dll",
                    ["RelativePath"] = @"System.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b77a5c561934e089",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\WindowsBase.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"WindowsBase.dll",
                    ["RelativePath"] = @"WindowsBase.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "31bf3856ad364e35",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\mscorlib.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"mscorlib.dll",
                    ["RelativePath"] = @"mscorlib.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "b77a5c561934e089",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "4.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\netstandard.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"netstandard.dll",
                    ["RelativePath"] = @"netstandard.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "cc7b13ffcd2ddd51",
                    ["AssetType"] = "runtime",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "2.1.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\System.Private.CoreLib.dll", new Dictionary<string, string>{
                    ["FileVersion"] = "6.0.21.32401",
                    ["DestinationSubPath"] = @"System.Private.CoreLib.dll",
                    ["RelativePath"] = @"System.Private.CoreLib.dll",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "7cec85d7bea7798e",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "6.0.0.0",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\dotnet.js", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"dotnet.js",
                    ["RelativePath"] = @"dotnet.js",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\dotnet.timezones.blat", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"dotnet.timezones.blat",
                    ["RelativePath"] = @"dotnet.timezones.blat",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\dotnet.wasm", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"dotnet.wasm",
                    ["RelativePath"] = @"dotnet.wasm",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\icudt.dat", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"icudt.dat",
                    ["RelativePath"] = @"icudt.dat",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\icudt_CJK.dat", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"icudt_CJK.dat",
                    ["RelativePath"] = @"icudt_CJK.dat",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\icudt_EFIGS.dat", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"icudt_EFIGS.dat",
                    ["RelativePath"] = @"icudt_EFIGS.dat",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\icudt_no_CJK.dat", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"icudt_no_CJK.dat",
                    ["RelativePath"] = @"icudt_no_CJK.dat",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\include\wasm\pinvoke.h", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"pinvoke.h",
                    ["RelativePath"] = @"pinvoke.h",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libSystem.IO.Compression.Native.a", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"libSystem.IO.Compression.Native.a",
                    ["RelativePath"] = @"libSystem.IO.Compression.Native.a",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libSystem.Native.a", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"libSystem.Native.a",
                    ["RelativePath"] = @"libSystem.Native.a",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libicui18n.a", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"libicui18n.a",
                    ["RelativePath"] = @"libicui18n.a",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libicuuc.a", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"libicuuc.a",
                    ["RelativePath"] = @"libicuuc.a",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libmono-component-diagnostics_tracing-static.a", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"libmono-component-diagnostics_tracing-static.a",
                    ["RelativePath"] = @"libmono-component-diagnostics_tracing-static.a",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libmono-component-diagnostics_tracing-stub-static.a", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"libmono-component-diagnostics_tracing-stub-static.a",
                    ["RelativePath"] = @"libmono-component-diagnostics_tracing-stub-static.a",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libmono-component-hot_reload-static.a", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"libmono-component-hot_reload-static.a",
                    ["RelativePath"] = @"libmono-component-hot_reload-static.a",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libmono-component-hot_reload-stub-static.a", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"libmono-component-hot_reload-stub-static.a",
                    ["RelativePath"] = @"libmono-component-hot_reload-stub-static.a",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libmono-ee-interp.a", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"libmono-ee-interp.a",
                    ["RelativePath"] = @"libmono-ee-interp.a",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libmono-icall-table.a", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"libmono-icall-table.a",
                    ["RelativePath"] = @"libmono-icall-table.a",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libmono-ilgen.a", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"libmono-ilgen.a",
                    ["RelativePath"] = @"libmono-ilgen.a",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libmono-profiler-aot.a", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"libmono-profiler-aot.a",
                    ["RelativePath"] = @"libmono-profiler-aot.a",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\libmonosgen-2.0.a", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"libmonosgen-2.0.a",
                    ["RelativePath"] = @"libmonosgen-2.0.a",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\src\Emcc.props", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"Emcc.props",
                    ["RelativePath"] = @"Emcc.props",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\src\binding_support.js", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"binding_support.js",
                    ["RelativePath"] = @"binding_support.js",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\src\corebindings.c", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"corebindings.c",
                    ["RelativePath"] = @"corebindings.c",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\src\dotnet_support.js", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"dotnet_support.js",
                    ["RelativePath"] = @"dotnet_support.js",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\src\driver.c", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"driver.c",
                    ["RelativePath"] = @"driver.c",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\src\emcc-default.rsp", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"emcc-default.rsp",
                    ["RelativePath"] = @"emcc-default.rsp",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\src\library_mono.js", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"library_mono.js",
                    ["RelativePath"] = @"library_mono.js",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\src\pal_random.js", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"pal_random.js",
                    ["RelativePath"] = @"pal_random.js",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\src\pinvoke.c", new Dictionary<string, string>{
                    ["FileVersion"] = "0.0.0.0",
                    ["DestinationSubPath"] = @"pinvoke.c",
                    ["RelativePath"] = @"pinvoke.c",
                    ["NuGetPackageVersion"] = "6.0.0-preview.7.21324.1",
                    ["PublicKeyToken"] = "",
                    ["AssetType"] = "native",
                    ["RuntimeIdentifier"] = "browser-wasm",
                    ["NuGetPackageId"] = "Microsoft.NETCore.App.Runtime.Mono.browser-wasm",
                    ["DropFromSingleFile"] = "true",
                    ["IsTrimmable"] = "",
                    ["AssemblyVersion"] = "",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\.nuget\packages\system.io.pipelines\5.0.0\lib\netcoreapp3.0\System.IO.Pipelines.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"System.IO.Pipelines.dll",
                    ["RelativePath"] = @"System.IO.Pipelines.dll",
                    ["NuGetPackageVersion"] = "5.0.0",
                    ["AssetType"] = "runtime",
                    ["NuGetPackageId"] = "System.IO.Pipelines",
                    ["CopyLocal"] = "true",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                    ["PathInPackage"] = "lib/netcoreapp3.0/System.IO.Pipelines.dll",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---A104416B\classlibrarywithsatelliteassemblies\bin\Debug\netstandard2.1\classlibrarywithsatelliteassemblies.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"classlibrarywithsatelliteassemblies.dll",
                    ["ReferenceSourceTarget"] = "ProjectReference",
                    ["RelativePath"] = @"classlibrarywithsatelliteassemblies.dll",
                    ["MSBuildSourceProjectFile"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---A104416B\classlibrarywithsatelliteassemblies\classlibrarywithsatelliteassemblies.csproj",
                    ["HasSingleTargetFramework"] = "true",
                    ["TargetFrameworkIdentifier"] = ".NETStandard",
                    ["ReferenceOutputAssembly"] = "true",
                    ["Version"] = "",
                    ["OutputItemType"] = "",
                    ["TargetPlatformMonikers"] = "Windows,Version=7.0",
                    ["TargetPlatformMoniker"] = "Windows,Version=7.0",
                    ["ProjectReferenceOriginalItemSpec"] = @"..\classlibrarywithsatelliteassemblies\classlibrarywithsatelliteassemblies.csproj",
                    ["BuildReference"] = "true",
                    ["CopyUpToDateMarker"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---A104416B\classlibrarywithsatelliteassemblies\obj\Debug\netstandard2.1\classlibrarywithsatelliteassemblies.csproj.CopyComplete",
                    ["TargetFrameworkMonikers"] = ".NETStandard,Version=v2.1",
                    ["TargetFrameworks"] = "netstandard2.1",
                    ["IsRidAgnostic"] = "true",
                    ["MSBuildSourceTargetName"] = "GetTargetFrameworks",
                    ["ResolvedFrom"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---A104416B\classlibrarywithsatelliteassemblies\bin\Debug\netstandard2.1\classlibrarywithsatelliteassemblies.dll",
                    ["NearestTargetFramework"] = "netstandard2.1",
                    ["UndefineProperties"] = ";TargetFramework;RuntimeIdentifier",
                    ["GlobalPropertiesToRemove"] = ";WebPublishProfileFile",
                    ["OriginalProjectReferenceItemSpec"] = @"..\classlibrarywithsatelliteassemblies\classlibrarywithsatelliteassemblies.csproj",
                    ["ImageRuntime"] = "v4.0.30319",
                    ["TargetPlatformIdentifier"] = "Windows",
                    ["TargetFrameworkVersion"] = "2.1",
                    ["Targets"] = "",
                    ["CopyLocal"] = "true",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---A104416B\classlibrarywithsatelliteassemblies\bin\Debug\netstandard2.1\classlibrarywithsatelliteassemblies.dll",
                    ["FusionName"] = "classlibrarywithsatelliteassemblies, Version=1.0.0.0, Culture=neutral, PublicKeyToken=null",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---A104416B\classlibrarywithsatelliteassemblies\bin\Debug\netstandard2.1\es-ES\classlibrarywithsatelliteassemblies.resources.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"es-ES\classlibrarywithsatelliteassemblies.resources.dll",
                    ["ReferenceSourceTarget"] = "ProjectReference",
                    ["RelativePath"] = @"es-ES\classlibrarywithsatelliteassemblies.resources.dll",
                    ["MSBuildSourceProjectFile"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---A104416B\classlibrarywithsatelliteassemblies\classlibrarywithsatelliteassemblies.csproj",
                    ["HasSingleTargetFramework"] = "true",
                    ["TargetFrameworkIdentifier"] = ".NETStandard",
                    ["ReferenceOutputAssembly"] = "true",
                    ["Version"] = "",
                    ["OutputItemType"] = "",
                    ["TargetPlatformMonikers"] = "Windows,Version=7.0",
                    ["TargetPlatformMoniker"] = "Windows,Version=7.0",
                    ["BuildReference"] = "true",
                    ["CopyUpToDateMarker"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---A104416B\classlibrarywithsatelliteassemblies\obj\Debug\netstandard2.1\classlibrarywithsatelliteassemblies.csproj.CopyComplete",
                    ["TargetFrameworkMonikers"] = ".NETStandard,Version=v2.1",
                    ["TargetFrameworks"] = "netstandard2.1",
                    ["IsRidAgnostic"] = "true",
                    ["MSBuildSourceTargetName"] = "GetTargetFrameworks",
                    ["ResolvedFrom"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---A104416B\classlibrarywithsatelliteassemblies\bin\Debug\netstandard2.1\classlibrarywithsatelliteassemblies.dll",
                    ["NearestTargetFramework"] = "netstandard2.1",
                    ["UndefineProperties"] = ";TargetFramework;RuntimeIdentifier",
                    ["GlobalPropertiesToRemove"] = ";WebPublishProfileFile",
                    ["OriginalProjectReferenceItemSpec"] = @"..\classlibrarywithsatelliteassemblies\classlibrarywithsatelliteassemblies.csproj",
                    ["TargetPlatformIdentifier"] = "Windows",
                    ["TargetFrameworkVersion"] = "2.1",
                    ["Targets"] = "",
                    ["CopyLocal"] = "true",
                    ["DestinationSubDirectory"] = @"es-ES\",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---A104416B\classlibrarywithsatelliteassemblies\bin\Debug\netstandard2.1\classlibrarywithsatelliteassemblies.dll",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---A104416B\razorclasslibrary\bin\Debug\netstandard2.1\RazorClassLibrary.dll", new Dictionary<string, string>{
                    ["DestinationSubPath"] = @"RazorClassLibrary.dll",
                    ["ReferenceSourceTarget"] = "ProjectReference",
                    ["RelativePath"] = @"RazorClassLibrary.dll",
                    ["MSBuildSourceProjectFile"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---A104416B\razorclasslibrary\RazorClassLibrary.csproj",
                    ["HasSingleTargetFramework"] = "true",
                    ["TargetFrameworkIdentifier"] = ".NETStandard",
                    ["ReferenceOutputAssembly"] = "true",
                    ["Version"] = "",
                    ["OutputItemType"] = "",
                    ["TargetPlatformMonikers"] = "Windows,Version=7.0",
                    ["TargetPlatformMoniker"] = "Windows,Version=7.0",
                    ["ProjectReferenceOriginalItemSpec"] = @"..\razorclasslibrary\RazorClassLibrary.csproj",
                    ["BuildReference"] = "true",
                    ["CopyUpToDateMarker"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---A104416B\razorclasslibrary\obj\Debug\netstandard2.1\RazorClassLibrary.csproj.CopyComplete",
                    ["TargetFrameworkMonikers"] = ".NETStandard,Version=v2.1",
                    ["TargetFrameworks"] = "netstandard2.1",
                    ["IsRidAgnostic"] = "true",
                    ["MSBuildSourceTargetName"] = "GetTargetFrameworks",
                    ["ResolvedFrom"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---A104416B\razorclasslibrary\bin\Debug\netstandard2.1\RazorClassLibrary.dll",
                    ["NearestTargetFramework"] = "netstandard2.1",
                    ["UndefineProperties"] = ";TargetFramework;RuntimeIdentifier",
                    ["GlobalPropertiesToRemove"] = ";WebPublishProfileFile",
                    ["OriginalProjectReferenceItemSpec"] = @"..\razorclasslibrary\RazorClassLibrary.csproj",
                    ["ImageRuntime"] = "v4.0.30319",
                    ["TargetPlatformIdentifier"] = "Windows",
                    ["TargetFrameworkVersion"] = "2.1",
                    ["Targets"] = "",
                    ["CopyLocal"] = "true",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---A104416B\razorclasslibrary\bin\Debug\netstandard2.1\RazorClassLibrary.dll",
                    ["FusionName"] = "RazorClassLibrary, Version=1.0.0.0, Culture=neutral, PublicKeyToken=null",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"obj\Debug\net6.0\blazorwasm.dll", new Dictionary<string,string>{
                    ["RelativePath"] = @"blazorwasm.dll",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
            };
        }

        private ITaskItem[] CreateExistingAssets()
        {
            return new TaskItem[]
            {
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\blazor.boot.json", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/blazor.boot.json",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "manifest",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"obj\Debug\net6.0\blazor.boot.json",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\blazor.webassembly.js", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/blazor.webassembly.js",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "All",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "boot",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.components.webassembly\5.0.0\build\net5.0\blazor.webassembly.js",
                    ["CopyToPublishDirectory"] = "PreserveNewest",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\blazorwasm.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/blazorwasm.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"obj\Debug\net6.0\blazorwasm.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\blazorwasm.pdb", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/blazorwasm.pdb",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "symbol",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"obj\Debug\net6.0\blazorwasm.pdb",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\classlibrarywithsatelliteassemblies.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/classlibrarywithsatelliteassemblies.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\classlibrarywithsatelliteassemblies\bin\Debug\netstandard2.1\classlibrarywithsatelliteassemblies.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\classlibrarywithsatelliteassemblies.pdb", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/classlibrarywithsatelliteassemblies.pdb",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "symbol",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\classlibrarywithsatelliteassemblies\bin\Debug\netstandard2.1\classlibrarywithsatelliteassemblies.pdb",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\dotnet.timezones.blat", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/dotnet.timezones.blat",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "native",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\dotnet.timezones.blat",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\dotnet.wasm", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/dotnet.wasm",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "native",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\dotnet.wasm",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\icudt_CJK.dat", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/icudt_CJK.dat",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "native",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\icudt_CJK.dat",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\icudt_EFIGS.dat", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/icudt_EFIGS.dat",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "native",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\icudt_EFIGS.dat",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\icudt_no_CJK.dat", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/icudt_no_CJK.dat",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "native",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\icudt_no_CJK.dat",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\icudt.dat", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/icudt.dat",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "native",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\icudt.dat",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Authorization.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.AspNetCore.Authorization.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.authorization\5.0.0\lib\net5.0\Microsoft.AspNetCore.Authorization.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Components.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.AspNetCore.Components.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.components\5.0.0\lib\net5.0\Microsoft.AspNetCore.Components.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Components.Forms.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.AspNetCore.Components.Forms.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.components.forms\5.0.0\lib\net5.0\Microsoft.AspNetCore.Components.Forms.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Components.Web.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.AspNetCore.Components.Web.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.components.web\5.0.0\lib\net5.0\Microsoft.AspNetCore.Components.Web.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Components.WebAssembly.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.AspNetCore.Components.WebAssembly.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.components.webassembly\5.0.0\lib\net5.0\Microsoft.AspNetCore.Components.WebAssembly.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.AspNetCore.Metadata.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.AspNetCore.Metadata.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.aspnetcore.metadata\5.0.0\lib\net5.0\Microsoft.AspNetCore.Metadata.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.CodeAnalysis.CSharp.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.CodeAnalysis.CSharp.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.csharp\3.4.0\lib\netstandard2.0\Microsoft.CodeAnalysis.CSharp.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.CodeAnalysis.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.CodeAnalysis.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.codeanalysis.common\3.4.0\lib\netstandard2.0\Microsoft.CodeAnalysis.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.CSharp.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.CSharp.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\Microsoft.CSharp.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.Abstractions.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.Extensions.Configuration.Abstractions.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.configuration.abstractions\5.0.0\lib\netstandard2.0\Microsoft.Extensions.Configuration.Abstractions.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.Binder.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.Extensions.Configuration.Binder.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.configuration.binder\5.0.0\lib\netstandard2.0\Microsoft.Extensions.Configuration.Binder.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.Extensions.Configuration.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.configuration\5.0.0\lib\netstandard2.0\Microsoft.Extensions.Configuration.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.FileExtensions.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.Extensions.Configuration.FileExtensions.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.configuration.fileextensions\5.0.0\lib\netstandard2.0\Microsoft.Extensions.Configuration.FileExtensions.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Configuration.Json.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.Extensions.Configuration.Json.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.configuration.json\5.0.0\lib\netstandard2.1\Microsoft.Extensions.Configuration.Json.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.DependencyInjection.Abstractions.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.Extensions.DependencyInjection.Abstractions.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.dependencyinjection.abstractions\5.0.0\lib\netstandard2.0\Microsoft.Extensions.DependencyInjection.Abstractions.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.DependencyInjection.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.Extensions.DependencyInjection.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.dependencyinjection\5.0.0\lib\net5.0\Microsoft.Extensions.DependencyInjection.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.FileProviders.Abstractions.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.Extensions.FileProviders.Abstractions.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.fileproviders.abstractions\5.0.0\lib\netstandard2.0\Microsoft.Extensions.FileProviders.Abstractions.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.FileProviders.Physical.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.Extensions.FileProviders.Physical.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.fileproviders.physical\5.0.0\lib\netstandard2.0\Microsoft.Extensions.FileProviders.Physical.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.FileSystemGlobbing.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.Extensions.FileSystemGlobbing.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.filesystemglobbing\5.0.0\lib\netstandard2.0\Microsoft.Extensions.FileSystemGlobbing.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Logging.Abstractions.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.Extensions.Logging.Abstractions.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.logging.abstractions\5.0.0\lib\netstandard2.0\Microsoft.Extensions.Logging.Abstractions.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Logging.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.Extensions.Logging.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.logging\5.0.0\lib\netstandard2.1\Microsoft.Extensions.Logging.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Options.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.Extensions.Options.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.options\5.0.0\lib\net5.0\Microsoft.Extensions.Options.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Extensions.Primitives.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.Extensions.Primitives.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.extensions.primitives\5.0.0\lib\netcoreapp3.0\Microsoft.Extensions.Primitives.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.JSInterop.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.JSInterop.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.jsinterop\5.0.0\lib\net5.0\Microsoft.JSInterop.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.JSInterop.WebAssembly.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.JSInterop.WebAssembly.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.jsinterop.webassembly\5.0.0\lib\net5.0\Microsoft.JSInterop.WebAssembly.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.VisualBasic.Core.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.VisualBasic.Core.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\Microsoft.VisualBasic.Core.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.VisualBasic.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.VisualBasic.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\Microsoft.VisualBasic.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Win32.Primitives.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.Win32.Primitives.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\Microsoft.Win32.Primitives.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\Microsoft.Win32.Registry.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/Microsoft.Win32.Registry.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\Microsoft.Win32.Registry.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\mscorlib.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/mscorlib.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\mscorlib.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\netstandard.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/netstandard.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\netstandard.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\RazorClassLibrary.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/RazorClassLibrary.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\razorclasslibrary\bin\Debug\netstandard2.1\RazorClassLibrary.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\RazorClassLibrary.pdb", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/RazorClassLibrary.pdb",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "symbol",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\razorclasslibrary\bin\Debug\netstandard2.1\RazorClassLibrary.pdb",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.AppContext.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.AppContext.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.AppContext.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Buffers.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Buffers.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Buffers.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.Concurrent.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Collections.Concurrent.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Collections.Concurrent.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Collections.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Collections.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.Immutable.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Collections.Immutable.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Collections.Immutable.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.NonGeneric.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Collections.NonGeneric.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Collections.NonGeneric.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Collections.Specialized.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Collections.Specialized.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Collections.Specialized.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.Annotations.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.ComponentModel.Annotations.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ComponentModel.Annotations.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.DataAnnotations.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.ComponentModel.DataAnnotations.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ComponentModel.DataAnnotations.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.ComponentModel.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ComponentModel.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.EventBasedAsync.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.ComponentModel.EventBasedAsync.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ComponentModel.EventBasedAsync.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.Primitives.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.ComponentModel.Primitives.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ComponentModel.Primitives.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ComponentModel.TypeConverter.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.ComponentModel.TypeConverter.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ComponentModel.TypeConverter.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Configuration.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Configuration.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Configuration.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Console.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Console.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Console.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Core.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Core.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Core.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Data.Common.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Data.Common.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Data.Common.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Data.DataSetExtensions.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Data.DataSetExtensions.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Data.DataSetExtensions.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Data.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Data.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Data.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Contracts.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Diagnostics.Contracts.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.Contracts.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Debug.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Diagnostics.Debug.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.Debug.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.DiagnosticSource.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Diagnostics.DiagnosticSource.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.DiagnosticSource.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.FileVersionInfo.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Diagnostics.FileVersionInfo.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.FileVersionInfo.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Process.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Diagnostics.Process.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.Process.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.StackTrace.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Diagnostics.StackTrace.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.StackTrace.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.TextWriterTraceListener.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Diagnostics.TextWriterTraceListener.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.TextWriterTraceListener.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Tools.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Diagnostics.Tools.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.Tools.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.TraceSource.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Diagnostics.TraceSource.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.TraceSource.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Diagnostics.Tracing.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Diagnostics.Tracing.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Diagnostics.Tracing.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Drawing.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Drawing.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Drawing.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Drawing.Primitives.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Drawing.Primitives.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Drawing.Primitives.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Dynamic.Runtime.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Dynamic.Runtime.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Dynamic.Runtime.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Formats.Asn1.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Formats.Asn1.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Formats.Asn1.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Globalization.Calendars.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Globalization.Calendars.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Globalization.Calendars.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Globalization.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Globalization.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Globalization.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Globalization.Extensions.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Globalization.Extensions.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Globalization.Extensions.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Compression.Brotli.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.IO.Compression.Brotli.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.Compression.Brotli.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Compression.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.IO.Compression.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.Compression.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Compression.FileSystem.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.IO.Compression.FileSystem.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.Compression.FileSystem.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Compression.ZipFile.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.IO.Compression.ZipFile.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.Compression.ZipFile.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.IO.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.AccessControl.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.IO.FileSystem.AccessControl.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.FileSystem.AccessControl.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.IO.FileSystem.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.FileSystem.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.DriveInfo.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.IO.FileSystem.DriveInfo.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.FileSystem.DriveInfo.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.Primitives.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.IO.FileSystem.Primitives.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.FileSystem.Primitives.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.FileSystem.Watcher.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.IO.FileSystem.Watcher.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.FileSystem.Watcher.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.IsolatedStorage.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.IO.IsolatedStorage.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.IsolatedStorage.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.MemoryMappedFiles.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.IO.MemoryMappedFiles.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.MemoryMappedFiles.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Pipelines.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.IO.Pipelines.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\system.io.pipelines\5.0.0\lib\netcoreapp3.0\System.IO.Pipelines.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Pipes.AccessControl.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.IO.Pipes.AccessControl.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.Pipes.AccessControl.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.Pipes.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.IO.Pipes.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.Pipes.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.IO.UnmanagedMemoryStream.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.IO.UnmanagedMemoryStream.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.IO.UnmanagedMemoryStream.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Linq.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Linq.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Linq.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Linq.Expressions.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Linq.Expressions.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Linq.Expressions.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Linq.Parallel.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Linq.Parallel.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Linq.Parallel.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Linq.Queryable.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Linq.Queryable.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Linq.Queryable.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Memory.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Memory.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Memory.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Http.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.Http.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Http.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Http.Json.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.Http.Json.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Http.Json.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.HttpListener.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.HttpListener.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.HttpListener.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Mail.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.Mail.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Mail.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.NameResolution.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.NameResolution.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.NameResolution.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.NetworkInformation.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.NetworkInformation.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.NetworkInformation.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Ping.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.Ping.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Ping.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Primitives.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.Primitives.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Primitives.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Quic.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.Quic.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Quic.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Requests.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.Requests.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Requests.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Security.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.Security.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Security.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.ServicePoint.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.ServicePoint.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.ServicePoint.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.Sockets.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.Sockets.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.Sockets.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebClient.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.WebClient.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.WebClient.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebHeaderCollection.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.WebHeaderCollection.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.WebHeaderCollection.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebProxy.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.WebProxy.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.WebProxy.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebSockets.Client.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.WebSockets.Client.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.WebSockets.Client.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Net.WebSockets.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Net.WebSockets.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Net.WebSockets.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Numerics.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Numerics.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Numerics.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Numerics.Vectors.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Numerics.Vectors.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Numerics.Vectors.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.ObjectModel.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.ObjectModel.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.ObjectModel.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.CoreLib.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Private.CoreLib.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\native\System.Private.CoreLib.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.DataContractSerialization.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Private.DataContractSerialization.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Private.DataContractSerialization.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.Runtime.InteropServices.JavaScript.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Private.Runtime.InteropServices.JavaScript.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Private.Runtime.InteropServices.JavaScript.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.Uri.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Private.Uri.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Private.Uri.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.Xml.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Private.Xml.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Private.Xml.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Private.Xml.Linq.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Private.Xml.Linq.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Private.Xml.Linq.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.DispatchProxy.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Reflection.DispatchProxy.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.DispatchProxy.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Reflection.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Emit.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Reflection.Emit.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.Emit.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Emit.ILGeneration.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Reflection.Emit.ILGeneration.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.Emit.ILGeneration.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Emit.Lightweight.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_framework/System.Reflection.Emit.Lightweight.dll",
                    ["BasePath"] = "/",
                    ["AssetMode"] = "All",
                    ["AssetKind"] = "Build",
                    ["SourceId"] = "blazorwasm",
                    ["CopyToOutputDirectory"] = "PreserveNewest",
                    ["RelatedAsset"] = @"",
                    ["ContentRoot"] = @"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\",
                    ["SourceType"] = "Computed",
                    ["AssetRole"] = "Primary",
                    ["AssetTraitValue"] = "runtime",
                    ["AssetTraitName"] = "BlazorWebAssemblyResource",
                    ["OriginalItemSpec"] = @"C:\work\dotnet-sdk2\artifacts\.nuget\packages\microsoft.netcore.app.runtime.mono.browser-wasm\6.0.0-preview.7.21324.1\runtimes\browser-wasm\lib\net6.0\System.Reflection.Emit.Lightweight.dll",
                    ["CopyToPublishDirectory"] = "Never",
                }),
                new TaskItem(@"C:\work\dotnet-sdk2\artifacts\tmp\Debug\Publish_Hoste---F07A04C5\blazorwasm\bin\Debug\net6.0\wwwroot\_framework\System.Reflection.Extensions.dll", new Dictionary<string,string>(){
                    ["RelativePath"] = "_fra