/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.model.Instrument;
import com.google.caliper.model.Measurement;
import com.google.caliper.model.Result;
import com.google.caliper.model.Run;
import com.google.caliper.model.Scenario;
import com.google.caliper.model.VM;
import com.google.caliper.runner.ResultProcessor;
import com.google.caliper.util.LinearTranslation;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Table;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

final class ConsoleResultProcessor
implements ResultProcessor {
    private static final int maxParamWidth = 30;
    private static final int barGraphWidth = 30;
    private static final int UNITS_FOR_SCORE_100 = 1;
    private static final int UNITS_FOR_SCORE_10 = 1000000000;
    private static final LinearTranslation scoreTranslation = new LinearTranslation(Math.log(1.0E9), 10.0, Math.log(1.0), 100.0);
    private final boolean printScore;
    private Run run;
    private Table<ScenarioName, AxisName, AxisValue> scenarioLocalVars;
    private Map<ScenarioName, ProcessedResult> processedResults;
    private List<Axis> sortedAxes;
    private ImmutableSortedSet<ScenarioName> sortedScenarioNames;
    private double minValue;
    private double maxValue;
    private static final Function<VM, String> VM_LOCAL_NAME_FUNCTION = new Function<VM, String>(){

        public String apply(VM vm) {
            return vm.localName;
        }
    };

    ConsoleResultProcessor(boolean printScore) {
        this.printScore = printScore;
    }

    @Override
    public void handleResults(Run run) {
        this.run = run;
        ImmutableMap vms = Maps.uniqueIndex(run.vms, VM_LOCAL_NAME_FUNCTION);
        this.scenarioLocalVars = HashBasedTable.create();
        for (Scenario scenario : run.scenarios) {
            ScenarioName scenarioName = new ScenarioName(scenario.localName);
            this.scenarioLocalVars.put((Object)scenarioName, (Object)new AxisName("benchmark"), (Object)new AxisValue(scenario.benchmarkMethodName));
            this.scenarioLocalVars.put((Object)scenarioName, (Object)new AxisName("vm"), (Object)new AxisValue(((VM)vms.get((Object)scenario.vmLocalName)).vmName));
            for (Map.Entry<String, String> entry : scenario.userParameters.entrySet()) {
                this.scenarioLocalVars.put((Object)scenarioName, (Object)new AxisName(entry.getKey()), (Object)new AxisValue(entry.getValue()));
            }
            for (Map.Entry<String, String> entry : scenario.vmArguments.entrySet()) {
                this.scenarioLocalVars.put((Object)scenarioName, (Object)new AxisName(entry.getKey()), (Object)new AxisValue(entry.getValue()));
            }
        }
        for (Instrument instrument : run.instruments) {
            this.displayResults(instrument);
        }
    }

    private void displayResults(Instrument instrument) {
        System.out.printf("Results for %s:%n", instrument.className);
        this.processedResults = Maps.newHashMap();
        for (Result result : this.run.results) {
            ScenarioName scenarioLocalName = new ScenarioName(result.scenarioLocalName);
            if (!instrument.localName.equals(result.instrumentLocalName)) continue;
            ProcessedResult existingResult = this.processedResults.get(scenarioLocalName);
            if (existingResult == null) {
                this.processedResults.put(scenarioLocalName, new ProcessedResult(result));
                continue;
            }
            this.processedResults.put(scenarioLocalName, this.combineResults(existingResult, result));
        }
        double minOfMedians = Double.POSITIVE_INFINITY;
        double maxOfMedians = Double.NEGATIVE_INFINITY;
        for (ProcessedResult result : this.processedResults.values()) {
            minOfMedians = Math.min(minOfMedians, result.median);
            maxOfMedians = Math.max(maxOfMedians, result.median);
        }
        LinkedHashMultimap axisValues = LinkedHashMultimap.create();
        for (Scenario scenario : this.run.scenarios) {
            ScenarioName scenarioName = new ScenarioName(scenario.localName);
            if (!this.processedResults.keySet().contains(scenarioName)) continue;
            for (Map.Entry entry : this.scenarioLocalVars.row((Object)scenarioName).entrySet()) {
                axisValues.put(entry.getKey(), entry.getValue());
            }
        }
        ArrayList axes = Lists.newArrayList();
        for (Map.Entry entry : axisValues.asMap().entrySet()) {
            Axis axis = new Axis((AxisName)entry.getKey(), (Collection)entry.getValue());
            axes.add(axis);
        }
        double sumOfAllMeasurements = 0.0;
        for (ProcessedResult processedResult : this.processedResults.values()) {
            sumOfAllMeasurements += processedResult.median;
        }
        for (Axis axis : axes) {
            int numValues = axis.numberOfValues();
            double[] sumForValue = new double[numValues];
            for (Map.Entry<ScenarioName, ProcessedResult> entry : this.processedResults.entrySet()) {
                ScenarioName scenarioLocalName = entry.getKey();
                ProcessedResult result = entry.getValue();
                int n = axis.index(scenarioLocalName);
                sumForValue[n] = sumForValue[n] + result.median;
            }
            double mean = sumOfAllMeasurements / (double)sumForValue.length;
            double variance = 0.0;
            for (double value : sumForValue) {
                double distance = value - mean;
                variance += distance * distance;
            }
            axis.variance = variance / (double)numValues;
        }
        this.sortedAxes = new VarianceOrdering().reverse().sortedCopy((Iterable)axes);
        this.sortedScenarioNames = ImmutableSortedSet.copyOf((Comparator)((Object)new ByAxisOrdering()), this.processedResults.keySet());
        this.maxValue = maxOfMedians;
        this.minValue = minOfMedians;
        this.displayResults();
    }

    private ProcessedResult combineResults(ProcessedResult r1, Result r2) {
        Preconditions.checkArgument((boolean)((ProcessedResult)r1).modelResult.instrumentLocalName.equals(r2.instrumentLocalName));
        Preconditions.checkArgument((boolean)((ProcessedResult)r1).modelResult.scenarioLocalName.equals(r2.scenarioLocalName));
        r2.measurements = ImmutableList.builder().addAll(((ProcessedResult)r1).modelResult.measurements).addAll(r2.measurements).build();
        return new ProcessedResult(r2);
    }

    void displayResults() {
        this.printValues();
        System.out.println();
        this.printSingletonAxes();
        this.printCharCounts();
    }

    private void printCharCounts() {
    }

    private void printValues() {
        for (Axis axis : this.sortedAxes) {
            if (axis.isSingleton()) continue;
            System.out.printf("%" + Math.min(axis.maxLength, 30) + "s ", axis.name);
        }
        boolean showGraphs = this.sortedScenarioNames.size() > 1;
        ProcessedResult firstResult = this.processedResults.values().iterator().next();
        String responseUnit = firstResult.responseUnit;
        String responseDesc = firstResult.responseDesc;
        int measurementLength = Math.max(10, responseUnit.length());
        System.out.printf("%" + measurementLength + "s", responseUnit);
        if (showGraphs) {
            System.out.print(" " + responseDesc);
        }
        System.out.println();
        double sumOfLogs = 0.0;
        String measurementPattern = "%" + measurementLength + ".3f";
        for (ScenarioName scenarioLocalName : this.sortedScenarioNames) {
            ProcessedResult result = this.processedResults.get(scenarioLocalName);
            for (Axis axis : this.sortedAxes) {
                if (axis.isSingleton()) continue;
                System.out.printf("%" + axis.maxLength + "s ", ConsoleResultProcessor.truncate(axis.get(scenarioLocalName).toString(), axis.maxLength));
            }
            sumOfLogs += Math.log(result.median);
            System.out.printf(measurementPattern, result.median);
            if (showGraphs) {
                System.out.printf(" %s", this.barGraph(result.median));
            }
            System.out.println();
        }
        if (this.printScore) {
            double meanLogUnits = sumOfLogs / (double)this.processedResults.size();
            System.out.format("%nScore: %.3f%n", scoreTranslation.translate(meanLogUnits));
        }
    }

    private void printSingletonAxes() {
        for (Axis axis : this.sortedAxes) {
            if (!axis.isSingleton()) continue;
            System.out.println(axis.name + ": " + Iterables.getOnlyElement(axis.values));
        }
    }

    private String barGraph(double value) {
        if (this.minValue >= 0.0) {
            int graphLength = ConsoleResultProcessor.floor(value / this.maxValue * 30.0);
            graphLength = Math.max(1, graphLength);
            graphLength = Math.min(30, graphLength);
            return Strings.repeat((String)"=", (int)graphLength);
        }
        int zeroIndex = ConsoleResultProcessor.floor(-this.minValue * 30.0 / (this.maxValue - this.minValue));
        if (value < 0.0) {
            int barLength = ConsoleResultProcessor.ceil(value / this.minValue * (double)zeroIndex);
            return Strings.repeat((String)" ", (int)(zeroIndex - barLength)) + Strings.repeat((String)"=", (int)barLength) + "0";
        }
        int barLength = ConsoleResultProcessor.floor(value / this.maxValue * (double)(30 - zeroIndex));
        return Strings.repeat((String)" ", (int)zeroIndex) + "0" + Strings.repeat((String)"=", (int)barLength);
    }

    private static int floor(double d) {
        return (int)Math.floor(d);
    }

    private static int ceil(double d) {
        return (int)Math.ceil(d);
    }

    private static String truncate(String s, int maxLength) {
        if (s.length() <= maxLength) {
            return s;
        }
        return s.substring(0, maxLength - 1) + "+";
    }

    private static class AxisValue {
        private final String value;

        public AxisValue(String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value);
        }

        public String toString() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof AxisValue) {
                AxisValue that = (AxisValue)other;
                return this.value.equals(that.value);
            }
            return false;
        }
    }

    private static class AxisName {
        private final String name;

        public AxisName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof AxisName) {
                AxisName that = (AxisName)other;
                return this.name.equals(that.name);
            }
            return false;
        }
    }

    private static class ScenarioName {
        private final String name;

        public ScenarioName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof ScenarioName) {
                ScenarioName that = (ScenarioName)other;
                return this.name.equals(that.name);
            }
            return false;
        }
    }

    private static class ProcessedResult {
        private final Result modelResult;
        private final double[] values;
        private final double min;
        private final double max;
        private final double median;
        private final double mean;
        private final String responseUnit;
        private final String responseDesc;

        private ProcessedResult(Result modelResult) {
            this.modelResult = modelResult;
            this.values = ProcessedResult.getValues(modelResult.measurements);
            this.min = Doubles.min((double[])this.values);
            this.max = Doubles.max((double[])this.values);
            this.median = ProcessedResult.computeMedian(this.values);
            this.mean = ProcessedResult.computeMean(this.values);
            Measurement firstMeasurement = modelResult.measurements.get(0);
            this.responseUnit = firstMeasurement.unit;
            this.responseDesc = firstMeasurement.description;
        }

        private static double[] getValues(Collection<Measurement> measurements) {
            double[] values = new double[measurements.size()];
            int i = 0;
            for (Measurement measurement : measurements) {
                values[i] = measurement.value / measurement.weight;
                ++i;
            }
            return values;
        }

        private static double computeMedian(double[] values) {
            double[] sortedValues = (double[])values.clone();
            Arrays.sort(sortedValues);
            if (sortedValues.length % 2 == 1) {
                return sortedValues[sortedValues.length / 2];
            }
            double high = sortedValues[sortedValues.length / 2];
            double low = sortedValues[sortedValues.length / 2 - 1];
            return (low + high) / 2.0;
        }

        private static double computeMean(double[] values) {
            double sum = 0.0;
            for (double value : values) {
                sum += value;
            }
            return sum / (double)values.length;
        }
    }

    private class ByAxisOrdering
    extends Ordering<ScenarioName> {
        private ByAxisOrdering() {
        }

        public int compare(ScenarioName scenarioALocalName, ScenarioName scenarioBLocalName) {
            for (Axis axis : ConsoleResultProcessor.this.sortedAxes) {
                int bValue;
                int aValue = axis.index(scenarioALocalName);
                int diff = aValue - (bValue = axis.index(scenarioBLocalName));
                if (diff == 0) continue;
                return diff;
            }
            return 0;
        }
    }

    private static class VarianceOrdering
    extends Ordering<Axis> {
        private VarianceOrdering() {
        }

        public int compare(Axis a, Axis b) {
            return Double.compare(a.variance, b.variance);
        }
    }

    private class Axis {
        final AxisName name;
        final ImmutableList<AxisValue> values;
        final int maxLength;
        double variance;

        Axis(AxisName name, Collection<AxisValue> values) {
            this.name = name;
            this.values = ImmutableList.copyOf(values);
            Preconditions.checkArgument((!this.values.isEmpty() ? 1 : 0) != 0);
            int maxLen = name.toString().length();
            for (AxisValue value : values) {
                maxLen = Math.max(maxLen, value.toString().length());
            }
            this.maxLength = Math.min(maxLen, 30);
        }

        AxisValue get(ScenarioName scenarioLocalName) {
            return (AxisValue)ConsoleResultProcessor.this.scenarioLocalVars.get((Object)scenarioLocalName, (Object)this.name);
        }

        int index(ScenarioName scenarioLocalName) {
            return this.values.indexOf((Object)this.get(scenarioLocalName));
        }

        int numberOfValues() {
            return this.values.size();
        }

        boolean isSingleton() {
            return this.numberOfValues() == 1;
        }
    }
}

