/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.memory;

import com.google.caliper.memory.Chain;
import com.google.caliper.memory.ObjectExplorer;
import com.google.caliper.memory.ObjectVisitor;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.EnumSet;

public final class ObjectGraphMeasurer {
    public static Footprint measure(Object rootObject) {
        return ObjectGraphMeasurer.measure(rootObject, (Predicate<Object>)Predicates.alwaysTrue());
    }

    public static Footprint measure(Object rootObject, Predicate<Object> objectAcceptor) {
        Preconditions.checkNotNull(objectAcceptor, (Object)"predicate");
        Predicate completePredicate = Predicates.and((Iterable)ImmutableList.of(ObjectExplorer.notEnumFieldsOrClasses, (Object)new ObjectExplorer.AtMostOncePredicate(), (Object)Predicates.compose(objectAcceptor, ObjectExplorer.chainToObject)));
        return ObjectExplorer.exploreObject(rootObject, new ObjectGraphVisitor((Predicate<Chain>)completePredicate), EnumSet.of(ObjectExplorer.Feature.VISIT_PRIMITIVES, ObjectExplorer.Feature.VISIT_NULL));
    }

    private ObjectGraphMeasurer() {
    }

    private static class ObjectGraphVisitor
    implements ObjectVisitor<Footprint> {
        private int objects;
        private int references = -1;
        private final Multiset<Class<?>> primitives = HashMultiset.create();
        private final Predicate<Chain> predicate;

        ObjectGraphVisitor(Predicate<Chain> predicate) {
            this.predicate = predicate;
        }

        @Override
        public ObjectVisitor.Traversal visit(Chain chain) {
            if (chain.isPrimitive()) {
                this.primitives.add(chain.getValueType());
                return ObjectVisitor.Traversal.SKIP;
            }
            ++this.references;
            if (this.predicate.apply((Object)chain) && chain.getValue() != null) {
                ++this.objects;
                return ObjectVisitor.Traversal.EXPLORE;
            }
            return ObjectVisitor.Traversal.SKIP;
        }

        @Override
        public Footprint result() {
            return new Footprint(this.objects, this.references, (Multiset<Class<?>>)ImmutableMultiset.copyOf(this.primitives));
        }
    }

    public static final class Footprint {
        private final int objects;
        private final int references;
        private final ImmutableMultiset<Class<?>> primitives;
        private static final ImmutableSet<Class<?>> primitiveTypes = ImmutableSet.of(Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, (Object[])new Class[]{Long.TYPE, Double.TYPE});

        public Footprint(int objects, int references, Multiset<Class<?>> primitives) {
            Preconditions.checkArgument((objects >= 0 ? 1 : 0) != 0, (Object)"Negative number of objects");
            Preconditions.checkArgument((references >= 0 ? 1 : 0) != 0, (Object)"Negative number of references");
            Preconditions.checkArgument((boolean)primitiveTypes.containsAll((Collection)primitives.elementSet()), (Object)"Unexpected primitive type");
            this.objects = objects;
            this.references = references;
            this.primitives = ImmutableMultiset.copyOf(primitives);
        }

        public int getObjects() {
            return this.objects;
        }

        public int getReferences() {
            return this.references;
        }

        public ImmutableMultiset<Class<?>> getPrimitives() {
            return this.primitives;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getClass().getName(), this.objects, this.references, this.primitives});
        }

        public boolean equals(Object o) {
            if (o instanceof Footprint) {
                Footprint that = (Footprint)o;
                return this.objects == that.objects && this.references == that.references && this.primitives.equals(that.primitives);
            }
            return false;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("Objects", this.objects).add("References", this.references).add("Primitives", this.primitives).toString();
        }
    }
}

